/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0015+\u0001^B\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\tQ\u0002\u0011\t\u0012)A\u00055\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003l\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u000bU\u0004A\u0011\u0001<\t\u000bm\u0004A\u0011\t?\t\rU\u0004A\u0011AA\u0001\u0011\u0019)\b\u0001\"\u0001\u0002\b!1Q\u000f\u0001C\u0001\u0003\u0017A!\"!\u0005\u0001\u0011\u000b\u0007I\u0011AA\n\u0011)\ti\u0003\u0001EC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003\u007f\u0001\u0001R1A\u0005\u0002\u0005\u0005\u0003BCA)\u0001!\u0015\r\u0011\"\u0001\u0002T!9\u0011\u0011\u000f\u0001\u0005B\u0005\u0005\u0003bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002,\u0002!\t%!,\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA]\u0001E\u0005I\u0011AA^\u0011%\t\t\u000eAI\u0001\n\u0003\t\u0019\u000eC\u0005\u0002X\u0002\t\n\u0011\"\u0001\u0002Z\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"!>\u0001\u0003\u0003%\t!a>\t\u0013\u0005u\b!!A\u0005B\u0005}\b\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\u0012)bB\u0005\u0003:)\n\t\u0011#\u0001\u0003<\u0019A\u0011FKA\u0001\u0012\u0003\u0011i\u0004\u0003\u0004vC\u0011\u0005!1\n\u0005\n\u0005\u001b\n\u0013\u0011!C#\u0005\u001fB\u0011B!\u0015\"\u0003\u0003%\tIa\u0015\t\u0013\tm\u0013%%A\u0005\u0002\u0005e\u0007\"\u0003B/C\u0005\u0005I\u0011\u0011B0\u0011%\u0011i'II\u0001\n\u0003\tI\u000eC\u0005\u0003p\u0005\n\t\u0011\"\u0003\u0003r\ti1\u000b\u001e:vGR\u001cHk\u001c&t_:T!a\u000b\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003[9\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\t\u0001abt(\u0012%P+B\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011(P\u0005\u0003})\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tS\u0013aB2pI\u0016<WM\\\u0005\u0003\t\u0006\u0013qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003s\u0019K!a\u0012\u0016\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002J\u0019:\u0011\u0011HS\u0005\u0003\u0017*\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA&+!\t\u00016+D\u0001R\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0015,\n\u0005]\u000b&\u0001D*fe&\fG.\u001b>bE2,\u0017aB8qi&|gn]\u000b\u00025B!1LY3f\u001d\ta\u0006\r\u0005\u0002^#6\taL\u0003\u0002`m\u00051AH]8pizJ!!Y)\u0002\rA\u0013X\rZ3g\u0013\t\u0019GMA\u0002NCBT!!Y)\u0011\u0005m3\u0017BA4e\u0005\u0019\u0019FO]5oO\u0006Aq\u000e\u001d;j_:\u001c\b%A\u0003dQ&dG-F\u0001l!\tID.\u0003\u0002nU\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002cB\u0019\u0001K]3\n\u0005M\f&AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003xqfT\bCA\u001d\u0001\u0011\u0015Av\u00011\u0001[\u0011\u0015Iw\u00011\u0001l\u0011\u001dyw\u0001%AA\u0002E\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002{B\u0011\u0001K`\u0005\u0003\u007fF\u0013qAQ8pY\u0016\fg\u000eF\u0003x\u0003\u0007\t)\u0001C\u0003Y\u0013\u0001\u0007!\fC\u0003j\u0013\u0001\u00071\u000eF\u0002x\u0003\u0013AQ!\u001b\u0006A\u0002-$Ra^A\u0007\u0003\u001fAQ![\u0006A\u0002-DQ\u0001W\u0006A\u0002-\faa\u001e:ji\u0016\u0014XCAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t!![8\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u001a\ty1\t[1s\u0003J\u0014\u0018-_,sSR,'\u000fK\u0002\r\u0003O\u00012\u0001UA\u0015\u0013\r\tY#\u0015\u0002\niJ\fgn]5f]R\f1aZ3o+\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004L\u0001\u0005UN|g.\u0003\u0003\u0002<\u0005U\"\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8sQ\ri\u0011qE\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017-\u0006\u0002\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J9\nQ\u0001^=qKNLA!!\u0014\u0002H\tAA)\u0019;b)f\u0004X\rK\u0002\u000f\u0003O\t\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005U\u0003c\u0002)\u0002X\u0005m\u0013\u0011M\u0005\u0004\u00033\n&!\u0003$v]\u000e$\u0018n\u001c82!\r\u0001\u0016QL\u0005\u0004\u0003?\n&aA!osB!\u00111MA6\u001b\t\t)G\u0003\u0003\u0002J\u0005\u001d$bAA5a\u00051QO\\:bM\u0016LA!!\u001c\u0002f\tQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007=\t9#\u0001\u0005eCR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bL\u0001\tC:\fG._:jg&!\u0011\u0011QA>\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001D<ji\"$\u0016.\\3[_:,Gc\u0001\u001f\u0002\b\")qN\u0005a\u0001K\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u00111LAG\u0011\u001d\tyi\u0005a\u0001\u00037\nQA^1mk\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t)\n\u0005\u0004\u0002\u0018\u0006}\u0015Q\u0015\b\u0005\u00033\u000biJD\u0002^\u00037K\u0011AU\u0005\u0003\u0017FKA!!)\u0002$\n\u00191+Z9\u000b\u0005-\u000b\u0006\u0003BA#\u0003OKA!!+\u0002H\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A3\u0002\t\r|\u0007/\u001f\u000b\bo\u0006M\u0016QWA\\\u0011\u001dAf\u0003%AA\u0002iCq!\u001b\f\u0011\u0002\u0003\u00071\u000eC\u0004p-A\u0005\t\u0019A9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0018\u0016\u00045\u0006}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0017+\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001b\u0016\u0004W\u0006}\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00037T3!]A`\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]A\u000f\u0003\u0011a\u0017M\\4\n\u0007\u001d\f)/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002pB\u0019\u0001+!=\n\u0007\u0005M\u0018KA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\\\u0005e\b\"CA~9\u0005\u0005\t\u0019AAx\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0001\t\u0007\u0005\u0007\u0011I!a\u0017\u000e\u0005\t\u0015!b\u0001B\u0004#\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-!Q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002~\u0005#A\u0011\"a?\u001f\u0003\u0003\u0005\r!a\u0017\u0002\r\u0015\fX/\u00197t)\ri(q\u0003\u0005\n\u0003w|\u0012\u0011!a\u0001\u00037B3\u0003\u0001B\u000e\u0005C\u0011\u0019Ca\n\u0003*\t5\"q\u0006B\u001a\u0005k\u00012!\u000fB\u000f\u0013\r\u0011yB\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011)#A%`\rVs5i\u0018\u0015fqB\u00148\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI1!\u0015N{e\nI:ue&tw\rI<ji\"\u0004\u0013\rI4jm\u0016t\u0007e\u001d;sk\u000e$\bE^1mk\u0016\f\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005W\tAq\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(C\u001eb\u0003%\r\u0017!O\t<C\u0006\t\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;euT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\1nK\u0012|6\u000f\u001e:vGRDs\u0005^5nK\u001eb\u0003\u0005^8`i&lWm\u001d;b[BDsE\r\u00192k5\u0002\u0004(\f\u001a7O1\u0002s%_=zs6jU*\f3eO%JC\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$E\r\u001c0aaz#\u0007M\u00196EuT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDc.Y7fI~\u001bHO];di\":\u0013m\n\u0017!c1\u0002sEY\u0014-AIJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u001a~;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)O\u0005<C\u0006\t8b[\u0016$wl\u001d;sk\u000e$\bf\n2(Y\u0001\n\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e|E\t\u0014#(M?~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013'\u000b\u0017oC6,GmX:ueV\u001cG\u000fK\u0014cO1\u0002#'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(eW\u0019^EiZ(E\u0019\u0012;eul(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\":\u0013m\n\u0017!c%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014' \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015)[\u0006\u0004\bfJ1(Y\u0001\n\u0014&K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEjXL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\t$\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#Aa\u000e\u0002\u000bIr#G\f\u0019\u0002\u001bM#(/^2ugR{'j]8o!\tI\u0014e\u0005\u0003\"\u0005\u007f)\u0006\u0003\u0003B!\u0005\u000fR6.]<\u000e\u0005\t\r#b\u0001B##\u00069!/\u001e8uS6,\u0017\u0002\u0002B%\u0005\u0007\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011Y$\u0001\u0005u_N#(/\u001b8h)\t\t\t/A\u0003baBd\u0017\u0010F\u0004x\u0005+\u00129F!\u0017\t\u000ba#\u0003\u0019\u0001.\t\u000b%$\u0003\u0019A6\t\u000f=$\u0003\u0013!a\u0001c\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005$\u0011\u000e\t\u0005!J\u0014\u0019\u0007\u0005\u0004Q\u0005KR6.]\u0005\u0004\u0005O\n&A\u0002+va2,7\u0007\u0003\u0005\u0003l\u0019\n\t\u00111\u0001x\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005g\u0002B!a9\u0003v%!!qOAs\u0005\u0019y%M[3di\u0002")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson structsToJson) {
        return StructsToJson$.MODULE$.unapply(structsToJson);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), mapType);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

