/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.examples.SparkLR;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class SparkLR$ {
    public static SparkLR$ MODULE$;
    private final int N;
    private final int D;
    private final double R;
    private final int ITERATIONS;
    private final Random rand;

    static {
        new SparkLR$();
    }

    public int N() {
        return this.N;
    }

    public int D() {
        return this.D;
    }

    public double R() {
        return this.R;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public Random rand() {
        return this.rand;
    }

    public SparkLR.DataPoint[] generateData() {
        return (SparkLR.DataPoint[])Array$.MODULE$.tabulate(this.N(), (Function1 & Serializable & scala.Serializable)i -> this.generatePoint$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(SparkLR.DataPoint.class));
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of Logistic Regression and is given as an example!\n        |Please use org.apache.spark.ml.classification.LogisticRegression\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkLR").getOrCreate();
        int numSlices = args.length > 0 ? new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt() : 2;
        RDD points = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.generateData()), numSlices, ClassTag$.MODULE$.apply(SparkLR.DataPoint.class)).cache();
        DenseVector w = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> (double)2 * MODULE$.rand().nextDouble() - 1.0, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Initial w: ").append(w).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach((Function1 & Serializable & scala.Serializable)i -> SparkLR$.$anonfun$main$2(points, w, BoxesRunTime.unboxToInt((Object)i)));
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("Final w: ").append(w).toString());
        spark.stop();
    }

    private final SparkLR.DataPoint generatePoint$1(int i) {
        int y = i % 2 == 0 ? -1 : 1;
        DenseVector x = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> MODULE$.rand().nextGaussian() + (double)y * MODULE$.R(), ClassTag$.MODULE$.Double());
        return new SparkLR.DataPoint((Vector<Object>)x, y);
    }

    public static final /* synthetic */ DenseVector $anonfun$main$2(RDD points$1, DenseVector w$1, int i) {
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("On iteration ").append(i).toString());
        Vector gradient = (Vector)points$1.map((Function1 & Serializable & scala.Serializable)p -> (Vector)((ImmutableNumericOps)p.x().$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (1.0 + package$.MODULE$.exp(-p.y() * BoxesRunTime.unboxToDouble((Object)w$1.dot(p.x(), DenseVector$.MODULE$.canDot_DV_V_Double())))) - 1.0)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$times((Object)BoxesRunTime.boxToDouble((double)p.y()), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), ClassTag$.MODULE$.apply(Vector.class)).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> (Vector)x$1.$plus(x$2, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()));
        return (DenseVector)w$1.$minus$eq((Object)gradient, (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpSub());
    }

    private SparkLR$() {
        MODULE$ = this;
        this.N = 10000;
        this.D = 10;
        this.R = 0.7;
        this.ITERATIONS = 5;
        this.rand = new Random(42L);
    }
}

