/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.graphx;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.GraphLoader$;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.PartitionStrategy$;
import org.apache.spark.graphx.PartitionStrategy$RandomVertexCut$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.sys.package$;

public final class Analytics$ {
    public static Analytics$ MODULE$;

    static {
        new Analytics$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            String usage = new StringOps(Predef$.MODULE$.augmentString("Usage: Analytics <taskType> <file> --numEPart=<num_edge_partitions>\n      |[other options] Supported 'taskType' as follows:\n      |pagerank    Compute PageRank\n      |cc          Compute the connected components of vertices\n      |triangles   Count the number of triangles")).stripMargin();
            System.err.println(usage);
            System.exit(1);
        }
        String taskType = args[0];
        String fname = args[1];
        Tuple2[] optionsList = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).drop(2))).map((Function1 & Serializable & scala.Serializable)arg -> {
            String[] stringArray = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(arg)).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Analytics$.$anonfun$main$2(BoxesRunTime.unboxToChar((Object)x$1)))))).split('=');
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new IllegalArgumentException(new StringBuilder(18).append("Invalid argument: ").append((String)arg).toString());
            }
            String opt = (String)((SeqLike)option.get()).apply(0);
            String v = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opt), (Object)v);
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Map options = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionsList));
        SparkConf conf = new SparkConf();
        GraphXUtils$.MODULE$.registerKryoClasses(conf);
        int numEPart = BoxesRunTime.unboxToInt((Object)options.remove((Object)"numEPart").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Analytics$.$anonfun$main$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)"Set the number of edge partitions using --numEPart.");
            return package$.MODULE$.exit(1);
        }));
        Option partitionStrategy = options.remove((Object)"partStrategy").map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStrategy$.MODULE$.fromString(x$3));
        StorageLevel edgeStorageLevel = (StorageLevel)options.remove((Object)"edgeStorageLevel").map((Function1 & Serializable & scala.Serializable)x$4 -> StorageLevel$.MODULE$.fromString(x$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> StorageLevel$.MODULE$.MEMORY_ONLY());
        StorageLevel vertexStorageLevel = (StorageLevel)options.remove((Object)"vertexStorageLevel").map((Function1 & Serializable & scala.Serializable)x$5 -> StorageLevel$.MODULE$.fromString(x$5)).getOrElse((Function0 & Serializable & scala.Serializable)() -> StorageLevel$.MODULE$.MEMORY_ONLY());
        String string = taskType;
        if ("pagerank".equals(string)) {
            Graph graph;
            SparkContext sc;
            float tol = BoxesRunTime.unboxToFloat((Object)options.remove((Object)"tol").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToFloat((float)Analytics$.$anonfun$main$10(x$6))).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.001f));
            String outFname = (String)options.remove((Object)"output").getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Option numIterOpt = options.remove((Object)"numIter").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Analytics$.$anonfun$main$13(x$7)));
            options.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String opt = (String)tuple2._1();
                    throw new IllegalArgumentException(new StringBuilder(16).append("Invalid option: ").append(opt).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|             PageRank               |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext x$1 = sc = new SparkContext(conf.setAppName(new StringBuilder(10).append("PageRank(").append(fname).append(")").toString()));
            String x$22 = fname;
            int x$32 = numEPart;
            StorageLevel x$42 = edgeStorageLevel;
            StorageLevel x$52 = vertexStorageLevel;
            boolean x$62 = GraphLoader$.MODULE$.edgeListFile$default$3();
            Graph unpartitionedGraph = GraphLoader$.MODULE$.edgeListFile(x$1, x$22, x$62, x$32, x$42, x$52).cache();
            Graph graph2 = (Graph)Option$.MODULE$.option2Iterable(partitionStrategy).foldLeft((Object)unpartitionedGraph, (Function2 & Serializable & scala.Serializable)(x$8, x$9) -> x$8.partitionBy(x$9));
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("GRAPHX: Number of vertices ").append(graph2.vertices().count()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("GRAPHX: Number of edges ").append(graph2.edges().count()).toString());
            Option option = numIterOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                int numIter = BoxesRunTime.unboxToInt((Object)some.value());
                graph = PageRank$.MODULE$.run(graph2, numIter, PageRank$.MODULE$.run$default$3(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            } else if (None$.MODULE$.equals(option)) {
                graph = PageRank$.MODULE$.runUntilConvergence(graph2, (double)tol, PageRank$.MODULE$.runUntilConvergence$default$3(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            } else {
                throw new MatchError((Object)option);
            }
            VertexRDD pr = (VertexRDD)graph.vertices().cache();
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("GRAPHX: Total rank: ").append(pr.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10._2$mcD$sp()), ClassTag$.MODULE$.Double()).reduce((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$11, x$12) -> x$11 + x$12)).toString());
            if (!outFname.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder(29).append("Saving pageranks of pages to ").append(outFname).toString());
                pr.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    long id = tuple2._1$mcJ$sp();
                    double r = tuple2._2$mcD$sp();
                    String string = new StringBuilder(1).append(id).append("\t").append(r).toString();
                    return string;
                }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outFname);
            }
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("cc".equals(string)) {
            SparkContext sc;
            options.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String opt = (String)tuple2._1();
                    throw new IllegalArgumentException(new StringBuilder(16).append("Invalid option: ").append(opt).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|      Connected Components          |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext x$72 = sc = new SparkContext(conf.setAppName(new StringBuilder(21).append("ConnectedComponents(").append(fname).append(")").toString()));
            String x$82 = fname;
            int x$92 = numEPart;
            StorageLevel x$102 = edgeStorageLevel;
            StorageLevel x$112 = vertexStorageLevel;
            boolean x$122 = GraphLoader$.MODULE$.edgeListFile$default$3();
            Graph unpartitionedGraph = GraphLoader$.MODULE$.edgeListFile(x$72, x$82, x$122, x$92, x$102, x$112).cache();
            Graph graph = (Graph)Option$.MODULE$.option2Iterable(partitionStrategy).foldLeft((Object)unpartitionedGraph, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> x$13.partitionBy(x$14));
            Graph cc = ConnectedComponents$.MODULE$.run(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Components: ").append(cc.vertices().map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToLong((long)Analytics$.$anonfun$main$21(x0$4)), ClassTag$.MODULE$.apply(Long.TYPE)).distinct()).toString());
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("triangles".equals(string)) {
            options.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    String opt = (String)tuple2._1();
                    throw new IllegalArgumentException(new StringBuilder(16).append("Invalid option: ").append(opt).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|      Triangle Count                |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext sc = new SparkContext(conf.setAppName(new StringBuilder(15).append("TriangleCount(").append(fname).append(")").toString()));
            Graph graph = GraphLoader$.MODULE$.edgeListFile(sc, fname, true, numEPart, edgeStorageLevel, vertexStorageLevel).partitionBy((PartitionStrategy)partitionStrategy.getOrElse((Function0 & Serializable & scala.Serializable)() -> PartitionStrategy$RandomVertexCut$.MODULE$)).cache();
            Graph triangles = TriangleCount$.MODULE$.run(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            long triangleTypes = BoxesRunTime.unboxToLong((Object)triangles.vertices().map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToLong((long)Analytics$.$anonfun$main$24(x0$6)), ClassTag$.MODULE$.Long()).reduce((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$15, x$16) -> x$15 + x$16)) / 3L;
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("Triangles: ").append(triangleTypes).toString());
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)"Invalid task type.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$2(char x$1) {
        return x$1 == '-';
    }

    public static final /* synthetic */ int $anonfun$main$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ float $anonfun$main$10(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toFloat();
    }

    public static final /* synthetic */ int $anonfun$main$13(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public static final /* synthetic */ long $anonfun$main$21(Tuple2 x0$4) {
        long data;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = data = tuple2._2$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ long $anonfun$main$24(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int data = tuple2._2$mcI$sp();
        long l = data;
        return l;
    }

    private Analytics$() {
        MODULE$ = this;
    }
}

