/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.DefaultArchitecture;

public class Architectures {
    public static final KnownArchitecture X86 = new KnownArchitecture("x86", "i386", "ia-32", "i686");
    public static final KnownArchitecture X86_64 = new KnownArchitecture("x86-64", "x86_64", "amd64", "x64");
    public static final KnownArchitecture IA_64 = new KnownArchitecture("ia-64", "ia64");
    public static final KnownArchitecture ARM_V7 = new KnownArchitecture("arm-v7", "armv7", "arm", "arm32");
    public static final KnownArchitecture AARCH64 = new KnownArchitecture("aarch64", "arm-v8", "arm64");
    private static final List<KnownArchitecture> KNOWN_ARCHITECTURES = Arrays.asList(X86, X86_64, IA_64, ARM_V7, AARCH64, new KnownArchitecture("ppc", new String[0]), new KnownArchitecture("ppc64", new String[0]), new KnownArchitecture("sparc-v8", "sparc", "sparc32"), new KnownArchitecture("sparc-v9", "sparc64", "ultrasparc"));

    public static ArchitectureInternal forInput(String input) {
        for (KnownArchitecture knownArchitecture : KNOWN_ARCHITECTURES) {
            if (!knownArchitecture.isAlias(input.toLowerCase(Locale.ROOT))) continue;
            return new DefaultArchitecture(knownArchitecture.getCanonicalName());
        }
        return new DefaultArchitecture(input);
    }

    public static ArchitectureInternal of(KnownArchitecture architecture) {
        return new DefaultArchitecture(architecture.canonicalName);
    }

    public static class KnownArchitecture {
        private final String canonicalName;
        private final List<String> aliases;

        public KnownArchitecture(String canonicalName, String ... aliases) {
            this.canonicalName = canonicalName;
            this.aliases = Arrays.asList(aliases);
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public boolean isAlias(String input) {
            return this.canonicalName.equals(input) || this.aliases.contains(input);
        }
    }
}

