/*
 *   mwmcntnd.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwcontnd.h>           /* contention manager calls*/


#define MWM_NOTREQD             0
#define MWM_MUSTHAVE            1


ULONG   APIENTRY mwmCntndRMClientProc(DWORD  dwConversationId,
                                      USHORT wMessage,
                                      ULONG  lParam,
                                      USHORT wSize,
                                      void FAR *pBuffer);
ULONG          mwmCntndLoadComplete(PMWM_DSPINFO pmwmDspInfo, int OK_flag);
ULONG mwmCntndContend(PMWM_DSPINFO pmwmDspInfo, ULONG ulRC);
ULONG mwmCntndAllocSegment(PMWM_DSPINFO pmwmDspInfo,
                           HMTASK hTask,
                           char  *pszInstanceName,
                           ULONG ulSize,
                           ULONG ulAlign,
                           ULONG ulDSPAddr,
                           PHSEG phSeg);
ULONG mwmCntndSetUART(PMWM_DSPINFO pmwmDspInfo, LONG Value, USHORT usMustHave,
                      PUSHORT pusFailed, char *achFile, SHORT sLine);
ULONG mwmCntndChangeCPF(PMWM_DSPINFO pmwmDspInfo,
                        HMTASK   hTask,
                        LONG   lCPFDelta ,
                        USHORT  usMustHave);

ULONG mwmCntndLoadModule(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                         char *pszInstanceName, HMOD *phmod, char *achFile, SHORT sLine);

ULONG mwmCntndLoadModuleOptional(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                                 char *pszInstanceName, HMOD *phmod, char *achFile,
                                 SHORT sLine, USHORT usMustHave);

ULONG mwmCntndLoadTask(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                       char *pszTaskName,         char *pszInstanceName,
                       HMOD hmod,                 HMTASK *phTask,
                       char *achFile, SHORT sLine);

ULONG mwmCntndLoadSegment(PMWM_DSPINFO pmwmDspInfo,
                          char *pszINIEntry,
                          char *pszSegmentName,
                          char *pszInstanceName,
                          HMTASK hTask,
                          PHSEG phSeg,
                          ULONG ulDSPAddr,
                          char *achFile, SHORT sLine, USHORT usMustHave);
RC mwmCntndConnectGPC(HMTASK hOwnerTask, PSZ  pszOwner,
                      HMTASK hUserTask, PSZ  pszUser,
                      USHORT usProtocol, PULONG pulDSPAddr,
                      PMWM_DSPINFO pmwmDspInfo,
                      char *achFile, SHORT sLine);

RC mwmCntndMEIOConnect(HCONNECTION FAR *pConnection, ULONG OwnerPort,
                       ULONG UserPort, ULONG SharingOptions,
                       ULONG ulState, ULONG Reserved,
                       PMWM_DSPINFO pmwmDspInfo,
                       ULONG errRC,
                       char *achFile, SHORT sLine);

