# %Cantera C++ Reference

Use the sidebar to view detailed documentation of the C++ code, or use the following
shortcuts:

* Overview of [**Cantera C++ Modules**](modules.html)
* Index of [**Cantera C++ Classes**](classes.html)

A **topical overview** is provided as follows:

* @ref solnGroup (interface to %Cantera core objects)
* @ref thermoprops (temperature, pressure, energy, ...)
* @ref chemkinetics (reactions, rates of progress, reaction path analysis, ...)
* @ref tranprops (diffusion, viscosity, thermal conductivity, ...)
* @ref zerodGroup (reactors, walls, flow devices, ...)
* @ref onedGroup (flames, flow domains, boundaries, ...)
* @ref physConstants (universal constants, built into %Cantera for convenience)

@cond CLIB_GENERATED
Generated C Interface (CLib):

* Overview of @subpage CAPImain
* Index of @ref CAPIindex

@endcond

Details on the fundamental scientific theories used in the implementation of %Cantera
are located in the
[Science Reference Section](../reference/index.html#science-reference).

The %Cantera source code is hosted on [GitHub](https://github.com/Cantera/cantera).
