/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.nlogo.hubnet.mirroring.AgentPerspective;
import org.nlogo.hubnet.mirroring.LinkData;
import org.nlogo.hubnet.mirroring.PatchData;
import org.nlogo.hubnet.mirroring.TurtleData;

public strictfp class DiffBuffer {
    public static final short EMPTY = 0;
    public static final short MINX = 1;
    public static final short MINY = 2;
    public static final short SHAPES = 4;
    public static final short FONT_SIZE = 8;
    public static final short MAXX = 16;
    public static final short MAXY = 32;
    public static final short TURTLES = 64;
    public static final short PATCHES = 128;
    public static final short LINKS = 256;
    public static final short DRAWING = 512;
    public static final short WRAPX = 1024;
    public static final short WRAPY = 2048;
    public static final short PERSPECTIVE = 4096;
    public static final short EVERYTHING = 7679;
    private short mask = 0;
    private int minPxcor;
    private int minPycor;
    private int maxPxcor;
    private int maxPycor;
    private int fontSize;
    private boolean xWrap;
    private boolean yWrap;
    private boolean shapes;
    private AgentPerspective perspective;
    private BufferedImage drawing;
    private final List<PatchData> patchDiffs = new ArrayList<PatchData>();
    private final List<TurtleData> turtleDiffs = new ArrayList<TurtleData>();
    private final List<LinkData> linkDiffs = new ArrayList<LinkData>();

    public boolean isEmpty() {
        return this.mask == 0;
    }

    void addMinX(int minPxcor) {
        this.mask = (short)(this.mask | 1);
        this.minPxcor = minPxcor;
    }

    void addMinY(int minPycor) {
        this.mask = (short)(this.mask | 2);
        this.minPycor = minPycor;
    }

    void addMaxX(int maxPxcor) {
        this.mask = (short)(this.mask | 0x10);
        this.maxPxcor = maxPxcor;
    }

    void addMaxY(int maxPycor) {
        this.mask = (short)(this.mask | 0x20);
        this.maxPycor = maxPycor;
    }

    void addWrapX(boolean xWrap) {
        this.mask = (short)(this.mask | 0x400);
        this.xWrap = xWrap;
    }

    void addWrapY(boolean yWrap) {
        this.mask = (short)(this.mask | 0x800);
        this.yWrap = yWrap;
    }

    void addShapes(boolean shapes) {
        this.mask = (short)(this.mask | 4);
        this.shapes = shapes;
    }

    void addFontSize(int fontSize) {
        this.mask = (short)(this.mask | 8);
        this.fontSize = fontSize;
    }

    void addTurtle(TurtleData diffs) {
        this.mask = (short)(this.mask | 0x40);
        this.turtleDiffs.add(diffs);
    }

    void addLink(LinkData diffs) {
        this.mask = (short)(this.mask | 0x100);
        this.linkDiffs.add(diffs);
    }

    void addPatch(PatchData diffs) {
        this.mask = (short)(this.mask | 0x80);
        this.patchDiffs.add(diffs);
    }

    void addDrawing(BufferedImage drawing) {
        this.mask = (short)(this.mask | 0x200);
        this.drawing = drawing;
    }

    void addPerspective(AgentPerspective perspective) {
        this.mask = (short)(this.mask | 0x1000);
        this.perspective = perspective;
    }

    public void serialize(DataOutputStream os) throws IOException {
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeInt(this.minPxcor);
        }
        if ((this.mask & 2) == 2) {
            os.writeInt(this.minPycor);
        }
        if ((this.mask & 0x10) == 16) {
            os.writeInt(this.maxPxcor);
        }
        if ((this.mask & 0x20) == 32) {
            os.writeInt(this.maxPycor);
        }
        if ((this.mask & 4) == 4) {
            os.writeBoolean(this.shapes);
        }
        if ((this.mask & 8) == 8) {
            os.writeInt(this.fontSize);
        }
        if ((this.mask & 0x400) == 1024) {
            os.writeBoolean(this.xWrap);
        }
        if ((this.mask & 0x800) == 2048) {
            os.writeBoolean(this.yWrap);
        }
        if ((this.mask & 0x1000) == 4096) {
            this.perspective.serialize(os);
        }
        if ((this.mask & 0x80) == 128) {
            os.writeInt(this.patchDiffs.size());
            for (PatchData patch : this.patchDiffs) {
                patch.serialize(os);
            }
        }
        if ((this.mask & 0x40) == 64) {
            os.writeInt(this.turtleDiffs.size());
            for (TurtleData turtle : this.turtleDiffs) {
                turtle.serialize(os);
            }
        }
        if ((this.mask & 0x100) == 256) {
            os.writeInt(this.linkDiffs.size());
            for (LinkData link : this.linkDiffs) {
                link.serialize(os);
            }
        }
        if ((this.mask & 0x200) == 512) {
            ImageIO.write((RenderedImage)this.drawing, "PNG", os);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.serialize(new DataOutputStream(bos));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }
}

