/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.INeighborhoodPointsCollector;
import org.tinfour.common.IProcessUsingTin;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualEdge;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.semivirtual.SemiVirtualStochasticLawsonsWalk;

class SemiVirtualNeighborhoodPointsCollector
implements IProcessUsingTin,
INeighborhoodPointsCollector {
    final SemiVirtualStochasticLawsonsWalk walker;
    final SemiVirtualIncrementalTin tin;
    final double vertexTolerance2;
    SemiVirtualEdge searchEdge;
    boolean isQueryPointToExterior;
    int maxDepthSearched;

    SemiVirtualNeighborhoodPointsCollector(SemiVirtualIncrementalTin tin, Thresholds thresholds) {
        this.tin = tin;
        this.walker = new SemiVirtualStochasticLawsonsWalk(thresholds);
        this.vertexTolerance2 = thresholds.getVertexTolerance2();
    }

    @Override
    public void resetForChangeToTin() {
        this.searchEdge = null;
        this.walker.reset();
        this.isQueryPointToExterior = false;
    }

    boolean checkForAmbiguity(Vertex a, Vertex b, double x, double y) {
        double vy;
        double ax = a.getX();
        double ay = a.getY();
        double dx = b.getX() - ax;
        double vx = x - ax;
        double dy = b.getY() - ay;
        double h = vx * dy - (vy = y - ay) * dx;
        return h == 0.0;
    }

    private List<Vertex> pinwheel(SemiVirtualEdge e0, int searchDepth, int targetMinVertexCount) {
        Vertex a;
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        Vertex v0 = e0.getA();
        vList.add(v0);
        SemiVirtualEdge c = e0;
        do {
            if ((a = (c = c.getForward()).getA()) == null) continue;
            vList.add(c.getA());
        } while (!(c = c.getForward().getDual()).equals(e0));
        if (searchDepth > 1) {
            c = e0;
            do {
                if ((a = (c = c.getForward()).getA()) == null) continue;
                SemiVirtualEdge sDual = c.getDual();
                this.standardSearch(vList, sDual.getForward().getDual(), 2, searchDepth);
                this.standardSearch(vList, sDual.getReverse().getDual(), 2, searchDepth);
            } while (!(c = c.getForward().getDual()).equals(e0));
        }
        int nFound = vList.size();
        int nExtras = 0;
        while (nFound < targetMinVertexCount) {
            int nPrior = nFound;
            ++nExtras;
            c = e0;
            do {
                Vertex a2;
                if ((a2 = (c = c.getForward()).getA()) == null) continue;
                SemiVirtualEdge sDual = c.getDual();
                this.extendedSearch(vList, sDual.getForward().getDual(), 2, searchDepth, searchDepth + nExtras);
                this.extendedSearch(vList, sDual.getReverse().getDual(), 2, searchDepth, searchDepth + nExtras);
            } while ((c = c.getForward().getDual()).equals(e0));
            nFound = vList.size();
            if (nFound > nPrior) continue;
            break;
        }
        return vList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Vertex> collectNeighboringVertices(double x, double y, int searchDepth, int targetMinVertexCount) {
        Vertex temp;
        this.isQueryPointToExterior = false;
        this.maxDepthSearched = 0;
        if (this.searchEdge == null) {
            this.searchEdge = this.tin.getStartingEdge();
        }
        SemiVirtualEdge eEdge = this.searchEdge = this.walker.findAnEdgeFromEnclosingTriangle(this.searchEdge, x, y);
        Vertex v0 = eEdge.getA();
        Vertex v1 = eEdge.getB();
        Vertex v2 = eEdge.getForward().getB();
        if (v2 == null) {
            eEdge = eEdge.getDual();
            v2 = eEdge.getForward().getB();
            this.isQueryPointToExterior = true;
        }
        if (v0.getDistanceSq(x, y) < this.vertexTolerance2) {
            return this.pinwheel(eEdge, searchDepth, targetMinVertexCount);
        }
        if (v1.getDistanceSq(x, y) < this.vertexTolerance2) {
            return this.pinwheel(eEdge.getDual(), searchDepth, targetMinVertexCount);
        }
        if (v2.getDistanceSq(x, y) < this.vertexTolerance2) {
            return this.pinwheel(eEdge.getReverse(), searchDepth, targetMinVertexCount);
        }
        boolean ambiguity = false;
        if (this.checkForAmbiguity(v0, v1, x, y)) {
            ambiguity = true;
        } else if (this.checkForAmbiguity(v1, v2, x, y)) {
            ambiguity = true;
            eEdge = eEdge.getForward();
            temp = v0;
            v0 = v1;
            v1 = v2;
            v2 = temp;
        } else if (this.checkForAmbiguity(v2, v0, x, y)) {
            ambiguity = true;
            eEdge = eEdge.getReverse();
            temp = v2;
            v2 = v1;
            v1 = v0;
            v0 = temp;
        }
        SemiVirtualEdge rEdge = eEdge.getReverse();
        SemiVirtualEdge fEdge = eEdge.getForward();
        SemiVirtualEdge dEdge = eEdge.getDual();
        Vertex vq = null;
        if (ambiguity) {
            vq = dEdge.getForward().getB();
        }
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        vList.add(v0);
        vList.add(v1);
        if (vq == null) {
            vList.add(v2);
            SemiVirtualEdge mEdge = rEdge.getDual();
            SemiVirtualEdge nEdge = fEdge.getDual();
            this.standardSearch(vList, dEdge, 1, searchDepth);
            this.standardSearch(vList, mEdge, 1, searchDepth);
            this.standardSearch(vList, nEdge, 1, searchDepth);
            this.maxDepthSearched = searchDepth;
            int nFound = vList.size();
            if (nFound >= targetMinVertexCount) return vList;
            int nPrior = 0;
            int nExtras = 0;
            do {
                if (nFound == nPrior) return vList;
                nPrior = nFound;
                this.extendedSearch(vList, dEdge, 1, searchDepth, searchDepth + ++nExtras);
                this.extendedSearch(vList, mEdge, 1, searchDepth, searchDepth + nExtras);
                this.extendedSearch(vList, nEdge, 1, searchDepth, searchDepth + nExtras);
            } while ((nFound = vList.size()) < targetMinVertexCount);
            return vList;
        } else {
            if (v2.getDistanceSq(x, y) < vq.getDistanceSq(x, y)) {
                vList.add(v2);
                vList.add(vq);
            } else {
                vList.add(vq);
                vList.add(v2);
            }
            SemiVirtualEdge mEdge = rEdge.getDual();
            SemiVirtualEdge nEdge = fEdge.getDual();
            SemiVirtualEdge sEdge = dEdge.getForward().getDual();
            SemiVirtualEdge tEdge = dEdge.getReverse().getDual();
            this.standardSearch(vList, mEdge, 1, searchDepth);
            this.standardSearch(vList, nEdge, 1, searchDepth);
            this.standardSearch(vList, sEdge, 1, searchDepth);
            this.standardSearch(vList, tEdge, 1, searchDepth);
            this.maxDepthSearched = searchDepth;
            int nFound = vList.size();
            if (nFound >= targetMinVertexCount) return vList;
            int nPrior = 0;
            int nExtras = 0;
            do {
                if (nFound == nPrior) return vList;
                nPrior = nFound;
                this.extendedSearch(vList, mEdge, 1, searchDepth, searchDepth + ++nExtras);
                this.extendedSearch(vList, nEdge, 1, searchDepth, searchDepth + nExtras);
                this.extendedSearch(vList, sEdge, 1, searchDepth, searchDepth + nExtras);
                this.extendedSearch(vList, tEdge, 1, searchDepth, searchDepth + nExtras);
            } while ((nFound = vList.size()) < targetMinVertexCount);
        }
        return vList;
    }

    private void standardSearch(List<Vertex> vList, SemiVirtualEdge e, int depth, int traversalDepth) {
        Vertex b = e.getForward().getB();
        if (b == null) {
            return;
        }
        if (!vList.contains(b)) {
            vList.add(b);
        }
        if (depth < traversalDepth) {
            this.standardSearch(vList, e.getForward().getDual(), depth + 1, traversalDepth);
            this.standardSearch(vList, e.getReverse().getDual(), depth + 1, traversalDepth);
        }
    }

    private void extendedSearch(List<Vertex> vList, SemiVirtualEdge e, int depth, int previousDepth, int traversalDepth) {
        Vertex b;
        if (depth > this.maxDepthSearched) {
            this.maxDepthSearched = depth;
        }
        if ((b = e.getForward().getB()) == null) {
            return;
        }
        if (depth >= previousDepth && !vList.contains(b)) {
            vList.add(b);
        }
        if (depth < traversalDepth) {
            this.extendedSearch(vList, e.getForward().getDual(), depth + 1, previousDepth, traversalDepth);
            this.extendedSearch(vList, e.getReverse().getDual(), depth + 1, previousDepth, traversalDepth);
        }
    }

    @Override
    public boolean wasTargetExteriorToTin() {
        return this.isQueryPointToExterior;
    }

    @Override
    public int getMaxDepthSearched() {
        return this.maxDepthSearched;
    }
}

