/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.io.WriteableBinary;

public class Writeable2DArrayBinary
implements WriteableBinary {
    public double[][] value;

    public Writeable2DArrayBinary(double[][] matrix) {
        this.value = matrix;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        if (this.value == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.value.length);
            out.writeInt(this.value[0].length);
            double[][] dArray = this.value;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] row;
                for (double d : row = dArray[i]) {
                    out.writeDouble(d);
                }
            }
        }
    }

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

