/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformDoubleRangeIterable
implements NumericIterable<Double> {
    private double stop;
    private double step;
    private double current;

    public UniformDoubleRangeIterable(double start, double stop, double step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformDoubleRangeIterable(double start, double stop) {
        this(start, stop, 1.0);
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){

            @Override
            public boolean hasNext() {
                return UniformDoubleRangeIterable.this.current + UniformDoubleRangeIterable.this.step <= UniformDoubleRangeIterable.this.stop;
            }

            @Override
            public Double next() {
                double ret = UniformDoubleRangeIterable.this.current;
                UniformDoubleRangeIterable.this.current = UniformDoubleRangeIterable.this.current + UniformDoubleRangeIterable.this.step;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

