// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package media

import original "github.com/Azure/azure-sdk-for-go/services/preview/mediaservices/mgmt/2018-03-30-preview/media"

type AssetsClient = original.AssetsClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type ContentKeyPoliciesClient = original.ContentKeyPoliciesClient
type JobsClient = original.JobsClient
type LiveEventsClient = original.LiveEventsClient
type LiveOutputsClient = original.LiveOutputsClient
type LocationsClient = original.LocationsClient
type MediaservicesClient = original.MediaservicesClient
type AacAudioProfile = original.AacAudioProfile

const (
	AacLc   AacAudioProfile = original.AacLc
	HeAacV1 AacAudioProfile = original.HeAacV1
	HeAacV2 AacAudioProfile = original.HeAacV2
)

type AssetContainerPermission = original.AssetContainerPermission

const (
	Read            AssetContainerPermission = original.Read
	ReadWrite       AssetContainerPermission = original.ReadWrite
	ReadWriteDelete AssetContainerPermission = original.ReadWriteDelete
)

type AssetStorageEncryptionFormat = original.AssetStorageEncryptionFormat

const (
	MediaStorageClientEncryption AssetStorageEncryptionFormat = original.MediaStorageClientEncryption
	None                         AssetStorageEncryptionFormat = original.None
)

type ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyType

const (
	PersistentLimited   ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.PersistentLimited
	PersistentUnlimited ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.PersistentUnlimited
	Undefined           ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.Undefined
	Unknown             ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.Unknown
)

type ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentType

const (
	ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload  ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload
	ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming
	ContentKeyPolicyPlayReadyContentTypeUnknown              ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnknown
	ContentKeyPolicyPlayReadyContentTypeUnspecified          ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnspecified
)

type ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseType

const (
	ContentKeyPolicyPlayReadyLicenseTypeNonPersistent ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeNonPersistent
	ContentKeyPolicyPlayReadyLicenseTypePersistent    ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypePersistent
	ContentKeyPolicyPlayReadyLicenseTypeUnknown       ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeUnknown
)

type ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOption

const (
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed                   ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown
)

type ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenType

const (
	ContentKeyPolicyRestrictionTokenTypeJwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeJwt
	ContentKeyPolicyRestrictionTokenTypeSwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeSwt
	ContentKeyPolicyRestrictionTokenTypeUnknown ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeUnknown
)

type DeinterlaceMode = original.DeinterlaceMode

const (
	AutoPixelAdaptive DeinterlaceMode = original.AutoPixelAdaptive
	Off               DeinterlaceMode = original.Off
)

type DeinterlaceParity = original.DeinterlaceParity

const (
	Auto             DeinterlaceParity = original.Auto
	BottomFieldFirst DeinterlaceParity = original.BottomFieldFirst
	TopFieldFirst    DeinterlaceParity = original.TopFieldFirst
)

type EncoderNamedPreset = original.EncoderNamedPreset

const (
	AACGoodQualityAudio      EncoderNamedPreset = original.AACGoodQualityAudio
	AdaptiveStreaming        EncoderNamedPreset = original.AdaptiveStreaming
	H264MultipleBitrate1080p EncoderNamedPreset = original.H264MultipleBitrate1080p
	H264MultipleBitrate720p  EncoderNamedPreset = original.H264MultipleBitrate720p
	H264MultipleBitrateSD    EncoderNamedPreset = original.H264MultipleBitrateSD
)

type EncryptionScheme = original.EncryptionScheme

const (
	EncryptionSchemeCommonEncryptionCbcs EncryptionScheme = original.EncryptionSchemeCommonEncryptionCbcs
	EncryptionSchemeCommonEncryptionCenc EncryptionScheme = original.EncryptionSchemeCommonEncryptionCenc
	EncryptionSchemeEnvelopeEncryption   EncryptionScheme = original.EncryptionSchemeEnvelopeEncryption
	EncryptionSchemeNoEncryption         EncryptionScheme = original.EncryptionSchemeNoEncryption
)

type EntropyMode = original.EntropyMode

const (
	Cabac EntropyMode = original.Cabac
	Cavlc EntropyMode = original.Cavlc
)

type H264Complexity = original.H264Complexity

const (
	Balanced H264Complexity = original.Balanced
	Quality  H264Complexity = original.Quality
	Speed    H264Complexity = original.Speed
)

type H264VideoProfile = original.H264VideoProfile

const (
	H264VideoProfileAuto     H264VideoProfile = original.H264VideoProfileAuto
	H264VideoProfileBaseline H264VideoProfile = original.H264VideoProfileBaseline
	H264VideoProfileHigh     H264VideoProfile = original.H264VideoProfileHigh
	H264VideoProfileHigh422  H264VideoProfile = original.H264VideoProfileHigh422
	H264VideoProfileHigh444  H264VideoProfile = original.H264VideoProfileHigh444
	H264VideoProfileMain     H264VideoProfile = original.H264VideoProfileMain
)

type JobErrorCategory = original.JobErrorCategory

const (
	JobErrorCategoryConfiguration JobErrorCategory = original.JobErrorCategoryConfiguration
	JobErrorCategoryContent       JobErrorCategory = original.JobErrorCategoryContent
	JobErrorCategoryDownload      JobErrorCategory = original.JobErrorCategoryDownload
	JobErrorCategoryService       JobErrorCategory = original.JobErrorCategoryService
	JobErrorCategoryUpload        JobErrorCategory = original.JobErrorCategoryUpload
)

type JobErrorCode = original.JobErrorCode

const (
	ConfigurationUnsupported JobErrorCode = original.ConfigurationUnsupported
	ContentMalformed         JobErrorCode = original.ContentMalformed
	ContentUnsupported       JobErrorCode = original.ContentUnsupported
	DownloadNotAccessible    JobErrorCode = original.DownloadNotAccessible
	DownloadTransientError   JobErrorCode = original.DownloadTransientError
	ServiceError             JobErrorCode = original.ServiceError
	ServiceTransientError    JobErrorCode = original.ServiceTransientError
	UploadNotAccessible      JobErrorCode = original.UploadNotAccessible
	UploadTransientError     JobErrorCode = original.UploadTransientError
)

type JobRetry = original.JobRetry

const (
	DoNotRetry JobRetry = original.DoNotRetry
	MayRetry   JobRetry = original.MayRetry
)

type JobState = original.JobState

const (
	Canceled   JobState = original.Canceled
	Canceling  JobState = original.Canceling
	Error      JobState = original.Error
	Finished   JobState = original.Finished
	Processing JobState = original.Processing
	Queued     JobState = original.Queued
	Scheduled  JobState = original.Scheduled
)

type LiveEventEncodingType = original.LiveEventEncodingType

const (
	LiveEventEncodingTypeBasic LiveEventEncodingType = original.LiveEventEncodingTypeBasic
	LiveEventEncodingTypeNone  LiveEventEncodingType = original.LiveEventEncodingTypeNone
)

type LiveEventInputProtocol = original.LiveEventInputProtocol

const (
	FragmentedMP4 LiveEventInputProtocol = original.FragmentedMP4
	RTMP          LiveEventInputProtocol = original.RTMP
)

type LiveEventResourceState = original.LiveEventResourceState

const (
	Deleting LiveEventResourceState = original.Deleting
	Running  LiveEventResourceState = original.Running
	Starting LiveEventResourceState = original.Starting
	Stopped  LiveEventResourceState = original.Stopped
	Stopping LiveEventResourceState = original.Stopping
)

type LiveOutputResourceState = original.LiveOutputResourceState

const (
	LiveOutputResourceStateCreating LiveOutputResourceState = original.LiveOutputResourceStateCreating
	LiveOutputResourceStateDeleting LiveOutputResourceState = original.LiveOutputResourceStateDeleting
	LiveOutputResourceStateRunning  LiveOutputResourceState = original.LiveOutputResourceStateRunning
)

type OdataType = original.OdataType

const (
	OdataTypeContentKeyPolicyPlayReadyContentKeyLocation                                  OdataType = original.OdataTypeContentKeyPolicyPlayReadyContentKeyLocation
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader        OdataType = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier OdataType = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
)

type OdataTypeBasicCodec = original.OdataTypeBasicCodec

const (
	OdataTypeCodec                   OdataTypeBasicCodec = original.OdataTypeCodec
	OdataTypeMicrosoftMediaAacAudio  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaAacAudio
	OdataTypeMicrosoftMediaAudio     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaAudio
	OdataTypeMicrosoftMediaCopyAudio OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaCopyAudio
	OdataTypeMicrosoftMediaCopyVideo OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaCopyVideo
	OdataTypeMicrosoftMediaH264Video OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaH264Video
	OdataTypeMicrosoftMediaImage     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaImage
	OdataTypeMicrosoftMediaJpgImage  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaJpgImage
	OdataTypeMicrosoftMediaPngImage  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaPngImage
	OdataTypeMicrosoftMediaVideo     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaVideo
)

type OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfiguration

const (
	OdataTypeContentKeyPolicyConfiguration                        OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeContentKeyPolicyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration   OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration
)

type OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestriction

const (
	OdataTypeContentKeyPolicyRestriction                      OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeContentKeyPolicyRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction    OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction   OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction
)

type OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKey

const (
	OdataTypeContentKeyPolicyRestrictionTokenKey                   OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeContentKeyPolicyRestrictionTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey             OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey       OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey
)

type OdataTypeBasicFormat = original.OdataTypeBasicFormat

const (
	OdataTypeFormat                              OdataTypeBasicFormat = original.OdataTypeFormat
	OdataTypeMicrosoftMediaImageFormat           OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaImageFormat
	OdataTypeMicrosoftMediaJpgFormat             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaJpgFormat
	OdataTypeMicrosoftMediaMp4Format             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaMp4Format
	OdataTypeMicrosoftMediaMultiBitrateFormat    OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaMultiBitrateFormat
	OdataTypeMicrosoftMediaPngFormat             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaPngFormat
	OdataTypeMicrosoftMediaTransportStreamFormat OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaTransportStreamFormat
)

type OdataTypeBasicJobInput = original.OdataTypeBasicJobInput

const (
	OdataTypeJobInput                    OdataTypeBasicJobInput = original.OdataTypeJobInput
	OdataTypeMicrosoftMediaJobInputAsset OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputAsset
	OdataTypeMicrosoftMediaJobInputClip  OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputClip
	OdataTypeMicrosoftMediaJobInputHTTP  OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputHTTP
	OdataTypeMicrosoftMediaJobInputs     OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputs
)

type OdataTypeBasicJobOutput = original.OdataTypeBasicJobOutput

const (
	OdataTypeJobOutput                    OdataTypeBasicJobOutput = original.OdataTypeJobOutput
	OdataTypeMicrosoftMediaJobOutputAsset OdataTypeBasicJobOutput = original.OdataTypeMicrosoftMediaJobOutputAsset
)

type OdataTypeBasicLayer = original.OdataTypeBasicLayer

const (
	OdataTypeLayer                    OdataTypeBasicLayer = original.OdataTypeLayer
	OdataTypeMicrosoftMediaH264Layer  OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaH264Layer
	OdataTypeMicrosoftMediaJpgLayer   OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaJpgLayer
	OdataTypeMicrosoftMediaPngLayer   OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaPngLayer
	OdataTypeMicrosoftMediaVideoLayer OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaVideoLayer
)

type OdataTypeBasicOverlay = original.OdataTypeBasicOverlay

const (
	OdataTypeMicrosoftMediaAudioOverlay OdataTypeBasicOverlay = original.OdataTypeMicrosoftMediaAudioOverlay
	OdataTypeMicrosoftMediaVideoOverlay OdataTypeBasicOverlay = original.OdataTypeMicrosoftMediaVideoOverlay
	OdataTypeOverlay                    OdataTypeBasicOverlay = original.OdataTypeOverlay
)

type OdataTypeBasicPreset = original.OdataTypeBasicPreset

const (
	OdataTypeMicrosoftMediaAudioAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaAudioAnalyzerPreset
	OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset
	OdataTypeMicrosoftMediaStandardEncoderPreset        OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaStandardEncoderPreset
	OdataTypeMicrosoftMediaVideoAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaVideoAnalyzerPreset
	OdataTypePreset                                     OdataTypeBasicPreset = original.OdataTypePreset
)

type OnErrorType = original.OnErrorType

const (
	ContinueJob       OnErrorType = original.ContinueJob
	StopProcessingJob OnErrorType = original.StopProcessingJob
)

type Priority = original.Priority

const (
	High   Priority = original.High
	Low    Priority = original.Low
	Normal Priority = original.Normal
)

type Rotation = original.Rotation

const (
	RotationAuto      Rotation = original.RotationAuto
	RotationNone      Rotation = original.RotationNone
	RotationRotate0   Rotation = original.RotationRotate0
	RotationRotate180 Rotation = original.RotationRotate180
	RotationRotate270 Rotation = original.RotationRotate270
	RotationRotate90  Rotation = original.RotationRotate90
)

type StorageAccountType = original.StorageAccountType

const (
	Primary   StorageAccountType = original.Primary
	Secondary StorageAccountType = original.Secondary
)

type StreamingEndpointResourceState = original.StreamingEndpointResourceState

const (
	StreamingEndpointResourceStateDeleting StreamingEndpointResourceState = original.StreamingEndpointResourceStateDeleting
	StreamingEndpointResourceStateRunning  StreamingEndpointResourceState = original.StreamingEndpointResourceStateRunning
	StreamingEndpointResourceStateScaling  StreamingEndpointResourceState = original.StreamingEndpointResourceStateScaling
	StreamingEndpointResourceStateStarting StreamingEndpointResourceState = original.StreamingEndpointResourceStateStarting
	StreamingEndpointResourceStateStopped  StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopped
	StreamingEndpointResourceStateStopping StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopping
)

type StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyType

const (
	StreamingLocatorContentKeyTypeCommonEncryptionCbcs StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCbcs
	StreamingLocatorContentKeyTypeCommonEncryptionCenc StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCenc
	StreamingLocatorContentKeyTypeEnvelopeEncryption   StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeEnvelopeEncryption
)

type StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocol

const (
	StreamingPolicyStreamingProtocolDash            StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDash
	StreamingPolicyStreamingProtocolDownload        StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDownload
	StreamingPolicyStreamingProtocolHls             StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolHls
	StreamingPolicyStreamingProtocolSmoothStreaming StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolSmoothStreaming
)

type StreamOptionsFlag = original.StreamOptionsFlag

const (
	Default    StreamOptionsFlag = original.Default
	LowLatency StreamOptionsFlag = original.LowLatency
)

type StretchMode = original.StretchMode

const (
	StretchModeAutoFit  StretchMode = original.StretchModeAutoFit
	StretchModeAutoSize StretchMode = original.StretchModeAutoSize
	StretchModeNone     StretchMode = original.StretchModeNone
)

type TrackPropertyCompareOperation = original.TrackPropertyCompareOperation

const (
	TrackPropertyCompareOperationEqual   TrackPropertyCompareOperation = original.TrackPropertyCompareOperationEqual
	TrackPropertyCompareOperationUnknown TrackPropertyCompareOperation = original.TrackPropertyCompareOperationUnknown
)

type TrackPropertyType = original.TrackPropertyType

const (
	TrackPropertyTypeFourCC  TrackPropertyType = original.TrackPropertyTypeFourCC
	TrackPropertyTypeUnknown TrackPropertyType = original.TrackPropertyTypeUnknown
)

type AacAudio = original.AacAudio
type AkamaiAccessControl = original.AkamaiAccessControl
type AkamaiSignatureHeaderAuthenticationKey = original.AkamaiSignatureHeaderAuthenticationKey
type APIError = original.APIError
type Asset = original.Asset
type AssetCollection = original.AssetCollection
type AssetCollectionIterator = original.AssetCollectionIterator
type AssetCollectionPage = original.AssetCollectionPage
type AssetContainerSas = original.AssetContainerSas
type AssetProperties = original.AssetProperties
type AssetStorageEncryptionKey = original.AssetStorageEncryptionKey
type BasicAudio = original.BasicAudio
type Audio = original.Audio
type BasicAudioAnalyzerPreset = original.BasicAudioAnalyzerPreset
type AudioAnalyzerPreset = original.AudioAnalyzerPreset
type AudioOverlay = original.AudioOverlay
type BuiltInStandardEncoderPreset = original.BuiltInStandardEncoderPreset
type CbcsDrmConfiguration = original.CbcsDrmConfiguration
type CencDrmConfiguration = original.CencDrmConfiguration
type CheckNameAvailabilityInput = original.CheckNameAvailabilityInput
type BasicCodec = original.BasicCodec
type Codec = original.Codec
type CommonEncryptionCbcs = original.CommonEncryptionCbcs
type CommonEncryptionCenc = original.CommonEncryptionCenc
type ContentKeyPolicy = original.ContentKeyPolicy
type ContentKeyPolicyClearKeyConfiguration = original.ContentKeyPolicyClearKeyConfiguration
type ContentKeyPolicyCollection = original.ContentKeyPolicyCollection
type ContentKeyPolicyCollectionIterator = original.ContentKeyPolicyCollectionIterator
type ContentKeyPolicyCollectionPage = original.ContentKeyPolicyCollectionPage
type BasicContentKeyPolicyConfiguration = original.BasicContentKeyPolicyConfiguration
type ContentKeyPolicyConfiguration = original.ContentKeyPolicyConfiguration
type ContentKeyPolicyFairPlayConfiguration = original.ContentKeyPolicyFairPlayConfiguration
type ContentKeyPolicyOpenRestriction = original.ContentKeyPolicyOpenRestriction
type ContentKeyPolicyOption = original.ContentKeyPolicyOption
type ContentKeyPolicyPlayReadyConfiguration = original.ContentKeyPolicyPlayReadyConfiguration
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
type BasicContentKeyPolicyPlayReadyContentKeyLocation = original.BasicContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyContentKeyLocation = original.ContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction = original.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
type ContentKeyPolicyPlayReadyLicense = original.ContentKeyPolicyPlayReadyLicense
type ContentKeyPolicyPlayReadyPlayRight = original.ContentKeyPolicyPlayReadyPlayRight
type ContentKeyPolicyProperties = original.ContentKeyPolicyProperties
type BasicContentKeyPolicyRestriction = original.BasicContentKeyPolicyRestriction
type ContentKeyPolicyRestriction = original.ContentKeyPolicyRestriction
type BasicContentKeyPolicyRestrictionTokenKey = original.BasicContentKeyPolicyRestrictionTokenKey
type ContentKeyPolicyRestrictionTokenKey = original.ContentKeyPolicyRestrictionTokenKey
type ContentKeyPolicyRsaTokenKey = original.ContentKeyPolicyRsaTokenKey
type ContentKeyPolicySymmetricTokenKey = original.ContentKeyPolicySymmetricTokenKey
type ContentKeyPolicyTokenClaim = original.ContentKeyPolicyTokenClaim
type ContentKeyPolicyTokenRestriction = original.ContentKeyPolicyTokenRestriction
type ContentKeyPolicyUnknownConfiguration = original.ContentKeyPolicyUnknownConfiguration
type ContentKeyPolicyUnknownRestriction = original.ContentKeyPolicyUnknownRestriction
type ContentKeyPolicyWidevineConfiguration = original.ContentKeyPolicyWidevineConfiguration
type ContentKeyPolicyX509CertificateTokenKey = original.ContentKeyPolicyX509CertificateTokenKey
type CopyAudio = original.CopyAudio
type CopyVideo = original.CopyVideo
type CrossSiteAccessPolicies = original.CrossSiteAccessPolicies
type DefaultKey = original.DefaultKey
type Deinterlace = original.Deinterlace
type EnabledProtocols = original.EnabledProtocols
type EntityNameAvailabilityCheckOutput = original.EntityNameAvailabilityCheckOutput
type EnvelopeEncryption = original.EnvelopeEncryption
type Filters = original.Filters
type BasicFormat = original.BasicFormat
type Format = original.Format
type H264Layer = original.H264Layer
type H264Video = original.H264Video
type Hls = original.Hls
type BasicImage = original.BasicImage
type Image = original.Image
type BasicImageFormat = original.BasicImageFormat
type ImageFormat = original.ImageFormat
type IPAccessControl = original.IPAccessControl
type IPRange = original.IPRange
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobError = original.JobError
type JobErrorDetail = original.JobErrorDetail
type BasicJobInput = original.BasicJobInput
type JobInput = original.JobInput
type JobInputAsset = original.JobInputAsset
type BasicJobInputClip = original.BasicJobInputClip
type JobInputClip = original.JobInputClip
type JobInputHTTP = original.JobInputHTTP
type JobInputs = original.JobInputs
type BasicJobOutput = original.BasicJobOutput
type JobOutput = original.JobOutput
type JobOutputAsset = original.JobOutputAsset
type JobProperties = original.JobProperties
type JpgFormat = original.JpgFormat
type JpgImage = original.JpgImage
type JpgLayer = original.JpgLayer
type BasicLayer = original.BasicLayer
type Layer = original.Layer
type ListContainerSasInput = original.ListContainerSasInput
type ListContentKeysResponse = original.ListContentKeysResponse
type ListPathsResponse = original.ListPathsResponse
type LiveEvent = original.LiveEvent
type LiveEventActionInput = original.LiveEventActionInput
type LiveEventEncoding = original.LiveEventEncoding
type LiveEventEndpoint = original.LiveEventEndpoint
type LiveEventInput = original.LiveEventInput
type LiveEventListResult = original.LiveEventListResult
type LiveEventListResultIterator = original.LiveEventListResultIterator
type LiveEventListResultPage = original.LiveEventListResultPage
type LiveEventPreview = original.LiveEventPreview
type LiveEventPreviewAccessControl = original.LiveEventPreviewAccessControl
type LiveEventProperties = original.LiveEventProperties
type LiveEventsCreateFuture = original.LiveEventsCreateFuture
type LiveEventsDeleteFuture = original.LiveEventsDeleteFuture
type LiveEventsResetFuture = original.LiveEventsResetFuture
type LiveEventsStartFuture = original.LiveEventsStartFuture
type LiveEventsStopFuture = original.LiveEventsStopFuture
type LiveEventsUpdateFuture = original.LiveEventsUpdateFuture
type LiveOutput = original.LiveOutput
type LiveOutputListResult = original.LiveOutputListResult
type LiveOutputListResultIterator = original.LiveOutputListResultIterator
type LiveOutputListResultPage = original.LiveOutputListResultPage
type LiveOutputProperties = original.LiveOutputProperties
type LiveOutputsCreateFuture = original.LiveOutputsCreateFuture
type LiveOutputsDeleteFuture = original.LiveOutputsDeleteFuture
type Location = original.Location
type Mp4Format = original.Mp4Format
type BasicMultiBitrateFormat = original.BasicMultiBitrateFormat
type MultiBitrateFormat = original.MultiBitrateFormat
type NoEncryption = original.NoEncryption
type ODataError = original.ODataError
type Operation = original.Operation
type OperationCollection = original.OperationCollection
type OperationCollectionIterator = original.OperationCollectionIterator
type OperationCollectionPage = original.OperationCollectionPage
type OperationDisplay = original.OperationDisplay
type OutputFile = original.OutputFile
type BasicOverlay = original.BasicOverlay
type Overlay = original.Overlay
type PngFormat = original.PngFormat
type PngImage = original.PngImage
type PngLayer = original.PngLayer
type BasicPreset = original.BasicPreset
type Preset = original.Preset
type Provider = original.Provider
type ProxyResource = original.ProxyResource
type Rectangle = original.Rectangle
type Resource = original.Resource
type Service = original.Service
type ServiceCollection = original.ServiceCollection
type ServiceCollectionIterator = original.ServiceCollectionIterator
type ServiceCollectionPage = original.ServiceCollectionPage
type ServiceProperties = original.ServiceProperties
type StandardEncoderPreset = original.StandardEncoderPreset
type StorageAccount = original.StorageAccount
type StreamingEndpoint = original.StreamingEndpoint
type StreamingEndpointAccessControl = original.StreamingEndpointAccessControl
type StreamingEndpointListResult = original.StreamingEndpointListResult
type StreamingEndpointListResultIterator = original.StreamingEndpointListResultIterator
type StreamingEndpointListResultPage = original.StreamingEndpointListResultPage
type StreamingEndpointProperties = original.StreamingEndpointProperties
type StreamingEndpointsCreateFuture = original.StreamingEndpointsCreateFuture
type StreamingEndpointsDeleteFuture = original.StreamingEndpointsDeleteFuture
type StreamingEndpointsScaleFuture = original.StreamingEndpointsScaleFuture
type StreamingEndpointsStartFuture = original.StreamingEndpointsStartFuture
type StreamingEndpointsStopFuture = original.StreamingEndpointsStopFuture
type StreamingEndpointsUpdateFuture = original.StreamingEndpointsUpdateFuture
type StreamingEntityScaleUnit = original.StreamingEntityScaleUnit
type StreamingLocator = original.StreamingLocator
type StreamingLocatorCollection = original.StreamingLocatorCollection
type StreamingLocatorCollectionIterator = original.StreamingLocatorCollectionIterator
type StreamingLocatorCollectionPage = original.StreamingLocatorCollectionPage
type StreamingLocatorContentKey = original.StreamingLocatorContentKey
type StreamingLocatorProperties = original.StreamingLocatorProperties
type StreamingLocatorUserDefinedContentKey = original.StreamingLocatorUserDefinedContentKey
type StreamingPath = original.StreamingPath
type StreamingPolicy = original.StreamingPolicy
type StreamingPolicyCollection = original.StreamingPolicyCollection
type StreamingPolicyCollectionIterator = original.StreamingPolicyCollectionIterator
type StreamingPolicyCollectionPage = original.StreamingPolicyCollectionPage
type StreamingPolicyContentKey = original.StreamingPolicyContentKey
type StreamingPolicyContentKeys = original.StreamingPolicyContentKeys
type StreamingPolicyFairPlayConfiguration = original.StreamingPolicyFairPlayConfiguration
type StreamingPolicyPlayReadyConfiguration = original.StreamingPolicyPlayReadyConfiguration
type StreamingPolicyProperties = original.StreamingPolicyProperties
type StreamingPolicyWidevineConfiguration = original.StreamingPolicyWidevineConfiguration
type SubscriptionMediaService = original.SubscriptionMediaService
type SubscriptionMediaServiceCollection = original.SubscriptionMediaServiceCollection
type SubscriptionMediaServiceCollectionIterator = original.SubscriptionMediaServiceCollectionIterator
type SubscriptionMediaServiceCollectionPage = original.SubscriptionMediaServiceCollectionPage
type SyncStorageKeysInput = original.SyncStorageKeysInput
type TrackedResource = original.TrackedResource
type TrackPropertyCondition = original.TrackPropertyCondition
type TrackSelection = original.TrackSelection
type Transform = original.Transform
type TransformCollection = original.TransformCollection
type TransformCollectionIterator = original.TransformCollectionIterator
type TransformCollectionPage = original.TransformCollectionPage
type TransformOutput = original.TransformOutput
type TransformProperties = original.TransformProperties
type TransportStreamFormat = original.TransportStreamFormat
type BasicVideo = original.BasicVideo
type Video = original.Video
type VideoAnalyzerPreset = original.VideoAnalyzerPreset
type BasicVideoLayer = original.BasicVideoLayer
type VideoLayer = original.VideoLayer
type VideoOverlay = original.VideoOverlay
type OperationsClient = original.OperationsClient
type StreamingEndpointsClient = original.StreamingEndpointsClient
type StreamingLocatorsClient = original.StreamingLocatorsClient
type StreamingPoliciesClient = original.StreamingPoliciesClient
type TransformsClient = original.TransformsClient

func NewAssetsClient(subscriptionID string) AssetsClient {
	return original.NewAssetsClient(subscriptionID)
}
func NewAssetsClientWithBaseURI(baseURI string, subscriptionID string) AssetsClient {
	return original.NewAssetsClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewContentKeyPoliciesClient(subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClient(subscriptionID)
}
func NewContentKeyPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveEventsClient(subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClient(subscriptionID)
}
func NewLiveEventsClientWithBaseURI(baseURI string, subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveOutputsClient(subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClient(subscriptionID)
}
func NewLiveOutputsClientWithBaseURI(baseURI string, subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMediaservicesClient(subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClient(subscriptionID)
}
func NewMediaservicesClientWithBaseURI(baseURI string, subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAacAudioProfileValues() []AacAudioProfile {
	return original.PossibleAacAudioProfileValues()
}
func PossibleAssetContainerPermissionValues() []AssetContainerPermission {
	return original.PossibleAssetContainerPermissionValues()
}
func PossibleAssetStorageEncryptionFormatValues() []AssetStorageEncryptionFormat {
	return original.PossibleAssetStorageEncryptionFormatValues()
}
func PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues() []ContentKeyPolicyFairPlayRentalAndLeaseKeyType {
	return original.PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues()
}
func PossibleContentKeyPolicyPlayReadyContentTypeValues() []ContentKeyPolicyPlayReadyContentType {
	return original.PossibleContentKeyPolicyPlayReadyContentTypeValues()
}
func PossibleContentKeyPolicyPlayReadyLicenseTypeValues() []ContentKeyPolicyPlayReadyLicenseType {
	return original.PossibleContentKeyPolicyPlayReadyLicenseTypeValues()
}
func PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues() []ContentKeyPolicyPlayReadyUnknownOutputPassingOption {
	return original.PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues()
}
func PossibleContentKeyPolicyRestrictionTokenTypeValues() []ContentKeyPolicyRestrictionTokenType {
	return original.PossibleContentKeyPolicyRestrictionTokenTypeValues()
}
func PossibleDeinterlaceModeValues() []DeinterlaceMode {
	return original.PossibleDeinterlaceModeValues()
}
func PossibleDeinterlaceParityValues() []DeinterlaceParity {
	return original.PossibleDeinterlaceParityValues()
}
func PossibleEncoderNamedPresetValues() []EncoderNamedPreset {
	return original.PossibleEncoderNamedPresetValues()
}
func PossibleEncryptionSchemeValues() []EncryptionScheme {
	return original.PossibleEncryptionSchemeValues()
}
func PossibleEntropyModeValues() []EntropyMode {
	return original.PossibleEntropyModeValues()
}
func PossibleH264ComplexityValues() []H264Complexity {
	return original.PossibleH264ComplexityValues()
}
func PossibleH264VideoProfileValues() []H264VideoProfile {
	return original.PossibleH264VideoProfileValues()
}
func PossibleJobErrorCategoryValues() []JobErrorCategory {
	return original.PossibleJobErrorCategoryValues()
}
func PossibleJobErrorCodeValues() []JobErrorCode {
	return original.PossibleJobErrorCodeValues()
}
func PossibleJobRetryValues() []JobRetry {
	return original.PossibleJobRetryValues()
}
func PossibleJobStateValues() []JobState {
	return original.PossibleJobStateValues()
}
func PossibleLiveEventEncodingTypeValues() []LiveEventEncodingType {
	return original.PossibleLiveEventEncodingTypeValues()
}
func PossibleLiveEventInputProtocolValues() []LiveEventInputProtocol {
	return original.PossibleLiveEventInputProtocolValues()
}
func PossibleLiveEventResourceStateValues() []LiveEventResourceState {
	return original.PossibleLiveEventResourceStateValues()
}
func PossibleLiveOutputResourceStateValues() []LiveOutputResourceState {
	return original.PossibleLiveOutputResourceStateValues()
}
func PossibleOdataTypeValues() []OdataType {
	return original.PossibleOdataTypeValues()
}
func PossibleOdataTypeBasicCodecValues() []OdataTypeBasicCodec {
	return original.PossibleOdataTypeBasicCodecValues()
}
func PossibleOdataTypeBasicContentKeyPolicyConfigurationValues() []OdataTypeBasicContentKeyPolicyConfiguration {
	return original.PossibleOdataTypeBasicContentKeyPolicyConfigurationValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionValues() []OdataTypeBasicContentKeyPolicyRestriction {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues() []OdataTypeBasicContentKeyPolicyRestrictionTokenKey {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues()
}
func PossibleOdataTypeBasicFormatValues() []OdataTypeBasicFormat {
	return original.PossibleOdataTypeBasicFormatValues()
}
func PossibleOdataTypeBasicJobInputValues() []OdataTypeBasicJobInput {
	return original.PossibleOdataTypeBasicJobInputValues()
}
func PossibleOdataTypeBasicJobOutputValues() []OdataTypeBasicJobOutput {
	return original.PossibleOdataTypeBasicJobOutputValues()
}
func PossibleOdataTypeBasicLayerValues() []OdataTypeBasicLayer {
	return original.PossibleOdataTypeBasicLayerValues()
}
func PossibleOdataTypeBasicOverlayValues() []OdataTypeBasicOverlay {
	return original.PossibleOdataTypeBasicOverlayValues()
}
func PossibleOdataTypeBasicPresetValues() []OdataTypeBasicPreset {
	return original.PossibleOdataTypeBasicPresetValues()
}
func PossibleOnErrorTypeValues() []OnErrorType {
	return original.PossibleOnErrorTypeValues()
}
func PossiblePriorityValues() []Priority {
	return original.PossiblePriorityValues()
}
func PossibleRotationValues() []Rotation {
	return original.PossibleRotationValues()
}
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return original.PossibleStorageAccountTypeValues()
}
func PossibleStreamingEndpointResourceStateValues() []StreamingEndpointResourceState {
	return original.PossibleStreamingEndpointResourceStateValues()
}
func PossibleStreamingLocatorContentKeyTypeValues() []StreamingLocatorContentKeyType {
	return original.PossibleStreamingLocatorContentKeyTypeValues()
}
func PossibleStreamingPolicyStreamingProtocolValues() []StreamingPolicyStreamingProtocol {
	return original.PossibleStreamingPolicyStreamingProtocolValues()
}
func PossibleStreamOptionsFlagValues() []StreamOptionsFlag {
	return original.PossibleStreamOptionsFlagValues()
}
func PossibleStretchModeValues() []StretchMode {
	return original.PossibleStretchModeValues()
}
func PossibleTrackPropertyCompareOperationValues() []TrackPropertyCompareOperation {
	return original.PossibleTrackPropertyCompareOperationValues()
}
func PossibleTrackPropertyTypeValues() []TrackPropertyType {
	return original.PossibleTrackPropertyTypeValues()
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingEndpointsClient(subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClient(subscriptionID)
}
func NewStreamingEndpointsClientWithBaseURI(baseURI string, subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingLocatorsClient(subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClient(subscriptionID)
}
func NewStreamingLocatorsClientWithBaseURI(baseURI string, subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingPoliciesClient(subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClient(subscriptionID)
}
func NewStreamingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransformsClient(subscriptionID string) TransformsClient {
	return original.NewTransformsClient(subscriptionID)
}
func NewTransformsClientWithBaseURI(baseURI string, subscriptionID string) TransformsClient {
	return original.NewTransformsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
