/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef MAP_ITEM_H
#define MAP_ITEM_H

typedef int mapobj_t;

#define MAX_MAPOBJ_NUM 256

#define MAPOBJ_ACTION_FLATTEN  -10
#define MAPOBJ_ACTION_SELLALL  -9
#define MAPOBJ_ACTION_SELLLAND -8
#define MAPOBJ_ACTION_BUYALL   -7
#define MAPOBJ_ACTION_IRRIGATE -6
#define MAPOBJ_ACTION_BUYLAND  -5
#define MAPOBJ_ACTION_LOWER    -4
#define MAPOBJ_ACTION_RAISE    -3
#define MAPOBJ_INVALID         -1
#define MAPOBJ_ACTION_DEMOLISH 254
typedef enum maptype_e {
    MAPTYPE_EMPTY,
    MAPTYPE_ZONING,
    MAPTYPE_WATER,
    MAPTYPE_HOUSE,
    MAPTYPE_ENTERTAINMENT,
    MAPTYPE_COMMERCIAL,
    MAPTYPE_OFFICE,
    MAPTYPE_INDUSTRIAL,
    MAPTYPE_FARM,

    MAPTYPE_ROAD,
    MAPTYPE_SCHOOL,
    MAPTYPE_POLICE,
    MAPTYPE_FIRE,
    MAPTYPE_HOSPITAL,

    MAPTYPE_POWER,
    MAPTYPE_WATERUTIL,
    MAPTYPE_LANDFILL,

} maptype_t;

struct map_item {
    mapobj_t num;
    maptype_t type;
    char *name;
};

extern mapobj_t map_item_registerobj(char *name);

extern int map_item_settype(mapobj_t obj, char *type);

extern maptype_t map_item_parsetypestring(char *type);

extern maptype_t map_item_gettype(mapobj_t obj);
extern char *map_item_getname(mapobj_t obj);

extern int map_item_emptyland(mapobj_t obj);

extern mapobj_t map_item_name2obj(char *name);

extern mapobj_t map_item_emptytype(void);

extern mapobj_t *
map_item_get_typelist(maptype_t type, 
		      int (*compar)(const void *, const void *),
		      int *len);

extern int map_item_landfarmable(mapobj_t obj);

#endif /* MAP_ITEM_H */
