/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef MAPSPOT_H_
#define MAPSPOT_H_

typedef struct mapspot_list_s mapspot_list_t;

#include "map.h"
#include "tiles.h"

extern void mapspot_list_add(mapspot_list_t **list, int x, int y, void *data);
extern void mapspot_list_extract(mapspot_list_t **list, int *x, int *y, void **data);
extern void mapspot_list_extract_end(mapspot_list_t **list, int *x, int *y, void **data);
extern void mapspot_list_free(mapspot_list_t *list);
extern int mapspot_list_length(mapspot_list_t *list);
extern float mapspot_list_nearest(mapspot_list_t *list, int x, int y);
extern int mapspot_list_num_within(mapspot_list_t *list, int x, int y, float within);
extern int mapspot_is_in_list(mapspot_list_t *list, int x, int y);
extern void mapspot_list_remove(mapspot_list_t **list, int x, int y);
extern void mapspot_list_remove_data(mapspot_list_t **list, int x, int y, void *data);
extern int mapspot_within_range(mapspot_list_t *list, int x, int y, 
				map_t *map, tiles_t *tiles);

typedef int mapspot_iterator_t(int x, int y, void *data, float dist, void *rock);
extern int mapspot_within_iterate(mapspot_list_t *list, int x, int y,
				   float within,
				   mapspot_iterator_t *cb, void *rock);
extern int
mapspot_iterate(mapspot_list_t *list, 
		mapspot_iterator_t *cb, void *rock);
				   

#endif /* MAPSPOT_H_ */
