/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef SCREEN_H
#define SCREEN_H

#include "utils.h"
#include "map.h"

typedef enum {
    GAMEVIEW_NORMAL = 2,
    GAMEVIEW_OWNERS,
    GAMEVIEW_POLICE_COVER,
    GAMEVIEW_HOSPITAL_COVER,
    GAMEVIEW_FIRE_COVER,
    GAMEVIEW_MINE,
} gameview_t;

typedef struct display_s {
    gameview_t view;
    int grid;
    int showbuildings;
    maptype_t viewtype;
    mapspot_list_t *objlist;

    mapobj_t activity;
    mapspot_list_t *height_change_list;
    int selected_cost;
} display_t;

typedef struct screen_s screen_t;

int screen_init(screen_t **screen);

void screen_setmap(screen_t *screen, map_t *map);

int screen_setsize(screen_t *screen, int sizex, int sizey);

void screen_viewarea_clear(screen_t *screen);

void screen_viewarea_set(screen_t *screen, int x, int y, square_t *square);

int screen_to_mapcoord(screen_t *screen, int screenx, int screeny, int *mapx, int *mapy);

int screen_to_mapcoord_screen_center(screen_t *screen, int *mapx, int *mapy);

int mapcoord_to_screen(screen_t *screen, int mapsizex, int mapsizey, 
		       int mapx, int mapy, int *screenx, int *screeny);

/*
 * zoom the viewable size. positive means zoom in. negative means zoom out
 * returns -1 if already at zooming limit
 */
int screen_zoom(screen_t *screen, int zoom);

int screen_getzoom(screen_t *screen);

void screen_keep_in_bounds(screen_t *screen, int mapsizex, int mapsizey, int *sx, int *sy);

typedef int screen_map_iterator_t(int x, int y, void *rock);

int screen_map_iterate(screen_t *screen, screen_map_iterator_t *func, void *rock);

int screen_is_square_viewable(screen_t *screen, int mapx, int mapy, int *screenx, int *screeny);

void screen_set_position(screen_t *screen, int x, int y);

void screen_rotate(screen_t *screen, int offset);

int screen_getdirview(screen_t *screen);

void screen_getdirviewadds(screen_t *screen, int *x, int *y);

void screen_tilesizes(screen_t *screen, int *sx, int *sy, int *th);

int screen_tileheight(screen_t *screen);

#endif /* SCREEN_H */
