/*
Copyright (c) 2018-2023 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package vpx

var MetricData = map[string]map[int32][]int64{
	"VirtualMachine":         VmMetricData,
	"HostSystem":             HostMetricData,
	"ResourcePool":           ResourcePoolMetricData,
	"ClusterComputeResource": ClusterMetricData,
	"Datastore":              DatastoreMetricData,
	"Datacenter":             DatacenterMetricData,
}

var VmMetricData = map[int32][]int64{
	130: []int64{42, 57, 9, 13, 14, 25, 8, 16, 6, 13, 67, 34, 292, 89, 27, 75, 98, 59, 49, 85, 127, 116, 179, 196, 161, 170, 174, 35, 26, 20,
		25, 42, 10, 45, 24, 64, 9, 21, 6, 18, 19, 9, 16, 18, 5, 124, 97, 25, 18, 20, 28, 28, 22, 11, 12, 139, 155, 149, 179, 173,
		135, 73, 73, 67, 49, 37, 12, 28, 18, 36, 59, 18, 21, 17, 27, 137, 140, 118, 137, 265, 246, 250, 114, 43, 26, 17, 7, 36, 89, 15,
		45, 47, 49, 13, 47, 34, 52, 16, 7, 25},
	155: []int64{2948499, 2948519, 2948539, 2948559, 2948579, 2948599, 2948619, 2948639, 2948659, 2948679, 2948699, 2948719, 2948739, 2948759, 2948779, 2948799, 2948819, 2948839, 2948859, 2948879, 2948899, 2948919, 2948939, 2948959, 2948979, 2948999, 2949019, 2949039, 2949059, 2949079,
		2949099, 2949119, 2949139, 2949159, 2949179, 2949199, 2949219, 2949239, 2949259, 2949279, 2949299, 2949319, 2949339, 2949359, 2949379, 2949399, 2949419, 2949439, 2949459, 2949479, 2949499, 2949519, 2949539, 2949559, 2949579, 2949599, 2949619, 2949639, 2949659, 2949679,
		2949699, 2949719, 2949739, 2949759, 2949779, 2949799, 2949819, 2949839, 2949859, 2949879, 2949899, 2949919, 2949939, 2949959, 2949979, 2949999, 2950019, 2950039, 2950059, 2950079, 2950099, 2950119, 2950139, 2950159, 2950179, 2950199, 2950219, 2950239, 2950259, 2950279,
		2950299, 2950319, 2950339, 2950359, 2950379, 2950399, 2950419, 2950439, 2950459, 2950479},
	173: []int64{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 180, 12, 4, 1, 12, 8, 0, 6, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0,
		0, 0, 0, 1, 0, 17, 1, 1, 0, 2, 0, 0, 0, 2, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 15, 0, 0, 6, 0,
		3, 0, 0, 6, 6, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 7, 4, 6, 5, 86, 63, 80, 2, 0, 2, 0, 0, 0, 17, 0,
		0, 1, 0, 0, 4, 1, 0, 0, 1, 0},
	399: []int64{4, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 2, 12, 0, 0, 0, 0, 0, 0, 0, 2, 0,
		0, 2, 0, 0, 0, 0, 0, 1, 0, 3},
	504: []int64{2000, 2200, 2200, 2200, 2200, 1700, 1700, 1700, 1700, 1700, 2300, 2300, 2300, 2300, 2300, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2000, 2000, 2000, 2000, 2000,
		1900, 1900, 1900, 1700, 1700, 1700, 1700, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 2100, 4700, 4700, 4700, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900,
		2000, 1600, 1600, 1600, 1600, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1900, 2600, 3900, 3900, 4200, 4300, 5100, 5500, 5500, 5500, 5500, 5500, 5500, 5500, 5500, 5500,
		5200, 5200, 5200, 5200, 4300, 3700, 2300, 2200, 2300, 2300},
	174: []int64{368, 141, 143, 106, 119, 157, 88, 127, 137, 106, 211, 225, 202, 226, 234, 920, 268, 181, 204, 241, 219, 168, 221, 234, 184, 185, 236, 195, 168, 222,
		185, 189, 134, 130, 160, 122, 84, 113, 153, 95, 110, 141, 91, 108, 130, 3372, 1942, 151, 102, 158, 162, 100, 143, 122, 109, 211, 229, 173, 187, 237,
		200, 205, 241, 184, 204, 217, 182, 195, 219, 213, 211, 214, 189, 182, 245, 2671, 612, 1055, 595, 644, 747, 611, 336, 244, 118, 113, 128, 93, 94, 130,
		359, 131, 151, 94, 137, 149, 106, 109, 127, 124},
	70: []int64{91, 585, 246, 114, 553, 348, 824, 848, 827, 882, 632, 500, 647, 805, 425, 971, 789, 1001, 910, 1013, 338, 713, 496, 168, 201, 886, 124, 968, 768, 736,
		612, 859, 973, 64, 312, 449, 38, 839, 807, 571, 83, 862, 1015, 333, 818, 173, 396, 520, 171, 678, 160, 203, 991, 549, 776, 524, 390, 228, 576, 307,
		1005, 93, 893, 475, 451, 141, 98, 439, 95, 104, 739, 630, 275, 701, 722, 16, 207, 468, 310, 387, 217, 377, 684, 969, 396, 1010, 866, 914, 181, 621, 995,
		831, 278, 530, 465, 745, 704, 762, 545, 544},
	473: []int64{30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 27, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	133: []int64{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0,
		0, 28, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1,
		1, 0, 0, 1, 1, 1, 1, 1, 1, 0},
	348: []int64{1100, 1200, 1200, 1000, 1200, 1200, 1300, 900, 900, 900, 1800, 1800, 1900, 1200, 1200, 1200, 1200, 1300, 1200, 1400, 1500, 1400, 1200, 1000, 1100, 1200, 1200, 1000, 900, 800,
		900, 1000, 1000, 1100, 1300, 1400, 1300, 900, 900, 900, 1100, 1100, 1000, 800, 900, 2500, 4000, 4300, 2600, 1400, 1300, 1300, 1000, 800, 900, 1100, 1100, 1000, 900, 900,
		1000, 900, 1100, 1000, 1300, 1300, 1300, 1000, 900, 900, 1200, 1200, 1100, 800, 1000, 2200, 3200, 4400, 4100, 4500, 4900, 5000, 4200, 2600, 1500, 1100, 1200, 1100, 900, 800,
		1000, 1200, 1200, 1000, 1200, 1400, 1400, 1100, 1000, 1100},
	422: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	146: []int64{1914, 1692, 2171, 2999, 2254, 2014, 1687, 1823, 2251, 3286, 1916, 1903, 4747, 1782, 2203, 2301, 1853, 4708, 5656, 2070, 5121, 1839, 1987, 4985, 3396, 1857, 2212, 1822, 1689, 1917,
		1831, 1862, 2163, 3297, 1996, 2070, 1871, 1868, 2199, 3065, 1718, 2055, 1825, 1692, 2169, 2685, 1867, 1917, 3203, 2016, 2132, 1713, 1881, 1989, 3266, 1886, 2182, 1748, 1819, 2060,
		1752, 1931, 2123, 2909, 2026, 2015, 1681, 1792, 2184, 3277, 1639, 2075, 1690, 1740, 5110, 7545, 7854, 9835, 10912, 10197, 10426, 12296, 3728, 2135, 3253, 1784, 5195, 1824, 1578, 1959,
		1772, 1917, 2176, 3091, 2022, 4991, 1829, 4629, 5412, 3269},
	463: []int64{277, 274, 338, 383, 297, 274, 275, 274, 339, 541, 288, 259, 752, 276, 338, 276, 274, 729, 838, 292, 838, 275, 275, 748, 542, 274, 338, 274, 274, 277,
		277, 275, 337, 392, 291, 276, 274, 274, 337, 541, 274, 278, 274, 276, 338, 279, 274, 274, 390, 293, 338, 274, 275, 276, 543, 274, 339, 274, 277, 274,
		275, 275, 337, 391, 289, 277, 275, 275, 339, 541, 274, 274, 274, 275, 810, 520, 535, 592, 668, 562, 605, 575, 329, 276, 542, 274, 828, 274, 274, 276,
		276, 278, 339, 390, 289, 753, 277, 747, 812, 541},
	472: []int64{281, 281, 347, 392, 304, 280, 282, 280, 347, 555, 295, 265, 770, 282, 347, 283, 280, 749, 861, 299, 861, 282, 281, 767, 556, 280, 347, 280, 280, 283,
		283, 282, 345, 401, 298, 282, 280, 281, 346, 556, 280, 284, 280, 282, 347, 285, 280, 281, 399, 300, 347, 280, 282, 282, 557, 280, 347, 280, 283, 281,
		281, 281, 346, 401, 295, 283, 281, 281, 347, 555, 280, 281, 280, 281, 832, 530, 546, 603, 681, 572, 617, 585, 336, 283, 556, 280, 850, 280, 280, 282,
		281, 284, 347, 400, 296, 772, 283, 767, 834, 555},
	147: []int64{842, 813, 1012, 1671, 1013, 717, 821, 706, 1005, 1804, 868, 782, 2000, 755, 986, 947, 691, 1958, 2756, 967, 2241, 708, 755, 1939, 1716, 706, 1047, 715, 711, 825,
		838, 722, 904, 1800, 882, 800, 661, 805, 1098, 1685, 676, 913, 774, 738, 960, 1241, 755, 804, 1738, 985, 983, 729, 703, 745, 1630, 721, 1148, 769, 825, 807,
		741, 793, 1035, 1636, 1005, 809, 720, 756, 1076, 1737, 677, 824, 663, 714, 2056, 5216, 5689, 7065, 7549, 7205, 7517, 8701, 2154, 855, 1724, 772, 2254, 749, 705, 754,
		758, 878, 1049, 1683, 896, 2047, 729, 1907, 2105, 1704},
	2: []int64{776, 604, 442, 846, 463, 524, 454, 410, 439, 607, 1540, 404, 759, 477, 484, 646, 683, 537, 1027, 473, 746, 429, 538, 527, 632, 603, 449, 441, 386, 405,
		492, 579, 430, 928, 648, 550, 447, 408, 444, 540, 666, 390, 427, 417, 435, 3590, 2309, 394, 751, 571, 621, 398, 413, 392, 567, 652, 437, 402, 509, 403,
		534, 604, 440, 825, 471, 569, 435, 430, 442, 563, 770, 400, 444, 418, 563, 2381, 1941, 1925, 2335, 2025, 2530, 2252, 868, 443, 594, 571, 602, 417, 388, 411,
		727, 600, 471, 825, 546, 713, 431, 522, 587, 544},
	148: []int64{218, 203, 246, 299, 225, 245, 202, 203, 246, 416, 205, 243, 220, 203, 246, 337, 203, 256, 315, 219, 264, 203, 203, 259, 416, 203, 246, 203, 202, 245,
		203, 203, 245, 308, 215, 245, 203, 203, 246, 415, 203, 245, 203, 203, 245, 427, 203, 244, 308, 216, 245, 202, 203, 245, 416, 203, 246, 202, 203, 245,
		203, 203, 245, 306, 217, 245, 202, 203, 246, 416, 202, 245, 202, 203, 259, 510, 462, 659, 772, 808, 928, 1177, 384, 260, 416, 203, 260, 203, 202, 245,
		218, 203, 245, 306, 217, 259, 203, 216, 260, 416},
	402: []int64{3278, 2525, 1849, 3540, 1919, 2330, 1902, 1734, 1847, 2544, 6355, 1703, 3167, 1986, 2096, 2826, 2870, 2240, 4305, 2010, 3145, 1824, 2268, 2234, 2706, 2527, 1901, 1834, 1653, 1723,
		2097, 2407, 1811, 3960, 2643, 2540, 1859, 1735, 1892, 2288, 2747, 1635, 1845, 1759, 1798, 14863, 9491, 1680, 3272, 2287, 2612, 1686, 1750, 1643, 2387, 2719, 1845, 1689, 2202, 1687,
		2255, 2533, 1818, 3440, 1994, 2365, 1850, 1806, 1843, 2352, 3217, 1682, 1859, 1788, 2376, 10120, 8065, 7951, 9802, 8339, 10497, 9331, 3611, 1890, 2510, 2444, 2522, 1734, 1667, 1707,
		3036, 2513, 1987, 3455, 2276, 2964, 1814, 2178, 2413, 2269},
	503: []int64{1200, 1200, 1200, 1200, 1200, 1100, 1100, 1100, 1100, 1100, 1200, 1200, 1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1400, 1400, 1200, 1200, 1200, 1200, 1200,
		1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1000, 1100, 1400, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
		1400, 1100, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1100, 1100, 1100, 1000, 1100, 1300, 1500, 1700, 1900, 2100, 2500, 2700, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800,
		2600, 2400, 2100, 1900, 1700, 1400, 1200, 1100, 1100, 1100},
	421: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	184: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	466: []int64{20, 20, 23, 22, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 21, 20, 20, 20, 21, 20, 20, 20, 20, 20, 21, 20, 20,
		20, 20, 20, 25, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 21, 20,
		20, 20, 20, 24, 20, 21, 20, 20, 20, 20, 20, 21, 20, 21, 20, 20, 20, 21, 20, 20, 20, 20, 20, 23, 20, 20, 20, 20, 20, 20,
		21, 20, 20, 20, 20, 20, 21, 20, 20, 20},
	410: []int64{976, 899, 657, 904, 171, 606, 607, 707, 823, 331, 255, 421, 230, 1001,
		937, 467, 738, 287, 904, 962, 518, 391, 593, 593, 59, 874, 364, 873, 728, 727, 533,
		328, 957, 637, 973, 1014, 259, 160, 698, 589, 933, 283, 385, 393, 129, 414, 16, 800,
		105, 150, 905, 278, 131, 115, 678, 738, 444, 411, 388, 402, 541, 428, 970, 260, 56,
		794, 975, 480, 644, 110, 702, 93, 240, 322, 651, 370, 261, 589, 72, 259, 405, 965,
		927, 519, 210, 291, 688, 758, 942, 301, 253, 605, 677, 995, 509, 478, 646, 3, 472, 1007,
	},
	505: []int64{1100, 1100, 1100, 1100, 1100, 1000, 1000, 1000, 1000, 1000, 1100, 1100, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1300, 1100, 1200, 1100, 1100, 1100,
		1100, 1100, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1300, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
		1300, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1200, 1400, 1600, 1800, 2000, 2300, 2500, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
		2400, 2200, 2000, 1800, 1600, 1400, 1100, 1100, 1100, 1100},
	149: []int64{277, 274, 338, 383, 297, 274, 275, 274, 339, 541, 288, 259, 752, 276, 338, 276, 274, 729, 838, 292, 838, 275, 275, 748, 542, 274, 338, 274, 274, 277,
		277, 275, 337, 392, 291, 276, 274, 274, 337, 541, 274, 278, 274, 276, 338, 279, 274, 274, 390, 293, 338, 274, 275, 276, 543, 274, 339, 274, 277, 274,
		275, 275, 337, 391, 289, 277, 275, 275, 339, 541, 274, 274, 274, 275, 810, 520, 535, 592, 668, 562, 605, 575, 329, 276, 542, 274, 828, 274, 274, 276,
		276, 278, 339, 390, 289, 753, 277, 747, 812, 541},
	509: []int64{2200, 2200, 2200, 2200, 4000, 4000, 4000, 1300, 1200, 1900, 5400, 5400, 5400, 2200, 2200, 2000, 2200, 2200, 2200, 4100, 4100, 4100, 1700, 1900, 1900, 1900, 1800, 1400, 1200, 1200,
		1300, 2000, 2000, 2000, 4600, 4600, 4600, 1500, 1500, 1600, 2400, 2400, 2400, 1300, 1400, 10500, 10900, 10900, 10900, 3900, 3900, 3900, 1500, 1300, 1700, 2000, 2000, 2000, 1500, 1500,
		1500, 1500, 2500, 2500, 3700, 3700, 3700, 1600, 1400, 1700, 2400, 2400, 2400, 1500, 2200, 6600, 6600, 6600, 4700, 7400, 7400, 7400, 6800, 5100, 4800, 1900, 2300, 2300, 2300, 1400,
		2200, 2200, 2200, 2000, 3700, 3700, 3700, 3300, 2200, 2200},
	143: []int64{496, 477, 584, 682, 522, 519, 478, 477, 585, 958, 494, 503, 972, 480, 585, 614, 477, 985, 1153, 511, 1103, 479, 479, 1007, 959, 478, 585, 477, 477, 522,
		480, 479, 583, 701, 507, 521, 477, 478, 583, 957, 477, 523, 477, 479, 584, 706, 478, 519, 698, 510, 584, 476, 479, 521, 959, 478, 585, 477, 480, 520,
		478, 479, 583, 698, 506, 522, 478, 478, 585, 957, 477, 520, 476, 478, 1070, 1030, 998, 1251, 1441, 1371, 1534, 1752, 714, 537, 958, 477, 1088, 477, 477, 521,
		495, 482, 585, 697, 507, 1012, 480, 964, 1073, 957},
	471: []int64{198, 197, 239, 287, 218, 239, 197, 197, 240, 398, 200, 239, 213, 197, 240, 322, 198, 248, 301, 213, 250, 197, 198, 249, 398, 198, 240, 197, 197, 238,
		198, 198, 239, 301, 204, 239, 198, 198, 240, 397, 197, 239, 197, 197, 239, 421, 198, 238, 300, 205, 239, 197, 198, 239, 398, 198, 240, 197, 197, 239,
		198, 198, 239, 293, 211, 239, 197, 197, 240, 397, 197, 239, 197, 197, 250, 491, 456, 651, 758, 800, 921, 1171, 379, 254, 398, 197, 250, 197, 197, 239,
		197, 198, 239, 293, 211, 249, 197, 207, 251, 397},
	511: []int64{1900, 2000, 1900, 1900, 1900, 1700, 1700, 1700, 1700, 1700, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 1900, 1900, 1900, 1900, 1900,
		1800, 1800, 1800, 1700, 1700, 1700, 1700, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 2000, 4600, 4600, 4600, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900,
		2000, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1700, 2500, 3700, 3900, 3900, 4100, 4700, 5100, 5100, 5100, 5100, 5100, 5100, 5100, 5100, 5100,
		4800, 4800, 4800, 4800, 4000, 3700, 2200, 2000, 2200, 2200},
	467: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	37: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	508: []int64{1200, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100,
		1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1200, 1200, 1200, 1200, 1200,
		1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1400, 1500, 1500, 1600, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
		1600, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500},
	90: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	404: []int64{34, 25, 29, 30, 28, 26, 24, 24, 25, 31, 27, 27, 27, 26, 26, 30, 30, 29, 37, 34, 35, 27, 27, 38, 32, 22, 26, 29, 25, 27,
		31, 22, 23, 29, 24, 27, 24, 25, 29, 30, 24, 24, 27, 23, 24, 26, 26, 26, 26, 24, 27, 26, 24, 24, 26, 27, 23, 22, 23, 25,
		32, 25, 25, 31, 27, 28, 24, 22, 26, 26, 24, 25, 28, 24, 28, 64, 46, 45, 64, 67, 58, 48, 30, 26, 30, 28, 28, 29, 26, 29,
		34, 26, 28, 31, 25, 25, 25, 31, 25, 30},
	460: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	398: []int64{270, 288, 299, 243, 285, 298, 304, 229, 216, 228, 420, 415, 442, 276, 290, 278, 298, 307, 297, 331, 364, 338, 279, 242, 269, 289, 277, 252, 212, 203,
		212, 241, 245, 259, 320, 339, 321, 226, 215, 225, 271, 262, 253, 205, 209, 586, 942, 999, 618, 340, 311, 310, 232, 196, 212, 260, 266, 249, 221, 215,
		235, 219, 256, 236, 309, 300, 306, 232, 214, 227, 292, 283, 270, 205, 234, 525, 750, 1023, 949, 1051, 1130, 1168, 975, 599, 363, 266, 293, 269, 229, 196,
		247, 283, 294, 238, 295, 333, 341, 270, 251, 259},
	403: []int64{54000, 57600, 59800, 48600, 57000, 59600, 60800, 45800, 43200, 45600, 84000, 83000, 88400, 55200, 58000, 55600, 59600, 61400, 59400, 66200, 72800, 67600, 55800, 48400, 53800, 57800, 55400, 50400, 42400, 40600,
		42400, 48200, 49000, 51800, 64000, 67800, 64200, 45200, 43000, 45000, 54200, 52400, 50600, 41000, 41800, 117200, 188400, 199800, 123600, 68000, 62200, 62000, 46400, 39200, 42400, 52000, 53200, 49800, 44200, 43000,
		47000, 43800, 51200, 47200, 61800, 60000, 61200, 46400, 42800, 45400, 58400, 56600, 54000, 41000, 46800, 105000, 150000, 204600, 189800, 210200, 226000, 233600, 195000, 119800, 72600, 53200, 58600, 53800, 45800, 39200,
		49400, 56600, 58800, 47600, 59000, 66600, 68200, 54000, 50200, 51800},
	397: []int64{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50},
	41: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	94: []int64{341, 881, 851, 214, 263, 802, 777, 58, 661, 231, 255, 494, 192, 302, 90, 371, 709, 164, 58, 1, 511, 711, 1005, 556, 457, 869, 708, 994, 668, 826, 112, 633, 901, 345, 317, 199, 199, 168, 981, 665, 29, 436, 225, 426, 309, 333, 757, 696, 840, 210, 500, 343, 651, 717, 803, 869, 445, 907, 928, 268, 437, 583, 160, 478, 891, 471, 72, 448, 457, 499, 348, 527, 409, 731, 849, 572, 378, 33, 254, 414, 781, 322, 153, 755, 301, 583, 823, 55, 637, 233, 259, 6, 448, 217, 842, 921, 971, 419, 246, 289},
	400: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	501: []int64{2300, 2300, 2300, 2300, 4000, 4000, 4000, 1400, 1400, 2100, 5500, 5500, 5500, 2200, 2200, 2000, 2300, 2300, 2300, 4200, 4200, 4200, 1700, 2100, 2100, 2100, 1900, 1500, 1300, 1400,
		1400, 2100, 2100, 2100, 4700, 4700, 4700, 1500, 1600, 1900, 2500, 2500, 2500, 1400, 1600, 11000, 11200, 11200, 11200, 3900, 3900, 3900, 1500, 1400, 1800, 2000, 2000, 2000, 1600, 1600,
		1600, 1500, 2600, 2600, 3700, 3700, 3700, 1700, 1500, 1900, 2500, 2500, 2500, 1600, 2400, 7700, 7700, 7700, 5100, 8000, 8000, 8000, 7200, 5500, 5200, 2200, 2400, 2400, 2400, 1600,
		2300, 2300, 2300, 2100, 3700, 3700, 3700, 3400, 2400, 2400},
	498: []int64{2856065, 2856065, 2856095, 2856125, 2856125, 2856155, 2856185, 2856185, 2856215, 2856245, 2856245, 2856275, 2856305, 2856305, 2856335, 2856365, 2856365, 2856395, 2856425, 2856425, 2856455, 2856485, 2856485, 2856515, 2856545, 2856545, 2856575, 2856605, 2856605, 2856635,
		2856665, 2856665, 2856695, 2856725, 2856725, 2856755, 2856785, 2856785, 2856815, 2856845, 2856845, 2856875, 2856905, 2856905, 2856935, 2856965, 2856965, 2856995, 2857025, 2857025, 2857055, 2857085, 2857085, 2857115, 2857145, 2857145, 2857175, 2857205, 2857205, 2857235,
		2857265, 2857265, 2857295, 2857325, 2857325, 2857355, 2857385, 2857385, 2857415, 2857445, 2857445, 2857475, 2857505, 2857505, 2857535, 2857565, 2857565, 2857595, 2857625, 2857625, 2857655, 2857685, 2857685, 2857715, 2857745, 2857745, 2857775, 2857805, 2857805, 2857835,
		2857865, 2857865, 2857895, 2857925, 2857925, 2857955, 2857985, 2857985, 2858015, 2858045},
	506: []int64{1300, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1300, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200,
		1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1300, 1300, 1300, 1300, 1300,
		1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1400, 1400, 1500, 1500, 1600, 1700, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800,
		1700, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1700, 1700},
	510: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	514: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	159: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	86: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	6: []int64{357, 278, 204, 390, 213, 241, 209, 189, 202, 280, 709, 186, 349, 219, 223, 297, 314, 247, 473, 218, 343, 197, 248, 242, 291, 278, 206, 203, 178, 187,
		227, 266, 198, 427, 298, 253, 206, 188, 204, 248, 306, 179, 196, 192, 200, 1654, 1064, 181, 346, 263, 286, 183, 190, 180, 261, 300, 201, 185, 234, 185,
		246, 278, 202, 380, 217, 262, 200, 198, 204, 259, 354, 184, 204, 192, 259, 1097, 894, 887, 1076, 933, 1165, 1037, 399, 204, 273, 263, 277, 192, 179, 189,
		335, 276, 217, 380, 251, 328, 198, 240, 270, 250},
	14: []int64{3010, 2320, 1660, 3264, 1748, 1986, 1713, 1545, 1647, 2295, 6083, 1508, 2913, 1790, 1847, 2477, 2621, 2028, 3960, 1778, 2868, 1603, 2057, 1970, 2417, 2302, 1688, 1648, 1462, 1516,
		1875, 2209, 1618, 3571, 2493, 2113, 1669, 1543, 1677, 2046, 2545, 1470, 1607, 1572, 1636, 14228, 9120, 1478, 2895, 2180, 2374, 1503, 1532, 1476, 2168, 2514, 1657, 1509, 1950, 1515,
		2036, 2321, 1643, 3190, 1773, 2165, 1639, 1617, 1654, 2143, 3004, 1479, 1672, 1570, 2106, 9318, 7534, 7434, 9078, 7821, 9839, 8745, 3350, 1693, 2242, 2204, 2282, 1564, 1447, 1541,
		2802, 2299, 1776, 3180, 2082, 2728, 1623, 1965, 2218, 2059},
	131: []int64{369, 141, 143, 106, 119, 157, 88, 127, 137, 106, 211, 225, 202, 226, 234, 920, 268, 181, 204, 241, 219, 168, 221, 234, 184, 185, 236, 195, 168, 222,
		185, 189, 134, 130, 160, 122, 84, 113, 153, 95, 110, 141, 91, 108, 130, 3373, 1951, 151, 102, 158, 162, 100, 143, 122, 109, 211, 229, 173, 187, 237,
		200, 205, 241, 184, 204, 217, 182, 195, 219, 213, 211, 214, 189, 182, 245, 2671, 615, 1057, 602, 645, 747, 611, 336, 244, 118, 113, 128, 93, 94, 130,
		359, 131, 151, 94, 137, 149, 106, 109, 127, 124},
	401: []int64{9, 9, 7, 10, 7, 9, 7, 7, 7, 7, 13, 8, 14, 10, 9, 11, 10, 9, 14, 11, 13, 8, 11, 11, 12, 11, 10, 8, 7, 8,
		8, 8, 7, 12, 8, 9, 8, 7, 7, 8, 9, 7, 7, 8, 7, 28, 21, 8, 10, 9, 9, 7, 8, 6, 8, 12, 10, 8, 10, 10,
		10, 10, 9, 11, 9, 10, 7, 8, 8, 10, 12, 7, 8, 7, 10, 34, 35, 32, 37, 35, 44, 39, 17, 7, 9, 8, 8, 7, 8, 6,
		11, 10, 7, 11, 9, 9, 8, 8, 9, 9},
	24: []int64{3899, 3299, 3299, 3299, 3599, 3599, 3599, 3500, 3500, 3500, 3299, 3299, 3299, 3199, 3199, 3199, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3199, 3199, 3199, 3000, 3000,
		3000, 3399, 3399, 3399, 2899, 2899, 2899, 2899, 2899, 2899, 3199, 3199, 3199, 3500, 3500, 3500, 3099, 3099, 3099, 4000, 4000, 4000, 3099, 3099, 3099, 3199, 3199, 3199, 3000, 3000,
		3000, 2899, 2899, 2899, 2899, 2899, 2899, 3199, 3199, 3199, 3000, 3000, 3000, 3199, 3199, 3199, 3699, 3699, 3699, 3099, 3099, 3099, 3199, 3199, 3199, 3399, 3399, 3399, 3099, 3099,
		3099, 3399, 3399, 3399, 3500, 3500, 3500, 3500, 3299, 3299},
	429: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	98: []int64{10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760},
	106: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	386: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	29: []int64{10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760},
	507: []int64{2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2100, 2100, 2100, 2100, 2100, 2100, 2200, 2100, 2100, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000,
		2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2000, 2000, 2000, 2000, 2000,
		1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1800, 1800, 1900, 1900, 1900, 1900, 1900, 2400, 2600, 3800, 3900, 3900, 4000, 4200, 4200, 4200, 4200, 4200, 4200, 4200, 4200, 4200,
		4100, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000},
	33: []int64{4089444, 3460300, 3460300, 3460300, 3774872, 3774872, 3774872, 3670016, 3670016, 3670016, 3460300, 3460300, 3460300, 3355440, 3355440, 3355440, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3355440, 3355440, 3355440, 3145728, 3145728,
		3145728, 3565156, 3565156, 3565156, 3040868, 3040868, 3040868, 3040868, 3040868, 3040868, 3355440, 3355440, 3355440, 3670016, 3670016, 3670016, 3250584, 3250584, 3250584, 4194304, 4194304, 4194304, 3250584, 3250584, 3250584, 3355440, 3355440, 3355440, 3145728, 3145728,
		3145728, 3040868, 3040868, 3040868, 3040868, 3040868, 3040868, 3355440, 3355440, 3355440, 3145728, 3145728, 3145728, 3355440, 3355440, 3355440, 3879728, 3879728, 3879728, 3250584, 3250584, 3250584, 3355440, 3355440, 3355440, 3565156, 3565156, 3565156, 3250584, 3250584,
		3250584, 3565156, 3565156, 3565156, 3670016, 3670016, 3670016, 3670016, 3460300, 3460300},
	102: []int64{57856, 57760, 57760, 57760, 57664, 57664, 57664, 57888, 57888, 57888, 57904, 57904, 57808, 57920, 57920, 57920, 57952, 57952, 57952, 57856, 57856, 57856, 58000, 58000, 58000, 58016, 58016, 58016, 58032, 58032,
		57936, 57952, 57952, 57952, 57872, 57872, 57872, 57984, 57984, 57984, 57888, 57888, 57888, 57904, 57904, 57904, 57808, 57808, 57808, 57824, 57936, 57936, 58048, 58048, 58048, 57872, 57872, 57872, 57888, 57888,
		57888, 57904, 57904, 57904, 57936, 57936, 57936, 57840, 57840, 57840, 57760, 57760, 57760, 57872, 57872, 57776, 57696, 57696, 57696, 57808, 57808, 57808, 57712, 57824, 57824, 57744, 57744, 57744, 57760, 57760,
		57760, 57872, 57872, 57872, 57776, 58000, 58000, 58000, 57808, 57808},
	418: []int64{84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252},
	428: []int64{57856, 57760, 57760, 57760, 57664, 57664, 57664, 57888, 57888, 57888, 57904, 57904, 57808, 57920, 57920, 57920, 57952, 57952, 57952, 57856, 57856, 57856, 58000, 58000, 58000, 58016, 58016, 58016, 58032, 58032,
		57936, 57952, 57952, 57952, 57872, 57872, 57872, 57984, 57984, 57984, 57888, 57888, 57888, 57904, 57904, 57904, 57808, 57808, 57808, 57824, 57936, 57936, 58048, 58048, 58048, 57872, 57872, 57872, 57888, 57888,
		57888, 57904, 57904, 57904, 57936, 57936, 57936, 57840, 57840, 57840, 57760, 57760, 57760, 57872, 57872, 57776, 57696, 57696, 57696, 57808, 57808, 57808, 57712, 57824, 57824, 57744, 57744, 57744, 57760, 57760,
		57760, 57872, 57872, 57872, 57776, 58000, 58000, 58000, 57808, 57808},
	420: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	423: []int64{10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208},
	105: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	107: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	515: []int64{160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160},
	13: []int64{36563, 37352, 38027, 36325, 37964, 37547, 37994, 38163, 38047, 37327, 33506, 38166, 36687, 37878, 37787, 37009, 36970, 37616, 35525, 37828, 36681, 38041, 37565, 37560, 37119, 37335, 37939, 38025, 38231, 38159,
		37762, 32473, 38087, 35903, 37253, 37333, 38034, 38145, 37983, 37582, 37150, 38257, 38040, 38141, 38094, 24973, 30358, 38203, 36612, 37602, 37267, 38196, 38139, 38252, 37496, 37127, 38015, 38190, 37655, 38163,
		37575, 37335, 38040, 36407, 37874, 37506, 38043, 38091, 38034, 37519, 36656, 38197, 38011, 38107, 37491, 29567, 31711, 31815, 29910, 31346, 29216, 30433, 36241, 37986, 37356, 37431, 37356, 38137, 38201, 38167,
		36801, 37359, 37886, 36408, 37599, 36921, 38071, 37686, 37479, 37595},
	502: []int64{1100, 1100, 1200, 900, 1100, 1200, 1200, 900, 800, 900, 1700, 1600, 1700, 1000, 1100, 1100, 1200, 1200, 1200, 1300, 1400, 1300, 1100, 900, 1000, 1100, 1100, 1000, 800, 800,
		800, 900, 1000, 1000, 1300, 1400, 1300, 900, 800, 900, 1000, 1000, 1000, 800, 800, 2400, 3900, 4100, 2600, 1400, 1200, 1200, 900, 800, 800, 1000, 1100, 1000, 900, 800,
		900, 900, 1000, 900, 1200, 1200, 1200, 900, 800, 900, 1100, 1100, 1100, 800, 900, 2000, 2900, 4100, 3800, 4200, 4500, 4700, 3900, 2400, 1400, 1000, 1100, 1100, 900, 800,
		1000, 1100, 1200, 900, 1200, 1300, 1400, 1100, 1000, 1000},
	74: []int64{961, 1016, 502, 571, 475, 122, 219, 937, 428, 657, 356, 987, 332, 469, 465, 216, 708, 984, 519, 696, 420, 994, 454, 7, 223, 559, 320, 521, 632, 18, 280, 144, 48, 994, 584, 555, 665, 944, 831, 135, 40, 851, 210, 440, 679, 569, 908, 745, 552, 125, 783, 877, 317, 895, 458, 999, 50, 288, 600, 729, 716, 441, 713, 800, 378, 440, 225, 226, 384, 588, 982, 393, 736, 817, 453, 644, 255, 92, 671, 81, 586, 1019, 286, 247, 781, 524, 765, 762, 217, 941, 595, 478, 597, 294, 648, 327, 1019, 706, 826, 813},
	85: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	465: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	464: []int64{51, 34, 48, 60, 36, 43, 41, 36, 38, 45, 35, 40, 44, 36, 35, 50, 35, 33, 40, 37, 41, 44, 35, 41, 42, 36, 31, 43, 44, 45,
		42, 45, 46, 37, 40, 41, 46, 43, 32, 49, 42, 36, 34, 43, 29, 47, 38, 42, 41, 37, 40, 37, 43, 33, 39, 38, 49, 31, 43, 46,
		40, 39, 34, 51, 39, 51, 45, 49, 41, 36, 34, 34, 45, 42, 45, 271, 410, 524, 558, 291, 176, 92, 43, 62, 36, 46, 40, 39, 34, 40,
		39, 38, 49, 34, 41, 51, 44, 29, 47, 37},
	396: []int64{117, 89, 89, 113, 87, 124, 84, 85, 88, 107, 113, 88, 146, 47, 101, 132, 106, 97, 139, 104, 118, 95, 95, 119, 119, 92, 91, 89, 85, 91,
		100, 84, 85, 141, 76, 152, 84, 88, 97, 103, 87, 77, 99, 82, 78, 199, 133, 90, 135, 71, 94, 85, 92, 79, 95, 92, 83, 80, 99, 81,
		101, 91, 83, 108, 95, 91, 89, 83, 87, 102, 80, 90, 89, 92, 111, 292, 202, 205, 276, 225, 253, 223, 111, 89, 111, 100, 102, 86, 95, 83,
		110, 93, 93, 114, 89, 106, 80, 99, 87, 98},
	426: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	427: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	125: []int64{411, 198, 152, 119, 134, 183, 96, 143, 144, 119, 279, 259, 494, 316, 261, 995, 366, 240, 253, 327, 346, 285, 400, 430, 345, 356, 410, 230, 194, 243,
		211, 231, 144, 176, 185, 186, 93, 135, 160, 113, 129, 151, 107, 127, 135, 3497, 2048, 176, 121, 178, 191, 129, 165, 133, 122, 351, 385, 322, 367, 410,
		336, 279, 315, 251, 253, 255, 194, 223, 238, 249, 270, 233, 210, 200, 273, 2808, 755, 1175, 739, 910, 993, 861, 451, 287, 144, 130, 135, 130, 183, 146,
		404, 178, 200, 108, 185, 184, 159, 126, 135, 150},
	11: []int64{36582, 37370, 38034, 36337, 37967, 37562, 38002, 38168, 38054, 37329, 33533, 38186, 36723, 37909, 37798, 37050, 37006, 37642, 35547, 37852, 36713, 38071, 37616, 37615, 37164, 37383, 37993, 38045, 38247, 38169,
		37776, 37500, 38095, 35924, 37261, 37351, 38038, 38160, 37990, 37591, 37158, 38263, 38047, 38148, 38100, 25033, 30406, 38214, 36618, 37614, 37277, 38207, 38152, 38261, 37506, 37169, 38060, 38221, 37703, 38210,
		37614, 37369, 38078, 36434, 37898, 37522, 38051, 38104, 38049, 37544, 36685, 38214, 38024, 38116, 37515, 29627, 31741, 31857, 29938, 31389, 29257, 30473, 36265, 38002, 37366, 37444, 37365, 38149, 38225, 38177,
		36823, 37378, 37901, 36420, 37620, 36931, 38085, 37698, 37484, 37604},
	516: []int64{6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000},
	462: []int64{218, 203, 246, 299, 225, 245, 202, 203, 246, 416, 205, 243, 220, 203, 246, 337, 203, 256, 315, 219, 264, 203, 203, 259, 416, 203, 246, 203, 202, 245,
		203, 203, 245, 308, 215, 245, 203, 203, 246, 415, 203, 245, 203, 203, 245, 427, 203, 244, 308, 216, 245, 202, 203, 245, 416, 203, 246, 202, 203, 245,
		203, 203, 245, 306, 217, 245, 202, 203, 246, 416, 202, 245, 202, 203, 259, 510, 462, 659, 772, 808, 928, 1177, 384, 260, 416, 203, 260, 203, 202, 245,
		218, 203, 245, 306, 217, 259, 203, 216, 260, 416},
	417: []int64{2726296, 2411724, 2411724, 2411724, 2831152, 2831152, 2831152, 2726296, 2726296, 2726296, 2411724, 2411724, 2411724, 2621440, 2621440, 2621440, 2306864, 2306864, 2306864, 2306864, 2306864, 2306864, 2411724, 2411724, 2411724, 2516580, 2516580, 2516580, 2202008, 2202008,
		2202008, 2516580, 2516580, 2516580, 2097152, 2097152, 2097152, 2097152, 2306864, 2411724, 2726296, 2726296, 2726296, 2411724, 2411724, 2411724, 2306864, 2306864, 2306864, 3145728, 3145728, 3145728, 2306864, 2306864, 2306864, 2411724, 2411724, 2411724, 2306864, 2306864,
		2306864, 2097152, 2202008, 2306864, 2306864, 2306864, 2621440, 2621440, 2621440, 2621440, 2411724, 2411724, 2411724, 2621440, 2621440, 2621440, 2936012, 2936012, 2936012, 2621440, 2621440, 2726296, 2726296, 2726296, 2726296, 2516580, 2516580, 2516580, 2621440, 2621440,
		2621440, 2936012, 2936012, 2936012, 2516580, 2516580, 2516580, 2516580, 2306864, 2306864},
	157: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	406: []int64{942, 615, 308, 1003, 67, 638, 951, 442, 100, 350, 477, 964, 469, 905, 622, 523, 679, 130, 457, 208, 710, 905, 781, 740, 608, 254, 286, 483, 205, 929, 88, 936, 730, 832, 144, 658, 558, 306, 19, 920, 254, 804, 458, 370, 328, 655, 43, 165, 653, 310, 369, 705, 188, 238, 170, 948, 535, 209, 293, 971, 787, 245, 377, 767, 807, 324, 896, 109, 178, 928, 954, 312, 26, 831, 816, 646, 159, 232, 997, 820, 387, 128, 28, 582, 1010, 705, 662, 815, 830, 946, 750, 637, 600, 847, 732, 566, 562, 406, 311, 609},
	513: []int64{1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1800, 1800, 1900, 1900, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
		1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 1900, 1900, 1900, 1900, 1900,
		1800, 1700, 1800, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 2200, 2500, 3600, 3700, 3800, 3900, 3900, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
		3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900, 3900},
	512: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	461: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	10: []int64{740, 967, 600, 858, 667, 588, 488, 323, 834, 600, 49, 486, 867, 163, 219, 532,
		224, 115, 377, 80, 671, 327, 77, 8, 995, 831, 594, 326, 595, 182, 152, 195, 897, 924, 995,
		393, 126, 296, 678, 494, 752, 198, 199, 184, 412, 600, 19, 454, 605, 481, 456, 54, 487,
		395, 24, 859, 670, 710, 339, 232, 300, 941, 187, 190, 779, 127, 252, 304, 580, 823, 30,
		43, 3, 30, 523, 670, 499, 474, 962, 588, 300, 978, 338, 772, 212, 435, 920, 958, 533, 650,
		39, 668, 185, 124, 851, 226, 356, 594, 247, 194},
	12: []int64{137, 101, 116, 123, 114, 107, 96, 96, 103, 124, 111, 109, 108, 106, 106, 124, 122, 117, 149, 137, 141, 109, 110, 154, 128, 88, 107, 119, 102, 108,
		125, 91, 95, 116, 97, 108, 100, 103, 119, 122, 97, 99, 108, 94, 97, 106, 105, 106, 107, 98, 111, 105, 97, 98, 106, 111, 94, 90, 95, 100,
		131, 100, 103, 125, 108, 112, 97, 91, 107, 106, 98, 102, 116, 96, 112, 257, 186, 182, 259, 271, 232, 196, 123, 107, 122, 112, 114, 118, 104, 116,
		139, 107, 112, 126, 103, 103, 101, 125, 101, 122},
}

var HostMetricData = map[int32][]int64{
	540: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	193: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11,
		10, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 0, 0, 10, 10,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	538: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	442: []int64{558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 558345748480, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304,
		559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304,
		559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304,
		559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304,
		559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304, 559419490304,
	},
	184: []int64{6, 7, 24, 10, 12, 10, 11, 11, 15, 9, 6, 11, 10, 11, 11, 15, 14, 24, 8, 15,
		11, 14, 8, 9, 13, 11, 10, 10, 10, 8, 14, 11, 13, 15, 16, 13, 10, 12, 16, 16,
		13, 14, 11, 11, 13, 14, 11, 11, 11, 10, 8, 13, 16, 16, 10, 15, 9, 10, 10, 9,
		12, 10, 15, 10, 11, 19, 11, 11, 18, 11, 10, 10, 9, 13, 8, 11, 8, 12, 10, 10,
		11, 18, 12, 14, 14, 8, 11, 13, 11, 24, 12, 14, 18, 10, 13, 15, 13, 12, 20, 11,
	},
	417: []int64{4209028, 4597196, 4911776, 4890868, 4716732, 4949160, 5618444, 5299588, 5939276, 5373040, 5444172, 5360296, 6744416, 6827536, 6208836, 6481460, 6483476, 6441596, 6315764, 6396904,
		6292044, 6313012, 6319280, 6245880, 5176316, 5171796, 5486372, 5402552, 5406000, 5059972, 4956844, 5174332, 5447028, 5153364, 5147720, 4403340, 4361368, 4369400, 4862164, 4946880,
		4994708, 5517376, 5999716, 5998864, 5380208, 4834948, 4838024, 4282212, 4177360, 4330364, 4582024, 5022488, 5030444, 4881924, 5007848, 5085540, 5012204, 5012144, 5036856, 4942480,
		4187564, 4228672, 4155256, 4134280, 4132984, 4299164, 4445960, 4453264, 4159664, 4390344, 4383672, 4415064, 4918376, 4918656, 5222744, 5222808, 5225088, 4616912, 4218456, 4215328,
		4351644, 4812948, 4976436, 4494096, 4726508, 4721272, 5235008, 4857516, 4855644, 5054940, 4740304, 4796812, 4543444, 4312760, 4351020, 4560668, 5084960, 5092936, 5260772, 5072024,
	},
	465: []int64{135, 62, 9, 25, 9, 16, 8, 10, 3, 7, 12, 8, 13, 5, 13, 6, 13, 2, 12, 10,
		7, 9, 7, 19, 6, 10, 7, 12, 8, 4, 13, 14, 14, 1, 13, 12, 7, 1, 8, 14,
		13, 9, 3, 12, 8, 2, 5, 9, 17, 5, 13, 7, 15, 10, 5, 13, 10, 18, 6, 15,
		6, 17, 3, 6, 8, 8, 12, 9, 11, 3, 18, 7, 4, 1, 12, 10, 11, 7, 12, 16,
		5, 3, 1, 24, 11, 9, 11, 18, 12, 1, 8, 10, 15, 4, 11, 11, 12, 10, 2, 6,
	},
	445: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	158: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	516: []int64{6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
	},
	9: []int64{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	},
	433: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	464: []int64{208, 119, 77, 99, 67, 76, 74, 62, 67, 73, 64, 72, 87, 61, 69, 96, 75, 56, 82, 62,
		77, 80, 57, 72, 88, 70, 61, 70, 76, 70, 67, 72, 76, 65, 71, 62, 81, 63, 58, 76,
		94, 99, 101, 104, 104, 107, 97, 57, 87, 63, 69, 75, 83, 56, 69, 81, 88, 84, 76, 71,
		70, 115, 47, 74, 76, 64, 98, 77, 72, 65, 80, 63, 72, 61, 64, 62, 91, 65, 58, 78,
		73, 63, 63, 84, 73, 79, 67, 68, 78, 73, 62, 68, 83, 56, 79, 71, 77, 94, 68, 56,
	},
	461: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	460: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	469: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	468: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	463: []int64{4529, 3139, 976, 1336, 1328, 854, 781, 678, 587, 874, 1296, 1092, 914, 657, 662, 862, 671, 1366, 724, 1384,
		595, 753, 766, 696, 697, 925, 1215, 579, 700, 644, 730, 595, 857, 1243, 1059, 1037, 937, 644, 449, 627,
		1002, 871, 626, 661, 594, 576, 543, 608, 1409, 1306, 579, 720, 479, 592, 641, 1576, 654, 660, 555, 648,
		606, 457, 580, 633, 1730, 985, 797, 451, 559, 768, 864, 1020, 638, 608, 641, 467, 622, 466, 687, 1507,
		542, 1115, 609, 472, 634, 1398, 556, 589, 730, 544, 625, 679, 525, 480, 1496, 1446, 1136, 683, 507, 704,
	},
	159: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	147: []int64{98787, 64540, 12850, 14793, 13898, 11584, 9842, 9220, 8157, 13929, 14763, 16435, 10855, 10541, 13461, 9241, 8298, 13911, 9665, 13714,
		8106, 9184, 9718, 10730, 11620, 10779, 18429, 7382, 10814, 13398, 8824, 8072, 9910, 12595, 10950, 11917, 12508, 8644, 6052, 10230,
		11355, 13255, 8252, 10033, 11957, 6777, 7435, 8673, 14327, 13369, 8016, 9588, 6494, 8082, 9718, 14035, 11684, 8576, 9269, 13208,
		7808, 6503, 7587, 8385, 16944, 11698, 10462, 6446, 7489, 10736, 11891, 15393, 8347, 9696, 12891, 6261, 8374, 6976, 8981, 15365,
		7323, 12960, 8301, 6383, 7699, 17905, 10476, 7616, 11062, 12148, 7518, 8798, 7209, 6363, 15726, 15193, 13103, 9463, 6583, 8581,
	},
	2: []int64{5216, 6422, 2301, 2399, 3513, 3670, 2479, 2777, 1948, 2395, 4382, 3535, 2610, 2991, 2086, 2249, 2980, 4164, 2341, 4394,
		2166, 2374, 2577, 3321, 2379, 3581, 2061, 2313, 3196, 3493, 2299, 2811, 2994, 2399, 3526, 3718, 2327, 3588, 2037, 2313,
		3351, 3459, 2269, 2940, 2039, 2267, 2935, 3661, 3132, 3684, 2261, 2318, 2543, 3373, 2315, 4170, 2265, 2348, 2654, 3427,
		2311, 2576, 2225, 3184, 4171, 3686, 2190, 2765, 2177, 2133, 3559, 3530, 2178, 3213, 2475, 2133, 2728, 3443, 2390, 4531,
		2388, 2188, 3001, 3636, 2125, 3588, 2281, 2203, 2861, 3476, 2124, 2860, 2463, 2142, 4806, 4150, 2169, 2695, 2160, 2194,
	},
	146: []int64{123085, 81730, 23478, 30517, 31220, 22570, 18686, 17187, 15034, 23327, 30538, 29852, 21611, 17841, 20520, 19804, 16652, 32333, 17640, 31898,
		15354, 17755, 19085, 17827, 19017, 22028, 30619, 14066, 18751, 21221, 17486, 15365, 20671, 27904, 24811, 25645, 22882, 16383, 11545, 17083,
		23937, 24473, 15364, 17625, 18616, 13334, 14162, 16791, 31671, 30553, 15054, 17695, 12414, 15992, 16789, 29615, 19038, 16113, 15550, 21144,
		14848, 12167, 14642, 15589, 39685, 24791, 19349, 12091, 14397, 18326, 22628, 28263, 15711, 16693, 20002, 11595, 15951, 13324, 16702, 34960,
		13979, 26177, 15704, 12997, 14929, 35171, 16772, 14289, 19393, 18969, 14908, 17101, 13600, 11905, 35064, 34309, 26614, 17578, 12759, 16810,
	},
	348: []int64{36000, 39300, 34400, 24500, 17700, 17700, 20100, 18600, 17100, 14600, 18300, 19200, 22300, 18700, 18300, 15100, 14800, 17300, 19600, 22900,
		20700, 18500, 14800, 15100, 17100, 19200, 18500, 16400, 15400, 16400, 18700, 18100, 18800, 16900, 18300, 17900, 19900, 20100, 18600, 16200,
		15800, 16700, 18900, 17900, 17300, 15000, 15000, 15600, 20300, 21400, 21600, 17100, 15000, 14800, 16900, 20700, 20400, 18300, 14900, 15500,
		17400, 17400, 16800, 16600, 19400, 20800, 20900, 18200, 16900, 14600, 16300, 16700, 19100, 17900, 18600, 16200, 15600, 14800, 17600, 21500,
		21700, 18900, 15200, 16100, 18200, 19900, 18600, 16700, 15100, 15400, 17600, 17300, 17100, 15400, 19400, 21300, 23000, 19100, 16300, 14500,
	},
	386: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	106: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	24: []int64{9387, 9390, 9388, 9389, 9389, 9387, 9388, 9389, 9388, 9389, 9390, 9388, 9389, 9390, 9390, 9392, 9391, 9390, 9388, 9388,
		9387, 9387, 9387, 9387, 9388, 9387, 9388, 9389, 9389, 9387, 9389, 9388, 9389, 9391, 9390, 9388, 9391, 9391, 9390, 9391,
		9392, 9388, 9388, 9387, 9388, 9388, 9388, 9389, 9388, 9388, 9389, 9388, 9389, 9388, 9389, 9388, 9389, 9391, 9389, 9388,
		9390, 9390, 9390, 9391, 9392, 9388, 9387, 9388, 9388, 9388, 9389, 9389, 9388, 9388, 9388, 9388, 9389, 9388, 9389, 9388,
		9388, 9390, 9390, 9390, 9390, 9389, 9391, 9390, 9391, 9388, 9389, 9388, 9388, 9388, 9388, 9390, 9388, 9388, 9388, 9389,
	},
	437: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	45: []int64{28758744, 28759192, 28759660, 28759688, 28759572, 28759656, 28759684, 28761964, 28759664, 28759716, 28761648, 28759596, 28759636, 28759652, 28761712, 28759628, 28761824, 28759660, 28759796, 28757672,
		28757696, 28757860, 28757692, 28757724, 28757712, 28757712, 28757672, 28757636, 28757652, 28757676, 28759828, 28757608, 28759684, 28757684, 28757700, 28757636, 28757712, 28759704, 28757676, 28757744,
		28757724, 28757648, 28757612, 28759848, 28759680, 28757680, 28759756, 28757808, 28757728, 28757740, 28757692, 28757724, 28759696, 28757752, 28757724, 28757660, 28757780, 28757660, 28759676, 28759784,
		28757752, 28759700, 28757688, 28757732, 28759700, 28757704, 28757668, 28757740, 28757676, 28759832, 28759628, 28759764, 28757720, 28757768, 28759680, 28757736, 28759712, 28757656, 28757668, 28759776,
		28757676, 28757652, 28759768, 28757724, 28757724, 28759676, 28759792, 28757680, 28757648, 28759740, 28757764, 28759876, 28757660, 28757652, 28759624, 28757780, 28759724, 28757648, 28759732, 28757768,
	},
	515: []int64{160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
	},
	512: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	504: []int64{38200, 40700, 40700, 40700, 40700, 40700, 41100, 41100, 41100, 41100, 41100, 41100, 41100, 41100, 41100, 40700, 26800, 26800, 27100, 31600,
		31600, 30600, 30600, 30600, 31600, 31600, 31600, 30600, 30600, 30600, 31600, 31600, 31600, 30600, 27000, 27400, 27500, 34800, 34800, 27500,
		27500, 27500, 36500, 36500, 36500, 27500, 27700, 27700, 36500, 36500, 36500, 28100, 27700, 27700, 28100, 28100, 28100, 27700, 27700, 27700,
		28100, 28100, 28100, 27700, 27700, 27700, 35000, 35000, 35000, 27700, 27600, 27600, 35000, 35000, 35000, 27600, 27600, 27600, 35400, 35400,
		35400, 29100, 29100, 29100, 34300, 34300, 34300, 29100, 29100, 29100, 34300, 34300, 34300, 29100, 26300, 27900, 34300, 34300, 34300, 27900,
	},
	509: []int64{56300, 56300, 56300, 45300, 26500, 26500, 40200, 40200, 40200, 23400, 45700, 45700, 45700, 39900, 39900, 23200, 20800, 25700, 36300, 36300,
		36300, 31100, 19300, 21900, 34300, 36700, 36700, 36700, 23100, 23100, 37900, 37900, 37900, 27000, 27000, 26900, 36700, 36700, 36700, 36100,
		36900, 36900, 36900, 36100, 36100, 26200, 27300, 27300, 44400, 44400, 44400, 27500, 20500, 21400, 35500, 44500, 44500, 44500, 22100, 22800,
		34600, 34600, 34600, 25500, 35300, 35300, 35300, 35000, 35000, 21300, 40300, 40300, 40300, 36600, 36600, 25400, 21400, 22000, 36200, 39900,
		39900, 39900, 22900, 22700, 33900, 37000, 37000, 37000, 21900, 23000, 36800, 36800, 36800, 19300, 41300, 41300, 41300, 35100, 35100, 19400,
	},
	13: []int64{55854, 44019, 91548, 91238, 77451, 76086, 89967, 87066, 96253, 92136, 66625, 77627, 88722, 83963, 94854, 93093, 84480, 69900, 91799, 67236,
		94009, 91442, 89091, 80204, 91615, 76760, 95271, 92658, 81344, 78020, 92539, 86149, 84145, 91137, 77621, 75411, 92107, 76879, 95544, 92520,
		79654, 78532, 92752, 84539, 95566, 92740, 84839, 77042, 81463, 75690, 92934, 92048, 89801, 79319, 92435, 69706, 92835, 92971, 86952, 78964,
		92614, 88676, 93272, 81870, 70002, 75928, 93396, 86942, 93717, 94338, 77321, 77673, 93967, 81264, 90382, 94398, 87290, 78692, 91395, 65516,
		91277, 94100, 83600, 76785, 94306, 76729, 92706, 93455, 85740, 78369, 94379, 85854, 90241, 94306, 62269, 70322, 93958, 87650, 94017, 93690,
	},
	505: []int64{23500, 24800, 24900, 24400, 24500, 24600, 25000, 25000, 24800, 24300, 23900, 23100, 22500, 21700, 20600, 18700, 17200, 17500, 17900, 18200,
		18100, 17600, 17500, 17700, 18100, 17700, 17600, 16900, 17000, 17200, 17600, 17700, 17500, 17100, 16800, 16900, 17400, 17800, 17600, 17200,
		17100, 17300, 17700, 17700, 17500, 17000, 17100, 16800, 17700, 17700, 17600, 17100, 16700, 16800, 17200, 17600, 17500, 17100, 17000, 17200,
		17600, 17500, 17400, 16900, 17100, 17200, 17600, 17700, 17600, 17100, 16900, 16900, 17300, 17400, 17600, 17100, 17100, 17200, 17300, 17500,
		17400, 16900, 16900, 17200, 17600, 17600, 17600, 17100, 17100, 16900, 17400, 17400, 17400, 17000, 17000, 17300, 17800, 17800, 17400, 17100,
	},
	157: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	388: []int64{3105, 3888, 1350, 1391, 1943, 2053, 1406, 1570, 1178, 1412, 2542, 1997, 1490, 1658, 1236, 1322, 1652, 2219, 1353, 2397,
		1273, 1376, 1460, 1857, 1389, 1993, 1231, 1352, 1761, 1961, 1336, 1574, 1686, 1385, 1931, 2030, 1380, 1954, 1204, 1366,
		1914, 1933, 1344, 1689, 1211, 1340, 1675, 2101, 1748, 2028, 1313, 1347, 1464, 1886, 1343, 2403, 1305, 1391, 1532, 1920,
		1358, 1480, 1282, 1788, 2261, 2023, 1288, 1576, 1283, 1278, 2002, 1949, 1281, 1796, 1411, 1240, 1552, 1909, 1384, 2483,
		1373, 1301, 1690, 1967, 1258, 2017, 1337, 1282, 1629, 1965, 1253, 1619, 1390, 1271, 2614, 2221, 1286, 1563, 1253, 1296,
	},
	155: []int64{2950229, 2950250, 2950269, 2950289, 2950309, 2950329, 2950349, 2950369, 2950389, 2950409, 2950429, 2950449, 2950469, 2950489, 2950509, 2950529, 2950549, 2950569, 2950589, 2950609,
		2950629, 2950649, 2950669, 2950689, 2950709, 2950729, 2950749, 2950769, 2950789, 2950809, 2950829, 2950849, 2950869, 2950889, 2950909, 2950929, 2950949, 2950969, 2950989, 2951009,
		2951029, 2951049, 2951069, 2951089, 2951109, 2951129, 2951149, 2951169, 2951189, 2951209, 2951229, 2951249, 2951269, 2951289, 2951309, 2951329, 2951349, 2951369, 2951389, 2951409,
		2951429, 2951449, 2951469, 2951489, 2951509, 2951529, 2951549, 2951569, 2951589, 2951609, 2951629, 2951649, 2951669, 2951689, 2951709, 2951729, 2951749, 2951769, 2951789, 2951809,
		2951829, 2951849, 2951869, 2951889, 2951909, 2951929, 2951949, 2951969, 2951989, 2952009, 2952029, 2952049, 2952069, 2952089, 2952109, 2952129, 2952149, 2952169, 2952189, 2952209,
	},
	404: []int64{46, 54, 34, 33, 37, 37, 35, 35, 33, 34, 43, 38, 34, 35, 34, 33, 35, 39, 33, 41,
		33, 34, 34, 37, 33, 37, 33, 33, 36, 37, 34, 35, 35, 33, 37, 37, 33, 37, 33, 33,
		39, 37, 34, 35, 33, 34, 36, 39, 37, 36, 34, 33, 34, 37, 33, 41, 33, 34, 34, 37,
		34, 34, 34, 35, 39, 38, 33, 36, 33, 33, 39, 37, 32, 34, 34, 32, 35, 37, 33, 41,
		34, 33, 35, 38, 33, 39, 33, 32, 35, 38, 34, 35, 34, 33, 42, 38, 33, 35, 32, 33,
	},
	65: []int64{30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429,
		30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429,
		30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429,
		30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429,
		30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429, 30429,
	},
	130: []int64{316, 288, 31, 17, 70, 78, 8, 5, 13, 172, 8, 9, 234, 84, 286, 107, 42, 15, 10, 48,
		9, 10, 16, 4, 410, 8, 11, 141, 85, 283, 12, 9, 12, 21, 45, 572, 19, 14, 2, 147,
		46, 9, 139, 84, 280, 9, 26, 8, 14, 42, 15, 13, 7, 10, 93, 76, 16, 143, 82, 287,
		6, 6, 311, 20, 82, 34, 7, 6, 21, 45, 137, 16, 146, 83, 286, 4, 9, 5, 8, 69,
		20, 3, 18, 8, 8, 173, 9, 139, 84, 274, 8, 11, 8, 3, 76, 61, 7, 4, 7, 11,
	},
	395: []int64{7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125,
		7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125,
		7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125,
		7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125,
		7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125, 7125,
	},
	392: []int64{5078, 6147, 2371, 2453, 3400, 3565, 2486, 2777, 2066, 2456, 4110, 3436, 2636, 2944, 2164, 2343, 2932, 3939, 2400, 4162,
		2265, 2439, 2599, 3240, 2426, 3443, 2166, 2371, 3127, 3394, 2360, 2783, 2950, 2453, 3410, 3576, 2426, 3452, 2126, 2400,
		3267, 3362, 2360, 2936, 2128, 2354, 2927, 3557, 3062, 3562, 2314, 2387, 2586, 3303, 2373, 4038, 2320, 2400, 2680, 3332,
		2385, 2613, 2275, 3132, 3966, 3540, 2273, 2756, 2272, 2243, 3406, 3411, 2261, 3155, 2512, 2207, 2731, 3332, 2445, 4277,
		2437, 2283, 2981, 3481, 2221, 3463, 2373, 2266, 2858, 3371, 2216, 2854, 2473, 2251, 4489, 3926, 2268, 2721, 2224, 2289,
	},
	168: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11,
		10, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 0, 0, 10, 10,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	11: []int64{3767685, 3766843, 3809485, 3802123, 3797075, 3794283, 3804460, 3803343, 3813172, 3813480, 3772726, 3795530, 3803912, 3801956, 3811636, 3811586, 3804529, 3783666, 3808189, 3783649,
		3810947, 3809723, 3804999, 3797668, 3808199, 3790673, 3812824, 3820071, 3791344, 3794066, 3807934, 3802632, 3800437, 3809786, 3796352, 3794083, 3808300, 3791286, 3812957, 3812179,
		3791058, 3797110, 3807338, 3801842, 3812268, 3809965, 3800048, 3796279, 3792819, 3795748, 3808166, 3810005, 3805475, 3797880, 3807963, 3786534, 3811175, 3821127, 3793409, 3798201,
		3808581, 3802765, 3811096, 3799097, 3788026, 3799350, 3803446, 3802916, 3810034, 3812160, 3790129, 3797411, 3810431, 3802124, 3804558, 3812784, 3803386, 3796951, 3809341, 3779330,
		3808717, 3819583, 3792378, 3799161, 3805583, 3790405, 3809761, 3812506, 3802618, 3794905, 3810449, 3803410, 3806050, 3812196, 3778959, 3789793, 3809308, 3803093, 3812233, 3810652,
	},
	443: []int64{35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
	},
	6: []int64{5946, 7321, 2624, 2735, 4005, 4184, 2826, 3166, 2221, 2730, 4996, 4030, 2975, 3409, 2378, 2563, 3397, 4747, 2668, 5009,
		2469, 2706, 2937, 3786, 2712, 4082, 2349, 2636, 3644, 3982, 2621, 3204, 3413, 2735, 4019, 4238, 2652, 4090, 2322, 2636,
		3820, 3943, 2586, 3351, 2325, 2584, 3346, 4173, 3570, 4200, 2577, 2642, 2899, 3845, 2639, 4753, 2582, 2676, 3025, 3906,
		2634, 2936, 2536, 3630, 4755, 4202, 2497, 3152, 2481, 2431, 4057, 4024, 2482, 3663, 2821, 2432, 3109, 3924, 2725, 5164,
		2722, 2494, 3421, 4145, 2423, 4090, 2600, 2511, 3261, 3962, 2421, 3260, 2808, 2441, 5479, 4731, 2472, 3072, 2462, 2501,
	},
	33: []int64{10290632, 11098228, 10794144, 10521580, 10347364, 10695132, 11637048, 11150420, 11454568, 10951244, 11043428, 11578212, 13717308, 13716504, 13286552, 12971972, 12974028, 12690972, 12376396, 12373608,
		11828348, 12247780, 12254008, 12316920, 11121524, 11200932, 12060768, 11851116, 11854604, 10879428, 11342532, 11360752, 11727820, 10700152, 10694468, 10159800, 10054908, 10241236, 10178260, 10304924,
		10468096, 11231940, 12406340, 12405528, 11430352, 10276920, 10279996, 9986332, 10070220, 10107804, 10862772, 10757980, 10765936, 10009244, 10407800, 10401684, 10118624, 10915480, 10919140, 11076432,
		10321520, 10320684, 9964144, 9125280, 9124024, 9374092, 9856432, 9863736, 9674992, 9779840, 9773128, 9909380, 10349780, 10350060, 10245204, 10580816, 10583136, 10163740, 9324880, 9321712,
		9709688, 10296824, 10565128, 10061812, 10923364, 10918128, 11400412, 11463328, 11461496, 11702728, 10570204, 10574244, 10278936, 9943392, 10002624, 9834784, 10233244, 10241220, 10702656, 10975280,
	},
	502: []int64{33600, 36700, 32300, 23200, 17300, 17300, 19600, 18200, 16700, 14200, 17800, 18700, 21800, 18300, 17900, 14700, 14400, 16900, 19200, 22500,
		20200, 18100, 14400, 14700, 16700, 18800, 18000, 16000, 15000, 16000, 18200, 17600, 18500, 16500, 17900, 17500, 19500, 19700, 18200, 15900,
		15500, 16300, 18500, 17500, 16900, 14600, 14700, 15200, 19800, 21000, 21200, 16700, 14700, 14400, 16500, 20200, 19900, 17800, 14500, 15000,
		17000, 17000, 16400, 16300, 19000, 20300, 20400, 17800, 16500, 14200, 16000, 16400, 18700, 17500, 18200, 15800, 15300, 14400, 17200, 21100,
		21300, 18500, 14800, 15700, 17800, 19500, 18200, 16300, 14700, 15000, 17200, 16900, 16800, 15100, 19000, 20900, 22600, 18700, 16000, 14200,
	},
	398: []int64{4356, 5034, 4468, 3401, 2288, 2406, 2883, 2712, 2439, 1928, 2642, 2820, 3379, 2703, 2553, 1991, 1938, 2455, 2883, 3400,
		2975, 2578, 1995, 2048, 2392, 2812, 2666, 2288, 2063, 2214, 2659, 2557, 2750, 2376, 2528, 2437, 2805, 2980, 2707, 2225,
		2182, 2358, 2755, 2530, 2380, 1957, 2023, 2150, 3032, 3112, 3147, 2296, 2036, 1989, 2390, 2899, 2844, 2439, 1948, 2022,
		2420, 2452, 2363, 2208, 2725, 2987, 3167, 2630, 2376, 1947, 2269, 2352, 2773, 2506, 2630, 2191, 2121, 1983, 2441, 3127,
		3164, 2729, 2059, 2244, 2625, 2947, 2693, 2299, 1996, 2047, 2488, 2443, 2434, 2079, 2719, 3087, 3410, 2790, 2272, 1937,
	},
	466: []int64{147, 79, 116, 164, 105, 79, 86, 90, 122, 152, 122, 96, 99, 84, 80, 116, 115, 88, 100, 79,
		76, 128, 122, 79, 84, 78, 81, 104, 104, 94, 116, 138, 82, 106, 93, 110, 112, 80, 82, 116,
		124, 111, 82, 82, 74, 100, 84, 145, 114, 74, 74, 172, 106, 150, 109, 76, 122, 132, 122, 78,
		135, 102, 74, 158, 108, 74, 121, 144, 74, 132, 124, 82, 211, 154, 127, 142, 84, 76, 115, 96,
		76, 128, 84, 72, 116, 157, 96, 126, 94, 107, 136, 132, 106, 158, 164, 96, 112, 137, 90, 142,
	},
	410: []int64{976, 899, 657, 904, 171, 606, 607, 707, 823, 331, 255, 421, 230, 1001,
		937, 467, 738, 287, 904, 962, 518, 391, 593, 593, 59, 874, 364, 873, 728, 727, 533,
		328, 957, 637, 973, 1014, 259, 160, 698, 589, 933, 283, 385, 393, 129, 414, 16, 800,
		105, 150, 905, 278, 131, 115, 678, 738, 444, 411, 388, 402, 541, 428, 970, 260, 56,
		794, 975, 480, 644, 110, 702, 93, 240, 322, 651, 370, 261, 589, 72, 259, 405, 965,
		927, 519, 210, 291, 688, 758, 942, 301, 253, 605, 677, 995, 509, 478, 646, 3, 472, 1007,
	},
	470: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	57: []int64{78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208, 78208,
		78208, 78208, 78208, 78208, 78208, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828, 77828,
		77824, 77824, 77824, 77824, 77824, 77824, 77848, 77844, 77832, 77832, 77832, 77828, 77824, 77824, 77824, 77824, 77824, 77824, 77824, 77824,
		77824, 77824, 77824, 77824, 77824, 77824, 77824, 77824, 77824, 77824, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816,
		77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816, 77816,
	},
	29: []int64{58388608, 58386244, 58386248, 58386248, 58386416, 58388724, 58386336, 58386332, 58386320, 58386400, 58386332, 58386344, 58386332, 58386344, 58386380, 58386372, 58386212, 58386208, 58386208, 58386208,
		58386208, 58386196, 58386208, 58386208, 58386276, 58386196, 58386208, 58386208, 58386216, 58386216, 58388608, 58386216, 58386216, 58386216, 58386204, 58386212, 58386208, 58386208, 58386208, 58387404,
		58388600, 58386208, 58386208, 58386208, 58386208, 58386208, 58386208, 58386196, 58386208, 58386208, 58386208, 58386208, 58388684, 58386208, 58386344, 58386208, 58386196, 58386208, 58386216, 58386216,
		58386204, 58386216, 58386220, 58386220, 58388612, 58386220, 58386220, 58386220, 58386220, 58386208, 58386248, 58386248, 58386248, 58386236, 58386248, 58386248, 58386248, 58386248, 58386248, 58386248,
		58386248, 58386248, 58386236, 58386248, 58388640, 58386248, 58386240, 58386248, 58386248, 58386248, 58386248, 58388640, 58386248, 58386248, 58386248, 58386236, 58386248, 58386248, 58386248, 58386236,
	},
	90: []int64{6, 644, 90, 376, 809, 98, 902, 998, 526, 633, 973, 1019, 423, 410, 219,
		879, 566, 390, 109, 450, 489, 341, 61, 465, 29, 893, 134, 1022, 703, 73, 477, 976,
		172, 175, 65, 696, 410, 566, 430, 187, 300, 542, 305, 751, 606, 567, 905, 70, 369,
		524, 913, 829, 351, 456, 295, 29, 539, 694, 620, 1010, 441, 904, 706, 954, 777, 221,
		497, 586, 456, 694, 183, 631, 302, 391, 857, 864, 610, 880, 906, 299, 839, 399, 49,
		713, 220, 903, 788, 228, 256, 119, 562, 395, 991, 543, 205, 584, 130, 804, 70, 99,
	},
	406: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	424: []int64{1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864,
		1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864,
		1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864,
		1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864,
		1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864, 1295864,
	},
	61: []int64{14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
	},
	506: []int64{20000, 20600, 20600, 20400, 20400, 20400, 20600, 20700, 20600, 20400, 20500, 20500, 20700, 20700, 20700, 20300, 20400, 20500, 20700, 20800,
		20700, 20500, 20500, 20600, 20700, 20700, 20700, 20500, 20500, 20600, 20600, 20600, 20700, 20500, 20500, 20600, 20700, 20800, 20700, 20500,
		20200, 20000, 19600, 19300, 18900, 18200, 17700, 17700, 18000, 18000, 17900, 17800, 17700, 17800, 17900, 17900, 17900, 17700, 17600, 17700,
		17800, 17800, 17600, 17600, 17600, 17600, 17800, 17800, 17800, 17600, 17600, 17700, 17800, 17800, 17800, 17600, 17600, 17500, 17700, 17800,
		17800, 17600, 17500, 17600, 17700, 17800, 17700, 17600, 17600, 17600, 17800, 17700, 17700, 17400, 17600, 17700, 17800, 17900, 17800, 17700,
	},
	508: []int64{19400, 19900, 19900, 19700, 19700, 19800, 19900, 20000, 19900, 19700, 19800, 19800, 20000, 20000, 20000, 19700, 19700, 19800, 20000, 20100,
		20000, 19800, 19800, 19900, 20000, 20000, 20000, 19800, 19800, 19900, 20000, 19900, 20000, 19800, 19800, 19900, 20000, 20100, 20000, 19900,
		19600, 19300, 19100, 18800, 18400, 17800, 17300, 17300, 17600, 17600, 17500, 17400, 17300, 17400, 17500, 17500, 17500, 17300, 17200, 17300,
		17400, 17400, 17200, 17200, 17200, 17200, 17400, 17400, 17400, 17200, 17200, 17300, 17400, 17400, 17400, 17200, 17200, 17100, 17300, 17400,
		17400, 17200, 17100, 17200, 17300, 17400, 17300, 17200, 17200, 17200, 17400, 17300, 17300, 17000, 17200, 17300, 17400, 17500, 17400, 17300,
	},
	37: []int64{1116464, 1116460, 1116476, 1116472, 1116984, 1117312, 1117308, 1117040, 1117680, 1117680, 1117768, 1117768, 1117764, 1117780, 1117780, 1117780, 1118264, 1118004, 1118004, 1118004,
		1118184, 1118184, 1118176, 1118596, 1118596, 1118360, 1117724, 1117724, 1117724, 1117976, 1117976, 1118296, 1118292, 1118292, 1118036, 1117612, 1117608, 1117288, 1117300, 1117300,
		1117388, 1117812, 1117812, 1118232, 1118552, 1118552, 1118904, 1118628, 1118624, 1118296, 1118296, 1118288, 1118540, 1118624, 1118620, 1118708, 1119284, 1119280, 1119276, 1118396,
		1118388, 1118788, 1119028, 1119028, 1119508, 1119508, 1119504, 1119500, 1119420, 1119420, 1119156, 1119476, 1119476, 1118976, 1118976, 1118968, 1119028, 1119128, 1119124, 1119124,
		1118952, 1118952, 1119212, 1119196, 1119192, 1118868, 1118920, 1118920, 1118916, 1118916, 1118908, 1119224, 1119224, 1119224, 1119220, 1119216, 1119216, 1119148, 1118884, 1118880,
	},
	85: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	396: []int64{65, 76, 50, 49, 53, 54, 51, 50, 49, 49, 62, 56, 50, 49, 49, 49, 49, 53, 49, 58,
		49, 49, 49, 53, 49, 53, 49, 49, 50, 54, 49, 50, 48, 48, 51, 53, 49, 52, 49, 49,
		56, 54, 50, 51, 49, 49, 52, 56, 52, 51, 49, 48, 50, 53, 49, 59, 47, 49, 49, 53,
		49, 49, 49, 49, 54, 54, 49, 51, 49, 49, 55, 53, 48, 50, 48, 47, 50, 53, 48, 56,
		49, 48, 50, 54, 48, 55, 49, 48, 50, 55, 49, 49, 49, 48, 58, 52, 49, 51, 48, 48,
	},
	426: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	107: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	510: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	98: []int64{62902396, 62921636, 62904432, 62913104, 62912472, 62897712, 62903512, 62911892, 62909336, 62914452, 62917196, 62904156, 62915072, 62920036, 62917360, 62930320, 62924892, 62917404, 62902896, 62906684,
		62898772, 62900724, 62898848, 62899600, 62906108, 62902472, 62903632, 62909996, 62913516, 62902092, 62911576, 62909124, 62914036, 62927356, 62917200, 62908204, 62923924, 62925684, 62917196, 62925320,
		62930344, 62909300, 62904316, 62901588, 62905664, 62906196, 62906848, 62913096, 62908148, 62906556, 62912224, 62904436, 62916248, 62903068, 62911968, 62906208, 62913732, 62924492, 62915224, 62904880,
		62919844, 62921172, 62919572, 62924784, 62931284, 62908824, 62901488, 62903452, 62903008, 62905672, 62911408, 62910308, 62907216, 62904444, 62904628, 62908004, 62915428, 62904220, 62912192, 62909452,
		62905684, 62916360, 62919128, 62919116, 62916452, 62914768, 62924312, 62922776, 62923692, 62903832, 62915528, 62903128, 62904000, 62904420, 62906860, 62918812, 62906628, 62907844, 62904164, 62910788,
	},
	102: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	105: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	49: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	68: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	41: []int64{1050664, 1050664, 1050664, 1050660, 1050656, 1050656, 1050652, 1050648, 1050648, 1050648, 1050648, 1050648, 1050644, 1050644, 1050644, 1050644, 1050640, 1050640, 1050640, 1050640,
		1050640, 1050640, 1050632, 1050632, 1050632, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050612, 1050608, 1050604, 1050604, 1050604,
		1050588, 1050588, 1050588, 1050588, 1050588, 1050588, 1050932, 1050916, 1050916, 1050900, 1050900, 1050896, 1050888, 1050888, 1050884, 1050864, 1050864, 1050860, 1050856, 1050856,
		1050848, 1050848, 1050848, 1050848, 1050848, 1050848, 1050844, 1050840, 1050840, 1050840, 1050824, 1050824, 1050824, 1050820, 1050820, 1050812, 1050812, 1050812, 1050808, 1050808,
		1050808, 1050808, 1050800, 1050800, 1050796, 1050792, 1050792, 1050792, 1050788, 1050788, 1050780, 1050780, 1050780, 1050780, 1050776, 1050772, 1050772, 1050768, 1050764, 1050760,
	},
	440: []int64{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	},
	441: []int64{268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
	},
	422: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	429: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	143: []int64{8765, 5677, 1947, 2716, 2821, 1860, 1596, 1424, 1238, 1784, 2685, 2330, 1867, 1402, 1389, 1764, 1412, 2895, 1478, 2934,
		1256, 1540, 1604, 1518, 1410, 1930, 2512, 1185, 1490, 1418, 1493, 1256, 1791, 2541, 2270, 2222, 1912, 1355, 958, 1282,
		2087, 1882, 1279, 1410, 1252, 1177, 1151, 1347, 2879, 2776, 1223, 1472, 1020, 1314, 1310, 2902, 1374, 1350, 1194, 1425,
		1239, 975, 1225, 1295, 3642, 2116, 1627, 963, 1182, 1567, 1806, 2185, 1304, 1303, 1348, 958, 1311, 1057, 1405, 3185,
		1147, 2278, 1285, 1069, 1297, 2895, 1175, 1205, 1551, 1214, 1279, 1427, 1113, 984, 3162, 3057, 2320, 1435, 1076, 1440,
	},
	131: []int64{4655, 3164, 3005, 3258, 3194, 3077, 3071, 2430, 2576, 2467, 2464, 3189, 2703, 1753, 2425, 1598, 2234, 2281, 2723, 2766,
		2130, 2329, 2275, 1503, 2062, 2067, 2520, 1644, 1862, 1863, 2102, 2138, 1872, 2436, 2331, 2555, 3023, 2370, 1893, 2109,
		2025, 1974, 2015, 1766, 2073, 2033, 1645, 1974, 2306, 2578, 2046, 2724, 2061, 1859, 1932, 2223, 1915, 2410, 1825, 1992,
		1723, 1552, 2076, 1931, 3267, 2736, 3099, 1421, 1897, 1773, 1973, 2563, 2185, 1572, 1948, 1545, 1881, 1639, 2266, 2916,
		2266, 2899, 1927, 1828, 2131, 2660, 1845, 1844, 1902, 1712, 1835, 2563, 2026, 1545, 4746, 7004, 3166, 2172, 2198, 1984,
	},
	125: []int64{4972, 3453, 3036, 3275, 3264, 3155, 3080, 2435, 2589, 2639, 2472, 3199, 2938, 1838, 2711, 1705, 2276, 2296, 2734, 2815,
		2139, 2339, 2291, 1508, 2473, 2076, 2532, 1785, 1947, 2146, 2114, 2148, 1885, 2458, 2376, 3128, 3042, 2384, 1895, 2256,
		2072, 1983, 2155, 1851, 2354, 2042, 1671, 1982, 2320, 2620, 2062, 2738, 2069, 1870, 2026, 2299, 1931, 2553, 1907, 2279,
		1729, 1558, 2388, 1951, 3349, 2771, 3106, 1428, 1918, 1819, 2110, 2579, 2331, 1656, 2234, 1550, 1891, 1645, 2274, 2985,
		2287, 2902, 1945, 1836, 2140, 2833, 1854, 1983, 1986, 1986, 1843, 2575, 2034, 1549, 4822, 7066, 3173, 2176, 2206, 1996,
	},
	27: []int64{29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551,
		29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551,
		29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551,
		29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551,
		29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551, 29551,
	},
	419: []int64{57636, 57636, 57637, 57637, 57636, 57637, 57637, 57639, 57637, 57637, 57638, 57636, 57637, 57637, 57639, 57637, 57639, 57637, 57637, 57635,
		57635, 57635, 57635, 57635, 57635, 57635, 57635, 57635, 57635, 57635, 57637, 57635, 57637, 57635, 57635, 57635, 57635, 57637, 57635, 57635,
		57635, 57635, 57635, 57637, 57637, 57635, 57637, 57635, 57635, 57635, 57635, 57635, 57637, 57635, 57635, 57635, 57635, 57635, 57637, 57637,
		57635, 57637, 57635, 57635, 57637, 57635, 57635, 57635, 57635, 57637, 57637, 57637, 57635, 57635, 57637, 57635, 57637, 57635, 57635, 57637,
		57635, 57635, 57637, 57635, 57635, 57637, 57637, 57635, 57635, 57637, 57635, 57637, 57635, 57635, 57636, 57635, 57637, 57635, 57637, 57635,
	},
	511: []int64{36400, 40300, 40300, 38500, 38500, 38500, 40200, 40200, 40200, 40200, 40200, 40200, 40200, 40200, 40200, 39900, 26100, 26100, 26500, 31100,
		31100, 29600, 29600, 29600, 31100, 31100, 31100, 29600, 29600, 29600, 31100, 31100, 31100, 29600, 26600, 26900, 27000, 34300, 34300, 27000,
		27000, 27000, 36100, 36100, 36100, 27000, 27300, 27300, 36100, 36100, 36100, 27500, 27300, 27300, 27500, 27500, 27500, 27300, 27300, 27300,
		27500, 27500, 27500, 27300, 27300, 27300, 34600, 34600, 34600, 27300, 26700, 26700, 34600, 34600, 34600, 26700, 26700, 26700, 35000, 35000,
		35000, 28500, 28500, 28500, 33900, 33900, 33900, 28500, 28500, 28500, 33900, 33900, 33900, 28500, 25600, 27300, 33900, 33900, 33900, 27300,
	},
	12: []int64{17855, 20753, 13236, 12962, 14433, 14512, 13653, 13534, 12746, 13076, 16646, 14960, 13417, 13483, 13067, 12955, 13556, 15106, 13014, 16075,
		13035, 13094, 13233, 14367, 13043, 14539, 12820, 13046, 13940, 14320, 13203, 13483, 13483, 12890, 14226, 14402, 13045, 14350, 12809, 12948,
		15041, 14439, 13309, 13757, 12993, 13068, 13879, 15041, 14435, 14027, 13045, 12915, 13351, 14350, 13023, 16024, 12689, 13111, 13270, 14385,
		13087, 13285, 13071, 13725, 15293, 14793, 13024, 13870, 12994, 12916, 15175, 14214, 12551, 13424, 13055, 12480, 13549, 14215, 12944, 15988,
		13097, 12677, 13603, 14745, 12869, 15045, 12947, 12664, 13529, 14769, 13079, 13453, 13052, 12744, 16185, 14851, 13030, 13729, 12598, 12845,
	},
	539: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	427: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	399: []int64{71, 59, 0, 4, 15, 14, 2, 9, 0, 3, 79, 10, 91, 11, 2, 2, 2, 101, 0, 35,
		0, 0, 0, 36, 2, 36, 0, 0, 15, 0, 0, 9, 0, 0, 6, 18, 1, 12, 0, 0,
		103, 15, 5, 0, 0, 6, 0, 28, 6, 37, 21, 0, 7, 26, 4, 5, 0, 22, 0, 3,
		0, 2, 1, 38, 15, 23, 0, 0, 0, 0, 9, 2, 0, 20, 0, 0, 3, 3, 3, 77,
		6, 0, 4, 99, 0, 26, 0, 1, 0, 22, 0, 10, 5, 2, 70, 25, 0, 0, 2, 0,
	},
	467: []int64{2, 0, 0, 4, 1, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 5, 0, 0, 0,
		0, 0, 5, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0,
		0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 4, 1, 0, 0, 0, 0, 0,
		5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 3, 2,
		0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 4, 0, 0, 1, 0, 0, 5, 0, 0,
	},
	149: []int64{4529, 3139, 976, 1336, 1328, 854, 781, 678, 587, 874, 1296, 1092, 914, 657, 662, 862, 671, 1366, 724, 1384,
		595, 753, 766, 696, 697, 925, 1215, 579, 700, 644, 730, 595, 857, 1243, 1059, 1037, 937, 644, 449, 627,
		1002, 871, 626, 661, 594, 576, 543, 608, 1409, 1306, 579, 720, 479, 592, 641, 1576, 654, 660, 555, 648,
		606, 457, 580, 633, 1730, 985, 797, 451, 559, 768, 864, 1020, 638, 608, 641, 467, 622, 466, 687, 1507,
		542, 1115, 609, 472, 634, 1398, 556, 589, 730, 544, 625, 679, 525, 480, 1496, 1446, 1136, 683, 507, 704,
	},
	501: []int64{61000, 61000, 61000, 49900, 27100, 27100, 41100, 41100, 41100, 23800, 47100, 47100, 47100, 40600, 40600, 23500, 21400, 26100, 36800, 36800,
		36800, 31600, 19600, 22400, 34800, 37300, 37300, 37300, 23700, 23700, 38500, 38500, 38500, 27400, 27400, 27500, 37200, 37200, 37200, 36500,
		37300, 37300, 37300, 36600, 36600, 27100, 27700, 27700, 45800, 45800, 45800, 28100, 20900, 22100, 36000, 45800, 45800, 45800, 22800, 23500,
		35000, 35000, 35000, 26000, 36100, 36100, 36100, 35400, 35400, 21600, 40900, 40900, 40900, 36900, 36900, 26300, 21800, 22600, 36500, 40500,
		40500, 40500, 23200, 23500, 34300, 37900, 37900, 37900, 22600, 23800, 37200, 37200, 37200, 19500, 41700, 41700, 41700, 35400, 35400, 19700,
	},
	133: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 7, 0, 10, 0, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11,
		10, 0, 0, 11, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 0, 0, 10, 10,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 11, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	444: []int64{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	},
	414: []int64{2356756, 2354240, 2353756, 2353760, 2353824, 2353756, 2353756, 2353756, 2353620, 2353760, 2353756, 2353756, 2353620, 2353756, 2353712, 2353712, 2353580, 2353580, 2353580, 2355628,
		2355628, 2355500, 2355672, 2355672, 2355688, 2355672, 2355672, 2355672, 2355672, 2355716, 2355716, 2355716, 2355716, 2355716, 2355580, 2355716, 2355720, 2355672, 2355672, 2355672,
		2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355536, 2355672, 2355672, 2355672, 2355672, 2355740, 2355672, 2355688, 2355672, 2355672, 2355676, 2355672, 2355672,
		2355536, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355536, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672,
		2355672, 2355672, 2355536, 2355672, 2355672, 2355672, 2355536, 2355676, 2355812, 2355672, 2355672, 2355672, 2355672, 2355672, 2355672, 2355536, 2355672, 2355672, 2355672, 2355540,
	},
	514: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	513: []int64{34500, 36400, 36400, 35700, 35700, 35700, 36400, 36400, 36400, 35700, 35700, 35700, 36400, 36400, 36400, 35700, 35700, 35700, 36300, 36300,
		36300, 35700, 35700, 35700, 35700, 35700, 35700, 34600, 34600, 34600, 35700, 35700, 35700, 34600, 34600, 34600, 35700, 36100, 36100, 35700,
		34600, 34600, 36100, 36100, 36100, 31100, 27000, 27000, 27300, 27500, 27500, 27300, 27300, 27300, 27500, 27500, 27500, 27300, 27300, 27300,
		27500, 27500, 27500, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 27300, 28500,
		28500, 27500, 27300, 27300, 27500, 27500, 27500, 27300, 27300, 27300, 27500, 27500, 27500, 27300, 27300, 27300, 28500, 28500, 28500, 27300,
	},
	503: []int64{24600, 26100, 26200, 25700, 25700, 25800, 26300, 26300, 26100, 25500, 25100, 24200, 23500, 22500, 21300, 19300, 17600, 17900, 18300, 18700,
		18500, 18000, 17900, 18100, 18500, 18100, 17900, 17300, 17400, 17600, 18000, 18100, 17900, 17500, 17200, 17300, 17800, 18200, 18000, 17600,
		17500, 17700, 18100, 18000, 17900, 17400, 17400, 17200, 18100, 18100, 18000, 17500, 17000, 17200, 17600, 18000, 17900, 17500, 17400, 17600,
		18000, 17900, 17800, 17300, 17500, 17600, 18000, 18100, 18100, 17600, 17200, 17300, 17700, 17800, 18000, 17500, 17500, 17600, 17700, 17900,
		17700, 17300, 17300, 17600, 18000, 18000, 18000, 17500, 17500, 17300, 17800, 17800, 17800, 17400, 17400, 17700, 18200, 18200, 17800, 17400,
	},
	14: []int64{62600, 77075, 27623, 28796, 42164, 44052, 29757, 33336, 23381, 28748, 52594, 42428, 31328, 35896, 25039, 26988, 35767, 49973, 28095, 52738,
		25992, 28489, 30925, 39862, 28555, 42973, 24731, 27757, 38363, 41920, 27595, 33737, 35930, 28800, 42316, 44616, 27926, 43063, 24453, 27756,
		40219, 41513, 27233, 35284, 24476, 27207, 35227, 43938, 37587, 44219, 27139, 27820, 30524, 40477, 27790, 50045, 27185, 28176, 31853, 41129,
		27734, 30915, 26703, 38213, 50064, 44243, 26290, 33188, 26125, 25601, 42719, 42369, 26139, 38564, 29703, 25603, 32738, 41318, 28690, 54373,
		28665, 26258, 36017, 43638, 25508, 43062, 27378, 26439, 34338, 41717, 25492, 34329, 29567, 25705, 57680, 49805, 26032, 32345, 25920, 26333,
	},
	507: []int64{36500, 38200, 38200, 37800, 37800, 37800, 38200, 38200, 38200, 37800, 37800, 37800, 38200, 38200, 38200, 37800, 37800, 37800, 37800, 37800,
		37800, 37000, 37000, 37000, 37000, 37000, 37000, 36800, 36800, 36800, 37000, 37000, 37000, 36800, 36800, 36800, 37000, 37000, 37000, 36800,
		36500, 36500, 36600, 36600, 36500, 31600, 27500, 27500, 27700, 28100, 28100, 27700, 27700, 27700, 28100, 28100, 28100, 27700, 27700, 27700,
		28100, 28100, 28100, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 27700, 29100,
		29100, 28100, 27700, 27700, 28100, 28100, 28100, 27700, 27700, 27700, 28100, 28100, 28100, 27700, 27700, 27900, 29100, 29100, 29100, 27900,
	},
	86: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	462: []int64{4235, 2537, 970, 1379, 1492, 1006, 814, 746, 651, 909, 1389, 1238, 953, 744, 726, 901, 740, 1529, 754, 1550,
		660, 786, 838, 822, 712, 1004, 1297, 605, 789, 773, 763, 661, 933, 1297, 1211, 1185, 975, 711, 509, 654,
		1085, 1011, 653, 749, 657, 601, 607, 738, 1470, 1469, 643, 752, 541, 721, 669, 1326, 720, 689, 639, 777,
		633, 517, 645, 661, 1911, 1130, 830, 511, 622, 798, 941, 1165, 666, 694, 706, 490, 688, 590, 717, 1677,
		605, 1162, 675, 596, 662, 1496, 618, 615, 821, 670, 654, 748, 587, 503, 1666, 1611, 1184, 751, 568, 736,
	},
	148: []int64{4235, 2537, 970, 1379, 1492, 1006, 814, 746, 651, 909, 1389, 1238, 953, 744, 726, 901, 740, 1529, 754, 1550,
		660, 786, 838, 822, 712, 1004, 1297, 605, 789, 773, 763, 661, 933, 1297, 1211, 1185, 975, 711, 509, 654,
		1085, 1011, 653, 749, 657, 601, 607, 738, 1470, 1469, 643, 752, 541, 721, 669, 1326, 720, 689, 639, 777,
		633, 517, 645, 661, 1911, 1130, 830, 511, 622, 798, 941, 1165, 666, 694, 706, 490, 688, 590, 717, 1677,
		605, 1162, 675, 596, 662, 1496, 618, 615, 821, 670, 654, 748, 587, 503, 1666, 1611, 1184, 751, 568, 736,
	},
}

var ResourcePoolMetricData = map[int32][]int64{
	6: []int64{2648, 2660, 2642, 2704, 2653, 2610, 2679, 2637, 2688, 2575, 2703, 2546, 2629, 2689, 2653, 2564, 2717, 2545, 2613, 2672,
		2767, 2549, 2648, 2535, 2618, 2693, 2635, 2584, 2684, 2585, 2770, 2655, 2721, 2665, 2804, 2563, 2920, 2718, 2661, 2741,
		2731, 2617, 2692, 2716, 2627, 2612, 2725, 2536, 2705, 2757, 2741, 2574, 3086, 2513, 2748, 2689, 2678, 3847, 2742, 2552,
		2672, 2731, 2667, 2717, 2727, 2570, 2687, 2650, 2702, 3887, 2694, 2583, 2679, 2687, 2690, 2664, 2668, 2592, 2809, 2669,
		2610, 3783, 2672, 2576, 2705, 2693, 2768, 2665, 2764, 2666, 2684, 2743, 2721},
	98: []int64{69961436, 69961085, 69960708, 69961322, 69961734, 69961582, 69960647, 69960520, 69961108, 69961043, 69959288, 69961340, 69963664, 69963803, 69966339, 69966730, 69966854, 69967577, 69969142, 69970332,
		69970629, 69970167, 69971088, 69970684, 69971038, 69971578, 69968726, 69968868, 69968092, 69968632, 69968387, 69968226, 69968412, 69967611, 69968527, 69969251, 69968896, 69968292, 69966611, 69966893,
		69966583, 69969648, 69969991, 69970006, 69970131, 69970476, 69970138, 69970011, 69969946, 69970596, 69970963, 69970303, 69970393, 69970626, 69970975, 69970635, 69970602, 69970758, 69970815, 69970774,
		69971567, 69974147, 69975787, 69973389, 69974243, 69974761, 69976130, 69977938, 69977197, 69976327, 69975736, 69975777, 69975205, 69974629, 69974275, 69973691, 69973552, 69972974, 69972629, 69972392,
		69973105, 69974080, 69976093, 69976312, 69979980, 69980007, 69984359, 69987261, 69988144, 69988443, 69987244, 69986857, 69986303},
	29: []int64{71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71097821, 71098368, 71102190, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464},
	33: []int64{14147864, 14298869, 13853549, 14071653, 14408592, 13569734, 13775254, 13631952, 14009437, 14864391, 15225092, 14491085, 14256903, 13928347, 13923454, 13900408, 14486205, 13712336, 13669000, 13853559,
		13605408, 14571477, 15720747, 15202728, 14281366, 14092624, 14070270, 14407903, 14308628, 13908775, 14154848, 13566956, 14234531, 14219868, 16074441, 14676380, 14672195, 14980482, 14745536, 14405798,
		14986710, 15169160, 14108018, 14105911, 13912964, 14536520, 15798325, 15342582, 14548403, 14673552, 15304788, 14523272, 15387281, 15152398, 14791723, 14362474, 13642436, 14774898, 16125462, 15111862,
		14085672, 14342207, 13367707, 15036358, 15538271, 14937092, 14194016, 13878714, 13884307, 14810548, 15532667, 15050322, 14081436, 14789578, 14602931, 14380633, 14739248, 14182827, 15072001, 14819650,
		14119919, 14589666, 16036683, 14730158, 14321214, 14659554, 14368049, 14447758, 14924502, 13787139, 14776992, 15789234, 14169540},
	37: []int64{1224491, 1224767, 1224727, 1224610, 1224560, 1224513, 1224444, 1224411, 1224390, 1224364, 1224323, 1223250, 1222386, 1221184, 1220120, 1218849, 1217944, 1217003, 1215534, 1215959,
		1215276, 1214698, 1214640, 1214615, 1214655, 1214319, 1215025, 1214862, 1214388, 1214122, 1214082, 1214049, 1214000, 1213937, 1213708, 1213309, 1213506, 1213300, 1212838, 1212427,
		1211531, 1206346, 1206131, 1206061, 1205836, 1205722, 1205495, 1205681, 1205711, 1204664, 1204509, 1205405, 1205132, 1204909, 1204796, 1204754, 1204743, 1204720, 1204484, 1204448,
		1204636, 1204476, 1204354, 1204331, 1204079, 1203968, 1203899, 1203865, 1203811, 1203734, 1203865, 1203628, 1203251, 1203212, 1203098, 1203057, 1203938, 1203697, 1203608, 1203573,
		1203545, 1203465, 1202291, 1201669, 1201782, 1201631, 1201743, 1201529, 1201474, 1201407, 1199122, 1198521, 1198570},
	70: []int64{91, 585, 246, 114, 553, 348, 824, 848, 827, 882, 632, 500, 647, 805, 425, 971, 789, 1001, 910, 1013, 338, 713, 496, 168, 201, 886, 124, 968, 768, 736, 612, 859, 973, 64, 312, 449, 38, 839, 807, 571, 83, 862, 1015, 333, 818, 173, 396, 520, 171, 678, 160, 203, 991, 549, 776, 524, 390, 228, 576, 307, 1005, 93, 893, 475, 451, 141, 98, 439, 95, 104, 739, 630, 275, 701, 722, 16, 207, 468, 310, 387, 217, 377, 684, 969, 396, 1010, 866, 914, 181, 621, 995, 831, 278, 530, 465, 745, 704, 762, 545, 544},
	90: []int64{6, 644, 90, 376, 809, 98, 902, 998, 526, 633, 973, 1019, 423, 410, 219,
		879, 566, 390, 109, 450, 489, 341, 61, 465, 29, 893, 134, 1022, 703, 73, 477, 976,
		172, 175, 65, 696, 410, 566, 430, 187, 300, 542, 305, 751, 606, 567, 905, 70, 369,
		524, 913, 829, 351, 456, 295, 29, 539, 694, 620, 1010, 441, 904, 706, 954, 777, 221,
		497, 586, 456, 694, 183, 631, 302, 391, 857, 864, 610, 880, 906, 299, 839, 399, 49,
		713, 220, 903, 788, 228, 256, 119, 562, 395, 991, 543, 205, 584, 130, 804, 70, 99,
	},
	7: []int64{1406, 1419, 1426, 1412, 1413, 1408, 1472, 1426, 1462, 1424, 1447, 1403, 1433, 1429, 1420, 1395, 1447, 1396, 1406, 1413,
		1432, 1420, 1425, 1411, 1432, 1437, 1444, 1407, 1448, 1450, 1477, 1431, 1451, 1437, 1403, 1459, 1478, 1452, 1447, 1446,
		1410, 1441, 1445, 1415, 1433, 1435, 1458, 1419, 1441, 1476, 1310, 1482, 1451, 1458, 1455, 1428, 1446, 1443, 1436, 1449,
		1422, 1394, 1424, 1402, 1417, 1410, 1419, 1432, 1446, 1421, 1440, 1430, 1406, 1463, 1448, 1446, 1432, 1435, 1465, 1484,
		1443, 1451, 1414, 1446, 1412, 1429, 1442, 1424, 1497, 1458, 1490, 1463, 1533, 1482, 1473, 1468, 1467, 294, 294, 293,
	},
	8: []int64{6539, 7702, 6548, 8268, 6700, 7397, 6790, 7898, 6476, 6905, 6238, 7278, 6627, 7807, 5958, 6792, 6036, 6789, 6141, 7983,
		7889, 6401, 5709, 6512, 5807, 7728, 5975, 6809, 6144, 7257, 8149, 7885, 6501, 8131, 7308, 6462, 8264, 8044, 6631, 7954,
		7046, 7166, 6704, 7344, 6438, 6346, 6730, 6478, 6916, 7791, 6944, 6179, 7985, 6202, 6726, 8141, 6854, 9215, 6561, 6467,
		6547, 7569, 6386, 7388, 7036, 6134, 6651, 7371, 6545, 11069, 6235, 6345, 6048, 8274, 6422, 7397, 6544, 6905, 7577, 7600,
		5693, 8974, 6178, 6603, 6656, 7968, 7048, 7406, 6370, 7129, 5815, 7886, 6045, 8873, 6834, 7219, 6213, 1852, 583, 753,
	},
	16: []int64{6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428,
		6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428,
		6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428,
		6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428,
		6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 6428, 100, 100, 100,
	},
	17: []int64{14, 14, 14, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 14, 14, 14,
		15, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 14, 15, 14, 15, 14, 16, 15, 14, 15,
		15, 14, 14, 15, 14, 14, 15, 14, 15, 15, 15, 14, 17, 13, 15, 14, 14, 21, 15, 14,
		14, 15, 14, 15, 15, 14, 14, 14, 14, 21, 14, 14, 14, 14, 14, 14, 14, 14, 15, 14,
		14, 21, 14, 14, 15, 14, 15, 14, 15, 14, 14, 15, 15, 20, 15, 14, 14, 253, 184, 198,
	},
	18: []int64{2805, 3008, 2834, 2990, 2887, 2897, 2838, 2978, 2875, 2848, 2889, 2868, 2799, 3006, 2816, 2871, 2885, 2862, 2764, 2979,
		2813, 2966, 2885, 2841, 2816, 3021, 2825, 2884, 2896, 2868, 3005, 2990, 2858, 3027, 2985, 2878, 3136, 3049, 2840, 3057,
		2932, 2952, 2886, 3029, 2822, 2907, 2908, 2846, 2885, 3019, 2957, 2938, 3268, 2858, 2922, 3005, 2894, 4130, 2912, 2893,
		2877, 3010, 2896, 3021, 2943, 2885, 2873, 2961, 2870, 4165, 2865, 2906, 2835, 3017, 2871, 2934, 2842, 2883, 2955, 2996,
		2852, 4035, 2909, 2881, 2864, 3050, 2947, 2936, 2978, 2983, 2850, 3069, 2881, 4073, 3006, 2929, 2824, 549, 402, 429,
	},
	19: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
	},
	20: []int64{196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 4, 4, 4,
	},
	22: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	30: []int64{71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71098368, 71100416, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 14680064, 14680064, 14680064,
	},
	31: []int64{71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272, 71094272,
		71094272, 71094272, 71094272, 71094272, 71098368, 71098368, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 71102464, 14680064, 14680064, 14680064,
	},
	34: []int64{11984984, 12310048, 12089852, 11869644, 12131784, 11754300, 11806732, 11460704, 12268108, 12656084, 13316684, 12509284, 12362480, 12435872, 12236644, 11733332, 12320532, 11712352, 12194704, 11743820,
		11785764, 12603648, 12750452, 13044056, 12456848, 12194700, 12268112, 12519768, 12142276, 12456848, 12760936, 11995480, 11680904, 12477824, 13872424, 13117456, 12372964, 12855352, 12687536, 12551220,
		13253768, 12771416, 12026932, 11901100, 11796248, 12488304, 12530248, 13285224, 12729480, 12792396, 12918224, 12404420, 12844828, 12718996, 12792388, 12561704, 12016444, 12289072, 14312828, 13411048,
		12110816, 12089848, 11722844, 13002108, 13222312, 12656076, 12477820, 11953532, 12047904, 12760936, 13201340, 13106960, 12404420, 12561712, 12939200, 12582680, 12561704, 12142280, 12970648, 13138420,
		12477820, 12771420, 12519764, 12823848, 12456848, 13211828, 11984992, 12603648, 12698016, 12257620, 12729476, 12802884, 12519764, 12823852, 13379596, 12844820, 12624624, 4236240, 4341100, 4487900,
	},
	35: []int64{17406204, 17070628, 16022008, 16630184, 16797952, 14962948, 16493868, 15319468, 16672116, 17773168, 17500540, 16829408, 16493868, 15759872, 16042976, 17028680, 16892368, 15665488, 15749384, 16284196,
		15906708, 16850420, 18486248, 17668348, 17049608, 16441444, 16294680, 17332768, 17479532, 15382380, 15581652, 15455820, 17479532, 16147880, 18286976, 16609288, 16567348, 17343296, 16567264, 16619700,
		17374668, 17678756, 16703620, 17206936, 16735036, 16818920, 19377496, 18979120, 17668268, 16777024, 17227912, 17133576, 18444296, 17699768, 17133580, 16819008, 15508208, 18182080, 18958024, 17636860,
		16389092, 17227948, 15340432, 17951424, 19398464, 17867580, 16525400, 15969576, 16567272, 17322240, 18265960, 17217380, 16514832, 17123012, 16651156, 17217388, 17752164, 16797996, 17301312, 16965768,
		16640752, 17353780, 19786396, 16472900, 16756008, 16923780, 17343212, 17490056, 17825596, 15896180, 17500496, 18905632, 16913372, 17374748, 18737944, 17007748, 17196492, 5955908, 5221904, 5515508,
	},
	38: []int64{1224116, 1224140, 1224660, 1224576, 1224544, 1224472, 1224420, 1224404, 1224376, 1224348, 1224308, 1222636, 1221028, 1221104, 1219004, 1217960, 1217928, 1215552, 1215528, 1215884,
		1214788, 1214688, 1214632, 1214608, 1214404, 1214264, 1214148, 1214616, 1214152, 1214096, 1214064, 1214036, 1213972, 1213888, 1213556, 1213292, 1213264, 1213196, 1212664, 1211552,
		1211516, 1206068, 1206108, 1206048, 1205820, 1205496, 1205492, 1205468, 1204548, 1204572, 1204492, 1204240, 1204980, 1204828, 1204776, 1204740, 1204732, 1204696, 1204460, 1204440,
		1204424, 1204380, 1204336, 1204072, 1204016, 1203940, 1203892, 1203844, 1203796, 1203720, 1203688, 1203076, 1203056, 1203128, 1203084, 1203028, 1203740, 1203624, 1203580, 1203552,
		1203516, 1203448, 1201708, 1201616, 1201612, 1201516, 1201692, 1201520, 1201452, 1201384, 1198548, 1198516, 1198472, 1198576, 1198560, 1196536, 1196512, 0, 0, 0,
	},
	39: []int64{1224732, 1225764, 1224908, 1224660, 1224576, 1224544, 1224464, 1224420, 1224404, 1224376, 1224352, 1224320, 1223000, 1221336, 1221104, 1219004, 1217960, 1217728, 1215548, 1216128,
		1215840, 1214712, 1214656, 1214632, 1215200, 1214432, 1215632, 1215088, 1214612, 1214152, 1214092, 1214060, 1214032, 1213968, 1213888, 1213320, 1213612, 1213536, 1213176, 1212660,
		1211548, 1208264, 1206156, 1206080, 1205844, 1205812, 1205496, 1206136, 1205884, 1204784, 1204532, 1206052, 1205248, 1204968, 1204824, 1204780, 1204752, 1204740, 1204700, 1204460,
		1204796, 1204708, 1204376, 1204604, 1204268, 1203996, 1203908, 1203888, 1203824, 1203740, 1204148, 1203772, 1203408, 1203360, 1203124, 1203084, 1204252, 1203740, 1203620, 1203584,
		1203572, 1203516, 1203440, 1201708, 1201980, 1201896, 1201856, 1201540, 1201504, 1201448, 1201372, 1198532, 1198856, 1198604, 1198576, 1196552, 1196904, 0, 0, 0,
	},
	41: []int64{1055608, 1055673, 1055611, 1055552, 1055515, 1055476, 1055412, 1055381, 1055362, 1055339, 1055315, 1054702, 1054162, 1053129, 1053072, 1053034, 1053001, 1052964, 1052902, 1053140,
		1053065, 1052986, 1052956, 1052937, 1053154, 1053106, 1053207, 1053163, 1053114, 1053076, 1053048, 1053021, 1052985, 1052934, 1052884, 1052877, 1053076, 1053086, 1053020, 1052979,
		1052925, 1052908, 1052834, 1052773, 1052745, 1052715, 1052707, 1052783, 1052930, 1052939, 1052823, 1052902, 1052858, 1052810, 1052757, 1052723, 1052703, 1052680, 1052659, 1052649,
		1052844, 1052912, 1052870, 1052881, 1052877, 1052824, 1052791, 1052763, 1052717, 1052664, 1052715, 1052572, 1052357, 1052434, 1052378, 1052343, 1052500, 1052423, 1052385, 1052362,
		1052328, 1052257, 1051141, 1050565, 1050688, 1050780, 1050854, 1050744, 1050700, 1050671, 1050642, 1050621, 1050643, 1050660, 1050640, 1050610, 1050777, 0, 0, 0,
	},
	42: []int64{1055340, 1055544, 1055588, 1055528, 1055500, 1055440, 1055388, 1055376, 1055348, 1055328, 1055304, 1054396, 1052844, 1053096, 1053052, 1053016, 1052988, 1052920, 1052896, 1053104,
		1053060, 1052976, 1052948, 1052932, 1052864, 1053084, 1053024, 1053136, 1053100, 1053060, 1053032, 1053012, 1052968, 1052892, 1052880, 1052864, 1052844, 1053060, 1053004, 1052944,
		1052912, 1052788, 1052812, 1052760, 1052732, 1052708, 1052704, 1052684, 1052716, 1052880, 1052808, 1052780, 1052844, 1052784, 1052740, 1052712, 1052692, 1052664, 1052652, 1052644,
		1052640, 1052896, 1052852, 1052808, 1052852, 1052808, 1052784, 1052748, 1052704, 1052656, 1052632, 1052176, 1052164, 1052408, 1052364, 1052320, 1052444, 1052396, 1052368, 1052344,
		1052312, 1052244, 1050592, 1050528, 1050524, 1050756, 1050812, 1050736, 1050684, 1050656, 1050632, 1050616, 1050572, 1050648, 1050632, 1050604, 1050588, 0, 0, 0,
	},
	43: []int64{1055696, 1056120, 1055628, 1055588, 1055528, 1055500, 1055432, 1055388, 1055376, 1055348, 1055328, 1055308, 1054744, 1053152, 1053096, 1053052, 1053016, 1052988, 1052916, 1053220,
		1053072, 1053000, 1052968, 1052948, 1053416, 1053128, 1053340, 1053208, 1053136, 1053100, 1053056, 1053028, 1053008, 1052964, 1052892, 1052884, 1053172, 1053112, 1053040, 1053000,
		1052940, 1053068, 1052856, 1052792, 1052752, 1052724, 1052708, 1053040, 1053028, 1052968, 1052844, 1052988, 1052876, 1052832, 1052780, 1052732, 1052712, 1052692, 1052664, 1052652,
		1052976, 1052924, 1052892, 1053072, 1052904, 1052840, 1052800, 1052780, 1052728, 1052668, 1052884, 1052676, 1052504, 1052468, 1052404, 1052364, 1052556, 1052444, 1052392, 1052368,
		1052348, 1052308, 1052236, 1050592, 1050860, 1050808, 1050944, 1050752, 1050724, 1050680, 1050648, 1050624, 1050824, 1050672, 1050648, 1050612, 1050948, 0, 0, 0,
	},
	71: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	72: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	91: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	92: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	99: []int64{69960688, 69959600, 69960228, 69960116, 69960688, 69960736, 69959156, 69959576, 69960484, 69959796, 69957320, 69958684, 69961812, 69962888, 69964840, 69965848, 69965972, 69966228, 69968528, 69969252,
		69969080, 69968724, 69970196, 69969716, 69969888, 69970532, 69967824, 69967952, 69967564, 69967904, 69967848, 69967588, 69967500, 69966760, 69967660, 69968544, 69968168, 69966496, 69965724, 69965868,
		69965816, 69966268, 69968824, 69969272, 69968828, 69969344, 69969496, 69968924, 69969160, 69970168, 69970320, 69969004, 69969592, 69969720, 69970316, 69969928, 69969808, 69969612, 69969896, 69970544,
		69970444, 69971520, 69974856, 69972324, 69973136, 69974292, 69975128, 69976984, 69976008, 69975604, 69974656, 69975084, 69974348, 69973416, 69972924, 69972828, 69972744, 69972144, 69971712, 69971752,
		69972212, 69973544, 69973784, 69975728, 69975584, 69979180, 69981700, 69986452, 69987628, 69988032, 69985860, 69985764, 69985400, 69984384, 69983756, 69983760, 69983452, 14680064, 14680064, 14680064,
	},
	100: []int64{69963068, 69962232, 69962076, 69962484, 69963332, 69962460, 69962284, 69961492, 69962064, 69961940, 69960848, 69963564, 69965540, 69964756, 69967632, 69967936, 69967904, 69969332, 69969792, 69970912,
		69972048, 69971304, 69971508, 69971548, 69972064, 69972608, 69971052, 69969968, 69968996, 69969416, 69969212, 69968836, 69969444, 69968496, 69969572, 69969964, 69969912, 69970156, 69967196, 69967908,
		69967208, 69971704, 69970876, 69970952, 69971680, 69971172, 69970660, 69970884, 69971432, 69971980, 69971460, 69972160, 69971432, 69971556, 69971820, 69971812, 69971924, 69971856, 69972396, 69972084,
		69972636, 69975972, 69976760, 69974320, 69975224, 69976312, 69977512, 69978932, 69978144, 69976904, 69976420, 69976648, 69976040, 69975928, 69975108, 69974296, 69974592, 69973736, 69973496, 69973216,
		69973868, 69974892, 69977532, 69976804, 69981496, 69980680, 69985564, 69988184, 69988860, 69988992, 69989032, 69987924, 69987492, 69986820, 69984960, 69985268, 69985340, 14680064, 14680064, 14680064,
	},
	102: []int64{3492918, 3493174, 3492757, 3492740, 3493216, 3493191, 3493195, 3493207, 3493435, 3493248, 3492551, 3493147, 3493026, 3492751, 3492580, 3492757, 3492723, 3492774, 3492555, 3493055,
		3492784, 3492681, 3493216, 3492830, 3492892, 3492948, 3493046, 3493060, 3493087, 3492704, 3492637, 3492534, 3492642, 3492200, 3491916, 3492401, 3492365, 3492496, 3492244, 3492346,
		3492494, 3492328, 3492643, 3492845, 3492800, 3492768, 3492817, 3492966, 3492993, 3492775, 3492814, 3492854, 3492624, 3492659, 3492556, 3492909, 3492991, 3492511, 3492570, 3492676,
		3493124, 3493161, 3492891, 3492730, 3492821, 3492603, 3492387, 3492922, 3492765, 3492628, 3492580, 3492887, 3493048, 3492725, 3492645, 3492413, 3492408, 3492389, 3492519, 3492265,
		3492381, 3492345, 3492567, 3492055, 3492620, 3492210, 3492316, 3492033, 3491852, 3492023, 3492222, 3492334, 3492414, 3492141, 3492333, 3492270, 3492054, 99800, 99966, 100021,
	},
	103: []int64{3491848, 3492168, 3491848, 3491912, 3492200, 3492136, 3492088, 3491976, 3492280, 3492072, 3491768, 3491880, 3491992, 3491736, 3491608, 3491704, 3491720, 3491688, 3491400, 3492008,
		3491704, 3491496, 3491944, 3491672, 3491816, 3491640, 3491864, 3492152, 3491896, 3491336, 3491176, 3491016, 3491640, 3491112, 3490792, 3491272, 3491448, 3491592, 3491192, 3491352,
		3491320, 3491480, 3491416, 3491848, 3491864, 3491528, 3491832, 3491544, 3491624, 3491720, 3491656, 3491656, 3491464, 3491624, 3491608, 3492024, 3491960, 3491688, 3491112, 3491496,
		3491928, 3492040, 3491688, 3491400, 3491480, 3491528, 3491352, 3492152, 3491736, 3491348, 3491540, 3491764, 3491956, 3491508, 3491412, 3491316, 3491348, 3491460, 3491508, 3491348,
		3491172, 3491092, 3491288, 3490760, 3491264, 3491200, 3490984, 3490696, 3490568, 3490648, 3490824, 3491256, 3491240, 3491064, 3491192, 3491240, 3490744, 99416, 99752, 99704,
	},
	104: []int64{3494248, 3494072, 3493528, 3493720, 3494312, 3494168, 3494232, 3494216, 3494440, 3494360, 3493752, 3494504, 3494296, 3493784, 3493864, 3494424, 3493848, 3494056, 3493704, 3494152,
		3494024, 3493976, 3494216, 3493864, 3493912, 3494104, 3494264, 3494168, 3494248, 3493736, 3493960, 3494008, 3493464, 3493352, 3493128, 3493672, 3493528, 3493336, 3493336, 3493304,
		3493496, 3493288, 3493720, 3494040, 3493896, 3494104, 3494120, 3494264, 3494280, 3493880, 3493896, 3493928, 3493832, 3493720, 3493592, 3493816, 3493912, 3493496, 3493912, 3493672,
		3494024, 3494168, 3494264, 3493768, 3493832, 3493544, 3493480, 3494008, 3493768, 3493700, 3493556, 3493988, 3494212, 3494020, 3493828, 3493748, 3493476, 3493364, 3493556, 3493188,
		3493604, 3493576, 3493864, 3492936, 3493728, 3493120, 3493336, 3493016, 3492952, 3493080, 3493336, 3493352, 3493448, 3493144, 3493640, 3493320, 3493560, 100088, 100312, 100392,
	},
	105: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	106: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	107: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	108: []int64{254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160,
		254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160,
		254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160,
		254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160,
		254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 254812160, 14680064, 14680064, 14680064,
	},
	109: []int64{72669509, 72669222, 72668798, 72669432, 72669934, 72669814, 72668820, 72668626, 72669167, 72669100, 72667309, 72669518, 72671803, 72671876, 72674528, 72674987, 72675130, 72675893, 72677596, 72678840,
		72679130, 72678625, 72679555, 72679104, 72679477, 72680094, 72677130, 72677211, 72676337, 72676877, 72676613, 72676430, 72676661, 72675813, 72676695, 72677409, 72677011, 72676365, 72674592, 72674894,
		72674587, 72677618, 72677960, 72677989, 72678323, 72678753, 72677997, 72677835, 72677884, 72678533, 72678783, 72678153, 72678332, 72678647, 72679004, 72678684, 72678613, 72678731, 72678783, 72678797,
		72679536, 72682196, 72683921, 72681372, 72682292, 72682820, 72684300, 72686184, 72685409, 72684595, 72683952, 72683983, 72683356, 72682772, 72682415, 72681736, 72681594, 72680926, 72680580, 72680310,
		72681090, 72682132, 72684368, 72684699, 72688731, 72688798, 72693599, 72696711, 72697646, 72697938, 72696678, 72696250, 72695584, 72694773, 72693560, 72693871, 72693294, 14715452, 14715452, 14715452,
	},
	111: []int64{30656722, 31076179, 30770388, 30592011, 30996556, 30532182, 30390123, 30352947, 30675033, 31077121, 31877885, 31308104, 30952698, 30718327, 30548242, 30083717, 31245735, 30332823, 30207174, 30364905,
		30279320, 31032211, 32115237, 32021915, 30972413, 30812060, 30826516, 30672099, 30929837, 30838081, 30966531, 30490329, 30788887, 30599961, 32589503, 31589096, 31232156, 31685175, 31359139, 30879847,
		31365331, 31837189, 30903611, 30615977, 30361114, 31113485, 32588192, 31584467, 31259797, 31681825, 31810135, 31252656, 32144658, 31630300, 31588314, 31299303, 30411427, 31516131, 32632526, 31501616,
		30845373, 30970138, 30053117, 30947587, 31970379, 31453594, 31041957, 30678159, 30610308, 31591595, 32223776, 31467215, 30827138, 31322148, 31453916, 31040880, 31097992, 30641493, 31552559, 31244155,
		31054060, 31418432, 32604574, 31275788, 31245161, 31354098, 31005407, 30914706, 31448268, 30663530, 31529169, 32255806, 30915270, 31310240, 33316725, 31639878, 31426836, 4947895, 4803891, 4987044,
	},
	112: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	138: []int64{2230, 2625, 2415, 2525, 2444, 2452, 2567, 2789, 2390, 2748, 2639, 2602, 2475, 2902, 2513, 2845, 2500, 2471, 2566, 2865,
		2526, 2841, 2714, 2647, 2494, 2871, 2693, 2910, 2601, 2731, 2697, 2840, 2662, 3119, 3002, 2612, 2718, 3016, 2735, 2919,
		2864, 2973, 2713, 2782, 2290, 2544, 2365, 2346, 2323, 2851, 3113, 2561, 4712, 2480, 2570, 2801, 2484, 3698, 2650, 2606,
		2280, 2781, 2703, 2796, 2532, 2595, 2507, 2814, 2586, 3219, 2737, 2762, 2744, 2960, 2701, 2893, 2488, 2716, 3324, 2887,
		2641, 3578, 2718, 2797, 2781, 2970, 2637, 2917, 2638, 2763, 2521, 3081, 2977, 3492, 2563, 2511, 2277, 573, 296, 401,
	},
	139: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	152: []int64{1504328, 1575229, 1508808, 1539050, 1521242, 1501829, 1575085, 1588140, 1552456, 1612624, 1639628, 1537009, 1757880, 1629266, 1527363, 1627738, 1527973, 1533938, 1570509, 1570986,
		1567765, 1572046, 1611014, 1541704, 1585722, 1563972, 1559854, 1705802, 1580902, 1568416, 1592145, 1537276, 1605016, 1667988, 1727917, 1565331, 2161135, 1638339, 1562243, 1661089,
		1584488, 1584636, 1629115, 1601832, 1541515, 1597786, 1614639, 1601248, 1554451, 1760051, 2052848, 1585702, 3227857, 1567160, 1637085, 1542094, 1563545, 3143052, 1671157, 1556602,
		1595426, 1539979, 1573539, 1627501, 1602214, 1524304, 1528918, 1558122, 1587828, 2854876, 1617354, 1588144, 1562083, 1557448, 1583029, 1592644, 1552987, 1506212, 2721076, 1575108,
		1580946, 3205255, 1625244, 1557114, 1644929, 1716253, 1653792, 1612237, 1629766, 1748134, 1720512, 1606758, 1851552, 2960837, 1868642, 1616094, 1552098, 588169, 567729, 571114,
	},
	153: []int64{1210, 1210, 1212, 1214, 1206, 1224, 1224, 1202, 1190, 1332, 1260, 1186, 1256, 1292, 1290, 1238, 1256, 1204, 1280, 1200,
		1232, 1208, 1238, 1212, 1212, 1232, 1206, 1242, 1188, 1256, 1218, 1214, 1194, 1290, 1218, 1186, 1254, 1216, 1194, 1242,
		1202, 1212, 1316, 1230, 1180, 1262, 1730, 1204, 1238, 1222, 1204, 1376, 1418, 1238, 1208, 1218, 1208, 5360, 1204, 1222,
		1192, 1192, 1220, 1327, 1178, 1224, 1218, 1240, 1188, 5604, 1210, 1224, 1203, 1244, 1244, 1210, 1244, 1206, 1234, 1180,
		1226, 5422, 1268, 1188, 1216, 1222, 1196, 1200, 1240, 1198, 1208, 1206, 1254, 5459, 1234, 1180, 1388, 0, 0, 0,
	},
	157: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	159: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
}

var ClusterMetricData = map[int32][]int64{
	6: []int64{2660, 2642, 2704, 2653, 2610, 2679, 2637, 2688, 2575, 2703, 2546, 2629, 2689, 2653, 2564, 2717, 2545, 2613, 2672, 2767,
		2549, 2648, 2535, 2618, 2693, 2635, 2584, 2684, 2585, 2770, 2655, 2721, 2665, 2804, 2563, 2920, 2718, 2661, 2741, 2731,
		2617, 2692, 2716, 2627, 2612, 2725, 2536, 2705, 2757, 2741, 2574, 3086, 2513, 2748, 2689, 2678, 3847, 2742, 2552, 2672,
		2731, 2667, 2717, 2727, 2570, 2687, 2650, 2702, 3887, 2694, 2583, 2679, 2687, 2690, 2664, 2668, 2592, 2809, 2669, 2610,
		3783, 2672, 2576, 2705, 2693, 2768, 2665, 2764, 2666, 2684, 2743, 2721, 3745, 2817, 2626, 2643},
	98: []int64{80966231, 80972025, 80967147, 80971805, 80971461, 80960856, 80971698, 80968629, 80966792, 80968280, 80965688, 80968160, 80972184, 80967234, 80974374, 80973069, 80969175, 80972462, 80974107, 80971158,
		80973760, 80971466, 80972732, 80976757, 80968959, 80978902, 80973979, 80970096, 80972837, 80971344, 80970522, 80978912, 80973926, 80974815, 80982004, 80972623, 80975529, 80975408, 80974234, 80981847,
		80980402, 80980768, 80982646, 80978686, 80982500, 80984391, 80977749, 80983381, 80981437, 80983425, 80983920, 80977214, 80980461, 80983718, 80975363, 80982565, 80988168, 80977604, 80981236, 80977706,
		80983249, 80985807, 80977272, 80983595, 80987325, 80979731, 80987109, 80984116, 80986864, 80984657, 80983357, 80984733, 80983009, 80974655, 80981406, 80980158, 80977819, 80984935, 80980954, 80983489,
		80994774, 80985680, 80987050, 80996748, 80987352, 80996335, 80992486, 80991240, 80998195, 80990395, 80995222, 80997350, 80996714, 80992828, 80995344, 80991168},
	29: []int64{73268364, 73268360, 73268358, 73268390, 73268427, 73268473, 73268419, 73268500, 73268407, 73268923, 73268921, 73269517, 73269343, 73269023, 73269710, 73268886, 73269368, 73269205, 73268503, 73268660,
		73268870, 73268673, 73268345, 73268344, 73268321, 73268895, 73268583, 73268411, 73268513, 73268571, 73268623, 73268251, 73268411, 73268306, 73268250, 73268253, 73268309, 73268317, 73269368, 73271047,
		73269682, 73268469, 73268720, 73268828, 73269641, 73269243, 73268832, 73269108, 73269050, 73268848, 73268895, 73268571, 73268889, 73268510, 73268253, 73268887, 73268927, 73268972, 73268729, 73268308,
		73268357, 73268252, 73268253, 73268572, 73268261, 73268299, 73268252, 73269763, 73269479, 73268300, 73268898, 73269226, 73268552, 73268331, 73268615, 73268571, 73268839, 73268481, 73268792, 73269221,
		73268894, 73269185, 73269022, 73272474, 73273345, 73276979, 73277015, 73277311, 73277095, 73277128, 73276683, 73276603, 73276938, 73276502, 73276687, 73276890},
	33: []int64{14802617, 14334048, 14652589, 14878941, 14109341, 14296412, 14128174, 14512681, 15409736, 15727532, 15005265, 14784211, 14444092, 14427274, 14440723, 14999719, 14227289, 14192172, 14367760, 14124191,
		15086676, 16296614, 15694711, 14773850, 14615508, 14579159, 14913646, 14818759, 14431242, 14649121, 14070432, 14769608, 14726241, 16565988, 15190989, 15156258, 15454480, 15236560, 14920029, 15467985,
		15690148, 14625978, 14627532, 14433452, 15056912, 16335706, 15852718, 15089894, 15188408, 15779104, 15033057, 15910760, 15677495, 15311713, 14893944, 14156923, 15382805, 16640532, 15618825, 14590669,
		14815275, 13882064, 15580462, 16066677, 15450425, 14709417, 14396746, 14410821, 15454994, 16150884, 15504171, 14596072, 15298748, 15116741, 14893971, 15254242, 14718071, 15552055, 15301147, 14657525,
		15188266, 16529916, 15247158, 14850729, 15175486, 14894463, 14965769, 15417648, 14307234, 15317129, 16306939, 14662144, 15226145, 17060333, 15423605, 15096561},
	49: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	90: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	7: []int64{1419, 1426, 1412, 1413, 1408, 1472, 1426, 1462, 1424, 1447, 1403, 1433, 1429, 1420, 1395, 1447, 1396, 1406, 1413, 1432,
		1420, 1425, 1411, 1432, 1437, 1444, 1407, 1448, 1450, 1477, 1431, 1451, 1437, 1403, 1459, 1478, 1452, 1447, 1446, 1410,
		1441, 1445, 1415, 1433, 1435, 1458, 1419, 1441, 1476, 1310, 1482, 1451, 1458, 1455, 1428, 1446, 1443, 1436, 1449, 1422,
		1394, 1424, 1402, 1417, 1410, 1419, 1432, 1446, 1421, 1440, 1430, 1406, 1463, 1448, 1446, 1432, 1435, 1465, 1484, 1443,
		1451, 1414, 1446, 1412, 1429, 1442, 1424, 1497, 1458, 1490, 1463, 1533, 1482, 1473, 1468, 1467, 294, 294, 293, 0,
	},
	8: []int64{7702, 6548, 8268, 6700, 7397, 6790, 7898, 6476, 6905, 6238, 7278, 6627, 7807, 5958, 6792, 6036, 6789, 6141, 7983, 7889,
		6401, 5709, 6512, 5807, 7728, 5975, 6809, 6144, 7257, 8149, 7885, 6501, 8131, 7308, 6462, 8264, 8044, 6631, 7954, 7046,
		7166, 6704, 7344, 6438, 6346, 6730, 6478, 6916, 7791, 6944, 6179, 7985, 6202, 6726, 8141, 6854, 9215, 6561, 6467, 6547,
		7569, 6386, 7388, 7036, 6134, 6651, 7371, 6545, 11069, 6235, 6345, 6048, 8274, 6422, 7397, 6544, 6905, 7577, 7600, 5693,
		8974, 6178, 6603, 6656, 7968, 7048, 7406, 6370, 7129, 5815, 7886, 6045, 8873, 6834, 7219, 6213, 1852, 583, 753, 0,
	},
	9: []int64{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0,
	},
	15: []int64{16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008,
		16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008,
		16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008,
		16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008,
		16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 16008, 4608, 4608, 4608, 0,
	},
	17: []int64{1855, 1834, 1862, 1838, 1821, 1849, 1840, 1848, 1815, 1852, 1785, 1825, 1867, 1838, 1792, 1869, 1785, 1816, 1863, 1889,
		1805, 1827, 1782, 1819, 1871, 1824, 1805, 1853, 1808, 1897, 1850, 1870, 1869, 1895, 1795, 1964, 1888, 1840, 1883, 1873,
		1820, 1852, 1876, 1827, 1830, 1875, 1783, 1860, 1907, 1884, 1807, 2046, 1773, 1888, 1865, 1850, 2686, 1882, 1787, 1846,
		1887, 1844, 1868, 1871, 1811, 1853, 1844, 1857, 2700, 1856, 1804, 1854, 1871, 1853, 1839, 1846, 1812, 1915, 1855, 1819,
		2646, 1849, 1798, 1855, 1872, 1891, 1853, 1894, 1852, 1855, 1890, 1876, 2635, 1918, 1830, 1827, 560, 424, 451, 0,
	},
	18: []int64{2745, 2574, 2728, 2623, 2638, 2583, 2711, 2612, 2594, 2616, 2601, 2536, 2746, 2556, 2605, 2627, 2593, 2500, 2714, 2551,
		2718, 2599, 2578, 2556, 2754, 2559, 2623, 2636, 2605, 2741, 2728, 2596, 2758, 2718, 2626, 2855, 2783, 2582, 2791, 2663,
		2683, 2619, 2764, 2556, 2648, 2642, 2580, 2626, 2764, 2686, 2677, 2974, 2597, 2663, 2737, 2633, 3805, 2649, 2633, 2613,
		2760, 2622, 2757, 2680, 2623, 2607, 2699, 2602, 3839, 2600, 2643, 2570, 2757, 2608, 2675, 2572, 2619, 2680, 2749, 2580,
		3712, 2635, 2619, 2597, 2783, 2681, 2684, 2702, 2718, 2585, 2802, 2617, 3739, 2738, 2666, 2565, 532, 386, 412, 0,
	},
	19: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0,
	},
	20: []int64{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 2, 0,
	},
	21: []int64{196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196,
		196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 4, 4, 4, 0,
	},
	22: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	27: []int64{29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682,
		29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682,
		29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682,
		29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682,
		29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 29682, 131, 131, 131, 0,
	},
	30: []int64{73268344, 73268280, 73268276, 73268344, 73268348, 73268280, 73268164, 73268236, 73268168, 73268232, 73268152, 73268232, 73268164, 73268236, 73268164, 73268244, 73268232, 73268232, 73268260, 73268256,
		73268328, 73268324, 73268256, 73268324, 73268232, 73268232, 73268232, 73268232, 73268232, 73268152, 73268164, 73268232, 73268232, 73268232, 73268164, 73268232, 73268164, 73268232, 73268236, 73271020,
		73268232, 73268236, 73268168, 73268232, 73268232, 73268236, 73268164, 73268232, 73268232, 73268232, 73268232, 73268232, 73268232, 73268232, 73268232, 73268232, 73268432, 73268396, 73268244, 73268232,
		73268232, 73268164, 73268232, 73268232, 73268236, 73268232, 73268232, 73268232, 73268232, 73268164, 73268232, 73269180, 73268232, 73268232, 73268232, 73268428, 73268248, 73268244, 73268232, 73268244,
		73268244, 73268180, 73268244, 73268248, 73272328, 73274396, 73276432, 73276432, 73276444, 73276424, 73276424, 73276424, 73276424, 73276344, 73276424, 73276424, 14890228, 14890228, 14890240, 0,
	},
	31: []int64{73268368, 73268372, 73268372, 73268568, 73269088, 73269596, 73270732, 73271360, 73270648, 73270648, 73271360, 73271128, 73270648, 73270652, 73271360, 73272952, 73270648, 73271460, 73270744, 73270744,
		73271452, 73270824, 73268432, 73268356, 73268928, 73270736, 73270736, 73270648, 73270976, 73270732, 73270648, 73268256, 73270648, 73268972, 73268300, 73268260, 73268648, 73268960, 73271048, 73271116,
		73272952, 73270492, 73270652, 73271360, 73272480, 73271084, 73271364, 73270652, 73270648, 73271360, 73271080, 73270648, 73270648, 73270168, 73268260, 73270840, 73271560, 73271136, 73270904, 73268840,
		73269812, 73268340, 73268256, 73270652, 73268344, 73268968, 73268260, 73273700, 73273612, 73268984, 73271852, 73269560, 73271360, 73269444, 73270892, 73270344, 73271104, 73271008, 73270988, 73271360,
		73271312, 73270796, 73273624, 73275220, 73274936, 73279560, 73278936, 73279296, 73278852, 73279436, 73278840, 73278840, 73279544, 73276620, 73278848, 73280600, 14890312, 14890240, 14891172, 0,
	},
	34: []int64{13573636, 13002248, 13232404, 13175356, 13275844, 13230176, 13127300, 13568144, 13612048, 14592480, 13627248, 13985164, 13411512, 13174864, 12907024, 13597756, 13035444, 13325464, 12784236, 13117220,
		14368280, 14369512, 14242768, 13654828, 13504268, 13671344, 13702612, 13565052, 13809900, 14009700, 13128836, 13452396, 13911836, 15183136, 14288752, 13997060, 14624404, 13999096, 13946744, 14215416,
		14398652, 13538060, 12956208, 13435088, 14117772, 13809576, 14619364, 14017428, 14045920, 14123604, 13776464, 14910084, 14461688, 14374812, 13518124, 13266716, 13290340, 15790532, 14513540, 13337576,
		13707496, 12310184, 14176152, 14751044, 14524840, 13523504, 13161340, 13209344, 14672408, 14764948, 14025352, 13578740, 13831184, 13996332, 14060404, 13740364, 13589484, 14216632, 13945008, 13504136,
		14340892, 14902536, 14285608, 13537676, 14050268, 12958476, 14072020, 13737044, 13660844, 14156448, 15279864, 13640448, 14496604, 15288784, 14111028, 13936984, 4518340, 4622284, 4559412, 0,
	},
	35: []int64{16451724, 15740832, 16075320, 16662552, 14687076, 15559032, 15035376, 15928468, 17382060, 17301940, 16063212, 15857696, 15416452, 15831532, 16184788, 16503796, 15361564, 15465240, 15591476, 15277916,
		16013604, 18002948, 16912700, 16135880, 16086316, 15500396, 17031640, 16554584, 15236076, 15360668, 15132064, 17019276, 16012024, 17925268, 16065972, 16684352, 16621572, 16073528, 16623412, 17827680,
		16495588, 15456200, 16758360, 15778444, 16543684, 18657400, 18034944, 16920652, 16651804, 17215456, 17034072, 17876912, 17218256, 16420608, 16388500, 14953544, 17862656, 17755284, 17335396, 15667204,
		16453040, 15328760, 17585044, 17356552, 16685544, 15928732, 15615012, 15483988, 16272684, 17680048, 17019220, 15510164, 16777088, 16537912, 15886852, 16338096, 15759460, 16660716, 17019064, 15951896,
		16177416, 18331856, 16097232, 15953764, 16517084, 16434732, 16266236, 16630780, 15445868, 16788272, 17628480, 16335328, 16473208, 18507932, 17039820, 17177604, 5901968, 5127288, 5483576, 0,
	},
	37: []int64{1133164, 1133556, 1132948, 1132536, 1132687, 1133608, 1133749, 1133162, 1133226, 1135034, 1132928, 1130504, 1130466, 1127930, 1127539, 1127419, 1126692, 1125126, 1123936, 1123639,
		1124080, 1123182, 1123585, 1123228, 1122690, 1125536, 1125400, 1126177, 1125636, 1125881, 1126043, 1125876, 1126648, 1125743, 1125018, 1125371, 1125976, 1127658, 1127351, 1127686,
		1124517, 1124154, 1124262, 1124115, 1123758, 1124131, 1124254, 1124213, 1123537, 1123298, 1123893, 1123808, 1123529, 1123294, 1123588, 1123590, 1123511, 1123305, 1123449, 1122702,
		1120122, 1118483, 1120873, 1120026, 1119508, 1118141, 1116332, 1117074, 1117943, 1118530, 1118493, 1119064, 1119641, 1119993, 1120578, 1120717, 1121297, 1121658, 1121876, 1121164,
		1120189, 1118066, 1117956, 1117838, 1118358, 1117828, 1115200, 1114318, 1114018, 1115218, 1115605, 1116157, 1116889, 1118043, 1117833, 1118344, 0, 0, 0, 0,
	},
	38: []int64{1132264, 1132876, 1132384, 1131660, 1131872, 1132060, 1133136, 1132780, 1132640, 1133488, 1131120, 1129464, 1129632, 1126672, 1127056, 1126920, 1125480, 1124752, 1123396, 1122604,
		1122968, 1122800, 1123056, 1122520, 1122064, 1123224, 1125052, 1125684, 1125204, 1125464, 1125496, 1125228, 1125624, 1125508, 1124612, 1124848, 1124632, 1127172, 1126804, 1127332,
		1124032, 1123832, 1123756, 1123700, 1123444, 1123928, 1123924, 1123364, 1122904, 1123072, 1123112, 1123276, 1123036, 1123052, 1123296, 1122964, 1123380, 1122864, 1122680, 1122496,
		1118300, 1117848, 1120032, 1119496, 1117980, 1117040, 1115356, 1116388, 1117464, 1118092, 1118000, 1118240, 1119296, 1119428, 1120028, 1119716, 1120656, 1120840, 1121528, 1120408,
		1119624, 1117096, 1117664, 1117132, 1117776, 1116904, 1114352, 1113940, 1113740, 1113848, 1115252, 1115068, 1116460, 1117764, 1117288, 1117388, 0, 0, 0, 0,
	},
	39: []int64{1134064, 1133888, 1133276, 1133192, 1133524, 1134976, 1134692, 1133616, 1133920, 1136052, 1135580, 1131236, 1130960, 1129384, 1127876, 1128104, 1127552, 1125508, 1124832, 1124620,
		1125204, 1123664, 1124280, 1123960, 1123272, 1126440, 1125924, 1126524, 1126032, 1126188, 1126616, 1126588, 1127508, 1126272, 1125348, 1126056, 1127596, 1128352, 1128132, 1128284,
		1125216, 1124744, 1124736, 1124616, 1124636, 1124380, 1124460, 1124596, 1124072, 1123452, 1124528, 1124260, 1123956, 1123600, 1123916, 1124012, 1123756, 1123820, 1123672, 1123008,
		1122752, 1119104, 1121480, 1120868, 1119976, 1119144, 1117272, 1117404, 1118668, 1119372, 1118868, 1119612, 1119992, 1120568, 1121432, 1121404, 1121876, 1121984, 1122428, 1121896,
		1120704, 1119616, 1118340, 1119168, 1118960, 1118660, 1115880, 1114716, 1114284, 1116084, 1116240, 1116992, 1117680, 1118596, 1118360, 1118904, 0, 0, 0, 0,
	},
	41: []int64{1055673, 1055611, 1055552, 1055515, 1055476, 1055412, 1055381, 1055362, 1055339, 1055315, 1054702, 1054162, 1053129, 1053072, 1053034, 1053001, 1052964, 1052902, 1053140, 1053065,
		1052986, 1052956, 1052937, 1053154, 1053106, 1053207, 1053163, 1053114, 1053076, 1053048, 1053021, 1052985, 1052934, 1052884, 1052877, 1053076, 1053086, 1053020, 1052979, 1052925,
		1052908, 1052834, 1052773, 1052745, 1052715, 1052707, 1052783, 1052930, 1052939, 1052823, 1052902, 1052858, 1052810, 1052757, 1052723, 1052703, 1052680, 1052659, 1052649, 1052844,
		1052912, 1052870, 1052881, 1052877, 1052824, 1052791, 1052763, 1052717, 1052664, 1052715, 1052572, 1052357, 1052434, 1052378, 1052343, 1052500, 1052423, 1052385, 1052362, 1052328,
		1052257, 1051141, 1050565, 1050688, 1050780, 1050854, 1050744, 1050700, 1050671, 1050642, 1050621, 1050643, 1050660, 1050640, 1050610, 1050777, 0, 0, 0, 0,
	},
	42: []int64{1055544, 1055588, 1055528, 1055500, 1055440, 1055388, 1055376, 1055348, 1055328, 1055304, 1054396, 1052844, 1053096, 1053052, 1053016, 1052988, 1052920, 1052896, 1053104, 1053060,
		1052976, 1052948, 1052932, 1052864, 1053084, 1053024, 1053136, 1053100, 1053060, 1053032, 1053012, 1052968, 1052892, 1052880, 1052864, 1052844, 1053060, 1053004, 1052944, 1052912,
		1052788, 1052812, 1052760, 1052732, 1052708, 1052704, 1052684, 1052716, 1052880, 1052808, 1052780, 1052844, 1052784, 1052740, 1052712, 1052692, 1052664, 1052652, 1052644, 1052640,
		1052896, 1052852, 1052808, 1052852, 1052808, 1052784, 1052748, 1052704, 1052656, 1052632, 1052176, 1052164, 1052408, 1052364, 1052320, 1052444, 1052396, 1052368, 1052344, 1052312,
		1052244, 1050592, 1050528, 1050524, 1050756, 1050812, 1050736, 1050684, 1050656, 1050632, 1050616, 1050572, 1050648, 1050632, 1050604, 1050588, 0, 0, 0, 0,
	},
	43: []int64{1056120, 1055628, 1055588, 1055528, 1055500, 1055432, 1055388, 1055376, 1055348, 1055328, 1055308, 1054744, 1053152, 1053096, 1053052, 1053016, 1052988, 1052916, 1053220, 1053072,
		1053000, 1052968, 1052948, 1053416, 1053128, 1053340, 1053208, 1053136, 1053100, 1053056, 1053028, 1053008, 1052964, 1052892, 1052884, 1053172, 1053112, 1053040, 1053000, 1052940,
		1053068, 1052856, 1052792, 1052752, 1052724, 1052708, 1053040, 1053028, 1052968, 1052844, 1052988, 1052876, 1052832, 1052780, 1052732, 1052712, 1052692, 1052664, 1052652, 1052976,
		1052924, 1052892, 1053072, 1052904, 1052840, 1052800, 1052780, 1052728, 1052668, 1052884, 1052676, 1052504, 1052468, 1052404, 1052364, 1052556, 1052444, 1052392, 1052368, 1052348,
		1052308, 1052236, 1050592, 1050860, 1050808, 1050944, 1050752, 1050724, 1050680, 1050648, 1050624, 1050824, 1050672, 1050648, 1050612, 1050948, 0, 0, 0, 0,
	},
	91: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	92: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	99: []int64{80955148, 80960404, 80957508, 80955548, 80957400, 80950612, 80956196, 80958740, 80954664, 80951436, 80955712, 80955416, 80957924, 80959820, 80956868, 80955900, 80960360, 80957508, 80957732, 80957688,
		80959004, 80958536, 80957416, 80963656, 80959360, 80961324, 80960448, 80959620, 80957772, 80962312, 80959300, 80965516, 80958040, 80961036, 80967952, 80962692, 80961740, 80960276, 80962328, 80963768,
		80969220, 80964288, 80966832, 80969276, 80967472, 80966404, 80967664, 80968120, 80969608, 80970192, 80967012, 80963952, 80963904, 80968148, 80969840, 80968256, 80971992, 80965796, 80967800, 80969552,
		80967412, 80971864, 80966940, 80966896, 80972116, 80967868, 80969156, 80971276, 80972072, 80968776, 80973300, 80966892, 80966320, 80968164, 80967288, 80966168, 80966892, 80971512, 80967080, 80970084,
		80979524, 80974924, 80972848, 80981664, 80977260, 80979240, 80982364, 80978940, 80979776, 80982316, 80979048, 80983128, 80978060, 80978928, 80982384, 80981824, 18079872, 18080924, 18080340, 0,
	},
	100: []int64{80996308, 81003320, 80991996, 81001012, 81007940, 80983840, 81010980, 80990568, 81003736, 81002540, 80987020, 80990684, 81000464, 80989804, 81013404, 81007044, 80992728, 81003756, 80996512, 81009852,
		81003316, 80996392, 80995840, 81005208, 80991676, 81015008, 81001284, 80992808, 80998680, 81006744, 81000124, 81007504, 81013256, 81010716, 81011904, 80995596, 81007392, 80999712, 80999676, 81005240,
		81000508, 81020312, 81008460, 81006528, 81001688, 81017056, 80995256, 81012348, 81003216, 81018092, 81018360, 81002940, 81017784, 81031588, 80990180, 81009528, 81020616, 81019428, 81003884, 81001308,
		81025468, 81010316, 80994628, 81013328, 81019276, 80998984, 81018968, 81005740, 81025968, 81007368, 81007112, 81017240, 81017928, 80988336, 81018752, 81007952, 81019756, 81022204, 81003308, 81016856,
		81021608, 81015380, 81012848, 81022628, 81009976, 81023636, 81018212, 81020392, 81021388, 81007928, 81025372, 81028804, 81037136, 81019656, 81018072, 81023468, 18107732, 18088460, 18093904, 0,
	},
	102: []int64{3493174, 3492757, 3492740, 3493216, 3493191, 3493195, 3493207, 3493435, 3493248, 3492551, 3493147, 3493026, 3492751, 3492580, 3492757, 3492723, 3492774, 3492555, 3493055, 3492784,
		3492681, 3493216, 3492830, 3492892, 3492948, 3493046, 3493060, 3493087, 3492704, 3492637, 3492534, 3492642, 3492200, 3491916, 3492401, 3492365, 3492496, 3492244, 3492346, 3492494,
		3492328, 3492643, 3492845, 3492800, 3492768, 3492817, 3492966, 3492993, 3492775, 3492814, 3492854, 3492624, 3492659, 3492556, 3492909, 3492991, 3492511, 3492570, 3492676, 3493124,
		3493161, 3492891, 3492730, 3492821, 3492603, 3492387, 3492922, 3492765, 3492628, 3492580, 3492887, 3493048, 3492725, 3492645, 3492413, 3492408, 3492389, 3492519, 3492265, 3492381,
		3492345, 3492567, 3492055, 3492620, 3492210, 3492316, 3492033, 3491852, 3492023, 3492222, 3492334, 3492414, 3492141, 3492333, 3492270, 3492054, 99800, 99966, 100021, 0,
	},
	103: []int64{3492168, 3491848, 3491912, 3492200, 3492136, 3492088, 3491976, 3492280, 3492072, 3491768, 3491880, 3491992, 3491736, 3491608, 3491704, 3491720, 3491688, 3491400, 3492008, 3491704,
		3491496, 3491944, 3491672, 3491816, 3491640, 3491864, 3492152, 3491896, 3491336, 3491176, 3491016, 3491640, 3491112, 3490792, 3491272, 3491448, 3491592, 3491192, 3491352, 3491320,
		3491480, 3491416, 3491848, 3491864, 3491528, 3491832, 3491544, 3491624, 3491720, 3491656, 3491656, 3491464, 3491624, 3491608, 3492024, 3491960, 3491688, 3491112, 3491496, 3491928,
		3492040, 3491688, 3491400, 3491480, 3491528, 3491352, 3492152, 3491736, 3491348, 3491540, 3491764, 3491956, 3491508, 3491412, 3491316, 3491348, 3491460, 3491508, 3491348, 3491172,
		3491092, 3491288, 3490760, 3491264, 3491200, 3490984, 3490696, 3490568, 3490648, 3490824, 3491256, 3491240, 3491064, 3491192, 3491240, 3490744, 99416, 99752, 99704, 0,
	},
	104: []int64{3494072, 3493528, 3493720, 3494312, 3494168, 3494232, 3494216, 3494440, 3494360, 3493752, 3494504, 3494296, 3493784, 3493864, 3494424, 3493848, 3494056, 3493704, 3494152, 3494024,
		3493976, 3494216, 3493864, 3493912, 3494104, 3494264, 3494168, 3494248, 3493736, 3493960, 3494008, 3493464, 3493352, 3493128, 3493672, 3493528, 3493336, 3493336, 3493304, 3493496,
		3493288, 3493720, 3494040, 3493896, 3494104, 3494120, 3494264, 3494280, 3493880, 3493896, 3493928, 3493832, 3493720, 3493592, 3493816, 3493912, 3493496, 3493912, 3493672, 3494024,
		3494168, 3494264, 3493768, 3493832, 3493544, 3493480, 3494008, 3493768, 3493700, 3493556, 3493988, 3494212, 3494020, 3493828, 3493748, 3493476, 3493364, 3493556, 3493188, 3493604,
		3493576, 3493864, 3492936, 3493728, 3493120, 3493336, 3493016, 3492952, 3493080, 3493336, 3493352, 3493448, 3493144, 3493640, 3493320, 3493560, 100088, 100312, 100392, 0,
	},
	105: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	106: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	107: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	108: []int64{100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136,
		100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136,
		100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136,
		100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136,
		100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 100443136, 33440768, 33440768, 33440768, 0,
	},
	109: []int64{72669222, 72668798, 72669432, 72669934, 72669814, 72668820, 72668626, 72669167, 72669100, 72667309, 72669518, 72671803, 72671876, 72674528, 72674987, 72675130, 72675893, 72677596, 72678840, 72679130,
		72678625, 72679555, 72679104, 72679477, 72680094, 72677130, 72677211, 72676337, 72676877, 72676613, 72676430, 72676661, 72675813, 72676695, 72677409, 72677011, 72676365, 72674592, 72674894, 72674587,
		72677618, 72677960, 72677989, 72678323, 72678753, 72677997, 72677835, 72677884, 72678533, 72678783, 72678153, 72678332, 72678647, 72679004, 72678684, 72678613, 72678731, 72678783, 72678797, 72679536,
		72682196, 72683921, 72681372, 72682292, 72682820, 72684300, 72686184, 72685409, 72684595, 72683952, 72683983, 72683356, 72682772, 72682415, 72681736, 72681594, 72680926, 72680580, 72680310, 72681090,
		72682132, 72684368, 72684699, 72688731, 72688798, 72693599, 72696711, 72697646, 72697938, 72696678, 72696250, 72695584, 72694773, 72693560, 72693871, 72693294, 14715452, 14715452, 14715452, 0,
	},
	110: []int64{96343490, 96342832, 96342800, 96342813, 96342773, 96342675, 96342782, 96342826, 96342815, 96342861, 96342789, 96341979, 96340788, 96342668, 96342873, 96342834, 96343836, 96344837, 96344957, 96344919,
		96344922, 96344913, 96344860, 96344784, 96342984, 96342845, 96342836, 96342835, 96342796, 96342736, 96342898, 96341904, 96340786, 96340814, 96340822, 96340680, 96340807, 96340771, 96340876, 96340861,
		96340790, 96342570, 96342010, 96340804, 96340866, 96340821, 96340878, 96340695, 96340747, 96340721, 96340671, 96340718, 96340694, 96340533, 96340689, 96340734, 96340601, 96342637, 96342677, 96342548,
		96341423, 96340784, 96340744, 96340733, 96340718, 96340553, 96340810, 96340796, 96338504, 96340784, 96340735, 96341365, 96342774, 96342974, 96342750, 96342740, 96342711, 96339961, 96338666, 96338781,
		96336571, 96338619, 96338627, 96338497, 96339187, 96340659, 96341191, 96340702, 96340668, 96340546, 96340669, 96340734, 96339668, 96341872, 96340711, 96340541, 31694132, 31694104, 31694086, 0,
	},
	111: []int64{35632290, 35304782, 35227097, 35519814, 35125423, 34976530, 34924498, 35243128, 35664707, 36446316, 35876655, 35535231, 35289302, 35106530, 34678142, 35814198, 34900775, 34783747, 34930870, 34849678,
		35598604, 36742932, 36565451, 35517423, 35388206, 35389394, 35231873, 35493640, 35414609, 35526398, 35058473, 35362573, 35161627, 37159410, 36158944, 35771391, 36214553, 35906735, 35450783, 35904378,
		36413394, 35474727, 35190698, 34936447, 35688174, 37181402, 36150647, 35858610, 36253248, 36363912, 35830285, 36718428, 36200915, 36164304, 35874877, 34981992, 36086876, 37201282, 36061698, 35405163,
		35497549, 34623703, 35548273, 36554619, 36022158, 35613522, 35251515, 35192877, 36187359, 36897172, 35976279, 35386235, 35895938, 36021694, 35603572, 35667641, 35231012, 36123482, 35816696, 35626919,
		35994572, 37177668, 35848603, 35831990, 35926579, 35576224, 35488252, 35996734, 35238379, 36125143, 36828845, 35485371, 35885228, 37879992, 36198896, 35990422, 6872535, 6728553, 6911962, 0,
	},
	112: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	138: []int64{2696, 2502, 2601, 2536, 2519, 2635, 2854, 2456, 2870, 2725, 2702, 2544, 3016, 2605, 2896, 2610, 2536, 2614, 2979, 2597,
		2915, 2805, 2712, 2560, 2940, 2773, 3052, 2688, 2800, 2765, 2964, 2692, 3180, 3094, 2709, 2784, 3084, 2804, 2980, 2969,
		3072, 2794, 2890, 2363, 2617, 2474, 2405, 2394, 2921, 3178, 2663, 4804, 2547, 2631, 2915, 2554, 4245, 2754, 2678, 2350,
		2891, 2771, 2865, 2622, 2703, 2574, 2899, 2658, 3804, 2875, 2813, 2824, 3045, 2767, 2961, 2576, 2811, 3421, 2954, 2718,
		4225, 2811, 2863, 2896, 3039, 2705, 2992, 2736, 2877, 2591, 3146, 3090, 4025, 2644, 2625, 2336, 580, 302, 408, 0,
	},
	139: []int64{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 2, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0,
	},
	150: []int64{768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 256000, 256000, 256000, 0,
	},
	151: []int64{768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000,
		768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 768000, 256000, 256000, 256000, 0,
	},
	152: []int64{2213, 2079, 2147, 2099, 2074, 2207, 2243, 2166, 2281, 2328, 2138, 2557, 2312, 2132, 2297, 2117, 2136, 2198, 2207, 2191,
		2212, 2273, 2153, 2224, 2200, 2173, 2464, 2212, 2204, 2239, 2143, 2259, 2392, 2422, 2161, 3320, 2306, 2153, 2355, 2193,
		2206, 2286, 2235, 2130, 2214, 2262, 2225, 2141, 2546, 3101, 2206, 5338, 2174, 2298, 2126, 2158, 4908, 2354, 2179, 2253,
		2143, 2207, 2318, 2225, 2115, 2121, 2181, 2232, 4384, 2284, 2241, 2183, 2185, 2218, 2250, 2158, 2083, 4414, 2212, 2222,
		5061, 2300, 2184, 2339, 2374, 2237, 2267, 2241, 2396, 2467, 2248, 2686, 4545, 2561, 2263, 2135, 580, 561, 564, 0,
	},
	153: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	157: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	158: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	159: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	256: []int64{245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245,
		245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245,
		245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245,
		245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245,
		245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245,
	},
	257: []int64{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	},
	258: []int64{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	},
	259: []int64{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	},
	260: []int64{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	},
	261: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	262: []int64{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	},
	263: []int64{227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227,
		227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227,
		227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227,
		227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227,
		227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227,
	},
	264: []int64{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
	},
	265: []int64{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	},
	266: []int64{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	},
	267: []int64{95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
		95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
		95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
		95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
		95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
	},
	268: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	269: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	270: []int64{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	},
	271: []int64{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	},
	272: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	273: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	274: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	275: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	2: []int64{1662, 1651, 1690, 1658, 1631, 1674, 1648, 1680, 1609, 1689, 1591, 1643, 1680, 1658, 1602, 1698, 1590, 1633, 1670, 1729,
		1593, 1655, 1584, 1636, 1683, 1646, 1615, 1677, 1615, 1731, 1659, 1700, 1665, 1752, 1601, 1825, 1698, 1663, 1713, 1706,
		1635, 1682, 1697, 1641, 1632, 1703, 1585, 1690, 1723, 1713, 1608, 1928, 1570, 1717, 1680, 1673, 2404, 1713, 1595, 1670,
		1706, 1666, 1698, 1704, 1606, 1679, 1656, 1688, 2429, 1683, 1614, 1674, 1679, 1681, 1665, 1667, 1620, 1755, 1668, 1631,
		2364, 1670, 1610, 1690, 1683, 1730, 1665, 1727, 1666, 1677, 1714, 1700, 2340, 1760, 1641, 1651, 0,
	},
	3: []int64{886, 891, 882, 883, 880, 920, 891, 913, 890, 904, 876, 895, 893, 887, 871, 904, 872, 878, 883, 895,
		887, 890, 881, 895, 898, 902, 879, 905, 906, 923, 894, 906, 898, 876, 911, 923, 907, 904, 903, 881,
		900, 903, 884, 895, 896, 911, 886, 900, 922, 818, 926, 906, 911, 909, 892, 903, 901, 897, 905, 888,
		871, 890, 876, 885, 881, 886, 895, 903, 888, 900, 893, 878, 914, 905, 903, 895, 896, 915, 927, 901,
		906, 883, 903, 882, 893, 901, 890, 935, 911, 931, 914, 958, 926, 920, 917, 916, 183, 183, 183, 0,
	},
	4: []int64{4813, 4092, 5167, 4187, 4623, 4243, 4936, 4047, 4315, 3898, 4548, 4141, 4879, 3723, 4245, 3772, 4243, 3838, 4989, 4930,
		4000, 3568, 4070, 3629, 4830, 3734, 4255, 3840, 4535, 5093, 4928, 4063, 5081, 4567, 4038, 5165, 5027, 4144, 4971, 4403,
		4478, 4190, 4590, 4023, 3966, 4206, 4048, 4322, 4869, 4340, 3861, 4990, 3876, 4203, 5088, 4283, 5759, 4100, 4041, 4091,
		4730, 3991, 4617, 4397, 3833, 4156, 4606, 4090, 6918, 3896, 3965, 3780, 5171, 4013, 4623, 4090, 4315, 4735, 4750, 3558,
		5608, 3861, 4126, 4160, 4980, 4405, 4628, 3981, 4455, 3634, 4928, 3778, 5545, 4271, 4511, 3883, 1157, 364, 470, 0,
	},
	24: []int64{8408, 8409, 8408, 8409, 8409, 8408, 8409, 8408, 8408, 8408, 8408, 8408, 8409, 8408, 8409, 8409, 8408, 8409, 8409, 8408,
		8409, 8409, 8409, 8409, 8408, 8409, 8409, 8408, 8409, 8408, 8408, 8409, 8409, 8409, 8410, 8409, 8409, 8409, 8409, 8410,
		8409, 8409, 8410, 8409, 8410, 8410, 8409, 8410, 8410, 8410, 8410, 8409, 8409, 8410, 8409, 8410, 8410, 8409, 8409, 8409,
		8410, 8410, 8409, 8410, 8410, 8409, 8410, 8410, 8410, 8410, 8410, 8410, 8410, 8409, 8409, 8409, 8409, 8410, 8409, 8410,
		8411, 8410, 8410, 8411, 8410, 8411, 8411, 8410, 8411, 8410, 8411, 8411, 8411, 8411, 8411, 8410, 1810, 1810, 1810, 0,
	},
	25: []int64{8407, 8407, 8407, 8407, 8407, 8406, 8407, 8407, 8407, 8406, 8407, 8407, 8407, 8407, 8407, 8407, 8407, 8407, 8407, 8407,
		8407, 8407, 8407, 8408, 8407, 8407, 8407, 8407, 8407, 8407, 8407, 8408, 8407, 8407, 8408, 8408, 8407, 8407, 8407, 8408,
		8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408,
		8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8409, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408, 8408,
		8409, 8409, 8408, 8409, 8409, 8409, 8409, 8409, 8409, 8409, 8409, 8410, 8409, 8409, 8409, 8409, 1809, 1810, 1809, 0,
	},
	50: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	26: []int64{8411, 8412, 8411, 8412, 8412, 8410, 8413, 8411, 8412, 8412, 8410, 8411, 8412, 8410, 8413, 8412, 8411, 8412, 8411, 8412,
		8412, 8411, 8411, 8412, 8411, 8413, 8412, 8411, 8411, 8412, 8411, 8412, 8413, 8412, 8413, 8411, 8412, 8411, 8411, 8412,
		8411, 8413, 8412, 8412, 8412, 8413, 8411, 8413, 8412, 8413, 8413, 8412, 8413, 8415, 8410, 8412, 8413, 8413, 8412, 8412,
		8414, 8413, 8411, 8413, 8413, 8411, 8413, 8412, 8414, 8412, 8412, 8413, 8413, 8410, 8413, 8412, 8413, 8414, 8412, 8413,
		8414, 8413, 8413, 8414, 8412, 8414, 8413, 8413, 8414, 8412, 8414, 8414, 8415, 8413, 8413, 8414, 1812, 1810, 1811, 0,
	},
	51: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
}

var DatastoreMetricData = map[int32][]int64{
	180: []int64{1, 5, 3, 1, 3, 39, 19, 13, 5, 0, 1, 0, 1, 1, 1, 1, 1, 1, 15, 9,
		17, 1, 2, 0, 1, 25, 0, 13, 23, 4, 26, 7, 2, 2, 480, 1, 0, 55, 2, 4,
		1, 0, 5, 6, 6, 18, 3, 155, 120, 13, 330, 7, 10, 2, 0, 247, 1, 1, 89, 1,
		22, 13, 18, 2, 11, 0, 1, 184, 4, 0, 1, 1, 0, 1, 0, 5, 595, 1, 37, 320,
		7, 9, 73, 27, 2, 7, 5, 4, 149, 0, 2, 190, 13, 14, 0, 0, 0, 0},
	181: []int64{433, 464, 439, 426, 490, 460, 455, 510, 544, 466, 657, 526, 457, 538, 448, 456, 488, 482, 470, 479,
		506, 470, 500, 469, 479, 591, 495, 474, 483, 448, 486, 567, 553, 461, 522, 506, 455, 497, 470, 470,
		516, 485, 434, 480, 501, 477, 448, 468, 783, 473, 1630, 454, 516, 430, 457, 912, 546, 483, 424, 444,
		471, 535, 466, 445, 442, 471, 505, 738, 525, 512, 480, 463, 499, 514, 469, 424, 937, 485, 460, 920,
		528, 475, 480, 466, 445, 503, 474, 497, 452, 489, 687, 781, 555, 498, 447, 0, 0, 0},
	187: []int64{434, 469, 442, 427, 493, 499, 474, 523, 549, 466, 658, 526, 458, 539, 449, 457, 489, 483, 485, 488,
		523, 471, 502, 469, 480, 616, 495, 487, 506, 452, 512, 574, 555, 463, 1002, 507, 455, 552, 472, 474,
		517, 485, 439, 486, 507, 495, 451, 623, 903, 486, 1960, 461, 526, 432, 457, 1159, 547, 484, 513, 445,
		493, 548, 484, 447, 453, 471, 506, 922, 529, 512, 481, 464, 499, 515, 469, 429, 1532, 486, 497, 1240,
		535, 484, 553, 493, 447, 510, 479, 501, 601, 489, 689, 971, 568, 512, 447, 0, 0, 0},
	281: []int64{174225912, 174227200, 174230104, 174230532, 174237664, 174237600, 174239588, 174235728, 174234644, 174234904, 174235132, 174236888, 174237012, 174240640, 174240148, 174246032},
	282: []int64{3536110027, 3536111315, 3536114219, 3536114647, 3536121779, 3536121715, 3536123703, 3536119843, 3536118759, 3536066971, 3536067199, 3536067623, 3536067747, 3536066811, 3536066319, 3536066979},
	283: []int64{426434020, 426425152, 426411808, 426402768, 426387204, 426370512, 426355764, 426340480, 426076860, 426176184, 426064540, 426487536, 426370184, 426424376, 426320528, 426406408},
	286: []int64{3536110027, 3536111315, 3536114219, 3536114647, 3536121779, 3536121715, 3536123703, 3536119843, 3536118759, 3536066971, 3536067199, 3536067623, 3536067747, 3536066811, 3536066319, 3536066979},
	287: []int64{174225912, 174227200, 174230104, 174230532, 174237664, 174237600, 174239588, 174235728, 174234644, 174234904, 174235132, 174236888, 174237012, 174240640, 174240148, 174246032},
	288: []int64{133298, 133303, 133311, 133316, 133328, 133337, 133346, 133352, 133491, 133437, 133496, 133273, 133335, 133308, 133363, 133320},
}

var DatacenterMetricData = map[int32][]int64{
	256: []int64{1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
		1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
		1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
		1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
		1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
	},
	257: []int64{833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833,
		833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833,
		833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833,
		833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833,
		833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833,
	},
	258: []int64{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	},
	259: []int64{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	},
	260: []int64{151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,
		151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,
		151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,
		151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,
		151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,
	},
	261: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	262: []int64{353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
		353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
		353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
		353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
		353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
	},
	263: []int64{598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598,
		598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598,
		598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598,
		598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598,
		598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598, 598,
	},
	264: []int64{1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
		1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
		1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
		1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
		1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
	},
	265: []int64{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
		19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
		19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
		19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
		19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
	},
	266: []int64{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
		16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
		16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
		16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
		16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	},
	267: []int64{3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409,
		3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409,
		3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409,
		3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409,
		3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409, 3409,
	},
	268: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	269: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	270: []int64{646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646,
		646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646,
		646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646,
		646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646,
		646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646,
	},
	271: []int64{34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
		34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
		34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
		34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
		34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
	},
	272: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	273: []int64{3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
		3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
		3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
		3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
		3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082, 3082,
	},
	274: []int64{124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
		124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
	},
	275: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
}
