/*
Copyright (c) 2014-2024 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types

import (
	"reflect"
	"time"
)

type AbandonHciWorkflow AbandonHciWorkflowRequestType

func init() {
	t["AbandonHciWorkflow"] = reflect.TypeOf((*AbandonHciWorkflow)(nil)).Elem()
}

type AbandonHciWorkflowRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AbandonHciWorkflowRequestType"] = reflect.TypeOf((*AbandonHciWorkflowRequestType)(nil)).Elem()
}

type AbandonHciWorkflowResponse struct {
}

type AbdicateDomOwnership AbdicateDomOwnershipRequestType

func init() {
	t["AbdicateDomOwnership"] = reflect.TypeOf((*AbdicateDomOwnership)(nil)).Elem()
}

// The parameters of `HostVsanInternalSystem.AbdicateDomOwnership`.
type AbdicateDomOwnershipRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// List of VSAN/DOM object UUIDs.
	Uuids []string `xml:"uuids" json:"uuids"`
}

func init() {
	t["AbdicateDomOwnershipRequestType"] = reflect.TypeOf((*AbdicateDomOwnershipRequestType)(nil)).Elem()
}

type AbdicateDomOwnershipResponse struct {
	Returnval []string `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

// The parameters of `VirtualMachineGuestCustomizationManager.AbortCustomization_Task`.
type AbortCustomizationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The Virtual Machine managed object reference.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
}

func init() {
	t["AbortCustomizationRequestType"] = reflect.TypeOf((*AbortCustomizationRequestType)(nil)).Elem()
}

type AbortCustomization_Task AbortCustomizationRequestType

func init() {
	t["AbortCustomization_Task"] = reflect.TypeOf((*AbortCustomization_Task)(nil)).Elem()
}

type AbortCustomization_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// This data object type describes system information
// including the name, type, version, and build number.
type AboutInfo struct {
	DynamicData

	// Short form of the product name.
	Name string `xml:"name" json:"name"`
	// The complete product name, including the version information.
	FullName string `xml:"fullName" json:"fullName"`
	// Name of the vendor of this product.
	Vendor string `xml:"vendor" json:"vendor"`
	// Dot-separated version string.
	//
	// For example, "1.2".
	Version string `xml:"version" json:"version"`
	// Patch level for the server.
	PatchLevel string `xml:"patchLevel,omitempty" json:"patchLevel,omitempty" vim:"7.0.2.0"`
	// Build string for the server on which this call is made.
	//
	// For example, x.y.z-num.
	// This string does not apply to the API.
	Build string `xml:"build" json:"build"`
	// Version of the message catalog for the current session's locale.
	LocaleVersion string `xml:"localeVersion,omitempty" json:"localeVersion,omitempty"`
	// Build number for the current session's locale.
	//
	// Typically, this is a small number reflecting a
	// localization change from the normal product build.
	LocaleBuild string `xml:"localeBuild,omitempty" json:"localeBuild,omitempty"`
	// Operating system type and architecture.
	//
	// Examples of values are:
	//   - "win32-x86" - For x86-based Windows systems.
	//   - "linux-x86" - For x86-based Linux systems.
	//   - "vmnix-x86" - For the x86 ESX Server microkernel.
	//   - "vmnix-arm64" - For the arm64 ESX Server microkernel.
	OsType string `xml:"osType" json:"osType"`
	// The product ID is a unique identifier for a product line.
	//
	// Examples of values are:
	//   - "gsx" - For the VMware Server product.
	//   - "esx" - For the ESX product.
	//   - "embeddedEsx" - For the ESXi product.
	//   - "esxio" - For the ESXio product.
	//   - "vpx" - For the VirtualCenter product.
	ProductLineId string `xml:"productLineId" json:"productLineId"`
	// Indicates whether or not the service instance represents a
	// standalone host.
	//
	// If the service instance represents a standalone host, then the physical
	// inventory for that service instance is fixed to that single host.
	// VirtualCenter server provides additional features over single hosts.
	// For example, VirtualCenter offers multi-host management.
	//
	// Examples of values are:
	//   - "VirtualCenter" - For a VirtualCenter instance.
	//   - "HostAgent" - For host agent on an ESX Server or VMware Server host.
	ApiType string `xml:"apiType" json:"apiType"`
	// The version of the API as a dot-separated string.
	//
	// For example, "1.0.0".
	ApiVersion string `xml:"apiVersion" json:"apiVersion"`
	// A globally unique identifier associated with this service instance.
	InstanceUuid string `xml:"instanceUuid,omitempty" json:"instanceUuid,omitempty"`
	// The license product name
	LicenseProductName string `xml:"licenseProductName,omitempty" json:"licenseProductName,omitempty"`
	// The license product version
	LicenseProductVersion string `xml:"licenseProductVersion,omitempty" json:"licenseProductVersion,omitempty"`
}

func init() {
	t["AboutInfo"] = reflect.TypeOf((*AboutInfo)(nil)).Elem()
}

// This event records that an account was created on a host.
type AccountCreatedEvent struct {
	HostEvent

	Spec  BaseHostAccountSpec `xml:"spec,typeattr" json:"spec"`
	Group bool                `xml:"group" json:"group"`
}

func init() {
	t["AccountCreatedEvent"] = reflect.TypeOf((*AccountCreatedEvent)(nil)).Elem()
}

// This event records that an account was removed from a host.
type AccountRemovedEvent struct {
	HostEvent

	Account string `xml:"account" json:"account"`
	Group   bool   `xml:"group" json:"group"`
}

func init() {
	t["AccountRemovedEvent"] = reflect.TypeOf((*AccountRemovedEvent)(nil)).Elem()
}

// This event records that an account was updated on a host.
type AccountUpdatedEvent struct {
	HostEvent

	Spec  BaseHostAccountSpec `xml:"spec,typeattr" json:"spec"`
	Group bool                `xml:"group" json:"group"`
	// The previous account description
	PrevDescription string `xml:"prevDescription,omitempty" json:"prevDescription,omitempty"`
}

func init() {
	t["AccountUpdatedEvent"] = reflect.TypeOf((*AccountUpdatedEvent)(nil)).Elem()
}

type AcknowledgeAlarm AcknowledgeAlarmRequestType

func init() {
	t["AcknowledgeAlarm"] = reflect.TypeOf((*AcknowledgeAlarm)(nil)).Elem()
}

// The parameters of `AlarmManager.AcknowledgeAlarm`.
type AcknowledgeAlarmRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The Alarm to acknowledge.
	//
	// Required privileges: Alarm.Acknowledge
	//
	// Refers instance of `Alarm`.
	Alarm ManagedObjectReference `xml:"alarm" json:"alarm"`
	// The ManagedEntity for which to acknowledge the Alarm.
	//
	// Required privileges: System.Read
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["AcknowledgeAlarmRequestType"] = reflect.TypeOf((*AcknowledgeAlarmRequestType)(nil)).Elem()
}

type AcknowledgeAlarmResponse struct {
}

type AcquireCimServicesTicket AcquireCimServicesTicketRequestType

func init() {
	t["AcquireCimServicesTicket"] = reflect.TypeOf((*AcquireCimServicesTicket)(nil)).Elem()
}

type AcquireCimServicesTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AcquireCimServicesTicketRequestType"] = reflect.TypeOf((*AcquireCimServicesTicketRequestType)(nil)).Elem()
}

type AcquireCimServicesTicketResponse struct {
	Returnval HostServiceTicket `xml:"returnval" json:"returnval"`
}

type AcquireCloneTicket AcquireCloneTicketRequestType

func init() {
	t["AcquireCloneTicket"] = reflect.TypeOf((*AcquireCloneTicket)(nil)).Elem()
}

type AcquireCloneTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AcquireCloneTicketRequestType"] = reflect.TypeOf((*AcquireCloneTicketRequestType)(nil)).Elem()
}

type AcquireCloneTicketResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type AcquireCredentialsInGuest AcquireCredentialsInGuestRequestType

func init() {
	t["AcquireCredentialsInGuest"] = reflect.TypeOf((*AcquireCredentialsInGuest)(nil)).Elem()
}

// The parameters of `GuestAuthManager.AcquireCredentialsInGuest`.
type AcquireCredentialsInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// MoRef of the VM to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Query
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data used to acquire credentials.
	// See `GuestAuthentication`.
	RequestedAuth BaseGuestAuthentication `xml:"requestedAuth,typeattr" json:"requestedAuth"`
	// The sessionID number should be provided only when
	// responding to a server challenge. The sessionID number to be used with
	// the challenge is found in the
	// `GuestAuthenticationChallenge` object.
	SessionID int64 `xml:"sessionID,omitempty" json:"sessionID,omitempty"`
}

func init() {
	t["AcquireCredentialsInGuestRequestType"] = reflect.TypeOf((*AcquireCredentialsInGuestRequestType)(nil)).Elem()
}

type AcquireCredentialsInGuestResponse struct {
	Returnval BaseGuestAuthentication `xml:"returnval,typeattr" json:"returnval"`
}

type AcquireGenericServiceTicket AcquireGenericServiceTicketRequestType

func init() {
	t["AcquireGenericServiceTicket"] = reflect.TypeOf((*AcquireGenericServiceTicket)(nil)).Elem()
}

// The parameters of `SessionManager.AcquireGenericServiceTicket`.
type AcquireGenericServiceTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// specification for the service request which will be
	// invoked with the ticket.
	Spec BaseSessionManagerServiceRequestSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["AcquireGenericServiceTicketRequestType"] = reflect.TypeOf((*AcquireGenericServiceTicketRequestType)(nil)).Elem()
}

type AcquireGenericServiceTicketResponse struct {
	Returnval SessionManagerGenericServiceTicket `xml:"returnval" json:"returnval"`
}

type AcquireLocalTicket AcquireLocalTicketRequestType

func init() {
	t["AcquireLocalTicket"] = reflect.TypeOf((*AcquireLocalTicket)(nil)).Elem()
}

// The parameters of `SessionManager.AcquireLocalTicket`.
type AcquireLocalTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// User requesting one-time password.
	UserName string `xml:"userName" json:"userName"`
}

func init() {
	t["AcquireLocalTicketRequestType"] = reflect.TypeOf((*AcquireLocalTicketRequestType)(nil)).Elem()
}

type AcquireLocalTicketResponse struct {
	Returnval SessionManagerLocalTicket `xml:"returnval" json:"returnval"`
}

type AcquireMksTicket AcquireMksTicketRequestType

func init() {
	t["AcquireMksTicket"] = reflect.TypeOf((*AcquireMksTicket)(nil)).Elem()
}

type AcquireMksTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AcquireMksTicketRequestType"] = reflect.TypeOf((*AcquireMksTicketRequestType)(nil)).Elem()
}

type AcquireMksTicketResponse struct {
	Returnval VirtualMachineMksTicket `xml:"returnval" json:"returnval"`
}

type AcquireTicket AcquireTicketRequestType

func init() {
	t["AcquireTicket"] = reflect.TypeOf((*AcquireTicket)(nil)).Elem()
}

// The parameters of `VirtualMachine.AcquireTicket`.
type AcquireTicketRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The type of service to acquire, the set of possible
	// values is described in `VirtualMachineTicketType_enum`.
	TicketType string `xml:"ticketType" json:"ticketType"`
}

func init() {
	t["AcquireTicketRequestType"] = reflect.TypeOf((*AcquireTicketRequestType)(nil)).Elem()
}

type AcquireTicketResponse struct {
	Returnval VirtualMachineTicket `xml:"returnval" json:"returnval"`
}

// This data object type defines the action initiated by a scheduled task or alarm.
//
// This is an abstract type.
// A client creates a scheduled task or an alarm each of which triggers
// an action, defined by a subclass of this type.
type Action struct {
	DynamicData
}

func init() {
	t["Action"] = reflect.TypeOf((*Action)(nil)).Elem()
}

// Base fault for Active Directory related problems.
type ActiveDirectoryFault struct {
	VimFault

	// The error code reported by the Active Directory API.
	ErrorCode int32 `xml:"errorCode,omitempty" json:"errorCode,omitempty"`
}

func init() {
	t["ActiveDirectoryFault"] = reflect.TypeOf((*ActiveDirectoryFault)(nil)).Elem()
}

type ActiveDirectoryFaultFault BaseActiveDirectoryFault

func init() {
	t["ActiveDirectoryFaultFault"] = reflect.TypeOf((*ActiveDirectoryFaultFault)(nil)).Elem()
}

// The `ActiveDirectoryProfile` data object represents Active Directory
// configuration.
//
// Use the `ApplyProfile.policy` list for
// access to configuration data for the Active Directory profile. Use the
// `ApplyProfile.property` list for access to subprofiles, if any.
type ActiveDirectoryProfile struct {
	ApplyProfile
}

func init() {
	t["ActiveDirectoryProfile"] = reflect.TypeOf((*ActiveDirectoryProfile)(nil)).Elem()
}

// An attempt to enable Enhanced VMotion Compatibility on a cluster, or to
// select a less-featureful EVC mode for a cluster where EVC is already
// enabled, has failed for the following reason:
//   - The cluster contains hosts that expose additional compatibility-
//     relevant CPU features beyond those present in the baseline of the
//     requested EVC mode.
//   - Those hosts have powered-on or suspended virtual machines.
//
// Therefore the EVC configuration has been rejected since it may suppress
// CPU features that are currently in-use.
type ActiveVMsBlockingEVC struct {
	EVCConfigFault

	// The requested EVC mode.
	EvcMode string `xml:"evcMode,omitempty" json:"evcMode,omitempty"`
	// Hosts with active virtual machines that are blocking the operation,
	// because the hosts expose compatibility-relevant CPU features not present
	// in the baseline of the requested EVC mode.
	//
	// Note that in rare cases, a host may be on this list even if its
	// `maxEVCModeKey` corresponds to the
	// requested EVC mode. This means that even though that EVC mode is the
	// best match for the host's hardware, the host still has some features
	// beyond those present in the baseline for that EVC mode.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The names of the hosts in the host array.
	HostName []string `xml:"hostName,omitempty" json:"hostName,omitempty"`
}

func init() {
	t["ActiveVMsBlockingEVC"] = reflect.TypeOf((*ActiveVMsBlockingEVC)(nil)).Elem()
}

type ActiveVMsBlockingEVCFault ActiveVMsBlockingEVC

func init() {
	t["ActiveVMsBlockingEVCFault"] = reflect.TypeOf((*ActiveVMsBlockingEVCFault)(nil)).Elem()
}

type AddAuthorizationRole AddAuthorizationRoleRequestType

func init() {
	t["AddAuthorizationRole"] = reflect.TypeOf((*AddAuthorizationRole)(nil)).Elem()
}

// The parameters of `AuthorizationManager.AddAuthorizationRole`.
type AddAuthorizationRoleRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Name of the new role.
	Name string `xml:"name" json:"name"`
	// List of privileges to assign to the role.
	PrivIds []string `xml:"privIds,omitempty" json:"privIds,omitempty"`
}

func init() {
	t["AddAuthorizationRoleRequestType"] = reflect.TypeOf((*AddAuthorizationRoleRequestType)(nil)).Elem()
}

type AddAuthorizationRoleResponse struct {
	Returnval int32 `xml:"returnval" json:"returnval"`
}

type AddCustomFieldDef AddCustomFieldDefRequestType

func init() {
	t["AddCustomFieldDef"] = reflect.TypeOf((*AddCustomFieldDef)(nil)).Elem()
}

// The parameters of `CustomFieldsManager.AddCustomFieldDef`.
type AddCustomFieldDefRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the field.
	Name string `xml:"name" json:"name"`
	// The managed object type to which this field
	// will apply
	MoType string `xml:"moType,omitempty" json:"moType,omitempty"`
	// Privilege policy to apply to FieldDef being
	// created
	FieldDefPolicy *PrivilegePolicyDef `xml:"fieldDefPolicy,omitempty" json:"fieldDefPolicy,omitempty"`
	// Privilege policy to apply to instances of field
	FieldPolicy *PrivilegePolicyDef `xml:"fieldPolicy,omitempty" json:"fieldPolicy,omitempty"`
}

func init() {
	t["AddCustomFieldDefRequestType"] = reflect.TypeOf((*AddCustomFieldDefRequestType)(nil)).Elem()
}

type AddCustomFieldDefResponse struct {
	Returnval CustomFieldDef `xml:"returnval" json:"returnval"`
}

// The parameters of `DistributedVirtualSwitch.AddDVPortgroup_Task`.
type AddDVPortgroupRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for the portgroup.
	Spec []DVPortgroupConfigSpec `xml:"spec" json:"spec"`
}

func init() {
	t["AddDVPortgroupRequestType"] = reflect.TypeOf((*AddDVPortgroupRequestType)(nil)).Elem()
}

type AddDVPortgroup_Task AddDVPortgroupRequestType

func init() {
	t["AddDVPortgroup_Task"] = reflect.TypeOf((*AddDVPortgroup_Task)(nil)).Elem()
}

type AddDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostVsanSystem.AddDisks_Task`.
type AddDisksRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// list of disks to add for use by the VSAN service
	Disk []HostScsiDisk `xml:"disk" json:"disk"`
}

func init() {
	t["AddDisksRequestType"] = reflect.TypeOf((*AddDisksRequestType)(nil)).Elem()
}

type AddDisks_Task AddDisksRequestType

func init() {
	t["AddDisks_Task"] = reflect.TypeOf((*AddDisks_Task)(nil)).Elem()
}

type AddDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type AddFilter AddFilterRequestType

func init() {
	t["AddFilter"] = reflect.TypeOf((*AddFilter)(nil)).Elem()
}

type AddFilterEntities AddFilterEntitiesRequestType

func init() {
	t["AddFilterEntities"] = reflect.TypeOf((*AddFilterEntities)(nil)).Elem()
}

// The parameters of `HealthUpdateManager.AddFilterEntities`.
type AddFilterEntitiesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The filter id.
	FilterId string `xml:"filterId" json:"filterId"`
	// The list of additional managed entities. Only
	// entities of type HostSystem or
	// ClusterComputeResource are valid.
	//
	// Refers instances of `ManagedEntity`.
	Entities []ManagedObjectReference `xml:"entities,omitempty" json:"entities,omitempty"`
}

func init() {
	t["AddFilterEntitiesRequestType"] = reflect.TypeOf((*AddFilterEntitiesRequestType)(nil)).Elem()
}

type AddFilterEntitiesResponse struct {
}

// The parameters of `HealthUpdateManager.AddFilter`.
type AddFilterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The provider identifier.
	ProviderId string `xml:"providerId" json:"providerId"`
	// The filter name.
	FilterName string `xml:"filterName" json:"filterName"`
	// The list of HealthUpdateInfo IDs that should be
	// filtered.
	InfoIds []string `xml:"infoIds,omitempty" json:"infoIds,omitempty"`
}

func init() {
	t["AddFilterRequestType"] = reflect.TypeOf((*AddFilterRequestType)(nil)).Elem()
}

type AddFilterResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type AddGuestAlias AddGuestAliasRequestType

func init() {
	t["AddGuestAlias"] = reflect.TypeOf((*AddGuestAlias)(nil)).Elem()
}

// The parameters of `GuestAliasManager.AddGuestAlias`.
type AddGuestAliasRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.ModifyAliases
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data for this operation. See
	// `GuestAuthentication`. These credentials must satisfy
	// authentication requirements
	// for a guest account on the specified virtual machine.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// Username for the guest account on the virtual machine.
	Username string `xml:"username" json:"username"`
	// Indicates whether the certificate associated with the
	// alias should be mapped. If an alias certificate is mapped,
	// guest operation requests that use that alias do not have
	// to specify the guest account username in the
	// `SAMLTokenAuthentication` object. If mapCert is
	// false, the request must specify the username.
	MapCert bool `xml:"mapCert" json:"mapCert"`
	// X.509 certificate from the VMware SSO Server,
	// in base64 encoded DER format. The ESXi
	// Server uses this certificate to authenticate guest
	// operation requests.
	Base64Cert string `xml:"base64Cert" json:"base64Cert"`
	// Specifies the subject name for authentication.
	// The subject name (when present) corresponds to
	// the value of the Subject element
	// in SAML tokens. The ESXi Server uses the subject
	// name to authenticate guest operation requests.
	AliasInfo GuestAuthAliasInfo `xml:"aliasInfo" json:"aliasInfo"`
}

func init() {
	t["AddGuestAliasRequestType"] = reflect.TypeOf((*AddGuestAliasRequestType)(nil)).Elem()
}

type AddGuestAliasResponse struct {
}

// The parameters of `ClusterComputeResource.AddHost_Task`.
type AddHostRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specifies the parameters needed to add a single host.
	Spec HostConnectSpec `xml:"spec" json:"spec"`
	// Flag to specify whether or not the host should be connected
	// immediately after it is added. The host will not be added if
	// a connection attempt is made and fails.
	AsConnected bool `xml:"asConnected" json:"asConnected"`
	// the resource pool for the root resource pool from the host.
	//
	// Required privileges: Resource.AssignVMToPool
	//
	// Refers instance of `ResourcePool`.
	ResourcePool *ManagedObjectReference `xml:"resourcePool,omitempty" json:"resourcePool,omitempty"`
	// Provide a licenseKey or licenseKeyType. See `LicenseManager`
	License string `xml:"license,omitempty" json:"license,omitempty"`
}

func init() {
	t["AddHostRequestType"] = reflect.TypeOf((*AddHostRequestType)(nil)).Elem()
}

type AddHost_Task AddHostRequestType

func init() {
	t["AddHost_Task"] = reflect.TypeOf((*AddHost_Task)(nil)).Elem()
}

type AddHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type AddInternetScsiSendTargets AddInternetScsiSendTargetsRequestType

func init() {
	t["AddInternetScsiSendTargets"] = reflect.TypeOf((*AddInternetScsiSendTargets)(nil)).Elem()
}

// The parameters of `HostStorageSystem.AddInternetScsiSendTargets`.
type AddInternetScsiSendTargetsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The device of the Internet SCSI HBA adapter.
	IScsiHbaDevice string `xml:"iScsiHbaDevice" json:"iScsiHbaDevice"`
	// An array of iSCSI send targets.
	Targets []HostInternetScsiHbaSendTarget `xml:"targets" json:"targets"`
}

func init() {
	t["AddInternetScsiSendTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiSendTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiSendTargetsResponse struct {
}

type AddInternetScsiStaticTargets AddInternetScsiStaticTargetsRequestType

func init() {
	t["AddInternetScsiStaticTargets"] = reflect.TypeOf((*AddInternetScsiStaticTargets)(nil)).Elem()
}

// The parameters of `HostStorageSystem.AddInternetScsiStaticTargets`.
type AddInternetScsiStaticTargetsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The device of the Internet SCSI HBA adapter.
	IScsiHbaDevice string `xml:"iScsiHbaDevice" json:"iScsiHbaDevice"`
	// An array of iSCSI static targets to add.
	Targets []HostInternetScsiHbaStaticTarget `xml:"targets" json:"targets"`
}

func init() {
	t["AddInternetScsiStaticTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiStaticTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiStaticTargetsResponse struct {
}

type AddKey AddKeyRequestType

func init() {
	t["AddKey"] = reflect.TypeOf((*AddKey)(nil)).Elem()
}

// The parameters of `CryptoManager.AddKey`.
type AddKeyRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// \[in\] The cryptographic key to add.
	Key CryptoKeyPlain `xml:"key" json:"key"`
}

func init() {
	t["AddKeyRequestType"] = reflect.TypeOf((*AddKeyRequestType)(nil)).Elem()
}

type AddKeyResponse struct {
}

type AddKeys AddKeysRequestType

func init() {
	t["AddKeys"] = reflect.TypeOf((*AddKeys)(nil)).Elem()
}

// The parameters of `CryptoManager.AddKeys`.
type AddKeysRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// \[in\] List of cryptographic keys to add.
	Keys []CryptoKeyPlain `xml:"keys,omitempty" json:"keys,omitempty"`
}

func init() {
	t["AddKeysRequestType"] = reflect.TypeOf((*AddKeysRequestType)(nil)).Elem()
}

type AddKeysResponse struct {
	Returnval []CryptoKeyResult `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

type AddLicense AddLicenseRequestType

func init() {
	t["AddLicense"] = reflect.TypeOf((*AddLicense)(nil)).Elem()
}

// The parameters of `LicenseManager.AddLicense`.
type AddLicenseRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A license. E.g. a serial license.
	LicenseKey string `xml:"licenseKey" json:"licenseKey"`
	// array of key-value labels. Ignored by ESX Server.
	Labels []KeyValue `xml:"labels,omitempty" json:"labels,omitempty"`
}

func init() {
	t["AddLicenseRequestType"] = reflect.TypeOf((*AddLicenseRequestType)(nil)).Elem()
}

type AddLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval" json:"returnval"`
}

type AddMonitoredEntities AddMonitoredEntitiesRequestType

func init() {
	t["AddMonitoredEntities"] = reflect.TypeOf((*AddMonitoredEntities)(nil)).Elem()
}

// The parameters of `HealthUpdateManager.AddMonitoredEntities`.
type AddMonitoredEntitiesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The provider id.
	ProviderId string `xml:"providerId" json:"providerId"`
	// The entities that are newly monitored by this
	// provider.
	//
	// Refers instances of `ManagedEntity`.
	Entities []ManagedObjectReference `xml:"entities,omitempty" json:"entities,omitempty"`
}

func init() {
	t["AddMonitoredEntitiesRequestType"] = reflect.TypeOf((*AddMonitoredEntitiesRequestType)(nil)).Elem()
}

type AddMonitoredEntitiesResponse struct {
}

type AddNetworkResourcePool AddNetworkResourcePoolRequestType

func init() {
	t["AddNetworkResourcePool"] = reflect.TypeOf((*AddNetworkResourcePool)(nil)).Elem()
}

// The parameters of `DistributedVirtualSwitch.AddNetworkResourcePool`.
type AddNetworkResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the network resource pool configuration specification.
	ConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"configSpec" json:"configSpec"`
}

func init() {
	t["AddNetworkResourcePoolRequestType"] = reflect.TypeOf((*AddNetworkResourcePoolRequestType)(nil)).Elem()
}

type AddNetworkResourcePoolResponse struct {
}

type AddPortGroup AddPortGroupRequestType

func init() {
	t["AddPortGroup"] = reflect.TypeOf((*AddPortGroup)(nil)).Elem()
}

// The parameters of `HostNetworkSystem.AddPortGroup`.
type AddPortGroupRequestType struct {
	This    ManagedObjectReference `xml:"_this" json:"-"`
	Portgrp HostPortGroupSpec      `xml:"portgrp" json:"portgrp"`
}

func init() {
	t["AddPortGroupRequestType"] = reflect.TypeOf((*AddPortGroupRequestType)(nil)).Elem()
}

type AddPortGroupResponse struct {
}

type AddServiceConsoleVirtualNic AddServiceConsoleVirtualNicRequestType

func init() {
	t["AddServiceConsoleVirtualNic"] = reflect.TypeOf((*AddServiceConsoleVirtualNic)(nil)).Elem()
}

// The parameters of `HostNetworkSystem.AddServiceConsoleVirtualNic`.
type AddServiceConsoleVirtualNicRequestType struct {
	This      ManagedObjectReference `xml:"_this" json:"-"`
	Portgroup string                 `xml:"portgroup" json:"portgroup"`
	Nic       HostVirtualNicSpec     `xml:"nic" json:"nic"`
}

func init() {
	t["AddServiceConsoleVirtualNicRequestType"] = reflect.TypeOf((*AddServiceConsoleVirtualNicRequestType)(nil)).Elem()
}

type AddServiceConsoleVirtualNicResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// The parameters of `Folder.AddStandaloneHost_Task`.
type AddStandaloneHostRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specifies the parameters needed to add a single host.
	Spec HostConnectSpec `xml:"spec" json:"spec"`
	// Optionally specify the configuration for the compute
	// resource that will be created to contain the host.
	CompResSpec BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr" json:"compResSpec,omitempty"`
	// Flag to specify whether or not the host should be
	// connected as soon as it is added. The host will not
	// be added if a connection attempt is made and fails.
	AddConnected bool `xml:"addConnected" json:"addConnected"`
	// Provide a licenseKey or licenseKeyType. See `LicenseManager`
	License string `xml:"license,omitempty" json:"license,omitempty"`
}

func init() {
	t["AddStandaloneHostRequestType"] = reflect.TypeOf((*AddStandaloneHostRequestType)(nil)).Elem()
}

type AddStandaloneHost_Task AddStandaloneHostRequestType

func init() {
	t["AddStandaloneHost_Task"] = reflect.TypeOf((*AddStandaloneHost_Task)(nil)).Elem()
}

type AddStandaloneHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type AddVirtualNic AddVirtualNicRequestType

func init() {
	t["AddVirtualNic"] = reflect.TypeOf((*AddVirtualNic)(nil)).Elem()
}

// The parameters of `HostNetworkSystem.AddVirtualNic`.
type AddVirtualNicRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Note: Must be the empty string in case nic.distributedVirtualPort
	// is set.
	Portgroup string             `xml:"portgroup" json:"portgroup"`
	Nic       HostVirtualNicSpec `xml:"nic" json:"nic"`
}

func init() {
	t["AddVirtualNicRequestType"] = reflect.TypeOf((*AddVirtualNicRequestType)(nil)).Elem()
}

type AddVirtualNicResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type AddVirtualSwitch AddVirtualSwitchRequestType

func init() {
	t["AddVirtualSwitch"] = reflect.TypeOf((*AddVirtualSwitch)(nil)).Elem()
}

// The parameters of `HostNetworkSystem.AddVirtualSwitch`.
type AddVirtualSwitchRequestType struct {
	This        ManagedObjectReference `xml:"_this" json:"-"`
	VswitchName string                 `xml:"vswitchName" json:"vswitchName"`
	Spec        *HostVirtualSwitchSpec `xml:"spec,omitempty" json:"spec,omitempty"`
}

func init() {
	t["AddVirtualSwitchRequestType"] = reflect.TypeOf((*AddVirtualSwitchRequestType)(nil)).Elem()
}

type AddVirtualSwitchResponse struct {
}

// Fault thrown if an attempt to disable the Administrator permission
// on a host of which the Administator permission has already been disabled.
type AdminDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminDisabled"] = reflect.TypeOf((*AdminDisabled)(nil)).Elem()
}

type AdminDisabledFault AdminDisabled

func init() {
	t["AdminDisabledFault"] = reflect.TypeOf((*AdminDisabledFault)(nil)).Elem()
}

// Fault thrown if an attempt to enable the Administrator permission
// on a host of which the Administator permission is not disabled.
type AdminNotDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminNotDisabled"] = reflect.TypeOf((*AdminNotDisabled)(nil)).Elem()
}

type AdminNotDisabledFault AdminNotDisabled

func init() {
	t["AdminNotDisabledFault"] = reflect.TypeOf((*AdminNotDisabledFault)(nil)).Elem()
}

// Default password for the Admin user on the host has not been changed.
type AdminPasswordNotChangedEvent struct {
	HostEvent
}

func init() {
	t["AdminPasswordNotChangedEvent"] = reflect.TypeOf((*AdminPasswordNotChangedEvent)(nil)).Elem()
}

// Virtual machine has a configured memory and/or CPU affinity that will
// prevent VMotion.
//
// This is an error for powered-on virtual machines.
type AffinityConfigured struct {
	MigrationFault

	// Configured affinity types for the virtual machine.
	//
	// See `AffinityType_enum` for valid values.
	ConfiguredAffinity []string `xml:"configuredAffinity" json:"configuredAffinity"`
}

func init() {
	t["AffinityConfigured"] = reflect.TypeOf((*AffinityConfigured)(nil)).Elem()
}

type AffinityConfiguredFault AffinityConfigured

func init() {
	t["AffinityConfiguredFault"] = reflect.TypeOf((*AffinityConfiguredFault)(nil)).Elem()
}

// The `AfterStartupTaskScheduler` data object establishes the time
// that a scheduled task will run after the vCenter server restarts.
type AfterStartupTaskScheduler struct {
	TaskScheduler

	// The delay in minutes after vCenter server is restarted.
	//
	// The value must be greater than or equal to 0.
	Minute int32 `xml:"minute" json:"minute"`
}

func init() {
	t["AfterStartupTaskScheduler"] = reflect.TypeOf((*AfterStartupTaskScheduler)(nil)).Elem()
}

// An AgentInstallFailed fault is thrown when VirtualCenter
// fails to install the VirtualCenter agent on a host.
//
// For example, a fault is
// thrown if the agent software cannot be uploaded to the host or an error occurred
// during the agent installation.
type AgentInstallFailed struct {
	HostConnectFault

	// The reason why the agent install failed, if known.
	//
	// Values should come from `AgentInstallFailedReason_enum`.
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
	// The status code returned by the agent installer, if it was run.
	StatusCode int32 `xml:"statusCode,omitempty" json:"statusCode,omitempty"`
	// The output (stdout/stderr) from executing the agent installer.
	InstallerOutput string `xml:"installerOutput,omitempty" json:"installerOutput,omitempty"`
}

func init() {
	t["AgentInstallFailed"] = reflect.TypeOf((*AgentInstallFailed)(nil)).Elem()
}

type AgentInstallFailedFault AgentInstallFailed

func init() {
	t["AgentInstallFailedFault"] = reflect.TypeOf((*AgentInstallFailedFault)(nil)).Elem()
}

// This event records the acknowledgement of an Alarm
type AlarmAcknowledgedEvent struct {
	AlarmEvent

	// The entity that triggered the alarm.
	Source ManagedEntityEventArgument `xml:"source" json:"source"`
	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
}

func init() {
	t["AlarmAcknowledgedEvent"] = reflect.TypeOf((*AlarmAcknowledgedEvent)(nil)).Elem()
}

// Action invoked by triggered alarm.
//
// This is an abstract type.
type AlarmAction struct {
	DynamicData
}

func init() {
	t["AlarmAction"] = reflect.TypeOf((*AlarmAction)(nil)).Elem()
}

// This event records that an alarm was triggered.
type AlarmActionTriggeredEvent struct {
	AlarmEvent

	// The entity that triggered the alarm.
	Source ManagedEntityEventArgument `xml:"source" json:"source"`
	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
}

func init() {
	t["AlarmActionTriggeredEvent"] = reflect.TypeOf((*AlarmActionTriggeredEvent)(nil)).Elem()
}

// This event records the manual clearing of an Alarm
type AlarmClearedEvent struct {
	AlarmEvent

	// The entity that triggered the alarm.
	Source ManagedEntityEventArgument `xml:"source" json:"source"`
	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The original alarm status from which it was cleared
	From string `xml:"from" json:"from"`
}

func init() {
	t["AlarmClearedEvent"] = reflect.TypeOf((*AlarmClearedEvent)(nil)).Elem()
}

// This event records the creation of an alarm.
type AlarmCreatedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
}

func init() {
	t["AlarmCreatedEvent"] = reflect.TypeOf((*AlarmCreatedEvent)(nil)).Elem()
}

// Static strings for alarms.
type AlarmDescription struct {
	DynamicData

	// Descriptions of expression types for a trigger.
	Expr []BaseTypeDescription `xml:"expr,typeattr" json:"expr"`
	// *State Operator enum description*
	StateOperator []BaseElementDescription `xml:"stateOperator,typeattr" json:"stateOperator"`
	// *MetricAlarmExpression Metric Operator enum description*
	MetricOperator []BaseElementDescription `xml:"metricOperator,typeattr" json:"metricOperator"`
	// *Host System Connection State enum description*
	HostSystemConnectionState []BaseElementDescription `xml:"hostSystemConnectionState,typeattr" json:"hostSystemConnectionState"`
	// *Virtual Machine Power State enum description*
	VirtualMachinePowerState []BaseElementDescription `xml:"virtualMachinePowerState,typeattr" json:"virtualMachinePowerState"`
	// `DatastoreSummary.accessible` and
	// `description`
	DatastoreConnectionState []BaseElementDescription `xml:"datastoreConnectionState,omitempty,typeattr" json:"datastoreConnectionState,omitempty"`
	// *Host System Power State enum description*
	HostSystemPowerState []BaseElementDescription `xml:"hostSystemPowerState,omitempty,typeattr" json:"hostSystemPowerState,omitempty"`
	// *Guest Heartbeat Status enum description*
	VirtualMachineGuestHeartbeatStatus []BaseElementDescription `xml:"virtualMachineGuestHeartbeatStatus,omitempty,typeattr" json:"virtualMachineGuestHeartbeatStatus,omitempty"`
	// *ManagedEntity Status enum description*
	EntityStatus []BaseElementDescription `xml:"entityStatus,typeattr" json:"entityStatus"`
	// Action class descriptions for an alarm.
	Action []BaseTypeDescription `xml:"action,typeattr" json:"action"`
}

func init() {
	t["AlarmDescription"] = reflect.TypeOf((*AlarmDescription)(nil)).Elem()
}

// This event records the completion of an alarm email notification.
type AlarmEmailCompletedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The destination email address.
	To string `xml:"to" json:"to"`
}

func init() {
	t["AlarmEmailCompletedEvent"] = reflect.TypeOf((*AlarmEmailCompletedEvent)(nil)).Elem()
}

// This event records a failure to complete an alarm email notification.
type AlarmEmailFailedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The destination email address.
	To string `xml:"to" json:"to"`
	// The reason for the failure.
	Reason LocalizedMethodFault `xml:"reason" json:"reason"`
}

func init() {
	t["AlarmEmailFailedEvent"] = reflect.TypeOf((*AlarmEmailFailedEvent)(nil)).Elem()
}

// This event is an alarm events.
type AlarmEvent struct {
	Event

	// The associated alarm object.
	Alarm AlarmEventArgument `xml:"alarm" json:"alarm"`
}

func init() {
	t["AlarmEvent"] = reflect.TypeOf((*AlarmEvent)(nil)).Elem()
}

// The event argument is an Alarm object.
type AlarmEventArgument struct {
	EntityEventArgument

	// The Alarm object.
	//
	// Refers instance of `Alarm`.
	Alarm ManagedObjectReference `xml:"alarm" json:"alarm"`
}

func init() {
	t["AlarmEventArgument"] = reflect.TypeOf((*AlarmEventArgument)(nil)).Elem()
}

// Base type for the expressions specifying the conditions that define
// the status of an alarm.
type AlarmExpression struct {
	DynamicData
}

func init() {
	t["AlarmExpression"] = reflect.TypeOf((*AlarmExpression)(nil)).Elem()
}

// Alarm Filter used to filter/group alarms.
type AlarmFilterSpec struct {
	DynamicData

	// Status array which could be used to filter alarms according to their
	// triggered state.
	//
	// If all triggered alarms need to be matched an empty array or
	// ManagedEntity::red and ManagedEntity::yellow could be filled in the array.
	Status []ManagedEntityStatus `xml:"status,omitempty" json:"status,omitempty"`
	// Use values from `AlarmFilterSpecAlarmTypeByEntity_enum`
	TypeEntity string `xml:"typeEntity,omitempty" json:"typeEntity,omitempty"`
	// Use values from `AlarmFilterSpecAlarmTypeByTrigger_enum`
	TypeTrigger string `xml:"typeTrigger,omitempty" json:"typeTrigger,omitempty"`
}

func init() {
	t["AlarmFilterSpec"] = reflect.TypeOf((*AlarmFilterSpec)(nil)).Elem()
}

// Attributes of an alarm.
type AlarmInfo struct {
	AlarmSpec

	// The unique key.
	Key string `xml:"key" json:"key"`
	// The alarm object.
	//
	// Refers instance of `Alarm`.
	Alarm ManagedObjectReference `xml:"alarm" json:"alarm"`
	// The entity on which the alarm is registered.
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
	// The time the alarm was created or modified.
	LastModifiedTime time.Time `xml:"lastModifiedTime" json:"lastModifiedTime"`
	// User name that modified the alarm most recently.
	LastModifiedUser string `xml:"lastModifiedUser" json:"lastModifiedUser"`
	// The event ID that records the alarm creation.
	CreationEventId int32 `xml:"creationEventId" json:"creationEventId"`
}

func init() {
	t["AlarmInfo"] = reflect.TypeOf((*AlarmInfo)(nil)).Elem()
}

// This event records the reconfiguration of an alarm.
type AlarmReconfiguredEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The configuration values changed during the reconfiguration.
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty" json:"configChanges,omitempty"`
}

func init() {
	t["AlarmReconfiguredEvent"] = reflect.TypeOf((*AlarmReconfiguredEvent)(nil)).Elem()
}

// This event records the removal of an alarm.
type AlarmRemovedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
}

func init() {
	t["AlarmRemovedEvent"] = reflect.TypeOf((*AlarmRemovedEvent)(nil)).Elem()
}

// This event records the completion of an alarm-triggered script.
type AlarmScriptCompleteEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The script triggered by the alarm.
	Script string `xml:"script" json:"script"`
}

func init() {
	t["AlarmScriptCompleteEvent"] = reflect.TypeOf((*AlarmScriptCompleteEvent)(nil)).Elem()
}

// This event records a failure to complete an alarm-triggered script.
type AlarmScriptFailedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The script triggered by the alarm.
	Script string `xml:"script" json:"script"`
	// The reason for the failure.
	Reason LocalizedMethodFault `xml:"reason" json:"reason"`
}

func init() {
	t["AlarmScriptFailedEvent"] = reflect.TypeOf((*AlarmScriptFailedEvent)(nil)).Elem()
}

// Tolerance and frequency limits of an alarm.
type AlarmSetting struct {
	DynamicData

	// Tolerance range for the metric triggers, measured in one hundredth percentage.
	//
	// A zero value means that the alarm
	// triggers whenever the metric value is above
	// or below the specified value.
	// A nonzero value means that the alarm
	// triggers only after reaching a certain percentage
	// above or below the nominal trigger value.
	ToleranceRange int32 `xml:"toleranceRange" json:"toleranceRange"`
	// How often the alarm is triggered, measured in seconds.
	//
	// A zero value means that the alarm is allowed
	// to trigger as often as possible.
	// A nonzero value means that any subsequent triggers
	// are suppressed for a period of seconds following a
	// reported trigger.
	ReportingFrequency int32 `xml:"reportingFrequency" json:"reportingFrequency"`
}

func init() {
	t["AlarmSetting"] = reflect.TypeOf((*AlarmSetting)(nil)).Elem()
}

// This event records the completion of an alarm SNMP notification.
type AlarmSnmpCompletedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
}

func init() {
	t["AlarmSnmpCompletedEvent"] = reflect.TypeOf((*AlarmSnmpCompletedEvent)(nil)).Elem()
}

// This event records a failure to complete an alarm SNMP notification.
type AlarmSnmpFailedEvent struct {
	AlarmEvent

	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The reason for the failure.
	Reason LocalizedMethodFault `xml:"reason" json:"reason"`
}

func init() {
	t["AlarmSnmpFailedEvent"] = reflect.TypeOf((*AlarmSnmpFailedEvent)(nil)).Elem()
}

// Parameters for alarm creation.
type AlarmSpec struct {
	DynamicData

	// Name of the alarm.
	Name string `xml:"name" json:"name"`
	// System name of the alarm.
	//
	// This is set only for predefined Alarms - i.e. Alarms created by the
	// server or extensions automatically. After creation this value cannot be
	// modified. User-created Alarms do not have a systemName at all.
	//
	// The purpose of this field is to identify system-created Alarms
	// reliably, even if they are edited by users.
	//
	// When creating Alarms with systemName, the systemName and the name of the
	// alarm should be equal.
	//
	// When reconfiguring an Alarm with systemName, the same systemName should
	// be passed in the new AlarmSpec. Renaming Alarms with systemName is not
	// allowed, i.e. when reconfiguring, the name passed in the new AlarmSpec
	// should be equal to either the systemName or its localized version (the
	// current name in the Alarm's info).
	SystemName string `xml:"systemName,omitempty" json:"systemName,omitempty"`
	// Description of the alarm.
	Description string `xml:"description" json:"description"`
	// Flag to indicate whether or not the alarm is enabled or disabled.
	Enabled bool `xml:"enabled" json:"enabled"`
	// Top-level alarm expression that defines trigger conditions.
	Expression BaseAlarmExpression `xml:"expression,typeattr" json:"expression"`
	// Action to perform when the alarm is triggered.
	Action BaseAlarmAction `xml:"action,omitempty,typeattr" json:"action,omitempty"`
	// Frequency in seconds, which specifies how often appropriate actions
	// should repeat when an alarm does not change state.
	ActionFrequency int32 `xml:"actionFrequency,omitempty" json:"actionFrequency,omitempty"`
	// Tolerance and maximum frequency settings.
	Setting *AlarmSetting `xml:"setting,omitempty" json:"setting,omitempty"`
}

func init() {
	t["AlarmSpec"] = reflect.TypeOf((*AlarmSpec)(nil)).Elem()
}

// Information about the alarm's state.
type AlarmState struct {
	DynamicData

	// Unique key that identifies the alarm.
	Key string `xml:"key" json:"key"`
	// Entity on which the alarm is instantiated.
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
	// Alarm object from which the AlarmState object is instantiated.
	//
	// Refers instance of `Alarm`.
	Alarm ManagedObjectReference `xml:"alarm" json:"alarm"`
	// Overall status of the alarm object.
	//
	// This is the value of the alarm's top-level expression.
	// In releases after vSphere API 5.0, vSphere Servers might not
	// generate property collector update notifications for this property.
	// To obtain the latest value of the property, you can use
	// PropertyCollector methods RetrievePropertiesEx or WaitForUpdatesEx.
	// If you use the PropertyCollector.WaitForUpdatesEx method, specify
	// an empty string for the version parameter.
	// Since this property is on a DataObject, an update returned by WaitForUpdatesEx may
	// contain values for this property when some other property on the DataObject changes.
	// If this update is a result of a call to WaitForUpdatesEx with a non-empty
	// version parameter, the value for this property may not be current.
	OverallStatus ManagedEntityStatus `xml:"overallStatus" json:"overallStatus"`
	// Time the alarm triggered.
	Time time.Time `xml:"time" json:"time"`
	// Flag to indicate if the alarm's actions have been acknowledged for the
	// associated ManagedEntity.
	Acknowledged *bool `xml:"acknowledged" json:"acknowledged,omitempty"`
	// The user who acknowledged this triggering.
	//
	// If the triggering has not
	// been acknowledged, then the value is not valid.
	AcknowledgedByUser string `xml:"acknowledgedByUser,omitempty" json:"acknowledgedByUser,omitempty"`
	// The time this triggering was acknowledged.
	//
	// If the triggering has not
	// been acknowledged, then the value is not valid.
	AcknowledgedTime *time.Time `xml:"acknowledgedTime" json:"acknowledgedTime,omitempty"`
	// Contains the key of the event that has triggered the alarm.
	//
	// The value
	// is set only for event based alarms. The value is not set for gray or
	// manually reset alarms (via vim.AlarmManager.setAlarmStatus).
	EventKey int32 `xml:"eventKey,omitempty" json:"eventKey,omitempty"`
	// Flag to indicate if the alarm is disabled for the associated
	// ManagedEntity.
	Disabled *bool `xml:"disabled" json:"disabled,omitempty"`
}

func init() {
	t["AlarmState"] = reflect.TypeOf((*AlarmState)(nil)).Elem()
}

// This event records a status change for an alarm.
type AlarmStatusChangedEvent struct {
	AlarmEvent

	// The entity for which the alarm status has been changed.
	Source ManagedEntityEventArgument `xml:"source" json:"source"`
	// The entity with which the alarm is registered.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The original alarm status.
	From string `xml:"from" json:"from"`
	// The new alarm status.
	To string `xml:"to" json:"to"`
}

func init() {
	t["AlarmStatusChangedEvent"] = reflect.TypeOf((*AlarmStatusChangedEvent)(nil)).Elem()
}

// This data object type describes one or more
// triggering transitions and an action to be done
// when an alarm is triggered.
//
// There are four triggering transitions; at least one of them must
// be provided. A gray state is considered the same as a green state,
// for the purpose of detecting transitions.
type AlarmTriggeringAction struct {
	AlarmAction

	// The action to be done when the alarm is triggered.
	Action BaseAction `xml:"action,typeattr" json:"action"`
	// Indicates on which transitions this action executes and repeats.
	//
	// This is optional only for backwards compatibility.
	TransitionSpecs []AlarmTriggeringActionTransitionSpec `xml:"transitionSpecs,omitempty" json:"transitionSpecs,omitempty"`
	// Deprecated as of vSphere API 4.0, use
	// `AlarmTriggeringActionTransitionSpec` .
	//
	// Flag to specify that the alarm should trigger on a transition
	// from green to yellow.
	Green2yellow bool `xml:"green2yellow" json:"green2yellow"`
	// Deprecated as of vSphere API 4.0, use
	// `AlarmTriggeringActionTransitionSpec` .
	//
	// Flag to specify that the alarm should trigger on a transition
	// from yellow to red.
	Yellow2red bool `xml:"yellow2red" json:"yellow2red"`
	// Deprecated as of vSphere API 4.0, use
	// `AlarmTriggeringActionTransitionSpec` .
	//
	// Flag to specify that the alarm should trigger on a transition
	// from red to yellow.
	Red2yellow bool `xml:"red2yellow" json:"red2yellow"`
	// Deprecated as of vSphere API 4.0, use
	// `AlarmTriggeringActionTransitionSpec` .
	//
	// Flag to specify that the alarm should trigger on a transition
	// from yellow to green.
	Yellow2green bool `xml:"yellow2green" json:"yellow2green"`
}

func init() {
	t["AlarmTriggeringAction"] = reflect.TypeOf((*AlarmTriggeringAction)(nil)).Elem()
}

// Specification indicating which on transitions this action fires.
//
// The existence of a Spec indicates that this action fires on
// transitions from that Spec's startState to finalState.
//
// There are six acceptable {startState, finalState} pairs:
// {green, yellow}, {green, red}, {yellow, red}, {red, yellow},
// {red, green} and {yellow, green}.
// Direct transitions have precedence over indirect.
// At least one of these pairs must be specified.
// Any deviation from the above will render the enclosing AlarmSpec invalid.
type AlarmTriggeringActionTransitionSpec struct {
	DynamicData

	// The state from which the alarm must transition for the action to
	// fire.
	//
	// Valid choices are red, yellow and green.
	StartState ManagedEntityStatus `xml:"startState" json:"startState"`
	// The state to which the alarm must transition for the action to fire.
	//
	// Valid choices are red, yellow, and green.
	FinalState ManagedEntityStatus `xml:"finalState" json:"finalState"`
	// Whether or not the action repeats, as per the actionFrequency defined
	// in the enclosing Alarm.
	Repeats bool `xml:"repeats" json:"repeats"`
}

func init() {
	t["AlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*AlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

// This event records that the previously unlicensed virtual machines on
// the specified host are now licensed.
//
// After this event is entered into
// the event log, we expect to see that the (@link
// vim.event.Event.UnlicensedVirtualMachinesEvent
// UnlicensedVirtualMachinesEvent) (@link vim.ManagedEntity.configIssue
// configIssue) is removed from the host.
type AllVirtualMachinesLicensedEvent struct {
	LicenseEvent
}

func init() {
	t["AllVirtualMachinesLicensedEvent"] = reflect.TypeOf((*AllVirtualMachinesLicensedEvent)(nil)).Elem()
}

type AllocateIpv4Address AllocateIpv4AddressRequestType

func init() {
	t["AllocateIpv4Address"] = reflect.TypeOf((*AllocateIpv4Address)(nil)).Elem()
}

// The parameters of `IpPoolManager.AllocateIpv4Address`.
type AllocateIpv4AddressRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter on which to find the pool
	//
	// Refers instance of `Datacenter`.
	Dc ManagedObjectReference `xml:"dc" json:"dc"`
	// The unique ID of the pool
	PoolId int32 `xml:"poolId" json:"poolId"`
	// The unique ID for this allocation
	AllocationId string `xml:"allocationId" json:"allocationId"`
}

func init() {
	t["AllocateIpv4AddressRequestType"] = reflect.TypeOf((*AllocateIpv4AddressRequestType)(nil)).Elem()
}

type AllocateIpv4AddressResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type AllocateIpv6Address AllocateIpv6AddressRequestType

func init() {
	t["AllocateIpv6Address"] = reflect.TypeOf((*AllocateIpv6Address)(nil)).Elem()
}

// The parameters of `IpPoolManager.AllocateIpv6Address`.
type AllocateIpv6AddressRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter on which to find the pool
	//
	// Refers instance of `Datacenter`.
	Dc ManagedObjectReference `xml:"dc" json:"dc"`
	// The unique ID of the pool
	PoolId int32 `xml:"poolId" json:"poolId"`
	// The unique ID for this allocation
	AllocationId string `xml:"allocationId" json:"allocationId"`
}

func init() {
	t["AllocateIpv6AddressRequestType"] = reflect.TypeOf((*AllocateIpv6AddressRequestType)(nil)).Elem()
}

type AllocateIpv6AddressResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// This event records a failed user logon due to the user already being logged on.
type AlreadyAuthenticatedSessionEvent struct {
	SessionEvent
}

func init() {
	t["AlreadyAuthenticatedSessionEvent"] = reflect.TypeOf((*AlreadyAuthenticatedSessionEvent)(nil)).Elem()
}

// AlreadyBeingManaged fault is thrown by the host
// connect method if the host is already being managed
// by a VirtualCenter server.
type AlreadyBeingManaged struct {
	HostConnectFault

	// IP address of server that is currently managing the host.
	IpAddress string `xml:"ipAddress" json:"ipAddress"`
}

func init() {
	t["AlreadyBeingManaged"] = reflect.TypeOf((*AlreadyBeingManaged)(nil)).Elem()
}

type AlreadyBeingManagedFault AlreadyBeingManaged

func init() {
	t["AlreadyBeingManagedFault"] = reflect.TypeOf((*AlreadyBeingManagedFault)(nil)).Elem()
}

// AlreadyConnect fault is thrown by the host connect method
// if the host is already connected to a VirtualCenter server.
//
// This might occur if the host has been added more than once
// in the same VirtualCenter in different folders or compute
// resources.
type AlreadyConnected struct {
	HostConnectFault

	// Name of the host
	Name string `xml:"name" json:"name"`
}

func init() {
	t["AlreadyConnected"] = reflect.TypeOf((*AlreadyConnected)(nil)).Elem()
}

type AlreadyConnectedFault AlreadyConnected

func init() {
	t["AlreadyConnectedFault"] = reflect.TypeOf((*AlreadyConnectedFault)(nil)).Elem()
}

// An AlreadyExists fault is thrown when an attempt is made to add an element
// to a collection, if the element's key, name, or identifier already exists in that
// collection.
type AlreadyExists struct {
	VimFault

	Name string `xml:"name,omitempty" json:"name,omitempty"`
}

func init() {
	t["AlreadyExists"] = reflect.TypeOf((*AlreadyExists)(nil)).Elem()
}

type AlreadyExistsFault AlreadyExists

func init() {
	t["AlreadyExistsFault"] = reflect.TypeOf((*AlreadyExistsFault)(nil)).Elem()
}

// An AlreadyUpgraded fault is thrown when an attempt is made to upgrade the
// virtual hardware of a Virtual machine whose virtual hardware is already
// up-to-date.
type AlreadyUpgraded struct {
	VimFault
}

func init() {
	t["AlreadyUpgraded"] = reflect.TypeOf((*AlreadyUpgraded)(nil)).Elem()
}

type AlreadyUpgradedFault AlreadyUpgraded

func init() {
	t["AlreadyUpgradedFault"] = reflect.TypeOf((*AlreadyUpgradedFault)(nil)).Elem()
}

// A data object type that links multiple alarm expressions with AND operators.
type AndAlarmExpression struct {
	AlarmExpression

	// List of alarm expressions that define the overall status of the alarm.
	//   - The state of the alarm expression is gray if all subexpressions are gray.
	//     Otherwise, gray subexpressions are ignored.
	//   - The state is red if all subexpressions are red.
	//   - Otherwise, the state is yellow if all subexpressions are red or yellow.
	//   - Otherwise, the state of the alarm expression is green.
	Expression []BaseAlarmExpression `xml:"expression,typeattr" json:"expression"`
}

func init() {
	t["AndAlarmExpression"] = reflect.TypeOf((*AndAlarmExpression)(nil)).Elem()
}

// The `AnswerFile` data object contains host-specific information that a host
// will use in combination with a `HostProfile` for configuration.
//
// Answer files are stored on the vCenter Server, along with host profiles.
// An answer file is always associated with a particular host.
//
// To supply host-specific data:
//   - Specify deferred parameters when you call the
//     `HostProfile*.*HostProfile.ExecuteHostProfile`
//     method. The host profile engine will verify the set of parameters for the
//     additional configuration data.
//   - Use the complete required input list
//     (`ProfileExecuteResult*.*ProfileExecuteResult.requireInput`\[\])
//     as user input for the
//     `HostProfileManager*.*HostProfileManager.ApplyHostConfig_Task`
//     method. When you apply the profile, the vCenter Server saves the additional configuration
//     data in the `AnswerFile.userInput` list.
//   - Use the `HostProfileManager*.*HostProfileManager.UpdateAnswerFile_Task` method. This method will update an existing answer file or create a new one.
type AnswerFile struct {
	DynamicData

	// List containing host-specific configuration data.
	UserInput []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty" json:"userInput,omitempty"`
	// Time at which the answer file was created.
	CreatedTime time.Time `xml:"createdTime" json:"createdTime"`
	// Time at which the answer file was last modified.
	ModifiedTime time.Time `xml:"modifiedTime" json:"modifiedTime"`
}

func init() {
	t["AnswerFile"] = reflect.TypeOf((*AnswerFile)(nil)).Elem()
}

// Base class for host-specific answer file options.
type AnswerFileCreateSpec struct {
	DynamicData

	// If "false", then the answer file will be saved without being validated.
	//
	// The default if not specified is "true".
	// This option should be used with caution, since the resulting answer
	// file will not be checked for errors.
	Validating *bool `xml:"validating" json:"validating,omitempty"`
}

func init() {
	t["AnswerFileCreateSpec"] = reflect.TypeOf((*AnswerFileCreateSpec)(nil)).Elem()
}

// The `AnswerFileOptionsCreateSpec`
// data object contains host-specific user input for an answer file.
type AnswerFileOptionsCreateSpec struct {
	AnswerFileCreateSpec

	// List of parameters that contain host-specific data.
	UserInput []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty" json:"userInput,omitempty"`
}

func init() {
	t["AnswerFileOptionsCreateSpec"] = reflect.TypeOf((*AnswerFileOptionsCreateSpec)(nil)).Elem()
}

// The `AnswerFileSerializedCreateSpec` data object
// contains a serialized string representation of host-specific data for an answer file.
type AnswerFileSerializedCreateSpec struct {
	AnswerFileCreateSpec

	// Host-specific user input.
	AnswerFileConfigString string `xml:"answerFileConfigString" json:"answerFileConfigString"`
}

func init() {
	t["AnswerFileSerializedCreateSpec"] = reflect.TypeOf((*AnswerFileSerializedCreateSpec)(nil)).Elem()
}

// The `AnswerFileStatusError` data object describes an answer file
// error and identifies the profile or policy option with which the error
// is associated.
type AnswerFileStatusError struct {
	DynamicData

	// Path to a profile or a policy option for host-specific data.
	UserInputPath ProfilePropertyPath `xml:"userInputPath" json:"userInputPath"`
	// Message describing the error.
	ErrMsg LocalizableMessage `xml:"errMsg" json:"errMsg"`
}

func init() {
	t["AnswerFileStatusError"] = reflect.TypeOf((*AnswerFileStatusError)(nil)).Elem()
}

// The `AnswerFileStatusResult` data object shows the validity of the
// answer file associated with a host.
type AnswerFileStatusResult struct {
	DynamicData

	// Time that the answer file status was determined.
	CheckedTime time.Time `xml:"checkedTime" json:"checkedTime"`
	// Host associated with the answer file.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Status of the answer file.
	//
	// See `HostProfileManagerAnswerFileStatus_enum` for valid values.
	Status string `xml:"status" json:"status"`
	// If <code>status</code> is <code>invalid</code>, this property contains a list
	// of status error objects.
	Error []AnswerFileStatusError `xml:"error,omitempty" json:"error,omitempty"`
}

func init() {
	t["AnswerFileStatusResult"] = reflect.TypeOf((*AnswerFileStatusResult)(nil)).Elem()
}

// Could not update the answer file as it has invalid inputs.
type AnswerFileUpdateFailed struct {
	VimFault

	// Failures encountered during answer file update
	Failure []AnswerFileUpdateFailure `xml:"failure" json:"failure"`
}

func init() {
	t["AnswerFileUpdateFailed"] = reflect.TypeOf((*AnswerFileUpdateFailed)(nil)).Elem()
}

type AnswerFileUpdateFailedFault AnswerFileUpdateFailed

func init() {
	t["AnswerFileUpdateFailedFault"] = reflect.TypeOf((*AnswerFileUpdateFailedFault)(nil)).Elem()
}

// DataObject which represents the errors that occurred when an
// answer file update was performed.
type AnswerFileUpdateFailure struct {
	DynamicData

	// The user input that has the error
	UserInputPath ProfilePropertyPath `xml:"userInputPath" json:"userInputPath"`
	// Message which explains the error
	ErrMsg LocalizableMessage `xml:"errMsg" json:"errMsg"`
}

func init() {
	t["AnswerFileUpdateFailure"] = reflect.TypeOf((*AnswerFileUpdateFailure)(nil)).Elem()
}

type AnswerVM AnswerVMRequestType

func init() {
	t["AnswerVM"] = reflect.TypeOf((*AnswerVM)(nil)).Elem()
}

// The parameters of `VirtualMachine.AnswerVM`.
type AnswerVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The value from QuestionInfo.id that identifies the question
	// to answer.
	QuestionId string `xml:"questionId" json:"questionId"`
	// The contents of the QuestionInfo.choice.value array element
	// that identifies the desired answer.
	AnswerChoice string `xml:"answerChoice" json:"answerChoice"`
}

func init() {
	t["AnswerVMRequestType"] = reflect.TypeOf((*AnswerVMRequestType)(nil)).Elem()
}

type AnswerVMResponse struct {
}

// This fault is thrown when creating a quiesced snapshot failed
// because the (user-supplied) custom pre-freeze script in the
// virtual machine exited with a non-zero return code.
//
// This indicates that the script failed to perform its quiescing
// task, which causes us to fail the quiesced snapshot operation.
type ApplicationQuiesceFault struct {
	SnapshotFault
}

func init() {
	t["ApplicationQuiesceFault"] = reflect.TypeOf((*ApplicationQuiesceFault)(nil)).Elem()
}

type ApplicationQuiesceFaultFault ApplicationQuiesceFault

func init() {
	t["ApplicationQuiesceFaultFault"] = reflect.TypeOf((*ApplicationQuiesceFaultFault)(nil)).Elem()
}

// The parameters of `HostProfileManager.ApplyEntitiesConfig_Task`.
type ApplyEntitiesConfigRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// An array of
	// `ApplyHostProfileConfigurationSpec`
	// objects. Each applyConfigSpecs object contains the data objects
	// required to remediate a host. The API caller should expand
	// a cluster to all its hosts for the purpose of providing the
	// required data object for configuration apply of each host.
	ApplyConfigSpecs []ApplyHostProfileConfigurationSpec `xml:"applyConfigSpecs,omitempty" json:"applyConfigSpecs,omitempty"`
}

func init() {
	t["ApplyEntitiesConfigRequestType"] = reflect.TypeOf((*ApplyEntitiesConfigRequestType)(nil)).Elem()
}

type ApplyEntitiesConfig_Task ApplyEntitiesConfigRequestType

func init() {
	t["ApplyEntitiesConfig_Task"] = reflect.TypeOf((*ApplyEntitiesConfig_Task)(nil)).Elem()
}

type ApplyEntitiesConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.ApplyEvcModeVM_Task`.
type ApplyEvcModeVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The feature masks to apply to the virtual machine.
	// An empty set of masks will clear EVC settings.
	Mask []HostFeatureMask `xml:"mask,omitempty" json:"mask,omitempty"`
	// Defaults to true if not set. A true value implies
	// that any unspecified feature will not be exposed to the guest.
	// A false value will expose any unspecified feature to the guest
	// with the value of the host.
	CompleteMasks *bool `xml:"completeMasks" json:"completeMasks,omitempty"`
}

func init() {
	t["ApplyEvcModeVMRequestType"] = reflect.TypeOf((*ApplyEvcModeVMRequestType)(nil)).Elem()
}

type ApplyEvcModeVM_Task ApplyEvcModeVMRequestType

func init() {
	t["ApplyEvcModeVM_Task"] = reflect.TypeOf((*ApplyEvcModeVM_Task)(nil)).Elem()
}

type ApplyEvcModeVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostProfileManager.ApplyHostConfig_Task`.
type ApplyHostConfigRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Host to be updated. User must have sufficient credentials and privileges
	// to satisfy the contents of the <code>configSpec</code>.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Set of configuration changes to be applied to the host.
	// The changes are returned by the
	// `HostProfile*.*HostProfile.ExecuteHostProfile`
	// method in the
	// `ProfileExecuteResult*.*ProfileExecuteResult.configSpec`
	// property.
	ConfigSpec HostConfigSpec `xml:"configSpec" json:"configSpec"`
	// Additional host-specific data to be applied to the host.
	// This data is the complete list of deferred parameters verified by the
	// `HostProfile*.*HostProfile.ExecuteHostProfile`
	// method, contained in the `ProfileExecuteResult` object
	// returned by the method.
	UserInput []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty" json:"userInput,omitempty"`
}

func init() {
	t["ApplyHostConfigRequestType"] = reflect.TypeOf((*ApplyHostConfigRequestType)(nil)).Elem()
}

type ApplyHostConfig_Task ApplyHostConfigRequestType

func init() {
	t["ApplyHostConfig_Task"] = reflect.TypeOf((*ApplyHostConfig_Task)(nil)).Elem()
}

type ApplyHostConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The `ApplyHostProfileConfigurationResult` data object contains the remediation
// results for a host: the time that the remediation happens, the status,
// the errors, and optinal compliance result after reboot.
type ApplyHostProfileConfigurationResult struct {
	DynamicData

	// Time that the host config apply starts.
	StartTime time.Time `xml:"startTime" json:"startTime"`
	// Time that the host config apply completes.
	CompleteTime time.Time `xml:"completeTime" json:"completeTime"`
	// Host to be remediated.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Status of the remediation.
	//
	// See
	// `ApplyHostProfileConfigurationResultStatus_enum`
	// for valid values.
	Status string `xml:"status" json:"status"`
	// If <code>status</code> is <code>fail</code>, this property contains
	// a list of status error message objects.
	Errors []LocalizedMethodFault `xml:"errors,omitempty" json:"errors,omitempty"`
}

func init() {
	t["ApplyHostProfileConfigurationResult"] = reflect.TypeOf((*ApplyHostProfileConfigurationResult)(nil)).Elem()
}

// The data object that contains the objects needed to remediate a host
// in host profile batch apply.
type ApplyHostProfileConfigurationSpec struct {
	ProfileExecuteResult

	// The host to be remediated.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// The task requirements from the results of
	// `HostProfileManager.GenerateConfigTaskList` method
	TaskListRequirement []string `xml:"taskListRequirement,omitempty" json:"taskListRequirement,omitempty"`
	// Description of tasks that will be performed on the host
	// to carry out HostProfile application.
	TaskDescription []LocalizableMessage `xml:"taskDescription,omitempty" json:"taskDescription,omitempty"`
	// For a stateless host, there are two approaches to apply a host
	// profile:
	// (1) Reboot the host and apply the host profile at boot time.
	//
	// (2) Apply the host profile directly from VC. We call this as
	// regular apply.
	// The variable rebootStateless allows users to choose the first
	// approach from the two approaches above:
	// apply host profile by rebooting this host.
	RebootStateless *bool `xml:"rebootStateless" json:"rebootStateless,omitempty"`
	// For regular apply, when some of the tasks requires reboot,
	// that this variable is<code>true</code> indicates that the
	// reboot automatically happens in the batch profile apply
	// than that the user will manually reboot the system later.
	//
	// For stateless host, this variable takes effect only when
	// the variable <code>rebootStateless</code> above is
	// <code>false</code>.
	RebootHost *bool `xml:"rebootHost" json:"rebootHost,omitempty"`
	// This contains the error details.
	FaultData *LocalizedMethodFault `xml:"faultData,omitempty" json:"faultData,omitempty"`
}

func init() {
	t["ApplyHostProfileConfigurationSpec"] = reflect.TypeOf((*ApplyHostProfileConfigurationSpec)(nil)).Elem()
}

// The `ApplyProfile` data object is the base class for all data objects
// that define profile configuration data.
//
// <code>ApplyProfile</code> defines ESX configuration data storage and it
// supports recursive profile definition for the profile plug-in architecture.
type ApplyProfile struct {
	DynamicData

	// Indicates whether the profile is enabled.
	Enabled bool `xml:"enabled" json:"enabled"`
	// The list of policies comprising the profile.
	//
	// A `ProfilePolicy`
	// stores one or more configuration data values in a `PolicyOption`.
	// The policy option is one of the configuration options from the
	// `ProfilePolicyMetadata*.*ProfilePolicyMetadata.possibleOption`
	// list.
	Policy []ProfilePolicy `xml:"policy,omitempty" json:"policy,omitempty"`
	// Identifies the profile type.
	ProfileTypeName string `xml:"profileTypeName,omitempty" json:"profileTypeName,omitempty"`
	// Profile engine version.
	ProfileVersion string `xml:"profileVersion,omitempty" json:"profileVersion,omitempty"`
	// List of subprofiles for this profile.
	//
	// This list can change depending on which profile plug-ins are available in the system.
	// Subprofiles can be nested to arbitrary depths to represent host capabilities.
	Property []ProfileApplyProfileProperty `xml:"property,omitempty" json:"property,omitempty"`
	// Indicates whether this profile is marked as "favorite".
	Favorite *bool `xml:"favorite" json:"favorite,omitempty"`
	// Indicates whether this profile is marked as to-be-merged.
	ToBeMerged *bool `xml:"toBeMerged" json:"toBeMerged,omitempty"`
	// Indicates whether the selected array elements, with the current
	// as one of them, replace the profile array in the target host
	// profile.
	ToReplaceWith *bool `xml:"toReplaceWith" json:"toReplaceWith,omitempty"`
	// Indicates whether this profile is marked as to-be-deleted.
	ToBeDeleted *bool `xml:"toBeDeleted" json:"toBeDeleted,omitempty"`
	// Indicates that the member variable <code>enabled</code> of this profile
	// will be copied from source profile to target profiles at host profile
	// composition.
	CopyEnableStatus *bool `xml:"copyEnableStatus" json:"copyEnableStatus,omitempty"`
	// Indicates whether this profile will be displayed or not.
	Hidden *bool `xml:"hidden" json:"hidden,omitempty"`
}

func init() {
	t["ApplyProfile"] = reflect.TypeOf((*ApplyProfile)(nil)).Elem()
}

type ApplyRecommendation ApplyRecommendationRequestType

func init() {
	t["ApplyRecommendation"] = reflect.TypeOf((*ApplyRecommendation)(nil)).Elem()
}

// The parameters of `ClusterComputeResource.ApplyRecommendation`.
type ApplyRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key field of the DrsRecommendation or Recommendation.
	Key string `xml:"key" json:"key"`
}

func init() {
	t["ApplyRecommendationRequestType"] = reflect.TypeOf((*ApplyRecommendationRequestType)(nil)).Elem()
}

type ApplyRecommendationResponse struct {
}

// The parameters of `StorageResourceManager.ApplyStorageDrsRecommendation_Task`.
type ApplyStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key fields of the Recommendations that are applied.
	Key []string `xml:"key" json:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationRequestType)(nil)).Elem()
}

// The parameters of `StorageResourceManager.ApplyStorageDrsRecommendationToPod_Task`.
type ApplyStorageDrsRecommendationToPodRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The storage pod.
	//
	// Refers instance of `StoragePod`.
	Pod ManagedObjectReference `xml:"pod" json:"pod"`
	// The key field of the Recommendation.
	Key string `xml:"key" json:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationToPodRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPodRequestType)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_Task ApplyStorageDrsRecommendationToPodRequestType

func init() {
	t["ApplyStorageDrsRecommendationToPod_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPod_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ApplyStorageDrsRecommendation_Task ApplyStorageDrsRecommendationRequestType

func init() {
	t["ApplyStorageDrsRecommendation_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendation_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendation_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Both `StorageResourceManager.RecommendDatastores` and
// `Datastore.DatastoreEnterMaintenanceMode` methods may invoke Storage DRS
// for recommendations on placing or evacuating virtual disks.
//
// All initial placement recommendations, and some enterMaintenanceMode
// recommendations need to be approved by the user. Recommendations that
// are approved will be applied using the
// `StorageResourceManager.ApplyStorageDrsRecommendation_Task`
// method.
// This class encapsulates the result of applying a subset of the
// recommendations.
type ApplyStorageRecommendationResult struct {
	DynamicData

	// The result applying the recommendation, if it was successful.
	//
	// This is the equivalent of the `TaskInfo.result` key for the
	// task launched when the recommendation was applied.
	//
	// Refers instance of `VirtualMachine`.
	Vm *ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
}

func init() {
	t["ApplyStorageRecommendationResult"] = reflect.TypeOf((*ApplyStorageRecommendationResult)(nil)).Elem()
}

type AreAlarmActionsEnabled AreAlarmActionsEnabledRequestType

func init() {
	t["AreAlarmActionsEnabled"] = reflect.TypeOf((*AreAlarmActionsEnabled)(nil)).Elem()
}

// The parameters of `AlarmManager.AreAlarmActionsEnabled`.
type AreAlarmActionsEnabledRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The managed entity to look up.
	//
	// Required privileges: System.Read
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["AreAlarmActionsEnabledRequestType"] = reflect.TypeOf((*AreAlarmActionsEnabledRequestType)(nil)).Elem()
}

type AreAlarmActionsEnabledResponse struct {
	Returnval bool `xml:"returnval" json:"returnval"`
}

// A boxed array of `AlarmAction`. To be used in `Any` placeholders.
type ArrayOfAlarmAction struct {
	AlarmAction []BaseAlarmAction `xml:"AlarmAction,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfAlarmAction"] = reflect.TypeOf((*ArrayOfAlarmAction)(nil)).Elem()
}

// A boxed array of `AlarmExpression`. To be used in `Any` placeholders.
type ArrayOfAlarmExpression struct {
	AlarmExpression []BaseAlarmExpression `xml:"AlarmExpression,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfAlarmExpression"] = reflect.TypeOf((*ArrayOfAlarmExpression)(nil)).Elem()
}

// A boxed array of `AlarmState`. To be used in `Any` placeholders.
type ArrayOfAlarmState struct {
	AlarmState []AlarmState `xml:"AlarmState,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAlarmState"] = reflect.TypeOf((*ArrayOfAlarmState)(nil)).Elem()
}

// A boxed array of `AlarmTriggeringActionTransitionSpec`. To be used in `Any` placeholders.
type ArrayOfAlarmTriggeringActionTransitionSpec struct {
	AlarmTriggeringActionTransitionSpec []AlarmTriggeringActionTransitionSpec `xml:"AlarmTriggeringActionTransitionSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*ArrayOfAlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

// A boxed array of `AnswerFileStatusError`. To be used in `Any` placeholders.
type ArrayOfAnswerFileStatusError struct {
	AnswerFileStatusError []AnswerFileStatusError `xml:"AnswerFileStatusError,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAnswerFileStatusError"] = reflect.TypeOf((*ArrayOfAnswerFileStatusError)(nil)).Elem()
}

// A boxed array of `AnswerFileStatusResult`. To be used in `Any` placeholders.
type ArrayOfAnswerFileStatusResult struct {
	AnswerFileStatusResult []AnswerFileStatusResult `xml:"AnswerFileStatusResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAnswerFileStatusResult"] = reflect.TypeOf((*ArrayOfAnswerFileStatusResult)(nil)).Elem()
}

// A boxed array of `AnswerFileUpdateFailure`. To be used in `Any` placeholders.
type ArrayOfAnswerFileUpdateFailure struct {
	AnswerFileUpdateFailure []AnswerFileUpdateFailure `xml:"AnswerFileUpdateFailure,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAnswerFileUpdateFailure"] = reflect.TypeOf((*ArrayOfAnswerFileUpdateFailure)(nil)).Elem()
}

// A boxed array of `Any`. To be used in `Any` placeholders.
type ArrayOfAnyType struct {
	AnyType []AnyType `xml:"anyType,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfAnyType"] = reflect.TypeOf((*ArrayOfAnyType)(nil)).Elem()
}

type ArrayOfAnyURI struct {
	AnyURI []string `xml:"anyURI,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAnyURI"] = reflect.TypeOf((*ArrayOfAnyURI)(nil)).Elem()
}

// A boxed array of `ApplyHostProfileConfigurationResult`. To be used in `Any` placeholders.
type ArrayOfApplyHostProfileConfigurationResult struct {
	ApplyHostProfileConfigurationResult []ApplyHostProfileConfigurationResult `xml:"ApplyHostProfileConfigurationResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfApplyHostProfileConfigurationResult"] = reflect.TypeOf((*ArrayOfApplyHostProfileConfigurationResult)(nil)).Elem()
}

// A boxed array of `ApplyHostProfileConfigurationSpec`. To be used in `Any` placeholders.
type ArrayOfApplyHostProfileConfigurationSpec struct {
	ApplyHostProfileConfigurationSpec []ApplyHostProfileConfigurationSpec `xml:"ApplyHostProfileConfigurationSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfApplyHostProfileConfigurationSpec"] = reflect.TypeOf((*ArrayOfApplyHostProfileConfigurationSpec)(nil)).Elem()
}

// A boxed array of `ApplyProfile`. To be used in `Any` placeholders.
type ArrayOfApplyProfile struct {
	ApplyProfile []BaseApplyProfile `xml:"ApplyProfile,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfApplyProfile"] = reflect.TypeOf((*ArrayOfApplyProfile)(nil)).Elem()
}

// A boxed array of `AuthorizationPrivilege`. To be used in `Any` placeholders.
type ArrayOfAuthorizationPrivilege struct {
	AuthorizationPrivilege []AuthorizationPrivilege `xml:"AuthorizationPrivilege,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAuthorizationPrivilege"] = reflect.TypeOf((*ArrayOfAuthorizationPrivilege)(nil)).Elem()
}

// A boxed array of `AuthorizationRole`. To be used in `Any` placeholders.
type ArrayOfAuthorizationRole struct {
	AuthorizationRole []AuthorizationRole `xml:"AuthorizationRole,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAuthorizationRole"] = reflect.TypeOf((*ArrayOfAuthorizationRole)(nil)).Elem()
}

// A boxed array of `AutoStartPowerInfo`. To be used in `Any` placeholders.
type ArrayOfAutoStartPowerInfo struct {
	AutoStartPowerInfo []AutoStartPowerInfo `xml:"AutoStartPowerInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfAutoStartPowerInfo"] = reflect.TypeOf((*ArrayOfAutoStartPowerInfo)(nil)).Elem()
}

type ArrayOfBase64Binary struct {
	Base64Binary [][]byte `xml:"base64Binary,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfBase64Binary"] = reflect.TypeOf((*ArrayOfBase64Binary)(nil)).Elem()
}

// A boxed array of `PrimitiveBoolean`. To be used in `Any` placeholders.
type ArrayOfBoolean struct {
	Boolean []bool `xml:"boolean,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfBoolean"] = reflect.TypeOf((*ArrayOfBoolean)(nil)).Elem()
}

// A boxed array of `PrimitiveByte`. To be used in `Any` placeholders.
type ArrayOfByte struct {
	Byte ByteSlice `xml:"byte,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfByte"] = reflect.TypeOf((*ArrayOfByte)(nil)).Elem()
}

// A boxed array of `ChangesInfoEventArgument`. To be used in `Any` placeholders.
type ArrayOfChangesInfoEventArgument struct {
	ChangesInfoEventArgument []ChangesInfoEventArgument `xml:"ChangesInfoEventArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfChangesInfoEventArgument"] = reflect.TypeOf((*ArrayOfChangesInfoEventArgument)(nil)).Elem()
}

// A boxed array of `CheckResult`. To be used in `Any` placeholders.
type ArrayOfCheckResult struct {
	CheckResult []CheckResult `xml:"CheckResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCheckResult"] = reflect.TypeOf((*ArrayOfCheckResult)(nil)).Elem()
}

// A boxed array of `ClusterAction`. To be used in `Any` placeholders.
type ArrayOfClusterAction struct {
	ClusterAction []BaseClusterAction `xml:"ClusterAction,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfClusterAction"] = reflect.TypeOf((*ArrayOfClusterAction)(nil)).Elem()
}

// A boxed array of `ClusterActionHistory`. To be used in `Any` placeholders.
type ArrayOfClusterActionHistory struct {
	ClusterActionHistory []ClusterActionHistory `xml:"ClusterActionHistory,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterActionHistory"] = reflect.TypeOf((*ArrayOfClusterActionHistory)(nil)).Elem()
}

// A boxed array of `ClusterAttemptedVmInfo`. To be used in `Any` placeholders.
type ArrayOfClusterAttemptedVmInfo struct {
	ClusterAttemptedVmInfo []ClusterAttemptedVmInfo `xml:"ClusterAttemptedVmInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterAttemptedVmInfo)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceDVSSetting`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceDVSSetting struct {
	ClusterComputeResourceDVSSetting []ClusterComputeResourceDVSSetting `xml:"ClusterComputeResourceDVSSetting,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceDVSSetting"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDVSSetting)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping struct {
	ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping []ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping `xml:"ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceDvsProfile`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceDvsProfile struct {
	ClusterComputeResourceDvsProfile []ClusterComputeResourceDvsProfile `xml:"ClusterComputeResourceDvsProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceDvsProfile"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDvsProfile)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping struct {
	ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping []ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping `xml:"ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceHostConfigurationInput`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceHostConfigurationInput struct {
	ClusterComputeResourceHostConfigurationInput []ClusterComputeResourceHostConfigurationInput `xml:"ClusterComputeResourceHostConfigurationInput,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceHostConfigurationInput"] = reflect.TypeOf((*ArrayOfClusterComputeResourceHostConfigurationInput)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceHostEvacuationInfo`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceHostEvacuationInfo struct {
	ClusterComputeResourceHostEvacuationInfo []ClusterComputeResourceHostEvacuationInfo `xml:"ClusterComputeResourceHostEvacuationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceHostEvacuationInfo"] = reflect.TypeOf((*ArrayOfClusterComputeResourceHostEvacuationInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfClusterComputeResourceHostEvacuationInfo"] = "8.0.3.0"
}

// A boxed array of `ClusterComputeResourceHostVmkNicInfo`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceHostVmkNicInfo struct {
	ClusterComputeResourceHostVmkNicInfo []ClusterComputeResourceHostVmkNicInfo `xml:"ClusterComputeResourceHostVmkNicInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceHostVmkNicInfo"] = reflect.TypeOf((*ArrayOfClusterComputeResourceHostVmkNicInfo)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceValidationResultBase`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceValidationResultBase struct {
	ClusterComputeResourceValidationResultBase []BaseClusterComputeResourceValidationResultBase `xml:"ClusterComputeResourceValidationResultBase,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceValidationResultBase"] = reflect.TypeOf((*ArrayOfClusterComputeResourceValidationResultBase)(nil)).Elem()
}

// A boxed array of `ClusterComputeResourceVcsSlots`. To be used in `Any` placeholders.
type ArrayOfClusterComputeResourceVcsSlots struct {
	ClusterComputeResourceVcsSlots []ClusterComputeResourceVcsSlots `xml:"ClusterComputeResourceVcsSlots,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterComputeResourceVcsSlots"] = reflect.TypeOf((*ArrayOfClusterComputeResourceVcsSlots)(nil)).Elem()
	minAPIVersionForType["ArrayOfClusterComputeResourceVcsSlots"] = "7.0.1.1"
}

// A boxed array of `ClusterDasAamNodeState`. To be used in `Any` placeholders.
type ArrayOfClusterDasAamNodeState struct {
	ClusterDasAamNodeState []ClusterDasAamNodeState `xml:"ClusterDasAamNodeState,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDasAamNodeState"] = reflect.TypeOf((*ArrayOfClusterDasAamNodeState)(nil)).Elem()
}

// A boxed array of `ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots`. To be used in `Any` placeholders.
type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

// A boxed array of `ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots`. To be used in `Any` placeholders.
type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

// A boxed array of `ClusterDasVmConfigInfo`. To be used in `Any` placeholders.
type ArrayOfClusterDasVmConfigInfo struct {
	ClusterDasVmConfigInfo []ClusterDasVmConfigInfo `xml:"ClusterDasVmConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDasVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigInfo)(nil)).Elem()
}

// A boxed array of `ClusterDasVmConfigSpec`. To be used in `Any` placeholders.
type ArrayOfClusterDasVmConfigSpec struct {
	ClusterDasVmConfigSpec []ClusterDasVmConfigSpec `xml:"ClusterDasVmConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDasVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigSpec)(nil)).Elem()
}

// A boxed array of `ClusterDatastoreUpdateSpec`. To be used in `Any` placeholders.
type ArrayOfClusterDatastoreUpdateSpec struct {
	ClusterDatastoreUpdateSpec []ClusterDatastoreUpdateSpec `xml:"ClusterDatastoreUpdateSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDatastoreUpdateSpec"] = reflect.TypeOf((*ArrayOfClusterDatastoreUpdateSpec)(nil)).Elem()
	minAPIVersionForType["ArrayOfClusterDatastoreUpdateSpec"] = "7.0.3.0"
}

// A boxed array of `ClusterDpmHostConfigInfo`. To be used in `Any` placeholders.
type ArrayOfClusterDpmHostConfigInfo struct {
	ClusterDpmHostConfigInfo []ClusterDpmHostConfigInfo `xml:"ClusterDpmHostConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigInfo)(nil)).Elem()
}

// A boxed array of `ClusterDpmHostConfigSpec`. To be used in `Any` placeholders.
type ArrayOfClusterDpmHostConfigSpec struct {
	ClusterDpmHostConfigSpec []ClusterDpmHostConfigSpec `xml:"ClusterDpmHostConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigSpec)(nil)).Elem()
}

// A boxed array of `ClusterDrsFaults`. To be used in `Any` placeholders.
type ArrayOfClusterDrsFaults struct {
	ClusterDrsFaults []ClusterDrsFaults `xml:"ClusterDrsFaults,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsFaults"] = reflect.TypeOf((*ArrayOfClusterDrsFaults)(nil)).Elem()
}

// A boxed array of `ClusterDrsFaultsFaultsByVm`. To be used in `Any` placeholders.
type ArrayOfClusterDrsFaultsFaultsByVm struct {
	ClusterDrsFaultsFaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"ClusterDrsFaultsFaultsByVm,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ArrayOfClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

// A boxed array of `ClusterDrsMigration`. To be used in `Any` placeholders.
type ArrayOfClusterDrsMigration struct {
	ClusterDrsMigration []ClusterDrsMigration `xml:"ClusterDrsMigration,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsMigration"] = reflect.TypeOf((*ArrayOfClusterDrsMigration)(nil)).Elem()
}

// A boxed array of `ClusterDrsRecommendation`. To be used in `Any` placeholders.
type ArrayOfClusterDrsRecommendation struct {
	ClusterDrsRecommendation []ClusterDrsRecommendation `xml:"ClusterDrsRecommendation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsRecommendation"] = reflect.TypeOf((*ArrayOfClusterDrsRecommendation)(nil)).Elem()
}

// A boxed array of `ClusterDrsVmConfigInfo`. To be used in `Any` placeholders.
type ArrayOfClusterDrsVmConfigInfo struct {
	ClusterDrsVmConfigInfo []ClusterDrsVmConfigInfo `xml:"ClusterDrsVmConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigInfo)(nil)).Elem()
}

// A boxed array of `ClusterDrsVmConfigSpec`. To be used in `Any` placeholders.
type ArrayOfClusterDrsVmConfigSpec struct {
	ClusterDrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"ClusterDrsVmConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigSpec)(nil)).Elem()
}

// A boxed array of `ClusterEVCManagerCheckResult`. To be used in `Any` placeholders.
type ArrayOfClusterEVCManagerCheckResult struct {
	ClusterEVCManagerCheckResult []ClusterEVCManagerCheckResult `xml:"ClusterEVCManagerCheckResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterEVCManagerCheckResult"] = reflect.TypeOf((*ArrayOfClusterEVCManagerCheckResult)(nil)).Elem()
}

// A boxed array of `ClusterFailoverHostAdmissionControlInfoHostStatus`. To be used in `Any` placeholders.
type ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus struct {
	ClusterFailoverHostAdmissionControlInfoHostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"ClusterFailoverHostAdmissionControlInfoHostStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

// A boxed array of `ClusterGroupInfo`. To be used in `Any` placeholders.
type ArrayOfClusterGroupInfo struct {
	ClusterGroupInfo []BaseClusterGroupInfo `xml:"ClusterGroupInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfClusterGroupInfo"] = reflect.TypeOf((*ArrayOfClusterGroupInfo)(nil)).Elem()
}

// A boxed array of `ClusterGroupSpec`. To be used in `Any` placeholders.
type ArrayOfClusterGroupSpec struct {
	ClusterGroupSpec []ClusterGroupSpec `xml:"ClusterGroupSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterGroupSpec"] = reflect.TypeOf((*ArrayOfClusterGroupSpec)(nil)).Elem()
}

// A boxed array of `ClusterHostRecommendation`. To be used in `Any` placeholders.
type ArrayOfClusterHostRecommendation struct {
	ClusterHostRecommendation []ClusterHostRecommendation `xml:"ClusterHostRecommendation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterHostRecommendation"] = reflect.TypeOf((*ArrayOfClusterHostRecommendation)(nil)).Elem()
}

// A boxed array of `ClusterIoFilterInfo`. To be used in `Any` placeholders.
type ArrayOfClusterIoFilterInfo struct {
	ClusterIoFilterInfo []ClusterIoFilterInfo `xml:"ClusterIoFilterInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterIoFilterInfo"] = reflect.TypeOf((*ArrayOfClusterIoFilterInfo)(nil)).Elem()
}

// A boxed array of `ClusterNotAttemptedVmInfo`. To be used in `Any` placeholders.
type ArrayOfClusterNotAttemptedVmInfo struct {
	ClusterNotAttemptedVmInfo []ClusterNotAttemptedVmInfo `xml:"ClusterNotAttemptedVmInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterNotAttemptedVmInfo)(nil)).Elem()
}

// A boxed array of `ClusterRecommendation`. To be used in `Any` placeholders.
type ArrayOfClusterRecommendation struct {
	ClusterRecommendation []ClusterRecommendation `xml:"ClusterRecommendation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterRecommendation"] = reflect.TypeOf((*ArrayOfClusterRecommendation)(nil)).Elem()
}

// A boxed array of `ClusterRuleInfo`. To be used in `Any` placeholders.
type ArrayOfClusterRuleInfo struct {
	ClusterRuleInfo []BaseClusterRuleInfo `xml:"ClusterRuleInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfClusterRuleInfo"] = reflect.TypeOf((*ArrayOfClusterRuleInfo)(nil)).Elem()
}

// A boxed array of `ClusterRuleSpec`. To be used in `Any` placeholders.
type ArrayOfClusterRuleSpec struct {
	ClusterRuleSpec []ClusterRuleSpec `xml:"ClusterRuleSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterRuleSpec"] = reflect.TypeOf((*ArrayOfClusterRuleSpec)(nil)).Elem()
}

// A boxed array of `ClusterTagCategoryUpdateSpec`. To be used in `Any` placeholders.
type ArrayOfClusterTagCategoryUpdateSpec struct {
	ClusterTagCategoryUpdateSpec []ClusterTagCategoryUpdateSpec `xml:"ClusterTagCategoryUpdateSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterTagCategoryUpdateSpec"] = reflect.TypeOf((*ArrayOfClusterTagCategoryUpdateSpec)(nil)).Elem()
	minAPIVersionForType["ArrayOfClusterTagCategoryUpdateSpec"] = "7.0.3.0"
}

// A boxed array of `ClusterVmOrchestrationInfo`. To be used in `Any` placeholders.
type ArrayOfClusterVmOrchestrationInfo struct {
	ClusterVmOrchestrationInfo []ClusterVmOrchestrationInfo `xml:"ClusterVmOrchestrationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterVmOrchestrationInfo"] = reflect.TypeOf((*ArrayOfClusterVmOrchestrationInfo)(nil)).Elem()
}

// A boxed array of `ClusterVmOrchestrationSpec`. To be used in `Any` placeholders.
type ArrayOfClusterVmOrchestrationSpec struct {
	ClusterVmOrchestrationSpec []ClusterVmOrchestrationSpec `xml:"ClusterVmOrchestrationSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfClusterVmOrchestrationSpec"] = reflect.TypeOf((*ArrayOfClusterVmOrchestrationSpec)(nil)).Elem()
}

// A boxed array of `ComplianceFailure`. To be used in `Any` placeholders.
type ArrayOfComplianceFailure struct {
	ComplianceFailure []ComplianceFailure `xml:"ComplianceFailure,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfComplianceFailure"] = reflect.TypeOf((*ArrayOfComplianceFailure)(nil)).Elem()
}

// A boxed array of `ComplianceFailureComplianceFailureValues`. To be used in `Any` placeholders.
type ArrayOfComplianceFailureComplianceFailureValues struct {
	ComplianceFailureComplianceFailureValues []ComplianceFailureComplianceFailureValues `xml:"ComplianceFailureComplianceFailureValues,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfComplianceFailureComplianceFailureValues"] = reflect.TypeOf((*ArrayOfComplianceFailureComplianceFailureValues)(nil)).Elem()
}

// A boxed array of `ComplianceLocator`. To be used in `Any` placeholders.
type ArrayOfComplianceLocator struct {
	ComplianceLocator []ComplianceLocator `xml:"ComplianceLocator,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfComplianceLocator"] = reflect.TypeOf((*ArrayOfComplianceLocator)(nil)).Elem()
}

// A boxed array of `ComplianceResult`. To be used in `Any` placeholders.
type ArrayOfComplianceResult struct {
	ComplianceResult []ComplianceResult `xml:"ComplianceResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfComplianceResult"] = reflect.TypeOf((*ArrayOfComplianceResult)(nil)).Elem()
}

// A boxed array of `ComputeResourceHostSPBMLicenseInfo`. To be used in `Any` placeholders.
type ArrayOfComputeResourceHostSPBMLicenseInfo struct {
	ComputeResourceHostSPBMLicenseInfo []ComputeResourceHostSPBMLicenseInfo `xml:"ComputeResourceHostSPBMLicenseInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ArrayOfComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

// A boxed array of `ConflictingConfigurationConfig`. To be used in `Any` placeholders.
type ArrayOfConflictingConfigurationConfig struct {
	ConflictingConfigurationConfig []ConflictingConfigurationConfig `xml:"ConflictingConfigurationConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfConflictingConfigurationConfig"] = reflect.TypeOf((*ArrayOfConflictingConfigurationConfig)(nil)).Elem()
}

// A boxed array of `CryptoKeyId`. To be used in `Any` placeholders.
type ArrayOfCryptoKeyId struct {
	CryptoKeyId []CryptoKeyId `xml:"CryptoKeyId,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoKeyId"] = reflect.TypeOf((*ArrayOfCryptoKeyId)(nil)).Elem()
}

// A boxed array of `CryptoKeyPlain`. To be used in `Any` placeholders.
type ArrayOfCryptoKeyPlain struct {
	CryptoKeyPlain []CryptoKeyPlain `xml:"CryptoKeyPlain,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoKeyPlain"] = reflect.TypeOf((*ArrayOfCryptoKeyPlain)(nil)).Elem()
}

// A boxed array of `CryptoKeyResult`. To be used in `Any` placeholders.
type ArrayOfCryptoKeyResult struct {
	CryptoKeyResult []CryptoKeyResult `xml:"CryptoKeyResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoKeyResult"] = reflect.TypeOf((*ArrayOfCryptoKeyResult)(nil)).Elem()
}

// A boxed array of `CryptoManagerHostKeyStatus`. To be used in `Any` placeholders.
type ArrayOfCryptoManagerHostKeyStatus struct {
	CryptoManagerHostKeyStatus []CryptoManagerHostKeyStatus `xml:"CryptoManagerHostKeyStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoManagerHostKeyStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerHostKeyStatus)(nil)).Elem()
	minAPIVersionForType["ArrayOfCryptoManagerHostKeyStatus"] = "8.0.1.0"
}

// A boxed array of `CryptoManagerKmipClusterStatus`. To be used in `Any` placeholders.
type ArrayOfCryptoManagerKmipClusterStatus struct {
	CryptoManagerKmipClusterStatus []CryptoManagerKmipClusterStatus `xml:"CryptoManagerKmipClusterStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoManagerKmipClusterStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipClusterStatus)(nil)).Elem()
}

// A boxed array of `CryptoManagerKmipCryptoKeyStatus`. To be used in `Any` placeholders.
type ArrayOfCryptoManagerKmipCryptoKeyStatus struct {
	CryptoManagerKmipCryptoKeyStatus []CryptoManagerKmipCryptoKeyStatus `xml:"CryptoManagerKmipCryptoKeyStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoManagerKmipCryptoKeyStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipCryptoKeyStatus)(nil)).Elem()
}

// A boxed array of `CryptoManagerKmipServerStatus`. To be used in `Any` placeholders.
type ArrayOfCryptoManagerKmipServerStatus struct {
	CryptoManagerKmipServerStatus []CryptoManagerKmipServerStatus `xml:"CryptoManagerKmipServerStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCryptoManagerKmipServerStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipServerStatus)(nil)).Elem()
}

// A boxed array of `CustomFieldDef`. To be used in `Any` placeholders.
type ArrayOfCustomFieldDef struct {
	CustomFieldDef []CustomFieldDef `xml:"CustomFieldDef,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCustomFieldDef"] = reflect.TypeOf((*ArrayOfCustomFieldDef)(nil)).Elem()
}

// A boxed array of `CustomFieldValue`. To be used in `Any` placeholders.
type ArrayOfCustomFieldValue struct {
	CustomFieldValue []BaseCustomFieldValue `xml:"CustomFieldValue,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfCustomFieldValue"] = reflect.TypeOf((*ArrayOfCustomFieldValue)(nil)).Elem()
}

// A boxed array of `CustomizationAdapterMapping`. To be used in `Any` placeholders.
type ArrayOfCustomizationAdapterMapping struct {
	CustomizationAdapterMapping []CustomizationAdapterMapping `xml:"CustomizationAdapterMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCustomizationAdapterMapping"] = reflect.TypeOf((*ArrayOfCustomizationAdapterMapping)(nil)).Elem()
}

// A boxed array of `CustomizationIpV6Generator`. To be used in `Any` placeholders.
type ArrayOfCustomizationIpV6Generator struct {
	CustomizationIpV6Generator []BaseCustomizationIpV6Generator `xml:"CustomizationIpV6Generator,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfCustomizationIpV6Generator"] = reflect.TypeOf((*ArrayOfCustomizationIpV6Generator)(nil)).Elem()
}

// A boxed array of `CustomizationSpecInfo`. To be used in `Any` placeholders.
type ArrayOfCustomizationSpecInfo struct {
	CustomizationSpecInfo []CustomizationSpecInfo `xml:"CustomizationSpecInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfCustomizationSpecInfo"] = reflect.TypeOf((*ArrayOfCustomizationSpecInfo)(nil)).Elem()
}

// A boxed array of `DVPortConfigSpec`. To be used in `Any` placeholders.
type ArrayOfDVPortConfigSpec struct {
	DVPortConfigSpec []DVPortConfigSpec `xml:"DVPortConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVPortConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortConfigSpec)(nil)).Elem()
}

// A boxed array of `DVPortgroupConfigSpec`. To be used in `Any` placeholders.
type ArrayOfDVPortgroupConfigSpec struct {
	DVPortgroupConfigSpec []DVPortgroupConfigSpec `xml:"DVPortgroupConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVPortgroupConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortgroupConfigSpec)(nil)).Elem()
}

// A boxed array of `DVSHealthCheckConfig`. To be used in `Any` placeholders.
type ArrayOfDVSHealthCheckConfig struct {
	DVSHealthCheckConfig []BaseDVSHealthCheckConfig `xml:"DVSHealthCheckConfig,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfDVSHealthCheckConfig"] = reflect.TypeOf((*ArrayOfDVSHealthCheckConfig)(nil)).Elem()
}

// A boxed array of `DVSManagerPhysicalNicsList`. To be used in `Any` placeholders.
type ArrayOfDVSManagerPhysicalNicsList struct {
	DVSManagerPhysicalNicsList []DVSManagerPhysicalNicsList `xml:"DVSManagerPhysicalNicsList,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVSManagerPhysicalNicsList"] = reflect.TypeOf((*ArrayOfDVSManagerPhysicalNicsList)(nil)).Elem()
	minAPIVersionForType["ArrayOfDVSManagerPhysicalNicsList"] = "8.0.0.1"
}

// A boxed array of `DVSNetworkResourcePool`. To be used in `Any` placeholders.
type ArrayOfDVSNetworkResourcePool struct {
	DVSNetworkResourcePool []DVSNetworkResourcePool `xml:"DVSNetworkResourcePool,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePool"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePool)(nil)).Elem()
}

// A boxed array of `DVSNetworkResourcePoolConfigSpec`. To be used in `Any` placeholders.
type ArrayOfDVSNetworkResourcePoolConfigSpec struct {
	DVSNetworkResourcePoolConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"DVSNetworkResourcePoolConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

// A boxed array of `DVSVmVnicNetworkResourcePool`. To be used in `Any` placeholders.
type ArrayOfDVSVmVnicNetworkResourcePool struct {
	DVSVmVnicNetworkResourcePool []DVSVmVnicNetworkResourcePool `xml:"DVSVmVnicNetworkResourcePool,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDVSVmVnicNetworkResourcePool"] = reflect.TypeOf((*ArrayOfDVSVmVnicNetworkResourcePool)(nil)).Elem()
}

// A boxed array of `DasHeartbeatDatastoreInfo`. To be used in `Any` placeholders.
type ArrayOfDasHeartbeatDatastoreInfo struct {
	DasHeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo `xml:"DasHeartbeatDatastoreInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDasHeartbeatDatastoreInfo"] = reflect.TypeOf((*ArrayOfDasHeartbeatDatastoreInfo)(nil)).Elem()
}

// A boxed array of `DatacenterBasicConnectInfo`. To be used in `Any` placeholders.
type ArrayOfDatacenterBasicConnectInfo struct {
	DatacenterBasicConnectInfo []DatacenterBasicConnectInfo `xml:"DatacenterBasicConnectInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDatacenterBasicConnectInfo"] = reflect.TypeOf((*ArrayOfDatacenterBasicConnectInfo)(nil)).Elem()
}

// A boxed array of `DatacenterMismatchArgument`. To be used in `Any` placeholders.
type ArrayOfDatacenterMismatchArgument struct {
	DatacenterMismatchArgument []DatacenterMismatchArgument `xml:"DatacenterMismatchArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDatacenterMismatchArgument"] = reflect.TypeOf((*ArrayOfDatacenterMismatchArgument)(nil)).Elem()
}

// A boxed array of `DatastoreHostMount`. To be used in `Any` placeholders.
type ArrayOfDatastoreHostMount struct {
	DatastoreHostMount []DatastoreHostMount `xml:"DatastoreHostMount,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDatastoreHostMount"] = reflect.TypeOf((*ArrayOfDatastoreHostMount)(nil)).Elem()
}

// A boxed array of `DatastoreMountPathDatastorePair`. To be used in `Any` placeholders.
type ArrayOfDatastoreMountPathDatastorePair struct {
	DatastoreMountPathDatastorePair []DatastoreMountPathDatastorePair `xml:"DatastoreMountPathDatastorePair,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDatastoreMountPathDatastorePair"] = reflect.TypeOf((*ArrayOfDatastoreMountPathDatastorePair)(nil)).Elem()
}

// A boxed array of `DatastoreVVolContainerFailoverPair`. To be used in `Any` placeholders.
type ArrayOfDatastoreVVolContainerFailoverPair struct {
	DatastoreVVolContainerFailoverPair []DatastoreVVolContainerFailoverPair `xml:"DatastoreVVolContainerFailoverPair,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDatastoreVVolContainerFailoverPair"] = reflect.TypeOf((*ArrayOfDatastoreVVolContainerFailoverPair)(nil)).Elem()
}

// A boxed array of `DesiredSoftwareSpecComponentSpec`. To be used in `Any` placeholders.
type ArrayOfDesiredSoftwareSpecComponentSpec struct {
	DesiredSoftwareSpecComponentSpec []DesiredSoftwareSpecComponentSpec `xml:"DesiredSoftwareSpecComponentSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDesiredSoftwareSpecComponentSpec"] = reflect.TypeOf((*ArrayOfDesiredSoftwareSpecComponentSpec)(nil)).Elem()
	minAPIVersionForType["ArrayOfDesiredSoftwareSpecComponentSpec"] = "7.0.2.0"
}

// A boxed array of `DiagnosticManagerBundleInfo`. To be used in `Any` placeholders.
type ArrayOfDiagnosticManagerBundleInfo struct {
	DiagnosticManagerBundleInfo []DiagnosticManagerBundleInfo `xml:"DiagnosticManagerBundleInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDiagnosticManagerBundleInfo"] = reflect.TypeOf((*ArrayOfDiagnosticManagerBundleInfo)(nil)).Elem()
}

// A boxed array of `DiagnosticManagerLogDescriptor`. To be used in `Any` placeholders.
type ArrayOfDiagnosticManagerLogDescriptor struct {
	DiagnosticManagerLogDescriptor []DiagnosticManagerLogDescriptor `xml:"DiagnosticManagerLogDescriptor,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDiagnosticManagerLogDescriptor"] = reflect.TypeOf((*ArrayOfDiagnosticManagerLogDescriptor)(nil)).Elem()
}

// A boxed array of `DiskChangeExtent`. To be used in `Any` placeholders.
type ArrayOfDiskChangeExtent struct {
	DiskChangeExtent []DiskChangeExtent `xml:"DiskChangeExtent,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDiskChangeExtent"] = reflect.TypeOf((*ArrayOfDiskChangeExtent)(nil)).Elem()
}

// A boxed array of `DistributedVirtualPort`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualPort struct {
	DistributedVirtualPort []DistributedVirtualPort `xml:"DistributedVirtualPort,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualPort"] = reflect.TypeOf((*ArrayOfDistributedVirtualPort)(nil)).Elem()
}

// A boxed array of `DistributedVirtualPortgroupInfo`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualPortgroupInfo struct {
	DistributedVirtualPortgroupInfo []DistributedVirtualPortgroupInfo `xml:"DistributedVirtualPortgroupInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualPortgroupInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualPortgroupInfo)(nil)).Elem()
}

// A boxed array of `DistributedVirtualPortgroupProblem`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualPortgroupProblem struct {
	DistributedVirtualPortgroupProblem []DistributedVirtualPortgroupProblem `xml:"DistributedVirtualPortgroupProblem,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualPortgroupProblem"] = reflect.TypeOf((*ArrayOfDistributedVirtualPortgroupProblem)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchHostMember`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostMember struct {
	DistributedVirtualSwitchHostMember []DistributedVirtualSwitchHostMember `xml:"DistributedVirtualSwitchHostMember,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMember"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMember)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchHostMemberConfigSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostMemberConfigSpec struct {
	DistributedVirtualSwitchHostMemberConfigSpec []DistributedVirtualSwitchHostMemberConfigSpec `xml:"DistributedVirtualSwitchHostMemberConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchHostMemberHostUplinkState`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostMemberHostUplinkState struct {
	DistributedVirtualSwitchHostMemberHostUplinkState []DistributedVirtualSwitchHostMemberHostUplinkState `xml:"DistributedVirtualSwitchHostMemberHostUplinkState,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberHostUplinkState"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberHostUplinkState)(nil)).Elem()
	minAPIVersionForType["ArrayOfDistributedVirtualSwitchHostMemberHostUplinkState"] = "8.0.3.0"
}

// A boxed array of `DistributedVirtualSwitchHostMemberPnicSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostMemberPnicSpec struct {
	DistributedVirtualSwitchHostMemberPnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"DistributedVirtualSwitchHostMemberPnicSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchHostMemberTransportZoneInfo`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo struct {
	DistributedVirtualSwitchHostMemberTransportZoneInfo []DistributedVirtualSwitchHostMemberTransportZoneInfo `xml:"DistributedVirtualSwitchHostMemberTransportZoneInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchHostProductSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchHostProductSpec struct {
	DistributedVirtualSwitchHostProductSpec []DistributedVirtualSwitchHostProductSpec `xml:"DistributedVirtualSwitchHostProductSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchInfo`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchInfo struct {
	DistributedVirtualSwitchInfo []DistributedVirtualSwitchInfo `xml:"DistributedVirtualSwitchInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchInfo)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchKeyedOpaqueBlob`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob struct {
	DistributedVirtualSwitchKeyedOpaqueBlob []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"DistributedVirtualSwitchKeyedOpaqueBlob,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchManagerCompatibilityResult`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchManagerCompatibilityResult struct {
	DistributedVirtualSwitchManagerCompatibilityResult []DistributedVirtualSwitchManagerCompatibilityResult `xml:"DistributedVirtualSwitchManagerCompatibilityResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchManagerHostDvsFilterSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec []BaseDistributedVirtualSwitchManagerHostDvsFilterSpec `xml:"DistributedVirtualSwitchManagerHostDvsFilterSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

// A boxed array of `DistributedVirtualSwitchNetworkOffloadSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchNetworkOffloadSpec struct {
	DistributedVirtualSwitchNetworkOffloadSpec []DistributedVirtualSwitchNetworkOffloadSpec `xml:"DistributedVirtualSwitchNetworkOffloadSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchNetworkOffloadSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchNetworkOffloadSpec)(nil)).Elem()
	minAPIVersionForType["ArrayOfDistributedVirtualSwitchNetworkOffloadSpec"] = "8.0.0.1"
}

// A boxed array of `DistributedVirtualSwitchProductSpec`. To be used in `Any` placeholders.
type ArrayOfDistributedVirtualSwitchProductSpec struct {
	DistributedVirtualSwitchProductSpec []DistributedVirtualSwitchProductSpec `xml:"DistributedVirtualSwitchProductSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchProductSpec)(nil)).Elem()
}

// A boxed array of `PrimitiveDouble`. To be used in `Any` placeholders.
type ArrayOfDouble struct {
	Double []float64 `xml:"double,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDouble"] = reflect.TypeOf((*ArrayOfDouble)(nil)).Elem()
}

// A boxed array of `DpuStatusInfo`. To be used in `Any` placeholders.
type ArrayOfDpuStatusInfo struct {
	DpuStatusInfo []DpuStatusInfo `xml:"DpuStatusInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDpuStatusInfo"] = reflect.TypeOf((*ArrayOfDpuStatusInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfDpuStatusInfo"] = "8.0.0.1"
}

// A boxed array of `DpuStatusInfoOperationalInfo`. To be used in `Any` placeholders.
type ArrayOfDpuStatusInfoOperationalInfo struct {
	DpuStatusInfoOperationalInfo []DpuStatusInfoOperationalInfo `xml:"DpuStatusInfoOperationalInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDpuStatusInfoOperationalInfo"] = reflect.TypeOf((*ArrayOfDpuStatusInfoOperationalInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfDpuStatusInfoOperationalInfo"] = "8.0.0.1"
}

// A boxed array of `DvsApplyOperationFaultFaultOnObject`. To be used in `Any` placeholders.
type ArrayOfDvsApplyOperationFaultFaultOnObject struct {
	DvsApplyOperationFaultFaultOnObject []DvsApplyOperationFaultFaultOnObject `xml:"DvsApplyOperationFaultFaultOnObject,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*ArrayOfDvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

// A boxed array of `DvsFilterConfig`. To be used in `Any` placeholders.
type ArrayOfDvsFilterConfig struct {
	DvsFilterConfig []BaseDvsFilterConfig `xml:"DvsFilterConfig,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfDvsFilterConfig"] = reflect.TypeOf((*ArrayOfDvsFilterConfig)(nil)).Elem()
}

// A boxed array of `DvsHostInfrastructureTrafficResource`. To be used in `Any` placeholders.
type ArrayOfDvsHostInfrastructureTrafficResource struct {
	DvsHostInfrastructureTrafficResource []DvsHostInfrastructureTrafficResource `xml:"DvsHostInfrastructureTrafficResource,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsHostInfrastructureTrafficResource"] = reflect.TypeOf((*ArrayOfDvsHostInfrastructureTrafficResource)(nil)).Elem()
}

// A boxed array of `DvsHostVNicProfile`. To be used in `Any` placeholders.
type ArrayOfDvsHostVNicProfile struct {
	DvsHostVNicProfile []DvsHostVNicProfile `xml:"DvsHostVNicProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsHostVNicProfile"] = reflect.TypeOf((*ArrayOfDvsHostVNicProfile)(nil)).Elem()
}

// A boxed array of `DvsNetworkRuleQualifier`. To be used in `Any` placeholders.
type ArrayOfDvsNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier []BaseDvsNetworkRuleQualifier `xml:"DvsNetworkRuleQualifier,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfDvsNetworkRuleQualifier"] = reflect.TypeOf((*ArrayOfDvsNetworkRuleQualifier)(nil)).Elem()
}

// A boxed array of `DvsOperationBulkFaultFaultOnHost`. To be used in `Any` placeholders.
type ArrayOfDvsOperationBulkFaultFaultOnHost struct {
	DvsOperationBulkFaultFaultOnHost []DvsOperationBulkFaultFaultOnHost `xml:"DvsOperationBulkFaultFaultOnHost,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*ArrayOfDvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

// A boxed array of `DvsOutOfSyncHostArgument`. To be used in `Any` placeholders.
type ArrayOfDvsOutOfSyncHostArgument struct {
	DvsOutOfSyncHostArgument []DvsOutOfSyncHostArgument `xml:"DvsOutOfSyncHostArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsOutOfSyncHostArgument"] = reflect.TypeOf((*ArrayOfDvsOutOfSyncHostArgument)(nil)).Elem()
}

// A boxed array of `DvsProfile`. To be used in `Any` placeholders.
type ArrayOfDvsProfile struct {
	DvsProfile []DvsProfile `xml:"DvsProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsProfile"] = reflect.TypeOf((*ArrayOfDvsProfile)(nil)).Elem()
}

// A boxed array of `DvsServiceConsoleVNicProfile`. To be used in `Any` placeholders.
type ArrayOfDvsServiceConsoleVNicProfile struct {
	DvsServiceConsoleVNicProfile []DvsServiceConsoleVNicProfile `xml:"DvsServiceConsoleVNicProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsServiceConsoleVNicProfile"] = reflect.TypeOf((*ArrayOfDvsServiceConsoleVNicProfile)(nil)).Elem()
}

// A boxed array of `DvsTrafficRule`. To be used in `Any` placeholders.
type ArrayOfDvsTrafficRule struct {
	DvsTrafficRule []DvsTrafficRule `xml:"DvsTrafficRule,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsTrafficRule"] = reflect.TypeOf((*ArrayOfDvsTrafficRule)(nil)).Elem()
}

// A boxed array of `DvsVmVnicNetworkResourcePoolRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo struct {
	DvsVmVnicNetworkResourcePoolRuntimeInfo []DvsVmVnicNetworkResourcePoolRuntimeInfo `xml:"DvsVmVnicNetworkResourcePoolRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo"] = reflect.TypeOf((*ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo)(nil)).Elem()
}

// A boxed array of `DvsVmVnicResourcePoolConfigSpec`. To be used in `Any` placeholders.
type ArrayOfDvsVmVnicResourcePoolConfigSpec struct {
	DvsVmVnicResourcePoolConfigSpec []DvsVmVnicResourcePoolConfigSpec `xml:"DvsVmVnicResourcePoolConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsVmVnicResourcePoolConfigSpec"] = reflect.TypeOf((*ArrayOfDvsVmVnicResourcePoolConfigSpec)(nil)).Elem()
}

// A boxed array of `DvsVnicAllocatedResource`. To be used in `Any` placeholders.
type ArrayOfDvsVnicAllocatedResource struct {
	DvsVnicAllocatedResource []DvsVnicAllocatedResource `xml:"DvsVnicAllocatedResource,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDvsVnicAllocatedResource"] = reflect.TypeOf((*ArrayOfDvsVnicAllocatedResource)(nil)).Elem()
}

// A boxed array of `DynamicProperty`. To be used in `Any` placeholders.
type ArrayOfDynamicProperty struct {
	DynamicProperty []DynamicProperty `xml:"DynamicProperty,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfDynamicProperty"] = reflect.TypeOf((*ArrayOfDynamicProperty)(nil)).Elem()
}

// A boxed array of `EVCMode`. To be used in `Any` placeholders.
type ArrayOfEVCMode struct {
	EVCMode []EVCMode `xml:"EVCMode,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEVCMode"] = reflect.TypeOf((*ArrayOfEVCMode)(nil)).Elem()
}

// A boxed array of `ElementDescription`. To be used in `Any` placeholders.
type ArrayOfElementDescription struct {
	ElementDescription []BaseElementDescription `xml:"ElementDescription,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfElementDescription"] = reflect.TypeOf((*ArrayOfElementDescription)(nil)).Elem()
}

// A boxed array of `EntityBackupConfig`. To be used in `Any` placeholders.
type ArrayOfEntityBackupConfig struct {
	EntityBackupConfig []EntityBackupConfig `xml:"EntityBackupConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEntityBackupConfig"] = reflect.TypeOf((*ArrayOfEntityBackupConfig)(nil)).Elem()
}

// A boxed array of `EntityPrivilege`. To be used in `Any` placeholders.
type ArrayOfEntityPrivilege struct {
	EntityPrivilege []EntityPrivilege `xml:"EntityPrivilege,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEntityPrivilege"] = reflect.TypeOf((*ArrayOfEntityPrivilege)(nil)).Elem()
}

// A boxed array of `EnumDescription`. To be used in `Any` placeholders.
type ArrayOfEnumDescription struct {
	EnumDescription []EnumDescription `xml:"EnumDescription,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEnumDescription"] = reflect.TypeOf((*ArrayOfEnumDescription)(nil)).Elem()
}

// A boxed array of `Event`. To be used in `Any` placeholders.
type ArrayOfEvent struct {
	Event []BaseEvent `xml:"Event,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfEvent"] = reflect.TypeOf((*ArrayOfEvent)(nil)).Elem()
}

// A boxed array of `EventAlarmExpressionComparison`. To be used in `Any` placeholders.
type ArrayOfEventAlarmExpressionComparison struct {
	EventAlarmExpressionComparison []EventAlarmExpressionComparison `xml:"EventAlarmExpressionComparison,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEventAlarmExpressionComparison"] = reflect.TypeOf((*ArrayOfEventAlarmExpressionComparison)(nil)).Elem()
}

// A boxed array of `EventArgDesc`. To be used in `Any` placeholders.
type ArrayOfEventArgDesc struct {
	EventArgDesc []EventArgDesc `xml:"EventArgDesc,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEventArgDesc"] = reflect.TypeOf((*ArrayOfEventArgDesc)(nil)).Elem()
}

// A boxed array of `EventDescriptionEventDetail`. To be used in `Any` placeholders.
type ArrayOfEventDescriptionEventDetail struct {
	EventDescriptionEventDetail []EventDescriptionEventDetail `xml:"EventDescriptionEventDetail,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfEventDescriptionEventDetail"] = reflect.TypeOf((*ArrayOfEventDescriptionEventDetail)(nil)).Elem()
}

// A boxed array of `ExtManagedEntityInfo`. To be used in `Any` placeholders.
type ArrayOfExtManagedEntityInfo struct {
	ExtManagedEntityInfo []ExtManagedEntityInfo `xml:"ExtManagedEntityInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtManagedEntityInfo"] = reflect.TypeOf((*ArrayOfExtManagedEntityInfo)(nil)).Elem()
}

// A boxed array of `ExtSolutionManagerInfoTabInfo`. To be used in `Any` placeholders.
type ArrayOfExtSolutionManagerInfoTabInfo struct {
	ExtSolutionManagerInfoTabInfo []ExtSolutionManagerInfoTabInfo `xml:"ExtSolutionManagerInfoTabInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtSolutionManagerInfoTabInfo"] = reflect.TypeOf((*ArrayOfExtSolutionManagerInfoTabInfo)(nil)).Elem()
}

// A boxed array of `ExtendedEventPair`. To be used in `Any` placeholders.
type ArrayOfExtendedEventPair struct {
	ExtendedEventPair []ExtendedEventPair `xml:"ExtendedEventPair,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtendedEventPair"] = reflect.TypeOf((*ArrayOfExtendedEventPair)(nil)).Elem()
}

// A boxed array of `Extension`. To be used in `Any` placeholders.
type ArrayOfExtension struct {
	Extension []Extension `xml:"Extension,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtension"] = reflect.TypeOf((*ArrayOfExtension)(nil)).Elem()
}

// A boxed array of `ExtensionClientInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionClientInfo struct {
	ExtensionClientInfo []ExtensionClientInfo `xml:"ExtensionClientInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionClientInfo"] = reflect.TypeOf((*ArrayOfExtensionClientInfo)(nil)).Elem()
}

// A boxed array of `ExtensionEventTypeInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionEventTypeInfo struct {
	ExtensionEventTypeInfo []ExtensionEventTypeInfo `xml:"ExtensionEventTypeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionEventTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionEventTypeInfo)(nil)).Elem()
}

// A boxed array of `ExtensionFaultTypeInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionFaultTypeInfo struct {
	ExtensionFaultTypeInfo []ExtensionFaultTypeInfo `xml:"ExtensionFaultTypeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionFaultTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionFaultTypeInfo)(nil)).Elem()
}

// A boxed array of `ExtensionManagerIpAllocationUsage`. To be used in `Any` placeholders.
type ArrayOfExtensionManagerIpAllocationUsage struct {
	ExtensionManagerIpAllocationUsage []ExtensionManagerIpAllocationUsage `xml:"ExtensionManagerIpAllocationUsage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionManagerIpAllocationUsage"] = reflect.TypeOf((*ArrayOfExtensionManagerIpAllocationUsage)(nil)).Elem()
}

// A boxed array of `ExtensionPrivilegeInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionPrivilegeInfo struct {
	ExtensionPrivilegeInfo []ExtensionPrivilegeInfo `xml:"ExtensionPrivilegeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionPrivilegeInfo"] = reflect.TypeOf((*ArrayOfExtensionPrivilegeInfo)(nil)).Elem()
}

// A boxed array of `ExtensionResourceInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionResourceInfo struct {
	ExtensionResourceInfo []ExtensionResourceInfo `xml:"ExtensionResourceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionResourceInfo"] = reflect.TypeOf((*ArrayOfExtensionResourceInfo)(nil)).Elem()
}

// A boxed array of `ExtensionServerInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionServerInfo struct {
	ExtensionServerInfo []ExtensionServerInfo `xml:"ExtensionServerInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionServerInfo"] = reflect.TypeOf((*ArrayOfExtensionServerInfo)(nil)).Elem()
}

// A boxed array of `ExtensionTaskTypeInfo`. To be used in `Any` placeholders.
type ArrayOfExtensionTaskTypeInfo struct {
	ExtensionTaskTypeInfo []ExtensionTaskTypeInfo `xml:"ExtensionTaskTypeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfExtensionTaskTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionTaskTypeInfo)(nil)).Elem()
}

// A boxed array of `FaultToleranceDiskSpec`. To be used in `Any` placeholders.
type ArrayOfFaultToleranceDiskSpec struct {
	FaultToleranceDiskSpec []FaultToleranceDiskSpec `xml:"FaultToleranceDiskSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFaultToleranceDiskSpec"] = reflect.TypeOf((*ArrayOfFaultToleranceDiskSpec)(nil)).Elem()
}

// A boxed array of `FaultsByHost`. To be used in `Any` placeholders.
type ArrayOfFaultsByHost struct {
	FaultsByHost []FaultsByHost `xml:"FaultsByHost,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFaultsByHost"] = reflect.TypeOf((*ArrayOfFaultsByHost)(nil)).Elem()
}

// A boxed array of `FaultsByVM`. To be used in `Any` placeholders.
type ArrayOfFaultsByVM struct {
	FaultsByVM []FaultsByVM `xml:"FaultsByVM,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFaultsByVM"] = reflect.TypeOf((*ArrayOfFaultsByVM)(nil)).Elem()
}

// A boxed array of `FcoeConfigVlanRange`. To be used in `Any` placeholders.
type ArrayOfFcoeConfigVlanRange struct {
	FcoeConfigVlanRange []FcoeConfigVlanRange `xml:"FcoeConfigVlanRange,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFcoeConfigVlanRange"] = reflect.TypeOf((*ArrayOfFcoeConfigVlanRange)(nil)).Elem()
}

// A boxed array of `FeatureEVCMode`. To be used in `Any` placeholders.
type ArrayOfFeatureEVCMode struct {
	FeatureEVCMode []FeatureEVCMode `xml:"FeatureEVCMode,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFeatureEVCMode"] = reflect.TypeOf((*ArrayOfFeatureEVCMode)(nil)).Elem()
	minAPIVersionForType["ArrayOfFeatureEVCMode"] = "7.0.1.0"
}

// A boxed array of `FileInfo`. To be used in `Any` placeholders.
type ArrayOfFileInfo struct {
	FileInfo []BaseFileInfo `xml:"FileInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfFileInfo"] = reflect.TypeOf((*ArrayOfFileInfo)(nil)).Elem()
}

// A boxed array of `FileLockInfo`. To be used in `Any` placeholders.
type ArrayOfFileLockInfo struct {
	FileLockInfo []FileLockInfo `xml:"FileLockInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFileLockInfo"] = reflect.TypeOf((*ArrayOfFileLockInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfFileLockInfo"] = "8.0.2.0"
}

// A boxed array of `FileQuery`. To be used in `Any` placeholders.
type ArrayOfFileQuery struct {
	FileQuery []BaseFileQuery `xml:"FileQuery,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfFileQuery"] = reflect.TypeOf((*ArrayOfFileQuery)(nil)).Elem()
}

// A boxed array of `FirewallProfileRulesetProfile`. To be used in `Any` placeholders.
type ArrayOfFirewallProfileRulesetProfile struct {
	FirewallProfileRulesetProfile []FirewallProfileRulesetProfile `xml:"FirewallProfileRulesetProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFirewallProfileRulesetProfile"] = reflect.TypeOf((*ArrayOfFirewallProfileRulesetProfile)(nil)).Elem()
}

// A boxed array of `FolderFailedHostResult`. To be used in `Any` placeholders.
type ArrayOfFolderFailedHostResult struct {
	FolderFailedHostResult []FolderFailedHostResult `xml:"FolderFailedHostResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFolderFailedHostResult"] = reflect.TypeOf((*ArrayOfFolderFailedHostResult)(nil)).Elem()
}

// A boxed array of `FolderNewHostSpec`. To be used in `Any` placeholders.
type ArrayOfFolderNewHostSpec struct {
	FolderNewHostSpec []FolderNewHostSpec `xml:"FolderNewHostSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfFolderNewHostSpec"] = reflect.TypeOf((*ArrayOfFolderNewHostSpec)(nil)).Elem()
}

// A boxed array of `GuestAliases`. To be used in `Any` placeholders.
type ArrayOfGuestAliases struct {
	GuestAliases []GuestAliases `xml:"GuestAliases,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestAliases"] = reflect.TypeOf((*ArrayOfGuestAliases)(nil)).Elem()
}

// A boxed array of `GuestAuthAliasInfo`. To be used in `Any` placeholders.
type ArrayOfGuestAuthAliasInfo struct {
	GuestAuthAliasInfo []GuestAuthAliasInfo `xml:"GuestAuthAliasInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestAuthAliasInfo"] = reflect.TypeOf((*ArrayOfGuestAuthAliasInfo)(nil)).Elem()
}

// A boxed array of `GuestAuthSubject`. To be used in `Any` placeholders.
type ArrayOfGuestAuthSubject struct {
	GuestAuthSubject []BaseGuestAuthSubject `xml:"GuestAuthSubject,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfGuestAuthSubject"] = reflect.TypeOf((*ArrayOfGuestAuthSubject)(nil)).Elem()
}

// A boxed array of `GuestDiskInfo`. To be used in `Any` placeholders.
type ArrayOfGuestDiskInfo struct {
	GuestDiskInfo []GuestDiskInfo `xml:"GuestDiskInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestDiskInfo"] = reflect.TypeOf((*ArrayOfGuestDiskInfo)(nil)).Elem()
}

// A boxed array of `GuestFileInfo`. To be used in `Any` placeholders.
type ArrayOfGuestFileInfo struct {
	GuestFileInfo []GuestFileInfo `xml:"GuestFileInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestFileInfo"] = reflect.TypeOf((*ArrayOfGuestFileInfo)(nil)).Elem()
}

// A boxed array of `GuestInfoNamespaceGenerationInfo`. To be used in `Any` placeholders.
type ArrayOfGuestInfoNamespaceGenerationInfo struct {
	GuestInfoNamespaceGenerationInfo []GuestInfoNamespaceGenerationInfo `xml:"GuestInfoNamespaceGenerationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestInfoNamespaceGenerationInfo"] = reflect.TypeOf((*ArrayOfGuestInfoNamespaceGenerationInfo)(nil)).Elem()
}

// A boxed array of `GuestInfoVirtualDiskMapping`. To be used in `Any` placeholders.
type ArrayOfGuestInfoVirtualDiskMapping struct {
	GuestInfoVirtualDiskMapping []GuestInfoVirtualDiskMapping `xml:"GuestInfoVirtualDiskMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestInfoVirtualDiskMapping"] = reflect.TypeOf((*ArrayOfGuestInfoVirtualDiskMapping)(nil)).Elem()
}

// A boxed array of `GuestMappedAliases`. To be used in `Any` placeholders.
type ArrayOfGuestMappedAliases struct {
	GuestMappedAliases []GuestMappedAliases `xml:"GuestMappedAliases,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestMappedAliases"] = reflect.TypeOf((*ArrayOfGuestMappedAliases)(nil)).Elem()
}

// A boxed array of `GuestNicInfo`. To be used in `Any` placeholders.
type ArrayOfGuestNicInfo struct {
	GuestNicInfo []GuestNicInfo `xml:"GuestNicInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestNicInfo"] = reflect.TypeOf((*ArrayOfGuestNicInfo)(nil)).Elem()
}

// A boxed array of `GuestOsDescriptor`. To be used in `Any` placeholders.
type ArrayOfGuestOsDescriptor struct {
	GuestOsDescriptor []GuestOsDescriptor `xml:"GuestOsDescriptor,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestOsDescriptor"] = reflect.TypeOf((*ArrayOfGuestOsDescriptor)(nil)).Elem()
}

// A boxed array of `GuestProcessInfo`. To be used in `Any` placeholders.
type ArrayOfGuestProcessInfo struct {
	GuestProcessInfo []GuestProcessInfo `xml:"GuestProcessInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestProcessInfo"] = reflect.TypeOf((*ArrayOfGuestProcessInfo)(nil)).Elem()
}

// A boxed array of `GuestRegKeyRecordSpec`. To be used in `Any` placeholders.
type ArrayOfGuestRegKeyRecordSpec struct {
	GuestRegKeyRecordSpec []GuestRegKeyRecordSpec `xml:"GuestRegKeyRecordSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestRegKeyRecordSpec"] = reflect.TypeOf((*ArrayOfGuestRegKeyRecordSpec)(nil)).Elem()
}

// A boxed array of `GuestRegValueSpec`. To be used in `Any` placeholders.
type ArrayOfGuestRegValueSpec struct {
	GuestRegValueSpec []GuestRegValueSpec `xml:"GuestRegValueSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestRegValueSpec"] = reflect.TypeOf((*ArrayOfGuestRegValueSpec)(nil)).Elem()
}

// A boxed array of `GuestStackInfo`. To be used in `Any` placeholders.
type ArrayOfGuestStackInfo struct {
	GuestStackInfo []GuestStackInfo `xml:"GuestStackInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfGuestStackInfo"] = reflect.TypeOf((*ArrayOfGuestStackInfo)(nil)).Elem()
}

// A boxed array of `HbrManagerVmReplicationCapability`. To be used in `Any` placeholders.
type ArrayOfHbrManagerVmReplicationCapability struct {
	HbrManagerVmReplicationCapability []HbrManagerVmReplicationCapability `xml:"HbrManagerVmReplicationCapability,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHbrManagerVmReplicationCapability"] = reflect.TypeOf((*ArrayOfHbrManagerVmReplicationCapability)(nil)).Elem()
}

// A boxed array of `HealthUpdate`. To be used in `Any` placeholders.
type ArrayOfHealthUpdate struct {
	HealthUpdate []HealthUpdate `xml:"HealthUpdate,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHealthUpdate"] = reflect.TypeOf((*ArrayOfHealthUpdate)(nil)).Elem()
}

// A boxed array of `HealthUpdateInfo`. To be used in `Any` placeholders.
type ArrayOfHealthUpdateInfo struct {
	HealthUpdateInfo []HealthUpdateInfo `xml:"HealthUpdateInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHealthUpdateInfo"] = reflect.TypeOf((*ArrayOfHealthUpdateInfo)(nil)).Elem()
}

// A boxed array of `HostAccessControlEntry`. To be used in `Any` placeholders.
type ArrayOfHostAccessControlEntry struct {
	HostAccessControlEntry []HostAccessControlEntry `xml:"HostAccessControlEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostAccessControlEntry"] = reflect.TypeOf((*ArrayOfHostAccessControlEntry)(nil)).Elem()
}

// A boxed array of `HostAccountSpec`. To be used in `Any` placeholders.
type ArrayOfHostAccountSpec struct {
	HostAccountSpec []BaseHostAccountSpec `xml:"HostAccountSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostAccountSpec"] = reflect.TypeOf((*ArrayOfHostAccountSpec)(nil)).Elem()
}

// A boxed array of `HostActiveDirectory`. To be used in `Any` placeholders.
type ArrayOfHostActiveDirectory struct {
	HostActiveDirectory []HostActiveDirectory `xml:"HostActiveDirectory,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostActiveDirectory"] = reflect.TypeOf((*ArrayOfHostActiveDirectory)(nil)).Elem()
}

// A boxed array of `HostAssignableHardwareBinding`. To be used in `Any` placeholders.
type ArrayOfHostAssignableHardwareBinding struct {
	HostAssignableHardwareBinding []HostAssignableHardwareBinding `xml:"HostAssignableHardwareBinding,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostAssignableHardwareBinding"] = reflect.TypeOf((*ArrayOfHostAssignableHardwareBinding)(nil)).Elem()
}

// A boxed array of `HostAssignableHardwareConfigAttributeOverride`. To be used in `Any` placeholders.
type ArrayOfHostAssignableHardwareConfigAttributeOverride struct {
	HostAssignableHardwareConfigAttributeOverride []HostAssignableHardwareConfigAttributeOverride `xml:"HostAssignableHardwareConfigAttributeOverride,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostAssignableHardwareConfigAttributeOverride"] = reflect.TypeOf((*ArrayOfHostAssignableHardwareConfigAttributeOverride)(nil)).Elem()
}

// A boxed array of `HostAuthenticationStoreInfo`. To be used in `Any` placeholders.
type ArrayOfHostAuthenticationStoreInfo struct {
	HostAuthenticationStoreInfo []BaseHostAuthenticationStoreInfo `xml:"HostAuthenticationStoreInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostAuthenticationStoreInfo"] = reflect.TypeOf((*ArrayOfHostAuthenticationStoreInfo)(nil)).Elem()
}

// A boxed array of `HostBootDevice`. To be used in `Any` placeholders.
type ArrayOfHostBootDevice struct {
	HostBootDevice []HostBootDevice `xml:"HostBootDevice,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostBootDevice"] = reflect.TypeOf((*ArrayOfHostBootDevice)(nil)).Elem()
}

// A boxed array of `HostCacheConfigurationInfo`. To be used in `Any` placeholders.
type ArrayOfHostCacheConfigurationInfo struct {
	HostCacheConfigurationInfo []HostCacheConfigurationInfo `xml:"HostCacheConfigurationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostCacheConfigurationInfo"] = reflect.TypeOf((*ArrayOfHostCacheConfigurationInfo)(nil)).Elem()
}

// A boxed array of `HostCertificateManagerCertificateInfo`. To be used in `Any` placeholders.
type ArrayOfHostCertificateManagerCertificateInfo struct {
	HostCertificateManagerCertificateInfo []HostCertificateManagerCertificateInfo `xml:"HostCertificateManagerCertificateInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostCertificateManagerCertificateInfo"] = reflect.TypeOf((*ArrayOfHostCertificateManagerCertificateInfo)(nil)).Elem()
}

// A boxed array of `HostConnectInfoNetworkInfo`. To be used in `Any` placeholders.
type ArrayOfHostConnectInfoNetworkInfo struct {
	HostConnectInfoNetworkInfo []BaseHostConnectInfoNetworkInfo `xml:"HostConnectInfoNetworkInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostConnectInfoNetworkInfo"] = reflect.TypeOf((*ArrayOfHostConnectInfoNetworkInfo)(nil)).Elem()
}

// A boxed array of `HostConnectSpec`. To be used in `Any` placeholders.
type ArrayOfHostConnectSpec struct {
	HostConnectSpec []HostConnectSpec `xml:"HostConnectSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostConnectSpec"] = reflect.TypeOf((*ArrayOfHostConnectSpec)(nil)).Elem()
}

// A boxed array of `HostCpuIdInfo`. To be used in `Any` placeholders.
type ArrayOfHostCpuIdInfo struct {
	HostCpuIdInfo []HostCpuIdInfo `xml:"HostCpuIdInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostCpuIdInfo"] = reflect.TypeOf((*ArrayOfHostCpuIdInfo)(nil)).Elem()
}

// A boxed array of `HostCpuPackage`. To be used in `Any` placeholders.
type ArrayOfHostCpuPackage struct {
	HostCpuPackage []HostCpuPackage `xml:"HostCpuPackage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostCpuPackage"] = reflect.TypeOf((*ArrayOfHostCpuPackage)(nil)).Elem()
}

// A boxed array of `HostDatastoreBrowserSearchResults`. To be used in `Any` placeholders.
type ArrayOfHostDatastoreBrowserSearchResults struct {
	HostDatastoreBrowserSearchResults []HostDatastoreBrowserSearchResults `xml:"HostDatastoreBrowserSearchResults,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDatastoreBrowserSearchResults"] = reflect.TypeOf((*ArrayOfHostDatastoreBrowserSearchResults)(nil)).Elem()
}

// A boxed array of `HostDatastoreConnectInfo`. To be used in `Any` placeholders.
type ArrayOfHostDatastoreConnectInfo struct {
	HostDatastoreConnectInfo []BaseHostDatastoreConnectInfo `xml:"HostDatastoreConnectInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostDatastoreConnectInfo"] = reflect.TypeOf((*ArrayOfHostDatastoreConnectInfo)(nil)).Elem()
}

// A boxed array of `HostDatastoreSystemDatastoreResult`. To be used in `Any` placeholders.
type ArrayOfHostDatastoreSystemDatastoreResult struct {
	HostDatastoreSystemDatastoreResult []HostDatastoreSystemDatastoreResult `xml:"HostDatastoreSystemDatastoreResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDatastoreSystemDatastoreResult"] = reflect.TypeOf((*ArrayOfHostDatastoreSystemDatastoreResult)(nil)).Elem()
}

// A boxed array of `HostDateTimeSystemTimeZone`. To be used in `Any` placeholders.
type ArrayOfHostDateTimeSystemTimeZone struct {
	HostDateTimeSystemTimeZone []HostDateTimeSystemTimeZone `xml:"HostDateTimeSystemTimeZone,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDateTimeSystemTimeZone"] = reflect.TypeOf((*ArrayOfHostDateTimeSystemTimeZone)(nil)).Elem()
}

// A boxed array of `HostDhcpService`. To be used in `Any` placeholders.
type ArrayOfHostDhcpService struct {
	HostDhcpService []HostDhcpService `xml:"HostDhcpService,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDhcpService"] = reflect.TypeOf((*ArrayOfHostDhcpService)(nil)).Elem()
}

// A boxed array of `HostDhcpServiceConfig`. To be used in `Any` placeholders.
type ArrayOfHostDhcpServiceConfig struct {
	HostDhcpServiceConfig []HostDhcpServiceConfig `xml:"HostDhcpServiceConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDhcpServiceConfig"] = reflect.TypeOf((*ArrayOfHostDhcpServiceConfig)(nil)).Elem()
}

// A boxed array of `HostDiagnosticPartition`. To be used in `Any` placeholders.
type ArrayOfHostDiagnosticPartition struct {
	HostDiagnosticPartition []HostDiagnosticPartition `xml:"HostDiagnosticPartition,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiagnosticPartition"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartition)(nil)).Elem()
}

// A boxed array of `HostDiagnosticPartitionCreateOption`. To be used in `Any` placeholders.
type ArrayOfHostDiagnosticPartitionCreateOption struct {
	HostDiagnosticPartitionCreateOption []HostDiagnosticPartitionCreateOption `xml:"HostDiagnosticPartitionCreateOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiagnosticPartitionCreateOption"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartitionCreateOption)(nil)).Elem()
}

// A boxed array of `HostDiskConfigurationResult`. To be used in `Any` placeholders.
type ArrayOfHostDiskConfigurationResult struct {
	HostDiskConfigurationResult []HostDiskConfigurationResult `xml:"HostDiskConfigurationResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiskConfigurationResult"] = reflect.TypeOf((*ArrayOfHostDiskConfigurationResult)(nil)).Elem()
}

// A boxed array of `HostDiskMappingPartitionOption`. To be used in `Any` placeholders.
type ArrayOfHostDiskMappingPartitionOption struct {
	HostDiskMappingPartitionOption []HostDiskMappingPartitionOption `xml:"HostDiskMappingPartitionOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiskMappingPartitionOption"] = reflect.TypeOf((*ArrayOfHostDiskMappingPartitionOption)(nil)).Elem()
}

// A boxed array of `HostDiskPartitionAttributes`. To be used in `Any` placeholders.
type ArrayOfHostDiskPartitionAttributes struct {
	HostDiskPartitionAttributes []HostDiskPartitionAttributes `xml:"HostDiskPartitionAttributes,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiskPartitionAttributes"] = reflect.TypeOf((*ArrayOfHostDiskPartitionAttributes)(nil)).Elem()
}

// A boxed array of `HostDiskPartitionBlockRange`. To be used in `Any` placeholders.
type ArrayOfHostDiskPartitionBlockRange struct {
	HostDiskPartitionBlockRange []HostDiskPartitionBlockRange `xml:"HostDiskPartitionBlockRange,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiskPartitionBlockRange"] = reflect.TypeOf((*ArrayOfHostDiskPartitionBlockRange)(nil)).Elem()
}

// A boxed array of `HostDiskPartitionInfo`. To be used in `Any` placeholders.
type ArrayOfHostDiskPartitionInfo struct {
	HostDiskPartitionInfo []HostDiskPartitionInfo `xml:"HostDiskPartitionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDiskPartitionInfo"] = reflect.TypeOf((*ArrayOfHostDiskPartitionInfo)(nil)).Elem()
}

// A boxed array of `HostDvxClass`. To be used in `Any` placeholders.
type ArrayOfHostDvxClass struct {
	HostDvxClass []HostDvxClass `xml:"HostDvxClass,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostDvxClass"] = reflect.TypeOf((*ArrayOfHostDvxClass)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostDvxClass"] = "8.0.0.1"
}

// A boxed array of `HostEventArgument`. To be used in `Any` placeholders.
type ArrayOfHostEventArgument struct {
	HostEventArgument []HostEventArgument `xml:"HostEventArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostEventArgument"] = reflect.TypeOf((*ArrayOfHostEventArgument)(nil)).Elem()
}

// A boxed array of `HostFeatureCapability`. To be used in `Any` placeholders.
type ArrayOfHostFeatureCapability struct {
	HostFeatureCapability []HostFeatureCapability `xml:"HostFeatureCapability,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFeatureCapability"] = reflect.TypeOf((*ArrayOfHostFeatureCapability)(nil)).Elem()
}

// A boxed array of `HostFeatureMask`. To be used in `Any` placeholders.
type ArrayOfHostFeatureMask struct {
	HostFeatureMask []HostFeatureMask `xml:"HostFeatureMask,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFeatureMask"] = reflect.TypeOf((*ArrayOfHostFeatureMask)(nil)).Elem()
}

// A boxed array of `HostFeatureVersionInfo`. To be used in `Any` placeholders.
type ArrayOfHostFeatureVersionInfo struct {
	HostFeatureVersionInfo []HostFeatureVersionInfo `xml:"HostFeatureVersionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFeatureVersionInfo"] = reflect.TypeOf((*ArrayOfHostFeatureVersionInfo)(nil)).Elem()
}

// A boxed array of `HostFileSystemMountInfo`. To be used in `Any` placeholders.
type ArrayOfHostFileSystemMountInfo struct {
	HostFileSystemMountInfo []HostFileSystemMountInfo `xml:"HostFileSystemMountInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFileSystemMountInfo"] = reflect.TypeOf((*ArrayOfHostFileSystemMountInfo)(nil)).Elem()
}

// A boxed array of `HostFirewallConfigRuleSetConfig`. To be used in `Any` placeholders.
type ArrayOfHostFirewallConfigRuleSetConfig struct {
	HostFirewallConfigRuleSetConfig []HostFirewallConfigRuleSetConfig `xml:"HostFirewallConfigRuleSetConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFirewallConfigRuleSetConfig"] = reflect.TypeOf((*ArrayOfHostFirewallConfigRuleSetConfig)(nil)).Elem()
}

// A boxed array of `HostFirewallRule`. To be used in `Any` placeholders.
type ArrayOfHostFirewallRule struct {
	HostFirewallRule []HostFirewallRule `xml:"HostFirewallRule,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFirewallRule"] = reflect.TypeOf((*ArrayOfHostFirewallRule)(nil)).Elem()
}

// A boxed array of `HostFirewallRuleset`. To be used in `Any` placeholders.
type ArrayOfHostFirewallRuleset struct {
	HostFirewallRuleset []HostFirewallRuleset `xml:"HostFirewallRuleset,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFirewallRuleset"] = reflect.TypeOf((*ArrayOfHostFirewallRuleset)(nil)).Elem()
}

// A boxed array of `HostFirewallRulesetIpNetwork`. To be used in `Any` placeholders.
type ArrayOfHostFirewallRulesetIpNetwork struct {
	HostFirewallRulesetIpNetwork []HostFirewallRulesetIpNetwork `xml:"HostFirewallRulesetIpNetwork,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostFirewallRulesetIpNetwork"] = reflect.TypeOf((*ArrayOfHostFirewallRulesetIpNetwork)(nil)).Elem()
}

// A boxed array of `HostGraphicsConfigDeviceType`. To be used in `Any` placeholders.
type ArrayOfHostGraphicsConfigDeviceType struct {
	HostGraphicsConfigDeviceType []HostGraphicsConfigDeviceType `xml:"HostGraphicsConfigDeviceType,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostGraphicsConfigDeviceType"] = reflect.TypeOf((*ArrayOfHostGraphicsConfigDeviceType)(nil)).Elem()
}

// A boxed array of `HostGraphicsInfo`. To be used in `Any` placeholders.
type ArrayOfHostGraphicsInfo struct {
	HostGraphicsInfo []HostGraphicsInfo `xml:"HostGraphicsInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostGraphicsInfo"] = reflect.TypeOf((*ArrayOfHostGraphicsInfo)(nil)).Elem()
}

// A boxed array of `HostHardwareElementInfo`. To be used in `Any` placeholders.
type ArrayOfHostHardwareElementInfo struct {
	HostHardwareElementInfo []BaseHostHardwareElementInfo `xml:"HostHardwareElementInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostHardwareElementInfo"] = reflect.TypeOf((*ArrayOfHostHardwareElementInfo)(nil)).Elem()
}

// A boxed array of `HostHostBusAdapter`. To be used in `Any` placeholders.
type ArrayOfHostHostBusAdapter struct {
	HostHostBusAdapter []BaseHostHostBusAdapter `xml:"HostHostBusAdapter,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostHostBusAdapter"] = reflect.TypeOf((*ArrayOfHostHostBusAdapter)(nil)).Elem()
}

// A boxed array of `HostInternetScsiHbaIscsiIpv6Address`. To be used in `Any` placeholders.
type ArrayOfHostInternetScsiHbaIscsiIpv6Address struct {
	HostInternetScsiHbaIscsiIpv6Address []HostInternetScsiHbaIscsiIpv6Address `xml:"HostInternetScsiHbaIscsiIpv6Address,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaIscsiIpv6Address"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaIscsiIpv6Address)(nil)).Elem()
}

// A boxed array of `HostInternetScsiHbaParamValue`. To be used in `Any` placeholders.
type ArrayOfHostInternetScsiHbaParamValue struct {
	HostInternetScsiHbaParamValue []HostInternetScsiHbaParamValue `xml:"HostInternetScsiHbaParamValue,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaParamValue"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaParamValue)(nil)).Elem()
}

// A boxed array of `HostInternetScsiHbaSendTarget`. To be used in `Any` placeholders.
type ArrayOfHostInternetScsiHbaSendTarget struct {
	HostInternetScsiHbaSendTarget []HostInternetScsiHbaSendTarget `xml:"HostInternetScsiHbaSendTarget,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaSendTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaSendTarget)(nil)).Elem()
}

// A boxed array of `HostInternetScsiHbaStaticTarget`. To be used in `Any` placeholders.
type ArrayOfHostInternetScsiHbaStaticTarget struct {
	HostInternetScsiHbaStaticTarget []HostInternetScsiHbaStaticTarget `xml:"HostInternetScsiHbaStaticTarget,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaStaticTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaStaticTarget)(nil)).Elem()
}

// A boxed array of `HostIoFilterInfo`. To be used in `Any` placeholders.
type ArrayOfHostIoFilterInfo struct {
	HostIoFilterInfo []HostIoFilterInfo `xml:"HostIoFilterInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostIoFilterInfo"] = reflect.TypeOf((*ArrayOfHostIoFilterInfo)(nil)).Elem()
}

// A boxed array of `HostIpConfigIpV6Address`. To be used in `Any` placeholders.
type ArrayOfHostIpConfigIpV6Address struct {
	HostIpConfigIpV6Address []HostIpConfigIpV6Address `xml:"HostIpConfigIpV6Address,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostIpConfigIpV6Address"] = reflect.TypeOf((*ArrayOfHostIpConfigIpV6Address)(nil)).Elem()
}

// A boxed array of `HostIpRouteEntry`. To be used in `Any` placeholders.
type ArrayOfHostIpRouteEntry struct {
	HostIpRouteEntry []HostIpRouteEntry `xml:"HostIpRouteEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostIpRouteEntry"] = reflect.TypeOf((*ArrayOfHostIpRouteEntry)(nil)).Elem()
}

// A boxed array of `HostIpRouteOp`. To be used in `Any` placeholders.
type ArrayOfHostIpRouteOp struct {
	HostIpRouteOp []HostIpRouteOp `xml:"HostIpRouteOp,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostIpRouteOp"] = reflect.TypeOf((*ArrayOfHostIpRouteOp)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerDiskLayoutSpec`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec struct {
	HostLowLevelProvisioningManagerDiskLayoutSpec []HostLowLevelProvisioningManagerDiskLayoutSpec `xml:"HostLowLevelProvisioningManagerDiskLayoutSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerFileDeleteResult`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerFileDeleteResult struct {
	HostLowLevelProvisioningManagerFileDeleteResult []HostLowLevelProvisioningManagerFileDeleteResult `xml:"HostLowLevelProvisioningManagerFileDeleteResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileDeleteResult"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileDeleteResult)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerFileDeleteSpec`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec struct {
	HostLowLevelProvisioningManagerFileDeleteSpec []HostLowLevelProvisioningManagerFileDeleteSpec `xml:"HostLowLevelProvisioningManagerFileDeleteSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerFileReserveResult`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerFileReserveResult struct {
	HostLowLevelProvisioningManagerFileReserveResult []HostLowLevelProvisioningManagerFileReserveResult `xml:"HostLowLevelProvisioningManagerFileReserveResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileReserveResult"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileReserveResult)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerFileReserveSpec`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerFileReserveSpec struct {
	HostLowLevelProvisioningManagerFileReserveSpec []HostLowLevelProvisioningManagerFileReserveSpec `xml:"HostLowLevelProvisioningManagerFileReserveSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileReserveSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileReserveSpec)(nil)).Elem()
}

// A boxed array of `HostLowLevelProvisioningManagerSnapshotLayoutSpec`. To be used in `Any` placeholders.
type ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec struct {
	HostLowLevelProvisioningManagerSnapshotLayoutSpec []HostLowLevelProvisioningManagerSnapshotLayoutSpec `xml:"HostLowLevelProvisioningManagerSnapshotLayoutSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec)(nil)).Elem()
}

// A boxed array of `HostMemberHealthCheckResult`. To be used in `Any` placeholders.
type ArrayOfHostMemberHealthCheckResult struct {
	HostMemberHealthCheckResult []BaseHostMemberHealthCheckResult `xml:"HostMemberHealthCheckResult,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostMemberHealthCheckResult"] = reflect.TypeOf((*ArrayOfHostMemberHealthCheckResult)(nil)).Elem()
}

// A boxed array of `HostMemberRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfHostMemberRuntimeInfo struct {
	HostMemberRuntimeInfo []HostMemberRuntimeInfo `xml:"HostMemberRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostMemberRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostMemberRuntimeInfo)(nil)).Elem()
}

// A boxed array of `HostMemoryTierInfo`. To be used in `Any` placeholders.
type ArrayOfHostMemoryTierInfo struct {
	HostMemoryTierInfo []HostMemoryTierInfo `xml:"HostMemoryTierInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostMemoryTierInfo"] = reflect.TypeOf((*ArrayOfHostMemoryTierInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostMemoryTierInfo"] = "7.0.3.0"
}

// A boxed array of `HostMultipathInfoLogicalUnit`. To be used in `Any` placeholders.
type ArrayOfHostMultipathInfoLogicalUnit struct {
	HostMultipathInfoLogicalUnit []HostMultipathInfoLogicalUnit `xml:"HostMultipathInfoLogicalUnit,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostMultipathInfoLogicalUnit"] = reflect.TypeOf((*ArrayOfHostMultipathInfoLogicalUnit)(nil)).Elem()
}

// A boxed array of `HostMultipathInfoPath`. To be used in `Any` placeholders.
type ArrayOfHostMultipathInfoPath struct {
	HostMultipathInfoPath []HostMultipathInfoPath `xml:"HostMultipathInfoPath,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostMultipathInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathInfoPath)(nil)).Elem()
}

// A boxed array of `HostMultipathStateInfoPath`. To be used in `Any` placeholders.
type ArrayOfHostMultipathStateInfoPath struct {
	HostMultipathStateInfoPath []HostMultipathStateInfoPath `xml:"HostMultipathStateInfoPath,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostMultipathStateInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathStateInfoPath)(nil)).Elem()
}

// A boxed array of `HostNasVolumeConfig`. To be used in `Any` placeholders.
type ArrayOfHostNasVolumeConfig struct {
	HostNasVolumeConfig []HostNasVolumeConfig `xml:"HostNasVolumeConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNasVolumeConfig"] = reflect.TypeOf((*ArrayOfHostNasVolumeConfig)(nil)).Elem()
}

// A boxed array of `HostNatService`. To be used in `Any` placeholders.
type ArrayOfHostNatService struct {
	HostNatService []HostNatService `xml:"HostNatService,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNatService"] = reflect.TypeOf((*ArrayOfHostNatService)(nil)).Elem()
}

// A boxed array of `HostNatServiceConfig`. To be used in `Any` placeholders.
type ArrayOfHostNatServiceConfig struct {
	HostNatServiceConfig []HostNatServiceConfig `xml:"HostNatServiceConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNatServiceConfig"] = reflect.TypeOf((*ArrayOfHostNatServiceConfig)(nil)).Elem()
}

// A boxed array of `HostNatServicePortForwardSpec`. To be used in `Any` placeholders.
type ArrayOfHostNatServicePortForwardSpec struct {
	HostNatServicePortForwardSpec []HostNatServicePortForwardSpec `xml:"HostNatServicePortForwardSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNatServicePortForwardSpec"] = reflect.TypeOf((*ArrayOfHostNatServicePortForwardSpec)(nil)).Elem()
}

// A boxed array of `HostNetStackInstance`. To be used in `Any` placeholders.
type ArrayOfHostNetStackInstance struct {
	HostNetStackInstance []HostNetStackInstance `xml:"HostNetStackInstance,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNetStackInstance"] = reflect.TypeOf((*ArrayOfHostNetStackInstance)(nil)).Elem()
}

// A boxed array of `HostNetworkConfigNetStackSpec`. To be used in `Any` placeholders.
type ArrayOfHostNetworkConfigNetStackSpec struct {
	HostNetworkConfigNetStackSpec []HostNetworkConfigNetStackSpec `xml:"HostNetworkConfigNetStackSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNetworkConfigNetStackSpec"] = reflect.TypeOf((*ArrayOfHostNetworkConfigNetStackSpec)(nil)).Elem()
}

// A boxed array of `HostNumaNode`. To be used in `Any` placeholders.
type ArrayOfHostNumaNode struct {
	HostNumaNode []HostNumaNode `xml:"HostNumaNode,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNumaNode"] = reflect.TypeOf((*ArrayOfHostNumaNode)(nil)).Elem()
}

// A boxed array of `HostNumericSensorInfo`. To be used in `Any` placeholders.
type ArrayOfHostNumericSensorInfo struct {
	HostNumericSensorInfo []HostNumericSensorInfo `xml:"HostNumericSensorInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNumericSensorInfo"] = reflect.TypeOf((*ArrayOfHostNumericSensorInfo)(nil)).Elem()
}

// A boxed array of `HostNvmeConnectSpec`. To be used in `Any` placeholders.
type ArrayOfHostNvmeConnectSpec struct {
	HostNvmeConnectSpec []HostNvmeConnectSpec `xml:"HostNvmeConnectSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeConnectSpec"] = reflect.TypeOf((*ArrayOfHostNvmeConnectSpec)(nil)).Elem()
}

// A boxed array of `HostNvmeController`. To be used in `Any` placeholders.
type ArrayOfHostNvmeController struct {
	HostNvmeController []HostNvmeController `xml:"HostNvmeController,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeController"] = reflect.TypeOf((*ArrayOfHostNvmeController)(nil)).Elem()
}

// A boxed array of `HostNvmeDisconnectSpec`. To be used in `Any` placeholders.
type ArrayOfHostNvmeDisconnectSpec struct {
	HostNvmeDisconnectSpec []HostNvmeDisconnectSpec `xml:"HostNvmeDisconnectSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeDisconnectSpec"] = reflect.TypeOf((*ArrayOfHostNvmeDisconnectSpec)(nil)).Elem()
}

// A boxed array of `HostNvmeDiscoveryLogEntry`. To be used in `Any` placeholders.
type ArrayOfHostNvmeDiscoveryLogEntry struct {
	HostNvmeDiscoveryLogEntry []HostNvmeDiscoveryLogEntry `xml:"HostNvmeDiscoveryLogEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeDiscoveryLogEntry"] = reflect.TypeOf((*ArrayOfHostNvmeDiscoveryLogEntry)(nil)).Elem()
}

// A boxed array of `HostNvmeNamespace`. To be used in `Any` placeholders.
type ArrayOfHostNvmeNamespace struct {
	HostNvmeNamespace []HostNvmeNamespace `xml:"HostNvmeNamespace,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeNamespace"] = reflect.TypeOf((*ArrayOfHostNvmeNamespace)(nil)).Elem()
}

// A boxed array of `HostNvmeTopologyInterface`. To be used in `Any` placeholders.
type ArrayOfHostNvmeTopologyInterface struct {
	HostNvmeTopologyInterface []HostNvmeTopologyInterface `xml:"HostNvmeTopologyInterface,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostNvmeTopologyInterface"] = reflect.TypeOf((*ArrayOfHostNvmeTopologyInterface)(nil)).Elem()
}

// A boxed array of `HostOpaqueNetworkInfo`. To be used in `Any` placeholders.
type ArrayOfHostOpaqueNetworkInfo struct {
	HostOpaqueNetworkInfo []HostOpaqueNetworkInfo `xml:"HostOpaqueNetworkInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostOpaqueNetworkInfo"] = reflect.TypeOf((*ArrayOfHostOpaqueNetworkInfo)(nil)).Elem()
}

// A boxed array of `HostOpaqueSwitch`. To be used in `Any` placeholders.
type ArrayOfHostOpaqueSwitch struct {
	HostOpaqueSwitch []HostOpaqueSwitch `xml:"HostOpaqueSwitch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostOpaqueSwitch"] = reflect.TypeOf((*ArrayOfHostOpaqueSwitch)(nil)).Elem()
}

// A boxed array of `HostOpaqueSwitchPhysicalNicZone`. To be used in `Any` placeholders.
type ArrayOfHostOpaqueSwitchPhysicalNicZone struct {
	HostOpaqueSwitchPhysicalNicZone []HostOpaqueSwitchPhysicalNicZone `xml:"HostOpaqueSwitchPhysicalNicZone,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostOpaqueSwitchPhysicalNicZone"] = reflect.TypeOf((*ArrayOfHostOpaqueSwitchPhysicalNicZone)(nil)).Elem()
}

// A boxed array of `HostPartialMaintenanceModeRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfHostPartialMaintenanceModeRuntimeInfo struct {
	HostPartialMaintenanceModeRuntimeInfo []HostPartialMaintenanceModeRuntimeInfo `xml:"HostPartialMaintenanceModeRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPartialMaintenanceModeRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostPartialMaintenanceModeRuntimeInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostPartialMaintenanceModeRuntimeInfo"] = "8.0.3.0"
}

// A boxed array of `HostPatchManagerStatus`. To be used in `Any` placeholders.
type ArrayOfHostPatchManagerStatus struct {
	HostPatchManagerStatus []HostPatchManagerStatus `xml:"HostPatchManagerStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPatchManagerStatus"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatus)(nil)).Elem()
}

// A boxed array of `HostPatchManagerStatusPrerequisitePatch`. To be used in `Any` placeholders.
type ArrayOfHostPatchManagerStatusPrerequisitePatch struct {
	HostPatchManagerStatusPrerequisitePatch []HostPatchManagerStatusPrerequisitePatch `xml:"HostPatchManagerStatusPrerequisitePatch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPatchManagerStatusPrerequisitePatch"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatusPrerequisitePatch)(nil)).Elem()
}

// A boxed array of `HostPathSelectionPolicyOption`. To be used in `Any` placeholders.
type ArrayOfHostPathSelectionPolicyOption struct {
	HostPathSelectionPolicyOption []HostPathSelectionPolicyOption `xml:"HostPathSelectionPolicyOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPathSelectionPolicyOption"] = reflect.TypeOf((*ArrayOfHostPathSelectionPolicyOption)(nil)).Elem()
}

// A boxed array of `HostPciDevice`. To be used in `Any` placeholders.
type ArrayOfHostPciDevice struct {
	HostPciDevice []HostPciDevice `xml:"HostPciDevice,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPciDevice"] = reflect.TypeOf((*ArrayOfHostPciDevice)(nil)).Elem()
}

// A boxed array of `HostPciPassthruConfig`. To be used in `Any` placeholders.
type ArrayOfHostPciPassthruConfig struct {
	HostPciPassthruConfig []BaseHostPciPassthruConfig `xml:"HostPciPassthruConfig,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostPciPassthruConfig"] = reflect.TypeOf((*ArrayOfHostPciPassthruConfig)(nil)).Elem()
}

// A boxed array of `HostPciPassthruInfo`. To be used in `Any` placeholders.
type ArrayOfHostPciPassthruInfo struct {
	HostPciPassthruInfo []BaseHostPciPassthruInfo `xml:"HostPciPassthruInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostPciPassthruInfo"] = reflect.TypeOf((*ArrayOfHostPciPassthruInfo)(nil)).Elem()
}

// A boxed array of `HostPlacedVirtualNicIdentifier`. To be used in `Any` placeholders.
type ArrayOfHostPlacedVirtualNicIdentifier struct {
	HostPlacedVirtualNicIdentifier []HostPlacedVirtualNicIdentifier `xml:"HostPlacedVirtualNicIdentifier,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlacedVirtualNicIdentifier"] = reflect.TypeOf((*ArrayOfHostPlacedVirtualNicIdentifier)(nil)).Elem()
}

// A boxed array of `HostPlugStoreTopologyAdapter`. To be used in `Any` placeholders.
type ArrayOfHostPlugStoreTopologyAdapter struct {
	HostPlugStoreTopologyAdapter []HostPlugStoreTopologyAdapter `xml:"HostPlugStoreTopologyAdapter,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyAdapter"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyAdapter)(nil)).Elem()
}

// A boxed array of `HostPlugStoreTopologyDevice`. To be used in `Any` placeholders.
type ArrayOfHostPlugStoreTopologyDevice struct {
	HostPlugStoreTopologyDevice []HostPlugStoreTopologyDevice `xml:"HostPlugStoreTopologyDevice,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyDevice"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyDevice)(nil)).Elem()
}

// A boxed array of `HostPlugStoreTopologyPath`. To be used in `Any` placeholders.
type ArrayOfHostPlugStoreTopologyPath struct {
	HostPlugStoreTopologyPath []HostPlugStoreTopologyPath `xml:"HostPlugStoreTopologyPath,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPath"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPath)(nil)).Elem()
}

// A boxed array of `HostPlugStoreTopologyPlugin`. To be used in `Any` placeholders.
type ArrayOfHostPlugStoreTopologyPlugin struct {
	HostPlugStoreTopologyPlugin []HostPlugStoreTopologyPlugin `xml:"HostPlugStoreTopologyPlugin,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPlugin"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPlugin)(nil)).Elem()
}

// A boxed array of `HostPlugStoreTopologyTarget`. To be used in `Any` placeholders.
type ArrayOfHostPlugStoreTopologyTarget struct {
	HostPlugStoreTopologyTarget []HostPlugStoreTopologyTarget `xml:"HostPlugStoreTopologyTarget,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyTarget"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyTarget)(nil)).Elem()
}

// A boxed array of `HostPnicNetworkResourceInfo`. To be used in `Any` placeholders.
type ArrayOfHostPnicNetworkResourceInfo struct {
	HostPnicNetworkResourceInfo []HostPnicNetworkResourceInfo `xml:"HostPnicNetworkResourceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPnicNetworkResourceInfo"] = reflect.TypeOf((*ArrayOfHostPnicNetworkResourceInfo)(nil)).Elem()
}

// A boxed array of `HostPortGroup`. To be used in `Any` placeholders.
type ArrayOfHostPortGroup struct {
	HostPortGroup []HostPortGroup `xml:"HostPortGroup,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPortGroup"] = reflect.TypeOf((*ArrayOfHostPortGroup)(nil)).Elem()
}

// A boxed array of `HostPortGroupConfig`. To be used in `Any` placeholders.
type ArrayOfHostPortGroupConfig struct {
	HostPortGroupConfig []HostPortGroupConfig `xml:"HostPortGroupConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPortGroupConfig"] = reflect.TypeOf((*ArrayOfHostPortGroupConfig)(nil)).Elem()
}

// A boxed array of `HostPortGroupPort`. To be used in `Any` placeholders.
type ArrayOfHostPortGroupPort struct {
	HostPortGroupPort []HostPortGroupPort `xml:"HostPortGroupPort,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPortGroupPort"] = reflect.TypeOf((*ArrayOfHostPortGroupPort)(nil)).Elem()
}

// A boxed array of `HostPortGroupProfile`. To be used in `Any` placeholders.
type ArrayOfHostPortGroupProfile struct {
	HostPortGroupProfile []HostPortGroupProfile `xml:"HostPortGroupProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPortGroupProfile"] = reflect.TypeOf((*ArrayOfHostPortGroupProfile)(nil)).Elem()
}

// A boxed array of `HostPowerPolicy`. To be used in `Any` placeholders.
type ArrayOfHostPowerPolicy struct {
	HostPowerPolicy []HostPowerPolicy `xml:"HostPowerPolicy,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPowerPolicy"] = reflect.TypeOf((*ArrayOfHostPowerPolicy)(nil)).Elem()
}

// A boxed array of `HostProfileManagerCompositionResultResultElement`. To be used in `Any` placeholders.
type ArrayOfHostProfileManagerCompositionResultResultElement struct {
	HostProfileManagerCompositionResultResultElement []HostProfileManagerCompositionResultResultElement `xml:"HostProfileManagerCompositionResultResultElement,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProfileManagerCompositionResultResultElement"] = reflect.TypeOf((*ArrayOfHostProfileManagerCompositionResultResultElement)(nil)).Elem()
}

// A boxed array of `HostProfileManagerCompositionValidationResultResultElement`. To be used in `Any` placeholders.
type ArrayOfHostProfileManagerCompositionValidationResultResultElement struct {
	HostProfileManagerCompositionValidationResultResultElement []HostProfileManagerCompositionValidationResultResultElement `xml:"HostProfileManagerCompositionValidationResultResultElement,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProfileManagerCompositionValidationResultResultElement"] = reflect.TypeOf((*ArrayOfHostProfileManagerCompositionValidationResultResultElement)(nil)).Elem()
}

// A boxed array of `HostProfilesEntityCustomizations`. To be used in `Any` placeholders.
type ArrayOfHostProfilesEntityCustomizations struct {
	HostProfilesEntityCustomizations []BaseHostProfilesEntityCustomizations `xml:"HostProfilesEntityCustomizations,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostProfilesEntityCustomizations"] = reflect.TypeOf((*ArrayOfHostProfilesEntityCustomizations)(nil)).Elem()
}

// A boxed array of `HostProtocolEndpoint`. To be used in `Any` placeholders.
type ArrayOfHostProtocolEndpoint struct {
	HostProtocolEndpoint []HostProtocolEndpoint `xml:"HostProtocolEndpoint,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProtocolEndpoint"] = reflect.TypeOf((*ArrayOfHostProtocolEndpoint)(nil)).Elem()
}

// A boxed array of `HostProxySwitch`. To be used in `Any` placeholders.
type ArrayOfHostProxySwitch struct {
	HostProxySwitch []HostProxySwitch `xml:"HostProxySwitch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProxySwitch"] = reflect.TypeOf((*ArrayOfHostProxySwitch)(nil)).Elem()
}

// A boxed array of `HostProxySwitchConfig`. To be used in `Any` placeholders.
type ArrayOfHostProxySwitchConfig struct {
	HostProxySwitchConfig []HostProxySwitchConfig `xml:"HostProxySwitchConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProxySwitchConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchConfig)(nil)).Elem()
}

// A boxed array of `HostProxySwitchHostLagConfig`. To be used in `Any` placeholders.
type ArrayOfHostProxySwitchHostLagConfig struct {
	HostProxySwitchHostLagConfig []HostProxySwitchHostLagConfig `xml:"HostProxySwitchHostLagConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostProxySwitchHostLagConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchHostLagConfig)(nil)).Elem()
}

// A boxed array of `HostPtpConfigPtpPort`. To be used in `Any` placeholders.
type ArrayOfHostPtpConfigPtpPort struct {
	HostPtpConfigPtpPort []HostPtpConfigPtpPort `xml:"HostPtpConfigPtpPort,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostPtpConfigPtpPort"] = reflect.TypeOf((*ArrayOfHostPtpConfigPtpPort)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostPtpConfigPtpPort"] = "7.0.3.0"
}

// A boxed array of `HostQualifiedName`. To be used in `Any` placeholders.
type ArrayOfHostQualifiedName struct {
	HostQualifiedName []HostQualifiedName `xml:"HostQualifiedName,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostQualifiedName"] = reflect.TypeOf((*ArrayOfHostQualifiedName)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostQualifiedName"] = "7.0.3.0"
}

// A boxed array of `HostRdmaDevice`. To be used in `Any` placeholders.
type ArrayOfHostRdmaDevice struct {
	HostRdmaDevice []HostRdmaDevice `xml:"HostRdmaDevice,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostRdmaDevice"] = reflect.TypeOf((*ArrayOfHostRdmaDevice)(nil)).Elem()
}

// A boxed array of `HostRuntimeInfoNetStackInstanceRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo struct {
	HostRuntimeInfoNetStackInstanceRuntimeInfo []HostRuntimeInfoNetStackInstanceRuntimeInfo `xml:"HostRuntimeInfoNetStackInstanceRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo)(nil)).Elem()
}

// A boxed array of `HostScsiDisk`. To be used in `Any` placeholders.
type ArrayOfHostScsiDisk struct {
	HostScsiDisk []HostScsiDisk `xml:"HostScsiDisk,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostScsiDisk"] = reflect.TypeOf((*ArrayOfHostScsiDisk)(nil)).Elem()
}

// A boxed array of `HostScsiDiskPartition`. To be used in `Any` placeholders.
type ArrayOfHostScsiDiskPartition struct {
	HostScsiDiskPartition []HostScsiDiskPartition `xml:"HostScsiDiskPartition,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostScsiDiskPartition"] = reflect.TypeOf((*ArrayOfHostScsiDiskPartition)(nil)).Elem()
}

// A boxed array of `HostScsiTopologyInterface`. To be used in `Any` placeholders.
type ArrayOfHostScsiTopologyInterface struct {
	HostScsiTopologyInterface []HostScsiTopologyInterface `xml:"HostScsiTopologyInterface,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostScsiTopologyInterface"] = reflect.TypeOf((*ArrayOfHostScsiTopologyInterface)(nil)).Elem()
}

// A boxed array of `HostScsiTopologyLun`. To be used in `Any` placeholders.
type ArrayOfHostScsiTopologyLun struct {
	HostScsiTopologyLun []HostScsiTopologyLun `xml:"HostScsiTopologyLun,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostScsiTopologyLun"] = reflect.TypeOf((*ArrayOfHostScsiTopologyLun)(nil)).Elem()
}

// A boxed array of `HostScsiTopologyTarget`. To be used in `Any` placeholders.
type ArrayOfHostScsiTopologyTarget struct {
	HostScsiTopologyTarget []HostScsiTopologyTarget `xml:"HostScsiTopologyTarget,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostScsiTopologyTarget"] = reflect.TypeOf((*ArrayOfHostScsiTopologyTarget)(nil)).Elem()
}

// A boxed array of `HostService`. To be used in `Any` placeholders.
type ArrayOfHostService struct {
	HostService []HostService `xml:"HostService,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostService"] = reflect.TypeOf((*ArrayOfHostService)(nil)).Elem()
}

// A boxed array of `HostServiceConfig`. To be used in `Any` placeholders.
type ArrayOfHostServiceConfig struct {
	HostServiceConfig []HostServiceConfig `xml:"HostServiceConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostServiceConfig"] = reflect.TypeOf((*ArrayOfHostServiceConfig)(nil)).Elem()
}

// A boxed array of `HostSharedGpuCapabilities`. To be used in `Any` placeholders.
type ArrayOfHostSharedGpuCapabilities struct {
	HostSharedGpuCapabilities []HostSharedGpuCapabilities `xml:"HostSharedGpuCapabilities,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSharedGpuCapabilities"] = reflect.TypeOf((*ArrayOfHostSharedGpuCapabilities)(nil)).Elem()
}

// A boxed array of `HostSnmpDestination`. To be used in `Any` placeholders.
type ArrayOfHostSnmpDestination struct {
	HostSnmpDestination []HostSnmpDestination `xml:"HostSnmpDestination,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSnmpDestination"] = reflect.TypeOf((*ArrayOfHostSnmpDestination)(nil)).Elem()
}

// A boxed array of `HostSriovDevicePoolInfo`. To be used in `Any` placeholders.
type ArrayOfHostSriovDevicePoolInfo struct {
	HostSriovDevicePoolInfo []BaseHostSriovDevicePoolInfo `xml:"HostSriovDevicePoolInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostSriovDevicePoolInfo"] = reflect.TypeOf((*ArrayOfHostSriovDevicePoolInfo)(nil)).Elem()
}

// A boxed array of `HostSslThumbprintInfo`. To be used in `Any` placeholders.
type ArrayOfHostSslThumbprintInfo struct {
	HostSslThumbprintInfo []HostSslThumbprintInfo `xml:"HostSslThumbprintInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSslThumbprintInfo"] = reflect.TypeOf((*ArrayOfHostSslThumbprintInfo)(nil)).Elem()
}

// A boxed array of `HostStorageArrayTypePolicyOption`. To be used in `Any` placeholders.
type ArrayOfHostStorageArrayTypePolicyOption struct {
	HostStorageArrayTypePolicyOption []HostStorageArrayTypePolicyOption `xml:"HostStorageArrayTypePolicyOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageArrayTypePolicyOption"] = reflect.TypeOf((*ArrayOfHostStorageArrayTypePolicyOption)(nil)).Elem()
}

// A boxed array of `HostStorageElementInfo`. To be used in `Any` placeholders.
type ArrayOfHostStorageElementInfo struct {
	HostStorageElementInfo []HostStorageElementInfo `xml:"HostStorageElementInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageElementInfo"] = reflect.TypeOf((*ArrayOfHostStorageElementInfo)(nil)).Elem()
}

// A boxed array of `HostStorageOperationalInfo`. To be used in `Any` placeholders.
type ArrayOfHostStorageOperationalInfo struct {
	HostStorageOperationalInfo []HostStorageOperationalInfo `xml:"HostStorageOperationalInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageOperationalInfo"] = reflect.TypeOf((*ArrayOfHostStorageOperationalInfo)(nil)).Elem()
}

// A boxed array of `HostStorageSystemDiskLocatorLedResult`. To be used in `Any` placeholders.
type ArrayOfHostStorageSystemDiskLocatorLedResult struct {
	HostStorageSystemDiskLocatorLedResult []HostStorageSystemDiskLocatorLedResult `xml:"HostStorageSystemDiskLocatorLedResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageSystemDiskLocatorLedResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemDiskLocatorLedResult)(nil)).Elem()
}

// A boxed array of `HostStorageSystemScsiLunResult`. To be used in `Any` placeholders.
type ArrayOfHostStorageSystemScsiLunResult struct {
	HostStorageSystemScsiLunResult []HostStorageSystemScsiLunResult `xml:"HostStorageSystemScsiLunResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageSystemScsiLunResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemScsiLunResult)(nil)).Elem()
}

// A boxed array of `HostStorageSystemVmfsVolumeResult`. To be used in `Any` placeholders.
type ArrayOfHostStorageSystemVmfsVolumeResult struct {
	HostStorageSystemVmfsVolumeResult []HostStorageSystemVmfsVolumeResult `xml:"HostStorageSystemVmfsVolumeResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostStorageSystemVmfsVolumeResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemVmfsVolumeResult)(nil)).Elem()
}

// A boxed array of `HostSubSpecification`. To be used in `Any` placeholders.
type ArrayOfHostSubSpecification struct {
	HostSubSpecification []HostSubSpecification `xml:"HostSubSpecification,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSubSpecification"] = reflect.TypeOf((*ArrayOfHostSubSpecification)(nil)).Elem()
}

// A boxed array of `HostSystemIdentificationInfo`. To be used in `Any` placeholders.
type ArrayOfHostSystemIdentificationInfo struct {
	HostSystemIdentificationInfo []HostSystemIdentificationInfo `xml:"HostSystemIdentificationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSystemIdentificationInfo"] = reflect.TypeOf((*ArrayOfHostSystemIdentificationInfo)(nil)).Elem()
}

// A boxed array of `HostSystemResourceInfo`. To be used in `Any` placeholders.
type ArrayOfHostSystemResourceInfo struct {
	HostSystemResourceInfo []HostSystemResourceInfo `xml:"HostSystemResourceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostSystemResourceInfo"] = reflect.TypeOf((*ArrayOfHostSystemResourceInfo)(nil)).Elem()
}

// A boxed array of `HostSystemSwapConfigurationSystemSwapOption`. To be used in `Any` placeholders.
type ArrayOfHostSystemSwapConfigurationSystemSwapOption struct {
	HostSystemSwapConfigurationSystemSwapOption []BaseHostSystemSwapConfigurationSystemSwapOption `xml:"HostSystemSwapConfigurationSystemSwapOption,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfHostSystemSwapConfigurationSystemSwapOption"] = reflect.TypeOf((*ArrayOfHostSystemSwapConfigurationSystemSwapOption)(nil)).Elem()
}

// A boxed array of `HostTpmDigestInfo`. To be used in `Any` placeholders.
type ArrayOfHostTpmDigestInfo struct {
	HostTpmDigestInfo []HostTpmDigestInfo `xml:"HostTpmDigestInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostTpmDigestInfo"] = reflect.TypeOf((*ArrayOfHostTpmDigestInfo)(nil)).Elem()
}

// A boxed array of `HostTpmEventLogEntry`. To be used in `Any` placeholders.
type ArrayOfHostTpmEventLogEntry struct {
	HostTpmEventLogEntry []HostTpmEventLogEntry `xml:"HostTpmEventLogEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostTpmEventLogEntry"] = reflect.TypeOf((*ArrayOfHostTpmEventLogEntry)(nil)).Elem()
}

// A boxed array of `HostTrustAuthorityAttestationInfo`. To be used in `Any` placeholders.
type ArrayOfHostTrustAuthorityAttestationInfo struct {
	HostTrustAuthorityAttestationInfo []HostTrustAuthorityAttestationInfo `xml:"HostTrustAuthorityAttestationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostTrustAuthorityAttestationInfo"] = reflect.TypeOf((*ArrayOfHostTrustAuthorityAttestationInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostTrustAuthorityAttestationInfo"] = "7.0.1.0"
}

// A boxed array of `HostUnresolvedVmfsExtent`. To be used in `Any` placeholders.
type ArrayOfHostUnresolvedVmfsExtent struct {
	HostUnresolvedVmfsExtent []HostUnresolvedVmfsExtent `xml:"HostUnresolvedVmfsExtent,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsExtent"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsExtent)(nil)).Elem()
}

// A boxed array of `HostUnresolvedVmfsResolutionResult`. To be used in `Any` placeholders.
type ArrayOfHostUnresolvedVmfsResolutionResult struct {
	HostUnresolvedVmfsResolutionResult []HostUnresolvedVmfsResolutionResult `xml:"HostUnresolvedVmfsResolutionResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionResult"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionResult)(nil)).Elem()
}

// A boxed array of `HostUnresolvedVmfsResolutionSpec`. To be used in `Any` placeholders.
type ArrayOfHostUnresolvedVmfsResolutionSpec struct {
	HostUnresolvedVmfsResolutionSpec []HostUnresolvedVmfsResolutionSpec `xml:"HostUnresolvedVmfsResolutionSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionSpec"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionSpec)(nil)).Elem()
}

// A boxed array of `HostUnresolvedVmfsVolume`. To be used in `Any` placeholders.
type ArrayOfHostUnresolvedVmfsVolume struct {
	HostUnresolvedVmfsVolume []HostUnresolvedVmfsVolume `xml:"HostUnresolvedVmfsVolume,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsVolume"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsVolume)(nil)).Elem()
}

// A boxed array of `HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption`. To be used in `Any` placeholders.
type ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption struct {
	HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption []HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption `xml:"HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption"] = reflect.TypeOf((*ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption)(nil)).Elem()
}

// A boxed array of `HostVMotionCompatibility`. To be used in `Any` placeholders.
type ArrayOfHostVMotionCompatibility struct {
	HostVMotionCompatibility []HostVMotionCompatibility `xml:"HostVMotionCompatibility,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVMotionCompatibility"] = reflect.TypeOf((*ArrayOfHostVMotionCompatibility)(nil)).Elem()
}

// A boxed array of `HostVirtualNic`. To be used in `Any` placeholders.
type ArrayOfHostVirtualNic struct {
	HostVirtualNic []HostVirtualNic `xml:"HostVirtualNic,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVirtualNic"] = reflect.TypeOf((*ArrayOfHostVirtualNic)(nil)).Elem()
}

// A boxed array of `HostVirtualNicConfig`. To be used in `Any` placeholders.
type ArrayOfHostVirtualNicConfig struct {
	HostVirtualNicConfig []HostVirtualNicConfig `xml:"HostVirtualNicConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVirtualNicConfig"] = reflect.TypeOf((*ArrayOfHostVirtualNicConfig)(nil)).Elem()
}

// A boxed array of `HostVirtualNicManagerNicTypeSelection`. To be used in `Any` placeholders.
type ArrayOfHostVirtualNicManagerNicTypeSelection struct {
	HostVirtualNicManagerNicTypeSelection []HostVirtualNicManagerNicTypeSelection `xml:"HostVirtualNicManagerNicTypeSelection,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVirtualNicManagerNicTypeSelection"] = reflect.TypeOf((*ArrayOfHostVirtualNicManagerNicTypeSelection)(nil)).Elem()
}

// A boxed array of `HostVirtualSwitch`. To be used in `Any` placeholders.
type ArrayOfHostVirtualSwitch struct {
	HostVirtualSwitch []HostVirtualSwitch `xml:"HostVirtualSwitch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVirtualSwitch"] = reflect.TypeOf((*ArrayOfHostVirtualSwitch)(nil)).Elem()
}

// A boxed array of `HostVirtualSwitchConfig`. To be used in `Any` placeholders.
type ArrayOfHostVirtualSwitchConfig struct {
	HostVirtualSwitchConfig []HostVirtualSwitchConfig `xml:"HostVirtualSwitchConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVirtualSwitchConfig"] = reflect.TypeOf((*ArrayOfHostVirtualSwitchConfig)(nil)).Elem()
}

// A boxed array of `HostVmciAccessManagerAccessSpec`. To be used in `Any` placeholders.
type ArrayOfHostVmciAccessManagerAccessSpec struct {
	HostVmciAccessManagerAccessSpec []HostVmciAccessManagerAccessSpec `xml:"HostVmciAccessManagerAccessSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVmciAccessManagerAccessSpec"] = reflect.TypeOf((*ArrayOfHostVmciAccessManagerAccessSpec)(nil)).Elem()
}

// A boxed array of `HostVmfsRescanResult`. To be used in `Any` placeholders.
type ArrayOfHostVmfsRescanResult struct {
	HostVmfsRescanResult []HostVmfsRescanResult `xml:"HostVmfsRescanResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVmfsRescanResult"] = reflect.TypeOf((*ArrayOfHostVmfsRescanResult)(nil)).Elem()
}

// A boxed array of `HostVsanInternalSystemCmmdsQuery`. To be used in `Any` placeholders.
type ArrayOfHostVsanInternalSystemCmmdsQuery struct {
	HostVsanInternalSystemCmmdsQuery []HostVsanInternalSystemCmmdsQuery `xml:"HostVsanInternalSystemCmmdsQuery,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemCmmdsQuery"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemCmmdsQuery)(nil)).Elem()
}

// A boxed array of `HostVsanInternalSystemDeleteVsanObjectsResult`. To be used in `Any` placeholders.
type ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult struct {
	HostVsanInternalSystemDeleteVsanObjectsResult []HostVsanInternalSystemDeleteVsanObjectsResult `xml:"HostVsanInternalSystemDeleteVsanObjectsResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult)(nil)).Elem()
}

// A boxed array of `HostVsanInternalSystemVsanObjectOperationResult`. To be used in `Any` placeholders.
type ArrayOfHostVsanInternalSystemVsanObjectOperationResult struct {
	HostVsanInternalSystemVsanObjectOperationResult []HostVsanInternalSystemVsanObjectOperationResult `xml:"HostVsanInternalSystemVsanObjectOperationResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemVsanObjectOperationResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemVsanObjectOperationResult)(nil)).Elem()
}

// A boxed array of `HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult`. To be used in `Any` placeholders.
type ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult struct {
	HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult []HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult `xml:"HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult)(nil)).Elem()
}

// A boxed array of `HostVvolNQN`. To be used in `Any` placeholders.
type ArrayOfHostVvolNQN struct {
	HostVvolNQN []HostVvolNQN `xml:"HostVvolNQN,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVvolNQN"] = reflect.TypeOf((*ArrayOfHostVvolNQN)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostVvolNQN"] = "8.0.2.0"
}

// A boxed array of `HostVvolVolumeHostVvolNQN`. To be used in `Any` placeholders.
type ArrayOfHostVvolVolumeHostVvolNQN struct {
	HostVvolVolumeHostVvolNQN []HostVvolVolumeHostVvolNQN `xml:"HostVvolVolumeHostVvolNQN,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHostVvolVolumeHostVvolNQN"] = reflect.TypeOf((*ArrayOfHostVvolVolumeHostVvolNQN)(nil)).Elem()
	minAPIVersionForType["ArrayOfHostVvolVolumeHostVvolNQN"] = "8.0.2.0"
}

// A boxed array of `HttpNfcLeaseDatastoreLeaseInfo`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseDatastoreLeaseInfo struct {
	HttpNfcLeaseDatastoreLeaseInfo []HttpNfcLeaseDatastoreLeaseInfo `xml:"HttpNfcLeaseDatastoreLeaseInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDatastoreLeaseInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDatastoreLeaseInfo)(nil)).Elem()
}

// A boxed array of `HttpNfcLeaseDeviceUrl`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseDeviceUrl struct {
	HttpNfcLeaseDeviceUrl []HttpNfcLeaseDeviceUrl `xml:"HttpNfcLeaseDeviceUrl,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDeviceUrl"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDeviceUrl)(nil)).Elem()
}

// A boxed array of `HttpNfcLeaseHostInfo`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseHostInfo struct {
	HttpNfcLeaseHostInfo []HttpNfcLeaseHostInfo `xml:"HttpNfcLeaseHostInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseHostInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseHostInfo)(nil)).Elem()
}

// A boxed array of `HttpNfcLeaseManifestEntry`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseManifestEntry struct {
	HttpNfcLeaseManifestEntry []HttpNfcLeaseManifestEntry `xml:"HttpNfcLeaseManifestEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseManifestEntry"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseManifestEntry)(nil)).Elem()
}

// A boxed array of `HttpNfcLeaseProbeResult`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseProbeResult struct {
	HttpNfcLeaseProbeResult []HttpNfcLeaseProbeResult `xml:"HttpNfcLeaseProbeResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseProbeResult"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseProbeResult)(nil)).Elem()
	minAPIVersionForType["ArrayOfHttpNfcLeaseProbeResult"] = "7.0.2.0"
}

// A boxed array of `HttpNfcLeaseSourceFile`. To be used in `Any` placeholders.
type ArrayOfHttpNfcLeaseSourceFile struct {
	HttpNfcLeaseSourceFile []HttpNfcLeaseSourceFile `xml:"HttpNfcLeaseSourceFile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfHttpNfcLeaseSourceFile"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseSourceFile)(nil)).Elem()
}

// A boxed array of `ID`. To be used in `Any` placeholders.
type ArrayOfID struct {
	ID []ID `xml:"ID,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfID"] = reflect.TypeOf((*ArrayOfID)(nil)).Elem()
}

// A boxed array of `ImportOperationBulkFaultFaultOnImport`. To be used in `Any` placeholders.
type ArrayOfImportOperationBulkFaultFaultOnImport struct {
	ImportOperationBulkFaultFaultOnImport []ImportOperationBulkFaultFaultOnImport `xml:"ImportOperationBulkFaultFaultOnImport,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfImportOperationBulkFaultFaultOnImport"] = reflect.TypeOf((*ArrayOfImportOperationBulkFaultFaultOnImport)(nil)).Elem()
}

// A boxed array of `ImportSpec`. To be used in `Any` placeholders.
type ArrayOfImportSpec struct {
	ImportSpec []BaseImportSpec `xml:"ImportSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfImportSpec"] = reflect.TypeOf((*ArrayOfImportSpec)(nil)).Elem()
}

// A boxed array of `PrimitiveInt`. To be used in `Any` placeholders.
type ArrayOfInt struct {
	Int []int32 `xml:"int,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfInt"] = reflect.TypeOf((*ArrayOfInt)(nil)).Elem()
}

// A boxed array of `IoFilterHostIssue`. To be used in `Any` placeholders.
type ArrayOfIoFilterHostIssue struct {
	IoFilterHostIssue []IoFilterHostIssue `xml:"IoFilterHostIssue,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIoFilterHostIssue"] = reflect.TypeOf((*ArrayOfIoFilterHostIssue)(nil)).Elem()
}

// A boxed array of `IpPool`. To be used in `Any` placeholders.
type ArrayOfIpPool struct {
	IpPool []IpPool `xml:"IpPool,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIpPool"] = reflect.TypeOf((*ArrayOfIpPool)(nil)).Elem()
}

// A boxed array of `IpPoolAssociation`. To be used in `Any` placeholders.
type ArrayOfIpPoolAssociation struct {
	IpPoolAssociation []IpPoolAssociation `xml:"IpPoolAssociation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIpPoolAssociation"] = reflect.TypeOf((*ArrayOfIpPoolAssociation)(nil)).Elem()
}

// A boxed array of `IpPoolManagerIpAllocation`. To be used in `Any` placeholders.
type ArrayOfIpPoolManagerIpAllocation struct {
	IpPoolManagerIpAllocation []IpPoolManagerIpAllocation `xml:"IpPoolManagerIpAllocation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIpPoolManagerIpAllocation"] = reflect.TypeOf((*ArrayOfIpPoolManagerIpAllocation)(nil)).Elem()
}

// A boxed array of `IscsiDependencyEntity`. To be used in `Any` placeholders.
type ArrayOfIscsiDependencyEntity struct {
	IscsiDependencyEntity []IscsiDependencyEntity `xml:"IscsiDependencyEntity,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIscsiDependencyEntity"] = reflect.TypeOf((*ArrayOfIscsiDependencyEntity)(nil)).Elem()
}

// A boxed array of `IscsiPortInfo`. To be used in `Any` placeholders.
type ArrayOfIscsiPortInfo struct {
	IscsiPortInfo []IscsiPortInfo `xml:"IscsiPortInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfIscsiPortInfo"] = reflect.TypeOf((*ArrayOfIscsiPortInfo)(nil)).Elem()
}

// A boxed array of `KernelModuleInfo`. To be used in `Any` placeholders.
type ArrayOfKernelModuleInfo struct {
	KernelModuleInfo []KernelModuleInfo `xml:"KernelModuleInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfKernelModuleInfo"] = reflect.TypeOf((*ArrayOfKernelModuleInfo)(nil)).Elem()
}

// A boxed array of `KeyAnyValue`. To be used in `Any` placeholders.
type ArrayOfKeyAnyValue struct {
	KeyAnyValue []KeyAnyValue `xml:"KeyAnyValue,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfKeyAnyValue"] = reflect.TypeOf((*ArrayOfKeyAnyValue)(nil)).Elem()
}

// A boxed array of `KeyValue`. To be used in `Any` placeholders.
type ArrayOfKeyValue struct {
	KeyValue []KeyValue `xml:"KeyValue,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfKeyValue"] = reflect.TypeOf((*ArrayOfKeyValue)(nil)).Elem()
}

// A boxed array of `KmipClusterInfo`. To be used in `Any` placeholders.
type ArrayOfKmipClusterInfo struct {
	KmipClusterInfo []KmipClusterInfo `xml:"KmipClusterInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfKmipClusterInfo"] = reflect.TypeOf((*ArrayOfKmipClusterInfo)(nil)).Elem()
}

// A boxed array of `KmipServerInfo`. To be used in `Any` placeholders.
type ArrayOfKmipServerInfo struct {
	KmipServerInfo []KmipServerInfo `xml:"KmipServerInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfKmipServerInfo"] = reflect.TypeOf((*ArrayOfKmipServerInfo)(nil)).Elem()
}

// A boxed array of `LicenseAssignmentManagerLicenseAssignment`. To be used in `Any` placeholders.
type ArrayOfLicenseAssignmentManagerLicenseAssignment struct {
	LicenseAssignmentManagerLicenseAssignment []LicenseAssignmentManagerLicenseAssignment `xml:"LicenseAssignmentManagerLicenseAssignment,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLicenseAssignmentManagerLicenseAssignment"] = reflect.TypeOf((*ArrayOfLicenseAssignmentManagerLicenseAssignment)(nil)).Elem()
}

// A boxed array of `LicenseAvailabilityInfo`. To be used in `Any` placeholders.
type ArrayOfLicenseAvailabilityInfo struct {
	LicenseAvailabilityInfo []LicenseAvailabilityInfo `xml:"LicenseAvailabilityInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLicenseAvailabilityInfo"] = reflect.TypeOf((*ArrayOfLicenseAvailabilityInfo)(nil)).Elem()
}

// A boxed array of `LicenseFeatureInfo`. To be used in `Any` placeholders.
type ArrayOfLicenseFeatureInfo struct {
	LicenseFeatureInfo []LicenseFeatureInfo `xml:"LicenseFeatureInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLicenseFeatureInfo"] = reflect.TypeOf((*ArrayOfLicenseFeatureInfo)(nil)).Elem()
}

// A boxed array of `LicenseManagerLicenseInfo`. To be used in `Any` placeholders.
type ArrayOfLicenseManagerLicenseInfo struct {
	LicenseManagerLicenseInfo []LicenseManagerLicenseInfo `xml:"LicenseManagerLicenseInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLicenseManagerLicenseInfo"] = reflect.TypeOf((*ArrayOfLicenseManagerLicenseInfo)(nil)).Elem()
}

// A boxed array of `LicenseReservationInfo`. To be used in `Any` placeholders.
type ArrayOfLicenseReservationInfo struct {
	LicenseReservationInfo []LicenseReservationInfo `xml:"LicenseReservationInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLicenseReservationInfo"] = reflect.TypeOf((*ArrayOfLicenseReservationInfo)(nil)).Elem()
}

// A boxed array of `LocalizableMessage`. To be used in `Any` placeholders.
type ArrayOfLocalizableMessage struct {
	LocalizableMessage []LocalizableMessage `xml:"LocalizableMessage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLocalizableMessage"] = reflect.TypeOf((*ArrayOfLocalizableMessage)(nil)).Elem()
}

// A boxed array of `LocalizationManagerMessageCatalog`. To be used in `Any` placeholders.
type ArrayOfLocalizationManagerMessageCatalog struct {
	LocalizationManagerMessageCatalog []LocalizationManagerMessageCatalog `xml:"LocalizationManagerMessageCatalog,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLocalizationManagerMessageCatalog"] = reflect.TypeOf((*ArrayOfLocalizationManagerMessageCatalog)(nil)).Elem()
}

// A boxed array of `PrimitiveLong`. To be used in `Any` placeholders.
type ArrayOfLong struct {
	Long []int64 `xml:"long,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfLong"] = reflect.TypeOf((*ArrayOfLong)(nil)).Elem()
}

// A boxed array of `ManagedEntityStatus_enum`. To be used in `Any` placeholders.
type ArrayOfManagedEntityStatus struct {
	ManagedEntityStatus []ManagedEntityStatus `xml:"ManagedEntityStatus,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfManagedEntityStatus"] = reflect.TypeOf((*ArrayOfManagedEntityStatus)(nil)).Elem()
}

// A boxed array of `ManagedObjectReference`. To be used in `Any` placeholders.
type ArrayOfManagedObjectReference struct {
	ManagedObjectReference []ManagedObjectReference `xml:"ManagedObjectReference,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfManagedObjectReference"] = reflect.TypeOf((*ArrayOfManagedObjectReference)(nil)).Elem()
}

// A boxed array of `MethodActionArgument`. To be used in `Any` placeholders.
type ArrayOfMethodActionArgument struct {
	MethodActionArgument []MethodActionArgument `xml:"MethodActionArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfMethodActionArgument"] = reflect.TypeOf((*ArrayOfMethodActionArgument)(nil)).Elem()
}

// A boxed array of `MethodFault`. To be used in `Any` placeholders.
type ArrayOfMethodFault struct {
	MethodFault []BaseMethodFault `xml:"MethodFault,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfMethodFault"] = reflect.TypeOf((*ArrayOfMethodFault)(nil)).Elem()
}

// A boxed array of `MissingObject`. To be used in `Any` placeholders.
type ArrayOfMissingObject struct {
	MissingObject []MissingObject `xml:"MissingObject,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfMissingObject"] = reflect.TypeOf((*ArrayOfMissingObject)(nil)).Elem()
}

// A boxed array of `MissingProperty`. To be used in `Any` placeholders.
type ArrayOfMissingProperty struct {
	MissingProperty []MissingProperty `xml:"MissingProperty,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfMissingProperty"] = reflect.TypeOf((*ArrayOfMissingProperty)(nil)).Elem()
}

// A boxed array of `MultipleCertificatesVerifyFaultThumbprintData`. To be used in `Any` placeholders.
type ArrayOfMultipleCertificatesVerifyFaultThumbprintData struct {
	MultipleCertificatesVerifyFaultThumbprintData []MultipleCertificatesVerifyFaultThumbprintData `xml:"MultipleCertificatesVerifyFaultThumbprintData,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfMultipleCertificatesVerifyFaultThumbprintData"] = reflect.TypeOf((*ArrayOfMultipleCertificatesVerifyFaultThumbprintData)(nil)).Elem()
}

// A boxed array of `NasStorageProfile`. To be used in `Any` placeholders.
type ArrayOfNasStorageProfile struct {
	NasStorageProfile []NasStorageProfile `xml:"NasStorageProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNasStorageProfile"] = reflect.TypeOf((*ArrayOfNasStorageProfile)(nil)).Elem()
}

// A boxed array of `NetIpConfigInfoIpAddress`. To be used in `Any` placeholders.
type ArrayOfNetIpConfigInfoIpAddress struct {
	NetIpConfigInfoIpAddress []NetIpConfigInfoIpAddress `xml:"NetIpConfigInfoIpAddress,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpConfigInfoIpAddress"] = reflect.TypeOf((*ArrayOfNetIpConfigInfoIpAddress)(nil)).Elem()
}

// A boxed array of `NetIpConfigSpecIpAddressSpec`. To be used in `Any` placeholders.
type ArrayOfNetIpConfigSpecIpAddressSpec struct {
	NetIpConfigSpecIpAddressSpec []NetIpConfigSpecIpAddressSpec `xml:"NetIpConfigSpecIpAddressSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpConfigSpecIpAddressSpec"] = reflect.TypeOf((*ArrayOfNetIpConfigSpecIpAddressSpec)(nil)).Elem()
}

// A boxed array of `NetIpRouteConfigInfoIpRoute`. To be used in `Any` placeholders.
type ArrayOfNetIpRouteConfigInfoIpRoute struct {
	NetIpRouteConfigInfoIpRoute []NetIpRouteConfigInfoIpRoute `xml:"NetIpRouteConfigInfoIpRoute,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpRouteConfigInfoIpRoute"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigInfoIpRoute)(nil)).Elem()
}

// A boxed array of `NetIpRouteConfigSpecIpRouteSpec`. To be used in `Any` placeholders.
type ArrayOfNetIpRouteConfigSpecIpRouteSpec struct {
	NetIpRouteConfigSpecIpRouteSpec []NetIpRouteConfigSpecIpRouteSpec `xml:"NetIpRouteConfigSpecIpRouteSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpRouteConfigSpecIpRouteSpec"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigSpecIpRouteSpec)(nil)).Elem()
}

// A boxed array of `NetIpStackInfoDefaultRouter`. To be used in `Any` placeholders.
type ArrayOfNetIpStackInfoDefaultRouter struct {
	NetIpStackInfoDefaultRouter []NetIpStackInfoDefaultRouter `xml:"NetIpStackInfoDefaultRouter,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpStackInfoDefaultRouter"] = reflect.TypeOf((*ArrayOfNetIpStackInfoDefaultRouter)(nil)).Elem()
}

// A boxed array of `NetIpStackInfoNetToMedia`. To be used in `Any` placeholders.
type ArrayOfNetIpStackInfoNetToMedia struct {
	NetIpStackInfoNetToMedia []NetIpStackInfoNetToMedia `xml:"NetIpStackInfoNetToMedia,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetIpStackInfoNetToMedia"] = reflect.TypeOf((*ArrayOfNetIpStackInfoNetToMedia)(nil)).Elem()
}

// A boxed array of `NetStackInstanceProfile`. To be used in `Any` placeholders.
type ArrayOfNetStackInstanceProfile struct {
	NetStackInstanceProfile []NetStackInstanceProfile `xml:"NetStackInstanceProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNetStackInstanceProfile"] = reflect.TypeOf((*ArrayOfNetStackInstanceProfile)(nil)).Elem()
}

// A boxed array of `NoPermissionEntityPrivileges`. To be used in `Any` placeholders.
type ArrayOfNoPermissionEntityPrivileges struct {
	NoPermissionEntityPrivileges []NoPermissionEntityPrivileges `xml:"NoPermissionEntityPrivileges,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNoPermissionEntityPrivileges"] = reflect.TypeOf((*ArrayOfNoPermissionEntityPrivileges)(nil)).Elem()
	minAPIVersionForType["ArrayOfNoPermissionEntityPrivileges"] = "7.0.3.2"
}

// A boxed array of `NsxHostVNicProfile`. To be used in `Any` placeholders.
type ArrayOfNsxHostVNicProfile struct {
	NsxHostVNicProfile []NsxHostVNicProfile `xml:"NsxHostVNicProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNsxHostVNicProfile"] = reflect.TypeOf((*ArrayOfNsxHostVNicProfile)(nil)).Elem()
}

// A boxed array of `NumericRange`. To be used in `Any` placeholders.
type ArrayOfNumericRange struct {
	NumericRange []NumericRange `xml:"NumericRange,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNumericRange"] = reflect.TypeOf((*ArrayOfNumericRange)(nil)).Elem()
}

// A boxed array of `NvdimmDimmInfo`. To be used in `Any` placeholders.
type ArrayOfNvdimmDimmInfo struct {
	NvdimmDimmInfo []NvdimmDimmInfo `xml:"NvdimmDimmInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmDimmInfo"] = reflect.TypeOf((*ArrayOfNvdimmDimmInfo)(nil)).Elem()
}

// A boxed array of `NvdimmGuid`. To be used in `Any` placeholders.
type ArrayOfNvdimmGuid struct {
	NvdimmGuid []NvdimmGuid `xml:"NvdimmGuid,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmGuid"] = reflect.TypeOf((*ArrayOfNvdimmGuid)(nil)).Elem()
}

// A boxed array of `NvdimmInterleaveSetInfo`. To be used in `Any` placeholders.
type ArrayOfNvdimmInterleaveSetInfo struct {
	NvdimmInterleaveSetInfo []NvdimmInterleaveSetInfo `xml:"NvdimmInterleaveSetInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmInterleaveSetInfo"] = reflect.TypeOf((*ArrayOfNvdimmInterleaveSetInfo)(nil)).Elem()
}

// A boxed array of `NvdimmNamespaceDetails`. To be used in `Any` placeholders.
type ArrayOfNvdimmNamespaceDetails struct {
	NvdimmNamespaceDetails []NvdimmNamespaceDetails `xml:"NvdimmNamespaceDetails,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmNamespaceDetails"] = reflect.TypeOf((*ArrayOfNvdimmNamespaceDetails)(nil)).Elem()
}

// A boxed array of `NvdimmNamespaceInfo`. To be used in `Any` placeholders.
type ArrayOfNvdimmNamespaceInfo struct {
	NvdimmNamespaceInfo []NvdimmNamespaceInfo `xml:"NvdimmNamespaceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmNamespaceInfo"] = reflect.TypeOf((*ArrayOfNvdimmNamespaceInfo)(nil)).Elem()
}

// A boxed array of `NvdimmRegionInfo`. To be used in `Any` placeholders.
type ArrayOfNvdimmRegionInfo struct {
	NvdimmRegionInfo []NvdimmRegionInfo `xml:"NvdimmRegionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfNvdimmRegionInfo"] = reflect.TypeOf((*ArrayOfNvdimmRegionInfo)(nil)).Elem()
}

// A boxed array of `ObjectContent`. To be used in `Any` placeholders.
type ArrayOfObjectContent struct {
	ObjectContent []ObjectContent `xml:"ObjectContent,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfObjectContent"] = reflect.TypeOf((*ArrayOfObjectContent)(nil)).Elem()
}

// A boxed array of `ObjectSpec`. To be used in `Any` placeholders.
type ArrayOfObjectSpec struct {
	ObjectSpec []ObjectSpec `xml:"ObjectSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfObjectSpec"] = reflect.TypeOf((*ArrayOfObjectSpec)(nil)).Elem()
}

// A boxed array of `ObjectUpdate`. To be used in `Any` placeholders.
type ArrayOfObjectUpdate struct {
	ObjectUpdate []ObjectUpdate `xml:"ObjectUpdate,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfObjectUpdate"] = reflect.TypeOf((*ArrayOfObjectUpdate)(nil)).Elem()
}

// A boxed array of `OpaqueNetworkTargetInfo`. To be used in `Any` placeholders.
type ArrayOfOpaqueNetworkTargetInfo struct {
	OpaqueNetworkTargetInfo []OpaqueNetworkTargetInfo `xml:"OpaqueNetworkTargetInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOpaqueNetworkTargetInfo"] = reflect.TypeOf((*ArrayOfOpaqueNetworkTargetInfo)(nil)).Elem()
}

// A boxed array of `OptionDef`. To be used in `Any` placeholders.
type ArrayOfOptionDef struct {
	OptionDef []OptionDef `xml:"OptionDef,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOptionDef"] = reflect.TypeOf((*ArrayOfOptionDef)(nil)).Elem()
}

// A boxed array of `OptionProfile`. To be used in `Any` placeholders.
type ArrayOfOptionProfile struct {
	OptionProfile []OptionProfile `xml:"OptionProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOptionProfile"] = reflect.TypeOf((*ArrayOfOptionProfile)(nil)).Elem()
}

// A boxed array of `OptionValue`. To be used in `Any` placeholders.
type ArrayOfOptionValue struct {
	OptionValue []BaseOptionValue `xml:"OptionValue,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfOptionValue"] = reflect.TypeOf((*ArrayOfOptionValue)(nil)).Elem()
}

// A boxed array of `OvfConsumerOstNode`. To be used in `Any` placeholders.
type ArrayOfOvfConsumerOstNode struct {
	OvfConsumerOstNode []OvfConsumerOstNode `xml:"OvfConsumerOstNode,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfConsumerOstNode"] = reflect.TypeOf((*ArrayOfOvfConsumerOstNode)(nil)).Elem()
}

// A boxed array of `OvfConsumerOvfSection`. To be used in `Any` placeholders.
type ArrayOfOvfConsumerOvfSection struct {
	OvfConsumerOvfSection []OvfConsumerOvfSection `xml:"OvfConsumerOvfSection,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfConsumerOvfSection"] = reflect.TypeOf((*ArrayOfOvfConsumerOvfSection)(nil)).Elem()
}

// A boxed array of `OvfDeploymentOption`. To be used in `Any` placeholders.
type ArrayOfOvfDeploymentOption struct {
	OvfDeploymentOption []OvfDeploymentOption `xml:"OvfDeploymentOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfDeploymentOption"] = reflect.TypeOf((*ArrayOfOvfDeploymentOption)(nil)).Elem()
}

// A boxed array of `OvfFile`. To be used in `Any` placeholders.
type ArrayOfOvfFile struct {
	OvfFile []OvfFile `xml:"OvfFile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfFile"] = reflect.TypeOf((*ArrayOfOvfFile)(nil)).Elem()
}

// A boxed array of `OvfFileItem`. To be used in `Any` placeholders.
type ArrayOfOvfFileItem struct {
	OvfFileItem []OvfFileItem `xml:"OvfFileItem,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfFileItem"] = reflect.TypeOf((*ArrayOfOvfFileItem)(nil)).Elem()
}

// A boxed array of `OvfNetworkInfo`. To be used in `Any` placeholders.
type ArrayOfOvfNetworkInfo struct {
	OvfNetworkInfo []OvfNetworkInfo `xml:"OvfNetworkInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfNetworkInfo"] = reflect.TypeOf((*ArrayOfOvfNetworkInfo)(nil)).Elem()
}

// A boxed array of `OvfNetworkMapping`. To be used in `Any` placeholders.
type ArrayOfOvfNetworkMapping struct {
	OvfNetworkMapping []OvfNetworkMapping `xml:"OvfNetworkMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfNetworkMapping"] = reflect.TypeOf((*ArrayOfOvfNetworkMapping)(nil)).Elem()
}

// A boxed array of `OvfOptionInfo`. To be used in `Any` placeholders.
type ArrayOfOvfOptionInfo struct {
	OvfOptionInfo []OvfOptionInfo `xml:"OvfOptionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfOptionInfo"] = reflect.TypeOf((*ArrayOfOvfOptionInfo)(nil)).Elem()
}

// A boxed array of `OvfResourceMap`. To be used in `Any` placeholders.
type ArrayOfOvfResourceMap struct {
	OvfResourceMap []OvfResourceMap `xml:"OvfResourceMap,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfOvfResourceMap"] = reflect.TypeOf((*ArrayOfOvfResourceMap)(nil)).Elem()
}

// A boxed array of `PerfCounterInfo`. To be used in `Any` placeholders.
type ArrayOfPerfCounterInfo struct {
	PerfCounterInfo []PerfCounterInfo `xml:"PerfCounterInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfCounterInfo"] = reflect.TypeOf((*ArrayOfPerfCounterInfo)(nil)).Elem()
}

// A boxed array of `PerfEntityMetricBase`. To be used in `Any` placeholders.
type ArrayOfPerfEntityMetricBase struct {
	PerfEntityMetricBase []BasePerfEntityMetricBase `xml:"PerfEntityMetricBase,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfPerfEntityMetricBase"] = reflect.TypeOf((*ArrayOfPerfEntityMetricBase)(nil)).Elem()
}

// A boxed array of `PerfInterval`. To be used in `Any` placeholders.
type ArrayOfPerfInterval struct {
	PerfInterval []PerfInterval `xml:"PerfInterval,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfInterval"] = reflect.TypeOf((*ArrayOfPerfInterval)(nil)).Elem()
}

// A boxed array of `PerfMetricId`. To be used in `Any` placeholders.
type ArrayOfPerfMetricId struct {
	PerfMetricId []PerfMetricId `xml:"PerfMetricId,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfMetricId"] = reflect.TypeOf((*ArrayOfPerfMetricId)(nil)).Elem()
}

// A boxed array of `PerfMetricSeries`. To be used in `Any` placeholders.
type ArrayOfPerfMetricSeries struct {
	PerfMetricSeries []BasePerfMetricSeries `xml:"PerfMetricSeries,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfPerfMetricSeries"] = reflect.TypeOf((*ArrayOfPerfMetricSeries)(nil)).Elem()
}

// A boxed array of `PerfMetricSeriesCSV`. To be used in `Any` placeholders.
type ArrayOfPerfMetricSeriesCSV struct {
	PerfMetricSeriesCSV []PerfMetricSeriesCSV `xml:"PerfMetricSeriesCSV,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfMetricSeriesCSV"] = reflect.TypeOf((*ArrayOfPerfMetricSeriesCSV)(nil)).Elem()
}

// A boxed array of `PerfQuerySpec`. To be used in `Any` placeholders.
type ArrayOfPerfQuerySpec struct {
	PerfQuerySpec []PerfQuerySpec `xml:"PerfQuerySpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfQuerySpec"] = reflect.TypeOf((*ArrayOfPerfQuerySpec)(nil)).Elem()
}

// A boxed array of `PerfSampleInfo`. To be used in `Any` placeholders.
type ArrayOfPerfSampleInfo struct {
	PerfSampleInfo []PerfSampleInfo `xml:"PerfSampleInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerfSampleInfo"] = reflect.TypeOf((*ArrayOfPerfSampleInfo)(nil)).Elem()
}

// A boxed array of `PerformanceManagerCounterLevelMapping`. To be used in `Any` placeholders.
type ArrayOfPerformanceManagerCounterLevelMapping struct {
	PerformanceManagerCounterLevelMapping []PerformanceManagerCounterLevelMapping `xml:"PerformanceManagerCounterLevelMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPerformanceManagerCounterLevelMapping"] = reflect.TypeOf((*ArrayOfPerformanceManagerCounterLevelMapping)(nil)).Elem()
}

// A boxed array of `Permission`. To be used in `Any` placeholders.
type ArrayOfPermission struct {
	Permission []Permission `xml:"Permission,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPermission"] = reflect.TypeOf((*ArrayOfPermission)(nil)).Elem()
}

// A boxed array of `PermissionProfile`. To be used in `Any` placeholders.
type ArrayOfPermissionProfile struct {
	PermissionProfile []PermissionProfile `xml:"PermissionProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPermissionProfile"] = reflect.TypeOf((*ArrayOfPermissionProfile)(nil)).Elem()
}

// A boxed array of `PhysicalNic`. To be used in `Any` placeholders.
type ArrayOfPhysicalNic struct {
	PhysicalNic []PhysicalNic `xml:"PhysicalNic,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNic"] = reflect.TypeOf((*ArrayOfPhysicalNic)(nil)).Elem()
}

// A boxed array of `PhysicalNicConfig`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicConfig struct {
	PhysicalNicConfig []PhysicalNicConfig `xml:"PhysicalNicConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicConfig"] = reflect.TypeOf((*ArrayOfPhysicalNicConfig)(nil)).Elem()
}

// A boxed array of `PhysicalNicHintInfo`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicHintInfo struct {
	PhysicalNicHintInfo []PhysicalNicHintInfo `xml:"PhysicalNicHintInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicHintInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicHintInfo)(nil)).Elem()
}

// A boxed array of `PhysicalNicIpHint`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicIpHint struct {
	PhysicalNicIpHint []PhysicalNicIpHint `xml:"PhysicalNicIpHint,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicIpHint"] = reflect.TypeOf((*ArrayOfPhysicalNicIpHint)(nil)).Elem()
}

// A boxed array of `PhysicalNicLinkInfo`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicLinkInfo struct {
	PhysicalNicLinkInfo []PhysicalNicLinkInfo `xml:"PhysicalNicLinkInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicLinkInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicLinkInfo)(nil)).Elem()
}

// A boxed array of `PhysicalNicNameHint`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicNameHint struct {
	PhysicalNicNameHint []PhysicalNicNameHint `xml:"PhysicalNicNameHint,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicNameHint"] = reflect.TypeOf((*ArrayOfPhysicalNicNameHint)(nil)).Elem()
}

// A boxed array of `PhysicalNicProfile`. To be used in `Any` placeholders.
type ArrayOfPhysicalNicProfile struct {
	PhysicalNicProfile []PhysicalNicProfile `xml:"PhysicalNicProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPhysicalNicProfile"] = reflect.TypeOf((*ArrayOfPhysicalNicProfile)(nil)).Elem()
}

// A boxed array of `PlacementAffinityRule`. To be used in `Any` placeholders.
type ArrayOfPlacementAffinityRule struct {
	PlacementAffinityRule []PlacementAffinityRule `xml:"PlacementAffinityRule,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPlacementAffinityRule"] = reflect.TypeOf((*ArrayOfPlacementAffinityRule)(nil)).Elem()
}

// A boxed array of `PlacementSpec`. To be used in `Any` placeholders.
type ArrayOfPlacementSpec struct {
	PlacementSpec []PlacementSpec `xml:"PlacementSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPlacementSpec"] = reflect.TypeOf((*ArrayOfPlacementSpec)(nil)).Elem()
}

// A boxed array of `PnicUplinkProfile`. To be used in `Any` placeholders.
type ArrayOfPnicUplinkProfile struct {
	PnicUplinkProfile []PnicUplinkProfile `xml:"PnicUplinkProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPnicUplinkProfile"] = reflect.TypeOf((*ArrayOfPnicUplinkProfile)(nil)).Elem()
}

// A boxed array of `PodDiskLocator`. To be used in `Any` placeholders.
type ArrayOfPodDiskLocator struct {
	PodDiskLocator []PodDiskLocator `xml:"PodDiskLocator,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPodDiskLocator"] = reflect.TypeOf((*ArrayOfPodDiskLocator)(nil)).Elem()
}

// A boxed array of `PolicyOption`. To be used in `Any` placeholders.
type ArrayOfPolicyOption struct {
	PolicyOption []BasePolicyOption `xml:"PolicyOption,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfPolicyOption"] = reflect.TypeOf((*ArrayOfPolicyOption)(nil)).Elem()
}

// A boxed array of `PrivilegeAvailability`. To be used in `Any` placeholders.
type ArrayOfPrivilegeAvailability struct {
	PrivilegeAvailability []PrivilegeAvailability `xml:"PrivilegeAvailability,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPrivilegeAvailability"] = reflect.TypeOf((*ArrayOfPrivilegeAvailability)(nil)).Elem()
}

// A boxed array of `ProductComponentInfo`. To be used in `Any` placeholders.
type ArrayOfProductComponentInfo struct {
	ProductComponentInfo []ProductComponentInfo `xml:"ProductComponentInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProductComponentInfo"] = reflect.TypeOf((*ArrayOfProductComponentInfo)(nil)).Elem()
}

// A boxed array of `ProfileApplyProfileProperty`. To be used in `Any` placeholders.
type ArrayOfProfileApplyProfileProperty struct {
	ProfileApplyProfileProperty []ProfileApplyProfileProperty `xml:"ProfileApplyProfileProperty,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileApplyProfileProperty"] = reflect.TypeOf((*ArrayOfProfileApplyProfileProperty)(nil)).Elem()
}

// A boxed array of `ProfileDeferredPolicyOptionParameter`. To be used in `Any` placeholders.
type ArrayOfProfileDeferredPolicyOptionParameter struct {
	ProfileDeferredPolicyOptionParameter []ProfileDeferredPolicyOptionParameter `xml:"ProfileDeferredPolicyOptionParameter,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileDeferredPolicyOptionParameter"] = reflect.TypeOf((*ArrayOfProfileDeferredPolicyOptionParameter)(nil)).Elem()
}

// A boxed array of `ProfileDescriptionSection`. To be used in `Any` placeholders.
type ArrayOfProfileDescriptionSection struct {
	ProfileDescriptionSection []ProfileDescriptionSection `xml:"ProfileDescriptionSection,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileDescriptionSection"] = reflect.TypeOf((*ArrayOfProfileDescriptionSection)(nil)).Elem()
}

// A boxed array of `ProfileExecuteError`. To be used in `Any` placeholders.
type ArrayOfProfileExecuteError struct {
	ProfileExecuteError []ProfileExecuteError `xml:"ProfileExecuteError,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileExecuteError"] = reflect.TypeOf((*ArrayOfProfileExecuteError)(nil)).Elem()
}

// A boxed array of `ProfileExpression`. To be used in `Any` placeholders.
type ArrayOfProfileExpression struct {
	ProfileExpression []BaseProfileExpression `xml:"ProfileExpression,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfProfileExpression"] = reflect.TypeOf((*ArrayOfProfileExpression)(nil)).Elem()
}

// A boxed array of `ProfileExpressionMetadata`. To be used in `Any` placeholders.
type ArrayOfProfileExpressionMetadata struct {
	ProfileExpressionMetadata []ProfileExpressionMetadata `xml:"ProfileExpressionMetadata,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileExpressionMetadata"] = reflect.TypeOf((*ArrayOfProfileExpressionMetadata)(nil)).Elem()
}

// A boxed array of `ProfileMetadata`. To be used in `Any` placeholders.
type ArrayOfProfileMetadata struct {
	ProfileMetadata []ProfileMetadata `xml:"ProfileMetadata,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileMetadata"] = reflect.TypeOf((*ArrayOfProfileMetadata)(nil)).Elem()
}

// A boxed array of `ProfileMetadataProfileOperationMessage`. To be used in `Any` placeholders.
type ArrayOfProfileMetadataProfileOperationMessage struct {
	ProfileMetadataProfileOperationMessage []ProfileMetadataProfileOperationMessage `xml:"ProfileMetadataProfileOperationMessage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileMetadataProfileOperationMessage"] = reflect.TypeOf((*ArrayOfProfileMetadataProfileOperationMessage)(nil)).Elem()
}

// A boxed array of `ProfileMetadataProfileSortSpec`. To be used in `Any` placeholders.
type ArrayOfProfileMetadataProfileSortSpec struct {
	ProfileMetadataProfileSortSpec []ProfileMetadataProfileSortSpec `xml:"ProfileMetadataProfileSortSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileMetadataProfileSortSpec"] = reflect.TypeOf((*ArrayOfProfileMetadataProfileSortSpec)(nil)).Elem()
}

// A boxed array of `ProfileParameterMetadata`. To be used in `Any` placeholders.
type ArrayOfProfileParameterMetadata struct {
	ProfileParameterMetadata []ProfileParameterMetadata `xml:"ProfileParameterMetadata,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileParameterMetadata"] = reflect.TypeOf((*ArrayOfProfileParameterMetadata)(nil)).Elem()
}

// A boxed array of `ProfileParameterMetadataParameterRelationMetadata`. To be used in `Any` placeholders.
type ArrayOfProfileParameterMetadataParameterRelationMetadata struct {
	ProfileParameterMetadataParameterRelationMetadata []ProfileParameterMetadataParameterRelationMetadata `xml:"ProfileParameterMetadataParameterRelationMetadata,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileParameterMetadataParameterRelationMetadata"] = reflect.TypeOf((*ArrayOfProfileParameterMetadataParameterRelationMetadata)(nil)).Elem()
}

// A boxed array of `ProfilePolicy`. To be used in `Any` placeholders.
type ArrayOfProfilePolicy struct {
	ProfilePolicy []ProfilePolicy `xml:"ProfilePolicy,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfilePolicy"] = reflect.TypeOf((*ArrayOfProfilePolicy)(nil)).Elem()
}

// A boxed array of `ProfilePolicyMetadata`. To be used in `Any` placeholders.
type ArrayOfProfilePolicyMetadata struct {
	ProfilePolicyMetadata []ProfilePolicyMetadata `xml:"ProfilePolicyMetadata,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfilePolicyMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyMetadata)(nil)).Elem()
}

// A boxed array of `ProfilePolicyOptionMetadata`. To be used in `Any` placeholders.
type ArrayOfProfilePolicyOptionMetadata struct {
	ProfilePolicyOptionMetadata []BaseProfilePolicyOptionMetadata `xml:"ProfilePolicyOptionMetadata,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfProfilePolicyOptionMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyOptionMetadata)(nil)).Elem()
}

// A boxed array of `ProfileProfileStructureProperty`. To be used in `Any` placeholders.
type ArrayOfProfileProfileStructureProperty struct {
	ProfileProfileStructureProperty []ProfileProfileStructureProperty `xml:"ProfileProfileStructureProperty,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileProfileStructureProperty"] = reflect.TypeOf((*ArrayOfProfileProfileStructureProperty)(nil)).Elem()
}

// A boxed array of `ProfilePropertyPath`. To be used in `Any` placeholders.
type ArrayOfProfilePropertyPath struct {
	ProfilePropertyPath []ProfilePropertyPath `xml:"ProfilePropertyPath,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfilePropertyPath"] = reflect.TypeOf((*ArrayOfProfilePropertyPath)(nil)).Elem()
}

// A boxed array of `ProfileUpdateFailedUpdateFailure`. To be used in `Any` placeholders.
type ArrayOfProfileUpdateFailedUpdateFailure struct {
	ProfileUpdateFailedUpdateFailure []ProfileUpdateFailedUpdateFailure `xml:"ProfileUpdateFailedUpdateFailure,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfProfileUpdateFailedUpdateFailure"] = reflect.TypeOf((*ArrayOfProfileUpdateFailedUpdateFailure)(nil)).Elem()
}

// A boxed array of `PropertyChange`. To be used in `Any` placeholders.
type ArrayOfPropertyChange struct {
	PropertyChange []PropertyChange `xml:"PropertyChange,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPropertyChange"] = reflect.TypeOf((*ArrayOfPropertyChange)(nil)).Elem()
}

// A boxed array of `PropertyFilterSpec`. To be used in `Any` placeholders.
type ArrayOfPropertyFilterSpec struct {
	PropertyFilterSpec []PropertyFilterSpec `xml:"PropertyFilterSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPropertyFilterSpec"] = reflect.TypeOf((*ArrayOfPropertyFilterSpec)(nil)).Elem()
}

// A boxed array of `PropertyFilterUpdate`. To be used in `Any` placeholders.
type ArrayOfPropertyFilterUpdate struct {
	PropertyFilterUpdate []PropertyFilterUpdate `xml:"PropertyFilterUpdate,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPropertyFilterUpdate"] = reflect.TypeOf((*ArrayOfPropertyFilterUpdate)(nil)).Elem()
}

// A boxed array of `PropertySpec`. To be used in `Any` placeholders.
type ArrayOfPropertySpec struct {
	PropertySpec []PropertySpec `xml:"PropertySpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfPropertySpec"] = reflect.TypeOf((*ArrayOfPropertySpec)(nil)).Elem()
}

// A boxed array of `Relation`. To be used in `Any` placeholders.
type ArrayOfRelation struct {
	Relation []Relation `xml:"Relation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfRelation"] = reflect.TypeOf((*ArrayOfRelation)(nil)).Elem()
}

// A boxed array of `ReplicationInfoDiskSettings`. To be used in `Any` placeholders.
type ArrayOfReplicationInfoDiskSettings struct {
	ReplicationInfoDiskSettings []ReplicationInfoDiskSettings `xml:"ReplicationInfoDiskSettings,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfReplicationInfoDiskSettings"] = reflect.TypeOf((*ArrayOfReplicationInfoDiskSettings)(nil)).Elem()
}

// A boxed array of `ResourceConfigSpec`. To be used in `Any` placeholders.
type ArrayOfResourceConfigSpec struct {
	ResourceConfigSpec []ResourceConfigSpec `xml:"ResourceConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfResourceConfigSpec"] = reflect.TypeOf((*ArrayOfResourceConfigSpec)(nil)).Elem()
}

// A boxed array of `RetrieveVStorageObjSpec`. To be used in `Any` placeholders.
type ArrayOfRetrieveVStorageObjSpec struct {
	RetrieveVStorageObjSpec []RetrieveVStorageObjSpec `xml:"RetrieveVStorageObjSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfRetrieveVStorageObjSpec"] = reflect.TypeOf((*ArrayOfRetrieveVStorageObjSpec)(nil)).Elem()
}

// A boxed array of `ScheduledTaskDetail`. To be used in `Any` placeholders.
type ArrayOfScheduledTaskDetail struct {
	ScheduledTaskDetail []ScheduledTaskDetail `xml:"ScheduledTaskDetail,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfScheduledTaskDetail"] = reflect.TypeOf((*ArrayOfScheduledTaskDetail)(nil)).Elem()
}

// A boxed array of `ScsiLun`. To be used in `Any` placeholders.
type ArrayOfScsiLun struct {
	ScsiLun []BaseScsiLun `xml:"ScsiLun,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfScsiLun"] = reflect.TypeOf((*ArrayOfScsiLun)(nil)).Elem()
}

// A boxed array of `ScsiLunDescriptor`. To be used in `Any` placeholders.
type ArrayOfScsiLunDescriptor struct {
	ScsiLunDescriptor []ScsiLunDescriptor `xml:"ScsiLunDescriptor,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfScsiLunDescriptor"] = reflect.TypeOf((*ArrayOfScsiLunDescriptor)(nil)).Elem()
}

// A boxed array of `ScsiLunDurableName`. To be used in `Any` placeholders.
type ArrayOfScsiLunDurableName struct {
	ScsiLunDurableName []ScsiLunDurableName `xml:"ScsiLunDurableName,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfScsiLunDurableName"] = reflect.TypeOf((*ArrayOfScsiLunDurableName)(nil)).Elem()
}

// A boxed array of `SelectionSet`. To be used in `Any` placeholders.
type ArrayOfSelectionSet struct {
	SelectionSet []BaseSelectionSet `xml:"SelectionSet,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfSelectionSet"] = reflect.TypeOf((*ArrayOfSelectionSet)(nil)).Elem()
}

// A boxed array of `SelectionSpec`. To be used in `Any` placeholders.
type ArrayOfSelectionSpec struct {
	SelectionSpec []BaseSelectionSpec `xml:"SelectionSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfSelectionSpec"] = reflect.TypeOf((*ArrayOfSelectionSpec)(nil)).Elem()
}

// A boxed array of `ServiceConsolePortGroupProfile`. To be used in `Any` placeholders.
type ArrayOfServiceConsolePortGroupProfile struct {
	ServiceConsolePortGroupProfile []ServiceConsolePortGroupProfile `xml:"ServiceConsolePortGroupProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfServiceConsolePortGroupProfile"] = reflect.TypeOf((*ArrayOfServiceConsolePortGroupProfile)(nil)).Elem()
}

// A boxed array of `ServiceLocator`. To be used in `Any` placeholders.
type ArrayOfServiceLocator struct {
	ServiceLocator []ServiceLocator `xml:"ServiceLocator,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfServiceLocator"] = reflect.TypeOf((*ArrayOfServiceLocator)(nil)).Elem()
}

// A boxed array of `ServiceManagerServiceInfo`. To be used in `Any` placeholders.
type ArrayOfServiceManagerServiceInfo struct {
	ServiceManagerServiceInfo []ServiceManagerServiceInfo `xml:"ServiceManagerServiceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfServiceManagerServiceInfo"] = reflect.TypeOf((*ArrayOfServiceManagerServiceInfo)(nil)).Elem()
}

// A boxed array of `ServiceProfile`. To be used in `Any` placeholders.
type ArrayOfServiceProfile struct {
	ServiceProfile []ServiceProfile `xml:"ServiceProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfServiceProfile"] = reflect.TypeOf((*ArrayOfServiceProfile)(nil)).Elem()
}

// A boxed array of `PrimitiveShort`. To be used in `Any` placeholders.
type ArrayOfShort struct {
	Short []int16 `xml:"short,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfShort"] = reflect.TypeOf((*ArrayOfShort)(nil)).Elem()
}

// A boxed array of `SoftwarePackage`. To be used in `Any` placeholders.
type ArrayOfSoftwarePackage struct {
	SoftwarePackage []SoftwarePackage `xml:"SoftwarePackage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfSoftwarePackage"] = reflect.TypeOf((*ArrayOfSoftwarePackage)(nil)).Elem()
}

// A boxed array of `StaticRouteProfile`. To be used in `Any` placeholders.
type ArrayOfStaticRouteProfile struct {
	StaticRouteProfile []StaticRouteProfile `xml:"StaticRouteProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStaticRouteProfile"] = reflect.TypeOf((*ArrayOfStaticRouteProfile)(nil)).Elem()
}

// A boxed array of `StorageDrsOptionSpec`. To be used in `Any` placeholders.
type ArrayOfStorageDrsOptionSpec struct {
	StorageDrsOptionSpec []StorageDrsOptionSpec `xml:"StorageDrsOptionSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStorageDrsOptionSpec"] = reflect.TypeOf((*ArrayOfStorageDrsOptionSpec)(nil)).Elem()
}

// A boxed array of `StorageDrsPlacementRankVmSpec`. To be used in `Any` placeholders.
type ArrayOfStorageDrsPlacementRankVmSpec struct {
	StorageDrsPlacementRankVmSpec []StorageDrsPlacementRankVmSpec `xml:"StorageDrsPlacementRankVmSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStorageDrsPlacementRankVmSpec"] = reflect.TypeOf((*ArrayOfStorageDrsPlacementRankVmSpec)(nil)).Elem()
}

// A boxed array of `StorageDrsVmConfigInfo`. To be used in `Any` placeholders.
type ArrayOfStorageDrsVmConfigInfo struct {
	StorageDrsVmConfigInfo []StorageDrsVmConfigInfo `xml:"StorageDrsVmConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigInfo)(nil)).Elem()
}

// A boxed array of `StorageDrsVmConfigSpec`. To be used in `Any` placeholders.
type ArrayOfStorageDrsVmConfigSpec struct {
	StorageDrsVmConfigSpec []StorageDrsVmConfigSpec `xml:"StorageDrsVmConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigSpec)(nil)).Elem()
}

// A boxed array of `StoragePerformanceSummary`. To be used in `Any` placeholders.
type ArrayOfStoragePerformanceSummary struct {
	StoragePerformanceSummary []StoragePerformanceSummary `xml:"StoragePerformanceSummary,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStoragePerformanceSummary"] = reflect.TypeOf((*ArrayOfStoragePerformanceSummary)(nil)).Elem()
}

// A boxed array of `StorageRequirement`. To be used in `Any` placeholders.
type ArrayOfStorageRequirement struct {
	StorageRequirement []StorageRequirement `xml:"StorageRequirement,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStorageRequirement"] = reflect.TypeOf((*ArrayOfStorageRequirement)(nil)).Elem()
}

// A boxed array of `PrimitiveString`. To be used in `Any` placeholders.
type ArrayOfString struct {
	String []string `xml:"string,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfString"] = reflect.TypeOf((*ArrayOfString)(nil)).Elem()
}

// A boxed array of `StructuredCustomizations`. To be used in `Any` placeholders.
type ArrayOfStructuredCustomizations struct {
	StructuredCustomizations []StructuredCustomizations `xml:"StructuredCustomizations,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfStructuredCustomizations"] = reflect.TypeOf((*ArrayOfStructuredCustomizations)(nil)).Elem()
}

// A boxed array of `SystemEventInfo`. To be used in `Any` placeholders.
type ArrayOfSystemEventInfo struct {
	SystemEventInfo []SystemEventInfo `xml:"SystemEventInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfSystemEventInfo"] = reflect.TypeOf((*ArrayOfSystemEventInfo)(nil)).Elem()
}

// A boxed array of `Tag`. To be used in `Any` placeholders.
type ArrayOfTag struct {
	Tag []Tag `xml:"Tag,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfTag"] = reflect.TypeOf((*ArrayOfTag)(nil)).Elem()
}

// A boxed array of `TaskInfo`. To be used in `Any` placeholders.
type ArrayOfTaskInfo struct {
	TaskInfo []TaskInfo `xml:"TaskInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfTaskInfo"] = reflect.TypeOf((*ArrayOfTaskInfo)(nil)).Elem()
}

// A boxed array of `TaskInfoState_enum`. To be used in `Any` placeholders.
type ArrayOfTaskInfoState struct {
	TaskInfoState []TaskInfoState `xml:"TaskInfoState,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfTaskInfoState"] = reflect.TypeOf((*ArrayOfTaskInfoState)(nil)).Elem()
}

// A boxed array of `TypeDescription`. To be used in `Any` placeholders.
type ArrayOfTypeDescription struct {
	TypeDescription []BaseTypeDescription `xml:"TypeDescription,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfTypeDescription"] = reflect.TypeOf((*ArrayOfTypeDescription)(nil)).Elem()
}

// A boxed array of `UpdateVirtualMachineFilesResultFailedVmFileInfo`. To be used in `Any` placeholders.
type ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo struct {
	UpdateVirtualMachineFilesResultFailedVmFileInfo []UpdateVirtualMachineFilesResultFailedVmFileInfo `xml:"UpdateVirtualMachineFilesResultFailedVmFileInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo"] = reflect.TypeOf((*ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo)(nil)).Elem()
}

type ArrayOfUri struct {
	Uri []string `xml:"uri,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUri"] = reflect.TypeOf((*ArrayOfUri)(nil)).Elem()
}

// A boxed array of `UsbScanCodeSpecKeyEvent`. To be used in `Any` placeholders.
type ArrayOfUsbScanCodeSpecKeyEvent struct {
	UsbScanCodeSpecKeyEvent []UsbScanCodeSpecKeyEvent `xml:"UsbScanCodeSpecKeyEvent,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUsbScanCodeSpecKeyEvent"] = reflect.TypeOf((*ArrayOfUsbScanCodeSpecKeyEvent)(nil)).Elem()
}

// A boxed array of `UserGroupProfile`. To be used in `Any` placeholders.
type ArrayOfUserGroupProfile struct {
	UserGroupProfile []UserGroupProfile `xml:"UserGroupProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUserGroupProfile"] = reflect.TypeOf((*ArrayOfUserGroupProfile)(nil)).Elem()
}

// A boxed array of `UserPrivilegeResult`. To be used in `Any` placeholders.
type ArrayOfUserPrivilegeResult struct {
	UserPrivilegeResult []UserPrivilegeResult `xml:"UserPrivilegeResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUserPrivilegeResult"] = reflect.TypeOf((*ArrayOfUserPrivilegeResult)(nil)).Elem()
}

// A boxed array of `UserProfile`. To be used in `Any` placeholders.
type ArrayOfUserProfile struct {
	UserProfile []UserProfile `xml:"UserProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUserProfile"] = reflect.TypeOf((*ArrayOfUserProfile)(nil)).Elem()
}

// A boxed array of `UserSearchResult`. To be used in `Any` placeholders.
type ArrayOfUserSearchResult struct {
	UserSearchResult []BaseUserSearchResult `xml:"UserSearchResult,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfUserSearchResult"] = reflect.TypeOf((*ArrayOfUserSearchResult)(nil)).Elem()
}

// A boxed array of `UserSession`. To be used in `Any` placeholders.
type ArrayOfUserSession struct {
	UserSession []UserSession `xml:"UserSession,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfUserSession"] = reflect.TypeOf((*ArrayOfUserSession)(nil)).Elem()
}

// A boxed array of `VASAStorageArray`. To be used in `Any` placeholders.
type ArrayOfVASAStorageArray struct {
	VASAStorageArray []VASAStorageArray `xml:"VASAStorageArray,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVASAStorageArray"] = reflect.TypeOf((*ArrayOfVASAStorageArray)(nil)).Elem()
}

// A boxed array of `VASAStorageArrayDiscoverySvcInfo`. To be used in `Any` placeholders.
type ArrayOfVASAStorageArrayDiscoverySvcInfo struct {
	VASAStorageArrayDiscoverySvcInfo []VASAStorageArrayDiscoverySvcInfo `xml:"VASAStorageArrayDiscoverySvcInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVASAStorageArrayDiscoverySvcInfo"] = reflect.TypeOf((*ArrayOfVASAStorageArrayDiscoverySvcInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVASAStorageArrayDiscoverySvcInfo"] = "8.0.0.0"
}

// A boxed array of `VAppCloneSpecNetworkMappingPair`. To be used in `Any` placeholders.
type ArrayOfVAppCloneSpecNetworkMappingPair struct {
	VAppCloneSpecNetworkMappingPair []VAppCloneSpecNetworkMappingPair `xml:"VAppCloneSpecNetworkMappingPair,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppCloneSpecNetworkMappingPair"] = reflect.TypeOf((*ArrayOfVAppCloneSpecNetworkMappingPair)(nil)).Elem()
}

// A boxed array of `VAppCloneSpecResourceMap`. To be used in `Any` placeholders.
type ArrayOfVAppCloneSpecResourceMap struct {
	VAppCloneSpecResourceMap []VAppCloneSpecResourceMap `xml:"VAppCloneSpecResourceMap,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppCloneSpecResourceMap"] = reflect.TypeOf((*ArrayOfVAppCloneSpecResourceMap)(nil)).Elem()
}

// A boxed array of `VAppEntityConfigInfo`. To be used in `Any` placeholders.
type ArrayOfVAppEntityConfigInfo struct {
	VAppEntityConfigInfo []VAppEntityConfigInfo `xml:"VAppEntityConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppEntityConfigInfo"] = reflect.TypeOf((*ArrayOfVAppEntityConfigInfo)(nil)).Elem()
}

// A boxed array of `VAppOvfSectionInfo`. To be used in `Any` placeholders.
type ArrayOfVAppOvfSectionInfo struct {
	VAppOvfSectionInfo []VAppOvfSectionInfo `xml:"VAppOvfSectionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppOvfSectionInfo"] = reflect.TypeOf((*ArrayOfVAppOvfSectionInfo)(nil)).Elem()
}

// A boxed array of `VAppOvfSectionSpec`. To be used in `Any` placeholders.
type ArrayOfVAppOvfSectionSpec struct {
	VAppOvfSectionSpec []VAppOvfSectionSpec `xml:"VAppOvfSectionSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppOvfSectionSpec"] = reflect.TypeOf((*ArrayOfVAppOvfSectionSpec)(nil)).Elem()
}

// A boxed array of `VAppProductInfo`. To be used in `Any` placeholders.
type ArrayOfVAppProductInfo struct {
	VAppProductInfo []VAppProductInfo `xml:"VAppProductInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppProductInfo"] = reflect.TypeOf((*ArrayOfVAppProductInfo)(nil)).Elem()
}

// A boxed array of `VAppProductSpec`. To be used in `Any` placeholders.
type ArrayOfVAppProductSpec struct {
	VAppProductSpec []VAppProductSpec `xml:"VAppProductSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppProductSpec"] = reflect.TypeOf((*ArrayOfVAppProductSpec)(nil)).Elem()
}

// A boxed array of `VAppPropertyInfo`. To be used in `Any` placeholders.
type ArrayOfVAppPropertyInfo struct {
	VAppPropertyInfo []VAppPropertyInfo `xml:"VAppPropertyInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppPropertyInfo"] = reflect.TypeOf((*ArrayOfVAppPropertyInfo)(nil)).Elem()
}

// A boxed array of `VAppPropertySpec`. To be used in `Any` placeholders.
type ArrayOfVAppPropertySpec struct {
	VAppPropertySpec []VAppPropertySpec `xml:"VAppPropertySpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVAppPropertySpec"] = reflect.TypeOf((*ArrayOfVAppPropertySpec)(nil)).Elem()
}

// A boxed array of `VMwareDVSPvlanConfigSpec`. To be used in `Any` placeholders.
type ArrayOfVMwareDVSPvlanConfigSpec struct {
	VMwareDVSPvlanConfigSpec []VMwareDVSPvlanConfigSpec `xml:"VMwareDVSPvlanConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanConfigSpec)(nil)).Elem()
}

// A boxed array of `VMwareDVSPvlanMapEntry`. To be used in `Any` placeholders.
type ArrayOfVMwareDVSPvlanMapEntry struct {
	VMwareDVSPvlanMapEntry []VMwareDVSPvlanMapEntry `xml:"VMwareDVSPvlanMapEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanMapEntry"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanMapEntry)(nil)).Elem()
}

// A boxed array of `VMwareDVSVspanConfigSpec`. To be used in `Any` placeholders.
type ArrayOfVMwareDVSVspanConfigSpec struct {
	VMwareDVSVspanConfigSpec []VMwareDVSVspanConfigSpec `xml:"VMwareDVSVspanConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareDVSVspanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSVspanConfigSpec)(nil)).Elem()
}

// A boxed array of `VMwareDvsLacpGroupConfig`. To be used in `Any` placeholders.
type ArrayOfVMwareDvsLacpGroupConfig struct {
	VMwareDvsLacpGroupConfig []VMwareDvsLacpGroupConfig `xml:"VMwareDvsLacpGroupConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupConfig"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupConfig)(nil)).Elem()
}

// A boxed array of `VMwareDvsLacpGroupSpec`. To be used in `Any` placeholders.
type ArrayOfVMwareDvsLacpGroupSpec struct {
	VMwareDvsLacpGroupSpec []VMwareDvsLacpGroupSpec `xml:"VMwareDvsLacpGroupSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupSpec"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupSpec)(nil)).Elem()
}

// A boxed array of `VMwareVspanSession`. To be used in `Any` placeholders.
type ArrayOfVMwareVspanSession struct {
	VMwareVspanSession []VMwareVspanSession `xml:"VMwareVspanSession,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVMwareVspanSession"] = reflect.TypeOf((*ArrayOfVMwareVspanSession)(nil)).Elem()
}

// A boxed array of `VStorageObjectAssociations`. To be used in `Any` placeholders.
type ArrayOfVStorageObjectAssociations struct {
	VStorageObjectAssociations []VStorageObjectAssociations `xml:"VStorageObjectAssociations,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVStorageObjectAssociations"] = reflect.TypeOf((*ArrayOfVStorageObjectAssociations)(nil)).Elem()
}

// A boxed array of `VStorageObjectAssociationsVmDiskAssociations`. To be used in `Any` placeholders.
type ArrayOfVStorageObjectAssociationsVmDiskAssociations struct {
	VStorageObjectAssociationsVmDiskAssociations []VStorageObjectAssociationsVmDiskAssociations `xml:"VStorageObjectAssociationsVmDiskAssociations,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVStorageObjectAssociationsVmDiskAssociations"] = reflect.TypeOf((*ArrayOfVStorageObjectAssociationsVmDiskAssociations)(nil)).Elem()
}

// A boxed array of `VStorageObjectSnapshotInfoVStorageObjectSnapshot`. To be used in `Any` placeholders.
type ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot struct {
	VStorageObjectSnapshotInfoVStorageObjectSnapshot []VStorageObjectSnapshotInfoVStorageObjectSnapshot `xml:"VStorageObjectSnapshotInfoVStorageObjectSnapshot,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot"] = reflect.TypeOf((*ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot)(nil)).Elem()
}

// A boxed array of `VVolHostPE`. To be used in `Any` placeholders.
type ArrayOfVVolHostPE struct {
	VVolHostPE []VVolHostPE `xml:"VVolHostPE,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVVolHostPE"] = reflect.TypeOf((*ArrayOfVVolHostPE)(nil)).Elem()
}

// A boxed array of `VVolVmConfigFileUpdateResultFailedVmConfigFileInfo`. To be used in `Any` placeholders.
type ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo struct {
	VVolVmConfigFileUpdateResultFailedVmConfigFileInfo []VVolVmConfigFileUpdateResultFailedVmConfigFileInfo `xml:"VVolVmConfigFileUpdateResultFailedVmConfigFileInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo"] = reflect.TypeOf((*ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo)(nil)).Elem()
}

// A boxed array of `VchaNodeRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfVchaNodeRuntimeInfo struct {
	VchaNodeRuntimeInfo []VchaNodeRuntimeInfo `xml:"VchaNodeRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVchaNodeRuntimeInfo"] = reflect.TypeOf((*ArrayOfVchaNodeRuntimeInfo)(nil)).Elem()
}

// A boxed array of `VimVasaProviderInfo`. To be used in `Any` placeholders.
type ArrayOfVimVasaProviderInfo struct {
	VimVasaProviderInfo []VimVasaProviderInfo `xml:"VimVasaProviderInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVimVasaProviderInfo"] = reflect.TypeOf((*ArrayOfVimVasaProviderInfo)(nil)).Elem()
}

// A boxed array of `VimVasaProviderStatePerArray`. To be used in `Any` placeholders.
type ArrayOfVimVasaProviderStatePerArray struct {
	VimVasaProviderStatePerArray []VimVasaProviderStatePerArray `xml:"VimVasaProviderStatePerArray,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVimVasaProviderStatePerArray"] = reflect.TypeOf((*ArrayOfVimVasaProviderStatePerArray)(nil)).Elem()
}

// A boxed array of `VirtualAppLinkInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualAppLinkInfo struct {
	VirtualAppLinkInfo []VirtualAppLinkInfo `xml:"VirtualAppLinkInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualAppLinkInfo"] = reflect.TypeOf((*ArrayOfVirtualAppLinkInfo)(nil)).Elem()
}

// A boxed array of `VirtualDevice`. To be used in `Any` placeholders.
type ArrayOfVirtualDevice struct {
	VirtualDevice []BaseVirtualDevice `xml:"VirtualDevice,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDevice"] = reflect.TypeOf((*ArrayOfVirtualDevice)(nil)).Elem()
}

// A boxed array of `VirtualDeviceBackingOption`. To be used in `Any` placeholders.
type ArrayOfVirtualDeviceBackingOption struct {
	VirtualDeviceBackingOption []BaseVirtualDeviceBackingOption `xml:"VirtualDeviceBackingOption,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDeviceBackingOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceBackingOption)(nil)).Elem()
}

// A boxed array of `VirtualDeviceConfigSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualDeviceConfigSpec struct {
	VirtualDeviceConfigSpec []BaseVirtualDeviceConfigSpec `xml:"VirtualDeviceConfigSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDeviceConfigSpec"] = reflect.TypeOf((*ArrayOfVirtualDeviceConfigSpec)(nil)).Elem()
}

// A boxed array of `VirtualDeviceOption`. To be used in `Any` placeholders.
type ArrayOfVirtualDeviceOption struct {
	VirtualDeviceOption []BaseVirtualDeviceOption `xml:"VirtualDeviceOption,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDeviceOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceOption)(nil)).Elem()
}

// A boxed array of `VirtualDisk`. To be used in `Any` placeholders.
type ArrayOfVirtualDisk struct {
	VirtualDisk []VirtualDisk `xml:"VirtualDisk,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDisk"] = reflect.TypeOf((*ArrayOfVirtualDisk)(nil)).Elem()
}

// A boxed array of `VirtualDiskDeltaDiskFormatsSupported`. To be used in `Any` placeholders.
type ArrayOfVirtualDiskDeltaDiskFormatsSupported struct {
	VirtualDiskDeltaDiskFormatsSupported []VirtualDiskDeltaDiskFormatsSupported `xml:"VirtualDiskDeltaDiskFormatsSupported,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDiskDeltaDiskFormatsSupported"] = reflect.TypeOf((*ArrayOfVirtualDiskDeltaDiskFormatsSupported)(nil)).Elem()
}

// A boxed array of `VirtualDiskId`. To be used in `Any` placeholders.
type ArrayOfVirtualDiskId struct {
	VirtualDiskId []VirtualDiskId `xml:"VirtualDiskId,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDiskId"] = reflect.TypeOf((*ArrayOfVirtualDiskId)(nil)).Elem()
}

// A boxed array of `VirtualDiskRuleSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualDiskRuleSpec struct {
	VirtualDiskRuleSpec []VirtualDiskRuleSpec `xml:"VirtualDiskRuleSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualDiskRuleSpec"] = reflect.TypeOf((*ArrayOfVirtualDiskRuleSpec)(nil)).Elem()
}

// A boxed array of `VirtualMachineBaseIndependentFilterSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineBaseIndependentFilterSpec struct {
	VirtualMachineBaseIndependentFilterSpec []BaseVirtualMachineBaseIndependentFilterSpec `xml:"VirtualMachineBaseIndependentFilterSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineBaseIndependentFilterSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineBaseIndependentFilterSpec)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineBaseIndependentFilterSpec"] = "7.0.2.1"
}

// A boxed array of `VirtualMachineBootOptionsBootableDevice`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineBootOptionsBootableDevice struct {
	VirtualMachineBootOptionsBootableDevice []BaseVirtualMachineBootOptionsBootableDevice `xml:"VirtualMachineBootOptionsBootableDevice,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineBootOptionsBootableDevice"] = reflect.TypeOf((*ArrayOfVirtualMachineBootOptionsBootableDevice)(nil)).Elem()
}

// A boxed array of `VirtualMachineCdromInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineCdromInfo struct {
	VirtualMachineCdromInfo []VirtualMachineCdromInfo `xml:"VirtualMachineCdromInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineCdromInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineCdromInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineCertThumbprint`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineCertThumbprint struct {
	VirtualMachineCertThumbprint []VirtualMachineCertThumbprint `xml:"VirtualMachineCertThumbprint,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineCertThumbprint"] = reflect.TypeOf((*ArrayOfVirtualMachineCertThumbprint)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineCertThumbprint"] = "7.0.3.1"
}

// A boxed array of `VirtualMachineConfigInfoDatastoreUrlPair`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineConfigInfoDatastoreUrlPair struct {
	VirtualMachineConfigInfoDatastoreUrlPair []VirtualMachineConfigInfoDatastoreUrlPair `xml:"VirtualMachineConfigInfoDatastoreUrlPair,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineConfigInfoDatastoreUrlPair"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigInfoDatastoreUrlPair)(nil)).Elem()
}

// A boxed array of `VirtualMachineConfigOptionDescriptor`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineConfigOptionDescriptor struct {
	VirtualMachineConfigOptionDescriptor []VirtualMachineConfigOptionDescriptor `xml:"VirtualMachineConfigOptionDescriptor,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineConfigOptionDescriptor"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigOptionDescriptor)(nil)).Elem()
}

// A boxed array of `VirtualMachineConfigSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineConfigSpec struct {
	VirtualMachineConfigSpec []VirtualMachineConfigSpec `xml:"VirtualMachineConfigSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineConfigSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigSpec)(nil)).Elem()
}

// A boxed array of `VirtualMachineConnection`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineConnection struct {
	VirtualMachineConnection []BaseVirtualMachineConnection `xml:"VirtualMachineConnection,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineConnection"] = reflect.TypeOf((*ArrayOfVirtualMachineConnection)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineConnection"] = "7.0.1.0"
}

// A boxed array of `VirtualMachineCpuIdInfoSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineCpuIdInfoSpec struct {
	VirtualMachineCpuIdInfoSpec []VirtualMachineCpuIdInfoSpec `xml:"VirtualMachineCpuIdInfoSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineCpuIdInfoSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineCpuIdInfoSpec)(nil)).Elem()
}

// A boxed array of `VirtualMachineDatastoreInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDatastoreInfo struct {
	VirtualMachineDatastoreInfo []VirtualMachineDatastoreInfo `xml:"VirtualMachineDatastoreInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineDatastoreVolumeOption`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDatastoreVolumeOption struct {
	VirtualMachineDatastoreVolumeOption []VirtualMachineDatastoreVolumeOption `xml:"VirtualMachineDatastoreVolumeOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreVolumeOption"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreVolumeOption)(nil)).Elem()
}

// A boxed array of `VirtualMachineDeviceRuntimeInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDeviceRuntimeInfo struct {
	VirtualMachineDeviceRuntimeInfo []VirtualMachineDeviceRuntimeInfo `xml:"VirtualMachineDeviceRuntimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDeviceRuntimeInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDeviceRuntimeInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineDisplayTopology`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDisplayTopology struct {
	VirtualMachineDisplayTopology []VirtualMachineDisplayTopology `xml:"VirtualMachineDisplayTopology,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDisplayTopology"] = reflect.TypeOf((*ArrayOfVirtualMachineDisplayTopology)(nil)).Elem()
}

// A boxed array of `VirtualMachineDvxClassInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDvxClassInfo struct {
	VirtualMachineDvxClassInfo []VirtualMachineDvxClassInfo `xml:"VirtualMachineDvxClassInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDvxClassInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDvxClassInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineDvxClassInfo"] = "8.0.0.1"
}

// A boxed array of `VirtualMachineDynamicPassthroughInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineDynamicPassthroughInfo struct {
	VirtualMachineDynamicPassthroughInfo []VirtualMachineDynamicPassthroughInfo `xml:"VirtualMachineDynamicPassthroughInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineDynamicPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDynamicPassthroughInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineFeatureRequirement`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFeatureRequirement struct {
	VirtualMachineFeatureRequirement []VirtualMachineFeatureRequirement `xml:"VirtualMachineFeatureRequirement,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFeatureRequirement"] = reflect.TypeOf((*ArrayOfVirtualMachineFeatureRequirement)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutDiskLayout`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutDiskLayout struct {
	VirtualMachineFileLayoutDiskLayout []VirtualMachineFileLayoutDiskLayout `xml:"VirtualMachineFileLayoutDiskLayout,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutDiskLayout)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutExDiskLayout`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutExDiskLayout struct {
	VirtualMachineFileLayoutExDiskLayout []VirtualMachineFileLayoutExDiskLayout `xml:"VirtualMachineFileLayoutExDiskLayout,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskLayout)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutExDiskUnit`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutExDiskUnit struct {
	VirtualMachineFileLayoutExDiskUnit []VirtualMachineFileLayoutExDiskUnit `xml:"VirtualMachineFileLayoutExDiskUnit,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskUnit"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskUnit)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutExFileInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutExFileInfo struct {
	VirtualMachineFileLayoutExFileInfo []VirtualMachineFileLayoutExFileInfo `xml:"VirtualMachineFileLayoutExFileInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExFileInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExFileInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutExSnapshotLayout`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutExSnapshotLayout struct {
	VirtualMachineFileLayoutExSnapshotLayout []VirtualMachineFileLayoutExSnapshotLayout `xml:"VirtualMachineFileLayoutExSnapshotLayout,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExSnapshotLayout)(nil)).Elem()
}

// A boxed array of `VirtualMachineFileLayoutSnapshotLayout`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFileLayoutSnapshotLayout struct {
	VirtualMachineFileLayoutSnapshotLayout []VirtualMachineFileLayoutSnapshotLayout `xml:"VirtualMachineFileLayoutSnapshotLayout,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutSnapshotLayout)(nil)).Elem()
}

// A boxed array of `VirtualMachineFloppyInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineFloppyInfo struct {
	VirtualMachineFloppyInfo []VirtualMachineFloppyInfo `xml:"VirtualMachineFloppyInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineFloppyInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFloppyInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineIdeDiskDeviceInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineIdeDiskDeviceInfo struct {
	VirtualMachineIdeDiskDeviceInfo []VirtualMachineIdeDiskDeviceInfo `xml:"VirtualMachineIdeDiskDeviceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDeviceInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineIdeDiskDevicePartitionInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineIdeDiskDevicePartitionInfo struct {
	VirtualMachineIdeDiskDevicePartitionInfo []VirtualMachineIdeDiskDevicePartitionInfo `xml:"VirtualMachineIdeDiskDevicePartitionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDevicePartitionInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDevicePartitionInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineLegacyNetworkSwitchInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineLegacyNetworkSwitchInfo struct {
	VirtualMachineLegacyNetworkSwitchInfo []VirtualMachineLegacyNetworkSwitchInfo `xml:"VirtualMachineLegacyNetworkSwitchInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineLegacyNetworkSwitchInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineLegacyNetworkSwitchInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineMessage`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineMessage struct {
	VirtualMachineMessage []VirtualMachineMessage `xml:"VirtualMachineMessage,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineMessage"] = reflect.TypeOf((*ArrayOfVirtualMachineMessage)(nil)).Elem()
}

// A boxed array of `VirtualMachineMetadataManagerVmMetadataInput`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineMetadataManagerVmMetadataInput struct {
	VirtualMachineMetadataManagerVmMetadataInput []VirtualMachineMetadataManagerVmMetadataInput `xml:"VirtualMachineMetadataManagerVmMetadataInput,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataInput"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataInput)(nil)).Elem()
}

// A boxed array of `VirtualMachineMetadataManagerVmMetadataResult`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineMetadataManagerVmMetadataResult struct {
	VirtualMachineMetadataManagerVmMetadataResult []VirtualMachineMetadataManagerVmMetadataResult `xml:"VirtualMachineMetadataManagerVmMetadataResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataResult"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataResult)(nil)).Elem()
}

// A boxed array of `VirtualMachineNetworkInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineNetworkInfo struct {
	VirtualMachineNetworkInfo []VirtualMachineNetworkInfo `xml:"VirtualMachineNetworkInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineNetworkInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineNetworkInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineParallelInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineParallelInfo struct {
	VirtualMachineParallelInfo []VirtualMachineParallelInfo `xml:"VirtualMachineParallelInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineParallelInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineParallelInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachinePciPassthroughInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachinePciPassthroughInfo struct {
	VirtualMachinePciPassthroughInfo []BaseVirtualMachinePciPassthroughInfo `xml:"VirtualMachinePciPassthroughInfo,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachinePciPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePciPassthroughInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachinePciSharedGpuPassthroughInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachinePciSharedGpuPassthroughInfo struct {
	VirtualMachinePciSharedGpuPassthroughInfo []VirtualMachinePciSharedGpuPassthroughInfo `xml:"VirtualMachinePciSharedGpuPassthroughInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachinePciSharedGpuPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePciSharedGpuPassthroughInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachinePrecisionClockInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachinePrecisionClockInfo struct {
	VirtualMachinePrecisionClockInfo []VirtualMachinePrecisionClockInfo `xml:"VirtualMachinePrecisionClockInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachinePrecisionClockInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePrecisionClockInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineProfileDetailsDiskProfileDetails`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineProfileDetailsDiskProfileDetails struct {
	VirtualMachineProfileDetailsDiskProfileDetails []VirtualMachineProfileDetailsDiskProfileDetails `xml:"VirtualMachineProfileDetailsDiskProfileDetails,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineProfileDetailsDiskProfileDetails"] = reflect.TypeOf((*ArrayOfVirtualMachineProfileDetailsDiskProfileDetails)(nil)).Elem()
}

// A boxed array of `VirtualMachineProfileSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineProfileSpec struct {
	VirtualMachineProfileSpec []BaseVirtualMachineProfileSpec `xml:"VirtualMachineProfileSpec,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineProfileSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineProfileSpec)(nil)).Elem()
}

// A boxed array of `VirtualMachinePropertyRelation`. To be used in `Any` placeholders.
type ArrayOfVirtualMachinePropertyRelation struct {
	VirtualMachinePropertyRelation []VirtualMachinePropertyRelation `xml:"VirtualMachinePropertyRelation,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachinePropertyRelation"] = reflect.TypeOf((*ArrayOfVirtualMachinePropertyRelation)(nil)).Elem()
}

// A boxed array of `VirtualMachineQuickStatsMemoryTierStats`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineQuickStatsMemoryTierStats struct {
	VirtualMachineQuickStatsMemoryTierStats []VirtualMachineQuickStatsMemoryTierStats `xml:"VirtualMachineQuickStatsMemoryTierStats,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineQuickStatsMemoryTierStats"] = reflect.TypeOf((*ArrayOfVirtualMachineQuickStatsMemoryTierStats)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineQuickStatsMemoryTierStats"] = "7.0.3.0"
}

// A boxed array of `VirtualMachineRelocateSpecDiskLocator`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineRelocateSpecDiskLocator struct {
	VirtualMachineRelocateSpecDiskLocator []VirtualMachineRelocateSpecDiskLocator `xml:"VirtualMachineRelocateSpecDiskLocator,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineRelocateSpecDiskLocator"] = reflect.TypeOf((*ArrayOfVirtualMachineRelocateSpecDiskLocator)(nil)).Elem()
}

// A boxed array of `VirtualMachineScsiDiskDeviceInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineScsiDiskDeviceInfo struct {
	VirtualMachineScsiDiskDeviceInfo []VirtualMachineScsiDiskDeviceInfo `xml:"VirtualMachineScsiDiskDeviceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineScsiDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiDiskDeviceInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineScsiPassthroughInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineScsiPassthroughInfo struct {
	VirtualMachineScsiPassthroughInfo []VirtualMachineScsiPassthroughInfo `xml:"VirtualMachineScsiPassthroughInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineScsiPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiPassthroughInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineSerialInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineSerialInfo struct {
	VirtualMachineSerialInfo []VirtualMachineSerialInfo `xml:"VirtualMachineSerialInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineSerialInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSerialInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineSnapshotTree`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineSnapshotTree struct {
	VirtualMachineSnapshotTree []VirtualMachineSnapshotTree `xml:"VirtualMachineSnapshotTree,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineSnapshotTree"] = reflect.TypeOf((*ArrayOfVirtualMachineSnapshotTree)(nil)).Elem()
}

// A boxed array of `VirtualMachineSoundInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineSoundInfo struct {
	VirtualMachineSoundInfo []VirtualMachineSoundInfo `xml:"VirtualMachineSoundInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineSoundInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSoundInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineSriovInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineSriovInfo struct {
	VirtualMachineSriovInfo []VirtualMachineSriovInfo `xml:"VirtualMachineSriovInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineSriovInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSriovInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineSummary`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineSummary struct {
	VirtualMachineSummary []VirtualMachineSummary `xml:"VirtualMachineSummary,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineSummary"] = reflect.TypeOf((*ArrayOfVirtualMachineSummary)(nil)).Elem()
}

// A boxed array of `VirtualMachineUsageOnDatastore`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineUsageOnDatastore struct {
	VirtualMachineUsageOnDatastore []VirtualMachineUsageOnDatastore `xml:"VirtualMachineUsageOnDatastore,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineUsageOnDatastore"] = reflect.TypeOf((*ArrayOfVirtualMachineUsageOnDatastore)(nil)).Elem()
}

// A boxed array of `VirtualMachineUsbInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineUsbInfo struct {
	VirtualMachineUsbInfo []VirtualMachineUsbInfo `xml:"VirtualMachineUsbInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineUsbInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineUsbInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineVFlashModuleInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVFlashModuleInfo struct {
	VirtualMachineVFlashModuleInfo []VirtualMachineVFlashModuleInfo `xml:"VirtualMachineVFlashModuleInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVFlashModuleInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVFlashModuleInfo)(nil)).Elem()
}

// A boxed array of `VirtualMachineVMCIDeviceFilterSpec`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVMCIDeviceFilterSpec struct {
	VirtualMachineVMCIDeviceFilterSpec []VirtualMachineVMCIDeviceFilterSpec `xml:"VirtualMachineVMCIDeviceFilterSpec,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVMCIDeviceFilterSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineVMCIDeviceFilterSpec)(nil)).Elem()
}

// A boxed array of `VirtualMachineVMotionStunTimeInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVMotionStunTimeInfo struct {
	VirtualMachineVMotionStunTimeInfo []VirtualMachineVMotionStunTimeInfo `xml:"VirtualMachineVMotionStunTimeInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVMotionStunTimeInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVMotionStunTimeInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineVMotionStunTimeInfo"] = "8.0.2.0"
}

// A boxed array of `VirtualMachineVcpuConfig`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVcpuConfig struct {
	VirtualMachineVcpuConfig []VirtualMachineVcpuConfig `xml:"VirtualMachineVcpuConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVcpuConfig"] = reflect.TypeOf((*ArrayOfVirtualMachineVcpuConfig)(nil)).Elem()
}

// A boxed array of `VirtualMachineVendorDeviceGroupInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVendorDeviceGroupInfo struct {
	VirtualMachineVendorDeviceGroupInfo []VirtualMachineVendorDeviceGroupInfo `xml:"VirtualMachineVendorDeviceGroupInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVendorDeviceGroupInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVendorDeviceGroupInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineVendorDeviceGroupInfo"] = "8.0.0.1"
}

// A boxed array of `VirtualMachineVendorDeviceGroupInfoComponentDeviceInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVendorDeviceGroupInfoComponentDeviceInfo struct {
	VirtualMachineVendorDeviceGroupInfoComponentDeviceInfo []VirtualMachineVendorDeviceGroupInfoComponentDeviceInfo `xml:"VirtualMachineVendorDeviceGroupInfoComponentDeviceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVendorDeviceGroupInfoComponentDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVendorDeviceGroupInfoComponentDeviceInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineVendorDeviceGroupInfoComponentDeviceInfo"] = "8.0.0.1"
}

// A boxed array of `VirtualMachineVgpuDeviceInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVgpuDeviceInfo struct {
	VirtualMachineVgpuDeviceInfo []VirtualMachineVgpuDeviceInfo `xml:"VirtualMachineVgpuDeviceInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVgpuDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVgpuDeviceInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineVgpuDeviceInfo"] = "7.0.3.0"
}

// A boxed array of `VirtualMachineVgpuProfileInfo`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVgpuProfileInfo struct {
	VirtualMachineVgpuProfileInfo []VirtualMachineVgpuProfileInfo `xml:"VirtualMachineVgpuProfileInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVgpuProfileInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVgpuProfileInfo)(nil)).Elem()
	minAPIVersionForType["ArrayOfVirtualMachineVgpuProfileInfo"] = "7.0.3.0"
}

// A boxed array of `VirtualMachineVirtualDeviceGroupsDeviceGroup`. To be used in `Any` placeholders.
type ArrayOfVirtualMachineVirtualDeviceGroupsDeviceGroup struct {
	VirtualMachineVirtualDeviceGroupsDeviceGroup []BaseVirtualMachineVirtualDeviceGroupsDeviceGroup `xml:"VirtualMachineVirtualDeviceGroupsDeviceGroup,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVirtualMachineVirtualDeviceGroupsDeviceGroup"] = reflect.TypeOf((*ArrayOfVirtualMachineVirtualDeviceGroupsDeviceGroup)(nil)).Elem()
}

// A boxed array of `VirtualNicManagerNetConfig`. To be used in `Any` placeholders.
type ArrayOfVirtualNicManagerNetConfig struct {
	VirtualNicManagerNetConfig []VirtualNicManagerNetConfig `xml:"VirtualNicManagerNetConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualNicManagerNetConfig"] = reflect.TypeOf((*ArrayOfVirtualNicManagerNetConfig)(nil)).Elem()
}

// A boxed array of `VirtualPCIPassthroughAllowedDevice`. To be used in `Any` placeholders.
type ArrayOfVirtualPCIPassthroughAllowedDevice struct {
	VirtualPCIPassthroughAllowedDevice []VirtualPCIPassthroughAllowedDevice `xml:"VirtualPCIPassthroughAllowedDevice,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualPCIPassthroughAllowedDevice"] = reflect.TypeOf((*ArrayOfVirtualPCIPassthroughAllowedDevice)(nil)).Elem()
}

// A boxed array of `VirtualSCSISharing_enum`. To be used in `Any` placeholders.
type ArrayOfVirtualSCSISharing struct {
	VirtualSCSISharing []VirtualSCSISharing `xml:"VirtualSCSISharing,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualSCSISharing"] = reflect.TypeOf((*ArrayOfVirtualSCSISharing)(nil)).Elem()
}

// A boxed array of `VirtualSwitchProfile`. To be used in `Any` placeholders.
type ArrayOfVirtualSwitchProfile struct {
	VirtualSwitchProfile []VirtualSwitchProfile `xml:"VirtualSwitchProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVirtualSwitchProfile"] = reflect.TypeOf((*ArrayOfVirtualSwitchProfile)(nil)).Elem()
}

// A boxed array of `VmEventArgument`. To be used in `Any` placeholders.
type ArrayOfVmEventArgument struct {
	VmEventArgument []VmEventArgument `xml:"VmEventArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVmEventArgument"] = reflect.TypeOf((*ArrayOfVmEventArgument)(nil)).Elem()
}

// A boxed array of `VmPodConfigForPlacement`. To be used in `Any` placeholders.
type ArrayOfVmPodConfigForPlacement struct {
	VmPodConfigForPlacement []VmPodConfigForPlacement `xml:"VmPodConfigForPlacement,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVmPodConfigForPlacement"] = reflect.TypeOf((*ArrayOfVmPodConfigForPlacement)(nil)).Elem()
}

// A boxed array of `VmPortGroupProfile`. To be used in `Any` placeholders.
type ArrayOfVmPortGroupProfile struct {
	VmPortGroupProfile []VmPortGroupProfile `xml:"VmPortGroupProfile,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVmPortGroupProfile"] = reflect.TypeOf((*ArrayOfVmPortGroupProfile)(nil)).Elem()
}

// A boxed array of `VmfsConfigOption`. To be used in `Any` placeholders.
type ArrayOfVmfsConfigOption struct {
	VmfsConfigOption []VmfsConfigOption `xml:"VmfsConfigOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVmfsConfigOption"] = reflect.TypeOf((*ArrayOfVmfsConfigOption)(nil)).Elem()
}

// A boxed array of `VmfsDatastoreOption`. To be used in `Any` placeholders.
type ArrayOfVmfsDatastoreOption struct {
	VmfsDatastoreOption []VmfsDatastoreOption `xml:"VmfsDatastoreOption,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVmfsDatastoreOption"] = reflect.TypeOf((*ArrayOfVmfsDatastoreOption)(nil)).Elem()
}

// A boxed array of `VnicPortArgument`. To be used in `Any` placeholders.
type ArrayOfVnicPortArgument struct {
	VnicPortArgument []VnicPortArgument `xml:"VnicPortArgument,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVnicPortArgument"] = reflect.TypeOf((*ArrayOfVnicPortArgument)(nil)).Elem()
}

// A boxed array of `VsanHostConfigInfo`. To be used in `Any` placeholders.
type ArrayOfVsanHostConfigInfo struct {
	VsanHostConfigInfo []VsanHostConfigInfo `xml:"VsanHostConfigInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostConfigInfo"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfo)(nil)).Elem()
}

// A boxed array of `VsanHostConfigInfoNetworkInfoPortConfig`. To be used in `Any` placeholders.
type ArrayOfVsanHostConfigInfoNetworkInfoPortConfig struct {
	VsanHostConfigInfoNetworkInfoPortConfig []VsanHostConfigInfoNetworkInfoPortConfig `xml:"VsanHostConfigInfoNetworkInfoPortConfig,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostConfigInfoNetworkInfoPortConfig"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfoNetworkInfoPortConfig)(nil)).Elem()
}

// A boxed array of `VsanHostDiskMapInfo`. To be used in `Any` placeholders.
type ArrayOfVsanHostDiskMapInfo struct {
	VsanHostDiskMapInfo []VsanHostDiskMapInfo `xml:"VsanHostDiskMapInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostDiskMapInfo"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapInfo)(nil)).Elem()
}

// A boxed array of `VsanHostDiskMapResult`. To be used in `Any` placeholders.
type ArrayOfVsanHostDiskMapResult struct {
	VsanHostDiskMapResult []VsanHostDiskMapResult `xml:"VsanHostDiskMapResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostDiskMapResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapResult)(nil)).Elem()
}

// A boxed array of `VsanHostDiskMapping`. To be used in `Any` placeholders.
type ArrayOfVsanHostDiskMapping struct {
	VsanHostDiskMapping []VsanHostDiskMapping `xml:"VsanHostDiskMapping,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostDiskMapping"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapping)(nil)).Elem()
}

// A boxed array of `VsanHostDiskResult`. To be used in `Any` placeholders.
type ArrayOfVsanHostDiskResult struct {
	VsanHostDiskResult []VsanHostDiskResult `xml:"VsanHostDiskResult,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostDiskResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskResult)(nil)).Elem()
}

// A boxed array of `VsanHostMembershipInfo`. To be used in `Any` placeholders.
type ArrayOfVsanHostMembershipInfo struct {
	VsanHostMembershipInfo []VsanHostMembershipInfo `xml:"VsanHostMembershipInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostMembershipInfo"] = reflect.TypeOf((*ArrayOfVsanHostMembershipInfo)(nil)).Elem()
}

// A boxed array of `VsanHostRuntimeInfoDiskIssue`. To be used in `Any` placeholders.
type ArrayOfVsanHostRuntimeInfoDiskIssue struct {
	VsanHostRuntimeInfoDiskIssue []VsanHostRuntimeInfoDiskIssue `xml:"VsanHostRuntimeInfoDiskIssue,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanHostRuntimeInfoDiskIssue"] = reflect.TypeOf((*ArrayOfVsanHostRuntimeInfoDiskIssue)(nil)).Elem()
}

// A boxed array of `VsanNewPolicyBatch`. To be used in `Any` placeholders.
type ArrayOfVsanNewPolicyBatch struct {
	VsanNewPolicyBatch []VsanNewPolicyBatch `xml:"VsanNewPolicyBatch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanNewPolicyBatch"] = reflect.TypeOf((*ArrayOfVsanNewPolicyBatch)(nil)).Elem()
}

// A boxed array of `VsanPolicyChangeBatch`. To be used in `Any` placeholders.
type ArrayOfVsanPolicyChangeBatch struct {
	VsanPolicyChangeBatch []VsanPolicyChangeBatch `xml:"VsanPolicyChangeBatch,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanPolicyChangeBatch"] = reflect.TypeOf((*ArrayOfVsanPolicyChangeBatch)(nil)).Elem()
}

// A boxed array of `VsanPolicySatisfiability`. To be used in `Any` placeholders.
type ArrayOfVsanPolicySatisfiability struct {
	VsanPolicySatisfiability []VsanPolicySatisfiability `xml:"VsanPolicySatisfiability,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanPolicySatisfiability"] = reflect.TypeOf((*ArrayOfVsanPolicySatisfiability)(nil)).Elem()
}

// A boxed array of `VsanUpgradeSystemNetworkPartitionInfo`. To be used in `Any` placeholders.
type ArrayOfVsanUpgradeSystemNetworkPartitionInfo struct {
	VsanUpgradeSystemNetworkPartitionInfo []VsanUpgradeSystemNetworkPartitionInfo `xml:"VsanUpgradeSystemNetworkPartitionInfo,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemNetworkPartitionInfo"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemNetworkPartitionInfo)(nil)).Elem()
}

// A boxed array of `VsanUpgradeSystemPreflightCheckIssue`. To be used in `Any` placeholders.
type ArrayOfVsanUpgradeSystemPreflightCheckIssue struct {
	VsanUpgradeSystemPreflightCheckIssue []BaseVsanUpgradeSystemPreflightCheckIssue `xml:"VsanUpgradeSystemPreflightCheckIssue,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemPreflightCheckIssue"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemPreflightCheckIssue)(nil)).Elem()
}

// A boxed array of `VsanUpgradeSystemUpgradeHistoryItem`. To be used in `Any` placeholders.
type ArrayOfVsanUpgradeSystemUpgradeHistoryItem struct {
	VsanUpgradeSystemUpgradeHistoryItem []BaseVsanUpgradeSystemUpgradeHistoryItem `xml:"VsanUpgradeSystemUpgradeHistoryItem,omitempty,typeattr" json:"_value"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemUpgradeHistoryItem"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemUpgradeHistoryItem)(nil)).Elem()
}

// A boxed array of `VslmTagEntry`. To be used in `Any` placeholders.
type ArrayOfVslmTagEntry struct {
	VslmTagEntry []VslmTagEntry `xml:"VslmTagEntry,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfVslmTagEntry"] = reflect.TypeOf((*ArrayOfVslmTagEntry)(nil)).Elem()
}

type ArrayOfVslmInfrastructureObjectPolicy struct {
	VslmInfrastructureObjectPolicy []VslmInfrastructureObjectPolicy `xml:"vslmInfrastructureObjectPolicy,omitempty" json:"_value"`
}

func init() {
	t["ArrayOfvslmInfrastructureObjectPolicy"] = reflect.TypeOf((*ArrayOfVslmInfrastructureObjectPolicy)(nil)).Elem()
}

// An ArrayUpdateSpec data object type is a common superclass
// for supporting incremental updates to arrays.
//
// The common code pattern is:
//
//	class MyTypeSpec extrends ArrayUpdateSpec {
//	      MyTypeInfo info;
//	}
//
// The ArrayUpdateSpec contains the following:
//   - `*operation*`: the type of operation being performed.
//   - `*removeKey*`: In the case of a remove operation, the
//     key value that identifies the array to be removed.
type ArrayUpdateSpec struct {
	DynamicData

	// The type of operation being performed on the specified virtual device.
	Operation ArrayUpdateOperation `xml:"operation" json:"operation"`
	// Key for the element to be removed.
	//
	// Only used if the operation
	// is "remove".
	RemoveKey AnyType `xml:"removeKey,omitempty,typeattr" json:"removeKey,omitempty"`
}

func init() {
	t["ArrayUpdateSpec"] = reflect.TypeOf((*ArrayUpdateSpec)(nil)).Elem()
}

type AssignUserToGroup AssignUserToGroupRequestType

func init() {
	t["AssignUserToGroup"] = reflect.TypeOf((*AssignUserToGroup)(nil)).Elem()
}

// The parameters of `HostLocalAccountManager.AssignUserToGroup`.
type AssignUserToGroupRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// User ID of the account whose group membership is
	// being assigned.
	User string `xml:"user" json:"user"`
	// Destination group account to which the user is
	// being assigned.
	Group string `xml:"group" json:"group"`
}

func init() {
	t["AssignUserToGroupRequestType"] = reflect.TypeOf((*AssignUserToGroupRequestType)(nil)).Elem()
}

type AssignUserToGroupResponse struct {
}

type AssociateProfile AssociateProfileRequestType

func init() {
	t["AssociateProfile"] = reflect.TypeOf((*AssociateProfile)(nil)).Elem()
}

// The parameters of `Profile.AssociateProfile`.
type AssociateProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The entity(s) to associate with the profile.
	// If an entity is already associated with the profile, the association is
	// maintained and the vCenter Server does not perform any action.
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["AssociateProfileRequestType"] = reflect.TypeOf((*AssociateProfileRequestType)(nil)).Elem()
}

type AssociateProfileResponse struct {
}

// The parameters of `VirtualMachine.AttachDisk_Task`.
type AttachDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual disk to be operated. See
	// `ID`
	DiskId ID `xml:"diskId" json:"diskId"`
	// The datastore where the virtual disk is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// Key of the controller the disk will connect to.
	// It can be unset if there is only one controller
	// (SCSI or SATA) with the available slot in the
	// virtual machine. If there are multiple SCSI or
	// SATA controllers available, user must specify
	// the controller; if there is no available
	// controllers, a `MissingController`
	// fault will be thrown.
	ControllerKey int32 `xml:"controllerKey,omitempty" json:"controllerKey,omitempty"`
	// The unit number of the attached disk on its controller.
	// If unset, the next available slot on the specified
	// controller or the only available controller will be
	// assigned to the attached disk.
	UnitNumber *int32 `xml:"unitNumber" json:"unitNumber,omitempty"`
}

func init() {
	t["AttachDiskRequestType"] = reflect.TypeOf((*AttachDiskRequestType)(nil)).Elem()
}

type AttachDisk_Task AttachDiskRequestType

func init() {
	t["AttachDisk_Task"] = reflect.TypeOf((*AttachDisk_Task)(nil)).Elem()
}

type AttachDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type AttachScsiLun AttachScsiLunRequestType

func init() {
	t["AttachScsiLun"] = reflect.TypeOf((*AttachScsiLun)(nil)).Elem()
}

// The parameters of `HostStorageSystem.AttachScsiLunEx_Task`.
type AttachScsiLunExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// each element specifies UUID of LUN to be attached.
	LunUuid []string `xml:"lunUuid" json:"lunUuid"`
}

func init() {
	t["AttachScsiLunExRequestType"] = reflect.TypeOf((*AttachScsiLunExRequestType)(nil)).Elem()
}

type AttachScsiLunEx_Task AttachScsiLunExRequestType

func init() {
	t["AttachScsiLunEx_Task"] = reflect.TypeOf((*AttachScsiLunEx_Task)(nil)).Elem()
}

type AttachScsiLunEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostStorageSystem.AttachScsiLun`.
type AttachScsiLunRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The uuid of the ScsiLun to update.
	LunUuid string `xml:"lunUuid" json:"lunUuid"`
}

func init() {
	t["AttachScsiLunRequestType"] = reflect.TypeOf((*AttachScsiLunRequestType)(nil)).Elem()
}

type AttachScsiLunResponse struct {
}

type AttachTagToVStorageObject AttachTagToVStorageObjectRequestType

func init() {
	t["AttachTagToVStorageObject"] = reflect.TypeOf((*AttachTagToVStorageObject)(nil)).Elem()
}

// The parameters of `VcenterVStorageObjectManager.AttachTagToVStorageObject`.
type AttachTagToVStorageObjectRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The identifier(ID) of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The category to which the tag belongs.
	Category string `xml:"category" json:"category"`
	// The tag which has to be associated with the virtual storage
	// object.
	Tag string `xml:"tag" json:"tag"`
}

func init() {
	t["AttachTagToVStorageObjectRequestType"] = reflect.TypeOf((*AttachTagToVStorageObjectRequestType)(nil)).Elem()
}

type AttachTagToVStorageObjectResponse struct {
}

type AttachVmfsExtent AttachVmfsExtentRequestType

func init() {
	t["AttachVmfsExtent"] = reflect.TypeOf((*AttachVmfsExtent)(nil)).Elem()
}

// The parameters of `HostStorageSystem.AttachVmfsExtent`.
type AttachVmfsExtentRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The path of the VMFS to extend. See `FileSystemMountInfo`.
	VmfsPath string `xml:"vmfsPath" json:"vmfsPath"`
	// A data object that describes the specification of a
	// Disk partition.
	Extent HostScsiDiskPartition `xml:"extent" json:"extent"`
}

func init() {
	t["AttachVmfsExtentRequestType"] = reflect.TypeOf((*AttachVmfsExtentRequestType)(nil)).Elem()
}

type AttachVmfsExtentResponse struct {
}

// This fault is thrown when the requested change
// would result in a loss of full administrative privileges
// for at least one user or group.
type AuthMinimumAdminPermission struct {
	VimFault
}

func init() {
	t["AuthMinimumAdminPermission"] = reflect.TypeOf((*AuthMinimumAdminPermission)(nil)).Elem()
}

type AuthMinimumAdminPermissionFault AuthMinimumAdminPermission

func init() {
	t["AuthMinimumAdminPermissionFault"] = reflect.TypeOf((*AuthMinimumAdminPermissionFault)(nil)).Elem()
}

// The `AuthenticationProfile` data object represents the host configuration
// for authentication.
//
// If a profile plug-in defines policies or subprofiles, use the
// `ApplyProfile.policy` or `ApplyProfile.property`
// list to access the additional configuration data.
type AuthenticationProfile struct {
	ApplyProfile

	// Subprofile representing the Active Directory configuration.
	ActiveDirectory *ActiveDirectoryProfile `xml:"activeDirectory,omitempty" json:"activeDirectory,omitempty"`
}

func init() {
	t["AuthenticationProfile"] = reflect.TypeOf((*AuthenticationProfile)(nil)).Elem()
}

// Static strings for authorization.
type AuthorizationDescription struct {
	DynamicData

	// Description of the privilege.
	Privilege []BaseElementDescription `xml:"privilege,typeattr" json:"privilege"`
	// Description of a category of similar privileges, grouped
	// together for convenience.
	PrivilegeGroup []BaseElementDescription `xml:"privilegeGroup,typeattr" json:"privilegeGroup"`
}

func init() {
	t["AuthorizationDescription"] = reflect.TypeOf((*AuthorizationDescription)(nil)).Elem()
}

// These events indicate authorization events.
type AuthorizationEvent struct {
	Event
}

func init() {
	t["AuthorizationEvent"] = reflect.TypeOf((*AuthorizationEvent)(nil)).Elem()
}

// This data object type provides access to some aspect of the system.
//
// Privileges are generally independent. This means a user with a privilege
// usually can perform an associated set of actions without needing any
// additional supporting privileges.
//
// Within each product version, privileges do not change.
// See `AuthorizationDescription` for
// detailed information on the privileges defined by the system.
type AuthorizationPrivilege struct {
	DynamicData

	// Unique identifier.
	PrivId string `xml:"privId" json:"privId"`
	// Determines whether or not the privilege is applied on the parent entity.
	OnParent bool `xml:"onParent" json:"onParent"`
	// Privilege name.
	Name string `xml:"name" json:"name"`
	// Group name.
	PrivGroupName string `xml:"privGroupName" json:"privGroupName"`
}

func init() {
	t["AuthorizationPrivilege"] = reflect.TypeOf((*AuthorizationPrivilege)(nil)).Elem()
}

// This data object type specifies a collection of privileges used
// to grant access to users on managed entities.
type AuthorizationRole struct {
	DynamicData

	// Unique role identifier.
	RoleId int32 `xml:"roleId" json:"roleId"`
	// Whether or not the role is system-defined.
	//
	// System-defined roles cannot be
	// changed.
	System bool `xml:"system" json:"system"`
	// System-defined or user-defined role name.
	Name string `xml:"name" json:"name"`
	// Displayable role information.
	Info BaseDescription `xml:"info,typeattr" json:"info"`
	// Privileges provided by this role, by privilege identifier.
	Privilege []string `xml:"privilege,omitempty" json:"privilege,omitempty"`
}

func init() {
	t["AuthorizationRole"] = reflect.TypeOf((*AuthorizationRole)(nil)).Elem()
}

// Defines the system default auto-start/auto-stop values.
type AutoStartDefaults struct {
	DynamicData

	// Indicates whether or not auto-start manager is enabled.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// System-default autoStart delay in seconds.
	//
	// The default is 120 seconds.
	StartDelay int32 `xml:"startDelay,omitempty" json:"startDelay,omitempty"`
	// System-default autoStop delay in seconds.
	//
	// The default is 120 seconds.
	StopDelay int32 `xml:"stopDelay,omitempty" json:"stopDelay,omitempty"`
	// System-default waitForHeartbeat setting.
	WaitForHeartbeat *bool `xml:"waitForHeartbeat" json:"waitForHeartbeat,omitempty"`
	// System-default power-off action.
	//
	// Used if the stopAction string in the
	// AutoPowerInfo object for a particular machine is set to systemDefault.
	// If stopAction and startAction for a virtual machine are both set to none,
	// that virtual machine is removed from the AutoStart sequence.
	StopAction string `xml:"stopAction,omitempty" json:"stopAction,omitempty"`
}

func init() {
	t["AutoStartDefaults"] = reflect.TypeOf((*AutoStartDefaults)(nil)).Elem()
}

// This object type describes the power-on / power-off behavior for a given virtual
// machine.
//
// Virtual machines can be configured to wait for a period of time before
// starting or to wait to receive a successful heartbeat from a virtual machine
// before starting the next virtual machine in the sequence.
//   - For a power-on operation, if waitForHeartbeat is true, then the power-on
//     sequence continues after the first heartbeat has been received. If
//     waitForHeartbeat is false, the system waits for the specified delay and
//     then continues the power-on sequence.
//   - For a power-off operation, if delay is non-zero, the requested power-off
//     action is invoked (powerOff, suspend, guestShutdown) on the virtual
//     machine and the system waits until the number of seconds specified in the
//     delay have passed.
//
// If startAction and stopAction for a virtual machine are both set to none, that
// virtual machine is removed from the AutoStart sequence.
// Virtual machines can be configured both to wait for a period of time before
// starting and to wait for a heartbeat. In such a case, the waiting virtual machine
// only waits until either of these conditions are met. In other words, a virtual
// machine starts in either of the following cases:
//   - After receiving a heartbeat but before the start delay has elapsed
//   - After the start delay has elapsed but before receiving a heartbeat
//
// This provides a better experience since as soon as one virtual machine begins
// sending heartbeats, indicating it has successfully started up, the next machine
// will begin starting up. This happens even if the startDelay has not yet elapsed.
// Similarly, if one virtual machine fails to begin sending heartbeats, perhaps
// because it could not start up, other machines are not blocked from starting up
// since the startDelay eventually elapses.
type AutoStartPowerInfo struct {
	DynamicData

	// Virtual machine to power on or power off.
	//
	// Refers instance of `VirtualMachine`.
	Key ManagedObjectReference `xml:"key" json:"key"`
	// The autostart priority of this virtual machine.
	//
	// Virtual machines with a lower
	// number are powered on first. On host shutdown, the virtual machines are
	// shut down in reverse order, meaning those with a higher number are powered off
	// first.
	//
	// Positive values indicate a start order and -1 indicates the machine can be
	// powered on at any time. Machines with a -1 value are typically powered on and
	// off after all virtual machines with positive startOrder values. Failure to
	// meet the following requirements results in an InvalidArgument exception:
	//   - startOrder must be set to -1 if startAction is set to none
	//   - startOrder must be -1 or positive integers. Values such as 0 or
	//     \-2 are not valid.
	//   - startOrder is relative to other virtual machines in the autostart
	//     sequence. Hence specifying a startOrder of 4 when there are only 3
	//     virtual machines in the Autostart sequence is not valid.
	//
	// If a newly established or changed startOrder value for a virtual machine
	// matches an existing startOrder value, the newly applied value takes
	// precedence, and the existing value is incremented by one. The incremented
	// startOrder value is checked for collisions, and the same rule is applied if
	// one is found. This simple system ensures no two virtual machines ever have the
	// same order number.
	//
	// For example, consider the case where there are three virtual machines with
	// different startOrder values. Virtual machine A has not yet established a
	// startOrder, virtual machine B has a startOrder value of 1 and Virtual Machine
	// C has a startOrder value of 2. If virtual machine A's startOrder is set to 1,
	// then virtual machine B's startOrder is incremented to 2. This creates a
	// conflict with virtual machine C's startOrder value, which is also incremented,
	// this time to 3.
	StartOrder int32 `xml:"startOrder" json:"startOrder"`
	// Delay in seconds before continuing with the next virtual machine in the order
	// of machines to be started.
	//
	// If the delay is specified as -1, then the system
	// default is used.
	StartDelay       int32                         `xml:"startDelay" json:"startDelay"`
	WaitForHeartbeat AutoStartWaitHeartbeatSetting `xml:"waitForHeartbeat" json:"waitForHeartbeat"`
	// How to start the virtual machine.
	//
	// Valid settings are none or powerOn.
	// If set to none, then the virtual machine does not participate in auto-start.
	StartAction string `xml:"startAction" json:"startAction"`
	// Delay in seconds before continuing with the next virtual machine in the order
	// sequence.
	//
	// If the delay is -1, then the system default is used.
	StopDelay int32 `xml:"stopDelay" json:"stopDelay"`
	// Defines the stop action for the virtual machine.
	//
	// Can be set to none,
	// systemDefault, powerOff, or suspend. If set to none, then the virtual machine
	// does not participate in auto-stop.
	StopAction string `xml:"stopAction" json:"stopAction"`
}

func init() {
	t["AutoStartPowerInfo"] = reflect.TypeOf((*AutoStartPowerInfo)(nil)).Elem()
}

type AutoStartPowerOff AutoStartPowerOffRequestType

func init() {
	t["AutoStartPowerOff"] = reflect.TypeOf((*AutoStartPowerOff)(nil)).Elem()
}

type AutoStartPowerOffRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AutoStartPowerOffRequestType"] = reflect.TypeOf((*AutoStartPowerOffRequestType)(nil)).Elem()
}

type AutoStartPowerOffResponse struct {
}

type AutoStartPowerOn AutoStartPowerOnRequestType

func init() {
	t["AutoStartPowerOn"] = reflect.TypeOf((*AutoStartPowerOn)(nil)).Elem()
}

type AutoStartPowerOnRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["AutoStartPowerOnRequestType"] = reflect.TypeOf((*AutoStartPowerOnRequestType)(nil)).Elem()
}

type AutoStartPowerOnResponse struct {
}

// Thrown if backupConfig blob is corrupted
type BackupBlobReadFailure struct {
	DvsFault

	// The entity name on which backupConfig read failed
	EntityName string `xml:"entityName" json:"entityName"`
	// The entity type on which backupConfig read failed
	EntityType string `xml:"entityType" json:"entityType"`
	// The fault that occurred.
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["BackupBlobReadFailure"] = reflect.TypeOf((*BackupBlobReadFailure)(nil)).Elem()
}

type BackupBlobReadFailureFault BackupBlobReadFailure

func init() {
	t["BackupBlobReadFailureFault"] = reflect.TypeOf((*BackupBlobReadFailureFault)(nil)).Elem()
}

// Thrown if backupConfig blob write fails
type BackupBlobWriteFailure struct {
	DvsFault

	// The entity name on which backupConfig write failed
	EntityName string `xml:"entityName" json:"entityName"`
	// The entity type on which backupConfig write failed
	EntityType string `xml:"entityType" json:"entityType"`
	// The fault that occurred.
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["BackupBlobWriteFailure"] = reflect.TypeOf((*BackupBlobWriteFailure)(nil)).Elem()
}

type BackupBlobWriteFailureFault BackupBlobWriteFailure

func init() {
	t["BackupBlobWriteFailureFault"] = reflect.TypeOf((*BackupBlobWriteFailureFault)(nil)).Elem()
}

type BackupFirmwareConfiguration BackupFirmwareConfigurationRequestType

func init() {
	t["BackupFirmwareConfiguration"] = reflect.TypeOf((*BackupFirmwareConfiguration)(nil)).Elem()
}

type BackupFirmwareConfigurationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["BackupFirmwareConfigurationRequestType"] = reflect.TypeOf((*BackupFirmwareConfigurationRequestType)(nil)).Elem()
}

type BackupFirmwareConfigurationResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// This event records a failed user logon.
//
// Failed logons are due to no match existing
// between the provided user name and password combination and the combinations
// stored for authentication.
type BadUsernameSessionEvent struct {
	SessionEvent

	// The IP address of the peer that initiated the connection.
	//
	// This may
	// be the client that originated the session, or it may be an intervening
	// proxy if the binding uses a protocol that supports proxies, such as HTTP.
	IpAddress string `xml:"ipAddress" json:"ipAddress"`
}

func init() {
	t["BadUsernameSessionEvent"] = reflect.TypeOf((*BadUsernameSessionEvent)(nil)).Elem()
}

// This data object type contains the basic configuration for
// a virtual storage object or a virtual storage object snapshot.
type BaseConfigInfo struct {
	DynamicData

	// ID of this object.
	Id ID `xml:"id" json:"id"`
	// Descriptive name of this object.
	Name string `xml:"name" json:"name"`
	// The date and time this object was created.
	CreateTime time.Time `xml:"createTime" json:"createTime"`
	// Choice of the deletion behavior of this virtual storage object.
	//
	// If not set, the default value is false.
	KeepAfterDeleteVm *bool `xml:"keepAfterDeleteVm" json:"keepAfterDeleteVm,omitempty"`
	// Is virtual storage object relocation disabled.
	//
	// If not set, the default value is false.
	RelocationDisabled *bool `xml:"relocationDisabled" json:"relocationDisabled,omitempty"`
	// Is virtual storage object supports native snapshot.
	//
	// If not set, the default value is false.
	NativeSnapshotSupported *bool `xml:"nativeSnapshotSupported" json:"nativeSnapshotSupported,omitempty"`
	// If Virtua storage object has changed block tracking enabled.
	//
	// If not set, the default value is false.
	ChangedBlockTrackingEnabled *bool `xml:"changedBlockTrackingEnabled" json:"changedBlockTrackingEnabled,omitempty"`
	// Backing of this object.
	Backing BaseBaseConfigInfoBackingInfo `xml:"backing,typeattr" json:"backing"`
	// Metadata associated with the FCD if available.
	Metadata []KeyValue `xml:"metadata,omitempty" json:"metadata,omitempty" vim:"7.0.2.0"`
	// VClock associated with the fcd when the operation completed.
	//
	// The files is unset if the operation is a retrieve.
	Vclock *VslmVClockInfo `xml:"vclock,omitempty" json:"vclock,omitempty" vim:"7.0.2.0"`
	// IDs of the IO Filters associated with the virtual disk.
	//
	// See `IoFilterInfo.id`.
	// The client cannot modify this information on a virtual machine.
	Iofilter []string `xml:"iofilter,omitempty" json:"iofilter,omitempty"`
}

func init() {
	t["BaseConfigInfo"] = reflect.TypeOf((*BaseConfigInfo)(nil)).Elem()
}

// The data object type is a base type of backing of a virtual
// storage object.
type BaseConfigInfoBackingInfo struct {
	DynamicData

	// The datastore managed object where this backing is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["BaseConfigInfoBackingInfo"] = reflect.TypeOf((*BaseConfigInfoBackingInfo)(nil)).Elem()
}

// The data object type for disk file backing of a virtual storage
// object.
//
// Disk file backing provides full virtualization of the backend
// storage.
type BaseConfigInfoDiskFileBackingInfo struct {
	BaseConfigInfoFileBackingInfo

	// Provisioning type.
	//
	// See `BaseConfigInfoDiskFileBackingInfoProvisioningType_enum` for the
	// supported types.
	ProvisioningType string `xml:"provisioningType" json:"provisioningType"`
}

func init() {
	t["BaseConfigInfoDiskFileBackingInfo"] = reflect.TypeOf((*BaseConfigInfoDiskFileBackingInfo)(nil)).Elem()
}

// Information for file backing of a virtual storage
// object.
//
// File backing is mainly used for virtual disks.
type BaseConfigInfoFileBackingInfo struct {
	BaseConfigInfoBackingInfo

	// Full file path for the host file used in this backing.
	FilePath string `xml:"filePath" json:"filePath"`
	// Id refers to the backed storage object where the virtual storage object
	// is backed on.
	BackingObjectId string `xml:"backingObjectId,omitempty" json:"backingObjectId,omitempty"`
	// The parent of this virtual disk file, if this is a delta disk backing.
	//
	// This will be unset if this is the root disk backing.
	//
	// Note that the type of the backing is consistent throughout the chain;
	// any new delta disk backing which is added is of the same type as the
	// original disk. Also note that since the parent backing is not being
	// written to, it is possible that the parent backing may be shared among
	// multiple disks.
	//
	// Only raw disk mappings in
	// *virtual compatibility mode* can have parents.
	Parent BaseBaseConfigInfoFileBackingInfo `xml:"parent,omitempty,typeattr" json:"parent,omitempty"`
	// Size allocated by the FS for this file/chain/link/extent only.
	//
	// This property is used only for a delta disk whose
	// `BaseConfigInfoFileBackingInfo.parent` is set.
	DeltaSizeInMB int64 `xml:"deltaSizeInMB,omitempty" json:"deltaSizeInMB,omitempty"`
	// key id used to encrypt the backing disk.
	KeyId *CryptoKeyId `xml:"keyId,omitempty" json:"keyId,omitempty"`
}

func init() {
	t["BaseConfigInfoFileBackingInfo"] = reflect.TypeOf((*BaseConfigInfoFileBackingInfo)(nil)).Elem()
}

// This data object type contains information about raw device mapping.
type BaseConfigInfoRawDiskMappingBackingInfo struct {
	BaseConfigInfoFileBackingInfo

	// Unique identifier of the LUN accessed by the raw disk mapping.
	LunUuid string `xml:"lunUuid" json:"lunUuid"`
	// The compatibility mode of the raw disk mapping (RDM).
	//
	// This must be
	// specified when a new virtual disk with an RDM backing is created.
	//
	// See also `VirtualDiskCompatibilityMode_enum`.
	CompatibilityMode string `xml:"compatibilityMode" json:"compatibilityMode"`
}

func init() {
	t["BaseConfigInfoRawDiskMappingBackingInfo"] = reflect.TypeOf((*BaseConfigInfoRawDiskMappingBackingInfo)(nil)).Elem()
}

// The parameters of `Folder.BatchAddHostsToCluster_Task`.
type BatchAddHostsToClusterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specifies the cluster to which hosts need to be
	// added.
	//
	// Refers instance of `ClusterComputeResource`.
	Cluster ManagedObjectReference `xml:"cluster" json:"cluster"`
	// Specifies a list of new hosts to be added to
	// the cluster. Hosts are first added as standalone hosts.
	NewHosts []FolderNewHostSpec `xml:"newHosts,omitempty" json:"newHosts,omitempty"`
	// Specifies a list of existing hosts to be
	// added to the cluster. Hosts are first moved to the desired state
	// before moving them to cluster.
	//
	// Refers instances of `HostSystem`.
	ExistingHosts []ManagedObjectReference `xml:"existingHosts,omitempty" json:"existingHosts,omitempty"`
	// Specifies the configuration for the compute
	// resource that will be created to contain all the hosts.
	CompResSpec BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr" json:"compResSpec,omitempty"`
	// Specifies desired state for hosts once added to
	// the cluster. If not specified, hosts are added to the cluster in their
	// current state. See `FolderDesiredHostState_enum` for valid values.
	DesiredState string `xml:"desiredState,omitempty" json:"desiredState,omitempty"`
}

func init() {
	t["BatchAddHostsToClusterRequestType"] = reflect.TypeOf((*BatchAddHostsToClusterRequestType)(nil)).Elem()
}

type BatchAddHostsToCluster_Task BatchAddHostsToClusterRequestType

func init() {
	t["BatchAddHostsToCluster_Task"] = reflect.TypeOf((*BatchAddHostsToCluster_Task)(nil)).Elem()
}

type BatchAddHostsToCluster_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `Folder.BatchAddStandaloneHosts_Task`.
type BatchAddStandaloneHostsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specifies a list of host specifications for new hosts.
	NewHosts []FolderNewHostSpec `xml:"newHosts,omitempty" json:"newHosts,omitempty"`
	// Specifies the configuration for the compute
	// resource that will be created to contain all the
	// hosts.
	CompResSpec BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr" json:"compResSpec,omitempty"`
	// Flag to specify whether or not hosts should be
	// connected at the time they are added. A host will not
	// be added if a connection attempt is made and fails.
	AddConnected bool `xml:"addConnected" json:"addConnected"`
}

func init() {
	t["BatchAddStandaloneHostsRequestType"] = reflect.TypeOf((*BatchAddStandaloneHostsRequestType)(nil)).Elem()
}

type BatchAddStandaloneHosts_Task BatchAddStandaloneHostsRequestType

func init() {
	t["BatchAddStandaloneHosts_Task"] = reflect.TypeOf((*BatchAddStandaloneHosts_Task)(nil)).Elem()
}

type BatchAddStandaloneHosts_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type BatchQueryConnectInfo BatchQueryConnectInfoRequestType

func init() {
	t["BatchQueryConnectInfo"] = reflect.TypeOf((*BatchQueryConnectInfo)(nil)).Elem()
}

// The parameters of `Datacenter.BatchQueryConnectInfo`.
type BatchQueryConnectInfoRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Information about the set of hosts to query.
	HostSpecs []HostConnectSpec `xml:"hostSpecs,omitempty" json:"hostSpecs,omitempty"`
}

func init() {
	t["BatchQueryConnectInfoRequestType"] = reflect.TypeOf((*BatchQueryConnectInfoRequestType)(nil)).Elem()
}

type BatchQueryConnectInfoResponse struct {
	Returnval []DatacenterBasicConnectInfo `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

// Results of Batch APIs.
type BatchResult struct {
	DynamicData

	// Enum value for @link BatchResult.Result
	Result string `xml:"result" json:"result"`
	// Host for which the result applies.
	HostKey string `xml:"hostKey" json:"hostKey"`
	// The datastore that is created.
	//
	// Refers instance of `Datastore`.
	Ds *ManagedObjectReference `xml:"ds,omitempty" json:"ds,omitempty"`
	// 'fault' would be set if the operation was not successful
	Fault *LocalizedMethodFault `xml:"fault,omitempty" json:"fault,omitempty"`
}

func init() {
	t["BatchResult"] = reflect.TypeOf((*BatchResult)(nil)).Elem()
}

type BindVnic BindVnicRequestType

func init() {
	t["BindVnic"] = reflect.TypeOf((*BindVnic)(nil)).Elem()
}

// The parameters of `IscsiManager.BindVnic`.
type BindVnicRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// iSCSI adapter name for which the Virtual NIC to
	// be added.
	IScsiHbaName string `xml:"iScsiHbaName" json:"iScsiHbaName"`
	// Virtual NIC that is to be bound to the iSCSI HBA
	VnicDevice string `xml:"vnicDevice" json:"vnicDevice"`
}

func init() {
	t["BindVnicRequestType"] = reflect.TypeOf((*BindVnicRequestType)(nil)).Elem()
}

type BindVnicResponse struct {
}

// Fault indicating that firewall configuration prevents
// an operation from completing successfully.
type BlockedByFirewall struct {
	HostConfigFault
}

func init() {
	t["BlockedByFirewall"] = reflect.TypeOf((*BlockedByFirewall)(nil)).Elem()
}

type BlockedByFirewallFault BlockedByFirewall

func init() {
	t["BlockedByFirewallFault"] = reflect.TypeOf((*BlockedByFirewallFault)(nil)).Elem()
}

// The BoolOption data object type describes if an option
// is supported ("true") and if the option is set to "true" or
// "false" by default.
type BoolOption struct {
	OptionType

	// The flag to indicate whether or not the
	// option is supported.
	Supported bool `xml:"supported" json:"supported"`
	// The default value for the option.
	DefaultValue bool `xml:"defaultValue" json:"defaultValue"`
}

func init() {
	t["BoolOption"] = reflect.TypeOf((*BoolOption)(nil)).Elem()
}

// The boolean type of setting or configuration that may get an
// inherited value.
type BoolPolicy struct {
	InheritablePolicy

	// The boolean value that is either set or inherited.
	Value *bool `xml:"value" json:"value,omitempty"`
}

func init() {
	t["BoolPolicy"] = reflect.TypeOf((*BoolPolicy)(nil)).Elem()
}

type BrowseDiagnosticLog BrowseDiagnosticLogRequestType

func init() {
	t["BrowseDiagnosticLog"] = reflect.TypeOf((*BrowseDiagnosticLog)(nil)).Elem()
}

// The parameters of `DiagnosticManager.BrowseDiagnosticLog`.
type BrowseDiagnosticLogRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specifies the host. If not specified, then it defaults
	// to the default server. For example, if called on
	// VirtualCenter, then the value defaults to VirtualCenter
	// logs.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// A string key specifying the key for the log file to
	// browse. Keys can be obtained using the queryDescriptions
	// method.
	Key string `xml:"key" json:"key"`
	// The line number for the first entry to be returned. If the
	// parameter is not specified, then the operation returns
	// with lines starting from the top of the log.
	Start int32 `xml:"start,omitempty" json:"start,omitempty"`
	// The number of lines to return. If not specified, then
	// all lines are returned from the start value to the end of
	// the file.
	Lines int32 `xml:"lines,omitempty" json:"lines,omitempty"`
}

func init() {
	t["BrowseDiagnosticLogRequestType"] = reflect.TypeOf((*BrowseDiagnosticLogRequestType)(nil)).Elem()
}

type BrowseDiagnosticLogResponse struct {
	Returnval DiagnosticManagerLogHeader `xml:"returnval" json:"returnval"`
}

// Fault indicating that the CAM server
// cannot be connected.
type CAMServerRefusedConnection struct {
	InvalidCAMServer
}

func init() {
	t["CAMServerRefusedConnection"] = reflect.TypeOf((*CAMServerRefusedConnection)(nil)).Elem()
}

type CAMServerRefusedConnectionFault CAMServerRefusedConnection

func init() {
	t["CAMServerRefusedConnectionFault"] = reflect.TypeOf((*CAMServerRefusedConnectionFault)(nil)).Elem()
}

type CanProvisionObjects CanProvisionObjectsRequestType

func init() {
	t["CanProvisionObjects"] = reflect.TypeOf((*CanProvisionObjects)(nil)).Elem()
}

// The parameters of `HostVsanInternalSystem.CanProvisionObjects`.
type CanProvisionObjectsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// List of NewPolicyBatch structure with sizes and policies.
	Npbs []VsanNewPolicyBatch `xml:"npbs" json:"npbs"`
	// Optionally populate PolicyCost even though
	// object cannot be provisioned in the current cluster topology.
	IgnoreSatisfiability *bool `xml:"ignoreSatisfiability" json:"ignoreSatisfiability,omitempty"`
}

func init() {
	t["CanProvisionObjectsRequestType"] = reflect.TypeOf((*CanProvisionObjectsRequestType)(nil)).Elem()
}

type CanProvisionObjectsResponse struct {
	Returnval []VsanPolicySatisfiability `xml:"returnval" json:"returnval"`
}

type CancelRecommendation CancelRecommendationRequestType

func init() {
	t["CancelRecommendation"] = reflect.TypeOf((*CancelRecommendation)(nil)).Elem()
}

// The parameters of `ClusterComputeResource.CancelRecommendation`.
type CancelRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key field of the Recommendation.
	Key string `xml:"key" json:"key"`
}

func init() {
	t["CancelRecommendationRequestType"] = reflect.TypeOf((*CancelRecommendationRequestType)(nil)).Elem()
}

type CancelRecommendationResponse struct {
}

type CancelRetrievePropertiesEx CancelRetrievePropertiesExRequestType

func init() {
	t["CancelRetrievePropertiesEx"] = reflect.TypeOf((*CancelRetrievePropertiesEx)(nil)).Elem()
}

// The parameters of `PropertyCollector.CancelRetrievePropertiesEx`.
type CancelRetrievePropertiesExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the token returned in the previous `RetrieveResult` returned on the same session by the
	// same `PropertyCollector`.
	Token string `xml:"token" json:"token"`
}

func init() {
	t["CancelRetrievePropertiesExRequestType"] = reflect.TypeOf((*CancelRetrievePropertiesExRequestType)(nil)).Elem()
}

type CancelRetrievePropertiesExResponse struct {
}

type CancelStorageDrsRecommendation CancelStorageDrsRecommendationRequestType

func init() {
	t["CancelStorageDrsRecommendation"] = reflect.TypeOf((*CancelStorageDrsRecommendation)(nil)).Elem()
}

// The parameters of `StorageResourceManager.CancelStorageDrsRecommendation`.
type CancelStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key field of the Recommendation.
	Key []string `xml:"key" json:"key"`
}

func init() {
	t["CancelStorageDrsRecommendationRequestType"] = reflect.TypeOf((*CancelStorageDrsRecommendationRequestType)(nil)).Elem()
}

type CancelStorageDrsRecommendationResponse struct {
}

type CancelTask CancelTaskRequestType

func init() {
	t["CancelTask"] = reflect.TypeOf((*CancelTask)(nil)).Elem()
}

type CancelTaskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CancelTaskRequestType"] = reflect.TypeOf((*CancelTaskRequestType)(nil)).Elem()
}

type CancelTaskResponse struct {
}

type CancelWaitForUpdates CancelWaitForUpdatesRequestType

func init() {
	t["CancelWaitForUpdates"] = reflect.TypeOf((*CancelWaitForUpdates)(nil)).Elem()
}

type CancelWaitForUpdatesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CancelWaitForUpdatesRequestType"] = reflect.TypeOf((*CancelWaitForUpdatesRequestType)(nil)).Elem()
}

type CancelWaitForUpdatesResponse struct {
}

// An operation performed on the host was canceled.
//
// Typically,
// a previous event in the sequence of events contains more
// information about the cause of this cancellation.
type CanceledHostOperationEvent struct {
	HostEvent
}

func init() {
	t["CanceledHostOperationEvent"] = reflect.TypeOf((*CanceledHostOperationEvent)(nil)).Elem()
}

// This fault is thrown when an operation fails because of insufficient
// permissions to access a file.
type CannotAccessFile struct {
	FileFault
}

func init() {
	t["CannotAccessFile"] = reflect.TypeOf((*CannotAccessFile)(nil)).Elem()
}

type CannotAccessFileFault CannotAccessFile

func init() {
	t["CannotAccessFileFault"] = reflect.TypeOf((*CannotAccessFileFault)(nil)).Elem()
}

// An CannotAccessLocalSourceFault exception is thrown when a
// an attempt is made to upload license content
// and the local source cannot be accesed.
type CannotAccessLocalSource struct {
	VimFault
}

func init() {
	t["CannotAccessLocalSource"] = reflect.TypeOf((*CannotAccessLocalSource)(nil)).Elem()
}

type CannotAccessLocalSourceFault CannotAccessLocalSource

func init() {
	t["CannotAccessLocalSourceFault"] = reflect.TypeOf((*CannotAccessLocalSourceFault)(nil)).Elem()
}

// A network associated with the virtual machine is not accessible.
//
// If returned as
// part of migration checks, this is an error if either of the following is true,
// a warning otherwise:
//   - The virtual ethernet card device backing is a distributed virtual switch,
//     of which the destination host is not a member
//   - The virtual ethernet card device backing is a standard network and the
//     the device is connected
type CannotAccessNetwork struct {
	CannotAccessVmDevice

	// A reference to the network that cannot be accessed
	//
	// Refers instance of `Network`.
	Network *ManagedObjectReference `xml:"network,omitempty" json:"network,omitempty"`
}

func init() {
	t["CannotAccessNetwork"] = reflect.TypeOf((*CannotAccessNetwork)(nil)).Elem()
}

type CannotAccessNetworkFault BaseCannotAccessNetwork

func init() {
	t["CannotAccessNetworkFault"] = reflect.TypeOf((*CannotAccessNetworkFault)(nil)).Elem()
}

// One of the virtual machine's components is not accessible on the execution host.
//
// This is a base class. Subclasses will encode the type of component that is not
// accessible.
type CannotAccessVmComponent struct {
	VmConfigFault
}

func init() {
	t["CannotAccessVmComponent"] = reflect.TypeOf((*CannotAccessVmComponent)(nil)).Elem()
}

type CannotAccessVmComponentFault BaseCannotAccessVmComponent

func init() {
	t["CannotAccessVmComponentFault"] = reflect.TypeOf((*CannotAccessVmComponentFault)(nil)).Elem()
}

// One or more of the virtual machine's configuration files are not accessible.
type CannotAccessVmConfig struct {
	CannotAccessVmComponent

	// Contains the reason why the VM file could not be found.
	//
	// This is typically
	// a FileFault.
	Reason LocalizedMethodFault `xml:"reason" json:"reason"`
}

func init() {
	t["CannotAccessVmConfig"] = reflect.TypeOf((*CannotAccessVmConfig)(nil)).Elem()
}

type CannotAccessVmConfigFault CannotAccessVmConfig

func init() {
	t["CannotAccessVmConfigFault"] = reflect.TypeOf((*CannotAccessVmConfigFault)(nil)).Elem()
}

// One of the virtual machine's devices uses a backing that is not accessible
// on the host.
//
// Following is a discussion of this fault's use in migration validation.
// This is an error if the device is currently connected and a warning
// otherwise. Devices that can be disconnected can only be connected if the virtual
// machine is powered on.
//
// The usage of this fault is slightly different if the backing of a device is
// inherently host-local, and therefore not shared or globally named among
// hosts. (Examples of such backings: physical CD-ROM drive, physical serial
// port.) If a device with such a backing is currently connected, that will
// be a migration error. If the device is disconnected, there will be a
// warning if no backing with the same name exists on the destination host.
// If the device is disconnected and a backing with the same name exists on
// the destination host, this is neither a warning nor an error case, even
// though the destination host's backing is not the same instance as the
// source host's. It is assumed that use of the host-local backing is what is
// desired for the device.
type CannotAccessVmDevice struct {
	CannotAccessVmComponent

	// The label of the device.
	Device string `xml:"device" json:"device"`
	// The backing of the device.
	Backing string `xml:"backing" json:"backing"`
	// The connected/disconnected state of the device.
	Connected bool `xml:"connected" json:"connected"`
}

func init() {
	t["CannotAccessVmDevice"] = reflect.TypeOf((*CannotAccessVmDevice)(nil)).Elem()
}

type CannotAccessVmDeviceFault BaseCannotAccessVmDevice

func init() {
	t["CannotAccessVmDeviceFault"] = reflect.TypeOf((*CannotAccessVmDeviceFault)(nil)).Elem()
}

// One of the virtual machine's virtual disks is not accessible.
type CannotAccessVmDisk struct {
	CannotAccessVmDevice

	// The reason why the disk could not be accessed
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["CannotAccessVmDisk"] = reflect.TypeOf((*CannotAccessVmDisk)(nil)).Elem()
}

type CannotAccessVmDiskFault BaseCannotAccessVmDisk

func init() {
	t["CannotAccessVmDiskFault"] = reflect.TypeOf((*CannotAccessVmDiskFault)(nil)).Elem()
}

// Can not add a host with fault tolerance vms to be standalone
type CannotAddHostWithFTVmAsStandalone struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmAsStandalone"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandalone)(nil)).Elem()
}

type CannotAddHostWithFTVmAsStandaloneFault CannotAddHostWithFTVmAsStandalone

func init() {
	t["CannotAddHostWithFTVmAsStandaloneFault"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandaloneFault)(nil)).Elem()
}

// Can not add a host with fault tolerance vms to a different cluster other
// than the one used other vms in the same fault tolerance group.
type CannotAddHostWithFTVmToDifferentCluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToDifferentCluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentCluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToDifferentClusterFault CannotAddHostWithFTVmToDifferentCluster

func init() {
	t["CannotAddHostWithFTVmToDifferentClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentClusterFault)(nil)).Elem()
}

// Can not add a host with fault tolerance vms to a non HA enabled cluster
type CannotAddHostWithFTVmToNonHACluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToNonHACluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHACluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToNonHAClusterFault CannotAddHostWithFTVmToNonHACluster

func init() {
	t["CannotAddHostWithFTVmToNonHAClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHAClusterFault)(nil)).Elem()
}

// This fault is used to report that the DRS behavior cannot be modified
// for a FT secondary virtual machine
type CannotChangeDrsBehaviorForFtSecondary struct {
	VmFaultToleranceIssue

	// The virtual machine whose behavior cannot be modified
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Name of the virtual machine
	VmName string `xml:"vmName" json:"vmName"`
}

func init() {
	t["CannotChangeDrsBehaviorForFtSecondary"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondary)(nil)).Elem()
}

type CannotChangeDrsBehaviorForFtSecondaryFault CannotChangeDrsBehaviorForFtSecondary

func init() {
	t["CannotChangeDrsBehaviorForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondaryFault)(nil)).Elem()
}

// This fault is used to report that the HA settings cannot be modified
// for a FT secondary virtual machine
type CannotChangeHaSettingsForFtSecondary struct {
	VmFaultToleranceIssue

	// The FT secondary virtual machine whose behavior cannot be modified
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Name of the FT secondary virtual machine
	VmName string `xml:"vmName" json:"vmName"`
}

func init() {
	t["CannotChangeHaSettingsForFtSecondary"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondary)(nil)).Elem()
}

type CannotChangeHaSettingsForFtSecondaryFault CannotChangeHaSettingsForFtSecondary

func init() {
	t["CannotChangeHaSettingsForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondaryFault)(nil)).Elem()
}

// Fault thrown for cases that a VSAN cluster UUID may not be changed.
//
// For example, the VSAN cluster UUID for a host may not be changed so long
// as that host is enabled for VSAN.
// The VSAN cluster UUID for a given `ClusterComputeResource` may
// not be changed so long as that vim.ClusterComputeResource is enabled for
// VSAN.
//
// See also `HostVsanSystem.UpdateVsan_Task`, `ComputeResource.ReconfigureComputeResource_Task`.
type CannotChangeVsanClusterUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanClusterUuid"] = reflect.TypeOf((*CannotChangeVsanClusterUuid)(nil)).Elem()
}

type CannotChangeVsanClusterUuidFault CannotChangeVsanClusterUuid

func init() {
	t["CannotChangeVsanClusterUuidFault"] = reflect.TypeOf((*CannotChangeVsanClusterUuidFault)(nil)).Elem()
}

// Fault thrown for cases that a VSAN node UUID may not be changed.
//
// For example, the VSAN node UUID for a host may not be changed so long as
// that host is enabled for VSAN.
//
// See also `HostVsanSystem.UpdateVsan_Task`, `ComputeResource.ReconfigureComputeResource_Task`.
type CannotChangeVsanNodeUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanNodeUuid"] = reflect.TypeOf((*CannotChangeVsanNodeUuid)(nil)).Elem()
}

type CannotChangeVsanNodeUuidFault CannotChangeVsanNodeUuid

func init() {
	t["CannotChangeVsanNodeUuidFault"] = reflect.TypeOf((*CannotChangeVsanNodeUuidFault)(nil)).Elem()
}

// This fault is used if FT compatible hosts cannot be computed for a VM
type CannotComputeFTCompatibleHosts struct {
	VmFaultToleranceIssue

	// The virtual machine for FT compatible hosts is being computed
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Name of the virtual machine
	VmName string `xml:"vmName" json:"vmName"`
}

func init() {
	t["CannotComputeFTCompatibleHosts"] = reflect.TypeOf((*CannotComputeFTCompatibleHosts)(nil)).Elem()
}

type CannotComputeFTCompatibleHostsFault CannotComputeFTCompatibleHosts

func init() {
	t["CannotComputeFTCompatibleHostsFault"] = reflect.TypeOf((*CannotComputeFTCompatibleHostsFault)(nil)).Elem()
}

// A CannotCreateFile exception is thrown if a file create
// operation fails.
type CannotCreateFile struct {
	FileFault
}

func init() {
	t["CannotCreateFile"] = reflect.TypeOf((*CannotCreateFile)(nil)).Elem()
}

type CannotCreateFileFault CannotCreateFile

func init() {
	t["CannotCreateFileFault"] = reflect.TypeOf((*CannotCreateFileFault)(nil)).Elem()
}

// The VirtualCenter server is unable to decrypt passwords stored in
// the customization specification.
type CannotDecryptPasswords struct {
	CustomizationFault
}

func init() {
	t["CannotDecryptPasswords"] = reflect.TypeOf((*CannotDecryptPasswords)(nil)).Elem()
}

type CannotDecryptPasswordsFault CannotDecryptPasswords

func init() {
	t["CannotDecryptPasswordsFault"] = reflect.TypeOf((*CannotDecryptPasswordsFault)(nil)).Elem()
}

// A CannotDeleteFile exception is thrown if a file-deletion
// operation fails.
type CannotDeleteFile struct {
	FileFault
}

func init() {
	t["CannotDeleteFile"] = reflect.TypeOf((*CannotDeleteFile)(nil)).Elem()
}

type CannotDeleteFileFault CannotDeleteFile

func init() {
	t["CannotDeleteFileFault"] = reflect.TypeOf((*CannotDeleteFileFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to disable DRS on a cluster,
// which contains a vApp.
type CannotDisableDrsOnClustersWithVApps struct {
	RuntimeFault
}

func init() {
	t["CannotDisableDrsOnClustersWithVApps"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVApps)(nil)).Elem()
}

type CannotDisableDrsOnClustersWithVAppsFault CannotDisableDrsOnClustersWithVApps

func init() {
	t["CannotDisableDrsOnClustersWithVAppsFault"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVAppsFault)(nil)).Elem()
}

// Fault thrown when an attempt is made to disable snapshots on a virtual
// machine which has a snapshot.
//
// To disable the snapshot feature, the
// virtual machine must not currently have a snapshot.
type CannotDisableSnapshot struct {
	VmConfigFault
}

func init() {
	t["CannotDisableSnapshot"] = reflect.TypeOf((*CannotDisableSnapshot)(nil)).Elem()
}

type CannotDisableSnapshotFault CannotDisableSnapshot

func init() {
	t["CannotDisableSnapshotFault"] = reflect.TypeOf((*CannotDisableSnapshotFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to disconnect a host, which
// has one or more fault tolerance vms and is not in maintenance mode.
type CannotDisconnectHostWithFaultToleranceVm struct {
	VimFault

	// The name of the host to be disconnected
	HostName string `xml:"hostName" json:"hostName"`
}

func init() {
	t["CannotDisconnectHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotDisconnectHostWithFaultToleranceVmFault CannotDisconnectHostWithFaultToleranceVm

func init() {
	t["CannotDisconnectHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVmFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to enable VM Component Protection
// on a cluster which contains a host that does not support this feature.
type CannotEnableVmcpForCluster struct {
	VimFault

	// Report the host with APD timeout disabled.
	//
	// If the host is set it points to the host which is the reason
	// for this fault i.e this host has ADPTimeout disabled.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// If set this reports the hostName.
	//
	// This is used for printing the host name in the
	// localized message as the host may have been removed
	// from the vCenter's inventory by the time localization would
	// be taking place.
	HostName string `xml:"hostName,omitempty" json:"hostName,omitempty"`
	// This reports the reason for host not meeting the requirements
	// for enabling vSphere VMCP.
	//
	// It can be the following reason.
	//   - APDTimeout disabled.
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
}

func init() {
	t["CannotEnableVmcpForCluster"] = reflect.TypeOf((*CannotEnableVmcpForCluster)(nil)).Elem()
}

type CannotEnableVmcpForClusterFault CannotEnableVmcpForCluster

func init() {
	t["CannotEnableVmcpForClusterFault"] = reflect.TypeOf((*CannotEnableVmcpForClusterFault)(nil)).Elem()
}

// A virtual machine's total CPU feature requirements are determined by
// overlaying the requirements specified in its configuration (if any) on top
// of the requirements specified in the descriptor for its guest OS.
//
// It is
// therefore possible for a host change to implicitly change a virtual
// machine's CPU feature requirements. The guest OS descriptor may have
// different requirements on the new host. Or, if the virtual machine
// currently specifies requirements in its configuration, those requirements
// will be lost if the new host does not support this.
//
// This fault indicates that the virtual machine's CPU feature requirements
// would change because of a migration, and also that the destination host
// does not support storing CPU feature requirements in the virtual machine's
// configuration. (If the destination host does support such an action,
// WillModifyConfigCpuRequirements is used instead of this fault.)
//
// For a powered-off virtual machine, this is a warning. The migration may
// proceed, but the virtual machine will be operating under different
// CPU feature requirements if it is powered on after the migration.
//
// For a powered-on or suspended virtual machine, this is an error.
type CannotModifyConfigCpuRequirements struct {
	MigrationFault
}

func init() {
	t["CannotModifyConfigCpuRequirements"] = reflect.TypeOf((*CannotModifyConfigCpuRequirements)(nil)).Elem()
}

type CannotModifyConfigCpuRequirementsFault CannotModifyConfigCpuRequirements

func init() {
	t["CannotModifyConfigCpuRequirementsFault"] = reflect.TypeOf((*CannotModifyConfigCpuRequirementsFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to move a fault tolerance
// vm to a different resource pool or cluster.
type CannotMoveFaultToleranceVm struct {
	VimFault

	// The type of the move
	MoveType string `xml:"moveType" json:"moveType"`
	// The virtual machine name to be moved.
	VmName string `xml:"vmName" json:"vmName"`
}

func init() {
	t["CannotMoveFaultToleranceVm"] = reflect.TypeOf((*CannotMoveFaultToleranceVm)(nil)).Elem()
}

type CannotMoveFaultToleranceVmFault CannotMoveFaultToleranceVm

func init() {
	t["CannotMoveFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveFaultToleranceVmFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to move a host which has
// one or more fault tolerance vms out of the current cluster.
type CannotMoveHostWithFaultToleranceVm struct {
	VimFault
}

func init() {
	t["CannotMoveHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotMoveHostWithFaultToleranceVmFault CannotMoveHostWithFaultToleranceVm

func init() {
	t["CannotMoveHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVmFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to relocate a virtual machine
// with virtual disk(s) having delta disk backing.
type CannotMoveVmWithDeltaDisk struct {
	MigrationFault

	// The label of the delta disk device
	Device string `xml:"device" json:"device"`
}

func init() {
	t["CannotMoveVmWithDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithDeltaDiskFault CannotMoveVmWithDeltaDisk

func init() {
	t["CannotMoveVmWithDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithDeltaDiskFault)(nil)).Elem()
}

// This fault is thrown when an attempt is made to migrate a virtual machine
// with native delta disks to different datastores.
type CannotMoveVmWithNativeDeltaDisk struct {
	MigrationFault
}

func init() {
	t["CannotMoveVmWithNativeDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithNativeDeltaDiskFault CannotMoveVmWithNativeDeltaDisk

func init() {
	t["CannotMoveVmWithNativeDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDiskFault)(nil)).Elem()
}

// Fault thrown for the case that an attempt is made to move a host which
// is enabled for VSAN into an unsuitable `ClusterComputeResource`.
//
// The destination vim.ClusterComputeResource may be disabled for VSAN, or
// may be using VSAN with a different cluster UUID.
//
// See also `ClusterComputeResource.AddHost_Task`, `ClusterComputeResource.MoveHostInto_Task`, `ClusterComputeResource.MoveInto_Task`, `VsanClusterUuidMismatch`, `DestinationVsanDisabled`.
type CannotMoveVsanEnabledHost struct {
	VsanFault
}

func init() {
	t["CannotMoveVsanEnabledHost"] = reflect.TypeOf((*CannotMoveVsanEnabledHost)(nil)).Elem()
}

type CannotMoveVsanEnabledHostFault BaseCannotMoveVsanEnabledHost

func init() {
	t["CannotMoveVsanEnabledHostFault"] = reflect.TypeOf((*CannotMoveVsanEnabledHostFault)(nil)).Elem()
}

// This fault is thrown when Storage DRS cannot recommend to place disks of
// a virtual machine without moving existing virtual disks in a
// datastore cluster.
type CannotPlaceWithoutPrerequisiteMoves struct {
	VimFault
}

func init() {
	t["CannotPlaceWithoutPrerequisiteMoves"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMoves)(nil)).Elem()
}

type CannotPlaceWithoutPrerequisiteMovesFault CannotPlaceWithoutPrerequisiteMoves

func init() {
	t["CannotPlaceWithoutPrerequisiteMovesFault"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMovesFault)(nil)).Elem()
}

// This fault is reported when a user attempts to power off or
// suspend a VM when the HA master agent to which vCenter Server is
// connected does not manage the VM.
type CannotPowerOffVmInCluster struct {
	InvalidState

	// The operation being performed.
	//
	// Values come from
	// `CannotPowerOffVmInClusterOperation_enum`.
	Operation string `xml:"operation" json:"operation"`
	// The Virtual Machine
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Name of the Virtual Machine
	VmName string `xml:"vmName" json:"vmName"`
}

func init() {
	t["CannotPowerOffVmInCluster"] = reflect.TypeOf((*CannotPowerOffVmInCluster)(nil)).Elem()
}

type CannotPowerOffVmInClusterFault CannotPowerOffVmInCluster

func init() {
	t["CannotPowerOffVmInClusterFault"] = reflect.TypeOf((*CannotPowerOffVmInClusterFault)(nil)).Elem()
}

// Fault thrown for the case that an attempt is made to reconfigure VSAN
// when HA is currently enabled for a given `ClusterComputeResource`.
//
// See also `ComputeResource.ReconfigureComputeResource_Task`.
type CannotReconfigureVsanWhenHaEnabled struct {
	VsanFault
}

func init() {
	t["CannotReconfigureVsanWhenHaEnabled"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabled)(nil)).Elem()
}

type CannotReconfigureVsanWhenHaEnabledFault CannotReconfigureVsanWhenHaEnabled

func init() {
	t["CannotReconfigureVsanWhenHaEnabledFault"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabledFault)(nil)).Elem()
}

// A network associated with the virtual machine is accessible, but it
// cannot be used for some reason.
type CannotUseNetwork struct {
	VmConfigFault

	// The label of the network device.
	Device string `xml:"device" json:"device"`
	// The backing of the network device.
	Backing string `xml:"backing" json:"backing"`
	// The connected/disconnected state of the device.
	Connected bool `xml:"connected" json:"connected"`
	// Reason describing why the network cannot be used.
	Reason string `xml:"reason" json:"reason"`
	// A reference to the network that cannot be used
	//
	// Refers instance of `Network`.
	Network *ManagedObjectReference `xml:"network,omitempty" json:"network,omitempty"`
}

func init() {
	t["CannotUseNetwork"] = reflect.TypeOf((*CannotUseNetwork)(nil)).Elem()
}

type CannotUseNetworkFault CannotUseNetwork

func init() {
	t["CannotUseNetworkFault"] = reflect.TypeOf((*CannotUseNetworkFault)(nil)).Elem()
}

// A particular product may or may not support certain features.
//
// This data object
// indicates whether or not a service instance implements these features. This data
// object type indicates the circumstances under which an operation throws a
// `NotSupported` fault.
//
// Support for some features is indicated by the presence or absence of
// the manager object from the service instance. For example, the AlarmManager manager
// object indicates collecting alarms is supported.
// Other features indicate whether or not a given operation on an
// object throws a `NotSupported` fault.
//
// Some capabilities depend on the host or virtual machine
// version. These are specified by using the vim.host.Capability and
// vim.vm.Capability objects.
type Capability struct {
	DynamicData

	// Indicates whether or not the service instance supports provisioning.
	//
	// For example, the `CloneVM` operation.
	ProvisioningSupported bool `xml:"provisioningSupported" json:"provisioningSupported"`
	// Indicates whether or not the service instance supports multiple hosts.
	MultiHostSupported bool `xml:"multiHostSupported" json:"multiHostSupported"`
	// Flag indicating whether host user accounts should have the option to
	// be granted shell access
	UserShellAccessSupported bool `xml:"userShellAccessSupported" json:"userShellAccessSupported"`
	// All supported Enhanced VMotion Compatibility modes.
	SupportedEVCMode []EVCMode `xml:"supportedEVCMode,omitempty" json:"supportedEVCMode,omitempty"`
	// All supported Enhanced VMotion Compatibility Graphics modes.
	SupportedEVCGraphicsMode []FeatureEVCMode `xml:"supportedEVCGraphicsMode,omitempty" json:"supportedEVCGraphicsMode,omitempty" vim:"7.0.1.0"`
	// Indicates whether network backup and restore feature is supported.
	NetworkBackupAndRestoreSupported *bool `xml:"networkBackupAndRestoreSupported" json:"networkBackupAndRestoreSupported,omitempty"`
	// Is DRS supported for Fault Tolerance VMs without enabling EVC.
	FtDrsWithoutEvcSupported *bool `xml:"ftDrsWithoutEvcSupported" json:"ftDrsWithoutEvcSupported,omitempty"`
	// Specifies if the workflow for setting up a HCI cluster is supported.
	HciWorkflowSupported *bool `xml:"hciWorkflowSupported" json:"hciWorkflowSupported,omitempty"`
	// Specifies the supported compute policy version.
	ComputePolicyVersion      int32 `xml:"computePolicyVersion,omitempty" json:"computePolicyVersion,omitempty"`
	ClusterPlacementSupported *bool `xml:"clusterPlacementSupported" json:"clusterPlacementSupported,omitempty"`
	// Specifies if lifecycle management of a Cluster is supported.
	LifecycleManagementSupported *bool `xml:"lifecycleManagementSupported" json:"lifecycleManagementSupported,omitempty"`
	// Specifies if host seeding for a cluster is supported.
	HostSeedingSupported *bool `xml:"hostSeedingSupported" json:"hostSeedingSupported,omitempty" vim:"7.0.2.0"`
	// Specifies if scalable shares for resource pools is supported.
	ScalableSharesSupported *bool `xml:"scalableSharesSupported" json:"scalableSharesSupported,omitempty"`
	// Specifies if highly available distributed clustering service is supported.
	HadcsSupported *bool `xml:"hadcsSupported" json:"hadcsSupported,omitempty" vim:"7.0.1.1"`
	// Specifies if desired configuration management platform is supported
	// on the cluster.
	ConfigMgmtSupported *bool `xml:"configMgmtSupported" json:"configMgmtSupported,omitempty" vim:"7.0.3.1"`
}

func init() {
	t["Capability"] = reflect.TypeOf((*Capability)(nil)).Elem()
}

// The parameters of `CertificateManager.CertMgrRefreshCACertificatesAndCRLs_Task`.
type CertMgrRefreshCACertificatesAndCRLsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the hosts on which the certificates need to be refreshed
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["CertMgrRefreshCACertificatesAndCRLsRequestType"] = reflect.TypeOf((*CertMgrRefreshCACertificatesAndCRLsRequestType)(nil)).Elem()
}

type CertMgrRefreshCACertificatesAndCRLs_Task CertMgrRefreshCACertificatesAndCRLsRequestType

func init() {
	t["CertMgrRefreshCACertificatesAndCRLs_Task"] = reflect.TypeOf((*CertMgrRefreshCACertificatesAndCRLs_Task)(nil)).Elem()
}

type CertMgrRefreshCACertificatesAndCRLs_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `CertificateManager.CertMgrRefreshCertificates_Task`.
type CertMgrRefreshCertificatesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the hosts on which the certificates need to be refreshed
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["CertMgrRefreshCertificatesRequestType"] = reflect.TypeOf((*CertMgrRefreshCertificatesRequestType)(nil)).Elem()
}

type CertMgrRefreshCertificates_Task CertMgrRefreshCertificatesRequestType

func init() {
	t["CertMgrRefreshCertificates_Task"] = reflect.TypeOf((*CertMgrRefreshCertificates_Task)(nil)).Elem()
}

type CertMgrRefreshCertificates_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `CertificateManager.CertMgrRevokeCertificates_Task`.
type CertMgrRevokeCertificatesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the hosts on which the certificates need to be revoked
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["CertMgrRevokeCertificatesRequestType"] = reflect.TypeOf((*CertMgrRevokeCertificatesRequestType)(nil)).Elem()
}

type CertMgrRevokeCertificates_Task CertMgrRevokeCertificatesRequestType

func init() {
	t["CertMgrRevokeCertificates_Task"] = reflect.TypeOf((*CertMgrRevokeCertificates_Task)(nil)).Elem()
}

type CertMgrRevokeCertificates_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ChangeAccessMode ChangeAccessModeRequestType

func init() {
	t["ChangeAccessMode"] = reflect.TypeOf((*ChangeAccessMode)(nil)).Elem()
}

// The parameters of `HostAccessManager.ChangeAccessMode`.
type ChangeAccessModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The affected user or group.
	Principal string `xml:"principal" json:"principal"`
	// True if principal refers to a group account,
	// false otherwise.
	IsGroup bool `xml:"isGroup" json:"isGroup"`
	// AccessMode to be granted.
	// `accessOther` is meaningless and
	// will result in InvalidArgument exception.
	AccessMode HostAccessMode `xml:"accessMode" json:"accessMode"`
}

func init() {
	t["ChangeAccessModeRequestType"] = reflect.TypeOf((*ChangeAccessModeRequestType)(nil)).Elem()
}

type ChangeAccessModeResponse struct {
}

type ChangeFileAttributesInGuest ChangeFileAttributesInGuestRequestType

func init() {
	t["ChangeFileAttributesInGuest"] = reflect.TypeOf((*ChangeFileAttributesInGuest)(nil)).Elem()
}

// The parameters of `GuestFileManager.ChangeFileAttributesInGuest`.
type ChangeFileAttributesInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual Machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The complete path to the file to be copied in
	// the guest. If the file points to an symbolic link, then the
	// attributes of the target file are changed.
	GuestFilePath string `xml:"guestFilePath" json:"guestFilePath"`
	// Specifies the different file attributes of the
	// guest file to be changed.
	// See `GuestFileAttributes`.
	// If any property is not specified, then the specific attribute of
	// the file will be unchanged.
	FileAttributes BaseGuestFileAttributes `xml:"fileAttributes,typeattr" json:"fileAttributes"`
}

func init() {
	t["ChangeFileAttributesInGuestRequestType"] = reflect.TypeOf((*ChangeFileAttributesInGuestRequestType)(nil)).Elem()
}

type ChangeFileAttributesInGuestResponse struct {
}

// The parameters of `CryptoManagerHost.ChangeKey_Task`.
type ChangeKeyRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key that replaces the existing core dump encryption key
	NewKey CryptoKeyPlain `xml:"newKey" json:"newKey"`
}

func init() {
	t["ChangeKeyRequestType"] = reflect.TypeOf((*ChangeKeyRequestType)(nil)).Elem()
}

type ChangeKey_Task ChangeKeyRequestType

func init() {
	t["ChangeKey_Task"] = reflect.TypeOf((*ChangeKey_Task)(nil)).Elem()
}

type ChangeKey_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ChangeLockdownMode ChangeLockdownModeRequestType

func init() {
	t["ChangeLockdownMode"] = reflect.TypeOf((*ChangeLockdownMode)(nil)).Elem()
}

// The parameters of `HostAccessManager.ChangeLockdownMode`.
type ChangeLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The new desired lockdown mode.
	//
	// If this is the same as the current lockdown mode state, the
	// operation will silently succeed and nothing will be changed.
	//
	// If this is `lockdownDisabled`
	// then lockdown mode will be disabled and the system will
	// start service DCUI if it is not running.
	//
	// If this is `lockdownNormal`
	// then lockdown mode will be enabled and the system will
	// start service DCUI if it is not running.
	//
	// If this is `lockdownStrict`
	// then lockdown mode will be enabled and the system will
	// stop service DCUI if it is running.
	Mode HostLockdownMode `xml:"mode" json:"mode"`
}

func init() {
	t["ChangeLockdownModeRequestType"] = reflect.TypeOf((*ChangeLockdownModeRequestType)(nil)).Elem()
}

type ChangeLockdownModeResponse struct {
}

type ChangeNFSUserPassword ChangeNFSUserPasswordRequestType

func init() {
	t["ChangeNFSUserPassword"] = reflect.TypeOf((*ChangeNFSUserPassword)(nil)).Elem()
}

// The parameters of `HostStorageSystem.ChangeNFSUserPassword`.
type ChangeNFSUserPasswordRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// New password.
	Password string `xml:"password" json:"password"`
}

func init() {
	t["ChangeNFSUserPasswordRequestType"] = reflect.TypeOf((*ChangeNFSUserPasswordRequestType)(nil)).Elem()
}

type ChangeNFSUserPasswordResponse struct {
}

type ChangeOwner ChangeOwnerRequestType

func init() {
	t["ChangeOwner"] = reflect.TypeOf((*ChangeOwner)(nil)).Elem()
}

// The parameters of `FileManager.ChangeOwner`.
type ChangeOwnerRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Name string                 `xml:"name" json:"name"`
	// Required privileges: System.View
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
	Owner      string                  `xml:"owner" json:"owner"`
}

func init() {
	t["ChangeOwnerRequestType"] = reflect.TypeOf((*ChangeOwnerRequestType)(nil)).Elem()
}

type ChangeOwnerResponse struct {
}

type ChangePassword ChangePasswordRequestType

func init() {
	t["ChangePassword"] = reflect.TypeOf((*ChangePassword)(nil)).Elem()
}

// The parameters of `HostLocalAccountManager.ChangePassword`.
type ChangePasswordRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the user whose password will be changed.
	User string `xml:"user" json:"user"`
	// the user's current (old) password.
	OldPassword string `xml:"oldPassword" json:"oldPassword"`
	// the user's new password.
	NewPassword string `xml:"newPassword" json:"newPassword"`
}

func init() {
	t["ChangePasswordRequestType"] = reflect.TypeOf((*ChangePasswordRequestType)(nil)).Elem()
}

type ChangePasswordResponse struct {
}

// The event argument contains changes.
type ChangesInfoEventArgument struct {
	DynamicData

	// Modified properties.
	Modified string `xml:"modified,omitempty" json:"modified,omitempty"`
	// Added properties.
	Added string `xml:"added,omitempty" json:"added,omitempty"`
	// Deleted properties.
	Deleted string `xml:"deleted,omitempty" json:"deleted,omitempty"`
}

func init() {
	t["ChangesInfoEventArgument"] = reflect.TypeOf((*ChangesInfoEventArgument)(nil)).Elem()
}

// The parameters of `ClusterEVCManager.CheckAddHostEvc_Task`.
type CheckAddHostEvcRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The spec that will be used to add the host.
	CnxSpec HostConnectSpec `xml:"cnxSpec" json:"cnxSpec"`
}

func init() {
	t["CheckAddHostEvcRequestType"] = reflect.TypeOf((*CheckAddHostEvcRequestType)(nil)).Elem()
}

type CheckAddHostEvc_Task CheckAddHostEvcRequestType

func init() {
	t["CheckAddHostEvc_Task"] = reflect.TypeOf((*CheckAddHostEvc_Task)(nil)).Elem()
}

type CheckAddHostEvc_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostProfileManager.CheckAnswerFileStatus_Task`.
type CheckAnswerFileStatusRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Set of hosts for which the answer file status will be checked.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["CheckAnswerFileStatusRequestType"] = reflect.TypeOf((*CheckAnswerFileStatusRequestType)(nil)).Elem()
}

type CheckAnswerFileStatus_Task CheckAnswerFileStatusRequestType

func init() {
	t["CheckAnswerFileStatus_Task"] = reflect.TypeOf((*CheckAnswerFileStatus_Task)(nil)).Elem()
}

type CheckAnswerFileStatus_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineProvisioningChecker.CheckClone_Task`.
type CheckCloneRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine we propose to clone.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The location of the new virtual machine.
	//
	// Refers instance of `Folder`.
	Folder ManagedObjectReference `xml:"folder" json:"folder"`
	// The name of the new virtual machine.
	Name string `xml:"name" json:"name"`
	// Specifies how to clone the virtual machine. In cases
	// where DRS would automatically select a host, all potential
	// hosts are tested against.
	Spec VirtualMachineCloneSpec `xml:"spec" json:"spec"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckCloneRequestType"] = reflect.TypeOf((*CheckCloneRequestType)(nil)).Elem()
}

type CheckClone_Task CheckCloneRequestType

func init() {
	t["CheckClone_Task"] = reflect.TypeOf((*CheckClone_Task)(nil)).Elem()
}

type CheckClone_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineCompatibilityChecker.CheckCompatibility_Task`.
type CheckCompatibilityRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine we'd like to place.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The host we would like the virtual machine
	// to execute on. The host parameter may be left unset if the compute
	// resource associated with the pool represents a stand-alone host
	// or a DRS-enabled cluster. In the former case the stand-alone host is
	// used. In the latter case, each connected host in the cluster
	// that is not in maintenance mode is tested. If the virtual machine is a
	// template then either this parameter or the pool parameter must be set.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The resource pool we would like the virtual machine
	// to reside in. If the pool parameter is left unset, then the virtual
	// machine's current pool is assumed. If the virtual machine is a template
	// then either this parameter or the host parameter must be set.
	//
	// Refers instance of `ResourcePool`.
	Pool *ManagedObjectReference `xml:"pool,omitempty" json:"pool,omitempty"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckCompatibilityRequestType"] = reflect.TypeOf((*CheckCompatibilityRequestType)(nil)).Elem()
}

type CheckCompatibility_Task CheckCompatibilityRequestType

func init() {
	t["CheckCompatibility_Task"] = reflect.TypeOf((*CheckCompatibility_Task)(nil)).Elem()
}

type CheckCompatibility_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `ProfileComplianceManager.CheckCompliance_Task`.
type CheckComplianceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// If specified, check compliance against the specified profiles.
	// If not specified, use the profiles associated with the entities.
	// If both Profiles and Entities are specified, Check the compliance of each
	// Entity against each of the profile specified.
	//
	// For more information, look at the KMap below.
	//
	// P represents if Profile is specified.
	//
	// E represents if Entity is specified.
	//
	//	            P                        ^P
	//	  ---------------------------------------------------
	//	  | Check compliance      |  Profiles associated    |
	//	 E|  of each entity       |   with the specified    |
	//	  |  against each of the  |   entity will be used   |
	//	  |  profiles specified.  |   for checking          |
	//	  |                       |   compliance.           |
	//	  |                       |                         |
	//	  |                       |                         |
	//	  ---------------------------------------------------
	//	  | All entities          |   InvalidArgument       |
	//	  |  associated with the  |   Exception is thrown.  |
	//	  |  profile are checked. |                         |
	//	^E|                       |                         |
	//	  |                       |                         |
	//	  |                       |                         |
	//	  |                       |                         |
	//	  ---------------------------------------------------
	//
	// Refers instances of `Profile`.
	Profile []ManagedObjectReference `xml:"profile,omitempty" json:"profile,omitempty"`
	// If specified, the compliance check is done against this entity.
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
}

func init() {
	t["CheckComplianceRequestType"] = reflect.TypeOf((*CheckComplianceRequestType)(nil)).Elem()
}

type CheckCompliance_Task CheckComplianceRequestType

func init() {
	t["CheckCompliance_Task"] = reflect.TypeOf((*CheckCompliance_Task)(nil)).Elem()
}

type CheckCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `ClusterEVCManager.CheckConfigureEvcMode_Task`.
type CheckConfigureEvcModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A key referencing the desired EVC mode.
	EvcModeKey string `xml:"evcModeKey" json:"evcModeKey"`
	// A key referencing the desired EVC Graphics
	// mode `Capability.supportedEVCGraphicsMode`.
	EvcGraphicsModeKey string `xml:"evcGraphicsModeKey,omitempty" json:"evcGraphicsModeKey,omitempty" vim:"7.0.1.0"`
}

func init() {
	t["CheckConfigureEvcModeRequestType"] = reflect.TypeOf((*CheckConfigureEvcModeRequestType)(nil)).Elem()
}

type CheckConfigureEvcMode_Task CheckConfigureEvcModeRequestType

func init() {
	t["CheckConfigureEvcMode_Task"] = reflect.TypeOf((*CheckConfigureEvcMode_Task)(nil)).Elem()
}

type CheckConfigureEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CheckCustomizationResources CheckCustomizationResourcesRequestType

func init() {
	t["CheckCustomizationResources"] = reflect.TypeOf((*CheckCustomizationResources)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.CheckCustomizationResources`.
type CheckCustomizationResourcesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Short name from the guest OS descriptor list describing the OS
	// we intend to customize.
	GuestOs string `xml:"guestOs" json:"guestOs"`
}

func init() {
	t["CheckCustomizationResourcesRequestType"] = reflect.TypeOf((*CheckCustomizationResourcesRequestType)(nil)).Elem()
}

type CheckCustomizationResourcesResponse struct {
}

type CheckCustomizationSpec CheckCustomizationSpecRequestType

func init() {
	t["CheckCustomizationSpec"] = reflect.TypeOf((*CheckCustomizationSpec)(nil)).Elem()
}

// The parameters of `VirtualMachine.CheckCustomizationSpec`.
type CheckCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The customization specification to check.
	Spec CustomizationSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CheckCustomizationSpecRequestType"] = reflect.TypeOf((*CheckCustomizationSpecRequestType)(nil)).Elem()
}

type CheckCustomizationSpecResponse struct {
}

type CheckForUpdates CheckForUpdatesRequestType

func init() {
	t["CheckForUpdates"] = reflect.TypeOf((*CheckForUpdates)(nil)).Elem()
}

// The parameters of `PropertyCollector.CheckForUpdates`.
type CheckForUpdatesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The data version currently known to the client. The value
	// must be either
	//   - the special initial version (an empty string)
	//   - a data version returned from `PropertyCollector.CheckForUpdates` or `PropertyCollector.WaitForUpdates` by the same `PropertyCollector` on the same session.
	//   - a non-truncated data version returned from `PropertyCollector.WaitForUpdatesEx` by the same `PropertyCollector` on the same
	//     session.
	Version string `xml:"version,omitempty" json:"version,omitempty"`
}

func init() {
	t["CheckForUpdatesRequestType"] = reflect.TypeOf((*CheckForUpdatesRequestType)(nil)).Elem()
}

type CheckForUpdatesResponse struct {
	Returnval *UpdateSet `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

// The parameters of `HostPatchManager.CheckHostPatch_Task`.
type CheckHostPatchRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// a list of urls pointing to metadata.zip.
	MetaUrls []string `xml:"metaUrls,omitempty" json:"metaUrls,omitempty"`
	// a list of urls pointing to an "offline" bundle. It is not supported in 5.0 or later.
	BundleUrls []string                                   `xml:"bundleUrls,omitempty" json:"bundleUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty" json:"spec,omitempty"`
}

func init() {
	t["CheckHostPatchRequestType"] = reflect.TypeOf((*CheckHostPatchRequestType)(nil)).Elem()
}

type CheckHostPatch_Task CheckHostPatchRequestType

func init() {
	t["CheckHostPatch_Task"] = reflect.TypeOf((*CheckHostPatch_Task)(nil)).Elem()
}

type CheckHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineProvisioningChecker.CheckInstantClone_Task`.
type CheckInstantCloneRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine we propose to instant clone.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Specifies how to instant clone the virtual machine.
	Spec VirtualMachineInstantCloneSpec `xml:"spec" json:"spec"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckInstantCloneRequestType"] = reflect.TypeOf((*CheckInstantCloneRequestType)(nil)).Elem()
}

type CheckInstantClone_Task CheckInstantCloneRequestType

func init() {
	t["CheckInstantClone_Task"] = reflect.TypeOf((*CheckInstantClone_Task)(nil)).Elem()
}

type CheckInstantClone_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CheckLicenseFeature CheckLicenseFeatureRequestType

func init() {
	t["CheckLicenseFeature"] = reflect.TypeOf((*CheckLicenseFeature)(nil)).Elem()
}

// The parameters of `LicenseManager.CheckLicenseFeature`.
type CheckLicenseFeatureRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Host to act on if LicenseManager is not on a host.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// Name of the feature to enable.
	FeatureKey string `xml:"featureKey" json:"featureKey"`
}

func init() {
	t["CheckLicenseFeatureRequestType"] = reflect.TypeOf((*CheckLicenseFeatureRequestType)(nil)).Elem()
}

type CheckLicenseFeatureResponse struct {
	Returnval bool `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineProvisioningChecker.CheckMigrate_Task`.
type CheckMigrateRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine we propose to migrate.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The target host on which the virtual machines will run. The host
	// parameter may be left unset if the compute resource associated with
	// the target pool represents a stand-alone host or a DRS-enabled
	// cluster. In the former case the stand-alone host is used as the
	// target host. In the latter case, each connected host in the cluster
	// that is not in maintenance mode is tested as a target host.
	// If the virtual machine is a template then either this
	// parameter or the pool parameter must be set.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The target resource pool for the virtual machines. If the
	// pool parameter is left unset, the target pool for each particular
	// virtual machine's migration will be that virtual machine's current
	// pool. If the virtual machine is a template then either this
	// parameter or the host parameter must be set.
	// The pool parameter must be set for testing the feasibility of
	// migration to a different datacenter or different vCenter service.
	//
	// Refers instance of `ResourcePool`.
	Pool *ManagedObjectReference `xml:"pool,omitempty" json:"pool,omitempty"`
	// The power state that the virtual machines must have. If
	// this argument is not set, each virtual machine is evaluated
	// according to its current power state.
	State VirtualMachinePowerState `xml:"state,omitempty" json:"state,omitempty"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckMigrateRequestType"] = reflect.TypeOf((*CheckMigrateRequestType)(nil)).Elem()
}

type CheckMigrate_Task CheckMigrateRequestType

func init() {
	t["CheckMigrate_Task"] = reflect.TypeOf((*CheckMigrate_Task)(nil)).Elem()
}

type CheckMigrate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineCompatibilityChecker.CheckPowerOn_Task`.
type CheckPowerOnRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine to power on.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The host on which we want to power on the virtual machine.
	// The host parameter may be left unset if the compute
	// resource associated with the pool represents a stand-alone host
	// or a DRS-enabled cluster. In the former case the stand-alone host
	// is used. In the latter case, each connected host in the cluster
	// that is not in maintenance mode is tested. Either this parameter
	// or the pool parameter must be set.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The resource pool we would like the virtual machine to run
	// in. If the pool parameter is left unset, we use the host's
	// root resource pool.
	//
	// Refers instance of `ResourcePool`.
	Pool *ManagedObjectReference `xml:"pool,omitempty" json:"pool,omitempty"`
	// The set of tests to run. If this argument is not set,
	// all tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckPowerOnRequestType"] = reflect.TypeOf((*CheckPowerOnRequestType)(nil)).Elem()
}

type CheckPowerOn_Task CheckPowerOnRequestType

func init() {
	t["CheckPowerOn_Task"] = reflect.TypeOf((*CheckPowerOn_Task)(nil)).Elem()
}

type CheckPowerOn_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `Profile.CheckProfileCompliance_Task`.
type CheckProfileComplianceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// If specified, the compliance check is performed on this entity.
	// If the entity is not specified, the vCenter Server runs a compliance check on all the
	// entities associated with the profile. The entity does not have to be associated with the
	// profile.
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
}

func init() {
	t["CheckProfileComplianceRequestType"] = reflect.TypeOf((*CheckProfileComplianceRequestType)(nil)).Elem()
}

type CheckProfileCompliance_Task CheckProfileComplianceRequestType

func init() {
	t["CheckProfileCompliance_Task"] = reflect.TypeOf((*CheckProfileCompliance_Task)(nil)).Elem()
}

type CheckProfileCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachineProvisioningChecker.CheckRelocate_Task`.
type CheckRelocateRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The virtual machine we propose to relocate.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The specification of where to relocate the virtual machine.
	// In cases where DRS would automatically select a host, all potential
	// hosts are tested against.
	// The host parameter in the spec may be left unset for checking
	// feasibility of relocation to a different datacenter or different
	// vCenter service, if the compute resource associated with the
	// target pool represents a stand-alone host, the host is tested
	// against, otherwise each connected host in the cluster that is
	// not in maintenance mode represented by the target pool is tested
	// as a target host.
	Spec VirtualMachineRelocateSpec `xml:"spec" json:"spec"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckRelocateRequestType"] = reflect.TypeOf((*CheckRelocateRequestType)(nil)).Elem()
}

type CheckRelocate_Task CheckRelocateRequestType

func init() {
	t["CheckRelocate_Task"] = reflect.TypeOf((*CheckRelocate_Task)(nil)).Elem()
}

type CheckRelocate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The result of a call to any of the methods in either
// `VirtualMachineCompatibilityChecker` or `VirtualMachineProvisioningChecker`.
type CheckResult struct {
	DynamicData

	// The virtual machine involved in the testing.
	//
	// Refers instance of `VirtualMachine`.
	Vm *ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
	// The host involved in the testing.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// A list of faults representing problems which may
	// require attention, but which are not fatal.
	Warning []LocalizedMethodFault `xml:"warning,omitempty" json:"warning,omitempty"`
	// A list of faults representing problems which are fatal
	// to the operation.
	//
	// For `VirtualMachineProvisioningChecker` an error means that the
	// given provisioning operation would fail.
	// For `VirtualMachineCompatibilityChecker` an error means that either
	// a power-on of this virtual machine would fail, or that the
	// virtual machine would not run correctly once powered-on.
	Error []LocalizedMethodFault `xml:"error,omitempty" json:"error,omitempty"`
}

func init() {
	t["CheckResult"] = reflect.TypeOf((*CheckResult)(nil)).Elem()
}

// The parameters of `VirtualMachineCompatibilityChecker.CheckVmConfig_Task`.
type CheckVmConfigRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification of the virtual machine to create.
	Spec VirtualMachineConfigSpec `xml:"spec" json:"spec"`
	// The existing virtual machine to apply the spec to.
	// If this is not provided, the spec is assumed to be for the creation
	// of a new virtual machine.
	//
	// Refers instance of `VirtualMachine`.
	Vm *ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
	// The host we would like the virtual machine
	// to execute on. The host parameter may be left unset if the compute
	// resource associated with the pool represents a stand-alone host
	// or a DRS-enabled cluster. In the former case the stand-alone host
	// is used. In the latter case, each connected host in the cluster
	// that is not in maintenance mode is tested. If the virtual machine
	// is a template, then either this parameter or the pool parameter
	// must be set.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The resource pool we would like the virtual machine
	// to reside in. If the pool parameter is left unset, then we use the
	// host's root resource pool.
	//
	// Refers instance of `ResourcePool`.
	Pool *ManagedObjectReference `xml:"pool,omitempty" json:"pool,omitempty"`
	// The set of tests to run. If this argument is not set, all
	// tests will be run. See `CheckTestType_enum` for possible values.
	TestType []string `xml:"testType,omitempty" json:"testType,omitempty"`
}

func init() {
	t["CheckVmConfigRequestType"] = reflect.TypeOf((*CheckVmConfigRequestType)(nil)).Elem()
}

type CheckVmConfig_Task CheckVmConfigRequestType

func init() {
	t["CheckVmConfig_Task"] = reflect.TypeOf((*CheckVmConfig_Task)(nil)).Elem()
}

type CheckVmConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The ChoiceOption data object type defines a set of
// supported string values, a localizable description for each value,
// and the default value.
type ChoiceOption struct {
	OptionType

	// The set of possible selections and descriptions.
	ChoiceInfo []BaseElementDescription `xml:"choiceInfo,typeattr" json:"choiceInfo"`
	// The index in ChoiceOption.value that serves as the default value.
	DefaultIndex int32 `xml:"defaultIndex,omitempty" json:"defaultIndex,omitempty"`
}

func init() {
	t["ChoiceOption"] = reflect.TypeOf((*ChoiceOption)(nil)).Elem()
}

type ClearComplianceStatus ClearComplianceStatusRequestType

func init() {
	t["ClearComplianceStatus"] = reflect.TypeOf((*ClearComplianceStatus)(nil)).Elem()
}

// The parameters of `ProfileComplianceManager.ClearComplianceStatus`.
type ClearComplianceStatusRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// If specified, clear the ComplianceResult related to the Profile.
	//
	// Refers instances of `Profile`.
	Profile []ManagedObjectReference `xml:"profile,omitempty" json:"profile,omitempty"`
	// If specified, clear the ComplianceResult related to the entity.
	// If profile and entity are not specified, all the ComplianceResults will be cleared.
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
}

func init() {
	t["ClearComplianceStatusRequestType"] = reflect.TypeOf((*ClearComplianceStatusRequestType)(nil)).Elem()
}

type ClearComplianceStatusResponse struct {
}

type ClearNFSUser ClearNFSUserRequestType

func init() {
	t["ClearNFSUser"] = reflect.TypeOf((*ClearNFSUser)(nil)).Elem()
}

type ClearNFSUserRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["ClearNFSUserRequestType"] = reflect.TypeOf((*ClearNFSUserRequestType)(nil)).Elem()
}

type ClearNFSUserResponse struct {
}

type ClearSystemEventLog ClearSystemEventLogRequestType

func init() {
	t["ClearSystemEventLog"] = reflect.TypeOf((*ClearSystemEventLog)(nil)).Elem()
}

type ClearSystemEventLogRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["ClearSystemEventLogRequestType"] = reflect.TypeOf((*ClearSystemEventLogRequestType)(nil)).Elem()
}

type ClearSystemEventLogResponse struct {
}

type ClearTriggeredAlarms ClearTriggeredAlarmsRequestType

func init() {
	t["ClearTriggeredAlarms"] = reflect.TypeOf((*ClearTriggeredAlarms)(nil)).Elem()
}

// The parameters of `AlarmManager.ClearTriggeredAlarms`.
type ClearTriggeredAlarmsRequestType struct {
	This   ManagedObjectReference `xml:"_this" json:"-"`
	Filter AlarmFilterSpec        `xml:"filter" json:"filter"`
}

func init() {
	t["ClearTriggeredAlarmsRequestType"] = reflect.TypeOf((*ClearTriggeredAlarmsRequestType)(nil)).Elem()
}

type ClearTriggeredAlarmsResponse struct {
}

type ClearVStorageObjectControlFlags ClearVStorageObjectControlFlagsRequestType

func init() {
	t["ClearVStorageObjectControlFlags"] = reflect.TypeOf((*ClearVStorageObjectControlFlags)(nil)).Elem()
}

// The parameters of `VcenterVStorageObjectManager.ClearVStorageObjectControlFlags`.
type ClearVStorageObjectControlFlagsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The datastore where the source virtual storage
	// object is located.
	//
	// Required privileges: Datastore.FileManagement
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// control flags enum array to be cleared on the
	// VStorageObject. All control flags not included
	// in the array remain intact.
	ControlFlags []string `xml:"controlFlags,omitempty" json:"controlFlags,omitempty"`
}

func init() {
	t["ClearVStorageObjectControlFlagsRequestType"] = reflect.TypeOf((*ClearVStorageObjectControlFlagsRequestType)(nil)).Elem()
}

type ClearVStorageObjectControlFlagsResponse struct {
}

// Fault indicating that the clock skew in the system exceeds the limit.
type ClockSkew struct {
	HostConfigFault
}

func init() {
	t["ClockSkew"] = reflect.TypeOf((*ClockSkew)(nil)).Elem()
}

type ClockSkewFault ClockSkew

func init() {
	t["ClockSkewFault"] = reflect.TypeOf((*ClockSkewFault)(nil)).Elem()
}

// An attempt is being made to clone a virtual machine from a snapshot
// point, and this is not supported.
//
// See also `VirtualMachineCloneSpec.snapshot`, `VirtualMachineCapability.snapshotConfigSupported`, `HostCapability.cloneFromSnapshotSupported`.
type CloneFromSnapshotNotSupported struct {
	MigrationFault
}

func init() {
	t["CloneFromSnapshotNotSupported"] = reflect.TypeOf((*CloneFromSnapshotNotSupported)(nil)).Elem()
}

type CloneFromSnapshotNotSupportedFault CloneFromSnapshotNotSupported

func init() {
	t["CloneFromSnapshotNotSupportedFault"] = reflect.TypeOf((*CloneFromSnapshotNotSupportedFault)(nil)).Elem()
}

type CloneSession CloneSessionRequestType

func init() {
	t["CloneSession"] = reflect.TypeOf((*CloneSession)(nil)).Elem()
}

// The parameters of `SessionManager.CloneSession`.
type CloneSessionRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// ticket string acquired via `SessionManager.AcquireCloneTicket`.
	CloneTicket string `xml:"cloneTicket" json:"cloneTicket"`
}

func init() {
	t["CloneSessionRequestType"] = reflect.TypeOf((*CloneSessionRequestType)(nil)).Elem()
}

type CloneSessionResponse struct {
	Returnval UserSession `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualApp.CloneVApp_Task`.
type CloneVAppRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the new vApp.
	Name string `xml:"name" json:"name"`
	// The parent entity of the new vApp. Must be of type
	// `ResourcePool` or `VirtualApp`.
	//
	// Refers instance of `ResourcePool`.
	Target ManagedObjectReference `xml:"target" json:"target"`
	// Specifies how to clone the vApp.
	Spec VAppCloneSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CloneVAppRequestType"] = reflect.TypeOf((*CloneVAppRequestType)(nil)).Elem()
}

type CloneVApp_Task CloneVAppRequestType

func init() {
	t["CloneVApp_Task"] = reflect.TypeOf((*CloneVApp_Task)(nil)).Elem()
}

type CloneVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CloneVM_Task`.
type CloneVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The location of the new virtual machine.
	//
	// Required privileges: VirtualMachine.Inventory.CreateFromExisting
	//
	// Refers instance of `Folder`.
	Folder ManagedObjectReference `xml:"folder" json:"folder"`
	// The name of the new virtual machine.
	Name string `xml:"name" json:"name"`
	// Specifies how to clone the virtual machine. The folder
	// specified in the spec takes precedence over the folder parameter.
	Spec VirtualMachineCloneSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CloneVMRequestType"] = reflect.TypeOf((*CloneVMRequestType)(nil)).Elem()
}

type CloneVM_Task CloneVMRequestType

func init() {
	t["CloneVM_Task"] = reflect.TypeOf((*CloneVM_Task)(nil)).Elem()
}

type CloneVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VcenterVStorageObjectManager.CloneVStorageObject_Task`.
type CloneVStorageObjectRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The datastore where the source virtual storage object
	// is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// The specification for cloning the virtual storage
	// object.
	Spec VslmCloneSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CloneVStorageObjectRequestType"] = reflect.TypeOf((*CloneVStorageObjectRequestType)(nil)).Elem()
}

type CloneVStorageObject_Task CloneVStorageObjectRequestType

func init() {
	t["CloneVStorageObject_Task"] = reflect.TypeOf((*CloneVStorageObject_Task)(nil)).Elem()
}

type CloneVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CloseInventoryViewFolder CloseInventoryViewFolderRequestType

func init() {
	t["CloseInventoryViewFolder"] = reflect.TypeOf((*CloseInventoryViewFolder)(nil)).Elem()
}

// The parameters of `InventoryView.CloseInventoryViewFolder`.
type CloseInventoryViewFolderRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// An array of managed object references. Each array entry is a
	// reference to an entity to collapse.
	//
	// Required privileges: System.View
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["CloseInventoryViewFolderRequestType"] = reflect.TypeOf((*CloseInventoryViewFolderRequestType)(nil)).Elem()
}

type CloseInventoryViewFolderResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

// Base class for all action recommendations in VirtualCenter.
type ClusterAction struct {
	DynamicData

	// Type of the action.
	//
	// This is encoded to differentiate between
	// different types of actions aimed at achieving different goals.
	Type string `xml:"type" json:"type"`
	// The target object on which this action will be applied.
	//
	// For
	// instance, a migration action will have a virtual machine as its
	// target object, while a host power action will have a host as its
	// target action.
	Target *ManagedObjectReference `xml:"target,omitempty" json:"target,omitempty"`
}

func init() {
	t["ClusterAction"] = reflect.TypeOf((*ClusterAction)(nil)).Elem()
}

// Base class for all action history.
type ClusterActionHistory struct {
	DynamicData

	// The action that was executed recently.
	Action BaseClusterAction `xml:"action,typeattr" json:"action"`
	// The time when the action was executed.
	Time time.Time `xml:"time" json:"time"`
}

func init() {
	t["ClusterActionHistory"] = reflect.TypeOf((*ClusterActionHistory)(nil)).Elem()
}

// The `ClusterAffinityRuleSpec` data object defines a set
// of virtual machines.
//
// DRS will attempt to schedule the virtual machines
// to run on the same host.
type ClusterAffinityRuleSpec struct {
	ClusterRuleInfo

	// List of virtual machine references.
	//
	// Refers instances of `VirtualMachine`.
	Vm []ManagedObjectReference `xml:"vm" json:"vm"`
}

func init() {
	t["ClusterAffinityRuleSpec"] = reflect.TypeOf((*ClusterAffinityRuleSpec)(nil)).Elem()
}

// The `ClusterAntiAffinityRuleSpec` data object defines
// a set of virtual machines.
//
// DRS will attempt to schedule the virtual
// machines to run on different hosts.
type ClusterAntiAffinityRuleSpec struct {
	ClusterRuleInfo

	// List of virtual machine references.
	//
	// Refers instances of `VirtualMachine`.
	Vm []ManagedObjectReference `xml:"vm" json:"vm"`
}

func init() {
	t["ClusterAntiAffinityRuleSpec"] = reflect.TypeOf((*ClusterAntiAffinityRuleSpec)(nil)).Elem()
}

// This data class reports virtual machine powerOn information.
type ClusterAttemptedVmInfo struct {
	DynamicData

	// The virtual machine being powered on.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The ID of the task, which monitors powering on.
	//
	// Refers instance of `Task`.
	Task *ManagedObjectReference `xml:"task,omitempty" json:"task,omitempty"`
}

func init() {
	t["ClusterAttemptedVmInfo"] = reflect.TypeOf((*ClusterAttemptedVmInfo)(nil)).Elem()
}

// Describes an action for the initial placement of a virtual machine in a
// cluster.
//
// This action is used by the cross cluster placement API when a
// virtual machine needs to be placed across a set of given clusters. See
// `Folder.PlaceVmsXCluster`. This action encapsulates details
// about the chosen cluster (via the resource pool inside that cluster), the
// chosen host and the chosen datastores for the disks of the virtual machine.
type ClusterClusterInitialPlacementAction struct {
	ClusterAction

	// The host where the virtual machine should be initially placed.
	//
	// This field
	// is optional because the primary use case of
	// `Folder.PlaceVmsXCluster` is to select the best cluster for
	// placing VMs. This `ClusterClusterInitialPlacementAction.targetHost`
	// denotes the best host within the best cluster and it is only returned
	// if the client asks for it, which is determined by
	// `PlaceVmsXClusterSpec.hostRecommRequired`. If
	// `PlaceVmsXClusterSpec.hostRecommRequired` is set to true, then
	// the targetHost is returned with a valid value and if it is either set to
	// false or left unset, then targetHost is also left unset. When this field
	// is unset, then it means that the client did not ask for the target host
	// within the recommended cluster. It does not mean that there is no
	// recommended host for placing this VM in the recommended cluster.
	//
	// Refers instance of `HostSystem`.
	TargetHost *ManagedObjectReference `xml:"targetHost,omitempty" json:"targetHost,omitempty"`
	// The chosen resource pool for placing the virtual machine.
	//
	// This is non-
	// optional because recommending the best cluster (by recommending the
	// resource pool in the best cluster) is the primary use case for the
	// `ClusterClusterInitialPlacementAction`.
	//
	// Refers instance of `ResourcePool`.
	Pool ManagedObjectReference `xml:"pool" json:"pool"`
	// The config spec of the virtual machine to be placed.
	//
	// The `Folder.PlaceVmsXCluster` method takes
	// input of `VirtualMachineConfigSpec` from client and populates the backing
	// for each virtual disk and the VM home path in it unless the input
	// ConfigSpec already provides them. The existing settings in the input
	// ConfigSpec are preserved and not overridden in the returned ConfigSpec
	// in this action as well as the resulting
	// `ClusterRecommendation`. This field is set based on whether
	// the client needs `Folder.PlaceVmsXCluster` to recommend a
	// backing datastore for the disks of the candidate VMs or not, which is
	// specified via `PlaceVmsXClusterSpec.datastoreRecommRequired`.
	// If `PlaceVmsXClusterSpec.datastoreRecommRequired` is set to
	// true, then this
	// `ClusterClusterInitialPlacementAction.configSpec` is also set
	// with the backing of each disk populated. If
	// `PlaceVmsXClusterSpec.datastoreRecommRequired` is either set to
	// false or left unset, then this field is also left unset. When this field
	// is left unset, then it means that the client did not ask to populate the
	// backing datastore for the disks of the candidate VMs.
	ConfigSpec *VirtualMachineConfigSpec `xml:"configSpec,omitempty" json:"configSpec,omitempty"`
}

func init() {
	t["ClusterClusterInitialPlacementAction"] = reflect.TypeOf((*ClusterClusterInitialPlacementAction)(nil)).Elem()
	minAPIVersionForType["ClusterClusterInitialPlacementAction"] = "8.0.0.1"
}

// This event records that a compliance check was triggered
// on the cluster.
type ClusterComplianceCheckedEvent struct {
	ClusterEvent

	Profile ProfileEventArgument `xml:"profile" json:"profile"`
}

func init() {
	t["ClusterComplianceCheckedEvent"] = reflect.TypeOf((*ClusterComplianceCheckedEvent)(nil)).Elem()
}

// ClusterConfigResult is the result returned for the `ClusterComputeResource.ConfigureHCI_Task`
// method.
type ClusterComputeResourceClusterConfigResult struct {
	DynamicData

	// List of failed hosts.
	FailedHosts []FolderFailedHostResult `xml:"failedHosts,omitempty" json:"failedHosts,omitempty"`
	// List of successfully configured hosts.
	//
	// Refers instances of `HostSystem`.
	ConfiguredHosts []ManagedObjectReference `xml:"configuredHosts,omitempty" json:"configuredHosts,omitempty"`
}

func init() {
	t["ClusterComputeResourceClusterConfigResult"] = reflect.TypeOf((*ClusterComputeResourceClusterConfigResult)(nil)).Elem()
}

// The encryption mode policy for a cluster.
type ClusterComputeResourceCryptoModePolicy struct {
	DynamicData

	// The host key identifier.
	//
	// When set, all hosts in the cluster will use this key when enabling
	// the crypto safe mode. Only one of `ClusterComputeResourceCryptoModePolicy.keyId` and
	// `ClusterComputeResourceCryptoModePolicy.providerId` may be set.
	KeyId *CryptoKeyId `xml:"keyId,omitempty" json:"keyId,omitempty"`
	// The host key provider identifier.
	//
	// When set, all hosts in the cluster will use a key from the specified
	// key provider when enabling the crypto safe mode. Only one of
	// `ClusterComputeResourceCryptoModePolicy.keyId` and `ClusterComputeResourceCryptoModePolicy.providerId` may be set.
	ProviderId *KeyProviderId `xml:"providerId,omitempty" json:"providerId,omitempty"`
}

func init() {
	t["ClusterComputeResourceCryptoModePolicy"] = reflect.TypeOf((*ClusterComputeResourceCryptoModePolicy)(nil)).Elem()
	minAPIVersionForType["ClusterComputeResourceCryptoModePolicy"] = "8.0.3.0"
}

// Describes the validations applicable to the network settings.
//
// These
// are based off the information recorded in
// `dvsSetting`.
type ClusterComputeResourceDVSConfigurationValidation struct {
	ClusterComputeResourceValidationResultBase

	// Check if the DVS is alive.
	IsDvsValid bool `xml:"isDvsValid" json:"isDvsValid"`
	// Check if the portgroups are valid.
	IsDvpgValid bool `xml:"isDvpgValid" json:"isDvpgValid"`
}

func init() {
	t["ClusterComputeResourceDVSConfigurationValidation"] = reflect.TypeOf((*ClusterComputeResourceDVSConfigurationValidation)(nil)).Elem()
}

// Contains reference to the DVS, list of physical nics attached to it,
// and list of dvportgroups created on it while initially configuring a
// cluster by calling the `ClusterComputeResource.ConfigureHCI_Task` method.
type ClusterComputeResourceDVSSetting struct {
	DynamicData

	// Managed object reference to the DVS.
	//
	// Refers instance of `DistributedVirtualSwitch`.
	DvSwitch ManagedObjectReference `xml:"dvSwitch" json:"dvSwitch"`
	// List of physical nics attached to the DVS.
	PnicDevices []string `xml:"pnicDevices,omitempty" json:"pnicDevices,omitempty"`
	// Describes dvportgroups on the DVS and services residing on each one.
	DvPortgroupSetting []ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping `xml:"dvPortgroupSetting,omitempty" json:"dvPortgroupSetting,omitempty"`
}

func init() {
	t["ClusterComputeResourceDVSSetting"] = reflect.TypeOf((*ClusterComputeResourceDVSSetting)(nil)).Elem()
}

type ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping struct {
	DynamicData

	// Managed object reference to the dvportgroup.
	//
	// Refers instance of `DistributedVirtualPortgroup`.
	DvPortgroup ManagedObjectReference `xml:"dvPortgroup" json:"dvPortgroup"`
	// Service to be configured on the virtual nics attached to this
	// dvportgroup.
	//
	// See `HostVirtualNicManagerNicType_enum` for
	// supported values.
	Service string `xml:"service" json:"service"`
}

func init() {
	t["ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping"] = reflect.TypeOf((*ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping)(nil)).Elem()
}

// Describes DVS related information to be configured by calling
// `ClusterComputeResource.ConfigureHCI_Task` method.
//
// Consists of name of the DVS, the physical adapters to be attached to it
// and the list of dvportgroups to be created on this DVS.
type ClusterComputeResourceDvsProfile struct {
	DynamicData

	// Name of the new `DistributedVirtualSwitch`.
	DvsName string `xml:"dvsName,omitempty" json:"dvsName,omitempty"`
	// Managed object reference to an existing `DistributedVirtualSwitch`.
	//
	// Refers instance of `DistributedVirtualSwitch`.
	DvSwitch *ManagedObjectReference `xml:"dvSwitch,omitempty" json:"dvSwitch,omitempty"`
	// List of physical Nics to be attached to the DVS.
	PnicDevices        []string                                                          `xml:"pnicDevices,omitempty" json:"pnicDevices,omitempty"`
	DvPortgroupMapping []ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping `xml:"dvPortgroupMapping,omitempty" json:"dvPortgroupMapping,omitempty"`
}

func init() {
	t["ClusterComputeResourceDvsProfile"] = reflect.TypeOf((*ClusterComputeResourceDvsProfile)(nil)).Elem()
}

type ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping struct {
	DynamicData

	// Specification for a new `DistributedVirtualPortgroup`.
	DvPortgroupSpec *DVPortgroupConfigSpec `xml:"dvPortgroupSpec,omitempty" json:"dvPortgroupSpec,omitempty"`
	// Managed object reference to an existing `DistributedVirtualPortgroup`.
	//
	// Refers instance of `DistributedVirtualPortgroup`.
	DvPortgroup *ManagedObjectReference `xml:"dvPortgroup,omitempty" json:"dvPortgroup,omitempty"`
	// Service to be configured on the virtual nics attached to this
	// dvportgroup.
	//
	// See `HostVirtualNicManagerNicType_enum` for
	// supported values.
	Service string `xml:"service" json:"service"`
}

func init() {
	t["ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping"] = reflect.TypeOf((*ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping)(nil)).Elem()
}

// This data object captures a subset of initial configuration of the cluster,
// which was configured by calling the `ClusterComputeResource.ConfigureHCI_Task` method.
type ClusterComputeResourceHCIConfigInfo struct {
	DynamicData

	// Configuration pertinent to state of the HCI workflow.
	//
	// Valid
	// values are enumerated by the `HCIWorkflowState`
	// type.
	WorkflowState string `xml:"workflowState" json:"workflowState"`
	// Contains DVS related information captured while configuring
	// the cluster.
	DvsSetting []ClusterComputeResourceDVSSetting `xml:"dvsSetting,omitempty" json:"dvsSetting,omitempty"`
	// Contains a list of hosts that are currently configured using
	// `ClusterComputeResource.ConfigureHCI_Task` and `ClusterComputeResource.ExtendHCI_Task`
	// method.
	//
	// A failed host will not be part of this list.
	//
	// Refers instances of `HostSystem`.
	ConfiguredHosts []ManagedObjectReference `xml:"configuredHosts,omitempty" json:"configuredHosts,omitempty"`
	// Configuration of host services and host settings.
	HostConfigProfile *ClusterComputeResourceHostConfigurationProfile `xml:"hostConfigProfile,omitempty" json:"hostConfigProfile,omitempty"`
}

func init() {
	t["ClusterComputeResourceHCIConfigInfo"] = reflect.TypeOf((*ClusterComputeResourceHCIConfigInfo)(nil)).Elem()
}

// Specification to configure the cluster.
type ClusterComputeResourceHCIConfigSpec struct {
	DynamicData

	// Information related to network configuration.
	//
	// For each DvsProfile
	// object, specify either `ClusterComputeResourceDvsProfile.dvsName` or
	// `ClusterComputeResourceDvsProfile.dvSwitch`. Across all DvsProfile objects, specify
	// exactly one
	// `ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping.dvPortgroup` or
	// `ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping.dvPortgroupSpec` per
	// `ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping.service`.
	DvsProf []ClusterComputeResourceDvsProfile `xml:"dvsProf,omitempty" json:"dvsProf,omitempty"`
	// Configuration of host services and host settings.
	HostConfigProfile *ClusterComputeResourceHostConfigurationProfile `xml:"hostConfigProfile,omitempty" json:"hostConfigProfile,omitempty"`
	// vSan configuration specification.
	//
	// This is vim.vsan.ReconfigSpec object
	// represented via the VIM object.
	VSanConfigSpec *SDDCBase `xml:"vSanConfigSpec,omitempty" json:"vSanConfigSpec,omitempty"`
	// Describes cluster and EVC configuration.
	VcProf *ClusterComputeResourceVCProfile `xml:"vcProf,omitempty" json:"vcProf,omitempty"`
}

func init() {
	t["ClusterComputeResourceHCIConfigSpec"] = reflect.TypeOf((*ClusterComputeResourceHCIConfigSpec)(nil)).Elem()
}

// Host configuration input to configure hosts in a cluster.
type ClusterComputeResourceHostConfigurationInput struct {
	DynamicData

	// Refers instance of `HostSystem`.
	Host        ManagedObjectReference                 `xml:"host" json:"host"`
	HostVmkNics []ClusterComputeResourceHostVmkNicInfo `xml:"hostVmkNics,omitempty" json:"hostVmkNics,omitempty"`
	// To apply configuration on the host, the host is expected to be in
	// maintenance mode.
	//
	// This constraint can be relaxed by setting this
	// flag to true.
	AllowedInNonMaintenanceMode *bool `xml:"allowedInNonMaintenanceMode" json:"allowedInNonMaintenanceMode,omitempty"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationInput"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationInput)(nil)).Elem()
}

// HostConfigurationProfile describes the configuration of services
// and settings which gets applied on every host in the HCI cluster.
type ClusterComputeResourceHostConfigurationProfile struct {
	DynamicData

	// Date and time settings
	DateTimeConfig *HostDateTimeConfig `xml:"dateTimeConfig,omitempty" json:"dateTimeConfig,omitempty"`
	// Desired lockdown mode
	LockdownMode HostLockdownMode `xml:"lockdownMode,omitempty" json:"lockdownMode,omitempty"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationProfile"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationProfile)(nil)).Elem()
}

// Describes the validations applicable to the settings on the host.
type ClusterComputeResourceHostConfigurationValidation struct {
	ClusterComputeResourceValidationResultBase

	// Host being validated.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Check if the host is attached to the DVS on right adapters.
	IsDvsSettingValid *bool `xml:"isDvsSettingValid" json:"isDvsSettingValid,omitempty"`
	// Check if the adapters for services are present and on the right
	// portgroups.
	IsVmknicSettingValid *bool `xml:"isVmknicSettingValid" json:"isVmknicSettingValid,omitempty"`
	// Check if NTP is configured per specification.
	IsNtpSettingValid *bool `xml:"isNtpSettingValid" json:"isNtpSettingValid,omitempty"`
	// Check if lockdown mode is set per specification
	IsLockdownModeValid *bool `xml:"isLockdownModeValid" json:"isLockdownModeValid,omitempty"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationValidation"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationValidation)(nil)).Elem()
}

// This data object describes what evacuation actions should be made for a given host.
type ClusterComputeResourceHostEvacuationInfo struct {
	DynamicData

	// Candidate host to be put into maintenance mode.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Specifies the list of required actions.
	//
	// Depending on the specified option values passed, additional
	// actions such as ones related to evacuation of specific objects,
	// additional memory reservation or allowing/disallowing certain groups
	// of operations may be taken when entering the desired flavor of
	// maintenance mode. The list of supported options and values may vary
	// based on the version of the ESXi host and Virtual Center.
	//
	// If unset, a default list of actions will be assumed based on the
	// selected flavor of maintenance mode as specified by the
	// `ClusterComputeResourceMaintenanceInfo.partialMMId` field. See `HostPartialMaintenanceModeId_enum`
	// for further information about individual flavors.
	Action []BaseOptionValue `xml:"action,omitempty,typeattr" json:"action,omitempty"`
}

func init() {
	t["ClusterComputeResourceHostEvacuationInfo"] = reflect.TypeOf((*ClusterComputeResourceHostEvacuationInfo)(nil)).Elem()
	minAPIVersionForType["ClusterComputeResourceHostEvacuationInfo"] = "8.0.3.0"
}

// This data object describes how a vmknic on a host must be configured.
type ClusterComputeResourceHostVmkNicInfo struct {
	DynamicData

	// NIC specification
	NicSpec HostVirtualNicSpec `xml:"nicSpec" json:"nicSpec"`
	// Service type for this adapter.
	//
	// See
	// `HostVirtualNicManagerNicType_enum` for supported values.
	Service string `xml:"service" json:"service"`
}

func init() {
	t["ClusterComputeResourceHostVmkNicInfo"] = reflect.TypeOf((*ClusterComputeResourceHostVmkNicInfo)(nil)).Elem()
}

// This data object describes how a given array of hosts will be put into maintenance mode.
type ClusterComputeResourceMaintenanceInfo struct {
	DynamicData

	// Indicates the flavor of maintenance mode requested.
	//
	// If set, specifies the desired flavor of partial
	// maintenance mode. Otherwise, full maintenance mode is assumed.
	// See `HostPartialMaintenanceModeId_enum` for supported values.
	PartialMMId string `xml:"partialMMId,omitempty" json:"partialMMId,omitempty"`
	// Evaucation information for each host
	HostEvacInfo []ClusterComputeResourceHostEvacuationInfo `xml:"hostEvacInfo,omitempty" json:"hostEvacInfo,omitempty"`
}

func init() {
	t["ClusterComputeResourceMaintenanceInfo"] = reflect.TypeOf((*ClusterComputeResourceMaintenanceInfo)(nil)).Elem()
	minAPIVersionForType["ClusterComputeResourceMaintenanceInfo"] = "8.0.3.0"
}

// The `ClusterComputeResourceSummary` data object
// encapsulates runtime properties of a `ClusterComputeResource`.
type ClusterComputeResourceSummary struct {
	ComputeResourceSummary

	// Deprecated as of vSphere API 4.0, use
	// `ClusterFailoverLevelAdmissionControlInfo.currentFailoverLevel`.
	//
	// Current failover level.
	//
	// This is the number of physical host failures that can
	// be tolerated without impacting the ability to satisfy the minimums for all
	// running virtual machines. This represents the current value, as opposed to
	// desired value configured by the user.
	CurrentFailoverLevel int32 `xml:"currentFailoverLevel" json:"currentFailoverLevel"`
	// Information about the current amount of resources available for a vSphere HA
	// cluster.
	//
	// The actual type of admissionControlInfo will depend on what kind of
	// `ClusterDasAdmissionControlPolicy` was used to configure the cluster.
	AdmissionControlInfo BaseClusterDasAdmissionControlInfo `xml:"admissionControlInfo,omitempty,typeattr" json:"admissionControlInfo,omitempty"`
	// Total number of migrations with VMotion that have been done internal to this
	// cluster.
	NumVmotions int32 `xml:"numVmotions" json:"numVmotions"`
	// The target balance, in terms of standard deviation, for a DRS cluster.
	//
	// Units are thousandths. For example, 12 represents 0.012.
	TargetBalance int32 `xml:"targetBalance,omitempty" json:"targetBalance,omitempty"`
	// The current balance, in terms of standard deviation, for a DRS cluster.
	//
	// Units are thousandths. For example, 12 represents 0.012.
	CurrentBalance int32 `xml:"currentBalance,omitempty" json:"currentBalance,omitempty"`
	// The DRS score of this cluster, in percentage.
	DrsScore int32 `xml:"drsScore,omitempty" json:"drsScore,omitempty"`
	// The number of VMs in this cluster corresponding to each DRS score
	// bucket.
	//
	// The buckets are defined as follows:
	//   - 0% - 20%
	//   - 21% - 40%
	//   - 41% - 60%
	//   - 61% - 80%
	//   - 81% - 100%
	NumVmsPerDrsScoreBucket []int32 `xml:"numVmsPerDrsScoreBucket,omitempty" json:"numVmsPerDrsScoreBucket,omitempty"`
	// The current usage summary for a DRS cluster.
	UsageSummary *ClusterUsageSummary `xml:"usageSummary,omitempty" json:"usageSummary,omitempty"`
	// The Enhanced VMotion Compatibility mode that is currently in effect
	// for all hosts in this cluster; unset if no EVC mode is active.
	//
	// See also `Capability.supportedEVCMode`.
	CurrentEVCModeKey string `xml:"currentEVCModeKey,omitempty" json:"currentEVCModeKey,omitempty"`
	// The Enhanced VMotion Compatibility Graphics mode that is currently in
	// effect for all hosts in this cluster; unset if no EVC mode is active.
	//
	// See also `Capability.supportedEVCGraphicsMode`.
	CurrentEVCGraphicsModeKey string `xml:"currentEVCGraphicsModeKey,omitempty" json:"currentEVCGraphicsModeKey,omitempty" vim:"7.0.1.0"`
	// Data pertaining to DAS.
	DasData BaseClusterDasData `xml:"dasData,omitempty,typeattr" json:"dasData,omitempty"`
	// Configuration pertinent to state of the cluster maintenance mode.
	//
	// Valid values are enumerated by the `ClusterMaintenanceModeStatus`
	// type.
	ClusterMaintenanceModeStatus string `xml:"clusterMaintenanceModeStatus,omitempty" json:"clusterMaintenanceModeStatus,omitempty" vim:"7.0.0.2"`
	// The health status of the vSphere Cluster Services in the cluster.
	//
	// Supported values are enumerated by the `VcsHealthStatus`
	// type.
	VcsHealthStatus string `xml:"vcsHealthStatus,omitempty" json:"vcsHealthStatus,omitempty" vim:"7.0.1.1"`
	// An array of hosts and number of resource slots on the host for
	// vSphere Cluster Services in the cluster.
	//
	// The number of resource slots on the host includes both following types:
	// 1\. Number of vCS VMs running on the host (resource reserved and occupied).
	// 2\. Number of reserved and unoccupied slots (reserved for new vCS VMs).
	VcsSlots []ClusterComputeResourceVcsSlots `xml:"vcsSlots,omitempty" json:"vcsSlots,omitempty" vim:"7.0.1.1"`
}

func init() {
	t["ClusterComputeResourceSummary"] = reflect.TypeOf((*ClusterComputeResourceSummary)(nil)).Elem()
}

// Describes cluster configuration for various vCenter services.
type ClusterComputeResourceVCProfile struct {
	DynamicData

	// Cluster configurarion.
	ClusterSpec *ClusterConfigSpecEx `xml:"clusterSpec,omitempty" json:"clusterSpec,omitempty"`
	// EVC mode key.
	EvcModeKey string `xml:"evcModeKey,omitempty" json:"evcModeKey,omitempty"`
	// EVC Graphics mode key
	EvcGraphicsModeKey string `xml:"evcGraphicsModeKey,omitempty" json:"evcGraphicsModeKey,omitempty" vim:"7.0.1.0"`
}

func init() {
	t["ClusterComputeResourceVCProfile"] = reflect.TypeOf((*ClusterComputeResourceVCProfile)(nil)).Elem()
}

// Describes the validation results.
type ClusterComputeResourceValidationResultBase struct {
	DynamicData

	// Describes the messages relevant to the validation result
	Info []LocalizableMessage `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterComputeResourceValidationResultBase"] = reflect.TypeOf((*ClusterComputeResourceValidationResultBase)(nil)).Elem()
}

type ClusterComputeResourceVcsSlots struct {
	DynamicData

	// Identifier of the system for which the slots are applicable.
	SystemId string `xml:"systemId,omitempty" json:"systemId,omitempty" vim:"7.0.3.0"`
	// The host that has vSphere Cluster Services slots.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Datastores on the host which are recommended for vCLS VM deployment.
	//
	// Refers instances of `Datastore`.
	Datastore []ManagedObjectReference `xml:"datastore,omitempty" json:"datastore,omitempty" vim:"7.0.3.0"`
	// The number of total vSphere Cluster Services slots on the host.
	TotalSlots int32 `xml:"totalSlots" json:"totalSlots"`
}

func init() {
	t["ClusterComputeResourceVcsSlots"] = reflect.TypeOf((*ClusterComputeResourceVcsSlots)(nil)).Elem()
	minAPIVersionForType["ClusterComputeResourceVcsSlots"] = "7.0.1.1"
}

// Deprecated as of VI API 2.5, use `ClusterConfigInfoEx`.
//
// A complete cluster configuration.
type ClusterConfigInfo struct {
	DynamicData

	// Cluster-wide configuration of the vSphere HA service.
	DasConfig ClusterDasConfigInfo `xml:"dasConfig" json:"dasConfig"`
	// List of virtual machine configurations for the vSphere HA
	// service.
	//
	// Each entry applies to one virtual machine.
	//
	// If a virtual machine is not specified in this array, the service uses
	// the default settings for that virtual machine.
	DasVmConfig []ClusterDasVmConfigInfo `xml:"dasVmConfig,omitempty" json:"dasVmConfig,omitempty"`
	// Cluster-wide configuration of the VMware DRS service.
	DrsConfig ClusterDrsConfigInfo `xml:"drsConfig" json:"drsConfig"`
	// List of virtual machine configurations for the VMware DRS
	// service.
	//
	// Each entry applies to one virtual machine.
	//
	// If a virtual machine is not specified in this array, the service uses
	// the default settings for that virtual machine.
	DrsVmConfig []ClusterDrsVmConfigInfo `xml:"drsVmConfig,omitempty" json:"drsVmConfig,omitempty"`
	// Cluster-wide rules.
	Rule []BaseClusterRuleInfo `xml:"rule,omitempty,typeattr" json:"rule,omitempty"`
}

func init() {
	t["ClusterConfigInfo"] = reflect.TypeOf((*ClusterConfigInfo)(nil)).Elem()
}

// The `ClusterConfigInfoEx` data object describes a complete cluster
// configuration.
//
// For information about configuring a cluster, see
// `ClusterConfigSpecEx`.
type ClusterConfigInfoEx struct {
	ComputeResourceConfigInfo

	// Configuration for vCLS system VMs deployment.
	SystemVMsConfig *ClusterSystemVMsConfigInfo `xml:"systemVMsConfig,omitempty" json:"systemVMsConfig,omitempty" vim:"7.0.3.0"`
	// Cluster-wide configuration of the vSphere HA service.
	DasConfig ClusterDasConfigInfo `xml:"dasConfig" json:"dasConfig"`
	// List of virtual machine configurations for the vSphere HA
	// service.
	//
	// Each entry applies to one virtual machine.
	//
	// If a virtual machine is not specified in this array, the service uses
	// the default settings for that virtual machine.
	DasVmConfig []ClusterDasVmConfigInfo `xml:"dasVmConfig,omitempty" json:"dasVmConfig,omitempty"`
	// Cluster-wide configuration of the VMware DRS service.
	DrsConfig ClusterDrsConfigInfo `xml:"drsConfig" json:"drsConfig"`
	// List of virtual machine configurations for the VMware DRS
	// service.
	//
	// Each entry applies to one virtual machine.
	//
	// If a virtual machine is not specified in this array, the service uses
	// the default settings for that virtual machine.
	DrsVmConfig []ClusterDrsVmConfigInfo `xml:"drsVmConfig,omitempty" json:"drsVmConfig,omitempty"`
	// Cluster-wide rules.
	Rule []BaseClusterRuleInfo `xml:"rule,omitempty,typeattr" json:"rule,omitempty"`
	// Cluster-wide configuration of VM orchestration.
	Orchestration *ClusterOrchestrationInfo `xml:"orchestration,omitempty" json:"orchestration,omitempty"`
	// List of virtual machine configurations that apply during cluster wide
	// VM orchestration.
	//
	// Each entry applies to one virtual machine.
	//
	// If a virtual machine is not specified in this array, the service uses
	// the default settings for that virtual machine.
	VmOrchestration []ClusterVmOrchestrationInfo `xml:"vmOrchestration,omitempty" json:"vmOrchestration,omitempty"`
	// Cluster-wide configuration of the VMware DPM service.
	DpmConfigInfo *ClusterDpmConfigInfo `xml:"dpmConfigInfo,omitempty" json:"dpmConfigInfo,omitempty"`
	// List of host configurations for the VMware DPM
	// service.
	//
	// Each entry applies to one host.
	//
	// If a host is not specified in this array, the service uses
	// the cluster default settings for that host.
	DpmHostConfig []ClusterDpmHostConfigInfo `xml:"dpmHostConfig,omitempty" json:"dpmHostConfig,omitempty"`
	// Cluster-wide configuration of the VMware VSAN service.
	VsanConfigInfo *VsanClusterConfigInfo `xml:"vsanConfigInfo,omitempty" json:"vsanConfigInfo,omitempty"`
	// List of host configurations for the VMware VSAN service.
	//
	// Each entry applies to one host.
	//
	// If a host is not specified in this array, the service uses
	// the cluster default settings for that host.
	VsanHostConfig []VsanHostConfigInfo `xml:"vsanHostConfig,omitempty" json:"vsanHostConfig,omitempty"`
	// Cluster-wide groups.
	Group []BaseClusterGroupInfo `xml:"group,omitempty,typeattr" json:"group,omitempty"`
	// Cluster-wide configuration of the VMware InfraUpdateHA service.
	InfraUpdateHaConfig *ClusterInfraUpdateHaConfigInfo `xml:"infraUpdateHaConfig,omitempty" json:"infraUpdateHaConfig,omitempty"`
	// Cluster-wide configuration of the ProactiveDRS service.
	ProactiveDrsConfig *ClusterProactiveDrsConfigInfo `xml:"proactiveDrsConfig,omitempty" json:"proactiveDrsConfig,omitempty"`
	// Cluster-wide configuration of the encryption mode.
	CryptoConfig *ClusterCryptoConfigInfo `xml:"cryptoConfig,omitempty" json:"cryptoConfig,omitempty"`
}

func init() {
	t["ClusterConfigInfoEx"] = reflect.TypeOf((*ClusterConfigInfoEx)(nil)).Elem()
}

// Deprecated as of VI API 2.5, use `ClusterConfigSpecEx`.
//
// A complete cluster configuration.
//
// All fields are defined as
// optional. In case of a reconfiguration, unset fields are
// unchanged.
type ClusterConfigSpec struct {
	DynamicData

	// Changes to the configuration of vSphere HA.
	DasConfig *ClusterDasConfigInfo `xml:"dasConfig,omitempty" json:"dasConfig,omitempty"`
	// Changes to the per-virtual-machine vSphere HA settings.
	DasVmConfigSpec []ClusterDasVmConfigSpec `xml:"dasVmConfigSpec,omitempty" json:"dasVmConfigSpec,omitempty"`
	// Changes to the configuration of the VMware DRS service.
	DrsConfig *ClusterDrsConfigInfo `xml:"drsConfig,omitempty" json:"drsConfig,omitempty"`
	// Changes to the per-virtual-machine DRS settings.
	DrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"drsVmConfigSpec,omitempty" json:"drsVmConfigSpec,omitempty"`
	// Changes to the set of rules.
	RulesSpec []ClusterRuleSpec `xml:"rulesSpec,omitempty" json:"rulesSpec,omitempty"`
}

func init() {
	t["ClusterConfigSpec"] = reflect.TypeOf((*ClusterConfigSpec)(nil)).Elem()
}

// The `ClusterConfigSpecEx` data object provides a set of update
// specifications for complete cluster configuration.
//
// You can configure a cluster when you create a new cluster
// (the `Folder.CreateClusterEx` method) or when you
// reconfigure an existing cluster
// (the `ComputeResource.ReconfigureComputeResource_Task` method).
//
// All fields are optional. If you set the <code>modify</code>
// parameter to <code>true</code> when you call
// `ComputeResource.ReconfigureComputeResource_Task`, an unset property has no effect
// on the existing property value in the cluster configuration on the Server.
// If you set the <code>modify</code> parameter to <code>false</code> when you
// reconfigure a cluster, the cluster configuration is reverted to the default
// values, then the new configuration values are applied.
//
// Use the properties defined for this object to configure
// the following services:
//
//   - HA (High Availability) -
//     provides failover protection for virtual machines
//     running in a cluster of ESX Server hosts.
//     The virtual machines are located in a `Datastore`, which
//     provides shared storage for the cluster.
//     When a failure occurs that affects a protected virtual machine,
//     HA will restart the virtual machine on another host.
//     When HA detects a host failure, either the host has failed or it may be
//     isolated from the network. The HA agent on an isolated host will power off
//     or shutdown the virtual machines running on that host so that they
//     can be restarted elsewhere.
//     See `ClusterDasVmSettingsIsolationResponse_enum` for information
//     about how a host handles network isolation.
//
//     When it chooses a failover host, HA selects a host that is compatible
//     with the virtual machine and that can support resource allocation for
//     that virtual machine so that service level guarantees remain intact.
//     HA does not consider hosts that are in maintenance mode, standby mode,
//     or which are disconnected from the vCenter Server. When a host powers
//     on or becomes available again, HA is reenabled on that host,
//     so it becomes available for failover again.
//     VMware recommends that you configure hosts and virtual machines
//     so that all virtual machines can run on all hosts in the cluster.
//     This will maximize the chances of restarting a VM after a failure.
//
//     HA also restarts a virtual machine after a guest operating system failure.
//     In this case, the virtual machine health monitoring service detects
//     the guest failure, and HA restarts the virtual machine on the same host.
//     The service monitors heartbeats from the VmTools service and optionally
//     heartbeats that are generated by a third-party application monitor.
//     See `ClusterVmToolsMonitoringSettings` and
//     `ClusterDasConfigInfo*.*ClusterDasConfigInfo.vmMonitoring`.
//
//     To enable HA for a cluster, set the
//     `ClusterDasConfigInfo*.*ClusterDasConfigInfo.enabled`
//     property to <code>true</code> and the
//     `ClusterDasConfigInfo*.*ClusterDasConfigInfo.hostMonitoring`
//     property to `enabled`.
//     (The vSphere API uses the substring "das" in object, property,
//     and method names for HA.<sup>1</sup>)
//
//   - DRS (Distributed Resource Scheduling) - provides automatic initial
//     virtual machine placement on any of the hosts in the cluster. DRS
//     also makes automatic resource relocation and optimization decisions
//     as hosts or virtual machines are added or removed from the cluster.
//     You can also configure DRS for manual control, so that it only makes
//     recommendations that you can review and carry out.
//
//     To enable DRS for a cluster, set the
//     `ClusterDrsConfigInfo*.*ClusterDrsConfigInfo.enabled`
//     property to <code>true</code>.
//
//   - DPM (Distributed Power Management) - supports optimized power
//     consumption on the cluster. When virtual machines in a DRS
//     cluster require fewer resources, DPM consolidates workloads
//     onto fewer servers while maintaining quality of service guarantees
//     and powers off the rest to reduce power consumption.
//     When more resources are required, DPM brings the powered-down hosts online.
//
//     To enable DPM for a cluster, set the
//     `ClusterDpmConfigInfo*.*ClusterDpmConfigInfo.enabled`
//     property to <code>true</code>.
//
//   - VSAN - aggregrates hosts' local disks to present a single
//     shared datastore to the cluster.
//
//     To enable VSAN for a cluster, set the
//     `VsanClusterConfigInfo.enabled` property to
//     <code>true</code> for `ClusterConfigSpecEx.vsanConfig`.
//
//   - InfraUpdateHA (Infrastructure update HA) - supports automatic
//     migration of virtual machines to hosts with low risk of a
//     catastrophic failure. Similar to DRS, you can also configure
//     InfraUpdateHA for manual control to only makes recommendations that
//     you can review and carry out. The health state of the hosts are
//     propagated to HA to enable restarting of virtual machines in healthy
//     hosts as possible.
//
//     To enable InfraUpdateHA for a cluster, set the
//     `ClusterInfraUpdateHaConfigInfo*.*ClusterInfraUpdateHaConfigInfo.enabled` property to
//     <code>true</code>.
//
//   - ProactiveDRS (Proactive Distributed Resources Scheduling) - supports
//     virtual machine load balancing decisions that take predicted
//     resource demand information into account.
//
//     To enable ProactiveDRS for a cluster, set the
//     `ClusterProactiveDrsConfigInfo*.*ClusterProactiveDrsConfigInfo.enabled` property to
//     <code>true</code>.
//
// The HA, DRS, and DPM services are integrated with the FT (Fault Tolerance)
// and EVC (Enhanced vMotion Compatibility) services.
// Use the `VirtualMachine.CreateSecondaryVM_Task` method to establish
// fault tolerance for a virtual machine. Use the vSphere Client to configure EVC.
// The HA, DRS, DPM, FT, and EVC services interact under
// the following circumstances.
//
//   - To determine initial placement of a virtual machine, DRS
//     checks to see if the HA admission control policy on a
//     potential host supports the addition of the powered on
//     virtual machine. With the default setting, DRS will not
//     power on more than four FT virtual machines per host.
//     You can use the configuration editor in the vSphere Client
//     to set the HA advanced option <code>das.maxFtVmsPerHost</code>
//     to the desired number or to zero to disable.
//
//   - When a host fails, HA determines placement within
//     the cluster when it restarts the virtual machines.
//     If there is insufficient capacity, and DPM has put one or more
//     compatible hosts into standby, HA relies on DPM to bring more
//     capacity online.
//
//   - To use FT in a cluster, the cluster must be HA-enabled.
//
//   - You can disable HA in a cluster while there are FT virtual
//     machines registered on hosts in the cluster.
//     While HA is disabled, powered on FT virtual machines will continue
//     to run, but HA will not restart any virtual machines after a failure.
//     When HA is disabled, you cannot use the following FT operations:
//
//   - Turn on FT (`VirtualMachine.CreateSecondaryVM_Task`)
//
//   - Enable FT (`VirtualMachine.EnableSecondaryVM_Task`)
//
//   - Power on an FT virtual machine
//     (`VirtualMachine.PowerOnVM_Task`)
//
//   - Test failover and test secondary restart
//     (`VirtualMachine.TerminateFaultTolerantVM_Task`)
//
//   - In a cluster using DRS and HA with admission control turned on
//     (`ClusterDasConfigInfo*.*ClusterDasConfigInfo.admissionControlEnabled`),
//     the vCenter Server might not migrate virtual machines from hosts
//     entering maintenance mode. This is because resources are reserved
//     to maintain the failover level. You must use vMotion to manually
//     migrate the virtual machines off the hosts.
//
//     When admission control is disabled, failover resource constraints
//     are not passed on to DRS and DPM. The constraints are not enforced.
//
//   - DRS determines virtual machine placement and status
//     (maintenance mode, standby mode) regardless of the impact
//     this might have on failover requirements.
//
//   - DPM powers off hosts (places them in standby mode)
//     even if doing so violates failover requirements.
//     If there is insufficient capacity when a failover
//     occurs, DPM will attempt to bring more capacity online
//     in order to correct the situation.
//
//   - You must enable EVC in a cluster to enable DRS to manage FT primary
//     and secondary virtual machine pairs in the cluster.
//     For information about EVC clusters, see `EVCMode`.
//
//     If EVC is disabled, vCenter automatically creates overrides
//     to disable DRS for FT primary/secondary pairs in the cluster.
//     vCenter will still use DRS to place a secondary virtual machine
//     when it powers on.
//     Attempts to remove the overrides or to enable DRS operations
//     will fail.
//
//   - EVC clusters support load balancing of powered on FT primary
//     and secondary virtual machines. DRS behavior
//     is governed by the overrides defined for the primary virtual
//     machine. The secondary inherits DRS behavior from its primary.
//     If you do not configure a DRS override for an FT virtual
//     machine, DRS uses the cluster default
//     (`ClusterDrsConfigInfo.defaultVmBehavior`).
//
// <sup>1</sup>High Availability was previously called Distributed
// Availability Services.
type ClusterConfigSpecEx struct {
	ComputeResourceConfigSpec

	// Configuration for vCLS system VMs deployment.
	SystemVMsConfig *ClusterSystemVMsConfigSpec `xml:"systemVMsConfig,omitempty" json:"systemVMsConfig,omitempty" vim:"7.0.3.0"`
	// HA configuration; includes default settings for virtual machines.
	DasConfig *ClusterDasConfigInfo `xml:"dasConfig,omitempty" json:"dasConfig,omitempty"`
	// HA configuration for individual virtual machines.
	//
	// The entries in this array override the cluster default
	// settings
	// (`ClusterDasConfigInfo*.*ClusterDasConfigInfo.defaultVmSettings`).
	// You cannot specify an HA override for a secondary FT virtual
	// machine. The secondary virtual machine will inherit whatever
	// settings apply to its primary virtual machine. If you
	// include an entry for a secondary, the reconfigure method
	// will throw the fault
	// `CannotChangeHaSettingsForFtSecondary`.
	DasVmConfigSpec []ClusterDasVmConfigSpec `xml:"dasVmConfigSpec,omitempty" json:"dasVmConfigSpec,omitempty"`
	// DRS configuration; includes default settings for virtual machines.
	DrsConfig *ClusterDrsConfigInfo `xml:"drsConfig,omitempty" json:"drsConfig,omitempty"`
	// DRS configuration for individual virtual machines.
	//
	// The entries in this array override the cluster default
	// settings
	// (`ClusterDrsConfigInfo*.*ClusterDrsConfigInfo.defaultVmBehavior`).
	// You cannot specify a DRS override for a secondary FT virtual
	// machine. The secondary virtual machine will inherit whatever
	// setting applies to its primary virtual machine. If you
	// include an entry for a secondary, the reconfigure method
	// will throw the fault
	// `CannotChangeDrsBehaviorForFtSecondary`.
	DrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"drsVmConfigSpec,omitempty" json:"drsVmConfigSpec,omitempty"`
	// Cluster affinity and anti-affinity rule configuration.
	RulesSpec []ClusterRuleSpec `xml:"rulesSpec,omitempty" json:"rulesSpec,omitempty"`
	// Cluster configuration of VM orchestration.
	Orchestration *ClusterOrchestrationInfo `xml:"orchestration,omitempty" json:"orchestration,omitempty"`
	// List of specific VM configurations that apply during cluster wide
	// VM orchestration.
	//
	// Each entry applies to one virtual machine, and
	// overrides the cluster default settings.
	VmOrchestrationSpec []ClusterVmOrchestrationSpec `xml:"vmOrchestrationSpec,omitempty" json:"vmOrchestrationSpec,omitempty"`
	// DPM configuration; includes default settings for hosts.
	DpmConfig *ClusterDpmConfigInfo `xml:"dpmConfig,omitempty" json:"dpmConfig,omitempty"`
	// DPM configuration for individual hosts.
	//
	// The entries in this array override the cluster default
	// settings
	// (`ClusterDpmConfigInfo*.*ClusterDpmConfigInfo.defaultDpmBehavior`).
	DpmHostConfigSpec []ClusterDpmHostConfigSpec `xml:"dpmHostConfigSpec,omitempty" json:"dpmHostConfigSpec,omitempty"`
	// VSAN configuration; includes default settings for hosts.
	//
	// When it is requested to change, vSAN related sub tasks will be
	// generated automatically per member hosts, which are identified
	// by using cluster reconfiguration task id as
	// `TaskInfo.parentTaskKey`, and should be monitored
	// and tracked separatedly.
	VsanConfig *VsanClusterConfigInfo `xml:"vsanConfig,omitempty" json:"vsanConfig,omitempty"`
	// VSAN configuration for individual hosts.
	//
	// The entries in this array override the cluster default settings
	// as specified in `VsanClusterConfigInfo`.
	VsanHostConfigSpec []VsanHostConfigInfo `xml:"vsanHostConfigSpec,omitempty" json:"vsanHostConfigSpec,omitempty"`
	// Cluster-wide group configuration.
	//
	// The array contains one or more group specification objects.
	// A group specification object contains a virtual machine group
	// (`ClusterVmGroup`) or a host group (`ClusterHostGroup`).
	// Groups can be related; see `ClusterVmHostRuleInfo`.
	GroupSpec []ClusterGroupSpec `xml:"groupSpec,omitempty" json:"groupSpec,omitempty"`
	// InfraUpdateHA configuration.
	InfraUpdateHaConfig *ClusterInfraUpdateHaConfigInfo `xml:"infraUpdateHaConfig,omitempty" json:"infraUpdateHaConfig,omitempty"`
	// ProactiveDrs configuration.
	ProactiveDrsConfig *ClusterProactiveDrsConfigInfo `xml:"proactiveDrsConfig,omitempty" json:"proactiveDrsConfig,omitempty"`
	// Flag to place the cluster in the HCI workflow during cluster creation.
	//
	// This flag is specified only at the time of cluster creation.
	// A cluster cannot be reconfigured to place it in the HCI workflow.
	InHciWorkflow *bool `xml:"inHciWorkflow" json:"inHciWorkflow,omitempty"`
	// Cluster-wide configuration of encryption mode.
	CryptoConfig *ClusterCryptoConfigInfo `xml:"cryptoConfig,omitempty" json:"cryptoConfig,omitempty"`
}

func init() {
	t["ClusterConfigSpecEx"] = reflect.TypeOf((*ClusterConfigSpecEx)(nil)).Elem()
}

// This event records when a cluster is created.
type ClusterCreatedEvent struct {
	ClusterEvent

	// The folder where the cluster is created.
	Parent FolderEventArgument `xml:"parent" json:"parent"`
}

func init() {
	t["ClusterCreatedEvent"] = reflect.TypeOf((*ClusterCreatedEvent)(nil)).Elem()
}

type ClusterCryptoConfigInfo struct {
	DynamicData

	// The cluster encryption mode.
	//
	// See `ClusterCryptoConfigInfoCryptoMode_enum` for supported values.
	CryptoMode string `xml:"cryptoMode,omitempty" json:"cryptoMode,omitempty"`
	// The encryption mode policy for the cluster.
	//
	// When unset, host keys will be automatically generated using the current
	// default key provider.
	Policy *ClusterComputeResourceCryptoModePolicy `xml:"policy,omitempty" json:"policy,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["ClusterCryptoConfigInfo"] = reflect.TypeOf((*ClusterCryptoConfigInfo)(nil)).Elem()
}

// Deprecated as of vSphere API 5.0, this object is no longer returned by
// vCenter Server. Availability information is now reported using
// `HostRuntimeInfo.dasHostState`.
//
// The `ClusterDasAamHostInfo` object contains a list of the ESX hosts
// in an HA cluster and a list that identifies the _primary_ hosts.
//
// (AAM is a component of the HA service.)
// The primary hosts share the joint responsibility of maintaining all cluster
// state and one will initiate failover actions should a failure occur.
//
// When you add an ESX host to a vSphere HA cluster, the host
// downloads HA agent components from the vCenter Server.
// The HA agent maintains communication with the vCenter Server.
//
// When the host downloads the HA agent, the host configures the agent
// to communicate with other agents in the cluster. A host that joins
// the cluster communicates with an existing primary host to complete
// its configuration (except when you are adding the first host to the cluster).
//   - The first five hosts added to the cluster are designated
//     as primary hosts. All subsequent hosts are designated as secondary hosts.
//   - If a primary host is removed from the cluster,
//     the vCenter Server promotes another host to primary status.
//   - There must be at least one functional primary host for vSphere HA
//     to operate correctly. If there is not an available primary host
//     (no response), host configuration for HA will fail.
//     If there is a total cluster failure, HA will begin restarting virtual
//     machines as soon as one host recovers and its HA agent is up and running.
//
// One of the primary hosts assumes the role of the active primary host.
// The active primary host responsibilities include the following activities:
//   - Decides where to restart virtual machines.
//   - Tracks failed restart attempts.
//   - Determines when it is appropriate to continue attempts to restart
//     a virtual machine.
//
// If the active primary host fails, another primary host replaces it.
type ClusterDasAamHostInfo struct {
	ClusterDasHostInfo

	// The state of HA on the hosts.
	HostDasState []ClusterDasAamNodeState `xml:"hostDasState,omitempty" json:"hostDasState,omitempty"`
	// The list of primary hosts.
	PrimaryHosts []string `xml:"primaryHosts,omitempty" json:"primaryHosts,omitempty"`
}

func init() {
	t["ClusterDasAamHostInfo"] = reflect.TypeOf((*ClusterDasAamHostInfo)(nil)).Elem()
}

// Deprecated as of vSphere API 5.0, this object is no longer returned by
// vCenter Server. See `HostRuntimeInfo.dasHostState` for a
// description of the objects now used.
//
// The `ClusterDasAamNodeState` data object represents the state
// of the HA service on an ESX host.
//
// (AAM is a component of this service.)
type ClusterDasAamNodeState struct {
	DynamicData

	// Reference to the host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Name of the host
	// (`HostSystem*.*ManagedEntity.name`).
	Name string `xml:"name" json:"name"`
	// Configuration state of the HA agent on the host.
	//
	// The property can be one of the following values:
	//
	// configuring
	// error
	// unconfiguring
	// running
	//
	// <code>configState</code> represents setting or resetting the HA
	// configuration on the host. If the configuration operation is
	// successful, the value of <code>configState</code> changes
	// to <code>running</code>. See `ClusterDasAamNodeStateDasState_enum`.
	ConfigState string `xml:"configState" json:"configState"`
	// The runtime state of the HA agent on the node.
	//
	// The property can be one of the following values:
	//
	// uninitialized
	// initialized
	// running
	// error
	// agentShutdown
	// nodeFailed
	//
	// See `ClusterDasAamNodeStateDasState_enum`.
	RuntimeState string `xml:"runtimeState" json:"runtimeState"`
}

func init() {
	t["ClusterDasAamNodeState"] = reflect.TypeOf((*ClusterDasAamNodeState)(nil)).Elem()
}

// Base class for admission control related information of a vSphere HA cluster.
type ClusterDasAdmissionControlInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasAdmissionControlInfo"] = reflect.TypeOf((*ClusterDasAdmissionControlInfo)(nil)).Elem()
}

// Base class for specifying how admission control should be done for vSphere HA.
type ClusterDasAdmissionControlPolicy struct {
	DynamicData

	// Percentage of resource reduction that a cluster of VMs can tolerate
	// in case of a failover.
	ResourceReductionToToleratePercent *int32 `xml:"resourceReductionToToleratePercent" json:"resourceReductionToToleratePercent,omitempty"`
	// Flag that determines whether strict admission control for persistent
	// memory is enabled.
	//
	// By default, this value is false.
	// This flag can only be set to true if
	// `ClusterDasConfigInfo.admissionControlEnabled` is set to true.
	// When you use persistent memory admission control, the following
	// operations are prevented, if doing so would violate the
	// `ClusterDasConfigInfo.admissionControlEnabled`.
	//   - Creating a virtual machine with persistent memory.
	//   - Adding a virtual persistent memory device to a virtual machine.
	//   - Increasing the capacity of a virtual persistent memory device.
	PMemAdmissionControlEnabled *bool `xml:"pMemAdmissionControlEnabled" json:"pMemAdmissionControlEnabled,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["ClusterDasAdmissionControlPolicy"] = reflect.TypeOf((*ClusterDasAdmissionControlPolicy)(nil)).Elem()
}

// Base class for advanced runtime information related to the high
// availability service for a cluster.
type ClusterDasAdvancedRuntimeInfo struct {
	DynamicData

	// The information pertaining to the HA agents on the hosts
	DasHostInfo BaseClusterDasHostInfo `xml:"dasHostInfo,omitempty,typeattr" json:"dasHostInfo,omitempty"`
	// Whether HA VM Component Protection can be enabled for the cluster.
	VmcpSupported *ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo `xml:"vmcpSupported,omitempty" json:"vmcpSupported,omitempty"`
	// The map of a datastore to the set of hosts that are using
	// the datastore for storage heartbeating.
	HeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo `xml:"heartbeatDatastoreInfo,omitempty" json:"heartbeatDatastoreInfo,omitempty"`
}

func init() {
	t["ClusterDasAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasAdvancedRuntimeInfo)(nil)).Elem()
}

// Class for capability to support VM Component Protection
type ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo struct {
	DynamicData

	// If all hosts in the cluster support the reaction of VM Component Protection
	// to storage All Paths Down timeout
	// (@link vim.host.MountInfo.InaccessibleReason#AllPathsDown\_Timeout}
	StorageAPDSupported bool `xml:"storageAPDSupported" json:"storageAPDSupported"`
	// If all hosts in the cluster support the reaction of VM Component Protection
	// to storage Permanent Device Loss
	// (@link vim.host.MountInfo.InaccessibleReason#PermanentDeviceLoss}
	StoragePDLSupported bool `xml:"storagePDLSupported" json:"storagePDLSupported"`
}

func init() {
	t["ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo"] = reflect.TypeOf((*ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo)(nil)).Elem()
}

// The `ClusterDasConfigInfo` data object contains configuration data
// about the HA service on a cluster.
//
// All fields are optional. If you set the <code>modify</code>
// parameter to <code>true</code> when you call
// `ComputeResource.ReconfigureComputeResource_Task`, an unset property has no effect
// on the existing property value in the cluster configuration on the Server.
// If you set the <code>modify</code> parameter to <code>false</code> when you
// reconfigure a cluster, the cluster configuration is reverted to the default
// values, then the new configuration values are applied.
type ClusterDasConfigInfo struct {
	DynamicData

	// Flag to indicate whether or not vSphere HA feature is enabled.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Level of HA Virtual Machine Health Monitoring Service.
	//
	// You can monitor both guest and application heartbeats, guest heartbeats only,
	// or you can disable the service. See `ClusterDasConfigInfoVmMonitoringState_enum`.
	// The default value is `vmMonitoringDisabled`.
	//
	// The Service level specified for the cluster determines
	// the possible monitoring settings that you can use for individual virtual machines.
	// See `ClusterVmToolsMonitoringSettings*.*ClusterVmToolsMonitoringSettings.vmMonitoring`.
	VmMonitoring string `xml:"vmMonitoring,omitempty" json:"vmMonitoring,omitempty"`
	// Determines whether HA restarts virtual machines after a host fails.
	//
	// The default value is
	// `ClusterDasConfigInfoServiceState_enum*.*enabled`.
	// This property is meaningful only when
	// `ClusterDasConfigInfo*.*ClusterDasConfigInfo.enabled` is <code>true</code>.
	//
	// When <code>hostMonitoring</code> is
	// `enabled`, HA restarts virtual machines
	// after a host fails.
	//
	// When <code>hostMonitoring</code> is
	// `disabled`, HA does not restart
	// virtual machines after a host fails.
	// The status of Host Monitoring does not affect other services such
	// as virtual machine Health Monitoring or Fault Tolerance.
	// The rest of the cluster operations follow normal processing.
	// No configuration information is lost and re-enabling the service
	// is a quick operation.
	HostMonitoring string `xml:"hostMonitoring,omitempty" json:"hostMonitoring,omitempty"`
	// This property indicates if vSphere HA VM Component Protection service
	// is enabled.
	//
	// The default value is `disabled`.
	//
	// When <code>vmComponentProtecting</code> is set to
	// `disabled`, reaction to all types of VM
	// component failures is disabled.
	//
	// When <code>vmComponentProtecting</code> is set to
	// `enabled`, VM Component Protection service
	// will detect and react to component failures. The actual reaction is determined
	// by `ClusterVmComponentProtectionSettings` which is referenced by both cluster
	// level configuration (`ClusterDasConfigInfo.defaultVmSettings`) and per-VM
	// override `ClusterConfigInfoEx.dasVmConfig`.
	VmComponentProtecting string `xml:"vmComponentProtecting,omitempty" json:"vmComponentProtecting,omitempty"`
	// Deprecated as of vSphere API 4.0, use
	// `ClusterFailoverLevelAdmissionControlPolicy` to set
	// `ClusterDasConfigInfo.admissionControlPolicy`.
	//
	// Configured failover level.
	//
	// This is the number of physical host failures
	// that can be tolerated without impacting the ability to satisfy the
	// minimums for all running virtual machines. Acceptable values range from one to
	// four.
	FailoverLevel int32 `xml:"failoverLevel,omitempty" json:"failoverLevel,omitempty"`
	// Virtual machine admission control policy for vSphere HA.
	//
	// The policies specify resource availability for failover support.
	//   - Failover host admission policy
	//     `ClusterFailoverHostAdmissionControlPolicy` -
	//     specify one or more dedicated failover hosts.
	//   - Failover level policy
	//     `ClusterFailoverLevelAdmissionControlPolicy` -
	//     the limit of host failures for which resources are reserved.
	//     When you use the failover level policy,
	//     HA partitions resources into slots. A slot represents the minimum
	//     CPU and memory resources that are required to support
	//     any powered on virtual machine in the cluster.
	//     To retrieve information about partitioned resources, use the
	//     `ClusterComputeResource.RetrieveDasAdvancedRuntimeInfo`
	//     method.
	//   - Resources admission policy
	//     `ClusterFailoverResourcesAdmissionControlPolicy` -
	//     CPU and memory resources reserved for failover support.
	//     When you use the resources policy, you can reserve
	//     a percentage of the aggregate cluster resource for failover.
	AdmissionControlPolicy BaseClusterDasAdmissionControlPolicy `xml:"admissionControlPolicy,omitempty,typeattr" json:"admissionControlPolicy,omitempty"`
	// Flag that determines whether strict admission control is enabled.
	//
	// When you use admission control, the following operations are
	// prevented, if doing so would violate the `ClusterDasConfigInfo.admissionControlPolicy`.
	//   - Powering on a virtual machine in the cluster.
	//   - Migrating a virtual machine into the cluster.
	//   - Increasing the CPU or memory reservation of powered-on
	//     virtual machines in the cluster.
	//
	// With admission control disabled, there is no assurance that
	// all virtual machines in the HA cluster can be restarted after
	// a host failure. VMware recommends that you do not disable
	// admission control, but you might need to do so temporarily,
	// for the following reasons:
	//   - If you need to violate the failover constraints when there
	//     are not enough resources to support them (for example,
	//     if you are placing hosts in standby mode to test them
	//     for use with DPM).
	//   - If an automated process needs to take actions that might
	//     temporarily violate the failover constraints (for example,
	//     as part of an upgrade directed by VMware Update Manager).
	//   - If you need to perform testing or maintenance operations.
	AdmissionControlEnabled *bool `xml:"admissionControlEnabled" json:"admissionControlEnabled,omitempty"`
	// Cluster-wide defaults for virtual machine HA settings.
	//
	// When a virtual machine has no HA configuration
	// (`ClusterDasVmConfigSpec`), it uses the values
	// specified here.
	DefaultVmSettings *ClusterDasVmSettings `xml:"defaultVmSettings,omitempty" json:"defaultVmSettings,omitempty"`
	// Advanced settings.
	Option []BaseOptionValue `xml:"option,omitempty,typeattr" json:"option,omitempty"`
	// The list of preferred datastores to use for storage heartbeating.
	//
	// Each of the specified datastores should be active and mounted
	// by more than one host. There is no limit on the number of specified
	// datastores and no priority among them.
	// The specified datastores will replace those previously specified and
	// an empty list will delete all such earlier specified ones.
	//
	// vCenter Server chooses the heartbeat datastores for a host from the
	// set specified by `ClusterDasConfigInfo.hBDatastoreCandidatePolicy`.
	// The choice is made based on datastore connectivity and storage array
	// redundancy (in case of VMFS).
	//
	// The final set of selected heartbeat datastores is reported via
	// `ClusterDasAdvancedRuntimeInfo.heartbeatDatastoreInfo`.
	//
	// Refers instances of `Datastore`.
	HeartbeatDatastore []ManagedObjectReference `xml:"heartbeatDatastore,omitempty" json:"heartbeatDatastore,omitempty"`
	// The policy on what datastores will be used by vCenter Server to choose
	// heartbeat datastores.
	//
	// See `ClusterDasConfigInfoHBDatastoreCandidate_enum` for all options.
	// The default value is
	// `allFeasibleDsWithUserPreference`.
	HBDatastoreCandidatePolicy string `xml:"hBDatastoreCandidatePolicy,omitempty" json:"hBDatastoreCandidatePolicy,omitempty"`
}

func init() {
	t["ClusterDasConfigInfo"] = reflect.TypeOf((*ClusterDasConfigInfo)(nil)).Elem()
}

// Base class for DAS data for high availability service for a cluster.
type ClusterDasData struct {
	DynamicData
}

func init() {
	t["ClusterDasData"] = reflect.TypeOf((*ClusterDasData)(nil)).Elem()
}

// This class contains the summary of the data that DAS needs/uses.
//
// The actual data is available in `ClusterDasDataDetails` and can be retrieved
// using the `ClusterComputeResource.RetrieveDasData` method.
// This class is meant for VMware internal use only.
type ClusterDasDataSummary struct {
	ClusterDasData

	// The version corresponding to the hostList
	HostListVersion int64 `xml:"hostListVersion" json:"hostListVersion"`
	// The version corresponding to the clusterConfig
	ClusterConfigVersion int64 `xml:"clusterConfigVersion" json:"clusterConfigVersion"`
	// The version corresponding to the compatList
	CompatListVersion int64 `xml:"compatListVersion" json:"compatListVersion"`
}

func init() {
	t["ClusterDasDataSummary"] = reflect.TypeOf((*ClusterDasDataSummary)(nil)).Elem()
}

// Advanced runtime information related to the high availability service
// for a cluster that has been configured with a failover level admission control
// policy.
//
// See `ClusterFailoverLevelAdmissionControlPolicy`.
type ClusterDasFailoverLevelAdvancedRuntimeInfo struct {
	ClusterDasAdvancedRuntimeInfo

	// Slot information for this cluster.
	SlotInfo ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo `xml:"slotInfo" json:"slotInfo"`
	// The total number of slots available in the cluster.
	//
	// See also `ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo`.
	TotalSlots int32 `xml:"totalSlots" json:"totalSlots"`
	// The number of slots currently being used.
	//
	// See also `ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo`.
	UsedSlots int32 `xml:"usedSlots" json:"usedSlots"`
	// The number of slots that are not used by currently powered on virtual machines
	// and not reserved to satisfy the configured failover level.
	//
	// This number gives
	// an indication of how many additional virtual machines can be powered on in
	// this cluster without violating the failover level (assuming the new virtual
	// machine's reservations are satisfied by the current slot size).
	// This value is computed as follows (where m is the configured failover level):
	// Remove the m largest hosts (ie. the ones with the most slots) from the list
	// of "good" hosts (see `ClusterDasFailoverLevelAdvancedRuntimeInfo.totalGoodHosts`). Sum up the number of slots on
	// the remaining hosts and deduct the number of currently used slots
	// (see `ClusterDasFailoverLevelAdvancedRuntimeInfo.usedSlots`). If this number is negative, use zero instead.
	//
	// See also `ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo`.
	UnreservedSlots int32 `xml:"unreservedSlots" json:"unreservedSlots"`
	// The total number of powered on vms in the cluster.
	TotalVms int32 `xml:"totalVms" json:"totalVms"`
	// The total number of hosts in the cluster.
	TotalHosts int32 `xml:"totalHosts" json:"totalHosts"`
	// The total number of connected hosts that are not in maintance mode and that
	// do not have any DAS-related config issues on them.
	TotalGoodHosts int32                                                 `xml:"totalGoodHosts" json:"totalGoodHosts"`
	HostSlots      []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"hostSlots,omitempty" json:"hostSlots,omitempty"`
	// The list of virtual machines whose reservations and memory overhead are not
	// satisfied by a single slot.
	VmsRequiringMultipleSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots `xml:"vmsRequiringMultipleSlots,omitempty" json:"vmsRequiringMultipleSlots,omitempty"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	DynamicData

	// The reference to the host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// The number of slots in this host.
	Slots int32 `xml:"slots" json:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

// A slot represents an amount of memory and cpu resources on a physical host for use
// by a virtual machine.
//
// It is used in computing the resources to be reserved for
// failover.
type ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo struct {
	DynamicData

	// Deprecated as of vSphere API 5.0, the number of vcpus is no longer used
	// for slot calculations.
	//
	// The number of virtual cpus of a slot is defined as the maximum number of
	// virtual cpus any powered on virtual machine has.
	NumVcpus int32 `xml:"numVcpus" json:"numVcpus"`
	// The cpu speed of a slot is defined as the maximum cpu reservation of any
	// powered on virtual machine in the cluster, or any otherwise defined minimum,
	// whichever is larger.
	CpuMHz int32 `xml:"cpuMHz" json:"cpuMHz"`
	// The memory size of a slot is defined as the maximum memory reservation plus
	// memory overhead of any powered on virtual machine in the cluster, or any
	// otherwise defined minimum, whichever is larger.
	MemoryMB int32 `xml:"memoryMB" json:"memoryMB"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	DynamicData

	// The reference to the virtual machine
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The number of slots required by this virtual machine
	Slots int32 `xml:"slots" json:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

// The `ClusterDasFdmHostState` data object
// describes the availability state of each active host in a
// vSphere HA enabled cluster.
//
// In a vSphere HA cluster, the active hosts form a fault domain.
// A host is inactive if it is in standby or maintenance mode, or
// it has been disconnected from vCenter Server. A vSphere HA
// agent, called the Fault Domain Manager (FDM), runs on each host in the
// fault domain.
//
// One FDM serves as the master and the remaining FDMs as its slaves.
// The master is responsible for monitoring the availability of the hosts
// and VMs in the cluster, and restarting any VMs that fail due to a
// host failure or non-user-initiated power offs. The master is also
// responsible for reporting fault-domain state to vCenter Server.
//
// The master FDM is determined through election by the FDMs that are
// alive at the time. An election occurs in the following circumstances:
//   - When the vSphere HA feature is enabled for the cluster.
//   - When the master's host fails.
//   - When the management network is partitioned. In a network partition
//     there will be a master for each partition. However, only one master
//     will be responsible for a given VM. When the partition is
//     resolved, all but one of the masters will abdicate.
//   - After a host in a vSphere HA cluster powers back up following a failure
//     that caused all hosts in the cluster to power off.
//
// The slaves are responsible for reporting state updates to the master and
// restarting VMs as required. All FDMs provide the VM/Application Health
// Monitoring Service.
type ClusterDasFdmHostState struct {
	DynamicData

	// The Availability State of a host based on information
	// reported by the entity given by the
	// `ClusterDasFdmHostState.stateReporter` property.
	//
	// See
	// `ClusterDasFdmAvailabilityState_enum` for the set of
	// states.
	State string `xml:"state" json:"state"`
	// The entity reporting the state of the host.
	//
	// If the reporter is a host,
	// the property reports which host, whereas if the reporter is vCenter Server,
	// the property is unset.
	//
	// Refers instance of `HostSystem`.
	StateReporter *ManagedObjectReference `xml:"stateReporter,omitempty" json:"stateReporter,omitempty"`
}

func init() {
	t["ClusterDasFdmHostState"] = reflect.TypeOf((*ClusterDasFdmHostState)(nil)).Elem()
}

// HA specific advanced information pertaining to the hosts in the cluster.
type ClusterDasHostInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasHostInfo"] = reflect.TypeOf((*ClusterDasHostInfo)(nil)).Elem()
}

// A host recommendation for a virtual machine managed by the VMware
// HA Service.
type ClusterDasHostRecommendation struct {
	DynamicData

	// The recommended host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Rating as computed by DRS for a DRS-enabled cluster.
	//
	// Rating
	// range from 1 to 5, and the higher the rating, the stronger DRS
	// suggests this host is picked for the operation.
	DrsRating int32 `xml:"drsRating,omitempty" json:"drsRating,omitempty"`
}

func init() {
	t["ClusterDasHostRecommendation"] = reflect.TypeOf((*ClusterDasHostRecommendation)(nil)).Elem()
}

// The `ClusterDasVmConfigInfo` data object contains
// the HA configuration for a single virtual machine.
//
// All fields are optional. If you set the <code>modify</code>
// parameter to <code>true</code> when you call
// `ComputeResource.ReconfigureComputeResource_Task`, an unset property has no effect
// on the existing property value in the cluster configuration on the Server.
// If you set the <code>modify</code> parameter to <code>false</code> when you
// reconfigure a cluster, the cluster configuration is reverted to the default
// values, then the new configuration values are applied.
type ClusterDasVmConfigInfo struct {
	DynamicData

	// Reference to the virtual machine.
	//
	// Refers instance of `VirtualMachine`.
	Key ManagedObjectReference `xml:"key" json:"key"`
	// Deprecated as of VI API 2.5, use
	// `ClusterDasVmConfigInfo.dasSettings*.*ClusterDasVmSettings.restartPriority`.
	// If you specify `ClusterDasVmConfigInfo.restartPriority` here and in
	// `ClusterDasVmSettings`, the value in `ClusterDasVmSettings`
	// has precedence.
	//
	// Restart priority for a virtual machine.
	//
	// If there is nothing specified here, then the defaults are picked up from
	// `ClusterDasConfigInfo.defaultVmSettings`.
	RestartPriority DasVmPriority `xml:"restartPriority,omitempty" json:"restartPriority,omitempty"`
	// Deprecated as of VI API 2.5, use
	// `ClusterDasVmConfigInfo.dasSettings*.*ClusterDasVmSettings.isolationResponse`.
	// If you specify both `ClusterDasVmConfigInfo.powerOffOnIsolation` and
	// `ClusterDasVmSettings.isolationResponse`, the value in
	// `ClusterDasVmSettings.isolationResponse` has precedence.
	//
	// Flag to indicate whether or not the virtual machine should be powered off if a
	// host determines that it is isolated from the rest of the compute resource.
	//
	// If there is nothing specified here, then the defaults are picked up from
	// `ClusterDasConfigInfo.defaultVmSettings`.
	PowerOffOnIsolation *bool `xml:"powerOffOnIsolation" json:"powerOffOnIsolation,omitempty"`
	// HA settings that apply to this virtual machine.
	//
	// Values specified in this object override the cluster-wide
	// defaults for virtual machines (`ClusterDasConfigInfo.defaultVmSettings`).
	DasSettings *ClusterDasVmSettings `xml:"dasSettings,omitempty" json:"dasSettings,omitempty"`
}

func init() {
	t["ClusterDasVmConfigInfo"] = reflect.TypeOf((*ClusterDasVmConfigInfo)(nil)).Elem()
}

// An incremental update to the per-virtual-machine vSphere HA configuration.
type ClusterDasVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDasVmConfigInfo `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterDasVmConfigSpec"] = reflect.TypeOf((*ClusterDasVmConfigSpec)(nil)).Elem()
}

// The `ClusterDasVmSettings` data object contains the HA configuration
// settings specified for a single virtual machine (identified by
// `ClusterDasVmConfigInfo*.*ClusterDasVmConfigInfo.key`)
// or as cluster-wide defaults
// `ClusterDasConfigInfo*.*ClusterDasConfigInfo.defaultVmSettings`
//
// All fields are optional. If you set the <code>modify</code> parameter to
// <code>true</code> when you call `ComputeResource.ReconfigureComputeResource_Task`,
// an unset property has no effect on the existing property value in the
// cluster configuration on the Server. If you set the <code>modify</code>
// parameter to <code>false</code> when you reconfigure a cluster, the cluster
// configuration is reverted to the default values, then the new configuration
// values are applied.
type ClusterDasVmSettings struct {
	DynamicData

	// Restart priority for a virtual machine.
	//
	// If not specified at either the cluster level or
	// the virtual machine level, this will default to <code>medium</code>.
	//
	// See also `ClusterDasVmSettingsRestartPriority_enum`.
	RestartPriority string `xml:"restartPriority,omitempty" json:"restartPriority,omitempty"`
	// This setting is used to specify a maximum time the lower priority VMs
	// should wait for the higher priority VMs to be ready.
	//
	// If the higher
	// priority Vms are not ready by this time, then the lower priority VMs
	// are restarted irrespective of the VM ready state. This timeout can be
	// used to prevent the failover of lower priority VMs to be stuck
	// infinitely.
	//
	// This timeout is not used if ready condition is
	// `none`
	//
	// Timeout specified in seconds. To use cluster setting for a VM override,
	// set to -1 in per-VM.
	// setting.
	RestartPriorityTimeout int32 `xml:"restartPriorityTimeout,omitempty" json:"restartPriorityTimeout,omitempty"`
	// Indicates whether or not the virtual machine should be powered off if a
	// host determines that it is isolated from the rest of the compute
	// resource.
	//
	// If not specified at either the cluster level or
	// the virtual machine level, this will default to <code>powerOff</code>.
	//
	// See also `ClusterDasVmSettingsIsolationResponse_enum`.
	IsolationResponse string `xml:"isolationResponse,omitempty" json:"isolationResponse,omitempty"`
	// Configuration for the VM Health Monitoring Service.
	VmToolsMonitoringSettings *ClusterVmToolsMonitoringSettings `xml:"vmToolsMonitoringSettings,omitempty" json:"vmToolsMonitoringSettings,omitempty"`
	// Configuration for the VM Component Protection Service.
	VmComponentProtectionSettings *ClusterVmComponentProtectionSettings `xml:"vmComponentProtectionSettings,omitempty" json:"vmComponentProtectionSettings,omitempty"`
}

func init() {
	t["ClusterDasVmSettings"] = reflect.TypeOf((*ClusterDasVmSettings)(nil)).Elem()
}

// An incremental update to a Datastore list.
type ClusterDatastoreUpdateSpec struct {
	ArrayUpdateSpec

	// Refers instance of `Datastore`.
	Datastore *ManagedObjectReference `xml:"datastore,omitempty" json:"datastore,omitempty"`
}

func init() {
	t["ClusterDatastoreUpdateSpec"] = reflect.TypeOf((*ClusterDatastoreUpdateSpec)(nil)).Elem()
	minAPIVersionForType["ClusterDatastoreUpdateSpec"] = "7.0.3.0"
}

// The `ClusterDependencyRuleInfo` data object indentifies VM-to-VM
// dependencies.
//
// A VM-VM Dependency rule identifies the following groups.
//   - A virtual machine group - `ClusterDependencyRuleInfo.vmGroup`
//   - A "depends on" virtual machine group - `ClusterDependencyRuleInfo.dependsOnVmGroup`.
//
// The VMs in `ClusterDependencyRuleInfo.vmGroup` depends on the list of VMs specified in `ClusterDependencyRuleInfo.dependsOnVmGroup`.
//
// For example, this rule is used during vSphere HA VM recovery
// orchestration. vSphere HA will not restart the VMs in `ClusterDependencyRuleInfo.vmGroup`
// until all the VMs in `ClusterDependencyRuleInfo.dependsOnVmGroup` are deemded "ready" (See
// `ClusterVmReadiness`).
//
// All the virtual machines referenced by this rule must be in
// the same cluster.
type ClusterDependencyRuleInfo struct {
	ClusterRuleInfo

	// Virtual group name.
	//
	// The virtual group may contain one or more virtual
	// machines.
	// `ClusterVmGroup*.*ClusterGroupInfo.name`
	VmGroup string `xml:"vmGroup" json:"vmGroup"`
	// Depdendency virtual group name
	// (`ClusterVmGroup*.*ClusterGroupInfo.name`).
	//
	// The virtual group may contain one or more virtual machines.
	DependsOnVmGroup string `xml:"dependsOnVmGroup" json:"dependsOnVmGroup"`
}

func init() {
	t["ClusterDependencyRuleInfo"] = reflect.TypeOf((*ClusterDependencyRuleInfo)(nil)).Elem()
}

// This event records when a cluster is destroyed.
type ClusterDestroyedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterDestroyedEvent"] = reflect.TypeOf((*ClusterDestroyedEvent)(nil)).Elem()
}

// Configuration of the VMware DPM service.
//
// All fields are defined as optional. In case of a reconfiguration,
// unset fields are not changed.
type ClusterDpmConfigInfo struct {
	DynamicData

	// Flag indicating whether or not the service is enabled.
	//
	// This
	// service can not be enabled, unless DRS is enabled as well.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Specifies the default VMware DPM behavior for
	// hosts.
	//
	// This default behavior can be overridden on a per host
	// basis using the `ClusterDpmHostConfigInfo` object.
	DefaultDpmBehavior DpmBehavior `xml:"defaultDpmBehavior,omitempty" json:"defaultDpmBehavior,omitempty"`
	// DPM generates only those recommendations that are above the
	// specified rating.
	//
	// Ratings vary from 1 to 5. This setting applies
	// to both manual and automated (@link DpmBehavior) DPM clusters.
	HostPowerActionRate int32 `xml:"hostPowerActionRate,omitempty" json:"hostPowerActionRate,omitempty"`
	// Deprecated as of vSphere API 4.1, use
	// `ClusterDrsConfigInfo.option`.
	//
	// Advanced settings.
	Option []BaseOptionValue `xml:"option,omitempty,typeattr" json:"option,omitempty"`
}

func init() {
	t["ClusterDpmConfigInfo"] = reflect.TypeOf((*ClusterDpmConfigInfo)(nil)).Elem()
}

// DPM configuration for a single host.
//
// This makes
// it possible to override the default behavior for an individual
// host.
type ClusterDpmHostConfigInfo struct {
	DynamicData

	// Reference to the host.
	//
	// Refers instance of `HostSystem`.
	Key ManagedObjectReference `xml:"key" json:"key"`
	// Flag to indicate whether or not VirtualCenter is allowed to perform any
	// power related operations or recommendations for this host.
	//
	// If this flag is false, the host is effectively excluded from
	// DPM service.
	//
	// If no individual DPM specification exists for a host,
	// this property defaults to true.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Specifies the particular DPM behavior for this host.
	//
	// See also `ClusterDpmConfigInfo`.
	Behavior DpmBehavior `xml:"behavior,omitempty" json:"behavior,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigInfo"] = reflect.TypeOf((*ClusterDpmHostConfigInfo)(nil)).Elem()
}

// The `ClusterDpmHostConfigSpec` data object provides information
// that the Server uses to update the DPM configuration for a
// single host (identified by the
// `ClusterDpmHostConfigInfo.key` property).
//
// The host DPM configuration overrides the cluster
// default DPM setting
// (`ClusterConfigSpecEx*.*ClusterConfigSpecEx.dpmConfig`).
//
// The vSphere API defines three update operations
// (`ArrayUpdateSpec*.*ArrayUpdateSpec.operation`).
//   - add: Define DPM behavior for a host. If the cluster
//     configuration already includes a DPM behavior override
//     for the specified host, this operation
//     removes the existing override and adds the new one.
//     The new DPM override will use the cluster default value
//     if you do not specify the behavior property
//     (`ClusterDpmConfigInfo.defaultDpmBehavior`).
//   - edit: Perform an incremental update to an existing
//     DPM configuration entry for a host.
//     The reconfigure method changes only the properties
//     that you set in the data object. The entry must exist
//     in the
//     `ClusterConfigSpecEx*.*ClusterConfigSpecEx.dpmHostConfigSpec` array.
//   - remove: Remove the DPM override for the specified
//     host. To identify the host to delete, use the
//     `ArrayUpdateSpec.removeKey` property
//     to specify the `ClusterDpmHostConfigInfo.key`
//     in the host override.
//
// Use the `ComputeResource.ReconfigureComputeResource_Task` method
// to update the DPM configuration. If you set the modify parameter
// to true, you can use any of the three operations (add, edit, or remove).
// If you set the modify parameter to false, you can use only the
// add operation.
type ClusterDpmHostConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDpmHostConfigInfo `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigSpec"] = reflect.TypeOf((*ClusterDpmHostConfigSpec)(nil)).Elem()
}

// The `ClusterDrsConfigInfo` data object contains configuration information
// for the VMware DRS service.
//
// All fields are optional. If you set the <code>modify</code>
// parameter to <code>true</code> when you call
// `ComputeResource.ReconfigureComputeResource_Task`, an unset property has no effect
// on the existing property value in the cluster configuration on the Server.
// If you set the <code>modify</code> parameter to <code>false</code> when you
// reconfigure a cluster, the cluster configuration is reverted to the default
// values, then the new configuration values are applied.
type ClusterDrsConfigInfo struct {
	DynamicData

	// Deprecated as of vSphere API 7.0.
	// To disable DRS load balancing, please use the lowest DRS aggressiveness
	// level, setting `ClusterDrsConfigInfo.vmotionRate` to 5, and/or
	// setting `ClusterDrsConfigInfo.defaultVmBehavior` to manual.
	// The former only generates manadatory move recommendations, not load
	// balancing recommendations. The latter only generates recommendations,
	// without executing them.
	// To remove all the child resource pools, please find the root resource
	// pool `ComputeResource.resourcePool`, and destroy all its
	// children `ResourcePool.DestroyChildren`.
	// Vice versa.
	//
	// Flag indicating whether or not DRS service is enabled.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Flag that dictates whether DRS Behavior overrides for individual
	// virtual machines (`ClusterDrsVmConfigInfo`) are enabled.
	//
	// The default
	// value is <code>true</code>.
	//
	// When this flag is <code>true</code>, the
	// `ClusterConfigSpecEx*.*ClusterConfigSpecEx.drsVmConfigSpec`
	// values override the `ClusterDrsConfigInfo.defaultVmBehavior`.
	//
	// When this flag is <code>false</code>, the
	// `ClusterDrsConfigInfo.defaultVmBehavior` value applies to all virtual
	// machines, with the following exception: in a cluster that has EVC disabled,
	// you cannot override the virtual machine setting
	// (`ClusterConfigSpecEx.drsVmConfigSpec`)
	// for Fault Tolerance virtual machines.
	EnableVmBehaviorOverrides *bool `xml:"enableVmBehaviorOverrides" json:"enableVmBehaviorOverrides,omitempty"`
	// Specifies the cluster-wide default DRS behavior for virtual machines.
	//
	// You can override the default behavior for a virtual machine
	// by using the `ClusterDrsVmConfigInfo` object.
	DefaultVmBehavior DrsBehavior `xml:"defaultVmBehavior,omitempty" json:"defaultVmBehavior,omitempty"`
	// Threshold for generated `ClusterRecommendation`s.
	//
	// DRS generates only those recommendations that are above the
	// specified vmotionRate. Ratings vary from 1 to 5. This setting applies
	// to manual, partiallyAutomated, and fullyAutomated
	// DRS clusters. See `DrsBehavior_enum`.
	VmotionRate int32 `xml:"vmotionRate,omitempty" json:"vmotionRate,omitempty"`
	// Specifies the scaling behavior of the shares of all resource pools
	// in the cluster.
	//
	// See `ResourceConfigSpecScaleSharesBehavior_enum`
	// for possible values. If any scaling behavior other than
	// `disabled` is specified,
	// the system will scale the CPU and memory shares allocated to each
	// resource pool with the total shares of all powered on virtual machines
	// under each respective pool. The system will also use the
	// `SharesInfo` set on each resource pool as a multiplier for the
	// scale. Setting the
	// `ClusterDrsConfigInfo.scaleDescendantsShares` on the cluster
	// is equivalent to setting the
	// `ResourceConfigSpec.scaleDescendantsShares` on the root
	// resource pool.
	ScaleDescendantsShares string `xml:"scaleDescendantsShares,omitempty" json:"scaleDescendantsShares,omitempty"`
	// Advanced settings.
	Option []BaseOptionValue `xml:"option,omitempty,typeattr" json:"option,omitempty"`
}

func init() {
	t["ClusterDrsConfigInfo"] = reflect.TypeOf((*ClusterDrsConfigInfo)(nil)).Elem()
}

// The faults generated by DRS when it tries to make recommendations
// for rule enforcement, power management, etc., and indexed in a tree
// structure with reason for recommendations and VM to migrate (optional)
// as the index keys.
type ClusterDrsFaults struct {
	DynamicData

	// A reason code explaining why this set of recommendations were attempted
	// by DRS when it generated the faults.
	Reason string `xml:"reason" json:"reason"`
	// The faults grouped by VMs that DRS was trying to migrate.
	FaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"faultsByVm,typeattr" json:"faultsByVm"`
}

func init() {
	t["ClusterDrsFaults"] = reflect.TypeOf((*ClusterDrsFaults)(nil)).Elem()
}

// The faults generated by storage DRS when it tries to move a virtual disk.
type ClusterDrsFaultsFaultsByVirtualDisk struct {
	ClusterDrsFaultsFaultsByVm

	// The virtual disk that storage DRS was trying to migrate when it
	// generated the faults.
	//
	// If this property is NULL, the fault is not
	// associated with a particular virtual disk.
	Disk *VirtualDiskId `xml:"disk,omitempty" json:"disk,omitempty"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVirtualDisk"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVirtualDisk)(nil)).Elem()
}

// FaultsByVm is the faults generated by DRS when it tries to
// move a VM.
type ClusterDrsFaultsFaultsByVm struct {
	DynamicData

	// The VM that DRS was trying to migrate when it generated the faults.
	//
	// If this property is NULL, the fault is not associated with a particular VM.
	//
	// Refers instance of `VirtualMachine`.
	Vm *ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
	// The faults generated by DRS when it was trying to move the given VM.
	Fault []LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

// Describes a single virtual machine migration.
type ClusterDrsMigration struct {
	DynamicData

	// A unique key that identifies this recommendation.
	//
	// This
	// is used as an argument to
	// ComputeResource.applyRecommendation.
	Key string `xml:"key" json:"key"`
	// The time this recommendation was computed.
	Time time.Time `xml:"time" json:"time"`
	// The virtual machine selected for migration.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Current CPU load for the virtual machine, in MHz.
	//
	// This property is only populated for recommendations.
	CpuLoad int32 `xml:"cpuLoad,omitempty" json:"cpuLoad,omitempty"`
	// Current memory load for the virtual machine, in bytes.
	//
	// This field is only populated for recommendations.
	MemoryLoad int64 `xml:"memoryLoad,omitempty" json:"memoryLoad,omitempty"`
	// Source host.
	//
	// Refers instance of `HostSystem`.
	Source ManagedObjectReference `xml:"source" json:"source"`
	// Current CPU load on the source host, in MHz.
	SourceCpuLoad int32 `xml:"sourceCpuLoad,omitempty" json:"sourceCpuLoad,omitempty"`
	// Current memory usage on the source host, in bytes.
	SourceMemoryLoad int64 `xml:"sourceMemoryLoad,omitempty" json:"sourceMemoryLoad,omitempty"`
	// Destination host.
	//
	// Refers instance of `HostSystem`.
	Destination ManagedObjectReference `xml:"destination" json:"destination"`
	// Current CPU load on the destination host, in MHz.
	DestinationCpuLoad int32 `xml:"destinationCpuLoad,omitempty" json:"destinationCpuLoad,omitempty"`
	// Current memory usage on the destination host, in bytes.
	DestinationMemoryLoad int64 `xml:"destinationMemoryLoad,omitempty" json:"destinationMemoryLoad,omitempty"`
}

func init() {
	t["ClusterDrsMigration"] = reflect.TypeOf((*ClusterDrsMigration)(nil)).Elem()
}

// Deprecated as of VI API 2.5 use `ClusterRecommendation`.
//
// DrsRecommendation describes a recommendation to migrate
// one or more virtual machines.
type ClusterDrsRecommendation struct {
	DynamicData

	// Key to identify the recommendation when calling applyRecommendation.
	Key string `xml:"key" json:"key"`
	// A rating of the recommendation.
	//
	// Valid values range from 1 (lowest confidence) to 5 (highest confidence).
	Rating int32 `xml:"rating" json:"rating"`
	// A reason code explaining why this set of migrations is being suggested.
	Reason string `xml:"reason" json:"reason"`
	// Text that provides more information about the reason code for the suggested
	// set of migrations.
	ReasonText string `xml:"reasonText" json:"reasonText"`
	// Deprecated a more general `recommendation` list should be used. This recommendation type
	// and the migrationList is kept for backward compatibility.
	//
	// List of migrations in this recommendation and all the parent
	// recommendations on which this recommendation depends.
	//
	// All the
	// migrations in this list can be constructed from `ClusterRecommendation.prerequisite` and `ClusterRecommendation.action`.
	MigrationList []ClusterDrsMigration `xml:"migrationList" json:"migrationList"`
}

func init() {
	t["ClusterDrsRecommendation"] = reflect.TypeOf((*ClusterDrsRecommendation)(nil)).Elem()
}

// DRS configuration for a single virtual machine.
//
// This makes it possible
// to override the default behavior for an individual virtual machine.
type ClusterDrsVmConfigInfo struct {
	DynamicData

	// Reference to the virtual machine.
	//
	// Refers instance of `VirtualMachine`.
	Key ManagedObjectReference `xml:"key" json:"key"`
	// Flag to indicate whether or not VirtualCenter is allowed to perform any
	// DRS migration or initial placement recommendations for this virtual
	// machine.
	//
	// If this flag is false, the virtual machine is effectively excluded from
	// DRS.
	//
	// If no individual DRS specification exists for a virtual machine,
	// this property defaults to true.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Specifies the particular DRS behavior for this virtual machine.
	//
	// See also `ClusterDrsConfigInfo`.
	Behavior DrsBehavior `xml:"behavior,omitempty" json:"behavior,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigInfo"] = reflect.TypeOf((*ClusterDrsVmConfigInfo)(nil)).Elem()
}

// Updates the per-virtual-machine DRS configuration.
//
// To update the DRS configuration of a virtual machine, a copy of this object
// is included in the `ClusterConfigSpecEx` object passed to the method
// `ComputeResource.ReconfigureComputeResource_Task`.
//
// If _reconfigureEx_ is used to
// incrementally update the cluster configuration (i.e., the parameter `*modify*` is true),
// then three operations are provided for updating the DRS configuration for a virtual machine.
// These operations are listed below (see `ArrayUpdateSpec` for more
// information on these operations).
//   - add: add a configuration for the virtual machine, overwritting the existing
//     configuration if one exists
//   - edit: incrmentally update the existing configuration; an existing configuration
//     must exist
//   - remove: remove the existing configuration; an existing configuration must exist
//
// If, instead, this method is used to overwrite the cluster configuration (i.e., the parameter
// `*modify*` is false) thereby creating a new configuration, only the add operation is allowed.
// In this case, _add_ creates a DRS configuration for a virtual machine in the new cluster
// configuration.
type ClusterDrsVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDrsVmConfigInfo `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigSpec"] = reflect.TypeOf((*ClusterDrsVmConfigSpec)(nil)).Elem()
}

type ClusterEVCManagerCheckResult struct {
	DynamicData

	// The EVC mode being tested for legal application.
	EvcModeKey string `xml:"evcModeKey" json:"evcModeKey"`
	// A problem that would prevent applying the desired EVC mode.
	Error LocalizedMethodFault `xml:"error" json:"error"`
	// The set of hosts which would generate the fault described by the
	// `ClusterEVCManagerCheckResult.error` property when the desired EVC mode is applied.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["ClusterEVCManagerCheckResult"] = reflect.TypeOf((*ClusterEVCManagerCheckResult)(nil)).Elem()
}

type ClusterEVCManagerEVCState struct {
	DynamicData

	// All supported EVC modes.
	//
	// Identical to
	// `Capability.supportedEVCMode`.
	SupportedEVCMode []EVCMode `xml:"supportedEVCMode" json:"supportedEVCMode"`
	// If unset, then EVC is disabled.
	//
	// If set, then EVC is enabled, and the
	// value references an EVC mode described in one of the elements of the
	// `ClusterEVCManagerEVCState.supportedEVCMode` array property. The EVC mode determines the
	// set of guaranteed clusterwide CPU features. While EVC is enabled, CPU
	// compatibility issues will not block any VMotion within the cluster
	// (unless some VM is specifically configured to do different CPUID
	// overrides).
	CurrentEVCModeKey string `xml:"currentEVCModeKey,omitempty" json:"currentEVCModeKey,omitempty"`
	// Deprecated as of vSphere API 6.5 use `ClusterEVCManagerEVCState.featureCapability`.
	//
	// When EVC is enabled, this array contains the CPU feature bits that are
	// guaranteed (by EVC) to be the same among all hosts in the cluster.
	//
	// This property has the same value as the guaranteedCPUFeatures property
	// of the configured EVC mode. On any host in the EVC cluster, the CPU
	// features either naturally match these values because of the CPU
	// hardware, or else CPU feature override is used to mask out differences
	// and enforce a match. This array is empty when EVC is disabled.
	GuaranteedCPUFeatures []HostCpuIdInfo `xml:"guaranteedCPUFeatures,omitempty" json:"guaranteedCPUFeatures,omitempty"`
	// When EVC is enabled, this array contains the feature capabilities that
	// are guaranteed (by EVC) to be the same among all hosts in the cluster.
	//
	// This property has the same value as the featureCapability property
	// of the configured EVC mode. On any host in the EVC cluster, the feature
	// capabilities either naturally match these values because of the CPU
	// hardware, or else feature masks are used to mask out differences and
	// enforce a match. This array is empty when EVC is disabled.
	FeatureCapability []HostFeatureCapability `xml:"featureCapability,omitempty" json:"featureCapability,omitempty"`
	// The masks (modifications to a host's feature capabilities) that limit a
	// host's capabilities to that of the EVC mode baseline.
	FeatureMask []HostFeatureMask `xml:"featureMask,omitempty" json:"featureMask,omitempty"`
	// The conditions that must be true of a host's feature capabilities in order
	// for the host to meet the minimum requirements of the EVC mode baseline.
	FeatureRequirement []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty" json:"featureRequirement,omitempty"`
}

func init() {
	t["ClusterEVCManagerEVCState"] = reflect.TypeOf((*ClusterEVCManagerEVCState)(nil)).Elem()
}

type ClusterEnterMaintenanceMode ClusterEnterMaintenanceModeRequestType

func init() {
	t["ClusterEnterMaintenanceMode"] = reflect.TypeOf((*ClusterEnterMaintenanceMode)(nil)).Elem()
}

// The parameters of `ClusterComputeResource.ClusterEnterMaintenanceMode`.
type ClusterEnterMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The array of hosts to put into maintenance mode.
	//
	// Required privileges: Host.Config.Maintenance
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
	// An array of `OptionValue`
	// options for this query. The specified options override the
	// advanced options in `ClusterDrsConfigInfo`.
	Option []BaseOptionValue                      `xml:"option,omitempty,typeattr" json:"option,omitempty"`
	Info   *ClusterComputeResourceMaintenanceInfo `xml:"info,omitempty" json:"info,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["ClusterEnterMaintenanceModeRequestType"] = reflect.TypeOf((*ClusterEnterMaintenanceModeRequestType)(nil)).Elem()
}

type ClusterEnterMaintenanceModeResponse struct {
	Returnval ClusterEnterMaintenanceResult `xml:"returnval" json:"returnval"`
}

// EnterMaintenanceResult is the base class of the result returned to the
// `ClusterComputeResource.ClusterEnterMaintenanceMode` method.
type ClusterEnterMaintenanceResult struct {
	DynamicData

	// The list of recommendations for hosts that Virtual Center will
	// be able to evacuate.
	//
	// Each recommendation consists of a host
	// maintenance action `ClusterAction` for a host, along
	// with zero or more vmotions for evacuation. Application of the
	// recommendations is not supported currently. The client will have
	// to put the hosts into maintenance mode by calling the separate
	// method `HostSystem.EnterMaintenanceMode_Task`.
	Recommendations []ClusterRecommendation `xml:"recommendations,omitempty" json:"recommendations,omitempty"`
	// The faults that explain why the Virtual Center cannot evacuate
	// some hosts.
	Fault *ClusterDrsFaults `xml:"fault,omitempty" json:"fault,omitempty"`
}

func init() {
	t["ClusterEnterMaintenanceResult"] = reflect.TypeOf((*ClusterEnterMaintenanceResult)(nil)).Elem()
}

// These are cluster events.
type ClusterEvent struct {
	Event
}

func init() {
	t["ClusterEvent"] = reflect.TypeOf((*ClusterEvent)(nil)).Elem()
}

// The current admission control related information if the cluster was configured
// with a FailoverHostAdmissionControlPolicy.
type ClusterFailoverHostAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	// Status of the failover hosts in the cluster.
	HostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"hostStatus,omitempty" json:"hostStatus,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfo)(nil)).Elem()
}

// Data object containing the status of a failover host.
type ClusterFailoverHostAdmissionControlInfoHostStatus struct {
	DynamicData

	// The failover host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// The status of the failover host.
	//
	// The status is green for a connected host with no vSphere HA errors and
	// no virtual machines running on it.
	// The status is yellow for a connected host with no vSphere HA errors and
	// some virtual machines running on it.
	// The status red for a disconnected or not responding host, a host that
	// is in maintenance or standby mode or that has a vSphere HA error on it.
	Status ManagedEntityStatus `xml:"status" json:"status"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

// The `ClusterFailoverHostAdmissionControlPolicy` dedicates
// one or more hosts for use during failover.
//
// When a host fails with this policy in place, vSphere HA attempts
// to restart its virtual machines on a dedicated failover host.
// If this is not possible, for example the failover host itself has failed
// or it has insufficient resources, HA attempts to restart those virtual
// machines on another host in the cluster.
//
// To support the availabilty of a failover host,
// the vCenter Server will prevent users from powering on virtual machines
// on that host, or from using vMotion to migrate virtual machines to the host.
// Also, DRS does not use the failover host for load balancing.
//
// To obtain the status of a failover host, use the
// `ClusterFailoverHostAdmissionControlInfo.hostStatus`
// property
// (`ClusterComputeResourceSummary*.*ClusterComputeResourceSummary.admissionControlInfo*.*ClusterFailoverHostAdmissionControlInfo.hostStatus`).
type ClusterFailoverHostAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	// List of managed object references to failover hosts.
	//
	// Refers instances of `HostSystem`.
	FailoverHosts []ManagedObjectReference `xml:"failoverHosts,omitempty" json:"failoverHosts,omitempty"`
	// Number of host failures that should be tolerated, still guaranteeing
	// sufficient resources to restart virtual machines on available hosts.
	//
	// If not set, we assume 1.
	FailoverLevel int32 `xml:"failoverLevel,omitempty" json:"failoverLevel,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlPolicy)(nil)).Elem()
}

// The current admission control related information if the cluster was
// configured with a FailoverLevelAdmissionControlPolicy.
type ClusterFailoverLevelAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	// Current failover level.
	//
	// This is the number of physical host failures that
	// can be tolerated without impacting the ability to satisfy the minimums for
	// all running virtual machines. This represents the current value, as
	// opposed to desired value configured by the user.
	CurrentFailoverLevel int32 `xml:"currentFailoverLevel" json:"currentFailoverLevel"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlInfo)(nil)).Elem()
}

// The `ClusterFailoverLevelAdmissionControlPolicy`
// defines the number of host failures that should be tolerated and still
// guarantee enough unfragmented resources to failover all powered on virtual
// machines on those failed hosts.
//
// When you use the failover level policy, vSphere HA partitions resources
// into slots. A slot represents the minimum CPU and memory resources
// that are required to support any powered-on virtual machine in the cluster.
//
// With the failover level policy in place, HA uses the following slot
// calculations to control virtual machine migration within the cluster:
//
//  1. Calculate the slot size from CPU and memory reservations.
//     The CPU value is the largest CPU reservation for all powered-on
//     virtual machines in the cluster. The memory value is the largest
//     memory reservation (plus memory overhead).
//
//     If your cluster contains any virtual machines that have much larger
//     reservations than the others, they will distort slot size calculation.
//     To avoid this, you can specify an upper bound for slot sizes;
//     use the configuration editor in the vSphere Client to set the
//     das.slotCpuInMHz and das.slotMemInMB attributes. When you use these
//     attributes, there is a risk that resource fragmentation will cause
//     virtual machines with resource requirements larger than the slot size
//     to be assigned multiple slots. In a cluster that is close to capacity,
//     there might be enough slots in aggregate for HA to successfully
//     failover a virtual machine. However, if those slots are located
//     on multiple hosts, a virtual machine assigned multiple slots cannot
//     use them because a virtual machine can run on only a single host
//     at a time.
//
//  2. Determine how many slots each host in the cluster can hold.
//     HA uses the CPU and memory resources in a host's root resource pool
//     to determine host slot capacity, not the total physical resources
//     of the host. Resources used for virtualization purposes are not
//     included. HA uses connected hosts that are not in maintenance mode
//     and that do not have any HA errors.
//
//     The CPU slot resource is the host CPU resource amount divided
//     by the CPU component of the slot size; the result is rounded down.
//     HA makes the same calculation for host memory resource amount.
//     HA compares the results; the lower of the two numbers is the
//     host slot capacity.
//
//  3. Determine the current failover capacity of the cluster. This is the
//     number of hosts (starting from the largest) that can fail and still
//     leave enough slots to satisfy all of the powered-on virtual machines.
//
//  4. Compare the current failover capacity to the configured
//     `ClusterFailoverLevelAdmissionControlPolicy.failoverLevel`.
//     If the current failover capacity is less than the configured
//     failover level, HA disallows the operation.
type ClusterFailoverLevelAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	// Number of host failures that should be tolerated, still guaranteeing
	// sufficient resources to restart virtual machines on available hosts.
	FailoverLevel int32 `xml:"failoverLevel" json:"failoverLevel"`
	// A policy for how to compute the slot size.
	//
	// If left unset, the slot is
	// computed using the maximum reservations and memory overhead of any
	// powered on virtual machine in the cluster.
	SlotPolicy BaseClusterSlotPolicy `xml:"slotPolicy,omitempty,typeattr" json:"slotPolicy,omitempty"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlPolicy)(nil)).Elem()
}

// The current admission control related information if the cluster was configured
// with a FailoverResourcesAdmissionControlPolicy.
type ClusterFailoverResourcesAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	// The percentage of cpu resources in the cluster available for failover.
	CurrentCpuFailoverResourcesPercent int32 `xml:"currentCpuFailoverResourcesPercent" json:"currentCpuFailoverResourcesPercent"`
	// The percentage of memory resources in the cluster available for failover.
	CurrentMemoryFailoverResourcesPercent int32 `xml:"currentMemoryFailoverResourcesPercent" json:"currentMemoryFailoverResourcesPercent"`
	// The percentage of persistent memory resources in the cluster available
	// for failover.
	CurrentPMemFailoverResourcesPercent int32 `xml:"currentPMemFailoverResourcesPercent,omitempty" json:"currentPMemFailoverResourcesPercent,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlInfo)(nil)).Elem()
}

// The `ClusterFailoverResourcesAdmissionControlPolicy`
// reserves a specified percentage of aggregate cluster resources for failover.
//
// With the resources failover policy in place, vSphere HA uses the following
// calculations to control virtual machine migration in the cluster.
//  1. Calculate the total resource requirements for all powered-on
//     virtual machines in the cluster.
//  2. Calculate the total host resources available for virtual machines.
//  3. Calculate the Current CPU failover capacity, memory failover
//     capacity and optionally, persistent memory failover capacity
//     for the cluster.
//  4. Compare the current CPU failover capacity and current memory failover
//     capacity with the configured resource percentages
//     (`ClusterFailoverResourcesAdmissionControlPolicy.cpuFailoverResourcesPercent`
//     and
//     `ClusterFailoverResourcesAdmissionControlPolicy.memoryFailoverResourcesPercent`).
//     If either current capacity is less than the corresponding configured
//     capacity, HA does not allow the operation.
//
// HA uses the actual reservations of the virtual machines. If a virtual machine
// does not have reservations, meaning that the reservation is 0, a default
// of 0MB memory and 256MHz CPU is applied. This is controlled by the same
// HA advanced options used for the failover level policy
// (`ClusterFailoverLevelAdmissionControlPolicy`).
type ClusterFailoverResourcesAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	// Percentage of CPU resources in the cluster to reserve for failover.
	//
	// You can specify up to 100% of CPU resources for failover.
	CpuFailoverResourcesPercent int32 `xml:"cpuFailoverResourcesPercent" json:"cpuFailoverResourcesPercent"`
	// Percentage of memory resources in the cluster to reserve for failover.
	//
	// You can specify up to 100% of memory resources for failover.
	MemoryFailoverResourcesPercent int32 `xml:"memoryFailoverResourcesPercent" json:"memoryFailoverResourcesPercent"`
	// Number of host failures that should be tolerated, still guaranteeing
	// sufficient resources to restart virtual machines on available hosts.
	//
	// If not set, we assume 1.
	FailoverLevel int32 `xml:"failoverLevel,omitempty" json:"failoverLevel,omitempty"`
	// Flag to enable user input values for
	// `ClusterFailoverResourcesAdmissionControlPolicy.cpuFailoverResourcesPercent`
	// and
	// `ClusterFailoverResourcesAdmissionControlPolicy.memoryFailoverResourcesPercent`
	// By default, this is true and the default calculation is using the
	// `ClusterFailoverResourcesAdmissionControlPolicy.failoverLevel`
	// hosts' resources.
	//
	// If users want to override the percentage values,
	// they must disable the auto-compute by setting this field to false.
	AutoComputePercentages *bool `xml:"autoComputePercentages" json:"autoComputePercentages,omitempty"`
	// Percentage of persistent memory resources in the cluster to reserve for
	// the failover.
	//
	// You can specify up to 100% of persistent memory resources for failover.
	PMemFailoverResourcesPercent int32 `xml:"pMemFailoverResourcesPercent,omitempty" json:"pMemFailoverResourcesPercent,omitempty" vim:"7.0.2.0"`
	// Flag to enable user input values for
	// `ClusterFailoverResourcesAdmissionControlPolicy.pMemFailoverResourcesPercent`
	// By default, this is true and the default calculation is done using the
	// `ClusterFailoverResourcesAdmissionControlPolicy.failoverLevel` hosts' resources.
	//
	// If a user wants to override the percentage values, they
	// must disable the auto-compute by setting this field to false.
	AutoComputePMemFailoverResourcesPercent *bool `xml:"autoComputePMemFailoverResourcesPercent" json:"autoComputePMemFailoverResourcesPercent,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlPolicy)(nil)).Elem()
}

// This policy allows setting a fixed slot size
type ClusterFixedSizeSlotPolicy struct {
	ClusterSlotPolicy

	// The cpu component of the slot size (in MHz)
	Cpu int32 `xml:"cpu" json:"cpu"`
	// The memory component of the slot size (in megabytes)
	Memory int32 `xml:"memory" json:"memory"`
}

func init() {
	t["ClusterFixedSizeSlotPolicy"] = reflect.TypeOf((*ClusterFixedSizeSlotPolicy)(nil)).Elem()
}

// An `ClusterFtVmHostRuleInfo` object provides control of the
// placement of virtual machines across two host groups. The virtual machines
// and hosts referenced by an FT VM-Host rule must be in the same cluster.
//
// An FT VM-Host rule identifies the following groups.
//   - A virtual machine group name (`ClusterVmGroup`).
//   - An array of two host groups (`ClusterHostGroup`).
//
// `ClusterFtVmHostRuleInfo` stores only the names of the relevant
// virtual machine and host groups. The group contents are stored in
// the virtual machine and host group objects.
//
// When employing this rule, take care to ensure that the specified
// host groups have sufficient resources to support the requirements
// of all VMs specified.
type ClusterFtVmHostRuleInfo struct {
	ClusterRuleInfo

	// Virtual machine group name
	// (`ClusterVmGroup*.*ClusterGroupInfo.name`).
	//
	// The named virtual machine group may have zero or more VMs.
	// A virtual machine in this group may be a normal virtual machine
	// or a fault tolerant primary virtual machine; it cannot
	// be a fault tolerant secondary virtual machine.
	//
	// Control of FT secondary virtual machines is implied by the presence
	// of the primary FT virtual machine.
	//
	// A virtual machine in this group should not be referenced in any other
	// FT VM-Host rule or VM-Host rule `ClusterVmHostRuleInfo`.
	VmGroupName string `xml:"vmGroupName" json:"vmGroupName"`
	// Array of two Host Groups (`ClusterHostGroup`).
	//
	// The hostGroup array must have two host groups. Each host group in the
	// hostGroup array will have a set of hosts. For each Fault Tolerance primary
	// VM that is part of VmGroup, the primary and secondary VMs would be placed
	// on hosts that are not part of the same host group.
	//
	// The members of each host group should be disjoint from the members
	// of all other host group specified.
	HostGroupName []string `xml:"hostGroupName,omitempty" json:"hostGroupName,omitempty"`
}

func init() {
	t["ClusterFtVmHostRuleInfo"] = reflect.TypeOf((*ClusterFtVmHostRuleInfo)(nil)).Elem()
	minAPIVersionForType["ClusterFtVmHostRuleInfo"] = "8.0.3.0"
}

// `ClusterGroupInfo` is the base type for all virtual machine
// and host groups.
//
// All virtual machines and hosts that are part of a group
// must be part of the same cluster.
type ClusterGroupInfo struct {
	DynamicData

	// Unique name of the group.
	Name string `xml:"name" json:"name"`
	// Flag to indicate whether the group is created by the user or the system.
	UserCreated *bool `xml:"userCreated" json:"userCreated,omitempty"`
	// Unique ID for the group.
	//
	// uniqueID is unique within a cluster.
	// Groups residing in different clusters might share a uniqueID.
	UniqueID string `xml:"uniqueID,omitempty" json:"uniqueID,omitempty"`
}

func init() {
	t["ClusterGroupInfo"] = reflect.TypeOf((*ClusterGroupInfo)(nil)).Elem()
}

// An incremental update to the cluster-wide groups.
type ClusterGroupSpec struct {
	ArrayUpdateSpec

	Info BaseClusterGroupInfo `xml:"info,omitempty,typeattr" json:"info,omitempty"`
}

func init() {
	t["ClusterGroupSpec"] = reflect.TypeOf((*ClusterGroupSpec)(nil)).Elem()
}

// The `ClusterHostGroup` data object identifies hosts for VM-Host rules.
//
// VM-Host rules determine placement of virtual machines on hosts in a cluster.
// The logic specified in a `ClusterVmHostRuleInfo` object
// determines where virtual machines can be powered-on.
type ClusterHostGroup struct {
	ClusterGroupInfo

	// List of hosts that are part of this group.
	//
	// A host group can contain zero or more hosts.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["ClusterHostGroup"] = reflect.TypeOf((*ClusterHostGroup)(nil)).Elem()
}

// Describes a HostSystem's quarantine or maintenance mode change action.
type ClusterHostInfraUpdateHaModeAction struct {
	ClusterAction

	// Specify the action type.
	//
	// Values are of type
	// `OperationType`.
	OperationType string `xml:"operationType" json:"operationType"`
}

func init() {
	t["ClusterHostInfraUpdateHaModeAction"] = reflect.TypeOf((*ClusterHostInfraUpdateHaModeAction)(nil)).Elem()
}

// Describes a single host power action.
type ClusterHostPowerAction struct {
	ClusterAction

	// Specify whether the action is power on or power off
	OperationType HostPowerOperationType `xml:"operationType" json:"operationType"`
	// Estimated power consumption of the host.
	//
	// In case of power-on,
	// this is the projected increase in the cluster's power
	// consumption. In case of power off, this is the projected
	// decrease in the cluster's power consumption
	PowerConsumptionWatt int32 `xml:"powerConsumptionWatt,omitempty" json:"powerConsumptionWatt,omitempty"`
	// CPU capacity of the host in units of MHz.
	//
	// In case of power-on
	// action, this is the projected increase in the cluster's CPU
	// capacity. In case of power off, this is the projected decrease
	// in the cluster's CPU capacity.
	CpuCapacityMHz int32 `xml:"cpuCapacityMHz,omitempty" json:"cpuCapacityMHz,omitempty"`
	// Memory capacity of the host in units of MM.
	//
	// In case of power-on
	// action, this is the projected increase in the cluster's memory
	// capacity. In case of power off, this is the projected decrease
	// in the cluster's memory capacity.
	MemCapacityMB int32 `xml:"memCapacityMB,omitempty" json:"memCapacityMB,omitempty"`
}

func init() {
	t["ClusterHostPowerAction"] = reflect.TypeOf((*ClusterHostPowerAction)(nil)).Elem()
}

// A DRS recommended host for either powering on, resuming or
// reverting a virtual machine, or migrating a virtual machine from
// outside the cluster.
type ClusterHostRecommendation struct {
	DynamicData

	// The recommended host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Rating for the recommendation.
	//
	// Ratings range from 1 to 5, and
	// the higher the rating, the stronger DRS suggests this host is
	// picked for the operation.
	Rating int32 `xml:"rating" json:"rating"`
}

func init() {
	t["ClusterHostRecommendation"] = reflect.TypeOf((*ClusterHostRecommendation)(nil)).Elem()
}

// Configuration of the vSphere InfraUpdateHA service.
//
// All fields are defined as optional. In case of a reconfiguration,
// unset fields are not changed.
type ClusterInfraUpdateHaConfigInfo struct {
	DynamicData

	// Flag indicating whether or not the service is enabled.
	//
	// InfraUpdateHA
	// will not be active, unless DRS is enabled as well.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Configured behavior.
	//
	// Values are of type
	// `BehaviorType`.
	Behavior string `xml:"behavior,omitempty" json:"behavior,omitempty"`
	// Configured remediation for moderately degraded hosts.
	//
	// Values are of type
	// `RemediationType`.
	// Configuring MaintenanceMode for moderateRemedation and QuarantineMode for
	// severeRemediation is not supported and will throw InvalidArgument.
	ModerateRemediation string `xml:"moderateRemediation,omitempty" json:"moderateRemediation,omitempty"`
	// Configured remediation for severely degraded hosts.
	//
	// Values are of type
	// `RemediationType`.
	SevereRemediation string `xml:"severeRemediation,omitempty" json:"severeRemediation,omitempty"`
	// The list of health update providers configured for this cluster.
	//
	// Providers are identified by their id.
	//
	// When reconfiguring the cluster, a list with a single element {""} will
	// clear the list of providers.
	//
	// If the provider list is empty, InfraUpdateHA will not be active.
	Providers []string `xml:"providers,omitempty" json:"providers,omitempty"`
}

func init() {
	t["ClusterInfraUpdateHaConfigInfo"] = reflect.TypeOf((*ClusterInfraUpdateHaConfigInfo)(nil)).Elem()
}

// Describes an initial placement of a single virtual machine
type ClusterInitialPlacementAction struct {
	ClusterAction

	// The host where the virtual machine should be initially placed.
	//
	// Refers instance of `HostSystem`.
	TargetHost ManagedObjectReference `xml:"targetHost" json:"targetHost"`
	// The resource pool to place the virtual machine into in case this
	// action is for migrating from outside cluster.
	//
	// Refers instance of `ResourcePool`.
	Pool *ManagedObjectReference `xml:"pool,omitempty" json:"pool,omitempty"`
}

func init() {
	t["ClusterInitialPlacementAction"] = reflect.TypeOf((*ClusterInitialPlacementAction)(nil)).Elem()
}

// Information about an IO Filter on a compute resource.
type ClusterIoFilterInfo struct {
	IoFilterInfo

	// The operation that was performed for the IO Filter.
	//
	// The set of possible values are described in
	// `IoFilterOperation_enum`.
	// If opType is `uninstall`,
	// and the uninstallation of the filter was sucessful on all the hosts
	// in the cluster, the filter will be removed from the cluster's filter
	// list.
	OpType string `xml:"opType" json:"opType"`
	// The URL of the VIB package that the IO Filter is installed from.
	//
	// The property is unset if the information is not available.
	VibUrl string `xml:"vibUrl,omitempty" json:"vibUrl,omitempty"`
}

func init() {
	t["ClusterIoFilterInfo"] = reflect.TypeOf((*ClusterIoFilterInfo)(nil)).Elem()
}

// Describes a single VM migration action.
type ClusterMigrationAction struct {
	ClusterAction

	// The details of the migration action
	DrsMigration *ClusterDrsMigration `xml:"drsMigration,omitempty" json:"drsMigration,omitempty"`
}

func init() {
	t["ClusterMigrationAction"] = reflect.TypeOf((*ClusterMigrationAction)(nil)).Elem()
}

// The Cluster network config spec allows specification of
// the second network adapter is used for communication between
// the nodes of a VCHA cluster.
type ClusterNetworkConfigSpec struct {
	DynamicData

	// The portgroup that is associated with the VCHA Cluster IP
	// address for VCHA cluster traffic for the second adapter to be
	// added to the Active vCenter.
	//
	// Refers instance of `Network`.
	NetworkPortGroup ManagedObjectReference `xml:"networkPortGroup" json:"networkPortGroup"`
	// VCHA Cluster network configuration of the node.
	//
	// All cluster communication (state replication, heartbeat,
	// cluster messages) happens over this network.
	// Only a single Gateway IPv4 Address is supported.
	// IPAddress and NetMask must be specified or an InvalidArgument
	// exception will be reported.
	IpSettings CustomizationIPSettings `xml:"ipSettings" json:"ipSettings"`
}

func init() {
	t["ClusterNetworkConfigSpec"] = reflect.TypeOf((*ClusterNetworkConfigSpec)(nil)).Elem()
}

// This data class reports one virtual machine powerOn failure.
type ClusterNotAttemptedVmInfo struct {
	DynamicData

	// The virtual machine that can not be powered on.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The exception returned.
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["ClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ClusterNotAttemptedVmInfo)(nil)).Elem()
}

// vSphere cluster VM orchestration settings.
//
// Used by vSphere HA when restarting failed VMs. For example, if a host
// fails, vSphere HA identifies the list of VMs to be restarted. The order in
// which the failed VMs to be restarted is determined by:
//   - VM restart priority setting (`ClusterDasVmSettings.restartPriority`).
//     Lower priority VMs are restarted only after higher priority VMs are
//     restarted and ready (`ClusterVmReadiness`).
//   - VM dependency rule (`ClusterDependencyRuleInfo`). If a VM
//     depends on other VMs, then it will be restarted only after all the VMs in
//     its dependency list are ready. Cyclic dependency is not permitted across
//     VMs. Also, higher priority VMs cannot depend on lower priority VMs.
type ClusterOrchestrationInfo struct {
	DynamicData

	// Cluster-wide defaults for virtual machine readiness
	DefaultVmReadiness *ClusterVmReadiness `xml:"defaultVmReadiness,omitempty" json:"defaultVmReadiness,omitempty"`
}

func init() {
	t["ClusterOrchestrationInfo"] = reflect.TypeOf((*ClusterOrchestrationInfo)(nil)).Elem()
}

// This event records when a cluster's host capacity cannot satisfy resource
// configuration constraints.
type ClusterOvercommittedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterOvercommittedEvent"] = reflect.TypeOf((*ClusterOvercommittedEvent)(nil)).Elem()
}

// PowerOnVmResult is the base class of the result returned to the
// `Datacenter.PowerOnMultiVM_Task` method.
type ClusterPowerOnVmResult struct {
	DynamicData

	// The list of virtual machines the Virtual Center has attempted to power on.
	//
	// For a virtual machine not managed by DRS, a task ID is also returned.
	Attempted []ClusterAttemptedVmInfo `xml:"attempted,omitempty" json:"attempted,omitempty"`
	// The list of virtual machines DRS can not find suitable hosts for powering on.
	//
	// There is one fault associated with each virtual machine.
	NotAttempted []ClusterNotAttemptedVmInfo `xml:"notAttempted,omitempty" json:"notAttempted,omitempty"`
	// The list of recommendations that need the client to approve manually.
	Recommendations []ClusterRecommendation `xml:"recommendations,omitempty" json:"recommendations,omitempty"`
}

func init() {
	t["ClusterPowerOnVmResult"] = reflect.TypeOf((*ClusterPowerOnVmResult)(nil)).Elem()
}

// The `ClusterPreemptibleVmPairInfo` data object contains the monitored and the
// preemptible VM pair in a HA-enabled cluster.
//
// Monitored virtual machine is a desired protected virtual machine in
// HA-enabled cluster when it is powered on. Any failures of this VM will
// continue to be handled by HA based on the VM's settings in cluster.
//
// Preemptible virtual machine is the desired protected virtual machine in HA
// when it is powered on. The lowest restart priority "disabled"
// `ClusterDasVmSettingsRestartPriority_enum` will be enforced for the
// `ClusterPreemptibleVmPairInfo.preemptibleVm`. A virtual machine can be marked as preemptible
// irrespective of its `powerState` but its
// extra configuration should identify it as preemptible.
//
// In case of failure of `ClusterPreemptibleVmPairInfo.monitoredVm`, the `ClusterPreemptibleVmPairInfo.preemptibleVm` will
// be terminated. This will free up any resources associated with
// `ClusterPreemptibleVmPairInfo.preemptibleVm`.
//
// In case of insufficient resources for failover of any VM in the cluster, the
// `ClusterPreemptibleVmPairInfo.preemptibleVm` will be terminated to free up resources.
//
// This data object is intended for VMware use and other usage is not
// supported. This data object will be removed in a future release.
type ClusterPreemptibleVmPairInfo struct {
	DynamicData

	// Server-assigned unique ID for pairs.
	//
	// When adding a new pair, do not
	// specify this property. The server will assign the key and any assigned
	// value will be ignored.
	Id int32 `xml:"id,omitempty" json:"id,omitempty"`
	// The virtual machine whose failure will cause the virtual machine specified
	// by `ClusterPreemptibleVmPairInfo.preemptibleVm` to be terminated.
	//
	// Refers instance of `VirtualMachine`.
	MonitoredVm ManagedObjectReference `xml:"monitoredVm" json:"monitoredVm"`
	// The preemptible virtual machine associated with the virtual machine
	// specified as `ClusterPreemptibleVmPairInfo.monitoredVm`.
	//
	// Refers instance of `VirtualMachine`.
	PreemptibleVm ManagedObjectReference `xml:"preemptibleVm" json:"preemptibleVm"`
}

func init() {
	t["ClusterPreemptibleVmPairInfo"] = reflect.TypeOf((*ClusterPreemptibleVmPairInfo)(nil)).Elem()
	minAPIVersionForType["ClusterPreemptibleVmPairInfo"] = "8.0.0.1"
}

// Provides monitored and preemptible VM pair along with any of the operations
// (add, edit or remove) to append, modify or remove this pair info from
// `ClusterPreemptibleVmPairInfo` list.
//
// This data object is intended for VMware use and other usage is not supported.
// This data object will be removed in a future release.
type ClusterPreemptibleVmPairSpec struct {
	ArrayUpdateSpec

	Info *ClusterPreemptibleVmPairInfo `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterPreemptibleVmPairSpec"] = reflect.TypeOf((*ClusterPreemptibleVmPairSpec)(nil)).Elem()
	minAPIVersionForType["ClusterPreemptibleVmPairSpec"] = "8.0.0.1"
}

type ClusterProactiveDrsConfigInfo struct {
	DynamicData

	// Flag indicating whether or not the service is enabled.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
}

func init() {
	t["ClusterProactiveDrsConfigInfo"] = reflect.TypeOf((*ClusterProactiveDrsConfigInfo)(nil)).Elem()
}

// DataObject completely specifying the configuration of
// the profile.
type ClusterProfileCompleteConfigSpec struct {
	ClusterProfileConfigSpec

	// User defined compliance profile for the cluster.
	//
	// If unset, clear the complyProfile.
	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty" json:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileCompleteConfigSpec"] = reflect.TypeOf((*ClusterProfileCompleteConfigSpec)(nil)).Elem()
}

type ClusterProfileConfigInfo struct {
	ProfileConfigInfo

	// Compliance profile for the cluster
	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty" json:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileConfigInfo"] = reflect.TypeOf((*ClusterProfileConfigInfo)(nil)).Elem()
}

// DataObject which allows reconfiguration of a profile
// based on services that will be available on the cluster.
type ClusterProfileConfigServiceCreateSpec struct {
	ClusterProfileConfigSpec

	// Type of the service for which the ClusterProfile is being requested.
	//
	// If more than one service is specified, the created ClusterProfile
	// will cater for all the services.
	// Possible values are specified by
	// `ClusterProfileServiceType_enum`.
	// If unset, clear the compliance expressions on the profile.
	ServiceType []string `xml:"serviceType,omitempty" json:"serviceType,omitempty"`
}

func init() {
	t["ClusterProfileConfigServiceCreateSpec"] = reflect.TypeOf((*ClusterProfileConfigServiceCreateSpec)(nil)).Elem()
}

// DataObject which is a baseclass for other configuration
// specifications.
type ClusterProfileConfigSpec struct {
	ClusterProfileCreateSpec
}

func init() {
	t["ClusterProfileConfigSpec"] = reflect.TypeOf((*ClusterProfileConfigSpec)(nil)).Elem()
}

// Base class for Cluster CreateSpecs
type ClusterProfileCreateSpec struct {
	ProfileCreateSpec
}

func init() {
	t["ClusterProfileCreateSpec"] = reflect.TypeOf((*ClusterProfileCreateSpec)(nil)).Elem()
}

// Recommendation is the base class for any packaged group of
// actions that are intended to take the system from one
// state to another one.
type ClusterRecommendation struct {
	DynamicData

	// Key to identify the recommendation when calling applyRecommendation.
	Key string `xml:"key" json:"key"`
	// Type of the recommendation.
	//
	// This differentiates between various
	// of recommendations aimed at achieving different goals.
	Type string `xml:"type" json:"type"`
	// The time this recommendation was computed.
	Time time.Time `xml:"time" json:"time"`
	// A rating of the recommendation.
	//
	// Valid values range from 1 (lowest confidence) to 5 (highest confidence).
	Rating int32 `xml:"rating" json:"rating"`
	// A reason code explaining why this set of migrations is being suggested.
	Reason string `xml:"reason" json:"reason"`
	// Text that provides more information about the reason code for the suggested
	// set of migrations.
	ReasonText string `xml:"reasonText" json:"reasonText"`
	// Text that provides warnings about potential adverse implications of
	// applying this recommendation
	WarningText string `xml:"warningText,omitempty" json:"warningText,omitempty"`
	// Warning about potential adverse implications of applying a recommendation
	WarningDetails *LocalizableMessage `xml:"warningDetails,omitempty" json:"warningDetails,omitempty"`
	// This recommendation may depend on some other recommendations.
	//
	// The prerequisite recommendations are listed by their keys.
	Prerequisite []string `xml:"prerequisite,omitempty" json:"prerequisite,omitempty"`
	// List of actions that are executed as part of this recommendation
	Action []BaseClusterAction `xml:"action,omitempty,typeattr" json:"action,omitempty"`
	// The target object of this recommendation.
	Target *ManagedObjectReference `xml:"target,omitempty" json:"target,omitempty"`
}

func init() {
	t["ClusterRecommendation"] = reflect.TypeOf((*ClusterRecommendation)(nil)).Elem()
}

// This event records when a cluster is reconfigured.
type ClusterReconfiguredEvent struct {
	ClusterEvent

	// The configuration values changed during the reconfiguration.
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty" json:"configChanges,omitempty"`
}

func init() {
	t["ClusterReconfiguredEvent"] = reflect.TypeOf((*ClusterReconfiguredEvent)(nil)).Elem()
}

// This class contains cpu, memory and storage usage information at cluster
// level.
type ClusterResourceUsageSummary struct {
	DynamicData

	CpuUsedMHz        int32 `xml:"cpuUsedMHz" json:"cpuUsedMHz"`
	CpuCapacityMHz    int32 `xml:"cpuCapacityMHz" json:"cpuCapacityMHz"`
	MemUsedMB         int32 `xml:"memUsedMB" json:"memUsedMB"`
	MemCapacityMB     int32 `xml:"memCapacityMB" json:"memCapacityMB"`
	PMemAvailableMB   int64 `xml:"pMemAvailableMB,omitempty" json:"pMemAvailableMB,omitempty"`
	PMemCapacityMB    int64 `xml:"pMemCapacityMB,omitempty" json:"pMemCapacityMB,omitempty"`
	StorageUsedMB     int64 `xml:"storageUsedMB" json:"storageUsedMB"`
	StorageCapacityMB int64 `xml:"storageCapacityMB" json:"storageCapacityMB"`
}

func init() {
	t["ClusterResourceUsageSummary"] = reflect.TypeOf((*ClusterResourceUsageSummary)(nil)).Elem()
}

// The `ClusterRuleInfo` data object is the base type for affinity
// and anti-affinity rules.
//
// The affinity and anti-affinity rules
// are DRS (Distributed Resource Scheduling) rules that affect the placement
// of virtual machines in a cluster. Hosts and virtual machines referenced
// in a DRS rule must be in the same cluster.
//
// Note: DRS rules are different than an individual host's CPU affinity rules
// (`VirtualMachineAffinityInfo`).
//
// The Server uses DRS rule objects to describe the current rule configuration
// (`ClusterConfigInfoEx*.*ClusterConfigInfoEx.rule`).
// Your client application uses rule objects to configure the affinity and
// anti-affinity rules
// (`ClusterConfigSpecEx*.*ClusterConfigSpecEx.rulesSpec`).
//
// You can create the following types of rules:
//   - An affinity rule defines a set of virtual machines that should run
//     on the same host.
//     The `ClusterAffinityRuleSpec` object describes a rule that
//     identifies virtual machines, but does not identify any specific host.
//   - An anti-affinity rule defines a set of virtual machines that should run
//     on different hosts.
//     The `ClusterAntiAffinityRuleSpec` object describes a rule that
//     identifies virtual machines, but does not identify any specific host.
//   - A VM-Host rule defines affinity and anti-affinity relationships between
//     virtual machines and hosts.
//     The `ClusterVmHostRuleInfo` object describes a rule that identifies
//     a virtual machine group (`ClusterVmGroup`) and affinity and
//     anti-affinity host groups (`ClusterHostGroup`).
//
// Rule configuration is a dynamic process. When you create or modify a DRS rule,
// the Server applies the rule to the cluster. If the existing cluster configuration
// violates the rule, the Server attempts to correct the situation. If that is not
// possible, the Server generates a fault and produces a log event.
// DRS rules do not have precedence; all rules are applied equally.
// DRS does not validate one rule against another. If you create conflicting
// rules, the older rule takes precedence and DRS disables the newer rule.
//
// Improperly used, DRS rules can fragment the cluster and inhibit the proper
// functioning of DRS, HA, and DPM services. vSphere services never
// take any actions that would result in the violation of mandatory DRS rules.
// An operation that violates a mandatory rule would produce the following
// consequences.
//   - DRS does not evacuate virtual machines to place a host in maintenance
//     mode.
//   - DRS does not place virtual machines for power-on or load balance virtual
//     machines.
//   - HA does not perform failovers.
//   - DPM does not optimize power management by placing hosts into standby
//     mode.
//
// To avoid these situations, exercise caution when creating more than one
// mandatory rule, or consider using only optional rules. Make sure that
// the number of hosts with which a virtual machine is related by affinity rule
// is large enough that losing a host does not prevent the virtual machine
// from running.
//
// For manual and partially automated DRS clusters, the Server produces migration
// recommendations to satisfy the DRS rules. You are not required to act on the
// recommendations, but the Server maintains the recommendations until the rules
// are satisfied.
type ClusterRuleInfo struct {
	DynamicData

	// Unique ID for rules.
	//
	// When adding a new rule, do not specify this property.
	// The Server will assign the key.
	Key int32 `xml:"key,omitempty" json:"key,omitempty"`
	// Flag to indicate whether or not the rule is currently satisfied.
	Status ManagedEntityStatus `xml:"status,omitempty" json:"status,omitempty"`
	// Flag to indicate whether or not the rule is enabled.
	//
	// Set this property
	// when you configure the rule. The default value is false (disabled).
	// If there is a rule conflict, the Server can override the setting to disable
	// a rule.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Name of the rule.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Flag to indicate whether compliance with this rule is mandatory or optional.
	//
	// The default value is false (optional).
	//   - A mandatory rule will prevent a virtual machine from being powered on
	//     or migrated to a host that does not satisfy the rule.
	//   - An optional rule specifies a preference. DRS takes an optional rule
	//     into consideration when it places a virtual machine in the cluster.
	//     DRS will act on an optional rule as long as it does not impact
	//     the ability of the host to satisfy current CPU or memory requirements
	//     for virtual machines on the system. (As long as the operation does not
	//     cause any host to be more than 100% utilized.)
	Mandatory *bool `xml:"mandatory" json:"mandatory,omitempty"`
	// Flag to indicate whether the rule is created by the user or the system.
	UserCreated *bool `xml:"userCreated" json:"userCreated,omitempty"`
	// Flag to indicate whether or not the placement of Virtual Machines is currently
	// in compliance with this rule.
	//
	// The Server does not currently use this property.
	InCompliance *bool `xml:"inCompliance" json:"inCompliance,omitempty"`
	// UUID for the rule.
	//
	// When adding a new rule, do not specify this
	// property. The Server will assign the key.
	RuleUuid string `xml:"ruleUuid,omitempty" json:"ruleUuid,omitempty"`
}

func init() {
	t["ClusterRuleInfo"] = reflect.TypeOf((*ClusterRuleInfo)(nil)).Elem()
}

// An incremental update to the cluster rules.
type ClusterRuleSpec struct {
	ArrayUpdateSpec

	Info BaseClusterRuleInfo `xml:"info,omitempty,typeattr" json:"info,omitempty"`
}

func init() {
	t["ClusterRuleSpec"] = reflect.TypeOf((*ClusterRuleSpec)(nil)).Elem()
}

// The base class `ClusterSlotPolicy` is used for specifying how
// the slot size is to be computed for the failover level HA admission control
// policy.
//
// By default, vSphere HA defines the slot size using the largest memory
// and cpu reservations of any powered on virtual machine in the cluster.
// Subclasses of this class define various policies to modify how the slot size
// is chosen to prevent outlier virtual machines (i.e. those with much larger
// reservations than the average) from skewing the slot size. If such a policy is chosen,
// outlier virtual machines will use multiple slots. Using such a policy introduces
// a risk that vSphere HA will be unable to failover these virtual machines because
// of resource fragmentation.
type ClusterSlotPolicy struct {
	DynamicData
}

func init() {
	t["ClusterSlotPolicy"] = reflect.TypeOf((*ClusterSlotPolicy)(nil)).Elem()
}

// This event records when a cluster's overall status changed.
type ClusterStatusChangedEvent struct {
	ClusterEvent

	// The old (`status`).
	OldStatus string `xml:"oldStatus" json:"oldStatus"`
	// The new (`status`).
	NewStatus string `xml:"newStatus" json:"newStatus"`
}

func init() {
	t["ClusterStatusChangedEvent"] = reflect.TypeOf((*ClusterStatusChangedEvent)(nil)).Elem()
}

// Configuration for System VMs deployment.
type ClusterSystemVMsConfigInfo struct {
	DynamicData

	// The only datastores which can be used for System VMs deployment.
	//
	// Refers instances of `Datastore`.
	AllowedDatastores []ManagedObjectReference `xml:"allowedDatastores,omitempty" json:"allowedDatastores,omitempty"`
	// Datastores which cannot be used for System VMs deployment.
	//
	// Refers instances of `Datastore`.
	NotAllowedDatastores []ManagedObjectReference `xml:"notAllowedDatastores,omitempty" json:"notAllowedDatastores,omitempty"`
	// Tag categories identifying datastores, which cannot be used for System VMs
	// deployment.
	DsTagCategoriesToExclude []string `xml:"dsTagCategoriesToExclude,omitempty" json:"dsTagCategoriesToExclude,omitempty"`
	// The System VM deployment mode for vSphere clusters.
	//
	// Supported values are enumerated by the
	// `DeploymentMode`
	// type.
	// An unset value implies SYSTEM\_MANAGED,
	// unless the cluster is put in "Retreat Mode".
	DeploymentMode string `xml:"deploymentMode,omitempty" json:"deploymentMode,omitempty" vim:"8.0.2.0"`
}

func init() {
	t["ClusterSystemVMsConfigInfo"] = reflect.TypeOf((*ClusterSystemVMsConfigInfo)(nil)).Elem()
	minAPIVersionForType["ClusterSystemVMsConfigInfo"] = "7.0.3.0"
}

// Configuration for System VMs deployment.
type ClusterSystemVMsConfigSpec struct {
	DynamicData

	// The only datastores which can be used for System VMs deployment.
	AllowedDatastores []ClusterDatastoreUpdateSpec `xml:"allowedDatastores,omitempty" json:"allowedDatastores,omitempty"`
	// Datastores which cannot be used for System VMs deployment.
	NotAllowedDatastores []ClusterDatastoreUpdateSpec `xml:"notAllowedDatastores,omitempty" json:"notAllowedDatastores,omitempty"`
	// Tag categories identifying datastores, which cannot be used for System VMs
	// deployment.
	DsTagCategoriesToExclude []ClusterTagCategoryUpdateSpec `xml:"dsTagCategoriesToExclude,omitempty" json:"dsTagCategoriesToExclude,omitempty"`
	// The System VM deployment mode for vSphere clusters.
	//
	// Supported values are enumerated by the
	// `DeploymentMode`
	// type.
	// Providing an unset value does not modify deploymentMode.
	DeploymentMode string `xml:"deploymentMode,omitempty" json:"deploymentMode,omitempty" vim:"8.0.2.0"`
}

func init() {
	t["ClusterSystemVMsConfigSpec"] = reflect.TypeOf((*ClusterSystemVMsConfigSpec)(nil)).Elem()
	minAPIVersionForType["ClusterSystemVMsConfigSpec"] = "7.0.3.0"
}

// An incremental update to a TagCategory list.
type ClusterTagCategoryUpdateSpec struct {
	ArrayUpdateSpec

	Category string `xml:"category,omitempty" json:"category,omitempty"`
}

func init() {
	t["ClusterTagCategoryUpdateSpec"] = reflect.TypeOf((*ClusterTagCategoryUpdateSpec)(nil)).Elem()
	minAPIVersionForType["ClusterTagCategoryUpdateSpec"] = "7.0.3.0"
}

// This class contains cluster usage summary that is populated
// by DRS and used by Cloud Placement Engine in VCD.
type ClusterUsageSummary struct {
	DynamicData

	// Total CPU capacity of the cluster.
	TotalCpuCapacityMhz int32 `xml:"totalCpuCapacityMhz" json:"totalCpuCapacityMhz"`
	// Total memory capacity of the cluster.
	TotalMemCapacityMB int32 `xml:"totalMemCapacityMB" json:"totalMemCapacityMB"`
	// Sum of CPU reservation of all the Resource Pools and powered-on VMs in the cluster.
	CpuReservationMhz int32 `xml:"cpuReservationMhz" json:"cpuReservationMhz"`
	// Sum of memory reservation of all the Resource Pools and powered-on VMs in the cluster.
	MemReservationMB int32 `xml:"memReservationMB" json:"memReservationMB"`
	// Sum of CPU reservation of all the powered-off VMs in the cluster.
	PoweredOffCpuReservationMhz int32 `xml:"poweredOffCpuReservationMhz,omitempty" json:"poweredOffCpuReservationMhz,omitempty"`
	// Sum of memory reservation of all the powered-off VMs in the cluster.
	PoweredOffMemReservationMB int32 `xml:"poweredOffMemReservationMB,omitempty" json:"poweredOffMemReservationMB,omitempty"`
	// Sum of CPU demand of all the powered-on VMs in the cluster.
	CpuDemandMhz int32 `xml:"cpuDemandMhz" json:"cpuDemandMhz"`
	// Sum of memory demand of all the powered-on VMs in the cluster.
	MemDemandMB int32 `xml:"memDemandMB" json:"memDemandMB"`
	// Generation number of the usage stats.
	//
	// Updated during every DRS load
	// balancing call.
	StatsGenNumber int64 `xml:"statsGenNumber" json:"statsGenNumber"`
	// This is the current CPU entitlement across the cluster
	CpuEntitledMhz int32 `xml:"cpuEntitledMhz" json:"cpuEntitledMhz"`
	// This is the current memory entitlement across the cluster
	MemEntitledMB int32 `xml:"memEntitledMB" json:"memEntitledMB"`
	// The number of powered off VMs in the cluster
	PoweredOffVmCount int32 `xml:"poweredOffVmCount" json:"poweredOffVmCount"`
	// The number of VMs in the cluster
	TotalVmCount int32 `xml:"totalVmCount" json:"totalVmCount"`
}

func init() {
	t["ClusterUsageSummary"] = reflect.TypeOf((*ClusterUsageSummary)(nil)).Elem()
}

// vSphere HA Virtual Machine Component Protection Service settings.
//
// vSphere HA Virtual Machine Component Protection Service detects
// and reacts to storage failures that do not necessarily cause a
// virtual machine to go down, but may impact the health or QoS of
// the virtual machine.
//
// All fields are defined as optional. In case of a reconfiguration, fields left unset
// are not changed.
type ClusterVmComponentProtectionSettings struct {
	DynamicData

	// VM storage protection setting for storage failures categorized as All Paths
	// Down (APD).
	//
	// APD is a condition where a storage has become inaccessible
	// for unknown reasons. It only indicates loss of connectivity and does not indicate
	// storage device failure or LUN removal (Permenant Device Loss or PDL). The details
	// of APD and PDL are described in `HostMountInfoInaccessibleReason_enum`.
	//
	// This property is meaningful only when vSphere HA is turned on. Valid values are
	// specified by `ClusterVmComponentProtectionSettingsStorageVmReaction_enum`. The default value is
	// `disabled` for cluster setting and
	// `clusterDefault` for per-VM setting.
	//
	// When an APD condition happens and the host begins timing out I/Os
	// (@link vim.host.MountInfo.InaccessibleReason#AllPathsDown\_Timeout}, VM Component
	// Protection service will react based on the specific value of this property:
	//   - `**disabled**`, no reaction, i.e., no
	//     VM failover and no event reporting for the failures.
	//   - `**warning**`, service will issue events,
	//     alarms and/or config issues for component failures.
	//   - `**restartConservative**`, service will
	//     terminate the impacted VMs after a preconfigured time interval
	//     (`ClusterVmComponentProtectionSettings.vmTerminateDelayForAPDSec`) if they are to be restarted.
	//   - `**restartAggressive**`, service might
	//     terminate the impacted VMs after a preconfigured time interval
	//     (`ClusterVmComponentProtectionSettings.vmTerminateDelayForAPDSec`). In some cases, a VM is terminated
	//     even if it may not able to be restarted or lose Fault Tolerance redundancy.
	//   - `**clusterDefault**`, service will implement
	//     cluster default.
	VmStorageProtectionForAPD string `xml:"vmStorageProtectionForAPD,omitempty" json:"vmStorageProtectionForAPD,omitempty"`
	// This property indicates if APD timeout will be enabled for all the hosts
	// in the cluster when vSphere HA is configured.
	//
	// The details of APD timeout are
	// described in `HostMountInfoInaccessibleReason_enum`.
	//
	// If `ClusterDasConfigInfo.vmComponentProtecting` is `disabled`,
	// the property will be ignored. Otherwise, for each host in the cluster,
	// APD timeout will be enabled. Note that no change will be made for a host if it
	// already had APD timeout enabled.
	//
	// This property is meaningful only for cluster setting. It is ignored if specified at VM level.
	// The default value is false if not specified.
	//
	// Note that this property is not persisted by vSphere backend. It does not impact any cluster
	// reconfiguration or host operation (such as adding a host to a cluster) that might happen later.
	EnableAPDTimeoutForHosts *bool `xml:"enableAPDTimeoutForHosts" json:"enableAPDTimeoutForHosts,omitempty"`
	// The time interval after an APD timeout has been declared and before VM Component
	// Protection service will terminate the VM.
	//
	// The value only applies if
	// `ClusterVmComponentProtectionSettings.vmStorageProtectionForAPD` is set to `restartConservative` or
	// `restartAggressive`.
	//
	// The default value is 180 seconds if not specified. To use cluster setting for a VM override,
	// set to -1 in per-VM setting.
	VmTerminateDelayForAPDSec int32 `xml:"vmTerminateDelayForAPDSec,omitempty" json:"vmTerminateDelayForAPDSec,omitempty"`
	// Action taken by VM Component Protection service for a powered on VM when APD
	// condition clears after APD timeout.
	//
	// This property is meaningful only when vSphere HA is turned on. Valid values are
	// specified by `ClusterVmComponentProtectionSettingsVmReactionOnAPDCleared_enum`. The default value is
	// `none` for cluster setting and
	// `useClusterDefault` for per-VM setting.
	VmReactionOnAPDCleared string `xml:"vmReactionOnAPDCleared,omitempty" json:"vmReactionOnAPDCleared,omitempty"`
	// VM storage protection setting for storage failures categorized as Permenant Device
	// Loss (PDL).
	//
	// PDL indicates storage device failure or LUN removal. In case of PDL,
	// the failed datastore or device is unlikely to recover. The details of PDL are
	// described in `HostMountInfoInaccessibleReason_enum`.
	//
	// This property is meaningful only when vSphere HA is turned on. Valid values are
	// `disabled`, `warning`,
	// `restartAggressive` and `clusterDefault`.
	// The default value is `disabled` for cluster setting and
	// `clusterDefault` for per-VM setting.
	//
	// When set to `restartAggressive`, VM Component Protection service
	// will immediately terminate the VMs impacted by PDL and will attempt to restart the VMs
	// with best effort. When set to the other values, the behavior is the same as described for
	// `ClusterVmComponentProtectionSettings.vmStorageProtectionForAPD`.
	VmStorageProtectionForPDL string `xml:"vmStorageProtectionForPDL,omitempty" json:"vmStorageProtectionForPDL,omitempty"`
}

func init() {
	t["ClusterVmComponentProtectionSettings"] = reflect.TypeOf((*ClusterVmComponentProtectionSettings)(nil)).Elem()
}

// The `ClusterVmGroup` data object identifies virtual machines
// for VM-Host rules.
//
// VM-Host rules determine placement of virtual machines
// on hosts in a cluster.
// The logic specified in a `ClusterVmHostRuleInfo` object
// determines where virtual machines can be powered-on.
//
// If a virtual machine is removed from the cluster, it loses its DRS group
// affiliation. The Server does not restore any group affiliations if the
// virtual machine is returned to the cluster.
type ClusterVmGroup struct {
	ClusterGroupInfo

	// List of virtual machines that are part of this group.
	//
	// A virtual machine group can contain zero or more virtual machines.
	//
	// Refers instances of `VirtualMachine`.
	Vm []ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
}

func init() {
	t["ClusterVmGroup"] = reflect.TypeOf((*ClusterVmGroup)(nil)).Elem()
}

// A `ClusterVmHostRuleInfo` object identifies virtual machines
// and host groups that determine virtual machine placement. The virtual
// machines and hosts referenced by a VM-Host rule must be in the same cluster.
//
// A VM-Host rule identifies the following groups.
//   - A virtual machine group (`ClusterVmGroup`).
//   - Two host groups - an affine host group and an anti-affine host group
//     (`ClusterHostGroup`).
//     At least one of the groups must contain one or more hosts.
//
// `ClusterVmHostRuleInfo` stores only the names of the relevant
// virtual machine and host groups. The group contents are stored in
// the virtual machine and host group objects.
//
// When you modify a VM-Host rule, only the fields that are specified are set.
type ClusterVmHostRuleInfo struct {
	ClusterRuleInfo

	// Virtual group name (`ClusterVmGroup*.*ClusterGroupInfo.name`).
	//
	// The virtual group may contain one or more virtual machines.
	VmGroupName string `xml:"vmGroupName,omitempty" json:"vmGroupName,omitempty"`
	// Name of the affine host group
	// (`ClusterHostGroup*.*ClusterGroupInfo.name`).
	//
	// The affine host group identifies hosts on which
	// `ClusterVmHostRuleInfo.vmGroupName` virtual machines can be powered-on.
	// The value of the `ClusterRuleInfo.mandatory` property
	// determines how the Server interprets the rule.
	AffineHostGroupName string `xml:"affineHostGroupName,omitempty" json:"affineHostGroupName,omitempty"`
	// Name of the anti-affine host group
	// (`ClusterHostGroup*.*ClusterGroupInfo.name`).
	//
	// The anti-affine host group identifies hosts on which
	// `ClusterVmHostRuleInfo.vmGroupName` virtual machines should not
	// be powered-on.
	// The value of the `ClusterRuleInfo.mandatory` property
	// determines how the Server interprets the rule.
	AntiAffineHostGroupName string `xml:"antiAffineHostGroupName,omitempty" json:"antiAffineHostGroupName,omitempty"`
}

func init() {
	t["ClusterVmHostRuleInfo"] = reflect.TypeOf((*ClusterVmHostRuleInfo)(nil)).Elem()
}

// The `ClusterVmOrchestrationInfo` data object contains the orchestration
// configuration for a single virtual machine.
//
// This makes it possible to
// override the defaut behavior for an individual virtual machine.
type ClusterVmOrchestrationInfo struct {
	DynamicData

	// Reference to the VM that the ready state is applied to.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// Readiness policy that apply to this virtual machine.
	//
	// Values specified in this object override the cluster-wide
	// defaults for virtual machines.
	// `ClusterOrchestrationInfo.defaultVmReadiness`
	VmReadiness ClusterVmReadiness `xml:"vmReadiness" json:"vmReadiness"`
}

func init() {
	t["ClusterVmOrchestrationInfo"] = reflect.TypeOf((*ClusterVmOrchestrationInfo)(nil)).Elem()
}

// An incremental update to the per-VM orchestration config.
type ClusterVmOrchestrationSpec struct {
	ArrayUpdateSpec

	Info *ClusterVmOrchestrationInfo `xml:"info,omitempty" json:"info,omitempty"`
}

func init() {
	t["ClusterVmOrchestrationSpec"] = reflect.TypeOf((*ClusterVmOrchestrationSpec)(nil)).Elem()
}

// VM readiness policy specifies when a VM is deemed ready.
//
// This is used in cluster VM orchestration settings. For example, vSphere HA
// restarts lower priority VMs only after higher priority VMs are ready.
type ClusterVmReadiness struct {
	DynamicData

	// Ready condition for a virtual machine.
	//
	// See `ClusterVmReadinessReadyCondition_enum`.
	//
	// If not specified at either the cluster level or the virtual machine
	// level, this will default to `none`.
	ReadyCondition string `xml:"readyCondition,omitempty" json:"readyCondition,omitempty"`
	// Additional delay in seconds after ready condition is met.
	//
	// A VM is
	// considered ready at this point.
	//
	// If not specified in a VM override, cluster default setting is
	// used. Alternatively, set to -1 in per-VM setting to use cluster default
	// value.
	PostReadyDelay int32 `xml:"postReadyDelay,omitempty" json:"postReadyDelay,omitempty"`
}

func init() {
	t["ClusterVmReadiness"] = reflect.TypeOf((*ClusterVmReadiness)(nil)).Elem()
}

// The `ClusterVmToolsMonitoringSettings` data object contains
// virtual machine monitoring settings that are used by the Virtual Machine Health Monitoring Service.
//
// The Service checks the VMware Tools heartbeat of a virtual machine.
// If heartbeats have not been received within a specified time interval, the Service
// declares the virtual machine as failed and resets the virtual machine.
//
// These settings are applied to individual virtual machines during cluster reconfiguration
// (`ClusterDasVmConfigInfo*.*ClusterDasVmConfigInfo.dasSettings*.*ClusterDasVmSettings.vmToolsMonitoringSettings`). You can also specify them as default values
// (`ClusterDasConfigInfo*.*ClusterDasConfigInfo.defaultVmSettings`).
//
// All fields are optional. In case of a reconfiguration, fields left unset are not changed.
type ClusterVmToolsMonitoringSettings struct {
	DynamicData

	// Deprecated as of vSphere API 4.1, use `ClusterVmToolsMonitoringSettings.vmMonitoring`.
	//
	// Flag indicating whether or not the Virtual Machine Health Monitoring
	// service is enabled.
	//
	// The Server does not use this property.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Indicates the type of virtual machine monitoring.
	//
	// Specify a string value corresponding to one of the
	// following `ClusterDasConfigInfoVmMonitoringState_enum` values:
	//   - <code>vmMonitoringDisabled</code> (the default value)
	//   - <code>vmMonitoringOnly</code>
	//   - <code>vmAndAppMonitoring</code>
	//
	// The individual VMware Tools setting for virtual machine monitoring depends on
	// the HA Virtual Machine Health Monitoring Service level that is
	// defined for the cluster
	// (`ClusterDasConfigInfo*.*ClusterDasConfigInfo.vmMonitoring`).
	// The following list indicates the supported VMware Tools <code>vmMonitoring</code> values
	// according to the cluster configuration.
	//   - If the cluster configuration specifies <code>vmMonitoringDisabled</code>,
	//     the Service is disabled and the HA Service ignores the VMware Tools monitoring setting.
	//   - If the cluster configuration specifies <code>vmMonitoringOnly</code>,
	//     the Service supports <code>vmMonitoringOnly</code> or <code>vmMonitoringDisabled</code> only.
	//   - If the cluster configuration specifies <code>vmAndAppMonitoring</code>,
	//     you can use any of the `ClusterDasConfigInfoVmMonitoringState_enum` values.
	//
	// The `ClusterVmToolsMonitoringSettings.clusterSettings` value has no
	// effect on the constraint imposed by the HA Virtual Machine Health Monitoring Service
	// level that is defined for the cluster
	// (`ClusterDasConfigInfo*.*ClusterDasConfigInfo.vmMonitoring`).
	//
	// Application monitoring events are generated regardless of the
	// currently configured type of virtual machine monitoring.
	// You can use these events even if monitoring is being disabled
	// or set to <code>vmMonitoringOnly</code>.
	VmMonitoring string `xml:"vmMonitoring,omitempty" json:"vmMonitoring,omitempty"`
	// Flag indicating whether to use the cluster settings or the per VM settings.
	//
	// The default value is true.
	ClusterSettings *bool `xml:"clusterSettings" json:"clusterSettings,omitempty"`
	// If no heartbeat has been received for at least the specified number of seconds,
	// the virtual machine is declared as failed.
	//
	// The default value is 30.
	FailureInterval int32 `xml:"failureInterval,omitempty" json:"failureInterval,omitempty"`
	// The number of seconds for the virtual machine's heartbeats to stabilize
	// after the virtual machine has been powered on.
	//
	// This time should include
	// the guest operating system boot-up time. The virtual machine monitoring
	// will begin only after this period.
	//
	// The default value is 120.
	MinUpTime int32 `xml:"minUpTime,omitempty" json:"minUpTime,omitempty"`
	// Maximum number of failures and automated resets allowed during the time that
	// `ClusterVmToolsMonitoringSettings.maxFailureWindow` specifies.
	//
	// If `ClusterVmToolsMonitoringSettings.maxFailureWindow` is -1
	// (no window), this represents the absolute number of failures after which
	// automated response is stopped.
	//
	// If a virtual machine exceeds this threshold, in-depth problem analysis is
	// usually needed.
	//
	// The default value is 3.
	MaxFailures int32 `xml:"maxFailures,omitempty" json:"maxFailures,omitempty"`
	// The number of seconds for the window during which up to `ClusterVmToolsMonitoringSettings.maxFailures`
	// resets can occur before automated responses stop.
	//
	// If set to -1, no failure window is specified.
	//
	// The default value is -1.
	MaxFailureWindow int32 `xml:"maxFailureWindow,omitempty" json:"maxFailureWindow,omitempty"`
}

func init() {
	t["ClusterVmToolsMonitoringSettings"] = reflect.TypeOf((*ClusterVmToolsMonitoringSettings)(nil)).Elem()
}

// The distributed virtual switch received a reconfiguration request to
// activate ipfix monitoring of the switch traffic.
//
// However, the address
// and/or the port of the ipfix collector has not been specified.
type CollectorAddressUnset struct {
	DvsFault
}

func init() {
	t["CollectorAddressUnset"] = reflect.TypeOf((*CollectorAddressUnset)(nil)).Elem()
}

type CollectorAddressUnsetFault CollectorAddressUnset

func init() {
	t["CollectorAddressUnsetFault"] = reflect.TypeOf((*CollectorAddressUnsetFault)(nil)).Elem()
}

type ComplianceFailure struct {
	DynamicData

	// String uniquely identifying the failure.
	FailureType string `xml:"failureType" json:"failureType"`
	// Message which describes the compliance failures
	// message.key serves as a key to the localized
	// message catalog.
	Message LocalizableMessage `xml:"message" json:"message"`
	// Name of the Expression which generated the ComplianceFailure
	ExpressionName string `xml:"expressionName,omitempty" json:"expressionName,omitempty"`
	// If complianceStatus is non-compliant, failureValues will
	// contain values of the non-compliant fields on the host and
	// in the profile.
	FailureValues []ComplianceFailureComplianceFailureValues `xml:"failureValues,omitempty" json:"failureValues,omitempty"`
}

func init() {
	t["ComplianceFailure"] = reflect.TypeOf((*ComplianceFailure)(nil)).Elem()
}

type ComplianceFailureComplianceFailureValues struct {
	DynamicData

	// Unique key to a message in the localized message catalog,
	// identifying the fields being compared.
	ComparisonIdentifier string `xml:"comparisonIdentifier" json:"comparisonIdentifier"`
	// Name of the profile instance, in case of non-singleton profiles.
	ProfileInstance string `xml:"profileInstance,omitempty" json:"profileInstance,omitempty"`
	// Value of the non-compliant field on the host.
	HostValue AnyType `xml:"hostValue,omitempty,typeattr" json:"hostValue,omitempty"`
	// Value of the non-compliant field in the profile.
	ProfileValue AnyType `xml:"profileValue,omitempty,typeattr" json:"profileValue,omitempty"`
}

func init() {
	t["ComplianceFailureComplianceFailureValues"] = reflect.TypeOf((*ComplianceFailureComplianceFailureValues)(nil)).Elem()
}

// This dataObject contains information about location of applyProfile
// which was responsible for generation of a particular ComplianceExpression.
type ComplianceLocator struct {
	DynamicData

	// Exression for which the Locator corresponds to
	ExpressionName string `xml:"expressionName" json:"expressionName"`
	// Complete path to the profile/policy which was responsible for the
	// generation of the ComplianceExpression.
	//
	// \[ProfilePath + policyId\] will uniquely identify a Policy.
	ApplyPath ProfilePropertyPath `xml:"applyPath" json:"applyPath"`
}

func init() {
	t["ComplianceLocator"] = reflect.TypeOf((*ComplianceLocator)(nil)).Elem()
}

// DataObject contains the verifications that need to be done
// to make sure the entity is in compliance.
type ComplianceProfile struct {
	DynamicData

	// List of expressions that make up the ComplianceChecks.
	Expression []BaseProfileExpression `xml:"expression,typeattr" json:"expression"`
	// Name of the Expression which is the root of the expression tree.
	RootExpression string `xml:"rootExpression" json:"rootExpression"`
}

func init() {
	t["ComplianceProfile"] = reflect.TypeOf((*ComplianceProfile)(nil)).Elem()
}

// DataObject representing the result from a ComplianceCheck
type ComplianceResult struct {
	DynamicData

	// Profile for which the ComplianceResult applies
	//
	// Refers instance of `Profile`.
	Profile *ManagedObjectReference `xml:"profile,omitempty" json:"profile,omitempty"`
	// Indicates the compliance status of the entity.
	//
	// See @link Status
	ComplianceStatus string `xml:"complianceStatus" json:"complianceStatus"`
	// Entity on which the compliance check was carried out.
	//
	// Entity can be a Cluster, Host and so on.
	//
	// Refers instance of `ManagedEntity`.
	Entity *ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
	// Time at which compliance check was last run on the entity
	CheckTime *time.Time `xml:"checkTime" json:"checkTime,omitempty"`
	// If complianceStatus is non-compliant, failure will
	// contain additional information about the compliance errors.
	Failure []ComplianceFailure `xml:"failure,omitempty" json:"failure,omitempty"`
}

func init() {
	t["ComplianceResult"] = reflect.TypeOf((*ComplianceResult)(nil)).Elem()
}

// The parameters of `HostProfileManager.CompositeHostProfile_Task`.
type CompositeHostProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Refers instance of `Profile`.
	Source ManagedObjectReference `xml:"source" json:"source"`
	// Refers instances of `Profile`.
	Targets                []ManagedObjectReference `xml:"targets,omitempty" json:"targets,omitempty"`
	ToBeMerged             *HostApplyProfile        `xml:"toBeMerged,omitempty" json:"toBeMerged,omitempty"`
	ToBeReplacedWith       *HostApplyProfile        `xml:"toBeReplacedWith,omitempty" json:"toBeReplacedWith,omitempty"`
	ToBeDeleted            *HostApplyProfile        `xml:"toBeDeleted,omitempty" json:"toBeDeleted,omitempty"`
	EnableStatusToBeCopied *HostApplyProfile        `xml:"enableStatusToBeCopied,omitempty" json:"enableStatusToBeCopied,omitempty"`
}

func init() {
	t["CompositeHostProfileRequestType"] = reflect.TypeOf((*CompositeHostProfileRequestType)(nil)).Elem()
}

type CompositeHostProfile_Task CompositeHostProfileRequestType

func init() {
	t["CompositeHostProfile_Task"] = reflect.TypeOf((*CompositeHostProfile_Task)(nil)).Elem()
}

type CompositeHostProfile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// DataObject represents a composite Policy that is created by the user
// using different PolicyOptions.
//
// The options set in the CompositePolicyOption
// should be derived from the possible options as indicated by the
// CompositePolicyOptionMetadata.
type CompositePolicyOption struct {
	PolicyOption

	// List of policy options that are composed and applicable for
	// this composite policy option.
	//
	// The selected PolicyOptions in a CompositePolicyOption will be used in the
	// policy. PolicyOptions need not be specified if they are not desired for
	// the CompositePolicyOption.
	// Order of PolicyOptions in the PolicyOption array is not significant.
	// The host profile policy engine will not respect order of PolicyOptions.
	// It will apply PolicyOptions in a pre-determined order.
	// Clients of the API must produce PolicyOption in the same order as specified
	// in the metadata.
	Option []BasePolicyOption `xml:"option,omitempty,typeattr" json:"option,omitempty"`
}

func init() {
	t["CompositePolicyOption"] = reflect.TypeOf((*CompositePolicyOption)(nil)).Elem()
}

type ComputeDiskPartitionInfo ComputeDiskPartitionInfoRequestType

func init() {
	t["ComputeDiskPartitionInfo"] = reflect.TypeOf((*ComputeDiskPartitionInfo)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResize ComputeDiskPartitionInfoForResizeRequestType

func init() {
	t["ComputeDiskPartitionInfoForResize"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResize)(nil)).Elem()
}

// The parameters of `HostStorageSystem.ComputeDiskPartitionInfoForResize`.
type ComputeDiskPartitionInfoForResizeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The disk partition to resize.
	Partition HostScsiDiskPartition `xml:"partition" json:"partition"`
	// Specifies the desired block range for the resized
	// partition. The start of the block range specified should match
	// that of the current partition.
	BlockRange HostDiskPartitionBlockRange `xml:"blockRange" json:"blockRange"`
	// Specifies the desired partition format to be
	// computed from the block range.
	// If partitionFormat is not specified, the existing partitionFormat
	// on disk is used, if the disk is not blank and mbr otherwise.
	PartitionFormat string `xml:"partitionFormat,omitempty" json:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoForResizeRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResizeRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResizeResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval" json:"returnval"`
}

// The parameters of `HostStorageSystem.ComputeDiskPartitionInfo`.
type ComputeDiskPartitionInfoRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the device path for the specific disk.
	DevicePath string `xml:"devicePath" json:"devicePath"`
	// A data object that describes the disk partition layout.
	Layout HostDiskPartitionLayout `xml:"layout" json:"layout"`
	// Specifies the desired partition format to be
	// computed from the block range.
	// If partitionFormat is not specified, the existing partitionFormat
	// on disk is used, if the disk is not blank and mbr otherwise.
	PartitionFormat string `xml:"partitionFormat,omitempty" json:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval" json:"returnval"`
}

// Configuration of the compute resource; applies to both standalone hosts
// and clusters.
type ComputeResourceConfigInfo struct {
	DynamicData

	// Swapfile placement policy for virtual machines within this compute
	// resource.
	//
	// Any policy except for "inherit" is a valid value for this
	// property; the default is "vmDirectory". This setting will be honored
	// for each virtual machine within the compute resource for which the
	// following is true:
	//   - The virtual machine is executing on a host that has the
	//     `perVmSwapFiles` capability.
	//   - The virtual machine configuration's
	//     `swapPlacement` property is set
	//     to "inherit".
	//
	// See also `VirtualMachineConfigInfoSwapPlacementType_enum`.
	VmSwapPlacement string `xml:"vmSwapPlacement" json:"vmSwapPlacement"`
	// Flag indicating whether or not the SPBM(Storage Policy Based Management)
	// feature is enabled on this compute resource
	SpbmEnabled *bool `xml:"spbmEnabled" json:"spbmEnabled,omitempty"`
	// Key for Default Hardware Version used on this compute resource
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// This field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of this object and all its children
	// with this field unset.
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty" json:"defaultHardwareVersionKey,omitempty"`
	// Key for Maximum Hardware Version used on this compute resource
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// This field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of this object and all its children
	// with this field unset.
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty" json:"maximumHardwareVersionKey,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["ComputeResourceConfigInfo"] = reflect.TypeOf((*ComputeResourceConfigInfo)(nil)).Elem()
}

// Changes to apply to the compute resource configuration.
type ComputeResourceConfigSpec struct {
	DynamicData

	// New setting for the swapfile placement policy.
	//
	// Any change to this
	// policy will affect virtual machines that subsequently power on or
	// resume from a suspended state in this compute resource, or that
	// migrate to a host in this compute resource while powered on; virtual
	// machines that are currently powered on in this compute resource will
	// not yet be affected.
	//
	// See also `VirtualMachineConfigInfoSwapPlacementType_enum`.
	VmSwapPlacement string `xml:"vmSwapPlacement,omitempty" json:"vmSwapPlacement,omitempty"`
	// Flag indicating whether or not the SPBM(Storage Policy Based Management)
	// feature is enabled on this compute resource
	SpbmEnabled *bool `xml:"spbmEnabled" json:"spbmEnabled,omitempty"`
	// Key for Default Hardware Version to be used on this compute resource
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// Setting this field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of this object and all its children
	// with this field unset.
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty" json:"defaultHardwareVersionKey,omitempty"`
	// Desired software spec for the set of physical compute resources.
	//
	// This
	// parameter is only supported in vim.Folder#createClusterEx operation.
	DesiredSoftwareSpec *DesiredSoftwareSpec `xml:"desiredSoftwareSpec,omitempty" json:"desiredSoftwareSpec,omitempty"`
	// Key for Maximum Hardware Version to be used on this compute resource
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// Setting this field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of this object and all its children
	// with this field unset.
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty" json:"maximumHardwareVersionKey,omitempty" vim:"7.0.2.0"`
	// Flag indicating whether or not the vLCM (vSphere Lifecycle Manager)
	// Config Manager feature is enabled on this compute resource.
	//
	// If the
	// flag is not set, the Config Manager feature will be disabled by
	// default. This parameter is only supported in `Folder.CreateClusterEx`
	// operation.
	EnableConfigManager *bool `xml:"enableConfigManager" json:"enableConfigManager,omitempty" vim:"7.0.3.1"`
	// Specification for the host seeding operation.
	HostSeedSpec *ComputeResourceHostSeedSpec `xml:"hostSeedSpec,omitempty" json:"hostSeedSpec,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["ComputeResourceConfigSpec"] = reflect.TypeOf((*ComputeResourceConfigSpec)(nil)).Elem()
}

// The event argument is a ComputeResource object.
type ComputeResourceEventArgument struct {
	EntityEventArgument

	// The ComputeResource object.
	//
	// Refers instance of `ComputeResource`.
	ComputeResource ManagedObjectReference `xml:"computeResource" json:"computeResource"`
}

func init() {
	t["ComputeResourceEventArgument"] = reflect.TypeOf((*ComputeResourceEventArgument)(nil)).Elem()
}

// The `ComputeResourceHostSPBMLicenseInfo` data object
// encapsulates the SPBM(Storage Policy Based Management) license
// information for a host.
type ComputeResourceHostSPBMLicenseInfo struct {
	DynamicData

	// Refers instance of `HostSystem`.
	Host         ManagedObjectReference                                 `xml:"host" json:"host"`
	LicenseState ComputeResourceHostSPBMLicenseInfoHostSPBMLicenseState `xml:"licenseState" json:"licenseState"`
}

func init() {
	t["ComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

type ComputeResourceHostSeedSpec struct {
	DynamicData

	// Specification for the seed host.
	SingleHostSpec ComputeResourceHostSeedSpecSingleHostSpec `xml:"singleHostSpec" json:"singleHostSpec"`
}

func init() {
	t["ComputeResourceHostSeedSpec"] = reflect.TypeOf((*ComputeResourceHostSeedSpec)(nil)).Elem()
	minAPIVersionForType["ComputeResourceHostSeedSpec"] = "8.0.3.0"
}

// This data object contains a specification for a single candidate host
// for the host seeding operation.
//
// If the candidate host is:
// \- A new host not managed by vCenter Server: A `HostConnectSpec`
// needs to be provided.
// \- A host managed by vCenter Server: A `HostSystem`
// needs to be provided.
type ComputeResourceHostSeedSpecSingleHostSpec struct {
	DynamicData

	// Connection Spec for a new host.
	NewHostCnxSpec *HostConnectSpec `xml:"newHostCnxSpec,omitempty" json:"newHostCnxSpec,omitempty"`
	// Reference to an existing host.
	//
	// Refers instance of `HostSystem`.
	ExistingHost *ManagedObjectReference `xml:"existingHost,omitempty" json:"existingHost,omitempty"`
}

func init() {
	t["ComputeResourceHostSeedSpecSingleHostSpec"] = reflect.TypeOf((*ComputeResourceHostSeedSpecSingleHostSpec)(nil)).Elem()
}

// This data object type encapsulates a typical set of ComputeResource information
// that is useful for list views and summary pages.
type ComputeResourceSummary struct {
	DynamicData

	// Aggregated CPU resources of all hosts, in MHz.
	TotalCpu int32 `xml:"totalCpu" json:"totalCpu"`
	// Aggregated memory resources of all hosts, in bytes.
	TotalMemory int64 `xml:"totalMemory" json:"totalMemory"`
	// Number of physical CPU cores.
	//
	// Physical CPU cores are the processors contained
	// by a CPU package.
	NumCpuCores int16 `xml:"numCpuCores" json:"numCpuCores"`
	// Aggregated number of CPU threads.
	NumCpuThreads int16 `xml:"numCpuThreads" json:"numCpuThreads"`
	// Effective CPU resources (in MHz) available to run virtual machines.
	//
	// This is the
	// aggregated effective resource level from all running hosts. Hosts that are in
	// maintenance mode or are unresponsive are not counted. Resources used by the
	// VMware Service Console are not included in the aggregate. This value represents
	// the amount of resources available for the root resource pool for running
	// virtual machines.
	EffectiveCpu int32 `xml:"effectiveCpu" json:"effectiveCpu"`
	// Effective memory resources (in MB) available to run virtual machines.
	//
	// This is the aggregated effective resource level from all running hosts. Hosts
	// that are in maintenance mode or are unresponsive are not counted.
	// Resources used by the VMware Service Console are not included in the aggregate.
	// This value represents the amount of resources available for the root
	// resource pool for running virtual machines.
	EffectiveMemory int64 `xml:"effectiveMemory" json:"effectiveMemory"`
	// Total number of hosts.
	NumHosts int32 `xml:"numHosts" json:"numHosts"`
	// Total number of effective hosts.
	NumEffectiveHosts int32 `xml:"numEffectiveHosts" json:"numEffectiveHosts"`
	// Overall alarm status.
	//
	// In releases after vSphere API 5.0, vSphere Servers might not
	// generate property collector update notifications for this property.
	// To obtain the latest value of the property, you can use
	// PropertyCollector methods RetrievePropertiesEx or WaitForUpdatesEx.
	// If you use the PropertyCollector.WaitForUpdatesEx method, specify
	// an empty string for the version parameter.
	// Since this property is on a DataObject, an update returned by WaitForUpdatesEx may
	// contain values for this property when some other property on the DataObject changes.
	// If this update is a result of a call to WaitForUpdatesEx with a non-empty
	// version parameter, the value for this property may not be current.
	OverallStatus ManagedEntityStatus `xml:"overallStatus" json:"overallStatus"`
}

func init() {
	t["ComputeResourceSummary"] = reflect.TypeOf((*ComputeResourceSummary)(nil)).Elem()
}

// A ConcurrentAccess fault is thrown when an operation
// fails because another operation has modified the
// datastructure.
//
// For non-transactional operations, such as a recursive
// delete of a subtree of the inventory, the operation might
// fail with ConcurrentAccess if another thread has added
// a new entity to the hierarchy.
type ConcurrentAccess struct {
	VimFault
}

func init() {
	t["ConcurrentAccess"] = reflect.TypeOf((*ConcurrentAccess)(nil)).Elem()
}

type ConcurrentAccessFault ConcurrentAccess

func init() {
	t["ConcurrentAccessFault"] = reflect.TypeOf((*ConcurrentAccessFault)(nil)).Elem()
}

// The ConfigTarget class contains information about "physical" devices that can
// be used to back virtual devices.
type ConfigTarget struct {
	DynamicData

	// Number of logical CPUs that can be used to run virtual machines.
	//
	// If invoked against a cluster, this is the total number of logical CPUs
	// available in the cluster.
	NumCpus int32 `xml:"numCpus" json:"numCpus"`
	// Number of physical CPU cores that are available to run virtual machines.
	//
	// If invoked against a cluster, this is the total number of physical CPUs
	// available in the cluster.
	NumCpuCores int32 `xml:"numCpuCores" json:"numCpuCores"`
	// Number of NUMA nodes.
	//
	// If invoked against a cluster, this is the total number of NUMA nodes
	// available in the cluster.
	NumNumaNodes int32 `xml:"numNumaNodes" json:"numNumaNodes"`
	// Maximum number of CPUs available on a single host.
	//
	// For standalone hosts, this value will be the same as numCpus.
	MaxCpusPerHost int32 `xml:"maxCpusPerHost,omitempty" json:"maxCpusPerHost,omitempty"`
	// Presence of System Management Controller, indicates the host is
	// Apple hardware, and thus capable of running Mac OS guest as VM.
	SmcPresent *bool `xml:"smcPresent" json:"smcPresent,omitempty"`
	// List of datastores available for virtual disks and associated storage.
	Datastore []VirtualMachineDatastoreInfo `xml:"datastore,omitempty" json:"datastore,omitempty"`
	// List of networks available for virtual network adapters.
	Network []VirtualMachineNetworkInfo `xml:"network,omitempty" json:"network,omitempty"`
	// List of opaque networks available for virtual network adapters.
	OpaqueNetwork []OpaqueNetworkTargetInfo `xml:"opaqueNetwork,omitempty" json:"opaqueNetwork,omitempty"`
	// List of networks available from DistributedVirtualSwitch for virtual
	// network adapters.
	DistributedVirtualPortgroup []DistributedVirtualPortgroupInfo `xml:"distributedVirtualPortgroup,omitempty" json:"distributedVirtualPortgroup,omitempty"`
	// List of distributed virtual switch available for virtual network
	// adapters.
	DistributedVirtualSwitch []DistributedVirtualSwitchInfo `xml:"distributedVirtualSwitch,omitempty" json:"distributedVirtualSwitch,omitempty"`
	// List of CD-ROM devices available for use by virtual CD-ROMs.
	//
	// Used for
	// `VirtualCdromAtapiBackingInfo`.
	CdRom []VirtualMachineCdromInfo `xml:"cdRom,omitempty" json:"cdRom,omitempty"`
	// List of serial devices available to support virtualization.
	//
	// Used for
	// `VirtualSerialPortDeviceBackingInfo`.
	Serial []VirtualMachineSerialInfo `xml:"serial,omitempty" json:"serial,omitempty"`
	// List of parallel devices available to support virtualization.
	//
	// Used for
	// `VirtualParallelPortDeviceBackingInfo`.
	Parallel []VirtualMachineParallelInfo `xml:"parallel,omitempty" json:"parallel,omitempty"`
	// List of sound devices available to support virtualization.
	//
	// Used for
	// `VirtualSoundCardDeviceBackingInfo`.
	Sound []VirtualMachineSoundInfo `xml:"sound,omitempty" json:"sound,omitempty"`
	// List of USB devices on the host that are available to support
	// virtualization.
	//
	// Used for
	// `VirtualUSBUSBBackingInfo`.
	Usb []VirtualMachineUsbInfo `xml:"usb,omitempty" json:"usb,omitempty"`
	// List of floppy devices available for use by virtual floppies.
	//
	// Used for
	// `VirtualFloppyDeviceBackingInfo`.
	Floppy []VirtualMachineFloppyInfo `xml:"floppy,omitempty" json:"floppy,omitempty"`
	// Legacy switch names when using the LegacyNetworkBacking types.
	LegacyNetworkInfo []VirtualMachineLegacyNetworkSwitchInfo `xml:"legacyNetworkInfo,omitempty" json:"legacyNetworkInfo,omitempty"`
	// List of generic SCSI devices.
	ScsiPassthrough []VirtualMachineScsiPassthroughInfo `xml:"scsiPassthrough,omitempty" json:"scsiPassthrough,omitempty"`
	// List of physical SCSI disks that can be used as targets for raw disk mapping
	// backings.
	ScsiDisk []VirtualMachineScsiDiskDeviceInfo `xml:"scsiDisk,omitempty" json:"scsiDisk,omitempty"`
	// List of physical IDE disks that can be used as targets for raw disk backings.
	IdeDisk []VirtualMachineIdeDiskDeviceInfo `xml:"ideDisk,omitempty" json:"ideDisk,omitempty"`
	// Maximum recommended memory size, in MB, for creating a new virtual machine.
	MaxMemMBOptimalPerf int32 `xml:"maxMemMBOptimalPerf" json:"maxMemMBOptimalPerf"`
	// Maximum supported memory size, in MB, for creating a new virtual machine.
	//
	// Maximum allowed size is smaller of this and limit in
	// `GuestOsDescriptor.supportedMaxMemMB`. When invoked on the
	// cluster, maximum size that can be created on at least one host
	// in the cluster is reported.
	SupportedMaxMemMB int32 `xml:"supportedMaxMemMB,omitempty" json:"supportedMaxMemMB,omitempty"`
	// Information about the current available resources on the current resource pool
	// for a virtual machine.
	//
	// This field is only populated from an Environment browser
	// obtained from a virtual machine.
	ResourcePool *ResourcePoolRuntimeInfo `xml:"resourcePool,omitempty" json:"resourcePool,omitempty"`
	// Information whether a virtual machine with this ConfigTarget can auto vmotion.
	//
	// This field is only populated from an Environment browser obtained from a
	// virtual machine.
	AutoVmotion *bool `xml:"autoVmotion" json:"autoVmotion,omitempty"`
	// List of generic PCI devices.
	PciPassthrough []BaseVirtualMachinePciPassthroughInfo `xml:"pciPassthrough,omitempty,typeattr" json:"pciPassthrough,omitempty"`
	// List of SRIOV devices.
	Sriov []VirtualMachineSriovInfo `xml:"sriov,omitempty" json:"sriov,omitempty"`
	// List of vFlash modules.
	VFlashModule []VirtualMachineVFlashModuleInfo `xml:"vFlashModule,omitempty" json:"vFlashModule,omitempty"`
	// List of shared GPU passthrough types.
	SharedGpuPassthroughTypes []VirtualMachinePciSharedGpuPassthroughInfo `xml:"sharedGpuPassthroughTypes,omitempty" json:"sharedGpuPassthroughTypes,omitempty"`
	// Maximum available persistent memory reservation on a compute resource
	// in MB.
	AvailablePersistentMemoryReservationMB int64 `xml:"availablePersistentMemoryReservationMB,omitempty" json:"availablePersistentMemoryReservationMB,omitempty"`
	// List of Dynamic DirectPath PCI devices.
	DynamicPassthrough []VirtualMachineDynamicPassthroughInfo `xml:"dynamicPassthrough,omitempty" json:"dynamicPassthrough,omitempty"`
	// Intel SGX information.
	SgxTargetInfo *VirtualMachineSgxTargetInfo `xml:"sgxTargetInfo,omitempty" json:"sgxTargetInfo,omitempty"`
	// List of host clock resources available to support virtual precision
	// clock device.
	//
	// Used for
	// `VirtualPrecisionClockSystemClockBackingInfo`
	PrecisionClockInfo []VirtualMachinePrecisionClockInfo `xml:"precisionClockInfo,omitempty" json:"precisionClockInfo,omitempty"`
	// Indicates whether the compute resource is capable of running AMD Secure
	// Encrypted Virtualization (SEV) enabled virtual machines.
	//
	// The compute
	// resource supports SEV when this value is set to true.
	SevSupported *bool `xml:"sevSupported" json:"sevSupported,omitempty" vim:"7.0.1.0"`
	// List of vGPU device capabilities.
	VgpuDeviceInfo []VirtualMachineVgpuDeviceInfo `xml:"vgpuDeviceInfo,omitempty" json:"vgpuDeviceInfo,omitempty" vim:"7.0.3.0"`
	// List of vGPU profile attributes.
	VgpuProfileInfo []VirtualMachineVgpuProfileInfo `xml:"vgpuProfileInfo,omitempty" json:"vgpuProfileInfo,omitempty" vim:"7.0.3.0"`
	// List of PCI Vendor Device Groups.
	VendorDeviceGroupInfo []VirtualMachineVendorDeviceGroupInfo `xml:"vendorDeviceGroupInfo,omitempty" json:"vendorDeviceGroupInfo,omitempty" vim:"8.0.0.1"`
	// Max SMT (Simultaneous multithreading) threads.
	MaxSimultaneousThreads int32 `xml:"maxSimultaneousThreads,omitempty" json:"maxSimultaneousThreads,omitempty" vim:"8.0.0.1"`
	// List of Device Virtualization Extensions (DVX) classes.
	DvxClassInfo []VirtualMachineDvxClassInfo `xml:"dvxClassInfo,omitempty" json:"dvxClassInfo,omitempty" vim:"8.0.0.1"`
}

func init() {
	t["ConfigTarget"] = reflect.TypeOf((*ConfigTarget)(nil)).Elem()
}

type ConfigureCryptoKey ConfigureCryptoKeyRequestType

func init() {
	t["ConfigureCryptoKey"] = reflect.TypeOf((*ConfigureCryptoKey)(nil)).Elem()
}

// The parameters of `HostSystem.ConfigureCryptoKey`.
type ConfigureCryptoKeyRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key to be used for coredump encryption. If unset, uses
	// existing host or cluster key or new key is generated from
	// the default KMIP server.
	KeyId *CryptoKeyId `xml:"keyId,omitempty" json:"keyId,omitempty"`
}

func init() {
	t["ConfigureCryptoKeyRequestType"] = reflect.TypeOf((*ConfigureCryptoKeyRequestType)(nil)).Elem()
}

type ConfigureCryptoKeyResponse struct {
}

// The parameters of `StorageResourceManager.ConfigureDatastoreIORM_Task`.
type ConfigureDatastoreIORMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datastore to be configured.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// The configuration spec.
	Spec StorageIORMConfigSpec `xml:"spec" json:"spec"`
}

func init() {
	t["ConfigureDatastoreIORMRequestType"] = reflect.TypeOf((*ConfigureDatastoreIORMRequestType)(nil)).Elem()
}

type ConfigureDatastoreIORM_Task ConfigureDatastoreIORMRequestType

func init() {
	t["ConfigureDatastoreIORM_Task"] = reflect.TypeOf((*ConfigureDatastoreIORM_Task)(nil)).Elem()
}

type ConfigureDatastoreIORM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ConfigureDatastorePrincipal ConfigureDatastorePrincipalRequestType

func init() {
	t["ConfigureDatastorePrincipal"] = reflect.TypeOf((*ConfigureDatastorePrincipal)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.ConfigureDatastorePrincipal`.
type ConfigureDatastorePrincipalRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Datastore principal user name.
	UserName string `xml:"userName" json:"userName"`
	// Optional password for systems that require password for
	// user impersonation.
	Password string `xml:"password,omitempty" json:"password,omitempty"`
}

func init() {
	t["ConfigureDatastorePrincipalRequestType"] = reflect.TypeOf((*ConfigureDatastorePrincipalRequestType)(nil)).Elem()
}

type ConfigureDatastorePrincipalResponse struct {
}

// The parameters of `ClusterEVCManager.ConfigureEvcMode_Task`.
type ConfigureEvcModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A key referencing the desired EVC mode.
	EvcModeKey string `xml:"evcModeKey" json:"evcModeKey"`
	// A key referencing the desired EVC Graphics
	// mode `Capability.supportedEVCGraphicsMode`.
	EvcGraphicsModeKey string `xml:"evcGraphicsModeKey,omitempty" json:"evcGraphicsModeKey,omitempty" vim:"7.0.1.0"`
}

func init() {
	t["ConfigureEvcModeRequestType"] = reflect.TypeOf((*ConfigureEvcModeRequestType)(nil)).Elem()
}

type ConfigureEvcMode_Task ConfigureEvcModeRequestType

func init() {
	t["ConfigureEvcMode_Task"] = reflect.TypeOf((*ConfigureEvcMode_Task)(nil)).Elem()
}

type ConfigureEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `ClusterComputeResource.ConfigureHCI_Task`.
type ConfigureHCIRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification to configure the cluster,
	// see `ClusterComputeResourceHCIConfigSpec`
	// for details. The `DistributedVirtualSwitch` and
	// `DistributedVirtualPortgroup` objects contained
	// within the specification must be in the same datacenter as the
	// cluster. Specify `ClusterComputeResourceHCIConfigSpec.vSanConfigSpec` only when
	// vSan is enabled on the cluster.
	ClusterSpec ClusterComputeResourceHCIConfigSpec `xml:"clusterSpec" json:"clusterSpec"`
	// Inputs to configure each host in the cluster,
	// see `ClusterComputeResourceHostConfigurationInput`
	// for details. Hosts in this list should be part of the cluster and
	// should be in maintenance mode for them to be configured per
	// specification. If this parameter is not specified, the API
	// operates on all the hosts in the cluster. Hosts which were not
	// configured due to not being in maintenance
	// mode will be returned in `ClusterComputeResourceClusterConfigResult.failedHosts`.
	HostInputs []ClusterComputeResourceHostConfigurationInput `xml:"hostInputs,omitempty" json:"hostInputs,omitempty"`
}

func init() {
	t["ConfigureHCIRequestType"] = reflect.TypeOf((*ConfigureHCIRequestType)(nil)).Elem()
}

type ConfigureHCI_Task ConfigureHCIRequestType

func init() {
	t["ConfigureHCI_Task"] = reflect.TypeOf((*ConfigureHCI_Task)(nil)).Elem()
}

type ConfigureHCI_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostCacheConfigurationManager.ConfigureHostCache_Task`.
type ConfigureHostCacheRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification for solid state drive cache configuration.
	Spec HostCacheConfigurationSpec `xml:"spec" json:"spec"`
}

func init() {
	t["ConfigureHostCacheRequestType"] = reflect.TypeOf((*ConfigureHostCacheRequestType)(nil)).Elem()
}

type ConfigureHostCache_Task ConfigureHostCacheRequestType

func init() {
	t["ConfigureHostCache_Task"] = reflect.TypeOf((*ConfigureHostCache_Task)(nil)).Elem()
}

type ConfigureHostCache_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ConfigureLicenseSource ConfigureLicenseSourceRequestType

func init() {
	t["ConfigureLicenseSource"] = reflect.TypeOf((*ConfigureLicenseSource)(nil)).Elem()
}

// The parameters of `LicenseManager.ConfigureLicenseSource`.
type ConfigureLicenseSourceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Host for which the license manager should be reconfigured.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// ServedSource or LocalSource.
	LicenseSource BaseLicenseSource `xml:"licenseSource,typeattr" json:"licenseSource"`
}

func init() {
	t["ConfigureLicenseSourceRequestType"] = reflect.TypeOf((*ConfigureLicenseSourceRequestType)(nil)).Elem()
}

type ConfigureLicenseSourceResponse struct {
}

type ConfigurePowerPolicy ConfigurePowerPolicyRequestType

func init() {
	t["ConfigurePowerPolicy"] = reflect.TypeOf((*ConfigurePowerPolicy)(nil)).Elem()
}

// The parameters of `HostPowerSystem.ConfigurePowerPolicy`.
type ConfigurePowerPolicyRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A key from one of the policies in
	// `PowerSystemCapability.availablePolicy`.
	Key int32 `xml:"key" json:"key"`
}

func init() {
	t["ConfigurePowerPolicyRequestType"] = reflect.TypeOf((*ConfigurePowerPolicyRequestType)(nil)).Elem()
}

type ConfigurePowerPolicyResponse struct {
}

// The parameters of `StorageResourceManager.ConfigureStorageDrsForPod_Task`.
type ConfigureStorageDrsForPodRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The storage pod.
	//
	// Required privileges: StoragePod.Config
	//
	// Refers instance of `StoragePod`.
	Pod ManagedObjectReference `xml:"pod" json:"pod"`
	// A set of storage Drs configuration changes to apply to the storage pod.
	// The specification can be a complete set of changes or a partial
	// set of changes, applied incrementally.
	Spec StorageDrsConfigSpec `xml:"spec" json:"spec"`
	// Flag to specify whether the specification ("spec") should
	// be applied incrementally. If "modify" is false and the
	// operation succeeds, then the configuration of the storage pod
	// matches the specification exactly; in this case any unset
	// portions of the specification will result in unset or
	// default portions of the configuration.
	Modify bool `xml:"modify" json:"modify"`
}

func init() {
	t["ConfigureStorageDrsForPodRequestType"] = reflect.TypeOf((*ConfigureStorageDrsForPodRequestType)(nil)).Elem()
}

type ConfigureStorageDrsForPod_Task ConfigureStorageDrsForPodRequestType

func init() {
	t["ConfigureStorageDrsForPod_Task"] = reflect.TypeOf((*ConfigureStorageDrsForPod_Task)(nil)).Elem()
}

type ConfigureStorageDrsForPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostVFlashManager.ConfigureVFlashResourceEx_Task`.
type ConfigureVFlashResourceExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// An array of device path names that identify disks.
	// See `ScsiDisk`.
	DevicePath []string `xml:"devicePath,omitempty" json:"devicePath,omitempty"`
}

func init() {
	t["ConfigureVFlashResourceExRequestType"] = reflect.TypeOf((*ConfigureVFlashResourceExRequestType)(nil)).Elem()
}

type ConfigureVFlashResourceEx_Task ConfigureVFlashResourceExRequestType

func init() {
	t["ConfigureVFlashResourceEx_Task"] = reflect.TypeOf((*ConfigureVFlashResourceEx_Task)(nil)).Elem()
}

type ConfigureVFlashResourceEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Thrown if the configurations of the objects are in conflict.
type ConflictingConfiguration struct {
	DvsFault

	// The configurations that are in conflict.
	ConfigInConflict []ConflictingConfigurationConfig `xml:"configInConflict" json:"configInConflict"`
}

func init() {
	t["ConflictingConfiguration"] = reflect.TypeOf((*ConflictingConfiguration)(nil)).Elem()
}

// This class defines the configuration that is in conflict.
type ConflictingConfigurationConfig struct {
	DynamicData

	// The entity on which the configuration is in conflict.
	//
	// Refers instance of `ManagedEntity`.
	Entity *ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
	// The property paths that are in conflict.
	PropertyPath string `xml:"propertyPath" json:"propertyPath"`
}

func init() {
	t["ConflictingConfigurationConfig"] = reflect.TypeOf((*ConflictingConfigurationConfig)(nil)).Elem()
}

type ConflictingConfigurationFault ConflictingConfiguration

func init() {
	t["ConflictingConfigurationFault"] = reflect.TypeOf((*ConflictingConfigurationFault)(nil)).Elem()
}

// ConflictingDatastoreFound is thrown when the conflicting datastores
// with the same url but backed by different disks are found in the host
// and the target datacenter.
type ConflictingDatastoreFound struct {
	RuntimeFault

	// The name of the datastore.
	Name string `xml:"name" json:"name"`
	// The unique locator for the datastore.
	Url string `xml:"url" json:"url"`
}

func init() {
	t["ConflictingDatastoreFound"] = reflect.TypeOf((*ConflictingDatastoreFound)(nil)).Elem()
}

type ConflictingDatastoreFoundFault ConflictingDatastoreFound

func init() {
	t["ConflictingDatastoreFoundFault"] = reflect.TypeOf((*ConflictingDatastoreFoundFault)(nil)).Elem()
}

type ConnectNvmeController ConnectNvmeControllerRequestType

func init() {
	t["ConnectNvmeController"] = reflect.TypeOf((*ConnectNvmeController)(nil)).Elem()
}

// The parameters of `HostStorageSystem.ConnectNvmeControllerEx_Task`.
type ConnectNvmeControllerExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A list of data objects, each specifying the parameters
	// necessary to connect to an NVMe controller.
	ConnectSpec []HostNvmeConnectSpec `xml:"connectSpec,omitempty" json:"connectSpec,omitempty"`
}

func init() {
	t["ConnectNvmeControllerExRequestType"] = reflect.TypeOf((*ConnectNvmeControllerExRequestType)(nil)).Elem()
	minAPIVersionForType["ConnectNvmeControllerExRequestType"] = "7.0.3.0"
}

type ConnectNvmeControllerEx_Task ConnectNvmeControllerExRequestType

func init() {
	t["ConnectNvmeControllerEx_Task"] = reflect.TypeOf((*ConnectNvmeControllerEx_Task)(nil)).Elem()
}

type ConnectNvmeControllerEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostStorageSystem.ConnectNvmeController`.
type ConnectNvmeControllerRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A data object that specifies the parameters
	// necessary to connect to the controller.
	ConnectSpec HostNvmeConnectSpec `xml:"connectSpec" json:"connectSpec"`
}

func init() {
	t["ConnectNvmeControllerRequestType"] = reflect.TypeOf((*ConnectNvmeControllerRequestType)(nil)).Elem()
}

type ConnectNvmeControllerResponse struct {
}

type ConnectedIso struct {
	OvfExport

	// The CD-ROM drive that caused the event.
	Cdrom VirtualCdrom `xml:"cdrom" json:"cdrom"`
	// The filename of the ISO
	Filename string `xml:"filename" json:"filename"`
}

func init() {
	t["ConnectedIso"] = reflect.TypeOf((*ConnectedIso)(nil)).Elem()
}

type ConnectedIsoFault ConnectedIso

func init() {
	t["ConnectedIsoFault"] = reflect.TypeOf((*ConnectedIsoFault)(nil)).Elem()
}

type ConsolidateVMDisksRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["ConsolidateVMDisksRequestType"] = reflect.TypeOf((*ConsolidateVMDisksRequestType)(nil)).Elem()
}

type ConsolidateVMDisks_Task ConsolidateVMDisksRequestType

func init() {
	t["ConsolidateVMDisks_Task"] = reflect.TypeOf((*ConsolidateVMDisks_Task)(nil)).Elem()
}

type ConsolidateVMDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type ContinueRetrievePropertiesEx ContinueRetrievePropertiesExRequestType

func init() {
	t["ContinueRetrievePropertiesEx"] = reflect.TypeOf((*ContinueRetrievePropertiesEx)(nil)).Elem()
}

// The parameters of `PropertyCollector.ContinueRetrievePropertiesEx`.
type ContinueRetrievePropertiesExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// the token returned in the previous `RetrieveResult` returned on the same session by the
	// same `PropertyCollector`.
	Token string `xml:"token" json:"token"`
}

func init() {
	t["ContinueRetrievePropertiesExRequestType"] = reflect.TypeOf((*ContinueRetrievePropertiesExRequestType)(nil)).Elem()
}

type ContinueRetrievePropertiesExResponse struct {
	Returnval RetrieveResult `xml:"returnval" json:"returnval"`
}

type ConvertNamespacePathToUuidPath ConvertNamespacePathToUuidPathRequestType

func init() {
	t["ConvertNamespacePathToUuidPath"] = reflect.TypeOf((*ConvertNamespacePathToUuidPath)(nil)).Elem()
}

// The parameters of `DatastoreNamespaceManager.ConvertNamespacePathToUuidPath`.
type ConvertNamespacePathToUuidPathRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter of the namespace path. Needs to be set
	// when making the call to VC; ignored when the call is
	// made to ESX.
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
	// Namesapce URL of the form
	// > \[ds://\]/vmfs/volumes/\[_datastore-uuid_\]/\[_directory-name_\]/...
	// >
	NamespaceUrl string `xml:"namespaceUrl" json:"namespaceUrl"`
}

func init() {
	t["ConvertNamespacePathToUuidPathRequestType"] = reflect.TypeOf((*ConvertNamespacePathToUuidPathRequestType)(nil)).Elem()
}

type ConvertNamespacePathToUuidPathResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// The parameters of `FileManager.CopyDatastoreFile_Task`.
type CopyDatastoreFileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the source, either a URL or a
	// datastore path referring to the file or folder to be copied.
	SourceName string `xml:"sourceName" json:"sourceName"`
	// If <code>sourceName</code> is a datastore path, the
	// datacenter for that datastore path.
	// Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>sourceName</code> must be a URL.
	//
	// Required privileges: System.View
	//
	// Refers instance of `Datacenter`.
	SourceDatacenter *ManagedObjectReference `xml:"sourceDatacenter,omitempty" json:"sourceDatacenter,omitempty"`
	// The name of the destination, either a
	// URL or a datastore path referring to the destination file
	// or folder.
	DestinationName string `xml:"destinationName" json:"destinationName"`
	// If <code>destinationName</code> is a datastore
	// path, the datacenter for that datastore path.
	// Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter, it is assumed that
	// the destination path belongs to the source datacenter.
	//
	// Required privileges: System.View
	//
	// Refers instance of `Datacenter`.
	DestinationDatacenter *ManagedObjectReference `xml:"destinationDatacenter,omitempty" json:"destinationDatacenter,omitempty"`
	// If true, overwrite any identically named file
	// at the destination. If not specified, it is assumed to be false.
	Force *bool `xml:"force" json:"force,omitempty"`
}

func init() {
	t["CopyDatastoreFileRequestType"] = reflect.TypeOf((*CopyDatastoreFileRequestType)(nil)).Elem()
}

type CopyDatastoreFile_Task CopyDatastoreFileRequestType

func init() {
	t["CopyDatastoreFile_Task"] = reflect.TypeOf((*CopyDatastoreFile_Task)(nil)).Elem()
}

type CopyDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualDiskManager.CopyVirtualDisk_Task`.
type CopyVirtualDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the source, either a datastore path
	// or a URL referring to the virtual disk to be copied.
	SourceName string `xml:"sourceName" json:"sourceName"`
	// If <code>sourceName</code> is a datastore path, the
	// datacenter for that datastore path.
	// Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>sourceName</code> must be a URL.
	//
	// Refers instance of `Datacenter`.
	SourceDatacenter *ManagedObjectReference `xml:"sourceDatacenter,omitempty" json:"sourceDatacenter,omitempty"`
	// The name of the destination, either a datastore path
	// or a URL referring to the virtual disk to be created.
	DestName string `xml:"destName" json:"destName"`
	// If <code>destName</code> is a datastore
	// path, the datacenter for that datastore path.
	// Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter, it is assumed that
	// the destination path belongs to the source datacenter.
	//
	// Refers instance of `Datacenter`.
	DestDatacenter *ManagedObjectReference `xml:"destDatacenter,omitempty" json:"destDatacenter,omitempty"`
	// The specification of the virtual disk to be created.
	// If not specified, a preallocated format and busLogic adapter type is assumed.
	DestSpec BaseVirtualDiskSpec `xml:"destSpec,omitempty,typeattr" json:"destSpec,omitempty"`
	// The force flag is currently ignored. The FileAlreadyExists fault is thrown if
	// the destination file already exists.
	Force *bool `xml:"force" json:"force,omitempty"`
}

func init() {
	t["CopyVirtualDiskRequestType"] = reflect.TypeOf((*CopyVirtualDiskRequestType)(nil)).Elem()
}

type CopyVirtualDisk_Task CopyVirtualDiskRequestType

func init() {
	t["CopyVirtualDisk_Task"] = reflect.TypeOf((*CopyVirtualDisk_Task)(nil)).Elem()
}

type CopyVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Deprecated as of VI API 2.5, use `CpuIncompatible` and its other subclasses,
// not this one.
//
// Compatibility between the virtual machine's host and its CPU
// feature requirements cannot be determined, because not enough information
// is available about the CPU features of the host.
type CpuCompatibilityUnknown struct {
	CpuIncompatible
}

func init() {
	t["CpuCompatibilityUnknown"] = reflect.TypeOf((*CpuCompatibilityUnknown)(nil)).Elem()
}

type CpuCompatibilityUnknownFault CpuCompatibilityUnknown

func init() {
	t["CpuCompatibilityUnknownFault"] = reflect.TypeOf((*CpuCompatibilityUnknownFault)(nil)).Elem()
}

// Thrown when virtual CPUs cannot be hot-added or hot-removed from
// the virtual machine.
type CpuHotPlugNotSupported struct {
	VmConfigFault
}

func init() {
	t["CpuHotPlugNotSupported"] = reflect.TypeOf((*CpuHotPlugNotSupported)(nil)).Elem()
}

type CpuHotPlugNotSupportedFault CpuHotPlugNotSupported

func init() {
	t["CpuHotPlugNotSupportedFault"] = reflect.TypeOf((*CpuHotPlugNotSupportedFault)(nil)).Elem()
}

// Deprecated as of vSphere API 6.5 use
// `FeatureRequirementsNotMet`.
//
// The host is not compatible with the CPU feature requirements of the
// virtual machine, for a particular CPUID register.
//
// A subclass of this fault
// may be used to express the incompatibilities in a more easily
// understandable format.
type CpuIncompatible struct {
	VirtualHardwareCompatibilityIssue

	// The CpuIdInfo level where a problem was detected.
	//
	// Other levels may
	// also have problems.
	Level int32 `xml:"level" json:"level"`
	// The CpuIdInfo register where a problem was detected.
	//
	// Other registers
	// may also have problems. Possible register names are eax, ebx, ecx, or edx.
	RegisterName string `xml:"registerName" json:"registerName"`
	// The contents of the register on the target host, in CpuIdInfo register
	// format.
	//
	// The '-' character indicates an unknown value.
	RegisterBits string `xml:"registerBits,omitempty" json:"registerBits,omitempty"`
	// The desired values for the register's bits.
	//
	// The 'x' character indicates
	// don't-care.
	DesiredBits string `xml:"desiredBits,omitempty" json:"desiredBits,omitempty"`
	// The host that is not compatible with the requirements.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["CpuIncompatible"] = reflect.TypeOf((*CpuIncompatible)(nil)).Elem()
}

// Deprecated as of vSphere API 6.5 use
// `FeatureRequirementsNotMet`.
//
// Convenience subclass for calling out some named features among the
// incompatibilities found in CPUID level 1 register ecx.
type CpuIncompatible1ECX struct {
	CpuIncompatible

	// Flag to indicate bit 0 is incompatible.
	Sse3 bool `xml:"sse3" json:"sse3"`
	// Flag to indicate bit 1 is incompatible.
	Pclmulqdq *bool `xml:"pclmulqdq" json:"pclmulqdq,omitempty"`
	// Flag to indicate bit 9 is incompatible.
	Ssse3 bool `xml:"ssse3" json:"ssse3"`
	// Flag to indicate bit 19 is incompatible.
	Sse41 bool `xml:"sse41" json:"sse41"`
	// Flag to indicate bit 20 is incompatible.
	Sse42 bool `xml:"sse42" json:"sse42"`
	// Flag to indicate bit 25 is incompatible.
	Aes *bool `xml:"aes" json:"aes,omitempty"`
	// Flag to indicate that bits other than 0/1/9/19/20/25 are incompatible.
	//
	// I.e. the detected incompatibilities cannot be completely described by
	// the sse3, pclmulqdq, ssse3, sse41, sse42, and/or aes flags.
	Other bool `xml:"other" json:"other"`
	// Flag to indicate that the sse3, pclmulqdq, ssse3, sse41, sse42, and aes
	// flags are all false, and the "other" flag is true.
	//
	// Purely a convenience
	// property for the client processing this fault.
	OtherOnly bool `xml:"otherOnly" json:"otherOnly"`
}

func init() {
	t["CpuIncompatible1ECX"] = reflect.TypeOf((*CpuIncompatible1ECX)(nil)).Elem()
}

type CpuIncompatible1ECXFault CpuIncompatible1ECX

func init() {
	t["CpuIncompatible1ECXFault"] = reflect.TypeOf((*CpuIncompatible1ECXFault)(nil)).Elem()
}

// Deprecated as of vSphere API 6.5 use
// `FeatureRequirementsNotMet`.
//
// Convenience subclass for calling out some named features among the
// incompatibilities found in CPUID level 0x80000001 register edx.
type CpuIncompatible81EDX struct {
	CpuIncompatible

	// Flag to indicate bit 20 is incompatible.
	Nx bool `xml:"nx" json:"nx"`
	// Flag to indicate bit 25 is incompatible.
	Ffxsr bool `xml:"ffxsr" json:"ffxsr"`
	// Flag to indicate bit 27 is incompatible.
	Rdtscp bool `xml:"rdtscp" json:"rdtscp"`
	// Flag to indicate bit 29 is incompatible.
	Lm bool `xml:"lm" json:"lm"`
	// Flag to indicate that bits other than 20/25/27/29 are incompatible.
	//
	// I.e. the detected incompatibilities cannot be completely described by
	// the nx, ffxsr, rdtscp, and/or lm flags.
	Other bool `xml:"other" json:"other"`
	// Flag to indicate that the nx, ffxsr, rdtscp, and lm flags are all false,
	// and the "other" flag is true.
	//
	// Purely a convenience property for the
	// client processing this fault.
	OtherOnly bool `xml:"otherOnly" json:"otherOnly"`
}

func init() {
	t["CpuIncompatible81EDX"] = reflect.TypeOf((*CpuIncompatible81EDX)(nil)).Elem()
}

type CpuIncompatible81EDXFault CpuIncompatible81EDX

func init() {
	t["CpuIncompatible81EDXFault"] = reflect.TypeOf((*CpuIncompatible81EDXFault)(nil)).Elem()
}

type CpuIncompatibleFault BaseCpuIncompatible

func init() {
	t["CpuIncompatibleFault"] = reflect.TypeOf((*CpuIncompatibleFault)(nil)).Elem()
}

type CreateAlarm CreateAlarmRequestType

func init() {
	t["CreateAlarm"] = reflect.TypeOf((*CreateAlarm)(nil)).Elem()
}

// The parameters of `AlarmManager.CreateAlarm`.
type CreateAlarmRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The entity with which the alarm is associated.
	//
	// Required privileges: Alarm.Create
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
	// The specification for the new alarm.
	Spec BaseAlarmSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["CreateAlarmRequestType"] = reflect.TypeOf((*CreateAlarmRequestType)(nil)).Elem()
}

type CreateAlarmResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `ResourcePool.CreateChildVM_Task`.
type CreateChildVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The configuration of the virtual machine hardware.
	Config VirtualMachineConfigSpec `xml:"config" json:"config"`
	// The target host on which the virtual machine will run. This must
	// specify a host that is a member of the ComputeResource indirectly
	// specified by the pool. For a stand-alone host or a cluster with DRS,
	// host can be omitted, and the system selects a default.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["CreateChildVMRequestType"] = reflect.TypeOf((*CreateChildVMRequestType)(nil)).Elem()
}

type CreateChildVM_Task CreateChildVMRequestType

func init() {
	t["CreateChildVM_Task"] = reflect.TypeOf((*CreateChildVM_Task)(nil)).Elem()
}

type CreateChildVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateCluster CreateClusterRequestType

func init() {
	t["CreateCluster"] = reflect.TypeOf((*CreateCluster)(nil)).Elem()
}

type CreateClusterEx CreateClusterExRequestType

func init() {
	t["CreateClusterEx"] = reflect.TypeOf((*CreateClusterEx)(nil)).Elem()
}

// The parameters of `Folder.CreateClusterEx`.
type CreateClusterExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Name for the new cluster.
	Name string `xml:"name" json:"name"`
	// Specification for the cluster.
	Spec ClusterConfigSpecEx `xml:"spec" json:"spec"`
}

func init() {
	t["CreateClusterExRequestType"] = reflect.TypeOf((*CreateClusterExRequestType)(nil)).Elem()
}

type CreateClusterExResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `Folder.CreateCluster`.
type CreateClusterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Name for the new cluster.
	Name string `xml:"name" json:"name"`
	// Specification for the cluster.
	Spec ClusterConfigSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateClusterRequestType"] = reflect.TypeOf((*CreateClusterRequestType)(nil)).Elem()
}

type CreateClusterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateCollectorForEvents CreateCollectorForEventsRequestType

func init() {
	t["CreateCollectorForEvents"] = reflect.TypeOf((*CreateCollectorForEvents)(nil)).Elem()
}

// The parameters of `EventManager.CreateCollectorForEvents`.
type CreateCollectorForEventsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The event query filter.
	Filter EventFilterSpec `xml:"filter" json:"filter"`
}

func init() {
	t["CreateCollectorForEventsRequestType"] = reflect.TypeOf((*CreateCollectorForEventsRequestType)(nil)).Elem()
}

type CreateCollectorForEventsResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateCollectorForTasks CreateCollectorForTasksRequestType

func init() {
	t["CreateCollectorForTasks"] = reflect.TypeOf((*CreateCollectorForTasks)(nil)).Elem()
}

// The parameters of `TaskManager.CreateCollectorForTasks`.
type CreateCollectorForTasksRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for the task query filter.
	Filter TaskFilterSpec `xml:"filter" json:"filter"`
}

func init() {
	t["CreateCollectorForTasksRequestType"] = reflect.TypeOf((*CreateCollectorForTasksRequestType)(nil)).Elem()
}

type CreateCollectorForTasksResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateCollectorWithInfoFilterForTasks CreateCollectorWithInfoFilterForTasksRequestType

func init() {
	t["CreateCollectorWithInfoFilterForTasks"] = reflect.TypeOf((*CreateCollectorWithInfoFilterForTasks)(nil)).Elem()
}

// The parameters of `TaskManager.CreateCollectorWithInfoFilterForTasks`.
type CreateCollectorWithInfoFilterForTasksRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for the task query filter.
	Filter TaskFilterSpec `xml:"filter" json:"filter"`
	// The specification for the task info filter.
	InfoFilter *TaskInfoFilterSpec `xml:"infoFilter,omitempty" json:"infoFilter,omitempty"`
}

func init() {
	t["CreateCollectorWithInfoFilterForTasksRequestType"] = reflect.TypeOf((*CreateCollectorWithInfoFilterForTasksRequestType)(nil)).Elem()
	minAPIVersionForType["CreateCollectorWithInfoFilterForTasksRequestType"] = "8.0.3.0"
}

type CreateCollectorWithInfoFilterForTasksResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateContainerView CreateContainerViewRequestType

func init() {
	t["CreateContainerView"] = reflect.TypeOf((*CreateContainerView)(nil)).Elem()
}

// The parameters of `ViewManager.CreateContainerView`.
type CreateContainerViewRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A reference to an instance of a `Folder`,
	// `Datacenter`, `ComputeResource`,
	// `ResourcePool`, or `HostSystem` object.
	//
	// Required privileges: System.View
	//
	// Refers instance of `ManagedEntity`.
	Container ManagedObjectReference `xml:"container" json:"container"`
	// An optional list of managed entity types. The server
	// associates only objects of the specified type(s) with the view.
	// If you specify an empty array, the server uses all types.
	Type []string `xml:"type,omitempty" json:"type,omitempty"`
	// Whether to include only the immediate children of the
	// container instance, or to include additional objects by
	// following paths beyond the immediate children.
	//
	// When recursive is false, the list of objects contains
	// only immediate children.
	// When recursive is true, the server populates the list
	// by following references beyond the immediate children
	// (using a child's references, and then references in the
	// resulting objects, and so on).
	//
	// Depending on the container type, the server will use the following
	// properties of the container instance to obtain objects for the
	// view's object list:
	//   - `Folder` object - `Folder.childEntity`
	//     property.
	//     If recursive is false, the container list includes the reference
	//     to the child entity in the folder instance.
	//     If recursive is true, the server will follow the child
	//     folder path(s) to collect additional childEntity references.
	//   - `ResourcePool` object - `ResourcePool.vm`
	//     and `ResourcePool.resourcePool` properties.
	//     If recursive is false, the object list will contain references
	//     to the virtual machines associated with this resource pool,
	//     and references to virtual machines associated with the
	//     immediate child resource pools. If recursive is true,
	//     the server will follow all child resource pool paths
	//     extending from the immediate children (and their children,
	//     and so on) to collect additional references to virtual machines.
	//   - `ComputeResource` object - `ComputeResource.host`
	//     and `ComputeResource.resourcePool` properties.
	//     If recursive is false, the object list will contain references
	//     to the host systems associated with this compute resource,
	//     references to virtual machines associated with the
	//     host systems, and references to virtual machines associated
	//     with the immediate child resource pools.
	//     If recursive is true, the server will follow the child
	//     resource pool paths (and their child resource pool paths,
	//     and so on) to collect additional references to virtual machines.
	//   - `Datacenter` object - `Datacenter.vmFolder`,
	//     `Datacenter.hostFolder`,
	//     `Datacenter.datastoreFolder`, and
	//     `Datacenter.networkFolder` properties.
	//     If recursive is set to false, the server uses the
	//     immediate child folders for the virtual machines,
	//     hosts, datastores, and networks associated with this
	//     datacenter. If recursive is set to true, the server
	//     will follow the folder paths to collect references
	//     to additional objects.
	//   - `HostSystem` object - `HostSystem.vm`
	//     property.
	//     The view object list contains references to the virtual machines
	//     associated with this host system. The value of recursive does not
	//     affect this behavior.
	Recursive bool `xml:"recursive" json:"recursive"`
}

func init() {
	t["CreateContainerViewRequestType"] = reflect.TypeOf((*CreateContainerViewRequestType)(nil)).Elem()
}

type CreateContainerViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateCustomizationSpec CreateCustomizationSpecRequestType

func init() {
	t["CreateCustomizationSpec"] = reflect.TypeOf((*CreateCustomizationSpec)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.CreateCustomizationSpec`.
type CreateCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Item CustomizationSpecItem  `xml:"item" json:"item"`
}

func init() {
	t["CreateCustomizationSpecRequestType"] = reflect.TypeOf((*CreateCustomizationSpecRequestType)(nil)).Elem()
}

type CreateCustomizationSpecResponse struct {
}

// The parameters of `DistributedVirtualSwitch.CreateDVPortgroup_Task`.
type CreateDVPortgroupRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for the portgroup.
	Spec DVPortgroupConfigSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateDVPortgroupRequestType"] = reflect.TypeOf((*CreateDVPortgroupRequestType)(nil)).Elem()
}

type CreateDVPortgroup_Task CreateDVPortgroupRequestType

func init() {
	t["CreateDVPortgroup_Task"] = reflect.TypeOf((*CreateDVPortgroup_Task)(nil)).Elem()
}

type CreateDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `Folder.CreateDVS_Task`.
type CreateDVSRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The `DVSCreateSpec`
	// to create the distributed virtual switch.
	Spec DVSCreateSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateDVSRequestType"] = reflect.TypeOf((*CreateDVSRequestType)(nil)).Elem()
}

type CreateDVS_Task CreateDVSRequestType

func init() {
	t["CreateDVS_Task"] = reflect.TypeOf((*CreateDVS_Task)(nil)).Elem()
}

type CreateDVS_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateDatacenter CreateDatacenterRequestType

func init() {
	t["CreateDatacenter"] = reflect.TypeOf((*CreateDatacenter)(nil)).Elem()
}

// The parameters of `Folder.CreateDatacenter`.
type CreateDatacenterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Name for the new datacenter. An entity name
	// must be a non-empty string of less than 80 characters.
	// The slash (/), backslash (\\) and percent (%) will be escaped
	// using the URL syntax. For example, %2F.
	Name string `xml:"name" json:"name"`
}

func init() {
	t["CreateDatacenterRequestType"] = reflect.TypeOf((*CreateDatacenterRequestType)(nil)).Elem()
}

type CreateDatacenterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateDefaultProfile CreateDefaultProfileRequestType

func init() {
	t["CreateDefaultProfile"] = reflect.TypeOf((*CreateDefaultProfile)(nil)).Elem()
}

// The parameters of `HostProfileManager.CreateDefaultProfile`.
type CreateDefaultProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Type of profile to create. The profile types
	// are system-defined
	// (`ApplyProfile*.*ApplyProfile.profileTypeName`).
	ProfileType string `xml:"profileType" json:"profileType"`
	// If specified, the method returns a profile object
	// containing data for the named profile. The type name does not have
	// to be system-defined. A user-defined profile can include various
	// dynamically-defined profiles.
	ProfileTypeName string `xml:"profileTypeName,omitempty" json:"profileTypeName,omitempty"`
	// Base profile used during the operation.
	//
	// Refers instance of `Profile`.
	Profile *ManagedObjectReference `xml:"profile,omitempty" json:"profile,omitempty"`
}

func init() {
	t["CreateDefaultProfileRequestType"] = reflect.TypeOf((*CreateDefaultProfileRequestType)(nil)).Elem()
}

type CreateDefaultProfileResponse struct {
	Returnval BaseApplyProfile `xml:"returnval,typeattr" json:"returnval"`
}

type CreateDescriptor CreateDescriptorRequestType

func init() {
	t["CreateDescriptor"] = reflect.TypeOf((*CreateDescriptor)(nil)).Elem()
}

// The parameters of `OvfManager.CreateDescriptor`.
type CreateDescriptorRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The entity to export. Supported types are `VirtualMachine`
	// and `VirtualApp`.
	//
	// Required privileges: VApp.Export
	//
	// Refers instance of `ManagedEntity`.
	Obj ManagedObjectReference `xml:"obj" json:"obj"`
	// Parameters to the method, bundled in an instance of
	// CreateDescriptorParams.
	Cdp OvfCreateDescriptorParams `xml:"cdp" json:"cdp"`
}

func init() {
	t["CreateDescriptorRequestType"] = reflect.TypeOf((*CreateDescriptorRequestType)(nil)).Elem()
}

type CreateDescriptorResponse struct {
	Returnval OvfCreateDescriptorResult `xml:"returnval" json:"returnval"`
}

type CreateDiagnosticPartition CreateDiagnosticPartitionRequestType

func init() {
	t["CreateDiagnosticPartition"] = reflect.TypeOf((*CreateDiagnosticPartition)(nil)).Elem()
}

// The parameters of `HostDiagnosticSystem.CreateDiagnosticPartition`.
type CreateDiagnosticPartitionRequestType struct {
	This ManagedObjectReference            `xml:"_this" json:"-"`
	Spec HostDiagnosticPartitionCreateSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateDiagnosticPartitionRequestType"] = reflect.TypeOf((*CreateDiagnosticPartitionRequestType)(nil)).Elem()
}

type CreateDiagnosticPartitionResponse struct {
}

type CreateDirectory CreateDirectoryRequestType

func init() {
	t["CreateDirectory"] = reflect.TypeOf((*CreateDirectory)(nil)).Elem()
}

// The parameters of `DatastoreNamespaceManager.CreateDirectory`.
type CreateDirectoryRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// datastore on which to create a top-level directory
	//
	// Required privileges: Datastore.Config
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// display name hint for the directory to create
	DisplayName string `xml:"displayName,omitempty" json:"displayName,omitempty"`
	// opaque storage policy to associate with the directory
	Policy string `xml:"policy,omitempty" json:"policy,omitempty"`
	// directory size in MB on vvol/vsan backed object storage.
	// default directory size will be used for vsan backed
	// object storage if not set.
	Size int64 `xml:"size,omitempty" json:"size,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["CreateDirectoryRequestType"] = reflect.TypeOf((*CreateDirectoryRequestType)(nil)).Elem()
}

type CreateDirectoryResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// The parameters of `VcenterVStorageObjectManager.CreateDiskFromSnapshot_Task`.
type CreateDiskFromSnapshotRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The datastore where the source virtual storage object
	// is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// The ID of the snapshot of the virtual storage object.
	SnapshotId ID `xml:"snapshotId" json:"snapshotId"`
	// A user friendly name to be associated with the new disk.
	Name string `xml:"name" json:"name"`
	// SPBM Profile requirement on the new virtual storage object.
	// If not specified datastore default policy would be
	// assigned.
	Profile []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr" json:"profile,omitempty"`
	// Crypto information of the new disk.
	// If unset and if profile contains an encryption iofilter and
	// if snapshto is unencrypted, then cyrpto will be of
	// type CryptoSpecEncrypt, and filled with keyId that is
	// automatically generated and keyProviderId that is the
	// default kms cluster.
	// If unset and if profile is a default policy and if snapshot
	// is unenrypted, then crypto is treated as CryptoSpecNoOp.
	// If unset and if profile contains an encryption iofilter and
	// if snapshot is encrypted, then cyrpto is treated as
	// CryptoSpecNoOp.
	// If unset and if profile is a default policy and if
	// snapshot is encrypted, then cyrpto is treated as
	// CryptoSpecDecrypt.
	// To recrypt the disk during creating disk, crypto has to be
	// present.
	Crypto BaseCryptoSpec `xml:"crypto,omitempty,typeattr" json:"crypto,omitempty"`
	// Relative location in the specified datastore where disk needs
	// to be created. If not specified disk gets created at the
	// defualt VStorageObject location on the specified datastore.
	Path string `xml:"path,omitempty" json:"path,omitempty"`
}

func init() {
	t["CreateDiskFromSnapshotRequestType"] = reflect.TypeOf((*CreateDiskFromSnapshotRequestType)(nil)).Elem()
}

type CreateDiskFromSnapshot_Task CreateDiskFromSnapshotRequestType

func init() {
	t["CreateDiskFromSnapshot_Task"] = reflect.TypeOf((*CreateDiskFromSnapshot_Task)(nil)).Elem()
}

type CreateDiskFromSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VcenterVStorageObjectManager.CreateDisk_Task`.
type CreateDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification of the virtual storage object
	// to be created.
	Spec VslmCreateSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateDiskRequestType"] = reflect.TypeOf((*CreateDiskRequestType)(nil)).Elem()
}

type CreateDisk_Task CreateDiskRequestType

func init() {
	t["CreateDisk_Task"] = reflect.TypeOf((*CreateDisk_Task)(nil)).Elem()
}

type CreateDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateFilter CreateFilterRequestType

func init() {
	t["CreateFilter"] = reflect.TypeOf((*CreateFilter)(nil)).Elem()
}

// The parameters of `PropertyCollector.CreateFilter`.
type CreateFilterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specifications for the filter.
	Spec PropertyFilterSpec `xml:"spec" json:"spec"`
	// Flag to specify whether a change to a nested property should report
	// only the nested change or the entire specified property value. If the
	// value is true, a change should report only the nested property. If
	// the value is false, a change should report the enclosing property
	// named in the filter.
	PartialUpdates bool `xml:"partialUpdates" json:"partialUpdates"`
}

func init() {
	t["CreateFilterRequestType"] = reflect.TypeOf((*CreateFilterRequestType)(nil)).Elem()
}

type CreateFilterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateFolder CreateFolderRequestType

func init() {
	t["CreateFolder"] = reflect.TypeOf((*CreateFolder)(nil)).Elem()
}

// The parameters of `Folder.CreateFolder`.
type CreateFolderRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name to be given the new folder. An entity name
	// must be a non-empty string of less than 80 characters.
	// The slash (/), backslash (\\) and percent (%) will be escaped
	// using the URL syntax. For example, %2F. Any percent (%)
	// character used in this parameter must be escaped, unless
	// it is used to start an escape sequence. Clients may also
	// escape any other characters in this parameter.
	Name string `xml:"name" json:"name"`
}

func init() {
	t["CreateFolderRequestType"] = reflect.TypeOf((*CreateFolderRequestType)(nil)).Elem()
}

type CreateFolderResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateGroup CreateGroupRequestType

func init() {
	t["CreateGroup"] = reflect.TypeOf((*CreateGroup)(nil)).Elem()
}

// The parameters of `HostLocalAccountManager.CreateGroup`.
type CreateGroupRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification of group being created.
	Group BaseHostAccountSpec `xml:"group,typeattr" json:"group"`
}

func init() {
	t["CreateGroupRequestType"] = reflect.TypeOf((*CreateGroupRequestType)(nil)).Elem()
}

type CreateGroupResponse struct {
}

type CreateImportSpec CreateImportSpecRequestType

func init() {
	t["CreateImportSpec"] = reflect.TypeOf((*CreateImportSpec)(nil)).Elem()
}

// The parameters of `OvfManager.CreateImportSpec`.
type CreateImportSpecRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The OVF descriptor of the entity.
	OvfDescriptor string `xml:"ovfDescriptor" json:"ovfDescriptor"`
	// The resource pool to import the entity to. May be a
	// vApp.
	//
	// Required privileges: VApp.Import
	//
	// Refers instance of `ResourcePool`.
	ResourcePool ManagedObjectReference `xml:"resourcePool" json:"resourcePool"`
	// The datastore on which to create the inventory objects
	// of the entity, for example "storage1". The privilege
	// Datastore.AllocateSpace is required on the datastore.
	//
	// Required privileges: Datastore.AllocateSpace
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// Additional parameters to the method, bundled in an instance of
	// CreateImportSpecParams.
	Cisp OvfCreateImportSpecParams `xml:"cisp" json:"cisp"`
}

func init() {
	t["CreateImportSpecRequestType"] = reflect.TypeOf((*CreateImportSpecRequestType)(nil)).Elem()
}

type CreateImportSpecResponse struct {
	Returnval OvfCreateImportSpecResult `xml:"returnval" json:"returnval"`
}

type CreateInventoryView CreateInventoryViewRequestType

func init() {
	t["CreateInventoryView"] = reflect.TypeOf((*CreateInventoryView)(nil)).Elem()
}

type CreateInventoryViewRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CreateInventoryViewRequestType"] = reflect.TypeOf((*CreateInventoryViewRequestType)(nil)).Elem()
}

type CreateInventoryViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateIpPool CreateIpPoolRequestType

func init() {
	t["CreateIpPool"] = reflect.TypeOf((*CreateIpPool)(nil)).Elem()
}

// The parameters of `IpPoolManager.CreateIpPool`.
type CreateIpPoolRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter on which to create the pool.
	//
	// Required privileges: Datacenter.IpPoolConfig
	//
	// Refers instance of `Datacenter`.
	Dc ManagedObjectReference `xml:"dc" json:"dc"`
	// The IP pool to create on the server
	Pool IpPool `xml:"pool" json:"pool"`
}

func init() {
	t["CreateIpPoolRequestType"] = reflect.TypeOf((*CreateIpPoolRequestType)(nil)).Elem()
}

type CreateIpPoolResponse struct {
	Returnval int32 `xml:"returnval" json:"returnval"`
}

type CreateListView CreateListViewRequestType

func init() {
	t["CreateListView"] = reflect.TypeOf((*CreateListView)(nil)).Elem()
}

type CreateListViewFromView CreateListViewFromViewRequestType

func init() {
	t["CreateListViewFromView"] = reflect.TypeOf((*CreateListViewFromView)(nil)).Elem()
}

// The parameters of `ViewManager.CreateListViewFromView`.
type CreateListViewFromViewRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The view that will provide the object list for the
	// new ListView object.
	//
	// Refers instance of `View`.
	View ManagedObjectReference `xml:"view" json:"view"`
}

func init() {
	t["CreateListViewFromViewRequestType"] = reflect.TypeOf((*CreateListViewFromViewRequestType)(nil)).Elem()
}

type CreateListViewFromViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `ViewManager.CreateListView`.
type CreateListViewRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The initial list of objects in the view.
	//
	// Required privileges: System.View
	Obj []ManagedObjectReference `xml:"obj,omitempty" json:"obj,omitempty"`
}

func init() {
	t["CreateListViewRequestType"] = reflect.TypeOf((*CreateListViewRequestType)(nil)).Elem()
}

type CreateListViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateLocalDatastore CreateLocalDatastoreRequestType

func init() {
	t["CreateLocalDatastore"] = reflect.TypeOf((*CreateLocalDatastore)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.CreateLocalDatastore`.
type CreateLocalDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of a datastore to create on the local host.
	Name string `xml:"name" json:"name"`
	// The file path for a directory in which the virtual machine data
	// will be stored.
	Path string `xml:"path" json:"path"`
}

func init() {
	t["CreateLocalDatastoreRequestType"] = reflect.TypeOf((*CreateLocalDatastoreRequestType)(nil)).Elem()
}

type CreateLocalDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateNasDatastore CreateNasDatastoreRequestType

func init() {
	t["CreateNasDatastore"] = reflect.TypeOf((*CreateNasDatastore)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.CreateNasDatastore`.
type CreateNasDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for creating a network-attached storage volume.
	Spec HostNasVolumeSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateNasDatastoreRequestType"] = reflect.TypeOf((*CreateNasDatastoreRequestType)(nil)).Elem()
}

type CreateNasDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostNvdimmSystem.CreateNvdimmNamespace_Task`.
type CreateNvdimmNamespaceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Parameters to create the required namespace.
	CreateSpec NvdimmNamespaceCreateSpec `xml:"createSpec" json:"createSpec"`
}

func init() {
	t["CreateNvdimmNamespaceRequestType"] = reflect.TypeOf((*CreateNvdimmNamespaceRequestType)(nil)).Elem()
}

type CreateNvdimmNamespace_Task CreateNvdimmNamespaceRequestType

func init() {
	t["CreateNvdimmNamespace_Task"] = reflect.TypeOf((*CreateNvdimmNamespace_Task)(nil)).Elem()
}

type CreateNvdimmNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostNvdimmSystem.CreateNvdimmPMemNamespace_Task`.
type CreateNvdimmPMemNamespaceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Parameters to create the required namespace.
	CreateSpec NvdimmPMemNamespaceCreateSpec `xml:"createSpec" json:"createSpec"`
}

func init() {
	t["CreateNvdimmPMemNamespaceRequestType"] = reflect.TypeOf((*CreateNvdimmPMemNamespaceRequestType)(nil)).Elem()
}

type CreateNvdimmPMemNamespace_Task CreateNvdimmPMemNamespaceRequestType

func init() {
	t["CreateNvdimmPMemNamespace_Task"] = reflect.TypeOf((*CreateNvdimmPMemNamespace_Task)(nil)).Elem()
}

type CreateNvdimmPMemNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateNvmeOverRdmaAdapter CreateNvmeOverRdmaAdapterRequestType

func init() {
	t["CreateNvmeOverRdmaAdapter"] = reflect.TypeOf((*CreateNvmeOverRdmaAdapter)(nil)).Elem()
}

// The parameters of `HostStorageSystem.CreateNvmeOverRdmaAdapter`.
type CreateNvmeOverRdmaAdapterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The device name of the RDMA device
	// to be used to create the software adapter.
	// Can be obtained from `HostRdmaDevice.device`.
	RdmaDeviceName string `xml:"rdmaDeviceName" json:"rdmaDeviceName"`
}

func init() {
	t["CreateNvmeOverRdmaAdapterRequestType"] = reflect.TypeOf((*CreateNvmeOverRdmaAdapterRequestType)(nil)).Elem()
}

type CreateNvmeOverRdmaAdapterResponse struct {
}

type CreateObjectScheduledTask CreateObjectScheduledTaskRequestType

func init() {
	t["CreateObjectScheduledTask"] = reflect.TypeOf((*CreateObjectScheduledTask)(nil)).Elem()
}

// The parameters of `ScheduledTaskManager.CreateObjectScheduledTask`.
type CreateObjectScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The managed object for which the
	// scheduled task triggers an action. You can
	// schedule tasks on any managed object.
	//
	// Required privileges: ScheduledTask.Create
	Obj ManagedObjectReference `xml:"obj" json:"obj"`
	// The specification for the new scheduled task.
	Spec BaseScheduledTaskSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["CreateObjectScheduledTaskRequestType"] = reflect.TypeOf((*CreateObjectScheduledTaskRequestType)(nil)).Elem()
}

type CreateObjectScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreatePerfInterval CreatePerfIntervalRequestType

func init() {
	t["CreatePerfInterval"] = reflect.TypeOf((*CreatePerfInterval)(nil)).Elem()
}

// The parameters of `PerformanceManager.CreatePerfInterval`.
type CreatePerfIntervalRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A custom interval, specified as the number of seconds to hold data in the
	// database, a user-specified unique name, and a sampling period (in
	// seconds).
	IntervalId PerfInterval `xml:"intervalId" json:"intervalId"`
}

func init() {
	t["CreatePerfIntervalRequestType"] = reflect.TypeOf((*CreatePerfIntervalRequestType)(nil)).Elem()
}

type CreatePerfIntervalResponse struct {
}

type CreateProfile CreateProfileRequestType

func init() {
	t["CreateProfile"] = reflect.TypeOf((*CreateProfile)(nil)).Elem()
}

// The parameters of `ProfileManager.CreateProfile`.
type CreateProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification for the profile being created.
	// Usually a derived class CreateSpec can be used to create the Profile.
	CreateSpec BaseProfileCreateSpec `xml:"createSpec,typeattr" json:"createSpec"`
}

func init() {
	t["CreateProfileRequestType"] = reflect.TypeOf((*CreateProfileRequestType)(nil)).Elem()
}

type CreateProfileResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreatePropertyCollector CreatePropertyCollectorRequestType

func init() {
	t["CreatePropertyCollector"] = reflect.TypeOf((*CreatePropertyCollector)(nil)).Elem()
}

type CreatePropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CreatePropertyCollectorRequestType"] = reflect.TypeOf((*CreatePropertyCollectorRequestType)(nil)).Elem()
}

type CreatePropertyCollectorResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateRegistryKeyInGuest CreateRegistryKeyInGuestRequestType

func init() {
	t["CreateRegistryKeyInGuest"] = reflect.TypeOf((*CreateRegistryKeyInGuest)(nil)).Elem()
}

// The parameters of `GuestWindowsRegistryManager.CreateRegistryKeyInGuest`.
type CreateRegistryKeyInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The path to the registry key to be created.
	KeyName GuestRegKeyNameSpec `xml:"keyName" json:"keyName"`
	// If true, the key is created in memory and is not
	// preserved across system reboot. Otherwise, it shall
	// persist in the file system.
	IsVolatile bool `xml:"isVolatile" json:"isVolatile"`
	// User defined class type for this key. May be omitted.
	ClassType string `xml:"classType,omitempty" json:"classType,omitempty"`
}

func init() {
	t["CreateRegistryKeyInGuestRequestType"] = reflect.TypeOf((*CreateRegistryKeyInGuestRequestType)(nil)).Elem()
}

type CreateRegistryKeyInGuestResponse struct {
}

type CreateResourcePool CreateResourcePoolRequestType

func init() {
	t["CreateResourcePool"] = reflect.TypeOf((*CreateResourcePool)(nil)).Elem()
}

// The parameters of `ResourcePool.CreateResourcePool`.
type CreateResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the ResourcePool. Any % (percent) character
	// used in this parameter must be escaped, unless it is used
	// to start an escape sequence. Clients may also escape any
	// other characters in this parameter.
	Name string `xml:"name" json:"name"`
	// The spec for the ResourcePool.
	// All values in ResourceAllocationInfo must be specified and
	// are not optional.
	Spec ResourceConfigSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateResourcePoolRequestType"] = reflect.TypeOf((*CreateResourcePoolRequestType)(nil)).Elem()
}

type CreateResourcePoolResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateScheduledTask CreateScheduledTaskRequestType

func init() {
	t["CreateScheduledTask"] = reflect.TypeOf((*CreateScheduledTask)(nil)).Elem()
}

// The parameters of `ScheduledTaskManager.CreateScheduledTask`.
type CreateScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The managed entity (or entities) for which the
	// scheduled task triggers an action. You can
	// schedule tasks on any managed entity. If the
	// scheduled task is associated with a leaf node in
	// the inventory tree, it applies only to a single
	// entity (virtual machine or host). If the
	// task is associated with a folder, a datacenter, a
	// compute resource, or a resource pool, it applies to
	// the virtual machine or host descendants of the entity.
	//
	// Required privileges: ScheduledTask.Create
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
	// The specification for the new scheduled task.
	Spec BaseScheduledTaskSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["CreateScheduledTaskRequestType"] = reflect.TypeOf((*CreateScheduledTaskRequestType)(nil)).Elem()
}

type CreateScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateScreenshotRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CreateScreenshotRequestType"] = reflect.TypeOf((*CreateScreenshotRequestType)(nil)).Elem()
}

type CreateScreenshot_Task CreateScreenshotRequestType

func init() {
	t["CreateScreenshot_Task"] = reflect.TypeOf((*CreateScreenshot_Task)(nil)).Elem()
}

type CreateScreenshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CreateSecondaryVMEx_Task`.
type CreateSecondaryVMExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The host where the secondary virtual machine is to be
	// created and powered on. If no host is specified, a compatible host will be
	// selected by the system. If a host cannot be found for the secondary or the specified
	// host is not suitable, the secondary will not be created and a fault will be returned.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// This parameter `FaultToleranceVMConfigSpec` can
	// be used to specify the storage location of the fault tolerance
	// tie-breaker file, secondary configuration file and secondary
	// disks.
	//
	// If the virtual machine is on a vSAN datastore, then the
	// Fault Tolerance secondary virtual machine and the tie-breaker
	// file also have to be placed on that same vSAN datastore.
	// Conversely, if a primary VM is not using vSAN datastore,
	// then its Fault Tolerance secondary virtual machine can
	// not be placed on a vSAN datastore. Fault Tolerance is not
	// supported for VMs that are using both vSAN and non-vSAN
	// datastores for its configuration and disks.
	//
	// If the virtual machine is using persistent memory for any of
	// its disks, then its corresponding secondary disk placement
	// entry should not be specified in the
	// `FaultToleranceVMConfigSpec`. The system will
	// automatically place the corresponding secondary disk on
	// persistent memory.
	Spec *FaultToleranceConfigSpec `xml:"spec,omitempty" json:"spec,omitempty"`
}

func init() {
	t["CreateSecondaryVMExRequestType"] = reflect.TypeOf((*CreateSecondaryVMExRequestType)(nil)).Elem()
}

type CreateSecondaryVMEx_Task CreateSecondaryVMExRequestType

func init() {
	t["CreateSecondaryVMEx_Task"] = reflect.TypeOf((*CreateSecondaryVMEx_Task)(nil)).Elem()
}

type CreateSecondaryVMEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CreateSecondaryVM_Task`.
type CreateSecondaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The host where the secondary virtual machine is to be
	// created and powered on. If no host is specified, a compatible host will be
	// selected by the system. If a host cannot be found for the secondary or the specified
	// host is not suitable, the secondary will not be created and a fault will be returned.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["CreateSecondaryVMRequestType"] = reflect.TypeOf((*CreateSecondaryVMRequestType)(nil)).Elem()
}

type CreateSecondaryVM_Task CreateSecondaryVMRequestType

func init() {
	t["CreateSecondaryVM_Task"] = reflect.TypeOf((*CreateSecondaryVM_Task)(nil)).Elem()
}

type CreateSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CreateSnapshotEx_Task`.
type CreateSnapshotExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name for this snapshot. The name need not be unique for
	// this virtual machine.
	Name string `xml:"name" json:"name"`
	// A description for this snapshot. If omitted, a default
	// description may be provided.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// If TRUE, a dump of the internal state of the virtual machine
	// (basically a memory dump) is included in the snapshot. Memory snapshots
	// consume time and resources, and thus take longer to create.
	// When set to FALSE, the power state of the snapshot is set to powered off.
	//
	// `capabilities`
	// indicates whether or not this virtual machine supports this operation.
	// For a virtual machine in suspended state we always include memory
	// unless `VirtualMachineCapability.diskOnlySnapshotOnSuspendedVMSupported` is
	// true.
	Memory bool `xml:"memory" json:"memory"`
	// Spec for granular control over quiesce details.
	// If quiesceSpec is set and the virtual machine is powered on when the
	// snapshot is taken, VMware Tools is used to quiesce the file
	// system in the virtual machine. This assures that a disk snapshot
	// represents a consistent state of the guest file systems. If the virtual
	// machine is powered off or VMware Tools are not available, the quiesce
	// spec is ignored. If the spec type is `VirtualMachineGuestQuiesceSpec`, the
	// default quiescing process will be applied. If the spec type is
	// `VirtualMachineWindowsQuiesceSpec` and Guest OS is Windows, the parameters
	// will control the VSS process.
	QuiesceSpec BaseVirtualMachineGuestQuiesceSpec `xml:"quiesceSpec,omitempty,typeattr" json:"quiesceSpec,omitempty"`
}

func init() {
	t["CreateSnapshotExRequestType"] = reflect.TypeOf((*CreateSnapshotExRequestType)(nil)).Elem()
}

type CreateSnapshotEx_Task CreateSnapshotExRequestType

func init() {
	t["CreateSnapshotEx_Task"] = reflect.TypeOf((*CreateSnapshotEx_Task)(nil)).Elem()
}

type CreateSnapshotEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CreateSnapshot_Task`.
type CreateSnapshotRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name for this snapshot. The name need not be unique for
	// this virtual machine.
	Name string `xml:"name" json:"name"`
	// A description for this snapshot. If omitted, a default
	// description may be provided.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// If TRUE, a dump of the internal state of the virtual machine
	// (basically a memory dump) is included in the snapshot. Memory snapshots
	// consume time and resources, and thus take longer to create. When set to FALSE,
	// the power state of the snapshot is set to powered off.
	//
	// `capabilities`
	// indicates whether or not this virtual machine supports this operation.
	// For a virtual machine in suspended state we always include memory
	// unless `VirtualMachineCapability.diskOnlySnapshotOnSuspendedVMSupported` is
	// true.
	Memory bool `xml:"memory" json:"memory"`
	// If TRUE and the virtual machine is powered on when the
	// snapshot is taken, VMware Tools is used to quiesce the file
	// system in the virtual machine. This assures that a disk snapshot
	// represents a consistent state of the guest file systems. If the virtual machine
	// is powered off or VMware Tools are not available, the quiesce flag is ignored.
	Quiesce bool `xml:"quiesce" json:"quiesce"`
}

func init() {
	t["CreateSnapshotRequestType"] = reflect.TypeOf((*CreateSnapshotRequestType)(nil)).Elem()
}

type CreateSnapshot_Task CreateSnapshotRequestType

func init() {
	t["CreateSnapshot_Task"] = reflect.TypeOf((*CreateSnapshot_Task)(nil)).Elem()
}

type CreateSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateSoftwareAdapter CreateSoftwareAdapterRequestType

func init() {
	t["CreateSoftwareAdapter"] = reflect.TypeOf((*CreateSoftwareAdapter)(nil)).Elem()
}

// The parameters of `HostStorageSystem.CreateSoftwareAdapter`.
type CreateSoftwareAdapterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A data object that specifices the parameters necessary
	// to create a software host bus adapter of a specific type.
	Spec BaseHostHbaCreateSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["CreateSoftwareAdapterRequestType"] = reflect.TypeOf((*CreateSoftwareAdapterRequestType)(nil)).Elem()
	minAPIVersionForType["CreateSoftwareAdapterRequestType"] = "7.0.3.0"
}

type CreateSoftwareAdapterResponse struct {
}

type CreateStoragePod CreateStoragePodRequestType

func init() {
	t["CreateStoragePod"] = reflect.TypeOf((*CreateStoragePod)(nil)).Elem()
}

// The parameters of `Folder.CreateStoragePod`.
type CreateStoragePodRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Name for the new storage pod.
	Name string `xml:"name" json:"name"`
}

func init() {
	t["CreateStoragePodRequestType"] = reflect.TypeOf((*CreateStoragePodRequestType)(nil)).Elem()
}

type CreateStoragePodResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateTask CreateTaskRequestType

func init() {
	t["CreateTask"] = reflect.TypeOf((*CreateTask)(nil)).Elem()
}

// This data object type specifies the type of task to be created
// when this action is triggered.
type CreateTaskAction struct {
	Action

	// Extension registered task type identifier
	// for type of task being created.
	TaskTypeId string `xml:"taskTypeId" json:"taskTypeId"`
	// Whether the task should be cancelable.
	Cancelable bool `xml:"cancelable" json:"cancelable"`
}

func init() {
	t["CreateTaskAction"] = reflect.TypeOf((*CreateTaskAction)(nil)).Elem()
}

// The parameters of `TaskManager.CreateTask`.
type CreateTaskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// ManagedObject with which Task will be associated
	Obj ManagedObjectReference `xml:"obj" json:"obj"`
	// Extension registered task type identifier
	// for type of task being created
	TaskTypeId string `xml:"taskTypeId" json:"taskTypeId"`
	// The name of the user on whose behalf the
	// Extension is creating the task
	InitiatedBy string `xml:"initiatedBy,omitempty" json:"initiatedBy,omitempty"`
	// True if the task should be cancelable,
	// false otherwise
	Cancelable bool `xml:"cancelable" json:"cancelable"`
	// Key of the task that is the parent of this task
	ParentTaskKey string `xml:"parentTaskKey,omitempty" json:"parentTaskKey,omitempty"`
	// Activation Id is a client-provided token to link an
	// API call with a task. When provided, the activationId is added to the
	// `TaskInfo`
	ActivationId string `xml:"activationId,omitempty" json:"activationId,omitempty"`
}

func init() {
	t["CreateTaskRequestType"] = reflect.TypeOf((*CreateTaskRequestType)(nil)).Elem()
}

type CreateTaskResponse struct {
	Returnval TaskInfo `xml:"returnval" json:"returnval"`
}

type CreateTemporaryDirectoryInGuest CreateTemporaryDirectoryInGuestRequestType

func init() {
	t["CreateTemporaryDirectoryInGuest"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuest)(nil)).Elem()
}

// The parameters of `GuestFileManager.CreateTemporaryDirectoryInGuest`.
type CreateTemporaryDirectoryInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual Machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The prefix to be given to the new temporary directory.
	Prefix string `xml:"prefix" json:"prefix"`
	// The suffix to be given to the new temporary directory.
	Suffix string `xml:"suffix" json:"suffix"`
	// The complete path to the directory in which to create the
	// new directory. If unset or an empty string, a guest-specific location
	// will be used.
	DirectoryPath string `xml:"directoryPath,omitempty" json:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryDirectoryInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryDirectoryInGuestResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type CreateTemporaryFileInGuest CreateTemporaryFileInGuestRequestType

func init() {
	t["CreateTemporaryFileInGuest"] = reflect.TypeOf((*CreateTemporaryFileInGuest)(nil)).Elem()
}

// The parameters of `GuestFileManager.CreateTemporaryFileInGuest`.
type CreateTemporaryFileInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual Machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The prefix to be given to the new temporary file.
	Prefix string `xml:"prefix" json:"prefix"`
	// The suffix to be given to the new temporary file.
	Suffix string `xml:"suffix" json:"suffix"`
	// The complete path to the directory in which to
	// create the file.
	// If unset, or an empty string, a guest-specific location will be used.
	DirectoryPath string `xml:"directoryPath,omitempty" json:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryFileInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryFileInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryFileInGuestResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

type CreateUser CreateUserRequestType

func init() {
	t["CreateUser"] = reflect.TypeOf((*CreateUser)(nil)).Elem()
}

// The parameters of `HostLocalAccountManager.CreateUser`.
type CreateUserRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification of user being created.
	User BaseHostAccountSpec `xml:"user,typeattr" json:"user"`
}

func init() {
	t["CreateUserRequestType"] = reflect.TypeOf((*CreateUserRequestType)(nil)).Elem()
}

type CreateUserResponse struct {
}

type CreateVApp CreateVAppRequestType

func init() {
	t["CreateVApp"] = reflect.TypeOf((*CreateVApp)(nil)).Elem()
}

// The parameters of `ResourcePool.CreateVApp`.
type CreateVAppRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the vApp container in the inventory
	Name string `xml:"name" json:"name"`
	// The resource configuration for the vApp container (same as for a
	// regular resource pool).
	ResSpec ResourceConfigSpec `xml:"resSpec" json:"resSpec"`
	// The specification of the vApp specific meta-data.
	ConfigSpec VAppConfigSpec `xml:"configSpec" json:"configSpec"`
	// The parent folder for the vApp. This must be null if this is
	// a child vApp.
	//
	// Refers instance of `Folder`.
	VmFolder *ManagedObjectReference `xml:"vmFolder,omitempty" json:"vmFolder,omitempty"`
}

func init() {
	t["CreateVAppRequestType"] = reflect.TypeOf((*CreateVAppRequestType)(nil)).Elem()
}

type CreateVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `Folder.CreateVM_Task`.
type CreateVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The configuration of the virtual machine hardware.
	Config VirtualMachineConfigSpec `xml:"config" json:"config"`
	// The resource pool to which the virtual machine will be attached.
	//
	// Required privileges: Resource.AssignVMToPool
	//
	// Refers instance of `ResourcePool`.
	Pool ManagedObjectReference `xml:"pool" json:"pool"`
	// The target host on which the virtual machine will run. This must
	// specify a host that is a member of the ComputeResource indirectly
	// specified by the pool. For a stand-alone host or a cluster with DRS,
	// host can be omitted, and the system selects a default.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["CreateVMRequestType"] = reflect.TypeOf((*CreateVMRequestType)(nil)).Elem()
}

type CreateVM_Task CreateVMRequestType

func init() {
	t["CreateVM_Task"] = reflect.TypeOf((*CreateVM_Task)(nil)).Elem()
}

type CreateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualDiskManager.CreateVirtualDisk_Task`.
type CreateVirtualDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the disk, either a datastore path or a
	// URL referring to the virtual disk to be created.
	Name string `xml:"name" json:"name"`
	// If <code>name</code> is a datastore path, the datacenter for
	// that datastore path. Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>name</code> must be a URL.
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
	// The specification of the virtual disk to be created.
	Spec BaseVirtualDiskSpec `xml:"spec,typeattr" json:"spec"`
}

func init() {
	t["CreateVirtualDiskRequestType"] = reflect.TypeOf((*CreateVirtualDiskRequestType)(nil)).Elem()
}

type CreateVirtualDisk_Task CreateVirtualDiskRequestType

func init() {
	t["CreateVirtualDisk_Task"] = reflect.TypeOf((*CreateVirtualDisk_Task)(nil)).Elem()
}

type CreateVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateVmfsDatastore CreateVmfsDatastoreRequestType

func init() {
	t["CreateVmfsDatastore"] = reflect.TypeOf((*CreateVmfsDatastore)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.CreateVmfsDatastore`.
type CreateVmfsDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specification for creating a datastore backed by a VMFS.
	Spec VmfsDatastoreCreateSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateVmfsDatastoreRequestType"] = reflect.TypeOf((*CreateVmfsDatastoreRequestType)(nil)).Elem()
}

type CreateVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CreateVvolDatastore CreateVvolDatastoreRequestType

func init() {
	t["CreateVvolDatastore"] = reflect.TypeOf((*CreateVvolDatastore)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.CreateVvolDatastore`.
type CreateVvolDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Specification for creating a Virtual-Volume based datastore.
	Spec HostDatastoreSystemVvolDatastoreSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CreateVvolDatastoreRequestType"] = reflect.TypeOf((*CreateVvolDatastoreRequestType)(nil)).Elem()
}

type CreateVvolDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Data Object representing a cryptographic key.
type CryptoKeyId struct {
	DynamicData

	// Unique key ID.
	//
	// When creating a key may be replaced with the ID generated by the KMS
	// server.
	// An empty string must be used when encrypting with a Trusted Key Provider,
	// because the key is generated at the time of encryption.
	KeyId string `xml:"keyId" json:"keyId"`
	// The provider holding the key data.
	//
	// May be ignored if the key is known to be stored in another provider.
	ProviderId *KeyProviderId `xml:"providerId,omitempty" json:"providerId,omitempty"`
}

func init() {
	t["CryptoKeyId"] = reflect.TypeOf((*CryptoKeyId)(nil)).Elem()
}

// Data Object representing a plain text cryptographic key.
type CryptoKeyPlain struct {
	DynamicData

	KeyId     CryptoKeyId `xml:"keyId" json:"keyId"`
	Algorithm string      `xml:"algorithm" json:"algorithm"`
	KeyData   string      `xml:"keyData" json:"keyData"`
}

func init() {
	t["CryptoKeyPlain"] = reflect.TypeOf((*CryptoKeyPlain)(nil)).Elem()
}

// CryptoKeyResult.java --
// Data Object representing a cryptographic key operation result.
type CryptoKeyResult struct {
	DynamicData

	KeyId   CryptoKeyId `xml:"keyId" json:"keyId"`
	Success bool        `xml:"success" json:"success"`
	Reason  string      `xml:"reason,omitempty" json:"reason,omitempty"`
	// Fault which includes details about the error.
	Fault *LocalizedMethodFault `xml:"fault,omitempty" json:"fault,omitempty" vim:"7.0.1.0"`
}

func init() {
	t["CryptoKeyResult"] = reflect.TypeOf((*CryptoKeyResult)(nil)).Elem()
}

type CryptoManagerHostDisable CryptoManagerHostDisableRequestType

func init() {
	t["CryptoManagerHostDisable"] = reflect.TypeOf((*CryptoManagerHostDisable)(nil)).Elem()
}

type CryptoManagerHostDisableRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CryptoManagerHostDisableRequestType"] = reflect.TypeOf((*CryptoManagerHostDisableRequestType)(nil)).Elem()
}

type CryptoManagerHostDisableResponse struct {
}

type CryptoManagerHostEnable CryptoManagerHostEnableRequestType

func init() {
	t["CryptoManagerHostEnable"] = reflect.TypeOf((*CryptoManagerHostEnable)(nil)).Elem()
}

// The parameters of `CryptoManagerHost.CryptoManagerHostEnable`.
type CryptoManagerHostEnableRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The key to be used for core dump encryption
	InitialKey CryptoKeyPlain `xml:"initialKey" json:"initialKey"`
}

func init() {
	t["CryptoManagerHostEnableRequestType"] = reflect.TypeOf((*CryptoManagerHostEnableRequestType)(nil)).Elem()
}

type CryptoManagerHostEnableResponse struct {
}

// Status of a Crypto key on host.
type CryptoManagerHostKeyStatus struct {
	DynamicData

	// Crypto key Id.
	KeyId CryptoKeyId `xml:"keyId" json:"keyId"`
	// Whether the key is present in key cache for crypto operation.
	Present bool `xml:"present" json:"present"`
	// Key management type.
	//
	// See `CryptoManagerHostKeyManagementType_enum` for valid values.
	ManagementType string `xml:"managementType,omitempty" json:"managementType,omitempty"`
	// Whether the provider of the key has been granted access.
	AccessGranted *bool `xml:"accessGranted" json:"accessGranted,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["CryptoManagerHostKeyStatus"] = reflect.TypeOf((*CryptoManagerHostKeyStatus)(nil)).Elem()
	minAPIVersionForType["CryptoManagerHostKeyStatus"] = "8.0.1.0"
}

type CryptoManagerHostPrepare CryptoManagerHostPrepareRequestType

func init() {
	t["CryptoManagerHostPrepare"] = reflect.TypeOf((*CryptoManagerHostPrepare)(nil)).Elem()
}

type CryptoManagerHostPrepareRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CryptoManagerHostPrepareRequestType"] = reflect.TypeOf((*CryptoManagerHostPrepareRequestType)(nil)).Elem()
}

type CryptoManagerHostPrepareResponse struct {
}

type CryptoManagerKmipCertSignRequest struct {
	DynamicData

	// Common name for the certificate sign request.
	//
	// This is fully qualified domain name that you wish to secure.
	CommonName string `xml:"commonName,omitempty" json:"commonName,omitempty"`
	// Organization name for the certificate sign request.
	//
	// Usually the legal name of a company or entity and
	// should include any suffixes such as Ltd., Inc., or Corp.
	Organization string `xml:"organization,omitempty" json:"organization,omitempty"`
	// Organizational unit name for the certificate sign request.
	//
	// Internal organization department/division name.
	OrganizationUnit string `xml:"organizationUnit,omitempty" json:"organizationUnit,omitempty"`
	// Locality name for the certificate sign request.
	//
	// Town, city, village, etc.
	Locality string `xml:"locality,omitempty" json:"locality,omitempty"`
	// State name for the certificate sign request.
	//
	// Province, region, county or state.
	State string `xml:"state,omitempty" json:"state,omitempty"`
	// Country Name for the certificate sign request.
	//
	// The two-letter ISO code for the country where your
	// organization is located.
	Country string `xml:"country,omitempty" json:"country,omitempty"`
	// Email address for the certificate sign request.
	//
	// The organization contact, usually of the certificate
	// administrator or IT department.
	Email string `xml:"email,omitempty" json:"email,omitempty"`
}

func init() {
	t["CryptoManagerKmipCertSignRequest"] = reflect.TypeOf((*CryptoManagerKmipCertSignRequest)(nil)).Elem()
	minAPIVersionForType["CryptoManagerKmipCertSignRequest"] = "8.0.1.0"
}

// Basic information of a certificate.
type CryptoManagerKmipCertificateInfo struct {
	DynamicData

	// Subject identifies whom the certificate is issued to.
	Subject string `xml:"subject" json:"subject"`
	// Issuer identifies the party that issued this certificate.
	Issuer string `xml:"issuer" json:"issuer"`
	// The unique serial number of the certificate given by issuer.
	SerialNumber string `xml:"serialNumber" json:"serialNumber"`
	// The beginning time of the period of validity.
	NotBefore time.Time `xml:"notBefore" json:"notBefore"`
	// The ending time of the period of validity.
	NotAfter time.Time `xml:"notAfter" json:"notAfter"`
	// The SSL SHA1 fingerprint of the certificate.
	Fingerprint string `xml:"fingerprint" json:"fingerprint"`
	// The timestamp when the state of the certificate is checked.
	CheckTime time.Time `xml:"checkTime" json:"checkTime"`
	// Total seconds since this certificate has entered valid state.
	//
	// It is the time difference between "now" and "notBefore".
	// If it is negative value, that means the certificate will become
	// valid in a future time.
	SecondsSinceValid int32 `xml:"secondsSinceValid,omitempty" json:"secondsSinceValid,omitempty"`
	// Total seconds before this certificate expires.
	//
	// It is the time difference between "notAfter" and "now".
	// If it is negative value, that means the certificate has already
	// expired.
	SecondsBeforeExpire int32 `xml:"secondsBeforeExpire,omitempty" json:"secondsBeforeExpire,omitempty"`
}

func init() {
	t["CryptoManagerKmipCertificateInfo"] = reflect.TypeOf((*CryptoManagerKmipCertificateInfo)(nil)).Elem()
}

// Status of a KMIP cluster.
type CryptoManagerKmipClusterStatus struct {
	DynamicData

	// The ID of the KMIP cluster.
	ClusterId KeyProviderId `xml:"clusterId" json:"clusterId"`
	// KMS cluster overall status.
	OverallStatus ManagedEntityStatus `xml:"overallStatus,omitempty" json:"overallStatus,omitempty"`
	// Key provider management type.
	//
	// See `KmipClusterInfoKmsManagementType_enum` for valid values.
	ManagementType string `xml:"managementType,omitempty" json:"managementType,omitempty"`
	// Status of the KMIP servers in this cluster.
	Servers []CryptoManagerKmipServerStatus `xml:"servers" json:"servers"`
	// The basic information about the client's certificate.
	ClientCertInfo *CryptoManagerKmipCertificateInfo `xml:"clientCertInfo,omitempty" json:"clientCertInfo,omitempty"`
}

func init() {
	t["CryptoManagerKmipClusterStatus"] = reflect.TypeOf((*CryptoManagerKmipClusterStatus)(nil)).Elem()
}

// Status of a Crypto key
type CryptoManagerKmipCryptoKeyStatus struct {
	DynamicData

	// Crypto key Id
	KeyId CryptoKeyId `xml:"keyId" json:"keyId"`
	// If the key is available for crypto operation
	KeyAvailable *bool `xml:"keyAvailable" json:"keyAvailable,omitempty"`
	// The reason for key not available, valid when keyAvailable is false.
	//
	// `CryptoManagerKmipCryptoKeyStatusKeyUnavailableReason_enum` lists the set of supported values.
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
	// The list of VMs which use that key
	//
	// Refers instances of `VirtualMachine`.
	EncryptedVMs []ManagedObjectReference `xml:"encryptedVMs,omitempty" json:"encryptedVMs,omitempty"`
	// The lists of hosts which use that key as host key
	//
	// Refers instances of `HostSystem`.
	AffectedHosts []ManagedObjectReference `xml:"affectedHosts,omitempty" json:"affectedHosts,omitempty"`
	// The identifier list for the 3rd party who are using the key
	ReferencedByTags []string `xml:"referencedByTags,omitempty" json:"referencedByTags,omitempty"`
}

func init() {
	t["CryptoManagerKmipCryptoKeyStatus"] = reflect.TypeOf((*CryptoManagerKmipCryptoKeyStatus)(nil)).Elem()
}

// Crypto key custom attribute spec
type CryptoManagerKmipCustomAttributeSpec struct {
	DynamicData

	// Crypto key custom attributes
	Attributes []KeyValue `xml:"attributes,omitempty" json:"attributes,omitempty"`
}

func init() {
	t["CryptoManagerKmipCustomAttributeSpec"] = reflect.TypeOf((*CryptoManagerKmipCustomAttributeSpec)(nil)).Elem()
	minAPIVersionForType["CryptoManagerKmipCustomAttributeSpec"] = "8.0.1.0"
}

// Information about the KMIP server certificate.
type CryptoManagerKmipServerCertInfo struct {
	DynamicData

	// The server certificate.
	Certificate string `xml:"certificate" json:"certificate"`
	// The basic information about server's certificate.
	CertInfo *CryptoManagerKmipCertificateInfo `xml:"certInfo,omitempty" json:"certInfo,omitempty"`
	// Whether this KMS server is trusted by local Kmip client.
	ClientTrustServer *bool `xml:"clientTrustServer" json:"clientTrustServer,omitempty"`
}

func init() {
	t["CryptoManagerKmipServerCertInfo"] = reflect.TypeOf((*CryptoManagerKmipServerCertInfo)(nil)).Elem()
}

// Status of a KMIP server.
type CryptoManagerKmipServerStatus struct {
	DynamicData

	// Name of the KMIP server.
	Name string `xml:"name" json:"name"`
	// KMIP server status.
	Status ManagedEntityStatus `xml:"status" json:"status"`
	// KMIP server connection status description.
	ConnectionStatus string `xml:"connectionStatus" json:"connectionStatus"`
	// The basic information about the KMIP server's certificate.
	CertInfo *CryptoManagerKmipCertificateInfo `xml:"certInfo,omitempty" json:"certInfo,omitempty"`
	// Whether this KMS server is trusted by local Kmip client.
	ClientTrustServer *bool `xml:"clientTrustServer" json:"clientTrustServer,omitempty"`
	// Whether this KMS server trusts the local Kmip client.
	ServerTrustClient *bool `xml:"serverTrustClient" json:"serverTrustClient,omitempty"`
}

func init() {
	t["CryptoManagerKmipServerStatus"] = reflect.TypeOf((*CryptoManagerKmipServerStatus)(nil)).Elem()
}

// This data object type encapsulates virtual machine or disk encryption
// settings.
type CryptoSpec struct {
	DynamicData
}

func init() {
	t["CryptoSpec"] = reflect.TypeOf((*CryptoSpec)(nil)).Elem()
}

// This data object type encapsulates virtual machine or disk encryption
// settings for decryption operation.
type CryptoSpecDecrypt struct {
	CryptoSpec
}

func init() {
	t["CryptoSpecDecrypt"] = reflect.TypeOf((*CryptoSpecDecrypt)(nil)).Elem()
}

// This data object type encapsulates virtual machine or disk cryptographic
// settings for deep reencryption operation.
type CryptoSpecDeepRecrypt struct {
	CryptoSpec

	NewKeyId CryptoKeyId `xml:"newKeyId" json:"newKeyId"`
}

func init() {
	t["CryptoSpecDeepRecrypt"] = reflect.TypeOf((*CryptoSpecDeepRecrypt)(nil)).Elem()
}

// This data object type encapsulates virtual machine or disk cryptohraphic
// settings for encryption operation.
type CryptoSpecEncrypt struct {
	CryptoSpec

	CryptoKeyId CryptoKeyId `xml:"cryptoKeyId" json:"cryptoKeyId"`
}

func init() {
	t["CryptoSpecEncrypt"] = reflect.TypeOf((*CryptoSpecEncrypt)(nil)).Elem()
}

// This data object type indicates that the encryption settings of the
// virtual machine or disk should not be modified by the operation.
type CryptoSpecNoOp struct {
	CryptoSpec
}

func init() {
	t["CryptoSpecNoOp"] = reflect.TypeOf((*CryptoSpecNoOp)(nil)).Elem()
}

// This data object type indicates that the operation requires keys to be sent
// but the encryption settings of the virtual machine or disk
// should not be modified by the operation.
type CryptoSpecRegister struct {
	CryptoSpecNoOp

	// The key the VM/disk is already encrypted with.
	CryptoKeyId CryptoKeyId `xml:"cryptoKeyId" json:"cryptoKeyId"`
}

func init() {
	t["CryptoSpecRegister"] = reflect.TypeOf((*CryptoSpecRegister)(nil)).Elem()
}

// This data object type encapsulates virtual machine or disk cryptographic
// settings for shallow reencryption operation.
type CryptoSpecShallowRecrypt struct {
	CryptoSpec

	NewKeyId CryptoKeyId `xml:"newKeyId" json:"newKeyId"`
}

func init() {
	t["CryptoSpecShallowRecrypt"] = reflect.TypeOf((*CryptoSpecShallowRecrypt)(nil)).Elem()
}

type CryptoUnlockRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CryptoUnlockRequestType"] = reflect.TypeOf((*CryptoUnlockRequestType)(nil)).Elem()
}

type CryptoUnlock_Task CryptoUnlockRequestType

func init() {
	t["CryptoUnlock_Task"] = reflect.TypeOf((*CryptoUnlock_Task)(nil)).Elem()
}

type CryptoUnlock_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type CurrentTime CurrentTimeRequestType

func init() {
	t["CurrentTime"] = reflect.TypeOf((*CurrentTime)(nil)).Elem()
}

type CurrentTimeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["CurrentTimeRequestType"] = reflect.TypeOf((*CurrentTimeRequestType)(nil)).Elem()
}

type CurrentTimeResponse struct {
	Returnval time.Time `xml:"returnval" json:"returnval"`
}

// Describes a custom field.
type CustomFieldDef struct {
	DynamicData

	// A unique ID used to reference this custom field in assignments.
	//
	// This
	// ID is unique for the lifetime of the field (even across
	// rename operations).
	Key int32 `xml:"key" json:"key"`
	// Name of the field.
	Name string `xml:"name" json:"name"`
	// Type of the field.
	Type string `xml:"type" json:"type"`
	// Type of object for which the field is valid.
	//
	// If not specified,
	// the field is valid for all managed objects.
	ManagedObjectType string `xml:"managedObjectType,omitempty" json:"managedObjectType,omitempty"`
	// The set of privileges to apply on this field definition
	FieldDefPrivileges *PrivilegePolicyDef `xml:"fieldDefPrivileges,omitempty" json:"fieldDefPrivileges,omitempty"`
	// The set of privileges to apply on instances of this field
	FieldInstancePrivileges *PrivilegePolicyDef `xml:"fieldInstancePrivileges,omitempty" json:"fieldInstancePrivileges,omitempty"`
}

func init() {
	t["CustomFieldDef"] = reflect.TypeOf((*CustomFieldDef)(nil)).Elem()
}

// This event records the addition of a custom field definition.
type CustomFieldDefAddedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefAddedEvent"] = reflect.TypeOf((*CustomFieldDefAddedEvent)(nil)).Elem()
}

// This event records a custom field definition event.
type CustomFieldDefEvent struct {
	CustomFieldEvent

	// The unique identifier of the custom field definition.
	FieldKey int32 `xml:"fieldKey" json:"fieldKey"`
	// The name of the custom field.
	Name string `xml:"name" json:"name"`
}

func init() {
	t["CustomFieldDefEvent"] = reflect.TypeOf((*CustomFieldDefEvent)(nil)).Elem()
}

// This event records the removal of a custom field definition.
type CustomFieldDefRemovedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefRemovedEvent"] = reflect.TypeOf((*CustomFieldDefRemovedEvent)(nil)).Elem()
}

// This event records the renaming of a custom field definition.
type CustomFieldDefRenamedEvent struct {
	CustomFieldDefEvent

	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["CustomFieldDefRenamedEvent"] = reflect.TypeOf((*CustomFieldDefRenamedEvent)(nil)).Elem()
}

// These are custom field events.
type CustomFieldEvent struct {
	Event
}

func init() {
	t["CustomFieldEvent"] = reflect.TypeOf((*CustomFieldEvent)(nil)).Elem()
}

// Subtype for string values (currently the only supported type).
type CustomFieldStringValue struct {
	CustomFieldValue

	// Value assigned to the custom field.
	Value string `xml:"value" json:"value"`
}

func init() {
	t["CustomFieldStringValue"] = reflect.TypeOf((*CustomFieldStringValue)(nil)).Elem()
}

// Base type for storing values.
type CustomFieldValue struct {
	DynamicData

	// The ID of the field to which this value belongs.
	Key int32 `xml:"key" json:"key"`
}

func init() {
	t["CustomFieldValue"] = reflect.TypeOf((*CustomFieldValue)(nil)).Elem()
}

// This event records a change to a custom field value for a particular entity.
type CustomFieldValueChangedEvent struct {
	CustomFieldEvent

	// The entity on which the field value was changed.
	Entity ManagedEntityEventArgument `xml:"entity" json:"entity"`
	// The custom field whose value was changed for the entity.
	FieldKey int32 `xml:"fieldKey" json:"fieldKey"`
	// The name of the custom field at the time the value was changed.
	Name string `xml:"name" json:"name"`
	// The new value that was set.
	Value string `xml:"value" json:"value"`
	// The previous service state.
	PrevState string `xml:"prevState,omitempty" json:"prevState,omitempty"`
}

func init() {
	t["CustomFieldValueChangedEvent"] = reflect.TypeOf((*CustomFieldValueChangedEvent)(nil)).Elem()
}

// Data object type to associate a virtual network adapter with its IP settings.
type CustomizationAdapterMapping struct {
	DynamicData

	// The MAC address of a network adapter being customized.
	//
	// The client cannot change
	// this value because the guest operating system has no control over the MAC
	// address of a virtual network adapter.
	//
	// This property is optional. If it is not included, the customization process maps
	// the settings from the list of AdapterMappings.IPSettings in the
	// Specification.nicSettingMap to the virtual machine's network adapters, in PCI
	// slot order. The first virtual network adapter on the PCI bus is assigned
	// nicSettingMap\[0\].IPSettings, the second adapter is assigned
	// nicSettingMap\[1\].IPSettings, and so on.
	//
	// In vSphere 7.0 series, the MAC addresses must be specified in the
	// ascending order of pciSlotNumber, otherwise a MAC address mismatch error
	// will be reported. For further details, see the
	// https://kb.vmware.com/s/article/87648
	MacAddress string `xml:"macAddress,omitempty" json:"macAddress,omitempty"`
	// The IP settings for the associated virtual network adapter.
	Adapter CustomizationIPSettings `xml:"adapter" json:"adapter"`
}

func init() {
	t["CustomizationAdapterMapping"] = reflect.TypeOf((*CustomizationAdapterMapping)(nil)).Elem()
}

// Use automatic address configuration to generate linklocal ipv6 addresses
type CustomizationAutoIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationAutoIpV6Generator"] = reflect.TypeOf((*CustomizationAutoIpV6Generator)(nil)).Elem()
}

// Guest customization settings to customize a Linux guest operating
// system with raw cloud-init data.
type CustomizationCloudinitPrep struct {
	CustomizationIdentitySettings

	// Metadata includes the network, instance id and hostname that cloud-init
	// processes to configure the VM.
	//
	// It is in json or yaml format.
	// The max size of the metadata is 524288 bytes.
	// See detail information about <a href="https://cloudinit.readthedocs.io/en/latest/topics/instancedata.html#"target="_blank">Instance Metadata</a>.
	Metadata string `xml:"metadata" json:"metadata"`
	// Userdata is the user custom content that cloud-init processes to
	// configure the VM.
	//
	// The max size of the userdata is 524288 bytes.
	// See detail information about <a href="https://cloudinit.readthedocs.io/en/latest/topics/format.html"target="_blank">User-Data formats</a>.
	Userdata string `xml:"userdata,omitempty" json:"userdata,omitempty"`
}

func init() {
	t["CustomizationCloudinitPrep"] = reflect.TypeOf((*CustomizationCloudinitPrep)(nil)).Elem()
	minAPIVersionForType["CustomizationCloudinitPrep"] = "7.0.3.0"
}

// Use a command-line program configured with the VirtualCenter server.
type CustomizationCustomIpGenerator struct {
	CustomizationIpGenerator

	// An optional argument that is passed to the utility for this IP address.
	//
	// The
	// meaning of this field is user-defined, in the script.
	Argument string `xml:"argument,omitempty" json:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpGenerator"] = reflect.TypeOf((*CustomizationCustomIpGenerator)(nil)).Elem()
}

// Use a command-line program configured with the VirtualCenter server.
type CustomizationCustomIpV6Generator struct {
	CustomizationIpV6Generator

	// An optional argument that is passed to the utility for this ipv6 address.
	//
	// The
	// meaning of this field is user-defined, in the script.
	Argument string `xml:"argument,omitempty" json:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpV6Generator"] = reflect.TypeOf((*CustomizationCustomIpV6Generator)(nil)).Elem()
}

// Specifies that the VirtualCenter server will launch an external application to
// generate the (hostname/IP).
//
// The command line for this application must be specified
// in the server configuration file (vpxd.cfg) in the vpxd/name-ip-generator key.
type CustomizationCustomName struct {
	CustomizationName

	// An optional argument that is passed to the utility for this IP address.
	//
	// The
	// meaning of this field is user-defined in the script.
	Argument string `xml:"argument,omitempty" json:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomName"] = reflect.TypeOf((*CustomizationCustomName)(nil)).Elem()
}

// Use a DHCP server to configure the virtual network adapter.
type CustomizationDhcpIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationDhcpIpGenerator"] = reflect.TypeOf((*CustomizationDhcpIpGenerator)(nil)).Elem()
}

// Use a DHCP server to configure ipv6 address
type CustomizationDhcpIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationDhcpIpV6Generator"] = reflect.TypeOf((*CustomizationDhcpIpV6Generator)(nil)).Elem()
}

// Base for customization events.
type CustomizationEvent struct {
	VmEvent

	// The location of the in-guest customization log which will contain
	// details of the customization operation.
	LogLocation string `xml:"logLocation,omitempty" json:"logLocation,omitempty"`
}

func init() {
	t["CustomizationEvent"] = reflect.TypeOf((*CustomizationEvent)(nil)).Elem()
}

// The customization sequence in the guest failed.
type CustomizationFailed struct {
	CustomizationEvent

	// Reason why the customization failed @see CustomizationFailed.ReasonCode .
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
}

func init() {
	t["CustomizationFailed"] = reflect.TypeOf((*CustomizationFailed)(nil)).Elem()
}

// Base for exceptions that can be thrown from the customizer.
type CustomizationFault struct {
	VimFault
}

func init() {
	t["CustomizationFault"] = reflect.TypeOf((*CustomizationFault)(nil)).Elem()
}

type CustomizationFaultFault BaseCustomizationFault

func init() {
	t["CustomizationFaultFault"] = reflect.TypeOf((*CustomizationFaultFault)(nil)).Elem()
}

// Use a static IP Address for the virtual network adapter.
type CustomizationFixedIp struct {
	CustomizationIpGenerator

	IpAddress string `xml:"ipAddress" json:"ipAddress"`
}

func init() {
	t["CustomizationFixedIp"] = reflect.TypeOf((*CustomizationFixedIp)(nil)).Elem()
}

// Use a static ipv6 address for the virtual network adapter
type CustomizationFixedIpV6 struct {
	CustomizationIpV6Generator

	IpAddress  string `xml:"ipAddress" json:"ipAddress"`
	SubnetMask int32  `xml:"subnetMask" json:"subnetMask"`
}

func init() {
	t["CustomizationFixedIpV6"] = reflect.TypeOf((*CustomizationFixedIpV6)(nil)).Elem()
}

// A fixed name.
type CustomizationFixedName struct {
	CustomizationName

	// The virtual machine name specified by the client.
	Name string `xml:"name" json:"name"`
}

func init() {
	t["CustomizationFixedName"] = reflect.TypeOf((*CustomizationFixedName)(nil)).Elem()
}

// A collection of global IP settings for a virtual network adapter.
//
// In Linux, DNS
// server settings are global. The settings can either be statically set or supplied
// by a DHCP server.
type CustomizationGlobalIPSettings struct {
	DynamicData

	// List of name resolution suffixes for the virtual network adapter.
	//
	// This list
	// applies to both Windows and Linux guest customization. For Linux, this setting
	// is global, whereas in Windows, this setting is listed on a per-adapter basis,
	// even though the setting is global in Windows.
	DnsSuffixList []string `xml:"dnsSuffixList,omitempty" json:"dnsSuffixList,omitempty"`
	// List of DNS servers, for a virtual network adapter with a static IP address.
	//
	// If
	// this list is empty, then the guest operating system is expected to use a DHCP
	// server to get its DNS server settings. These settings configure the virtual
	// machine to use the specified DNS servers. These DNS server settings are listed
	// in order of preference.
	DnsServerList []string `xml:"dnsServerList,omitempty" json:"dnsServerList,omitempty"`
}

func init() {
	t["CustomizationGlobalIPSettings"] = reflect.TypeOf((*CustomizationGlobalIPSettings)(nil)).Elem()
}

// The commands listed in the GuiRunOnce data object type are executed when a user
// logs on the first time after customization completes.
//
// The logon may be driven by
// the `AutoLogon` setting.
//
// The GuiRunOnce data object type maps to the GuiRunOnce key in the
// `sysprep.xml` answer file. These values are transferred into the
// `sysprep.xml` file that VirtualCenter stores on the target virtual disk. For
// more detailed information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
type CustomizationGuiRunOnce struct {
	DynamicData

	// A list of commands to run at first user logon, after guest customization.
	CommandList []string `xml:"commandList" json:"commandList"`
}

func init() {
	t["CustomizationGuiRunOnce"] = reflect.TypeOf((*CustomizationGuiRunOnce)(nil)).Elem()
}

// The GuiUnattended type maps to the GuiUnattended key in the `sysprep.xml`
// answer file.
//
// These values are plugged directly into the `sysprep.xml` file
// that VirtualCenter stores on the target virtual disk. For more detailed
// information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
type CustomizationGuiUnattended struct {
	DynamicData

	// The new administrator password for the machine.
	//
	// To specify that the password
	// should be set to blank (that is, no password), set the password value to NULL.
	// Because of encryption, "" is NOT a valid value.
	//
	// If password is set to blank and `CustomizationGuiUnattended.autoLogon` is set, the
	// guest customization will fail.
	//
	// If the XML file is generated by the VirtualCenter Customization Wizard, then the
	// password is encrypted. Otherwise, the client should set the plainText attribute
	// to true, so that the customization process does not attempt to decrypt the
	// string.
	Password *CustomizationPassword `xml:"password,omitempty" json:"password,omitempty"`
	// The time zone index for the virtual machine.
	//
	// Numbers correspond to time zones
	// listed at <a href="https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values"target="_blank">Microsoft Time Zone Index Values</a>.
	TimeZone int32 `xml:"timeZone" json:"timeZone"`
	// Flag to determine whether or not the machine automatically logs on as
	// Administrator.
	//
	// See also the password property.
	//
	// If the AutoLogon flag is set, `CustomizationGuiUnattended.password` must not be
	// blank or the guest customization will fail.
	AutoLogon bool `xml:"autoLogon" json:"autoLogon"`
	// If the AutoLogon flag is set, then the AutoLogonCount property specifies the
	// number of times the machine should automatically log on as Administrator.
	//
	// Generally it should be 1, but if your setup requires a number of reboots, you
	// may want to increase it. This number may be determined by the list of commands
	// executed by the `GuiRunOnce` command.
	AutoLogonCount int32 `xml:"autoLogonCount" json:"autoLogonCount"`
}

func init() {
	t["CustomizationGuiUnattended"] = reflect.TypeOf((*CustomizationGuiUnattended)(nil)).Elem()
}

// IP settings for a virtual network adapter.
type CustomizationIPSettings struct {
	DynamicData

	// Specification to obtain a unique IP address for this virtual network adapter.
	Ip BaseCustomizationIpGenerator `xml:"ip,typeattr" json:"ip"`
	// Subnet mask for this virtual network adapter.
	SubnetMask string `xml:"subnetMask,omitempty" json:"subnetMask,omitempty"`
	// For a virtual network adapter with a static IP address, this data object type
	// contains a list of gateways, in order of preference.
	Gateway []string `xml:"gateway,omitempty" json:"gateway,omitempty"`
	// This contains the IpGenerator, subnet mask and gateway info for all
	// the ipv6 addresses associated with the virtual network adapter.
	IpV6Spec *CustomizationIPSettingsIpV6AddressSpec `xml:"ipV6Spec,omitempty" json:"ipV6Spec,omitempty"`
	// A list of server IP addresses to use for DNS lookup in a Windows guest operating
	// system.
	//
	// In Windows, these settings are adapter-specific, whereas in Linux, they
	// are global. As a result, the Linux guest customization process ignores this
	// setting and looks for its DNS servers in the globalIPSettings object.
	//
	// Specify these servers in order of preference. If this list is not empty, and if
	// a DHCP IpGenerator is used, then these settings override the DHCP settings.
	DnsServerList []string `xml:"dnsServerList,omitempty" json:"dnsServerList,omitempty"`
	// A DNS domain suffix such as vmware.com.
	DnsDomain string `xml:"dnsDomain,omitempty" json:"dnsDomain,omitempty"`
	// The IP address of the primary WINS server.
	//
	// This property is ignored for Linux
	// guest operating systems.
	PrimaryWINS string `xml:"primaryWINS,omitempty" json:"primaryWINS,omitempty"`
	// The IP address of the secondary WINS server.
	//
	// This property is ignored for Linux
	// guest operating systems.
	SecondaryWINS string `xml:"secondaryWINS,omitempty" json:"secondaryWINS,omitempty"`
	// NetBIOS setting for Windows.
	NetBIOS CustomizationNetBIOSMode `xml:"netBIOS,omitempty" json:"netBIOS,omitempty"`
}

func init() {
	t["CustomizationIPSettings"] = reflect.TypeOf((*CustomizationIPSettings)(nil)).Elem()
}

// IPv6 settings
type CustomizationIPSettingsIpV6AddressSpec struct {
	DynamicData

	// ipv6 address generators
	Ip []BaseCustomizationIpV6Generator `xml:"ip,typeattr" json:"ip"`
	// gateways
	Gateway []string `xml:"gateway,omitempty" json:"gateway,omitempty"`
}

func init() {
	t["CustomizationIPSettingsIpV6AddressSpec"] = reflect.TypeOf((*CustomizationIPSettingsIpV6AddressSpec)(nil)).Elem()
}

// The Identification data object type provides information needed to join a workgroup
// or domain.
//
// The Identification data object type maps to the Identification key in the
// `sysprep.xml` answer file. These values are transferred into the
// `sysprep.xml` file that VirtualCenter stores on the target virtual disk. For
// more detailed information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
type CustomizationIdentification struct {
	DynamicData

	// The workgroup that the virtual machine should join.
	//
	// If this value is supplied,
	// then the domain name and authentication fields must be empty.
	JoinWorkgroup string `xml:"joinWorkgroup,omitempty" json:"joinWorkgroup,omitempty"`
	// The domain that the virtual machine should join.
	//
	// If this value is supplied, then
	// domainAdmin and domainAdminPassword must also be supplied, and the workgroup
	// name must be empty.
	JoinDomain string `xml:"joinDomain,omitempty" json:"joinDomain,omitempty"`
	// This is the domain user account used for authentication if the virtual machine
	// is joining a domain.
	//
	// The user does not need to be a domain administrator, but
	// the account must have the privileges required to add computers to the domain.
	DomainAdmin string `xml:"domainAdmin,omitempty" json:"domainAdmin,omitempty"`
	// This is the password for the domain user account used for authentication if the
	// virtual machine is joining a domain.
	DomainAdminPassword *CustomizationPassword `xml:"domainAdminPassword,omitempty" json:"domainAdminPassword,omitempty"`
	// This is the MachineObjectOU which specifies the full LDAP path name of
	// the OU to which the computer belongs.
	//
	// For example, OU=MyOu,DC=MyDom,DC=MyCompany,DC=com
	// Refer to: https://docs.microsoft.com/en-us/windows-hardware/customize/
	// desktop/unattend/microsoft-windows-unattendedjoin-
	// identification-machineobjectou
	DomainOU string `xml:"domainOU,omitempty" json:"domainOU,omitempty" vim:"8.0.2.0"`
}

func init() {
	t["CustomizationIdentification"] = reflect.TypeOf((*CustomizationIdentification)(nil)).Elem()
}

// Base type for sysprep, sysprepText, or linuxPrep object type.
type CustomizationIdentitySettings struct {
	DynamicData
}

func init() {
	t["CustomizationIdentitySettings"] = reflect.TypeOf((*CustomizationIdentitySettings)(nil)).Elem()
}

// Base type for the various IP specification possibilities.
type CustomizationIpGenerator struct {
	DynamicData
}

func init() {
	t["CustomizationIpGenerator"] = reflect.TypeOf((*CustomizationIpGenerator)(nil)).Elem()
}

// Base type for the various IpV6 specification possibilities
type CustomizationIpV6Generator struct {
	DynamicData
}

func init() {
	t["CustomizationIpV6Generator"] = reflect.TypeOf((*CustomizationIpV6Generator)(nil)).Elem()
}

// The LicenseFilePrintData type maps directly to the LicenseFilePrintData key in the
// `sysprep.xml` answer file.
//
// These values are transferred into the
// `sysprep.xml` file that VirtualCenter stores on the target virtual disk. For
// more detailed information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
// LicenseFilePrintData provides licensing information for Windows server operating
// systems.
type CustomizationLicenseFilePrintData struct {
	DynamicData

	// Server licensing mode
	AutoMode CustomizationLicenseDataMode `xml:"autoMode" json:"autoMode"`
	// This key is valid only if AutoMode = PerServer.
	//
	// The integer value indicates the
	// number of client licenses purchased for the VirtualCenter server being
	// installed.
	AutoUsers int32 `xml:"autoUsers,omitempty" json:"autoUsers,omitempty"`
}

func init() {
	t["CustomizationLicenseFilePrintData"] = reflect.TypeOf((*CustomizationLicenseFilePrintData)(nil)).Elem()
}

// Failed to set Linux identity.
type CustomizationLinuxIdentityFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationLinuxIdentityFailed"] = reflect.TypeOf((*CustomizationLinuxIdentityFailed)(nil)).Elem()
}

// Base object type for optional operations supported by the customization process for
// Linux.
type CustomizationLinuxOptions struct {
	CustomizationOptions
}

func init() {
	t["CustomizationLinuxOptions"] = reflect.TypeOf((*CustomizationLinuxOptions)(nil)).Elem()
}

// This is the Linux counterpart to the Windows Sysprep object.
//
// LinuxPrep contains
// machine-wide settings that identify a Linux machine in the same way that the
// Sysprep type identifies a Windows machine.
type CustomizationLinuxPrep struct {
	CustomizationIdentitySettings

	// The network host name of the (Linux) virtual machine.
	HostName BaseCustomizationName `xml:"hostName,typeattr" json:"hostName"`
	// The fully qualified domain name.
	Domain string `xml:"domain" json:"domain"`
	// The case-sensitive timezone, such as Europe/Sofia.
	//
	// <a href="timezone.html"title="Display list of Valid timeZone values...">
	// **Valid timeZone values**</a> are based on the tz (timezone)
	// database used by Linux and other Unix systems.
	// The values are strings (xsd:string) in the form "Area/Location," in which
	// Area is a continent or ocean name, and Location is the city, island, or
	// other regional designation.
	//
	// See the <a href="https://kb.vmware.com/selfservice/microsites/search.do?language=en_US&cmd=displayKC&externalId=2145518"target="_blank">List of supported time zones for different vSphere versions in Linux/Unix systems</a>.
	TimeZone string `xml:"timeZone,omitempty" json:"timeZone,omitempty"`
	// Specifies whether the hardware clock is in UTC or local time.
	//   - True when the hardware clock is in UTC.
	//   - False when the hardware clock is in local time.
	HwClockUTC *bool `xml:"hwClockUTC" json:"hwClockUTC,omitempty"`
	// The script to run before and after GOS customization.
	ScriptText string `xml:"scriptText,omitempty" json:"scriptText,omitempty"`
	// The compatible customization method is an identifier of a customization
	// strategy which is implementable in a group of Linux operating systems.
	//
	// This value does not need to be set if your operating system is officially
	// supported by VMware guest operating system customization. When using a
	// Linux operating system which hasn't been officially supported and it is
	// designed to be 100% bug-for-bug compatible with an officially supported
	// Linux operating system, it can be customized by an existing customization
	// method.
	//
	// Please set the compatible customization method to a supported string value
	// e.g. "GOSC\_METHOD\_1".
	// See <a href="https://kb.vmware.com/s/article/95903"target="_blank">Supported compatible customization method list</a>.
	CompatibleCustomizationMethod string `xml:"compatibleCustomizationMethod,omitempty" json:"compatibleCustomizationMethod,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["CustomizationLinuxPrep"] = reflect.TypeOf((*CustomizationLinuxPrep)(nil)).Elem()
}

// A base object type for a virtual machine name that can be either fixed or
// auto-generated.
type CustomizationName struct {
	DynamicData
}

func init() {
	t["CustomizationName"] = reflect.TypeOf((*CustomizationName)(nil)).Elem()
}

// Network setup failed in the guest during customization.
type CustomizationNetworkSetupFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationNetworkSetupFailed"] = reflect.TypeOf((*CustomizationNetworkSetupFailed)(nil)).Elem()
}

// Base object type for optional operations supported by the customization process.
type CustomizationOptions struct {
	DynamicData
}

func init() {
	t["CustomizationOptions"] = reflect.TypeOf((*CustomizationOptions)(nil)).Elem()
}

// Contains a password string and a flag that specifies whether the string is in plain
// text or encrypted.
type CustomizationPassword struct {
	DynamicData

	// The password string.
	//
	// It is encrypted if the associated plainText flag is false.
	Value string `xml:"value" json:"value"`
	// Flag to specify whether or not the password is in plain text, rather than
	// encrypted.
	PlainText bool `xml:"plainText" json:"plainText"`
}

func init() {
	t["CustomizationPassword"] = reflect.TypeOf((*CustomizationPassword)(nil)).Elem()
}

// A customization operation is already pending on this virtual
// machine and is awaiting power-up to complete.
type CustomizationPending struct {
	CustomizationFault
}

func init() {
	t["CustomizationPending"] = reflect.TypeOf((*CustomizationPending)(nil)).Elem()
}

type CustomizationPendingFault CustomizationPending

func init() {
	t["CustomizationPendingFault"] = reflect.TypeOf((*CustomizationPendingFault)(nil)).Elem()
}

// Specifies that a unique name should be generated by concatenating the base string
// with a number.
//
// Virtual machine names are unique across the set of hosts and virtual machines known
// to the VirtualCenter instance. VirtualCenter tracks the network names of virtual
// machines as well as hosts. VMware Tools runs in a guest operating system and
// reports information to VirtualCenter, including the network name of the guest.
type CustomizationPrefixName struct {
	CustomizationName

	// Base prefix, to which a unique number is appended.
	Base string `xml:"base" json:"base"`
}

func init() {
	t["CustomizationPrefixName"] = reflect.TypeOf((*CustomizationPrefixName)(nil)).Elem()
}

// The Specification data object type contains information required to customize a
// virtual machine when deploying it or migrating it to a new host.
type CustomizationSpec struct {
	DynamicData

	// Optional operations (either LinuxOptions or WinOptions).
	Options BaseCustomizationOptions `xml:"options,omitempty,typeattr" json:"options,omitempty"`
	// Network identity and settings, similar to Microsoft's Sysprep tool.
	//
	// This is a
	// Sysprep, LinuxPrep, CloudinitPrep, or SysprepText object.
	Identity BaseCustomizationIdentitySettings `xml:"identity,typeattr" json:"identity"`
	// Global IP settings constitute the IP settings that are not specific to a
	// particular virtual network adapter.
	GlobalIPSettings CustomizationGlobalIPSettings `xml:"globalIPSettings" json:"globalIPSettings"`
	// IP settings that are specific to a particular virtual network adapter.
	//
	// The
	// AdapterMapping object maps a network adapter's MAC address to its Adapter
	// settings object. May be empty if there are no network adapters, else should
	// match number of network adapters in the VM.
	NicSettingMap []CustomizationAdapterMapping `xml:"nicSettingMap,omitempty" json:"nicSettingMap,omitempty"`
	// Byte array containing the public key used to encrypt any passwords stored in the
	// specification.
	//
	// Both the client and the server can use this to determine if
	// stored passwords can be decrypted by the server or if the passwords need to be
	// re-entered and re-encrypted before the specification can be used.
	EncryptionKey ByteSlice `xml:"encryptionKey,omitempty" json:"encryptionKey,omitempty"`
}

func init() {
	t["CustomizationSpec"] = reflect.TypeOf((*CustomizationSpec)(nil)).Elem()
}

// Information about a specification.
type CustomizationSpecInfo struct {
	DynamicData

	// Unique name of the specification.
	Name string `xml:"name" json:"name"`
	// Description of the specification.
	Description string `xml:"description" json:"description"`
	// Guest operating system for this specification (Linux or Windows).
	Type string `xml:"type" json:"type"`
	// The changeVersion is a unique identifier for a given version
	// of the configuration.
	//
	// Each change to the configuration will
	// update this value. This is typically implemented as an ever
	// increasing count or a time-stamp. However, a client should
	// always treat this as an opaque string.
	//
	// If specified when updating a specification, the changes will only be
	// applied if the current changeVersion matches the specified changeVersion. This
	// field can be used to guard against updates that has happened
	// between the configInfo was read and until it is applied.
	ChangeVersion string `xml:"changeVersion,omitempty" json:"changeVersion,omitempty"`
	// Time when the specification was last modified.
	//
	// This time is ignored when
	// the CustomizationSpecItem containing this is used as an input to
	// CustomizationSpecManager.create.
	LastUpdateTime *time.Time `xml:"lastUpdateTime" json:"lastUpdateTime,omitempty"`
}

func init() {
	t["CustomizationSpecInfo"] = reflect.TypeOf((*CustomizationSpecInfo)(nil)).Elem()
}

// Specification information and the Specification object.
type CustomizationSpecItem struct {
	DynamicData

	// Information about the specification - name, description, and so on.
	Info CustomizationSpecInfo `xml:"info" json:"info"`
	// The customization specification.
	Spec CustomizationSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CustomizationSpecItem"] = reflect.TypeOf((*CustomizationSpecItem)(nil)).Elem()
}

type CustomizationSpecItemToXml CustomizationSpecItemToXmlRequestType

func init() {
	t["CustomizationSpecItemToXml"] = reflect.TypeOf((*CustomizationSpecItemToXml)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.CustomizationSpecItemToXml`.
type CustomizationSpecItemToXmlRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Item CustomizationSpecItem  `xml:"item" json:"item"`
}

func init() {
	t["CustomizationSpecItemToXmlRequestType"] = reflect.TypeOf((*CustomizationSpecItemToXmlRequestType)(nil)).Elem()
}

type CustomizationSpecItemToXmlResponse struct {
	Returnval string `xml:"returnval" json:"returnval"`
}

// The customization sequence has started in the VM guest.
type CustomizationStartedEvent struct {
	CustomizationEvent
}

func init() {
	t["CustomizationStartedEvent"] = reflect.TypeOf((*CustomizationStartedEvent)(nil)).Elem()
}

// Use stateless autoconfiguration to configure to ipv6 address
type CustomizationStatelessIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationStatelessIpV6Generator"] = reflect.TypeOf((*CustomizationStatelessIpV6Generator)(nil)).Elem()
}

// The customization sequence completed successfully in the guest.
type CustomizationSucceeded struct {
	CustomizationEvent
}

func init() {
	t["CustomizationSucceeded"] = reflect.TypeOf((*CustomizationSucceeded)(nil)).Elem()
}

// An object representation of a Windows `sysprep.xml` answer file.
//
// The sysprep
// type encloses all the individual keys listed in a `sysprep.xml` file. For
// more detailed information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
type CustomizationSysprep struct {
	CustomizationIdentitySettings

	// An object representation of the sysprep GuiUnattended key.
	GuiUnattended CustomizationGuiUnattended `xml:"guiUnattended" json:"guiUnattended"`
	// An object representation of the sysprep UserData key.
	UserData CustomizationUserData `xml:"userData" json:"userData"`
	// An object representation of the sysprep GuiRunOnce key.
	GuiRunOnce *CustomizationGuiRunOnce `xml:"guiRunOnce,omitempty" json:"guiRunOnce,omitempty"`
	// An object representation of the sysprep Identification key.
	Identification CustomizationIdentification `xml:"identification" json:"identification"`
	// An object representation of the sysprep LicenseFilePrintData key.
	//
	// Required only
	// for Windows 2000 Server and Windows Server 2003.
	LicenseFilePrintData *CustomizationLicenseFilePrintData `xml:"licenseFilePrintData,omitempty" json:"licenseFilePrintData,omitempty"`
}

func init() {
	t["CustomizationSysprep"] = reflect.TypeOf((*CustomizationSysprep)(nil)).Elem()
}

// Sysprep failed to run in the guest during customization.
//
// This will most like
// have been caused by the fact that the wrong sysprep was used for the guest,
// so we include the version information in the event.
type CustomizationSysprepFailed struct {
	CustomizationFailed

	// The version string for the sysprep files that were included in the
	// customization package.
	SysprepVersion string `xml:"sysprepVersion" json:"sysprepVersion"`
	// The version string for the system
	SystemVersion string `xml:"systemVersion" json:"systemVersion"`
}

func init() {
	t["CustomizationSysprepFailed"] = reflect.TypeOf((*CustomizationSysprepFailed)(nil)).Elem()
}

// An alternate way to specify the `sysprep.xml` answer file.
//
// This string is
// written to the `sysprep.xml` answer file on the target virtual disk.
type CustomizationSysprepText struct {
	CustomizationIdentitySettings

	// Text for the `sysprep.xml` answer file.
	//
	// For additional details, see <a href="https://kb.vmware.com/selfservice/microsites/search.do?language=en_US&cmd=displayKC&externalId=2151684"target="_blank">Using custom sysprep.xml for vCenter Guest Customization</a> and
	// <a href="https://kb.vmware.com/selfservice/microsites/search.do?language=en_US&cmd=displayKC&externalId=1029174"target="_blank">Specifying network settings in custom sysprep.xml</a>.
	Value string `xml:"value" json:"value"`
}

func init() {
	t["CustomizationSysprepText"] = reflect.TypeOf((*CustomizationSysprepText)(nil)).Elem()
}

// The customization sequence failed unexpectedly in the guest.
type CustomizationUnknownFailure struct {
	CustomizationFailed
}

func init() {
	t["CustomizationUnknownFailure"] = reflect.TypeOf((*CustomizationUnknownFailure)(nil)).Elem()
}

// The IP address is left unspecified.
//
// The user must be prompted to supply an IP
// address.
type CustomizationUnknownIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationUnknownIpGenerator"] = reflect.TypeOf((*CustomizationUnknownIpGenerator)(nil)).Elem()
}

// The ipv6 address is left unspecified.
//
// The user must be prompted to supply an ipv6
// address.
type CustomizationUnknownIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationUnknownIpV6Generator"] = reflect.TypeOf((*CustomizationUnknownIpV6Generator)(nil)).Elem()
}

// Indicates that the name is not specified in advance.
//
// The client should prompt the
// user for the value to complete the specification.
type CustomizationUnknownName struct {
	CustomizationName
}

func init() {
	t["CustomizationUnknownName"] = reflect.TypeOf((*CustomizationUnknownName)(nil)).Elem()
}

// Personal data pertaining to the owner of the virtual machine.
//
// The UserData data object type maps to the UserData key in the `sysprep.xml`
// answer file. These values are transferred directly into the `sysprep.xml`
// file that VirtualCenter stores on the target virtual disk. For more detailed
// information, see <a href="https://technet.microsoft.com/en-us/library/cc771830(v=ws.10).aspx"target="_blank">Performing Unattended Installations</a>.
type CustomizationUserData struct {
	DynamicData

	// User's full name.
	FullName string `xml:"fullName" json:"fullName"`
	// User's organization.
	OrgName string `xml:"orgName" json:"orgName"`
	// The computer name of the (Windows) virtual machine.
	//
	// Computer name may contain
	// letters (A-Z), numbers(0-9) and hyphens (-) but no spaces or periods (.).
	// The name may not consists entirely of digits.
	// Computer name is restricted to 15 characters in length. If the computer
	// name is longer than 15 characters, it will be truncated to 15 characters.
	ComputerName BaseCustomizationName `xml:"computerName,typeattr" json:"computerName"`
	// Microsoft Sysprep requires that a valid serial number be included in the answer
	// file when mini-setup runs.
	//
	// This serial number is ignored if the original guest
	// operating system was installed using a volume-licensed CD.
	ProductId string `xml:"productId" json:"productId"`
}

func init() {
	t["CustomizationUserData"] = reflect.TypeOf((*CustomizationUserData)(nil)).Elem()
}

// Specifies that VirtualCenter should generate a virtual machine name from a base
// prefix comprising the virtual machine entity name.
//
// A number is appended, if
// necessary, to make it unique.
//
// Virtual machine names are unique across the set of hosts and virtual machines known
// to the VirtualCenter instance. VMware Tools reports the names of existing virtual
// machines.
type CustomizationVirtualMachineName struct {
	CustomizationName
}

func init() {
	t["CustomizationVirtualMachineName"] = reflect.TypeOf((*CustomizationVirtualMachineName)(nil)).Elem()
}

// Optional operations supported by the customization process for Windows.
type CustomizationWinOptions struct {
	CustomizationOptions

	// The customization process should modify the machine's security identifier (SID).
	//
	// For Vista OS and greater, SID will always be modified and a value of false will
	// generate an error.
	ChangeSID bool `xml:"changeSID" json:"changeSID"`
	// Deprecated as of VI API 2.5, this value is ignored. Removing user accounts
	// during customization is no longer supported. To change the
	// administrator password, set the administrator password to
	// blank in the master vm. Sysprep will then be able to change the
	// password to the one specified by the `CustomizationGuiUnattended.password`.
	//
	// If deleteAccounts is true, then all user accounts are removed from the system as
	// part of the customization.
	//
	// Mini-setup creates a new Administrator account with a
	// blank password.
	DeleteAccounts bool `xml:"deleteAccounts" json:"deleteAccounts"`
	// A value of type SysprepRebootOption specifying the action that should be
	// taken after running sysprep.
	//
	// Defaults to "reboot".
	Reboot CustomizationSysprepRebootOption `xml:"reboot,omitempty" json:"reboot,omitempty"`
}

func init() {
	t["CustomizationWinOptions"] = reflect.TypeOf((*CustomizationWinOptions)(nil)).Elem()
}

// The parameters of `VirtualMachineGuestCustomizationManager.CustomizeGuest_Task`.
type CustomizeGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The Virtual Machine managed object reference.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// Is a `CustomizationSpec`.
	// It specifies the virtual machine's configuration.
	Spec CustomizationSpec `xml:"spec" json:"spec"`
	// addtional key/value pair list to support
	// third party customization.
	ConfigParams []BaseOptionValue `xml:"configParams,omitempty,typeattr" json:"configParams,omitempty"`
}

func init() {
	t["CustomizeGuestRequestType"] = reflect.TypeOf((*CustomizeGuestRequestType)(nil)).Elem()
}

type CustomizeGuest_Task CustomizeGuestRequestType

func init() {
	t["CustomizeGuest_Task"] = reflect.TypeOf((*CustomizeGuest_Task)(nil)).Elem()
}

type CustomizeGuest_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.CustomizeVM_Task`.
type CustomizeVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The customization specification object.
	Spec CustomizationSpec `xml:"spec" json:"spec"`
}

func init() {
	t["CustomizeVMRequestType"] = reflect.TypeOf((*CustomizeVMRequestType)(nil)).Elem()
}

type CustomizeVM_Task CustomizeVMRequestType

func init() {
	t["CustomizeVM_Task"] = reflect.TypeOf((*CustomizeVM_Task)(nil)).Elem()
}

type CustomizeVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Management related configuration of a DistributedVirtualPort.
type DVPortConfigInfo struct {
	DynamicData

	// The name of the port.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Deprecated as of vSphere API 5.5.
	//
	// The eligible entities that can connect to the port.
	//
	// If unset, there
	// is no restriction on which entity can connect to the port. If set,
	// only the entities in the specified list or their child entities are
	// allowed to connect to the port. If scopes are defined at both port
	// and portgroup level, they are taken as an "AND" relationship. If such
	// a relationship doesn't make sense, the reconfigure operation will
	// raise an exception.
	//
	// Refers instances of `ManagedEntity`.
	Scope []ManagedObjectReference `xml:"scope,omitempty" json:"scope,omitempty"`
	// A description string of the port.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The network configuration of the port.
	Setting BaseDVPortSetting `xml:"setting,omitempty,typeattr" json:"setting,omitempty"`
	// The version string of the configuration.
	ConfigVersion string `xml:"configVersion" json:"configVersion"`
}

func init() {
	t["DVPortConfigInfo"] = reflect.TypeOf((*DVPortConfigInfo)(nil)).Elem()
}

// Specification to reconfigure a `DistributedVirtualPort`.
type DVPortConfigSpec struct {
	DynamicData

	// The operation to remove or modify the existing ports.
	//
	// The valid values
	// are:
	//   - `edit`
	//   - `remove`
	Operation string `xml:"operation" json:"operation"`
	// Key of the port to be reconfigured.
	Key string `xml:"key,omitempty" json:"key,omitempty"`
	// The name of the port.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Deprecated as of vSphere API 5.5.
	//
	// The eligible entities that can connect to the port, for detail see
	// `DVPortConfigInfo.scope`.
	//
	// Refers instances of `ManagedEntity`.
	Scope []ManagedObjectReference `xml:"scope,omitempty" json:"scope,omitempty"`
	// The description string of the port.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The network setting of the port.
	Setting BaseDVPortSetting `xml:"setting,omitempty,typeattr" json:"setting,omitempty"`
	// The version string of the configuration.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
}

func init() {
	t["DVPortConfigSpec"] = reflect.TypeOf((*DVPortConfigSpec)(nil)).Elem()
}

// The virtual machine is configured to use a DVPort, which is not
// supported on the host.
//
// This could be because the host
// does not support VDS at all, or because the host has not
// joined a VDS.
type DVPortNotSupported struct {
	DeviceBackingNotSupported
}

func init() {
	t["DVPortNotSupported"] = reflect.TypeOf((*DVPortNotSupported)(nil)).Elem()
}

type DVPortNotSupportedFault DVPortNotSupported

func init() {
	t["DVPortNotSupportedFault"] = reflect.TypeOf((*DVPortNotSupportedFault)(nil)).Elem()
}

// The `DVPortSetting` data object
// describes the network configuration of a `DistributedVirtualPort`.
type DVPortSetting struct {
	DynamicData

	// Indicates whether this port is blocked.
	//
	// If a port is blocked,
	// packet forwarding is stopped.
	Blocked *BoolPolicy `xml:"blocked,omitempty" json:"blocked,omitempty"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer supported and
	// there is no replacement.
	//
	// Indicates whether this port is allowed to do VMDirectPath Gen2 network passthrough.
	//
	// Direct path capability is defined at host, switch, and device levels.
	// See the <code>vmDirectPathGen2Supported</code> properties on the
	// `DVSFeatureCapability`,
	// `HostCapability`, `PhysicalNic`,
	// and `VirtualEthernetCardOption` objects.
	VmDirectPathGen2Allowed *BoolPolicy `xml:"vmDirectPathGen2Allowed,omitempty" json:"vmDirectPathGen2Allowed,omitempty"`
	// Network shaping policy for controlling throughput of inbound traffic.
	InShapingPolicy *DVSTrafficShapingPolicy `xml:"inShapingPolicy,omitempty" json:"inShapingPolicy,omitempty"`
	// Network shaping policy for controlling throughput of outbound traffic.
	OutShapingPolicy *DVSTrafficShapingPolicy `xml:"outShapingPolicy,omitempty" json:"outShapingPolicy,omitempty"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig *DVSVendorSpecificConfig `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// Deprecated as of vSphere API 6.0
	// Use `DVPortgroupConfigInfo.vmVnicNetworkResourcePoolKey` instead
	// to reference the virtual NIC network resource pool.
	//
	// The key of user defined network resource pool to be associated with a port.
	//
	// The default value for this property is "-1", indicating that
	// this port is not associated with any network resource pool.
	NetworkResourcePoolKey *StringPolicy `xml:"networkResourcePoolKey,omitempty" json:"networkResourcePoolKey,omitempty"`
	// Configuration for Network Filter Policy.
	FilterPolicy *DvsFilterPolicy `xml:"filterPolicy,omitempty" json:"filterPolicy,omitempty"`
}

func init() {
	t["DVPortSetting"] = reflect.TypeOf((*DVPortSetting)(nil)).Elem()
}

// The state of a DistributedVirtualPort.
type DVPortState struct {
	DynamicData

	// Run time information of the port.
	//
	// This property is set only when the port is running.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
	// Statistics of the port.
	Stats DistributedVirtualSwitchPortStatistics `xml:"stats" json:"stats"`
	// Opaque binary blob that stores vendor-specific runtime state data.
	VendorSpecificState []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificState,omitempty" json:"vendorSpecificState,omitempty"`
}

func init() {
	t["DVPortState"] = reflect.TypeOf((*DVPortState)(nil)).Elem()
}

// The `DVPortStatus` data object
// contains runtime information about a `DistributedVirtualPort`.
type DVPortStatus struct {
	DynamicData

	// Indicates whether the port is in linkUp status.
	LinkUp bool `xml:"linkUp" json:"linkUp"`
	// Indicates whether the port is blocked by switch implementation.
	Blocked bool `xml:"blocked" json:"blocked"`
	// VLAN ID of the port.
	VlanIds []NumericRange `xml:"vlanIds,omitempty" json:"vlanIds,omitempty"`
	// True if the port VLAN tagging/stripping is disabled.
	TrunkingMode *bool `xml:"trunkingMode" json:"trunkingMode,omitempty"`
	// Maximum transmission unit (MTU) of the port.
	//
	// You can set the MTU only
	// at the switch level
	// (`VMwareDVSConfigSpec`).
	// If you attempt to change it at the portgroup or port level,
	// the Server throws an exception.
	Mtu int32 `xml:"mtu,omitempty" json:"mtu,omitempty"`
	// Name of the connected entity.
	LinkPeer string `xml:"linkPeer,omitempty" json:"linkPeer,omitempty"`
	// The MAC address that is used at this port.
	MacAddress string `xml:"macAddress,omitempty" json:"macAddress,omitempty"`
	// Additional information regarding the current status of the port.
	StatusDetail string `xml:"statusDetail,omitempty" json:"statusDetail,omitempty"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer
	// supported and there is no replacement.
	//
	// Indicates whether VMDirectPath Gen 2 is active on this port.
	//
	// If false, the reason(s) for inactivity will be provided in one or
	// more of `DVPortStatus.vmDirectPathGen2InactiveReasonNetwork`,
	// `DVPortStatus.vmDirectPathGen2InactiveReasonOther`,
	// and `DVPortStatus.vmDirectPathGen2InactiveReasonExtended`.
	//
	// If the host software is not capable of VMDirectPath Gen 2,
	// this property will be unset. See
	// `HostCapability*.*HostCapability.vmDirectPathGen2Supported`.
	VmDirectPathGen2Active *bool `xml:"vmDirectPathGen2Active" json:"vmDirectPathGen2Active,omitempty"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer
	// supported and there is no replacement.
	//
	// If `DVPortStatus.vmDirectPathGen2Active` is false, this array will be
	// populated with reasons for the inactivity that are related to network
	// state or configuration.
	//
	// The reasons are chosen from the
	// `DVPortStatusVmDirectPathGen2InactiveReasonNetwork_enum`
	// values.
	//
	// Other reasons for inactivity will be provided in
	// `DVPortStatus.vmDirectPathGen2InactiveReasonOther`. If there is a reason
	// for inactivity that cannot be described by the available constants,
	// `DVPortStatus.vmDirectPathGen2InactiveReasonExtended` will be populated
	// with an additional explanation provided by the platform.
	//
	// Note that this list of reasons is not guaranteed to be exhaustive.
	VmDirectPathGen2InactiveReasonNetwork []string `xml:"vmDirectPathGen2InactiveReasonNetwork,omitempty" json:"vmDirectPathGen2InactiveReasonNetwork,omitempty"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer
	// supported and there is no replacement.
	//
	// If `DVPortStatus.vmDirectPathGen2Active` is false, this array will be
	// populated with reasons for the inactivity that are not related to
	// network state or configuration.
	//
	// The reasons are chosen from the
	// `DVPortStatusVmDirectPathGen2InactiveReasonOther_enum`
	// values.
	//
	// Network-related reasons for inactivity will be provided in
	// `DVPortStatus.vmDirectPathGen2InactiveReasonNetwork`. If there is a reason
	// for inactivity that cannot be described by the available constants,
	// `DVPortStatus.vmDirectPathGen2InactiveReasonExtended` will be populated
	// with an additional explanation provided by the platform.
	//
	// Note that this list of reasons is not guaranteed to be exhaustive.
	//
	// See also `HostCapability.vmDirectPathGen2Supported`.
	VmDirectPathGen2InactiveReasonOther []string `xml:"vmDirectPathGen2InactiveReasonOther,omitempty" json:"vmDirectPathGen2InactiveReasonOther,omitempty"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer
	// supported and there is no replacement.
	//
	// If `DVPortStatus.vmDirectPathGen2Active` is false, this property may
	// contain an explanation provided by the platform, beyond the reasons
	// (if any) listed in `DVPortStatus.vmDirectPathGen2InactiveReasonNetwork`
	// and/or `DVPortStatus.vmDirectPathGen2InactiveReasonOther`.
	VmDirectPathGen2InactiveReasonExtended string `xml:"vmDirectPathGen2InactiveReasonExtended,omitempty" json:"vmDirectPathGen2InactiveReasonExtended,omitempty"`
}

func init() {
	t["DVPortStatus"] = reflect.TypeOf((*DVPortStatus)(nil)).Elem()
}

// The `DVPortgroupConfigInfo` data object defines
// the configuration of a `DistributedVirtualPortgroup`.
type DVPortgroupConfigInfo struct {
	DynamicData

	// Key of the portgroup.
	Key string `xml:"key" json:"key"`
	// Name of the portgroup.
	Name string `xml:"name" json:"name"`
	// Number of ports in the portgroup.
	NumPorts int32 `xml:"numPorts" json:"numPorts"`
	// Distributed virtual switch that the portgroup is defined on.
	//
	// This property should always be set unless the user's setting
	// does not have System.Read privilege on the object referred to
	// by this property.
	//
	// Refers instance of `DistributedVirtualSwitch`.
	DistributedVirtualSwitch *ManagedObjectReference `xml:"distributedVirtualSwitch,omitempty" json:"distributedVirtualSwitch,omitempty"`
	// Common network setting for all the ports in the portgroup.
	DefaultPortConfig BaseDVPortSetting `xml:"defaultPortConfig,omitempty,typeattr" json:"defaultPortConfig,omitempty"`
	// Description of the portgroup.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// Type of portgroup.
	//
	// See
	// `DistributedVirtualPortgroup*.*DistributedVirtualPortgroupPortgroupType_enum`
	// for possible values.
	Type string `xml:"type" json:"type"`
	// Backing type of portgroup.
	//
	// See
	// `DistributedVirtualPortgroup*.*DistributedVirtualPortgroupBackingType_enum`
	// for possible values.
	// The default value is "standard"
	BackingType string `xml:"backingType,omitempty" json:"backingType,omitempty"`
	// Portgroup policy.
	Policy BaseDVPortgroupPolicy `xml:"policy,typeattr" json:"policy"`
	// If set, a name will be automatically generated based on this format
	// string for a port when it is created in or moved into the portgroup.
	//
	// The format string can contain meta tags that will be resolved
	// to the corresponding values in generating a name, if applicable for
	// the port at the time of name generation.
	//
	// To insert a meta tag in the format string,
	// enclose the names defined as meta tag names inside angle brackets.
	// See `DistributedVirtualPortgroupMetaTagName_enum` for a list of
	// currently available meta tags. For example,
	// "redNetwork-&lt;portIndex&gt;" and "&lt;dvsName&gt;-pnic&lt;portIndex&gt;"
	// result in generated port names like "redNetwork-2" and "switch-pnic3".
	//
	// If a meta tag is recognized, but there is no applicable value, the tag
	// will be expanded to empty string. If an arbitrary name appears inside
	// a "&lt;&gt;" pair and is not recognized as one of the defined meta tags,
	// the substring is treated as-is and appear unchanged in the generated name.
	//
	// To prevent a meta tag from being expanded, prefix the meta tag with a
	// '\\' (backslash). For example, the format string "abc\\&lt;portIndex&gt;def"
	// results in the generated port name "abc&lt;portIndex&gt;def".
	PortNameFormat string `xml:"portNameFormat,omitempty" json:"portNameFormat,omitempty"`
	// Deprecated as of vSphere API 5.5.
	//
	// Eligible entities that can connect to the portgroup.
	//
	// If unset,
	// there is no restriction on which entity can connect to the portgroup.
	// If set, only the entities in the specified list or their child
	// entities are allowed to connect to the portgroup. If scopes are
	// defined at both port and portgroup level, they are taken as an "AND"
	// relationship. If such a relationship doesn't make sense, the
	// reconfigure operation will raise an exception.
	//
	// Refers instances of `ManagedEntity`.
	Scope []ManagedObjectReference `xml:"scope,omitempty" json:"scope,omitempty"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// Configuration version number.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
	// If set to true, this property ignores the limit on the number of ports in the
	// portgroup.
	//
	// When a Virtual Machine/Host tries to connect to the portgroup and there
	// are no free ports available in the portgroup, new ports will be automatically
	// added to the portgroup. The flag is currently supported only for static portgroups.
	//
	// When this property is set to true, the portgroup becomes a potential candidate for
	// auto-shrink. Once the portgroup has auto-expanded then its disconnected ports are
	// likely to be deleted automatically, as a part of auto-shrink step, if there are more
	// than certain number of free ports. If the portgroup never auto-expanded, then it will
	// never lose any free ports.
	AutoExpand *bool `xml:"autoExpand" json:"autoExpand,omitempty"`
	// The key of virtual NIC network resource pool to be associated with a portgroup.
	//
	// The default value for this property is unset, indicating that
	// this portgroup is not associated with any virtual NIC network resource pool.
	// To clear the value of this property and revert to unset, set the
	// `DVPortgroupConfigSpec.vmVnicNetworkResourcePoolKey`
	// to "-1" in an update operation.
	VmVnicNetworkResourcePoolKey string `xml:"vmVnicNetworkResourcePoolKey,omitempty" json:"vmVnicNetworkResourcePoolKey,omitempty"`
	// Indicates whether the portgroup is an uplink portroup.
	Uplink *bool `xml:"uplink" json:"uplink,omitempty"`
	// The UUID of transport zone to be associated with a NSX portgroup.
	TransportZoneUuid string `xml:"transportZoneUuid,omitempty" json:"transportZoneUuid,omitempty"`
	// The name of transport zone to be associated with a NSX portgroup.
	TransportZoneName string `xml:"transportZoneName,omitempty" json:"transportZoneName,omitempty"`
	// The logical switch UUID, which is used by NSX portgroup
	LogicalSwitchUuid string `xml:"logicalSwitchUuid,omitempty" json:"logicalSwitchUuid,omitempty"`
	// The segment ID of logical switch
	SegmentId string `xml:"segmentId,omitempty" json:"segmentId,omitempty"`
}

func init() {
	t["DVPortgroupConfigInfo"] = reflect.TypeOf((*DVPortgroupConfigInfo)(nil)).Elem()
}

// The `DVPortgroupConfigSpec`
// data object contains configuration data for a
// `DistributedVirtualPortgroup`.
//
// Use the
// `DistributedVirtualPortgroup.ReconfigureDVPortgroup_Task`
// method to apply the configuration to the portgroup.
type DVPortgroupConfigSpec struct {
	DynamicData

	// Version string of the configuration that this spec is trying to
	// change.
	//
	// This property is required in reconfiguring a portgroup and
	// should be set to the same value as the
	// `DVPortgroupConfigInfo.configVersion`.
	// This property is ignored in creating a portgroup if set.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
	// Name of the portgroup.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Number of ports in the portgroup.
	//
	// Setting this number larger than the
	// number of existing ports in the portgroup causes new ports to
	// be added to the portgroup to meet the number. Setting this property
	// smaller than the number of existing ports deletes the free ports
	// from the portgroup. If the number cannot be met by deleting free ports,
	// a fault is raised. If new ports are added to the portgroup, they
	// are also added to the switch. For portgroups of type ephemeral this
	// property is ignored.
	NumPorts int32 `xml:"numPorts,omitempty" json:"numPorts,omitempty"`
	// Format of the name of the ports when ports are created in the portgroup.
	//
	// For details see `DVPortgroupConfigInfo.portNameFormat`.
	PortNameFormat string `xml:"portNameFormat,omitempty" json:"portNameFormat,omitempty"`
	// Default network setting for all the ports in the portgroup.
	DefaultPortConfig BaseDVPortSetting `xml:"defaultPortConfig,omitempty,typeattr" json:"defaultPortConfig,omitempty"`
	// Description of the portgroup.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// Type of portgroup.
	//
	// See
	// `DistributedVirtualPortgroup*.*DistributedVirtualPortgroupPortgroupType_enum`
	// for possible values.
	Type string `xml:"type,omitempty" json:"type,omitempty"`
	// Backing type of portgroup.
	//
	// See
	// `DistributedVirtualPortgroup*.*DistributedVirtualPortgroupBackingType_enum`
	// for possible values.
	// The default value is "standard"
	BackingType string `xml:"backingType,omitempty" json:"backingType,omitempty"`
	// Deprecated as of vSphere API 5.5.
	//
	// Eligible entities that can connect to the port.
	//
	// See
	// `DVPortgroupConfigInfo*.*DVPortgroupConfigInfo.scope`.
	//
	// Refers instances of `ManagedEntity`.
	Scope []ManagedObjectReference `xml:"scope,omitempty" json:"scope,omitempty"`
	// Portgroup policy.
	Policy BaseDVPortgroupPolicy `xml:"policy,omitempty,typeattr" json:"policy,omitempty"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// If set to true, this property ignores the limit on the number of ports in the
	// portgroup.
	//
	// When a Virtual Machine/Host tries to connect to the portgroup and there
	// are no free ports available in the portgroup, new ports will be automatically
	// added to the portgroup. The flag is currently supported only for static portgroups.
	//
	// Setting this property to true makes the portgroup a potential candidate for
	// auto-shrink. Once the portgroup has auto-expanded then its disconnected ports are
	// likely to be deleted automatically, as a part of auto-shrink step, if there are more
	// than certain number of free ports. If the portgroup never auto-expanded, then it will
	// never lose any free ports.
	AutoExpand *bool `xml:"autoExpand" json:"autoExpand,omitempty"`
	// The key of virtual NIC network resource pool to be associated with a portgroup.
	//
	// Setting this property to "-1", would mean that this portgroup
	// is not associated with any virtual NIC network resource pool.
	VmVnicNetworkResourcePoolKey string `xml:"vmVnicNetworkResourcePoolKey,omitempty" json:"vmVnicNetworkResourcePoolKey,omitempty"`
	// The UUID of transport zone to be associated with a NSX portgroup.
	TransportZoneUuid string `xml:"transportZoneUuid,omitempty" json:"transportZoneUuid,omitempty"`
	// The name of transport zone to be associated with a NSX portgroup.
	TransportZoneName string `xml:"transportZoneName,omitempty" json:"transportZoneName,omitempty"`
	// The logical switch UUID, which is used by NSX portgroup
	LogicalSwitchUuid string `xml:"logicalSwitchUuid,omitempty" json:"logicalSwitchUuid,omitempty"`
	// The segment ID of logical switch
	SegmentId string `xml:"segmentId,omitempty" json:"segmentId,omitempty"`
}

func init() {
	t["DVPortgroupConfigSpec"] = reflect.TypeOf((*DVPortgroupConfigSpec)(nil)).Elem()
}

// Two distributed virtual portgroup was created.
type DVPortgroupCreatedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupCreatedEvent"] = reflect.TypeOf((*DVPortgroupCreatedEvent)(nil)).Elem()
}

// Two distributed virtual portgroup was destroyed.
type DVPortgroupDestroyedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupDestroyedEvent"] = reflect.TypeOf((*DVPortgroupDestroyedEvent)(nil)).Elem()
}

// DVPortgroup related events.
type DVPortgroupEvent struct {
	Event
}

func init() {
	t["DVPortgroupEvent"] = reflect.TypeOf((*DVPortgroupEvent)(nil)).Elem()
}

// The DistributedVirtualPortgroup policies.
//
// This field is not applicable
// when queried directly against an ESX host.
type DVPortgroupPolicy struct {
	DynamicData

	// Allow the `DVPortSetting.blocked` setting
	// of an individual port to override the setting in
	// `DVPortgroupConfigInfo.defaultPortConfig` of
	// a portgroup.
	BlockOverrideAllowed bool `xml:"blockOverrideAllowed" json:"blockOverrideAllowed"`
	// Allow the `DVPortSetting.inShapingPolicy` or
	// `DVPortSetting.outShapingPolicy` settings
	// of an individual port to override the setting in
	// `DVPortgroupConfigInfo.defaultPortConfig` of
	// a portgroup.
	ShapingOverrideAllowed bool `xml:"shapingOverrideAllowed" json:"shapingOverrideAllowed"`
	// Allow the `DVPortSetting.vendorSpecificConfig`
	// setting of an individual port to override the setting in
	// `DVPortgroupConfigInfo.defaultPortConfig` of
	// a portgroup.
	VendorConfigOverrideAllowed bool `xml:"vendorConfigOverrideAllowed" json:"vendorConfigOverrideAllowed"`
	// Allow a live port to be moved in and out of the portgroup.
	LivePortMovingAllowed bool `xml:"livePortMovingAllowed" json:"livePortMovingAllowed"`
	// If true, reset the port network setting back to the portgroup setting
	// (thus removing the per-port setting) when the port is disconnected from
	// the connectee.
	PortConfigResetAtDisconnect bool `xml:"portConfigResetAtDisconnect" json:"portConfigResetAtDisconnect"`
	// Allow the setting of
	// `DVPortSetting.networkResourcePoolKey` of an
	// individual port to override the setting in
	// `DVPortgroupConfigInfo.defaultPortConfig`
	// of a portgroup.
	NetworkResourcePoolOverrideAllowed *bool `xml:"networkResourcePoolOverrideAllowed" json:"networkResourcePoolOverrideAllowed,omitempty"`
	// Allow the setting of
	// `DVPortSetting.filterPolicy`,
	// for an individual port to override the setting in
	// `DVPortgroupConfigInfo.defaultPortConfig` of
	// a portgroup.
	TrafficFilterOverrideAllowed *bool `xml:"trafficFilterOverrideAllowed" json:"trafficFilterOverrideAllowed,omitempty"`
}

func init() {
	t["DVPortgroupPolicy"] = reflect.TypeOf((*DVPortgroupPolicy)(nil)).Elem()
}

// Two distributed virtual portgroup was reconfigured.
type DVPortgroupReconfiguredEvent struct {
	DVPortgroupEvent

	// The reconfiguration spec.
	ConfigSpec DVPortgroupConfigSpec `xml:"configSpec" json:"configSpec"`
	// The configuration values changed during the reconfiguration.
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty" json:"configChanges,omitempty"`
}

func init() {
	t["DVPortgroupReconfiguredEvent"] = reflect.TypeOf((*DVPortgroupReconfiguredEvent)(nil)).Elem()
}

// Two distributed virtual portgroup was renamed.
type DVPortgroupRenamedEvent struct {
	DVPortgroupEvent

	// The old portgroup name.
	OldName string `xml:"oldName" json:"oldName"`
	// The new portgroup name.
	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["DVPortgroupRenamedEvent"] = reflect.TypeOf((*DVPortgroupRenamedEvent)(nil)).Elem()
}

// The parameters of `DistributedVirtualPortgroup.DVPortgroupRollback_Task`.
type DVPortgroupRollbackRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The backup of Distributed Virtual PortGroup entity.
	EntityBackup *EntityBackupConfig `xml:"entityBackup,omitempty" json:"entityBackup,omitempty"`
}

func init() {
	t["DVPortgroupRollbackRequestType"] = reflect.TypeOf((*DVPortgroupRollbackRequestType)(nil)).Elem()
}

type DVPortgroupRollback_Task DVPortgroupRollbackRequestType

func init() {
	t["DVPortgroupRollback_Task"] = reflect.TypeOf((*DVPortgroupRollback_Task)(nil)).Elem()
}

type DVPortgroupRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// Class to specify selection criteria of list of vNetwork Distributed Portgroups.
type DVPortgroupSelection struct {
	SelectionSet

	// vSphere Distributed Switch uuid
	DvsUuid string `xml:"dvsUuid" json:"dvsUuid"`
	// List of vNetwork Distributed Portgroup keys
	PortgroupKey []string `xml:"portgroupKey" json:"portgroupKey"`
}

func init() {
	t["DVPortgroupSelection"] = reflect.TypeOf((*DVPortgroupSelection)(nil)).Elem()
}

// The `DVSBackupRestoreCapability` data object
// describes backup, restore, and rollback capabilities for distributed virtual
// switches and distributed virtual portgroups.
//
// Backup and restore capabilities are indicated for `DistributedVirtualSwitch`.
// Rollback capability is indicated for `DistributedVirtualSwitch`
// and `DistributedVirtualPortgroup`.
type DVSBackupRestoreCapability struct {
	DynamicData

	// Indicates whether backup, restore, and rollback are supported.
	BackupRestoreSupported bool `xml:"backupRestoreSupported" json:"backupRestoreSupported"`
}

func init() {
	t["DVSBackupRestoreCapability"] = reflect.TypeOf((*DVSBackupRestoreCapability)(nil)).Elem()
}

// The `DVSCapability` data object
// describes the distributed virtual switch features and indicates
// the level of configuration that is allowed.
type DVSCapability struct {
	DynamicData

	// Indicates whether this switch allows vCenter users to modify
	// the switch configuration at the switch level,
	// except for host member, policy, and scope operations.
	DvsOperationSupported *bool `xml:"dvsOperationSupported" json:"dvsOperationSupported,omitempty"`
	// Indicates whether this switch allows vCenter users to modify
	// the switch configuration at the portgroup level,
	// except for host member, policy, and scope operations.
	DvPortGroupOperationSupported *bool `xml:"dvPortGroupOperationSupported" json:"dvPortGroupOperationSupported,omitempty"`
	// Indicates whether this switch allows vCenter users to modify
	// the switch configuration at the port level,
	// except for host member, policy, and scope operations.
	DvPortOperationSupported *bool `xml:"dvPortOperationSupported" json:"dvPortOperationSupported,omitempty"`
	// List of host component product information that is compatible
	// with the current switch implementation.
	CompatibleHostComponentProductInfo []DistributedVirtualSwitchHostProductSpec `xml:"compatibleHostComponentProductInfo,omitempty" json:"compatibleHostComponentProductInfo,omitempty"`
	// Indicators for which version-specific distributed virtual switch
	// features are available on this switch.
	//
	// This information is read-only, with the following exception.
	// For a third-party distributed switch implementation, you can
	// set the property
	// `DVSFeatureCapability*.*DVSFeatureCapability.vmDirectPathGen2Supported`
	// during switch creation or when you call the
	// `DistributedVirtualSwitch.UpdateDvsCapability` method.
	FeaturesSupported BaseDVSFeatureCapability `xml:"featuresSupported,omitempty,typeattr" json:"featuresSupported,omitempty"`
}

func init() {
	t["DVSCapability"] = reflect.TypeOf((*DVSCapability)(nil)).Elem()
}

// Configuration of a `DistributedVirtualSwitch`.
type DVSConfigInfo struct {
	DynamicData

	// Generated UUID of the switch.
	//
	// Unique across vCenter Server
	// inventory and instances.
	Uuid string `xml:"uuid" json:"uuid"`
	// Name of the switch.
	Name string `xml:"name" json:"name"`
	// Number of standalone ports in the switch.
	//
	// Standalone ports are
	// ports that do not belong to any portgroup.
	NumStandalonePorts int32 `xml:"numStandalonePorts" json:"numStandalonePorts"`
	// Current number of ports, not including conflict ports.
	NumPorts int32 `xml:"numPorts" json:"numPorts"`
	// Maximum number of ports allowed in the switch,
	// not including conflict ports.
	MaxPorts int32 `xml:"maxPorts" json:"maxPorts"`
	// Uplink port policy.
	UplinkPortPolicy BaseDVSUplinkPortPolicy `xml:"uplinkPortPolicy,typeattr" json:"uplinkPortPolicy"`
	// List of uplink portgroups.
	//
	// When adding host members, the server
	// uses the `DVSConfigInfo.uplinkPortPolicy` to create a number of
	// uplink ports for the host. If portgroups are shown here,
	// those uplink ports will be added to the portgroups, with uplink ports
	// evenly spread among the portgroups.
	//
	// Refers instances of `DistributedVirtualPortgroup`.
	UplinkPortgroup []ManagedObjectReference `xml:"uplinkPortgroup,omitempty" json:"uplinkPortgroup,omitempty"`
	// Default configuration for the ports in the switch, if the port
	// does not inherit configuration from the parent portgroup or has
	// its own configuration.
	DefaultPortConfig BaseDVPortSetting `xml:"defaultPortConfig,typeattr" json:"defaultPortConfig"`
	// Hosts that join the switch.
	Host []DistributedVirtualSwitchHostMember `xml:"host,omitempty" json:"host,omitempty"`
	// Vendor, product, and version information for the implementation
	// module of the switch.
	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo" json:"productInfo"`
	// Intended vendor, product, and version information for the
	// implementation module of the switch.
	TargetInfo *DistributedVirtualSwitchProductSpec `xml:"targetInfo,omitempty" json:"targetInfo,omitempty"`
	// Key of the extension registered by the remote server that
	// controls the switch.
	ExtensionKey string `xml:"extensionKey,omitempty" json:"extensionKey,omitempty"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// Usage policy of the switch.
	Policy *DVSPolicy `xml:"policy,omitempty" json:"policy,omitempty"`
	// Description string for the switch.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// Version string of the configuration.
	ConfigVersion string `xml:"configVersion" json:"configVersion"`
	// Human operator contact information.
	Contact DVSContactInfo `xml:"contact" json:"contact"`
	// IP address for the switch, specified using IPv4 dot notation.
	//
	// The
	// utility of this address is defined by other switch features.
	SwitchIpAddress string `xml:"switchIpAddress,omitempty" json:"switchIpAddress,omitempty"`
	// Create time of the switch.
	CreateTime time.Time `xml:"createTime" json:"createTime"`
	// Boolean to indicate if network I/O control is enabled on the
	// switch.
	NetworkResourceManagementEnabled *bool `xml:"networkResourceManagementEnabled" json:"networkResourceManagementEnabled,omitempty"`
	// Default host proxy switch maximum port number
	DefaultProxySwitchMaxNumPorts int32 `xml:"defaultProxySwitchMaxNumPorts,omitempty" json:"defaultProxySwitchMaxNumPorts,omitempty"`
	// VDS health check configuration.
	HealthCheckConfig []BaseDVSHealthCheckConfig `xml:"healthCheckConfig,omitempty,typeattr" json:"healthCheckConfig,omitempty"`
	// Host infrastructure traffic class resource configuration.
	InfrastructureTrafficResourceConfig []DvsHostInfrastructureTrafficResource `xml:"infrastructureTrafficResourceConfig,omitempty" json:"infrastructureTrafficResourceConfig,omitempty"`
	// Dynamic Host infrastructure traffic class resource configuration.
	NetResourcePoolTrafficResourceConfig []DvsHostInfrastructureTrafficResource `xml:"netResourcePoolTrafficResourceConfig,omitempty" json:"netResourcePoolTrafficResourceConfig,omitempty"`
	// Network resource control version of the switch.
	//
	// Possible value can be of
	// `DistributedVirtualSwitchNetworkResourceControlVersion_enum`.
	NetworkResourceControlVersion string `xml:"networkResourceControlVersion,omitempty" json:"networkResourceControlVersion,omitempty"`
	// The Virtual NIC network resource pool information for the switch.
	VmVnicNetworkResourcePool []DVSVmVnicNetworkResourcePool `xml:"vmVnicNetworkResourcePool,omitempty" json:"vmVnicNetworkResourcePool,omitempty"`
	// The percentage of physical nic link speed
	// `PhysicalNicLinkInfo.speedMb`
	// available for infrastructure traffic reservation.
	//
	// If this value is 75, then for a 1Gbps physical nic, only
	// 750Mbps is allowed for all infrastructure traffic reservations.
	PnicCapacityRatioForReservation int32 `xml:"pnicCapacityRatioForReservation,omitempty" json:"pnicCapacityRatioForReservation,omitempty"`
}

func init() {
	t["DVSConfigInfo"] = reflect.TypeOf((*DVSConfigInfo)(nil)).Elem()
}

// The `DVSConfigSpec`
// data object contains configuration data for a
// `DistributedVirtualSwitch`.
//
// Use the `DistributedVirtualSwitch.ReconfigureDvs_Task`
// method to apply the configuration to the
// switch.
type DVSConfigSpec struct {
	DynamicData

	// The version string of the configuration that this spec is trying to
	// change.
	//
	// This property is required in reconfiguring a switch
	// and should be set to the same value as
	// `DVSConfigInfo.configVersion`.
	// This property is ignored during switch creation.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
	// The name of the switch.
	//
	// Must be unique in the parent folder.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// The number of standalone ports in the switch.
	//
	// Standalone ports are
	// ports that do not belong to any portgroup. If set to a number larger
	// than number of existing standalone ports in the switch, new ports get
	// created to meet the number. If set to a number smaller than the number
	// of existing standalone ports, free ports (uplink ports excluded) are
	// deleted to meet the number. If the set number cannot be met by
	// deleting free standalone ports, a fault is raised.
	NumStandalonePorts int32 `xml:"numStandalonePorts,omitempty" json:"numStandalonePorts,omitempty"`
	// Deprecated as of vSphere API 5.0
	// The default value of this propoerty is maxint and there is no reason
	// for users to change it to a lower value.
	//
	// The maximum number of DistributedVirtualPorts allowed in the switch.
	//
	// If specified in a reconfigure operation, this number cannot be smaller
	// than the number of existing DistributedVirtualPorts.
	MaxPorts int32 `xml:"maxPorts,omitempty" json:"maxPorts,omitempty"`
	// The uplink port policy.
	UplinkPortPolicy BaseDVSUplinkPortPolicy `xml:"uplinkPortPolicy,omitempty,typeattr" json:"uplinkPortPolicy,omitempty"`
	// The uplink portgroups.
	//
	// Refers instances of `DistributedVirtualPortgroup`.
	UplinkPortgroup []ManagedObjectReference `xml:"uplinkPortgroup,omitempty" json:"uplinkPortgroup,omitempty"`
	// The default configuration for ports.
	DefaultPortConfig BaseDVPortSetting `xml:"defaultPortConfig,omitempty,typeattr" json:"defaultPortConfig,omitempty"`
	// The host member specification.
	//
	// A particular host should have only one entry
	// in this array. Duplicate entries for the same host will raise a fault.
	// The host version should be compatible with the version of
	// `DistributedVirtualSwitch`. Use
	// `DistributedVirtualSwitchManager.QueryDvsCheckCompatibility`
	// to check for compatibility.
	Host []DistributedVirtualSwitchHostMemberConfigSpec `xml:"host,omitempty" json:"host,omitempty"`
	// The key of the extension registered by a remote server that
	// controls the switch.
	ExtensionKey string `xml:"extensionKey,omitempty" json:"extensionKey,omitempty"`
	// Set the description string of the switch.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The usage policy of the switch.
	Policy *DVSPolicy `xml:"policy,omitempty" json:"policy,omitempty"`
	// Set the opaque blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// Set the human operator contact information.
	Contact *DVSContactInfo `xml:"contact,omitempty" json:"contact,omitempty"`
	// IP address for the switch, specified using IPv4 dot notation.
	//
	// IPv6 address is not supported for this property.
	// The utility of this address is defined by other switch features.
	// switchIpAddress would be ignored when IPFIX collector uses IPv6.
	SwitchIpAddress string `xml:"switchIpAddress,omitempty" json:"switchIpAddress,omitempty"`
	// The default host proxy switch maximum port number
	DefaultProxySwitchMaxNumPorts int32 `xml:"defaultProxySwitchMaxNumPorts,omitempty" json:"defaultProxySwitchMaxNumPorts,omitempty"`
	// The host infrastructure traffic resource allocation specification.
	//
	// Only the traffic class resource allocations identified in the list
	// will be updated. The other traffic class resource allocations that are not
	// specified will not change.
	InfrastructureTrafficResourceConfig []DvsHostInfrastructureTrafficResource `xml:"infrastructureTrafficResourceConfig,omitempty" json:"infrastructureTrafficResourceConfig,omitempty"`
	// The dynamic host infrastructure traffic resource allocation
	// specification.
	NetResourcePoolTrafficResourceConfig []DvsHostInfrastructureTrafficResource `xml:"netResourcePoolTrafficResourceConfig,omitempty" json:"netResourcePoolTrafficResourceConfig,omitempty"`
	// Indicates the Network Resource Control APIs that are supported on the switch.
	//
	// Possible value can be of
	// `DistributedVirtualSwitchNetworkResourceControlVersion_enum`.
	NetworkResourceControlVersion string `xml:"networkResourceControlVersion,omitempty" json:"networkResourceControlVersion,omitempty"`
}

func init() {
	t["DVSConfigSpec"] = reflect.TypeOf((*DVSConfigSpec)(nil)).Elem()
}

// Contact information of a human operator.
type DVSContactInfo struct {
	DynamicData

	// The name of the person who is responsible for the switch.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// The contact information for the person.
	Contact string `xml:"contact,omitempty" json:"contact,omitempty"`
}

func init() {
	t["DVSContactInfo"] = reflect.TypeOf((*DVSContactInfo)(nil)).Elem()
}

// Specification to create a `DistributedVirtualSwitch`.
type DVSCreateSpec struct {
	DynamicData

	// Configuration data.
	ConfigSpec BaseDVSConfigSpec `xml:"configSpec,typeattr" json:"configSpec"`
	// Product information for this switch implementation.
	//
	// If you
	// do not specify this property, the Server will use the latest
	// version to create the `DistributedVirtualSwitch`.
	ProductInfo *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty" json:"productInfo,omitempty"`
	// Capability of the switch.
	Capability *DVSCapability `xml:"capability,omitempty" json:"capability,omitempty"`
}

func init() {
	t["DVSCreateSpec"] = reflect.TypeOf((*DVSCreateSpec)(nil)).Elem()
}

// This data object type describes the network adapter failover
// detection algorithm for a network adapter team.
type DVSFailureCriteria struct {
	InheritablePolicy

	// To use link speed as the criteria, _checkSpeed_ must be one of
	// the following values:
	//   - `*exact*`: Use exact speed to detect link failure.
	//     `*speed*` is the configured exact speed in megabits per second.
	//   - `*minimum*`: Use minimum speed to detect failure.
	//     `*speed*` is the configured minimum speed in megabits per second.
	//   - **empty string**: Do not use link speed to detect failure.
	//     `*speed*` is unused in this case.
	CheckSpeed *StringPolicy `xml:"checkSpeed,omitempty" json:"checkSpeed,omitempty"`
	// See also `DVSFailureCriteria.checkSpeed`.
	Speed *IntPolicy `xml:"speed,omitempty" json:"speed,omitempty"`
	// The flag to indicate whether or not to use the link duplex reported
	// by the driver as link selection criteria.
	//
	// If `*checkDuplex*` is true, then fullDuplex is the configured
	// duplex mode. The link is considered bad if the link duplex reported
	// by driver is not the same as fullDuplex.
	//
	// If `*checkDuplex*` is false, then fullDuplex is unused, and
	// link duplexity is not used as a detection method.
	CheckDuplex *BoolPolicy `xml:"checkDuplex,omitempty" json:"checkDuplex,omitempty"`
	// See also `DVSFailureCriteria.checkDuplex`.
	FullDuplex *BoolPolicy `xml:"fullDuplex,omitempty" json:"fullDuplex,omitempty"`
	// The flag to indicate whether or not to use link error percentage
	// to detect failure.
	//
	// If `*checkErrorPercent*` is true, then percentage is the configured
	// error percentage that is tolerated. The link is considered bad
	// if error rate exceeds percentage.
	//
	// If `*checkErrorPercent*` is false, percentage is unused, and
	// error percentage is not used as a detection method.
	CheckErrorPercent *BoolPolicy `xml:"checkErrorPercent,omitempty" json:"checkErrorPercent,omitempty"`
	// See also `DVSFailureCriteria.checkErrorPercent`.
	Percentage *IntPolicy `xml:"percentage,omitempty" json:"percentage,omitempty"`
	// The flag to indicate whether or not to enable this property to
	// enable beacon probing as a method to validate
	// the link status of a physical network adapter.
	//
	// `*checkBeacon*` can be enabled only if the VirtualSwitch has been
	// configured to use the beacon. Attempting to set `*checkBeacon*`
	// on a PortGroup or VirtualSwitch that does not have beacon probing
	// configured for the applicable VirtualSwitch results in an error.
	CheckBeacon *BoolPolicy `xml:"checkBeacon,omitempty" json:"checkBeacon,omitempty"`
}

func init() {
	t["DVSFailureCriteria"] = reflect.TypeOf((*DVSFailureCriteria)(nil)).Elem()
}

// The `DVSFeatureCapability` data object
// represents the capabilities supported by a
// `DistributedVirtualSwitch`.
//
// These properties are read-only with
// the exception of
// `DVSFeatureCapability.vmDirectPathGen2Supported`.
type DVSFeatureCapability struct {
	DynamicData

	// Deprecated as of vSphere API 5.0, use
	// <code>networkResourceManagementCapability</code>.`DVSNetworkResourceManagementCapability.networkResourceManagementSupported`.
	//
	// Indicates whether network I/O control is
	// supported on the vSphere Distributed Switch.
	NetworkResourceManagementSupported bool `xml:"networkResourceManagementSupported" json:"networkResourceManagementSupported"`
	// Deprecated as of vSphere API 8.0. VMDirectPath Gen 2 is no longer supported and
	// there is no replacement.
	//
	// Indicates whether VMDirectPath Gen 2 is supported on the
	// distributed virtual switch.
	//
	// See
	// `HostCapability*.*HostCapability.vmDirectPathGen2Supported`
	// and `PhysicalNic*.*PhysicalNic.vmDirectPathGen2Supported`.
	//
	// For a third-party distributed switch implementation, you can
	// specify this property during switch creation or when you call the
	// `DistributedVirtualSwitch.UpdateDvsCapability` method.
	//
	// VMDirectPath Gen 2 is supported in
	// vSphere Distributed Switch Version 4.1 or later.
	VmDirectPathGen2Supported *bool `xml:"vmDirectPathGen2Supported" json:"vmDirectPathGen2Supported,omitempty"`
	// The available teaming modes for the vSphere Distributed Switch.
	//
	// The
	// value can be one or more of
	// `DistributedVirtualSwitchNicTeamingPolicyMode_enum`.
	NicTeamingPolicy []string `xml:"nicTeamingPolicy,omitempty" json:"nicTeamingPolicy,omitempty"`
	// Deprecated as of vSphere API 5.0, use
	// <code>networkResourceManagementCapability</code>.`DVSNetworkResourceManagementCapability.networkResourcePoolHighShareValue`.
	//
	// This is the value for `high`
	// in `DVSNetworkResourcePoolAllocationInfo.shares`.
	//
	// This
	// implicitly defines the legal range of share values to be between 1 and this.
	// This also defines values for other level types, such as
	// `normal` being one half of this value and
	// `low` being one fourth of this value.
	NetworkResourcePoolHighShareValue int32 `xml:"networkResourcePoolHighShareValue,omitempty" json:"networkResourcePoolHighShareValue,omitempty"`
	// Network resource management capabilities supported by a
	// distributed virtual switch.
	NetworkResourceManagementCapability *DVSNetworkResourceManagementCapability `xml:"networkResourceManagementCapability,omitempty" json:"networkResourceManagementCapability,omitempty"`
	// Health check capabilities supported by a `VmwareDistributedVirtualSwitch`.
	HealthCheckCapability BaseDVSHealthCheckCapability `xml:"healthCheckCapability,omitempty,typeattr" json:"healthCheckCapability,omitempty"`
	// Host rollback capability.
	//
	// If <code>rollbackCapability</code>.`DVSRollbackCapability.rollbackSupported`
	// is true, network operations that disconnect the the host are rolled back.
	RollbackCapability *DVSRollbackCapability `xml:"rollbackCapability,omitempty" json:"rollbackCapability,omitempty"`
	// Backup, restore, and rollback capabilities.
	//
	// Backup and restore
	// are supported only for `VmwareDistributedVirtualSwitch`.
	// Rollback is supported for `VmwareDistributedVirtualSwitch`
	// and `DistributedVirtualPortgroup`.
	// For information about backup and restore, see the
	// `DistributedVirtualSwitchManager` methods
	// `DistributedVirtualSwitchManager.DVSManagerExportEntity_Task` and
	// `DistributedVirtualSwitchManager.DVSManagerImportEntity_Task`.
	// For information about rollback, see the
	// `DistributedVirtualSwitch*.*DistributedVirtualSwitch.DVSRollback_Task`
	// and `DistributedVirtualPortgroup*.*DistributedVirtualPortgroup.DVPortgroupRollback_Task`
	// methods.
	BackupRestoreCapability *DVSBackupRestoreCapability `xml:"backupRestoreCapability,omitempty" json:"backupRestoreCapability,omitempty"`
	// Indicates whether Network Filter feature is
	// supported in vSphere Distributed Switch.
	NetworkFilterSupported *bool `xml:"networkFilterSupported" json:"networkFilterSupported,omitempty"`
	// Indicates whether MAC learning feature is
	// supported in vSphere Distributed Switch.
	MacLearningSupported *bool `xml:"macLearningSupported" json:"macLearningSupported,omitempty"`
}

func init() {
	t["DVSFeatureCapability"] = reflect.TypeOf((*DVSFeatureCapability)(nil)).Elem()
}

// Base class for connectee filters.
//
// This class serves as a base for different types of connectee filters.
// It has three sub-classes.
type DVSFilterSpecConnecteeSpec struct {
	DynamicData
}

func init() {
	t["DVSFilterSpecConnecteeSpec"] = reflect.TypeOf((*DVSFilterSpecConnecteeSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecConnecteeSpec"] = "8.0.3.0"
}

// Sub-class for connectee filters.
//
// This is for the connectee type to be pnic.
// Two filters will apply, which are pnicName and hostName.
// This connectee whole-name will be made up from two names: pnicName and hostName.
type DVSFilterSpecPnicConnecteeSpec struct {
	DVSFilterSpecConnecteeSpec

	// The pnic name to be filtered in the connectee column.
	//
	// If set, port's connectee type being a pnic whose whole-name including this string are qualified.
	PnicNameSpec string `xml:"pnicNameSpec,omitempty" json:"pnicNameSpec,omitempty"`
}

func init() {
	t["DVSFilterSpecPnicConnecteeSpec"] = reflect.TypeOf((*DVSFilterSpecPnicConnecteeSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecPnicConnecteeSpec"] = "8.0.3.0"
}

// Sub-class for Vlan filters.
//
// This is for the Vlan type to be private Vlan.
type DVSFilterSpecPvlanSpec struct {
	DVSFilterSpecVlanSpec

	// The private VLAN ID for ports.
	//
	// Possible values:
	// A value of 0 specifies that you do not want the port associated
	// with a VLAN.
	// A value from 1 to 4094 specifies a VLAN ID for the port.
	// If set, port private vlans matching are qualified.
	PvlanId int32 `xml:"pvlanId,omitempty" json:"pvlanId,omitempty"`
}

func init() {
	t["DVSFilterSpecPvlanSpec"] = reflect.TypeOf((*DVSFilterSpecPvlanSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecPvlanSpec"] = "8.0.3.0"
}

// Sub-class for Vlan filters.
//
// This is for the Vlan type to be trunking.
type DVSFilterSpecTrunkVlanSpec struct {
	DVSFilterSpecVlanSpec

	// The VlanId range for the trunk port.
	//
	// The valid VlanId range is
	// from 0 to 4094. Overlapping ranges are allowed.
	// If set, port trunk ranges matching are qualified.
	Range *NumericRange `xml:"range,omitempty" json:"range,omitempty"`
}

func init() {
	t["DVSFilterSpecTrunkVlanSpec"] = reflect.TypeOf((*DVSFilterSpecTrunkVlanSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecTrunkVlanSpec"] = "8.0.3.0"
}

// Sub-class for Vlan filters.
//
// This is for the Vlan type to be Vlan.
type DVSFilterSpecVlanIdSpec struct {
	DVSFilterSpecVlanSpec

	// The VLAN ID for ports.
	//
	// Possible values:
	// A value of 0 specifies that you do not want the port associated
	// with a VLAN.
	// A value from 1 to 4094 specifies a VLAN ID for the port.
	// If set,port vlans matching are qualified.
	VlanId int32 `xml:"vlanId,omitempty" json:"vlanId,omitempty"`
}

func init() {
	t["DVSFilterSpecVlanIdSpec"] = reflect.TypeOf((*DVSFilterSpecVlanIdSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecVlanIdSpec"] = "8.0.3.0"
}

// Base class for VlanSpec filters.
//
// This class serves as a base for different types of VlanSpec filters.
// It has three sub-classes.
type DVSFilterSpecVlanSpec struct {
	DynamicData
}

func init() {
	t["DVSFilterSpecVlanSpec"] = reflect.TypeOf((*DVSFilterSpecVlanSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecVlanSpec"] = "8.0.3.0"
}

// Sub-class for connectee filters.
//
// This is for the connectee type to be vm.
// Only one filter will apply, whici is vmName.
type DVSFilterSpecVmConnecteeSpec struct {
	DVSFilterSpecConnecteeSpec

	// The vm name to be filtered in the connectee column.
	//
	// If set, port's connectee type being a vm whose name including this string are qualified.
	VmNameSpec string `xml:"vmNameSpec,omitempty" json:"vmNameSpec,omitempty"`
}

func init() {
	t["DVSFilterSpecVmConnecteeSpec"] = reflect.TypeOf((*DVSFilterSpecVmConnecteeSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecVmConnecteeSpec"] = "8.0.3.0"
}

// Sub-class for connectee filters.
//
// This is for the connectee type to be vmknic.
// Two filters will apply, which are vmknicName and hostName.
// This connectee whole-name will be made up from two names: vmknicName and hostName.
type DVSFilterSpecVmknicConnecteeSpec struct {
	DVSFilterSpecConnecteeSpec

	// The vmknic name to be filtered in the connectee column.
	//
	// If set, port's connectee type being a vmknic whose whole-name including this string are qualified.
	VmknicNameSpec string `xml:"vmknicNameSpec,omitempty" json:"vmknicNameSpec,omitempty"`
}

func init() {
	t["DVSFilterSpecVmknicConnecteeSpec"] = reflect.TypeOf((*DVSFilterSpecVmknicConnecteeSpec)(nil)).Elem()
	minAPIVersionForType["DVSFilterSpecVmknicConnecteeSpec"] = "8.0.3.0"
}

// Health check capabilities of health check supported by the
// vSphere Distributed Switch
type DVSHealthCheckCapability struct {
	DynamicData
}

func init() {
	t["DVSHealthCheckCapability"] = reflect.TypeOf((*DVSHealthCheckCapability)(nil)).Elem()
}

// The `DVSHealthCheckConfig` data object
// defines vSphere Distributed Switch health check configuration.
type DVSHealthCheckConfig struct {
	DynamicData

	// True if enable health check.
	Enable *bool `xml:"enable" json:"enable,omitempty"`
	// Interval of health check, in minutes.
	Interval int32 `xml:"interval,omitempty" json:"interval,omitempty"`
}

func init() {
	t["DVSHealthCheckConfig"] = reflect.TypeOf((*DVSHealthCheckConfig)(nil)).Elem()
}

// This data object type describes the information about the host local port.
//
// A host local port is created to resurrect the management network connection
// on a VMkernel Virtual NIC.
type DVSHostLocalPortInfo struct {
	DynamicData

	// UUID of the vSphere Distributed Switch that management interface is connected to.
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// Portkey of the DVPort that management interface is now connected to.
	PortKey string `xml:"portKey" json:"portKey"`
	// The configuration of the new host local port.
	Setting BaseDVPortSetting `xml:"setting,typeattr" json:"setting"`
	// The Virtual NIC device connected to this port
	Vnic string `xml:"vnic" json:"vnic"`
}

func init() {
	t["DVSHostLocalPortInfo"] = reflect.TypeOf((*DVSHostLocalPortInfo)(nil)).Elem()
}

// This data object type describes MAC learning policy of a port.
type DVSMacLearningPolicy struct {
	InheritablePolicy

	// The flag to indicate if source MAC address learning is allowed.
	Enabled bool `xml:"enabled" json:"enabled"`
	// The flag to allow flooding of unlearned MAC for ingress traffic.
	AllowUnicastFlooding *bool `xml:"allowUnicastFlooding" json:"allowUnicastFlooding,omitempty"`
	// The maximum number of MAC addresses that can be learned.
	Limit *int32 `xml:"limit" json:"limit,omitempty"`
	// The default switching policy after MAC limit is exceeded.
	//
	// See `DVSMacLimitPolicyType_enum`
	// for valid values.
	LimitPolicy string `xml:"limitPolicy,omitempty" json:"limitPolicy,omitempty"`
}

func init() {
	t["DVSMacLearningPolicy"] = reflect.TypeOf((*DVSMacLearningPolicy)(nil)).Elem()
}

// This data object type describes MAC management policy of a port.
type DVSMacManagementPolicy struct {
	InheritablePolicy

	// The flag to indicate whether or not all traffic is seen
	// on the port.
	AllowPromiscuous *bool `xml:"allowPromiscuous" json:"allowPromiscuous,omitempty"`
	// The flag to indicate whether or not the Media Access
	// Control (MAC) address can be changed.
	MacChanges *bool `xml:"macChanges" json:"macChanges,omitempty"`
	// The flag to indicate whether or not the virtual network adapter
	// should be allowed to send network traffic with a different MAC
	// address than that of the virtual network adapter.
	ForgedTransmits *bool `xml:"forgedTransmits" json:"forgedTransmits,omitempty"`
	// The MAC learning policy.
	MacLearningPolicy *DVSMacLearningPolicy `xml:"macLearningPolicy,omitempty" json:"macLearningPolicy,omitempty"`
}

func init() {
	t["DVSMacManagementPolicy"] = reflect.TypeOf((*DVSMacManagementPolicy)(nil)).Elem()
}

// Configuration specification for a DistributedVirtualSwitch or
// DistributedVirtualPortgroup.
type DVSManagerDvsConfigTarget struct {
	DynamicData

	// List of any DistributedVirtualPortgroup available for host Virtual NIC connection.
	DistributedVirtualPortgroup []DistributedVirtualPortgroupInfo `xml:"distributedVirtualPortgroup,omitempty" json:"distributedVirtualPortgroup,omitempty"`
	// List of any DistributedVirtualSwitch available for host Virtual NIC connection.
	DistributedVirtualSwitch []DistributedVirtualSwitchInfo `xml:"distributedVirtualSwitch,omitempty" json:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DVSManagerDvsConfigTarget"] = reflect.TypeOf((*DVSManagerDvsConfigTarget)(nil)).Elem()
}

// The parameters of `DistributedVirtualSwitchManager.DVSManagerExportEntity_Task`.
type DVSManagerExportEntityRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The selection criteria for a set of
	// entities to export the configuration.
	SelectionSet []BaseSelectionSet `xml:"selectionSet,typeattr" json:"selectionSet"`
}

func init() {
	t["DVSManagerExportEntityRequestType"] = reflect.TypeOf((*DVSManagerExportEntityRequestType)(nil)).Elem()
}

type DVSManagerExportEntity_Task DVSManagerExportEntityRequestType

func init() {
	t["DVSManagerExportEntity_Task"] = reflect.TypeOf((*DVSManagerExportEntity_Task)(nil)).Elem()
}

type DVSManagerExportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `DistributedVirtualSwitchManager.DVSManagerImportEntity_Task`.
type DVSManagerImportEntityRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Configuration of one or more entities to be imported.
	// The entity backup configuration is returned
	// by the `DistributedVirtualSwitchManager.DVSManagerExportEntity_Task` method.
	EntityBackup []EntityBackupConfig `xml:"entityBackup" json:"entityBackup"`
	// Specifies whether to create a new configuration
	// or restore a previous configuration. See `EntityImportType_enum` for valid values.
	ImportType string `xml:"importType" json:"importType"`
}

func init() {
	t["DVSManagerImportEntityRequestType"] = reflect.TypeOf((*DVSManagerImportEntityRequestType)(nil)).Elem()
}

type DVSManagerImportEntity_Task DVSManagerImportEntityRequestType

func init() {
	t["DVSManagerImportEntity_Task"] = reflect.TypeOf((*DVSManagerImportEntity_Task)(nil)).Elem()
}

type DVSManagerImportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DVSManagerLookupDvPortGroup DVSManagerLookupDvPortGroupRequestType

func init() {
	t["DVSManagerLookupDvPortGroup"] = reflect.TypeOf((*DVSManagerLookupDvPortGroup)(nil)).Elem()
}

// The parameters of `DistributedVirtualSwitchManager.DVSManagerLookupDvPortGroup`.
type DVSManagerLookupDvPortGroupRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The UUID of the `DistributedVirtualSwitch`.
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// The key that identifies a
	// `DistributedVirtualPortgroup`.
	PortgroupKey string `xml:"portgroupKey" json:"portgroupKey"`
}

func init() {
	t["DVSManagerLookupDvPortGroupRequestType"] = reflect.TypeOf((*DVSManagerLookupDvPortGroupRequestType)(nil)).Elem()
}

type DVSManagerLookupDvPortGroupResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty" json:"returnval,omitempty"`
}

// This class is used to store valid PhysicalNics for a specific host
type DVSManagerPhysicalNicsList struct {
	DynamicData

	// Refers instance of `HostSystem`.
	Host         ManagedObjectReference `xml:"host" json:"host"`
	PhysicalNics []PhysicalNic          `xml:"physicalNics,omitempty" json:"physicalNics,omitempty"`
}

func init() {
	t["DVSManagerPhysicalNicsList"] = reflect.TypeOf((*DVSManagerPhysicalNicsList)(nil)).Elem()
	minAPIVersionForType["DVSManagerPhysicalNicsList"] = "8.0.0.1"
}

// The uplink port policy specifies an array of uniform names
// for the uplink ports across the hosts.
//
// The size of the array indicates
// the number of uplink ports that will be created for each host in the
// switch.
//
// When the names in this array change, the uplink ports on all the
// hosts are automatically renamed accordingly. Increasing the number
// of names in the array automatically creates additional uplink ports
// bearing the added name on each host. Decreasing the number of name
// automatically deletes the unused uplink ports on each host. Decreasing
// beyond the number of unused uplink port raises a fault.
//
// This policy overrides the portgroup port naming format
// (`DVPortgroupConfigSpec*.*DVPortgroupConfigSpec.portNameFormat`),
// if both are defined and the uplink ports are created in a uplink portgroup.
type DVSNameArrayUplinkPortPolicy struct {
	DVSUplinkPortPolicy

	// The uniform name of uplink ports on each host.
	UplinkPortName []string `xml:"uplinkPortName" json:"uplinkPortName"`
}

func init() {
	t["DVSNameArrayUplinkPortPolicy"] = reflect.TypeOf((*DVSNameArrayUplinkPortPolicy)(nil)).Elem()
}

// Dataobject representing the feature capabilities of network resource management
// supported by the vSphere Distributed Switch.
type DVSNetworkResourceManagementCapability struct {
	DynamicData

	// Indicates whether network I/O control is
	// supported on the vSphere Distributed Switch.
	//
	// Network I/O control
	// is supported in vSphere Distributed Switch Version 4.1 or later.
	NetworkResourceManagementSupported bool `xml:"networkResourceManagementSupported" json:"networkResourceManagementSupported"`
	// High share level (`SharesLevel_enum*.*high`)
	// for `DVSNetworkResourcePoolAllocationInfo*.*DVSNetworkResourcePoolAllocationInfo.shares`.
	//
	// The <code>networkResourcePoolHighshareValue</code> property implicitly defines
	// the legal range of share values to be between 1 and this value.
	// This property also defines values for other level types, such as
	// `normal` being one half of this value and
	// `low` being one fourth of this value.
	// This feature is supported in vSphere Distributed
	// Switch Version 4.1 or later.
	NetworkResourcePoolHighShareValue int32 `xml:"networkResourcePoolHighShareValue" json:"networkResourcePoolHighShareValue"`
	// Indicates whether Qos Tag(802.1p priority tag)is supported on the
	// vSphere Distributed Switch.
	//
	// Qos Tag is supported in vSphere
	// Distributed Switch Version 5.0 or later.
	QosSupported bool `xml:"qosSupported" json:"qosSupported"`
	// Indicates whether the switch supports creating user defined resource
	// pools.
	//
	// This feature is supported in vSphere Distributed
	// Switch Version 5.0 or later.
	UserDefinedNetworkResourcePoolsSupported bool `xml:"userDefinedNetworkResourcePoolsSupported" json:"userDefinedNetworkResourcePoolsSupported"`
	// Flag to indicate whether Network Resource Control version 3 is supported.
	//
	// The API supported by Network Resouce Control version 3 include:
	//  1. VM virtual NIC network resource specification
	//     `VirtualEthernetCardResourceAllocation`
	//  2. VM virtual NIC network resource pool specification
	//     `DVSVmVnicNetworkResourcePool`
	//  3. Host infrastructure traffic network resource specification
	//     `DvsHostInfrastructureTrafficResource`
	//
	// Network Resource Control version 3 is supported for Switch Version 6.0 or later.
	NetworkResourceControlVersion3Supported *bool `xml:"networkResourceControlVersion3Supported" json:"networkResourceControlVersion3Supported,omitempty"`
	// Indicates whether user defined infrastructure traffic pool
	// supported in vSphere Distributed Switch.
	UserDefinedInfraTrafficPoolSupported *bool `xml:"userDefinedInfraTrafficPoolSupported" json:"userDefinedInfraTrafficPoolSupported,omitempty"`
}

func init() {
	t["DVSNetworkResourceManagementCapability"] = reflect.TypeOf((*DVSNetworkResourceManagementCapability)(nil)).Elem()
}

// Deprecated as of vSphere API 6.0
// Use `DvsHostInfrastructureTrafficResource`
// to manage resource allocation for host infrastructure traffic.
// Use `DVSVmVnicNetworkResourcePool` to manage
// resource allocation for user defined pools.
//
// The `DVSNetworkResourcePool` data object
// describes the resource configuration and management
// of network resource pools.
type DVSNetworkResourcePool struct {
	DynamicData

	// Key of the network resource pool.
	Key string `xml:"key" json:"key"`
	// Name of the network resource pool.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Description of the network resource pool.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// Configuration version for the network resource pool.
	ConfigVersion string `xml:"configVersion" json:"configVersion"`
	// Resource settings of the resource pool.
	AllocationInfo DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo" json:"allocationInfo"`
}

func init() {
	t["DVSNetworkResourcePool"] = reflect.TypeOf((*DVSNetworkResourcePool)(nil)).Elem()
}

// Resource allocation information for a network resource pool.
type DVSNetworkResourcePoolAllocationInfo struct {
	DynamicData

	// Maximum allowed usage for network clients belonging to
	// this resource pool per host.
	//
	// The utilization of network clients belonging to this resource pool
	// will not exceed the specified limit even if there are available
	// network resources. If set to -1, then there is no limit on the network
	// resource usage for clients belonging to this resource pool. Units are
	// in Mbits/sec. When setting the allocation of a particular resource
	// pool, if the property is unset, it is treated as no change and the
	// property is not updated. An unset limit value while reading back the
	// allocation information of a network resource pool indicates that
	// there is no limit on the network resource usage for the clients
	// belonging to this resource group.
	Limit *int64 `xml:"limit" json:"limit,omitempty"`
	// Share settings associated with the network resource pool to
	// facilitate proportional sharing of the physical network resources.
	//
	// If the property is unset when setting the allocation of a particular
	// resource pool, it is treated as unset and the property is not updated.
	// The property is always set when reading back the allocation
	// information of a network resource pool.
	Shares *SharesInfo `xml:"shares,omitempty" json:"shares,omitempty"`
	// 802.1p tag to be used for this resource pool.
	//
	// The tag is a priority value
	// in the range 0..7 for Quality of Service operations on network traffic.
	PriorityTag int32 `xml:"priorityTag,omitempty" json:"priorityTag,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolAllocationInfo"] = reflect.TypeOf((*DVSNetworkResourcePoolAllocationInfo)(nil)).Elem()
}

// The `DVSNetworkResourcePoolConfigSpec` data object
// contains properties to create or update a network resource pool
// for a distributed virtual switch.
type DVSNetworkResourcePoolConfigSpec struct {
	DynamicData

	// Key of the network resource pool.
	//
	// The property is ignored for
	// `DistributedVirtualSwitch*.*DistributedVirtualSwitch.AddNetworkResourcePool`
	// operations.
	Key string `xml:"key" json:"key"`
	// Unique identifier for a given version
	// of the configuration.
	//
	// Each change to the configuration will
	// update this value. This is typically implemented as a
	// non-decreasing count or a time-stamp. However, a client should
	// always treat this as an opaque string.
	//
	// If you specify the configuration version when you update
	// the resource configuration, the Server will apply the changes
	// only if the specified identifier matches the current
	// `DVSNetworkResourcePool*.*DVSNetworkResourcePool.configVersion`
	// value. You can use this field to guard against updates
	// that may have occurred between the time when the client
	// reads `DVSNetworkResourcePool.configVersion`
	// and when the configuration is applied.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
	// Network resource allocation for the network resource pool.
	AllocationInfo *DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo,omitempty" json:"allocationInfo,omitempty"`
	// User defined name for the resource pool.
	//
	// The property is required for
	// `DistributedVirtualSwitch*.*DistributedVirtualSwitch.AddNetworkResourcePool`
	// operations.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// User-defined description for the resource pool.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*DVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

// The switch usage policy types
type DVSPolicy struct {
	DynamicData

	// Whether downloading a new proxy VirtualSwitch module to the host is
	// allowed to be automatically executed by the switch.
	AutoPreInstallAllowed *bool `xml:"autoPreInstallAllowed" json:"autoPreInstallAllowed,omitempty"`
	// Whether upgrading of the switch is allowed to be automatically
	// executed by the switch.
	AutoUpgradeAllowed *bool `xml:"autoUpgradeAllowed" json:"autoUpgradeAllowed,omitempty"`
	// Whether to allow upgrading a switch when some of the hosts failed to
	// install the needed module.
	//
	// The vCenter Server will reattempt the
	// pre-install operation of the host module on those failed hosts,
	// whenever they reconnect to vCenter.
	PartialUpgradeAllowed *bool `xml:"partialUpgradeAllowed" json:"partialUpgradeAllowed,omitempty"`
}

func init() {
	t["DVSPolicy"] = reflect.TypeOf((*DVSPolicy)(nil)).Elem()
}

// The `DVSRollbackCapability` data object
// describes the rollback capabilities for a `DistributedVirtualSwitch`.
type DVSRollbackCapability struct {
	DynamicData

	// Indicates whether rollback is supported on the distributed switch.
	RollbackSupported bool `xml:"rollbackSupported" json:"rollbackSupported"`
}

func init() {
	t["DVSRollbackCapability"] = reflect.TypeOf((*DVSRollbackCapability)(nil)).Elem()
}

// The parameters of `DistributedVirtualSwitch.DVSRollback_Task`.
type DVSRollbackRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Backup of a distributed virtual switch, returned by
	// the `DistributedVirtualSwitchManager.DVSManagerExportEntity_Task`
	// method.
	EntityBackup *EntityBackupConfig `xml:"entityBackup,omitempty" json:"entityBackup,omitempty"`
}

func init() {
	t["DVSRollbackRequestType"] = reflect.TypeOf((*DVSRollbackRequestType)(nil)).Elem()
}

type DVSRollback_Task DVSRollbackRequestType

func init() {
	t["DVSRollback_Task"] = reflect.TypeOf((*DVSRollback_Task)(nil)).Elem()
}

type DVSRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The `DVSRuntimeInfo` data object defines
// runtime information for a vSphere Distributed Switch.
type DVSRuntimeInfo struct {
	DynamicData

	// Runtime information of the hosts that joined the switch.
	HostMemberRuntime []HostMemberRuntimeInfo `xml:"hostMemberRuntime,omitempty" json:"hostMemberRuntime,omitempty"`
	// The bandwidth reservation information for the switch.
	ResourceRuntimeInfo *DvsResourceRuntimeInfo `xml:"resourceRuntimeInfo,omitempty" json:"resourceRuntimeInfo,omitempty"`
}

func init() {
	t["DVSRuntimeInfo"] = reflect.TypeOf((*DVSRuntimeInfo)(nil)).Elem()
}

// This data object type describes security policy governing ports.
type DVSSecurityPolicy struct {
	InheritablePolicy

	// The flag to indicate whether or not all traffic is seen
	// on the port.
	AllowPromiscuous *BoolPolicy `xml:"allowPromiscuous,omitempty" json:"allowPromiscuous,omitempty"`
	// The flag to indicate whether or not the Media Access
	// Control (MAC) address can be changed.
	MacChanges *BoolPolicy `xml:"macChanges,omitempty" json:"macChanges,omitempty"`
	// The flag to indicate whether or not the virtual network adapter
	// should be allowed to send network traffic with a different MAC
	// address than that of the virtual network adapter.
	ForgedTransmits *BoolPolicy `xml:"forgedTransmits,omitempty" json:"forgedTransmits,omitempty"`
}

func init() {
	t["DVSSecurityPolicy"] = reflect.TypeOf((*DVSSecurityPolicy)(nil)).Elem()
}

// Class to specify selection criteria of vSphere Distributed Switch.
type DVSSelection struct {
	SelectionSet

	// vSphere Distributed Switch uuid
	DvsUuid string `xml:"dvsUuid" json:"dvsUuid"`
}

func init() {
	t["DVSSelection"] = reflect.TypeOf((*DVSSelection)(nil)).Elem()
}

// Summary of the distributed switch configuration.
type DVSSummary struct {
	DynamicData

	// The name of the switch.
	Name string `xml:"name" json:"name"`
	// The generated UUID of the switch.
	Uuid string `xml:"uuid" json:"uuid"`
	// Current number of ports, not including conflict ports.
	NumPorts int32 `xml:"numPorts" json:"numPorts"`
	// The product information for the implementation of the switch.
	ProductInfo *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty" json:"productInfo,omitempty"`
	// The names of the hosts that join the switch.
	//
	// Refers instances of `HostSystem`.
	HostMember []ManagedObjectReference `xml:"hostMember,omitempty" json:"hostMember,omitempty"`
	// The Virtual Machines with Virtual NICs that connect to the switch.
	//
	// In releases after vSphere API 5.0, vSphere Servers might not
	// generate property collector update notifications for this property.
	// To obtain the latest value of the property, you can use
	// PropertyCollector methods RetrievePropertiesEx or WaitForUpdatesEx.
	// If you use the PropertyCollector.WaitForUpdatesEx method, specify
	// an empty string for the version parameter.
	// Since this property is on a DataObject, an update returned by WaitForUpdatesEx may
	// contain values for this property when some other property on the DataObject changes.
	// If this update is a result of a call to WaitForUpdatesEx with a non-empty
	// version parameter, the value for this property may not be current.
	//
	// Refers instances of `VirtualMachine`.
	Vm []ManagedObjectReference `xml:"vm,omitempty" json:"vm,omitempty"`
	// The hosts with Virtual NICs that connect to the switch.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// The names of the portgroups that are defined on the switch.
	PortgroupName []string `xml:"portgroupName,omitempty" json:"portgroupName,omitempty"`
	// A description string of the switch.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The human operator contact information.
	Contact *DVSContactInfo `xml:"contact,omitempty" json:"contact,omitempty"`
	// The number of hosts in the switch.
	//
	// The value of this property
	// is not affected by the privileges granted to the current user.
	NumHosts int32 `xml:"numHosts,omitempty" json:"numHosts,omitempty"`
}

func init() {
	t["DVSSummary"] = reflect.TypeOf((*DVSSummary)(nil)).Elem()
}

// This data object type describes traffic shaping policy.
type DVSTrafficShapingPolicy struct {
	InheritablePolicy

	// The flag to indicate whether or not traffic shaper is enabled on
	// the port.
	Enabled *BoolPolicy `xml:"enabled,omitempty" json:"enabled,omitempty"`
	// The average bandwidth in bits per second if shaping is enabled on
	// the port.
	AverageBandwidth *LongPolicy `xml:"averageBandwidth,omitempty" json:"averageBandwidth,omitempty"`
	// The peak bandwidth during bursts in bits per second if traffic
	// shaping is enabled on the port.
	PeakBandwidth *LongPolicy `xml:"peakBandwidth,omitempty" json:"peakBandwidth,omitempty"`
	// The maximum burst size allowed in bytes if shaping is enabled on
	// the port.
	BurstSize *LongPolicy `xml:"burstSize,omitempty" json:"burstSize,omitempty"`
}

func init() {
	t["DVSTrafficShapingPolicy"] = reflect.TypeOf((*DVSTrafficShapingPolicy)(nil)).Elem()
}

// The base class for uplink port policy.
type DVSUplinkPortPolicy struct {
	DynamicData
}

func init() {
	t["DVSUplinkPortPolicy"] = reflect.TypeOf((*DVSUplinkPortPolicy)(nil)).Elem()
}

// This data object type describes vendor specific configuration.
type DVSVendorSpecificConfig struct {
	InheritablePolicy

	// An opaque binary blob that stores vendor specific configuration.
	KeyValue []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"keyValue,omitempty" json:"keyValue,omitempty"`
}

func init() {
	t["DVSVendorSpecificConfig"] = reflect.TypeOf((*DVSVendorSpecificConfig)(nil)).Elem()
}

// DataObject describing the resource configuration and management of
// virtual NIC network resource pools.
type DVSVmVnicNetworkResourcePool struct {
	DynamicData

	// The key of the virtual NIC network resource pool.
	Key string `xml:"key" json:"key"`
	// The name of the virtual NIC network resource pool.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// The description of the virtual NIC network resource pool.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The config version for the virtual NIC network resource pool.
	ConfigVersion string `xml:"configVersion" json:"configVersion"`
	// The resource settings of the virtual NIC network resource pool.
	AllocationInfo *DvsVmVnicResourceAllocation `xml:"allocationInfo,omitempty" json:"allocationInfo,omitempty"`
}

func init() {
	t["DVSVmVnicNetworkResourcePool"] = reflect.TypeOf((*DVSVmVnicNetworkResourcePool)(nil)).Elem()
}

// The `DailyTaskScheduler` data object sets the time for daily
// task execution.
//
// You set the hour and the inherited minute
// property to complete the schedule. By default, the scheduled task
// will run once every day at the specified hour and minute.
//
// If you set the interval to a value greater than 1, the task will
// execute at the specified daily interval. (For example, an interval
// of 2 will cause the task to execute at the specified hour and minute
// every 2 days.)
type DailyTaskScheduler struct {
	HourlyTaskScheduler

	// The hour at which the `RecurrentTaskScheduler` runs the task.
	//
	// Use UTC (Coordinated Universal Time) values in the range
	// 0 to 23, where 0 = 12:00 a.m. (UTC) and 12 = 12:00 p.m. (UTC).
	//
	// For vCenter 2.x and prior releases, use the server's local time.
	// For example, use Eastern Standard Time (EST) or Pacific Daylight Time (PDT),
	// rather than UTC.
	Hour int32 `xml:"hour" json:"hour"`
}

func init() {
	t["DailyTaskScheduler"] = reflect.TypeOf((*DailyTaskScheduler)(nil)).Elem()
}

// This event records when admission control checks have been disabled in a HA
// cluster.
type DasAdmissionControlDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlDisabledEvent"] = reflect.TypeOf((*DasAdmissionControlDisabledEvent)(nil)).Elem()
}

// This event records when admission control checks have been enabled in a HA cluster.
type DasAdmissionControlEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlEnabledEvent"] = reflect.TypeOf((*DasAdmissionControlEnabledEvent)(nil)).Elem()
}

// Deprecated as of vSphere API 5.0, the event is no longer relevant.
//
// This event records that VirtualCenter has re-established contact with a
// primary host in this HA cluster.
type DasAgentFoundEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentFoundEvent"] = reflect.TypeOf((*DasAgentFoundEvent)(nil)).Elem()
}

// Deprecated as of vSphere API 5.0, the event is no longer relevant.
//
// This event records that VirtualCenter cannot contact any primary host
// in this HA cluster.
//
// HA designates some hosts as primary hosts in the HA
// cluster. When adding a new host to an existing cluster, HA needs to
// contact one of the primary hosts to finish the configuration. VirtualCenter
// has lost contact with all primary nodes in the connected state. Attempts
// to configure HA on a host in this cluster will fail until a
// DasAgentFoundEvent is logged or unless this is the first node to be
// configured. For example, if all the other hosts are disconnected first.
type DasAgentUnavailableEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentUnavailableEvent"] = reflect.TypeOf((*DasAgentUnavailableEvent)(nil)).Elem()
}

// This event records that all hosts have been isolated from the network in a
// HA cluster.
type DasClusterIsolatedEvent struct {
	ClusterEvent
}

func init() {
	t["DasClusterIsolatedEvent"] = reflect.TypeOf((*DasClusterIsolatedEvent)(nil)).Elem()
}

// This fault indicates that some error has occurred during the
// configuration of the host for HA.
//
// This may be subclassed by a more specific fault.
type DasConfigFault struct {
	VimFault

	// The reason why the HA configuration failed, if known.
	//
	// Values should come from `DasConfigFaultDasConfigFaultReason_enum`.
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
	// The output (stdout/stderr) from executing the configuration.
	Output string `xml:"output,omitempty" json:"output,omitempty"`
	// The list of events containing details why the configuration failed, if known.
	Event []BaseEvent `xml:"event,omitempty,typeattr" json:"event,omitempty"`
}

func init() {
	t["DasConfigFault"] = reflect.TypeOf((*DasConfigFault)(nil)).Elem()
}

type DasConfigFaultFault DasConfigFault

func init() {
	t["DasConfigFaultFault"] = reflect.TypeOf((*DasConfigFaultFault)(nil)).Elem()
}

// This event records when a cluster has been disabled for HA.
type DasDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasDisabledEvent"] = reflect.TypeOf((*DasDisabledEvent)(nil)).Elem()
}

// This event records when a cluster has been enabled for HA.
type DasEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasEnabledEvent"] = reflect.TypeOf((*DasEnabledEvent)(nil)).Elem()
}

// Class for the selection of heartbeat datastores
type DasHeartbeatDatastoreInfo struct {
	DynamicData

	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// Refers instances of `HostSystem`.
	Hosts []ManagedObjectReference `xml:"hosts" json:"hosts"`
}

func init() {
	t["DasHeartbeatDatastoreInfo"] = reflect.TypeOf((*DasHeartbeatDatastoreInfo)(nil)).Elem()
}

// This event records when a host failure has been detected by HA.
type DasHostFailedEvent struct {
	ClusterEvent

	// The host that failed.
	FailedHost HostEventArgument `xml:"failedHost" json:"failedHost"`
}

func init() {
	t["DasHostFailedEvent"] = reflect.TypeOf((*DasHostFailedEvent)(nil)).Elem()
}

// This event records that a host has been isolated from the network in a
// HA cluster.
//
// Since an isolated host cannot be distinguished from a failed
// host except by the isolated host itself, this event is logged when the
// isolated host regains network connectivity.
type DasHostIsolatedEvent struct {
	ClusterEvent

	// The host that was isolated.
	IsolatedHost HostEventArgument `xml:"isolatedHost" json:"isolatedHost"`
}

func init() {
	t["DasHostIsolatedEvent"] = reflect.TypeOf((*DasHostIsolatedEvent)(nil)).Elem()
}

// A DatabaseError exception is thrown if an
// operation failed when accessing the external
// database.
//
// This typically is because
// the database is (temporarily) unavailable or
// because of network problems.
type DatabaseError struct {
	RuntimeFault
}

func init() {
	t["DatabaseError"] = reflect.TypeOf((*DatabaseError)(nil)).Elem()
}

type DatabaseErrorFault DatabaseError

func init() {
	t["DatabaseErrorFault"] = reflect.TypeOf((*DatabaseErrorFault)(nil)).Elem()
}

// DatabaseSizeEstimate contains information about the size
// required to by the database.
type DatabaseSizeEstimate struct {
	DynamicData

	// The estimated size required in MB
	Size int64 `xml:"size" json:"size"`
}

func init() {
	t["DatabaseSizeEstimate"] = reflect.TypeOf((*DatabaseSizeEstimate)(nil)).Elem()
}

// DatabaseSizeParam contains information about a sample inventory.
//
// Using this
// information, database size requirements for that sample inventory can be computed.
// Depending on the accuracy of estimate desired, users can choose to specify
// the number of different types of managed entities. The numHosts and
// numVirtualMachines are the only two required fields. Rest are all optional
// fields filled up by Virtual Center based on some heuristics.
// These parameters need not represent a real inventory. The user can use these
// parameters to estimate the database size required by a hypothetical
// VirtualCenter setup.
type DatabaseSizeParam struct {
	DynamicData

	// Object to capture inventory description
	InventoryDesc InventoryDescription `xml:"inventoryDesc" json:"inventoryDesc"`
	// Object to capture performance statistics
	// related parameters
	PerfStatsDesc *PerformanceStatisticsDescription `xml:"perfStatsDesc,omitempty" json:"perfStatsDesc,omitempty"`
}

func init() {
	t["DatabaseSizeParam"] = reflect.TypeOf((*DatabaseSizeParam)(nil)).Elem()
}

// BasicConnectInfo consists of essential information about the host.
//
// This
// is a subset of `HostConnectInfo` and contains the information
// which is relevant when it comes to dealing with a set of hosts.
type DatacenterBasicConnectInfo struct {
	DynamicData

	// Target host.
	Hostname string `xml:"hostname,omitempty" json:"hostname,omitempty"`
	// Error encountered while querying the host.
	//
	// See
	// `Datacenter.QueryConnectionInfo` for the list of exceptions which can
	// be represented here.
	Error *LocalizedMethodFault `xml:"error,omitempty" json:"error,omitempty"`
	// IP address of the VirtualCenter already managing this host, if any.
	ServerIp string `xml:"serverIp,omitempty" json:"serverIp,omitempty"`
	// Specifies the number of VMs on the host.
	NumVm int32 `xml:"numVm,omitempty" json:"numVm,omitempty"`
	// Specifies the number of powered-on VMs on the host.
	NumPoweredOnVm int32 `xml:"numPoweredOnVm,omitempty" json:"numPoweredOnVm,omitempty"`
	// Information about the software running on the host.
	HostProductInfo *AboutInfo `xml:"hostProductInfo,omitempty" json:"hostProductInfo,omitempty"`
	// Hardware vendor identification.
	HardwareVendor string `xml:"hardwareVendor,omitempty" json:"hardwareVendor,omitempty"`
	// System model identification.
	HardwareModel string `xml:"hardwareModel,omitempty" json:"hardwareModel,omitempty"`
}

func init() {
	t["DatacenterBasicConnectInfo"] = reflect.TypeOf((*DatacenterBasicConnectInfo)(nil)).Elem()
}

// Configuration of the datacenter.
type DatacenterConfigInfo struct {
	DynamicData

	// Key for Default Hardware Version used on this datacenter
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// This field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of all its children
	// with this field unset.
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty" json:"defaultHardwareVersionKey,omitempty"`
	// Key for Maximum Hardware Version used on this datacenter
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// This field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of all its children
	// with this field unset.
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty" json:"maximumHardwareVersionKey,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["DatacenterConfigInfo"] = reflect.TypeOf((*DatacenterConfigInfo)(nil)).Elem()
}

// Changes to apply to the datacenter configuration.
type DatacenterConfigSpec struct {
	DynamicData

	// Key for Default Hardware Version to be used on this datacenter
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// Setting this field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of all its children
	// with this field unset.
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty" json:"defaultHardwareVersionKey,omitempty"`
	// Key for Maximum Hardware Version to be used on this datacenter
	// in the format of `VirtualMachineConfigOptionDescriptor.key`.
	//
	// Setting this field affects
	// `VirtualMachineConfigOptionDescriptor.defaultConfigOption` returned
	// by `ComputeResource.environmentBrowser` of all its children
	// with this field unset.
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty" json:"maximumHardwareVersionKey,omitempty" vim:"7.0.2.0"`
}

func init() {
	t["DatacenterConfigSpec"] = reflect.TypeOf((*DatacenterConfigSpec)(nil)).Elem()
}

type DatacenterCreatedEvent struct {
	DatacenterEvent

	// The folder where the datacenter is created.
	Parent FolderEventArgument `xml:"parent" json:"parent"`
}

func init() {
	t["DatacenterCreatedEvent"] = reflect.TypeOf((*DatacenterCreatedEvent)(nil)).Elem()
}

// These are datacenter events.
type DatacenterEvent struct {
	Event
}

func init() {
	t["DatacenterEvent"] = reflect.TypeOf((*DatacenterEvent)(nil)).Elem()
}

// The event argument is a Datacenter object.
type DatacenterEventArgument struct {
	EntityEventArgument

	// The Datacenter object.
	//
	// Refers instance of `Datacenter`.
	Datacenter ManagedObjectReference `xml:"datacenter" json:"datacenter"`
}

func init() {
	t["DatacenterEventArgument"] = reflect.TypeOf((*DatacenterEventArgument)(nil)).Elem()
}

// The input arguments had entities that did not belong to the same
// datacenter.
type DatacenterMismatch struct {
	MigrationFault

	// The list of invalid arguments.
	InvalidArgument []DatacenterMismatchArgument `xml:"invalidArgument" json:"invalidArgument"`
	// The expected datacenter for the arguments.
	//
	// Refers instance of `Datacenter`.
	ExpectedDatacenter ManagedObjectReference `xml:"expectedDatacenter" json:"expectedDatacenter"`
}

func init() {
	t["DatacenterMismatch"] = reflect.TypeOf((*DatacenterMismatch)(nil)).Elem()
}

// An input entity argument that belongs to a mismatched datacenter.
type DatacenterMismatchArgument struct {
	DynamicData

	// The invalid input entity.
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
	// The datacenter for this entity.
	//
	// Refers instance of `Datacenter`.
	InputDatacenter *ManagedObjectReference `xml:"inputDatacenter,omitempty" json:"inputDatacenter,omitempty"`
}

func init() {
	t["DatacenterMismatchArgument"] = reflect.TypeOf((*DatacenterMismatchArgument)(nil)).Elem()
}

type DatacenterMismatchFault DatacenterMismatch

func init() {
	t["DatacenterMismatchFault"] = reflect.TypeOf((*DatacenterMismatchFault)(nil)).Elem()
}

type DatacenterRenamedEvent struct {
	DatacenterEvent

	// The old datacenter name.
	OldName string `xml:"oldName" json:"oldName"`
	// The new datacenter name.
	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["DatacenterRenamedEvent"] = reflect.TypeOf((*DatacenterRenamedEvent)(nil)).Elem()
}

// Information about the capabilities of this datastore.
type DatastoreCapability struct {
	DynamicData

	// Indicates whether or not directories can be created on this datastore.
	DirectoryHierarchySupported bool `xml:"directoryHierarchySupported" json:"directoryHierarchySupported"`
	// Indicates whether or not raw disk mappings can be created on this datastore.
	RawDiskMappingsSupported bool `xml:"rawDiskMappingsSupported" json:"rawDiskMappingsSupported"`
	// Indicates whether or not the datastore supports thin provisioning on a per file
	// basis.
	//
	// When thin provisioning is used, backing storage is lazily allocated.
	//
	// This is supported by VMFS3. VMFS2 always allocates storage eagerly. Thus, this
	// value is false for VMFS2. Most NAS systems always use thin provisioning.
	// They do not support configuring this on a per file basis, so for NAS systems
	// this value is also false.
	PerFileThinProvisioningSupported bool `xml:"perFileThinProvisioningSupported" json:"perFileThinProvisioningSupported"`
	// Deprecated as of vSphere8.0 U3, and there is no replacement for it.
	//
	// Indicates whether the datastore supports Storage I/O Resource Management.
	StorageIORMSupported *bool `xml:"storageIORMSupported" json:"storageIORMSupported,omitempty"`
	// Indicates whether the datastore supports native snapshot feature which is
	// based on Copy-On-Write.
	NativeSnapshotSupported *bool `xml:"nativeSnapshotSupported" json:"nativeSnapshotSupported,omitempty"`
	// Indicates whether the datastore supports traditional top-level
	// directory creation.
	//
	// See also `DatastoreNamespaceManager`.
	TopLevelDirectoryCreateSupported *bool `xml:"topLevelDirectoryCreateSupported" json:"topLevelDirectoryCreateSupported,omitempty"`
	// Indicates whether the datastore supports the Flex-SE(SeSparse) feature.
	SeSparseSupported *bool `xml:"seSparseSupported" json:"seSparseSupported,omitempty"`
	// Indicates whether the datastore supports the vmfsSparse feature.
	//
	// True for VMFS3/VMFS5/NFS/NFS41, False for VMFS6.
	// If value is undefined, then it should be read as supported.
	VmfsSparseSupported *bool `xml:"vmfsSparseSupported" json:"vmfsSparseSupported,omitempty"`
	// Indicates whether the datastore supports the vsanSparse feature.
	VsanSparseSupported *bool `xml:"vsanSparseSupported" json:"vsanSparseSupported,omitempty"`
	// Deprecated as of vSphere API 8.0, and there is no replacement for it.
	//
	// Indicates whether the datastore supports the upit feature.
	UpitSupported *bool `xml:"upitSupported" json:"upitSupported,omitempty"`
	// On certain datastores (e.g.
	//
	// 2016 PMEM datastore) VMDK expand is not supported.
	// This field tells user if VMDK on this datastore can be expanded or not.
	// If value is undefined, then it should be read as supported.
	VmdkExpandSupported *bool `xml:"vmdkExpandSupported" json:"vmdkExpandSupported,omitempty"`
	// Indicates whether the datastore supports clustered VMDK feature.
	ClusteredVmdkSupported *bool `xml:"clusteredVmdkSupported" json:"clusteredVmdkSupported,omitempty"`
}

func init() {
	t["DatastoreCapability"] = reflect.TypeOf((*DatastoreCapability)(nil)).Elem()
}

// This event records when increase in a datastore's capacity is observed.
//
// It may happen due to different reasons, like extending or expanding a
// datastore.
type DatastoreCapacityIncreasedEvent struct {
	DatastoreEvent

	// The old datastore capacity.
	OldCapacity int64 `xml:"oldCapacity" json:"oldCapacity"`
	// The new datastore capacity.
	NewCapacity int64 `xml:"newCapacity" json:"newCapacity"`
}

func init() {
	t["DatastoreCapacityIncreasedEvent"] = reflect.TypeOf((*DatastoreCapacityIncreasedEvent)(nil)).Elem()
}

// This event records when a datastore is removed from VirtualCenter.
type DatastoreDestroyedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDestroyedEvent"] = reflect.TypeOf((*DatastoreDestroyedEvent)(nil)).Elem()
}

// This event records when a host is added to VirtualCenter
// and datastores are discovered.
type DatastoreDiscoveredEvent struct {
	HostEvent

	// The associated datastore.
	Datastore DatastoreEventArgument `xml:"datastore" json:"datastore"`
}

func init() {
	t["DatastoreDiscoveredEvent"] = reflect.TypeOf((*DatastoreDiscoveredEvent)(nil)).Elem()
}

// This event records when a duplicate datastore name is found.
//
// This event is used in VirtualCenter 1.x and is included for
// backward compatibility.
type DatastoreDuplicatedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDuplicatedEvent"] = reflect.TypeOf((*DatastoreDuplicatedEvent)(nil)).Elem()
}

type DatastoreEnterMaintenanceMode DatastoreEnterMaintenanceModeRequestType

func init() {
	t["DatastoreEnterMaintenanceMode"] = reflect.TypeOf((*DatastoreEnterMaintenanceMode)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DatastoreEnterMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreEnterMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeResponse struct {
	Returnval StoragePlacementResult `xml:"returnval" json:"returnval"`
}

// These are datastore events.
type DatastoreEvent struct {
	Event

	// The associated datastore.
	Datastore *DatastoreEventArgument `xml:"datastore,omitempty" json:"datastore,omitempty"`
}

func init() {
	t["DatastoreEvent"] = reflect.TypeOf((*DatastoreEvent)(nil)).Elem()
}

// The event argument is a Datastore object.
type DatastoreEventArgument struct {
	EntityEventArgument

	// The Datastore object.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["DatastoreEventArgument"] = reflect.TypeOf((*DatastoreEventArgument)(nil)).Elem()
}

type DatastoreExitMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DatastoreExitMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreExitMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_Task DatastoreExitMaintenanceModeRequestType

func init() {
	t["DatastoreExitMaintenanceMode_Task"] = reflect.TypeOf((*DatastoreExitMaintenanceMode_Task)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// This event records copy of a file or directory.
type DatastoreFileCopiedEvent struct {
	DatastoreFileEvent

	// Source datastore.
	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore" json:"sourceDatastore"`
	// Datastore path of the source file or directory.
	SourceFile string `xml:"sourceFile" json:"sourceFile"`
}

func init() {
	t["DatastoreFileCopiedEvent"] = reflect.TypeOf((*DatastoreFileCopiedEvent)(nil)).Elem()
}

// This event records deletion of a file or directory.
type DatastoreFileDeletedEvent struct {
	DatastoreFileEvent
}

func init() {
	t["DatastoreFileDeletedEvent"] = reflect.TypeOf((*DatastoreFileDeletedEvent)(nil)).Elem()
}

// Base class for events related to datastore file and directory
// operations.
//
// Property _datastore_ inherited from DatastoreEvent refers
// to the destination datastore in case there is more than datastore
// involved in the operation.
type DatastoreFileEvent struct {
	DatastoreEvent

	// Datastore path of the target file or directory.
	TargetFile string `xml:"targetFile" json:"targetFile"`
	// Identifier of the initiator of the file operation.
	SourceOfOperation string `xml:"sourceOfOperation,omitempty" json:"sourceOfOperation,omitempty"`
	// Indicator whether the datastore file operation succeeded.
	Succeeded *bool `xml:"succeeded" json:"succeeded,omitempty"`
}

func init() {
	t["DatastoreFileEvent"] = reflect.TypeOf((*DatastoreFileEvent)(nil)).Elem()
}

// This event records move of a file or directory.
type DatastoreFileMovedEvent struct {
	DatastoreFileEvent

	// Source datastore.
	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore" json:"sourceDatastore"`
	// Datastore path of the source file or directory.
	SourceFile string `xml:"sourceFile" json:"sourceFile"`
}

func init() {
	t["DatastoreFileMovedEvent"] = reflect.TypeOf((*DatastoreFileMovedEvent)(nil)).Elem()
}

// Host-specific datastore information.
type DatastoreHostMount struct {
	DynamicData

	// The host associated with this datastore.
	//
	// Refers instance of `HostSystem`.
	Key ManagedObjectReference `xml:"key" json:"key"`
	// Host-specific information about the mount.
	MountInfo HostMountInfo `xml:"mountInfo" json:"mountInfo"`
}

func init() {
	t["DatastoreHostMount"] = reflect.TypeOf((*DatastoreHostMount)(nil)).Elem()
}

// This event records that the configuration of storage I/O
// resource management for a datastore has changed.
type DatastoreIORMReconfiguredEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreIORMReconfiguredEvent"] = reflect.TypeOf((*DatastoreIORMReconfiguredEvent)(nil)).Elem()
}

// Detailed information about a datastore.
//
// This is a base type for derived types
// that have more specific details about a datastore.
//
// See also `HostVmfsVolume`, `HostNasVolume`, `HostLocalFileSystemVolume`.
type DatastoreInfo struct {
	DynamicData

	// The name of the datastore.
	Name string `xml:"name" json:"name"`
	// The unique locator for the datastore.
	Url string `xml:"url" json:"url"`
	// Free space of this datastore, in bytes.
	//
	// The server periodically updates this
	// value. It can be explicitly refreshed with the Refresh operation.
	FreeSpace int64 `xml:"freeSpace" json:"freeSpace"`
	// The maximum size of a file that can reside on this file system volume.
	MaxFileSize int64 `xml:"maxFileSize" json:"maxFileSize"`
	// The maximum capacity of a virtual disk which can be created on this volume.
	MaxVirtualDiskCapacity int64 `xml:"maxVirtualDiskCapacity,omitempty" json:"maxVirtualDiskCapacity,omitempty"`
	// The maximum size of a snapshot or a swap file that can reside on this file system volume.
	MaxMemoryFileSize int64 `xml:"maxMemoryFileSize,omitempty" json:"maxMemoryFileSize,omitempty"`
	// Time when the free-space and capacity values in `DatastoreInfo` and
	// `DatastoreSummary` were updated.
	Timestamp *time.Time `xml:"timestamp" json:"timestamp,omitempty"`
	// The unique container ID of the datastore, if applicable.
	ContainerId string `xml:"containerId,omitempty" json:"containerId,omitempty"`
	// vSAN datastore container that this datastore is alias of.
	//
	// If this
	// field is unset then this datastore is not alias of any other vSAN
	// datastore.
	// See `DatastoreInfo.containerId`.
	AliasOf string `xml:"aliasOf,omitempty" json:"aliasOf,omitempty"`
}

func init() {
	t["DatastoreInfo"] = reflect.TypeOf((*DatastoreInfo)(nil)).Elem()
}

// Contains a mapping of an old mount path and its corresponding
// resignatured or remounted datastore
type DatastoreMountPathDatastorePair struct {
	DynamicData

	// Old file path where file system volume is mounted, which
	// should be `path` value in
	// `HostMountInfo`
	OldMountPath string `xml:"oldMountPath" json:"oldMountPath"`
	// The resignatured or remounted datastore corresponding to the oldMountPath
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["DatastoreMountPathDatastorePair"] = reflect.TypeOf((*DatastoreMountPathDatastorePair)(nil)).Elem()
}

type DatastoreNamespaceManagerDirectoryInfo struct {
	DynamicData

	// Size in MB of underlying object.
	Capacity int64 `xml:"capacity" json:"capacity"`
	// Used size in MB in the VMFS volume.
	Used int64 `xml:"used" json:"used"`
}

func init() {
	t["DatastoreNamespaceManagerDirectoryInfo"] = reflect.TypeOf((*DatastoreNamespaceManagerDirectoryInfo)(nil)).Elem()
	minAPIVersionForType["DatastoreNamespaceManagerDirectoryInfo"] = "8.0.1.0"
}

// This exception is thrown if a datastore is not
// writable on the target host.
type DatastoreNotWritableOnHost struct {
	InvalidDatastore

	// The target host on which the datastore is not writable.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["DatastoreNotWritableOnHost"] = reflect.TypeOf((*DatastoreNotWritableOnHost)(nil)).Elem()
}

type DatastoreNotWritableOnHostFault BaseDatastoreNotWritableOnHost

func init() {
	t["DatastoreNotWritableOnHostFault"] = reflect.TypeOf((*DatastoreNotWritableOnHostFault)(nil)).Elem()
}

// The DatastoreOption data object describes datastore options
// for a virtual machine.
type DatastoreOption struct {
	DynamicData

	// The type of file system volumes on which this virtual machine cannot have
	// its disk and configuration files.
	UnsupportedVolumes []VirtualMachineDatastoreVolumeOption `xml:"unsupportedVolumes,omitempty" json:"unsupportedVolumes,omitempty"`
}

func init() {
	t["DatastoreOption"] = reflect.TypeOf((*DatastoreOption)(nil)).Elem()
}

// This event records that a datastore principal was configured on a host.
type DatastorePrincipalConfigured struct {
	HostEvent

	DatastorePrincipal string `xml:"datastorePrincipal" json:"datastorePrincipal"`
}

func init() {
	t["DatastorePrincipalConfigured"] = reflect.TypeOf((*DatastorePrincipalConfigured)(nil)).Elem()
}

// This event records when a datastore is removed from a host
// but not from VirtualCenter.
type DatastoreRemovedOnHostEvent struct {
	HostEvent

	// The associated datastore.
	Datastore DatastoreEventArgument `xml:"datastore" json:"datastore"`
}

func init() {
	t["DatastoreRemovedOnHostEvent"] = reflect.TypeOf((*DatastoreRemovedOnHostEvent)(nil)).Elem()
}

// This event records the renaming of a datastore.
type DatastoreRenamedEvent struct {
	DatastoreEvent

	// The old datastore name.
	OldName string `xml:"oldName" json:"oldName"`
	// The new datastore name.
	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["DatastoreRenamedEvent"] = reflect.TypeOf((*DatastoreRenamedEvent)(nil)).Elem()
}

// This event records when a datastore is added to VirtualCenter
// and is renamed by VirtualCenter because this datastore already
// exists in VirtualCenter with a different name, or because the
// name conflicts with another datastore in VirtualCenter.
type DatastoreRenamedOnHostEvent struct {
	HostEvent

	// The old datastore name.
	OldName string `xml:"oldName" json:"oldName"`
	// The new datastore name.
	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["DatastoreRenamedOnHostEvent"] = reflect.TypeOf((*DatastoreRenamedOnHostEvent)(nil)).Elem()
}

// Summary information about the datastore.
//
// The status fields and managed object
// reference is not set when an object of this type is created. These fields and
// references are typically set later when these objects are associated with a host.
type DatastoreSummary struct {
	DynamicData

	// The reference to the managed object.
	//
	// Refers instance of `Datastore`.
	Datastore *ManagedObjectReference `xml:"datastore,omitempty" json:"datastore,omitempty"`
	// The name of the datastore.
	Name string `xml:"name" json:"name"`
	// The unique locator for the datastore.
	//
	// This property is guaranteed to be valid
	// only if `DatastoreSummary.accessible` is true.
	Url string `xml:"url" json:"url"`
	// Maximum capacity of this datastore, in bytes.
	//
	// This value is updated
	// periodically by the server. It can be explicitly refreshed with the Refresh
	// operation. This property is guaranteed to be valid only if `DatastoreSummary.accessible`
	// is true.
	Capacity int64 `xml:"capacity" json:"capacity"`
	// Available space of this datastore, in bytes.
	//
	// The server periodically
	// updates this value. It can be explicitly refreshed with the Refresh operation.
	// This property is guaranteed to be valid only if `DatastoreSummary.accessible` is true.
	FreeSpace int64 `xml:"freeSpace" json:"freeSpace"`
	// Total additional storage space, in bytes, potentially used by all
	// virtual machines on this datastore.
	//
	// The server periodically updates this
	// value.
	// It can be explicitly refreshed with the `Datastore.RefreshDatastoreStorageInfo` operation.
	// This property is valid only if `DatastoreSummary.accessible` is true.
	Uncommitted int64 `xml:"uncommitted,omitempty" json:"uncommitted,omitempty"`
	// The connectivity status of this datastore.
	//
	// If this is set to false, meaning the
	// datastore is not accessible, this datastore's capacity and freespace properties
	// cannot be validated. Furthermore, if this property is set to false, some of the
	// properties in this summary and in `DatastoreInfo` should not be
	// used. Refer to the documentation for the property of your interest.
	// For datastores accessed from multiple hosts, vCenter Server reports
	// `DatastoreSummary.accessible` as an aggregated value of the
	// properties reported in `HostMountInfo`. For instance,
	// if a datastore is accessible through a subset of hosts, then the value of
	// `DatastoreSummary.accessible` will be reported as true by
	// vCenter Server. And the reason for a daastore being inaccessible from a host
	// will be reported in `HostMountInfo.inaccessibleReason`
	Accessible bool `xml:"accessible" json:"accessible"`
	// More than one host in the datacenter has been configured with access to the
	// datastore.
	//
	// This is only provided by VirtualCenter.
	MultipleHostAccess *bool `xml:"multipleHostAccess" json:"multipleHostAccess,omitempty"`
	// Type of file system volume, such as VMFS or NFS.
	//
	// See also `HostFileSystemVolume.type`.
	Type string `xml:"type" json:"type"`
	// The current maintenance mode state of the datastore.
	//
	// The set of
	// possible values is described in `DatastoreSummaryMaintenanceModeState_enum`.
	MaintenanceMode string `xml:"maintenanceMode,omitempty" json:"maintenanceMode,omitempty"`
}

func init() {
	t["DatastoreSummary"] = reflect.TypeOf((*DatastoreSummary)(nil)).Elem()
}

// A pair of source and target VVol containers and mapping of VVol
// IDs from source to target.
type DatastoreVVolContainerFailoverPair struct {
	DynamicData

	// Storage container on the source side.
	SrcContainer string `xml:"srcContainer,omitempty" json:"srcContainer,omitempty"`
	// Storage container on the target side.
	TgtContainer string `xml:"tgtContainer" json:"tgtContainer"`
	// Mapping of VVol IDs from source to target corresponding to the
	// given set of containers.
	VvolMapping []KeyValue `xml:"vvolMapping,omitempty" json:"vvolMapping,omitempty"`
}

func init() {
	t["DatastoreVVolContainerFailoverPair"] = reflect.TypeOf((*DatastoreVVolContainerFailoverPair)(nil)).Elem()
}

// The `DateTimeProfile` data object represents host date and time configuration.
//
// Use the `ApplyProfile.policy` list for access to configuration data
// for the date and time profile. Use the `ApplyProfile.property` list
// for access to subprofiles, if any.
type DateTimeProfile struct {
	ApplyProfile
}

func init() {
	t["DateTimeProfile"] = reflect.TypeOf((*DateTimeProfile)(nil)).Elem()
}

type DecodeLicense DecodeLicenseRequestType

func init() {
	t["DecodeLicense"] = reflect.TypeOf((*DecodeLicense)(nil)).Elem()
}

// The parameters of `LicenseManager.DecodeLicense`.
type DecodeLicenseRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A license. E.g. a serial license.
	LicenseKey string `xml:"licenseKey" json:"licenseKey"`
}

func init() {
	t["DecodeLicenseRequestType"] = reflect.TypeOf((*DecodeLicenseRequestType)(nil)).Elem()
}

type DecodeLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval" json:"returnval"`
}

type DefragmentAllDisks DefragmentAllDisksRequestType

func init() {
	t["DefragmentAllDisks"] = reflect.TypeOf((*DefragmentAllDisks)(nil)).Elem()
}

type DefragmentAllDisksRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DefragmentAllDisksRequestType"] = reflect.TypeOf((*DefragmentAllDisksRequestType)(nil)).Elem()
}

type DefragmentAllDisksResponse struct {
}

// The parameters of `VirtualDiskManager.DefragmentVirtualDisk_Task`.
type DefragmentVirtualDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the disk, either a datastore path or a URL
	// referring to the virtual disk that should be defragmented.
	Name string `xml:"name" json:"name"`
	// If <code>name</code> is a datastore path, the datacenter for
	// that datastore path. Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>name</code> must be a URL.
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
}

func init() {
	t["DefragmentVirtualDiskRequestType"] = reflect.TypeOf((*DefragmentVirtualDiskRequestType)(nil)).Elem()
}

type DefragmentVirtualDisk_Task DefragmentVirtualDiskRequestType

func init() {
	t["DefragmentVirtualDisk_Task"] = reflect.TypeOf((*DefragmentVirtualDisk_Task)(nil)).Elem()
}

type DefragmentVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DeleteCustomizationSpec DeleteCustomizationSpecRequestType

func init() {
	t["DeleteCustomizationSpec"] = reflect.TypeOf((*DeleteCustomizationSpec)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.DeleteCustomizationSpec`.
type DeleteCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Name string                 `xml:"name" json:"name"`
}

func init() {
	t["DeleteCustomizationSpecRequestType"] = reflect.TypeOf((*DeleteCustomizationSpecRequestType)(nil)).Elem()
}

type DeleteCustomizationSpecResponse struct {
}

// The parameters of `FileManager.DeleteDatastoreFile_Task`.
type DeleteDatastoreFileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the file or folder, either a URL or a datastore path
	// referring to the file or folder to be deleted.
	Name string `xml:"name" json:"name"`
	// If <code>name</code> is a datastore path, the datacenter for
	// that datastore path. Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>name</code> must be a URL.
	//
	// Required privileges: System.View
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
}

func init() {
	t["DeleteDatastoreFileRequestType"] = reflect.TypeOf((*DeleteDatastoreFileRequestType)(nil)).Elem()
}

type DeleteDatastoreFile_Task DeleteDatastoreFileRequestType

func init() {
	t["DeleteDatastoreFile_Task"] = reflect.TypeOf((*DeleteDatastoreFile_Task)(nil)).Elem()
}

type DeleteDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DeleteDirectory DeleteDirectoryRequestType

func init() {
	t["DeleteDirectory"] = reflect.TypeOf((*DeleteDirectory)(nil)).Elem()
}

type DeleteDirectoryInGuest DeleteDirectoryInGuestRequestType

func init() {
	t["DeleteDirectoryInGuest"] = reflect.TypeOf((*DeleteDirectoryInGuest)(nil)).Elem()
}

// The parameters of `GuestFileManager.DeleteDirectoryInGuest`.
type DeleteDirectoryInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual Machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The complete path to the directory to be deleted.
	DirectoryPath string `xml:"directoryPath" json:"directoryPath"`
	// If true, all subdirectories are also deleted.
	// If false, the directory must be empty for the operation to succeed.
	Recursive bool `xml:"recursive" json:"recursive"`
}

func init() {
	t["DeleteDirectoryInGuestRequestType"] = reflect.TypeOf((*DeleteDirectoryInGuestRequestType)(nil)).Elem()
}

type DeleteDirectoryInGuestResponse struct {
}

// The parameters of `DatastoreNamespaceManager.DeleteDirectory`.
type DeleteDirectoryRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter of the datastore path. Needs to be set
	// when making the call to VC; ignored when the call is
	// made to ESX.
	//
	// Required privileges: System.View
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
	// Stable vmfs path of the directory to delete.
	DatastorePath string `xml:"datastorePath" json:"datastorePath"`
}

func init() {
	t["DeleteDirectoryRequestType"] = reflect.TypeOf((*DeleteDirectoryRequestType)(nil)).Elem()
}

type DeleteDirectoryResponse struct {
}

type DeleteFile DeleteFileRequestType

func init() {
	t["DeleteFile"] = reflect.TypeOf((*DeleteFile)(nil)).Elem()
}

type DeleteFileInGuest DeleteFileInGuestRequestType

func init() {
	t["DeleteFileInGuest"] = reflect.TypeOf((*DeleteFileInGuest)(nil)).Elem()
}

// The parameters of `GuestFileManager.DeleteFileInGuest`.
type DeleteFileInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual Machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data. See
	// `GuestAuthentication`.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The complete path to the file or symbolic link to be deleted.
	FilePath string `xml:"filePath" json:"filePath"`
}

func init() {
	t["DeleteFileInGuestRequestType"] = reflect.TypeOf((*DeleteFileInGuestRequestType)(nil)).Elem()
}

type DeleteFileInGuestResponse struct {
}

// The parameters of `HostDatastoreBrowser.DeleteFile`.
type DeleteFileRequestType struct {
	This          ManagedObjectReference `xml:"_this" json:"-"`
	DatastorePath string                 `xml:"datastorePath" json:"datastorePath"`
}

func init() {
	t["DeleteFileRequestType"] = reflect.TypeOf((*DeleteFileRequestType)(nil)).Elem()
}

type DeleteFileResponse struct {
}

type DeleteHostSpecification DeleteHostSpecificationRequestType

func init() {
	t["DeleteHostSpecification"] = reflect.TypeOf((*DeleteHostSpecification)(nil)).Elem()
}

// The parameters of `HostSpecificationManager.DeleteHostSpecification`.
type DeleteHostSpecificationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specified host for which the specification will be
	// deleted.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["DeleteHostSpecificationRequestType"] = reflect.TypeOf((*DeleteHostSpecificationRequestType)(nil)).Elem()
}

type DeleteHostSpecificationResponse struct {
}

type DeleteHostSubSpecification DeleteHostSubSpecificationRequestType

func init() {
	t["DeleteHostSubSpecification"] = reflect.TypeOf((*DeleteHostSubSpecification)(nil)).Elem()
}

// The parameters of `HostSpecificationManager.DeleteHostSubSpecification`.
type DeleteHostSubSpecificationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The specified host for which the sub specification will be
	// deleted.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// The name of the host sub specification to be deleted.
	SubSpecName string `xml:"subSpecName" json:"subSpecName"`
}

func init() {
	t["DeleteHostSubSpecificationRequestType"] = reflect.TypeOf((*DeleteHostSubSpecificationRequestType)(nil)).Elem()
}

type DeleteHostSubSpecificationResponse struct {
}

type DeleteNvdimmBlockNamespacesRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DeleteNvdimmBlockNamespacesRequestType"] = reflect.TypeOf((*DeleteNvdimmBlockNamespacesRequestType)(nil)).Elem()
}

type DeleteNvdimmBlockNamespaces_Task DeleteNvdimmBlockNamespacesRequestType

func init() {
	t["DeleteNvdimmBlockNamespaces_Task"] = reflect.TypeOf((*DeleteNvdimmBlockNamespaces_Task)(nil)).Elem()
}

type DeleteNvdimmBlockNamespaces_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostNvdimmSystem.DeleteNvdimmNamespace_Task`.
type DeleteNvdimmNamespaceRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Details of namespace to be deleted.
	DeleteSpec NvdimmNamespaceDeleteSpec `xml:"deleteSpec" json:"deleteSpec"`
}

func init() {
	t["DeleteNvdimmNamespaceRequestType"] = reflect.TypeOf((*DeleteNvdimmNamespaceRequestType)(nil)).Elem()
}

type DeleteNvdimmNamespace_Task DeleteNvdimmNamespaceRequestType

func init() {
	t["DeleteNvdimmNamespace_Task"] = reflect.TypeOf((*DeleteNvdimmNamespace_Task)(nil)).Elem()
}

type DeleteNvdimmNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DeleteRegistryKeyInGuest DeleteRegistryKeyInGuestRequestType

func init() {
	t["DeleteRegistryKeyInGuest"] = reflect.TypeOf((*DeleteRegistryKeyInGuest)(nil)).Elem()
}

// The parameters of `GuestWindowsRegistryManager.DeleteRegistryKeyInGuest`.
type DeleteRegistryKeyInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The path to the registry key to be deleted.
	KeyName GuestRegKeyNameSpec `xml:"keyName" json:"keyName"`
	// If true, the key is deleted along with any subkeys (if
	// present). Otherwise, it shall only delete the key if it
	// has no subkeys.
	Recursive bool `xml:"recursive" json:"recursive"`
}

func init() {
	t["DeleteRegistryKeyInGuestRequestType"] = reflect.TypeOf((*DeleteRegistryKeyInGuestRequestType)(nil)).Elem()
}

type DeleteRegistryKeyInGuestResponse struct {
}

type DeleteRegistryValueInGuest DeleteRegistryValueInGuestRequestType

func init() {
	t["DeleteRegistryValueInGuest"] = reflect.TypeOf((*DeleteRegistryValueInGuest)(nil)).Elem()
}

// The parameters of `GuestWindowsRegistryManager.DeleteRegistryValueInGuest`.
type DeleteRegistryValueInGuestRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Virtual machine to perform the operation on.
	//
	// Required privileges: VirtualMachine.GuestOperations.Modify
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The guest authentication data.
	Auth BaseGuestAuthentication `xml:"auth,typeattr" json:"auth"`
	// The registry value name to be deleted.
	// The Value "name" (specified in
	// `GuestRegValueNameSpec`)
	// can be empty. If "name" is empty, it deletes the value
	// for the unnamed or default value of the given key.
	ValueName GuestRegValueNameSpec `xml:"valueName" json:"valueName"`
}

func init() {
	t["DeleteRegistryValueInGuestRequestType"] = reflect.TypeOf((*DeleteRegistryValueInGuestRequestType)(nil)).Elem()
}

type DeleteRegistryValueInGuestResponse struct {
}

type DeleteScsiLunState DeleteScsiLunStateRequestType

func init() {
	t["DeleteScsiLunState"] = reflect.TypeOf((*DeleteScsiLunState)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DeleteScsiLunState`.
type DeleteScsiLunStateRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The 'canonicalName' of the ScsiLun
	// whose state needs to be deleted.
	LunCanonicalName string `xml:"lunCanonicalName" json:"lunCanonicalName"`
}

func init() {
	t["DeleteScsiLunStateRequestType"] = reflect.TypeOf((*DeleteScsiLunStateRequestType)(nil)).Elem()
}

type DeleteScsiLunStateResponse struct {
}

// The parameters of `VcenterVStorageObjectManager.DeleteSnapshot_Task`.
type DeleteSnapshotRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The datastore where the source virtual storage object
	// is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
	// The ID of the snapshot of a virtual storage object.
	SnapshotId ID `xml:"snapshotId" json:"snapshotId"`
}

func init() {
	t["DeleteSnapshotRequestType"] = reflect.TypeOf((*DeleteSnapshotRequestType)(nil)).Elem()
}

type DeleteSnapshot_Task DeleteSnapshotRequestType

func init() {
	t["DeleteSnapshot_Task"] = reflect.TypeOf((*DeleteSnapshot_Task)(nil)).Elem()
}

type DeleteSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VcenterVStorageObjectManager.DeleteVStorageObjectEx_Task`.
type DeleteVStorageObjectExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object to be deleted.
	Id ID `xml:"id" json:"id"`
	// The datastore where the virtual storage object
	// is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["DeleteVStorageObjectExRequestType"] = reflect.TypeOf((*DeleteVStorageObjectExRequestType)(nil)).Elem()
	minAPIVersionForType["DeleteVStorageObjectExRequestType"] = "7.0.2.0"
}

type DeleteVStorageObjectEx_Task DeleteVStorageObjectExRequestType

func init() {
	t["DeleteVStorageObjectEx_Task"] = reflect.TypeOf((*DeleteVStorageObjectEx_Task)(nil)).Elem()
}

type DeleteVStorageObjectEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VcenterVStorageObjectManager.DeleteVStorageObject_Task`.
type DeleteVStorageObjectRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual storage object to be deleted.
	Id ID `xml:"id" json:"id"`
	// The datastore where the virtual storage object
	// is located.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["DeleteVStorageObjectRequestType"] = reflect.TypeOf((*DeleteVStorageObjectRequestType)(nil)).Elem()
}

type DeleteVStorageObject_Task DeleteVStorageObjectRequestType

func init() {
	t["DeleteVStorageObject_Task"] = reflect.TypeOf((*DeleteVStorageObject_Task)(nil)).Elem()
}

type DeleteVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DeleteVffsVolumeState DeleteVffsVolumeStateRequestType

func init() {
	t["DeleteVffsVolumeState"] = reflect.TypeOf((*DeleteVffsVolumeState)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DeleteVffsVolumeState`.
type DeleteVffsVolumeStateRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The VFFS UUID.
	VffsUuid string `xml:"vffsUuid" json:"vffsUuid"`
}

func init() {
	t["DeleteVffsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVffsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVffsVolumeStateResponse struct {
}

// The parameters of `VirtualDiskManager.DeleteVirtualDisk_Task`.
type DeleteVirtualDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the disk, either a datastore path or a URL
	// referring to the virtual disk to be deleted.
	Name string `xml:"name" json:"name"`
	// If <code>name</code> is a datastore path, the datacenter for
	// that datastore path. Not needed when invoked directly on ESX.
	// If not specified on a call to VirtualCenter,
	// <code>name</code> must be a URL.
	//
	// Refers instance of `Datacenter`.
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty" json:"datacenter,omitempty"`
}

func init() {
	t["DeleteVirtualDiskRequestType"] = reflect.TypeOf((*DeleteVirtualDiskRequestType)(nil)).Elem()
}

type DeleteVirtualDisk_Task DeleteVirtualDiskRequestType

func init() {
	t["DeleteVirtualDisk_Task"] = reflect.TypeOf((*DeleteVirtualDisk_Task)(nil)).Elem()
}

type DeleteVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DeleteVmfsVolumeState DeleteVmfsVolumeStateRequestType

func init() {
	t["DeleteVmfsVolumeState"] = reflect.TypeOf((*DeleteVmfsVolumeState)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DeleteVmfsVolumeState`.
type DeleteVmfsVolumeStateRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The VMFS UUID.
	VmfsUuid string `xml:"vmfsUuid" json:"vmfsUuid"`
}

func init() {
	t["DeleteVmfsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVmfsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVmfsVolumeStateResponse struct {
}

type DeleteVsanObjects DeleteVsanObjectsRequestType

func init() {
	t["DeleteVsanObjects"] = reflect.TypeOf((*DeleteVsanObjects)(nil)).Elem()
}

// The parameters of `HostVsanInternalSystem.DeleteVsanObjects`.
type DeleteVsanObjectsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// List of object UUIDs to be deleted.
	Uuids []string `xml:"uuids" json:"uuids"`
	// Optional force delete.
	Force *bool `xml:"force" json:"force,omitempty"`
}

func init() {
	t["DeleteVsanObjectsRequestType"] = reflect.TypeOf((*DeleteVsanObjectsRequestType)(nil)).Elem()
}

type DeleteVsanObjectsResponse struct {
	Returnval []HostVsanInternalSystemDeleteVsanObjectsResult `xml:"returnval" json:"returnval"`
}

// Thrown on an attempt to use an unsupported delta disk format.
type DeltaDiskFormatNotSupported struct {
	VmConfigFault

	// The datastores which do not support the specified format.
	//
	// Refers instances of `Datastore`.
	Datastore []ManagedObjectReference `xml:"datastore,omitempty" json:"datastore,omitempty"`
	// The format not supported.
	//
	// See `DeltaDiskFormat`.
	DeltaDiskFormat string `xml:"deltaDiskFormat" json:"deltaDiskFormat"`
}

func init() {
	t["DeltaDiskFormatNotSupported"] = reflect.TypeOf((*DeltaDiskFormatNotSupported)(nil)).Elem()
}

type DeltaDiskFormatNotSupportedFault DeltaDiskFormatNotSupported

func init() {
	t["DeltaDiskFormatNotSupportedFault"] = reflect.TypeOf((*DeltaDiskFormatNotSupportedFault)(nil)).Elem()
}

// Static strings used for describing an object or property.
type Description struct {
	DynamicData

	// Display label.
	Label string `xml:"label" json:"label"`
	// Summary description.
	Summary string `xml:"summary" json:"summary"`
}

func init() {
	t["Description"] = reflect.TypeOf((*Description)(nil)).Elem()
}

type DeselectVnic DeselectVnicRequestType

func init() {
	t["DeselectVnic"] = reflect.TypeOf((*DeselectVnic)(nil)).Elem()
}

type DeselectVnicForNicType DeselectVnicForNicTypeRequestType

func init() {
	t["DeselectVnicForNicType"] = reflect.TypeOf((*DeselectVnicForNicType)(nil)).Elem()
}

// The parameters of `HostVirtualNicManager.DeselectVnicForNicType`.
type DeselectVnicForNicTypeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The type of VirtualNic that would be deselected
	NicType string `xml:"nicType" json:"nicType"`
	// The device that uniquely identifies the VirtualNic.
	Device string `xml:"device" json:"device"`
}

func init() {
	t["DeselectVnicForNicTypeRequestType"] = reflect.TypeOf((*DeselectVnicForNicTypeRequestType)(nil)).Elem()
}

type DeselectVnicForNicTypeResponse struct {
}

type DeselectVnicRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DeselectVnicRequestType"] = reflect.TypeOf((*DeselectVnicRequestType)(nil)).Elem()
}

type DeselectVnicResponse struct {
}

// Desired Software Spec is defined as combination of base-image and add-on
// component which user wants to install on ESX host or cluster.
type DesiredSoftwareSpec struct {
	DynamicData

	// Describes a specific base-image spec for the ESX host.
	BaseImageSpec DesiredSoftwareSpecBaseImageSpec `xml:"baseImageSpec" json:"baseImageSpec"`
	// Vendor add-on info for desired software spec.
	VendorAddOnSpec *DesiredSoftwareSpecVendorAddOnSpec `xml:"vendorAddOnSpec,omitempty" json:"vendorAddOnSpec,omitempty"`
	// Additional components which should be part of the desired software
	// spec.
	//
	// These components would override the components present in
	// `DesiredSoftwareSpec.vendorAddOnSpec` and `DesiredSoftwareSpec.baseImageSpec`.
	Components []DesiredSoftwareSpecComponentSpec `xml:"components,omitempty" json:"components,omitempty" vim:"7.0.2.0"`
	// Components which should not be part of the desired software
	// spec.
	//
	// These components are not applied on the host.
	RemovedComponents []string `xml:"removedComponents,omitempty" json:"removedComponents,omitempty" vim:"8.0.3.0"`
}

func init() {
	t["DesiredSoftwareSpec"] = reflect.TypeOf((*DesiredSoftwareSpec)(nil)).Elem()
}

// Describes base-image spec for the ESX host.
type DesiredSoftwareSpecBaseImageSpec struct {
	DynamicData

	// Version of the base-image.
	Version string `xml:"version" json:"version"`
}

func init() {
	t["DesiredSoftwareSpecBaseImageSpec"] = reflect.TypeOf((*DesiredSoftwareSpecBaseImageSpec)(nil)).Elem()
}

// Component information for the ESX host.
type DesiredSoftwareSpecComponentSpec struct {
	DynamicData

	// Name of the component.
	Name string `xml:"name" json:"name"`
	// Version of the component.
	//
	// This field is required in the
	// current release.
	Version string `xml:"version,omitempty" json:"version,omitempty"`
}

func init() {
	t["DesiredSoftwareSpecComponentSpec"] = reflect.TypeOf((*DesiredSoftwareSpecComponentSpec)(nil)).Elem()
	minAPIVersionForType["DesiredSoftwareSpecComponentSpec"] = "7.0.2.0"
}

// Vendor specific add-on info for ESX host.
type DesiredSoftwareSpecVendorAddOnSpec struct {
	DynamicData

	// Vendor add-on name.
	Name string `xml:"name" json:"name"`
	// Vendor add-on version.
	Version string `xml:"version" json:"version"`
}

func init() {
	t["DesiredSoftwareSpecVendorAddOnSpec"] = reflect.TypeOf((*DesiredSoftwareSpecVendorAddOnSpec)(nil)).Elem()
}

// For one of the networks that the virtual machine is using, the corresponding
// switch on the host is full.
//
// If returned as part of migration checks, this is an error
// if either of the following is true, a warning otherwise:
//   - The virtual ethernet card device backing is a distributed virtual switch
//   - The virtual ethernet card device backing is a standard network and the
//     the device is connected
type DestinationSwitchFull struct {
	CannotAccessNetwork
}

func init() {
	t["DestinationSwitchFull"] = reflect.TypeOf((*DestinationSwitchFull)(nil)).Elem()
}

type DestinationSwitchFullFault DestinationSwitchFull

func init() {
	t["DestinationSwitchFullFault"] = reflect.TypeOf((*DestinationSwitchFullFault)(nil)).Elem()
}

// Fault thrown for the case that an attempt is made to move a host which
// is enabled for VSAN into a `ClusterComputeResource` which is
// disabled for VSAN.
//
// See also `CannotMoveVsanEnabledHost`.
type DestinationVsanDisabled struct {
	CannotMoveVsanEnabledHost

	// Name of the disabled destination `ClusterComputeResource`.
	//
	// See also `ManagedEntity.name`.
	DestinationCluster string `xml:"destinationCluster" json:"destinationCluster"`
}

func init() {
	t["DestinationVsanDisabled"] = reflect.TypeOf((*DestinationVsanDisabled)(nil)).Elem()
}

type DestinationVsanDisabledFault DestinationVsanDisabled

func init() {
	t["DestinationVsanDisabledFault"] = reflect.TypeOf((*DestinationVsanDisabledFault)(nil)).Elem()
}

type DestroyChildren DestroyChildrenRequestType

func init() {
	t["DestroyChildren"] = reflect.TypeOf((*DestroyChildren)(nil)).Elem()
}

type DestroyChildrenRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyChildrenRequestType"] = reflect.TypeOf((*DestroyChildrenRequestType)(nil)).Elem()
}

type DestroyChildrenResponse struct {
}

type DestroyCollector DestroyCollectorRequestType

func init() {
	t["DestroyCollector"] = reflect.TypeOf((*DestroyCollector)(nil)).Elem()
}

type DestroyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyCollectorRequestType"] = reflect.TypeOf((*DestroyCollectorRequestType)(nil)).Elem()
}

type DestroyCollectorResponse struct {
}

type DestroyDatastore DestroyDatastoreRequestType

func init() {
	t["DestroyDatastore"] = reflect.TypeOf((*DestroyDatastore)(nil)).Elem()
}

type DestroyDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyDatastoreRequestType"] = reflect.TypeOf((*DestroyDatastoreRequestType)(nil)).Elem()
}

type DestroyDatastoreResponse struct {
}

type DestroyIpPool DestroyIpPoolRequestType

func init() {
	t["DestroyIpPool"] = reflect.TypeOf((*DestroyIpPool)(nil)).Elem()
}

// The parameters of `IpPoolManager.DestroyIpPool`.
type DestroyIpPoolRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The datacenter on which to find the pool
	//
	// Required privileges: Datacenter.IpPoolConfig
	//
	// Refers instance of `Datacenter`.
	Dc ManagedObjectReference `xml:"dc" json:"dc"`
	// The unique ID of the pool
	Id int32 `xml:"id" json:"id"`
	// If true, the pool will be destroyed even if it is in use
	Force bool `xml:"force" json:"force"`
}

func init() {
	t["DestroyIpPoolRequestType"] = reflect.TypeOf((*DestroyIpPoolRequestType)(nil)).Elem()
}

type DestroyIpPoolResponse struct {
}

type DestroyNetwork DestroyNetworkRequestType

func init() {
	t["DestroyNetwork"] = reflect.TypeOf((*DestroyNetwork)(nil)).Elem()
}

type DestroyNetworkRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyNetworkRequestType"] = reflect.TypeOf((*DestroyNetworkRequestType)(nil)).Elem()
}

type DestroyNetworkResponse struct {
}

type DestroyProfile DestroyProfileRequestType

func init() {
	t["DestroyProfile"] = reflect.TypeOf((*DestroyProfile)(nil)).Elem()
}

type DestroyProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyProfileRequestType"] = reflect.TypeOf((*DestroyProfileRequestType)(nil)).Elem()
}

type DestroyProfileResponse struct {
}

type DestroyPropertyCollector DestroyPropertyCollectorRequestType

func init() {
	t["DestroyPropertyCollector"] = reflect.TypeOf((*DestroyPropertyCollector)(nil)).Elem()
}

type DestroyPropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyPropertyCollectorRequestType"] = reflect.TypeOf((*DestroyPropertyCollectorRequestType)(nil)).Elem()
}

type DestroyPropertyCollectorResponse struct {
}

type DestroyPropertyFilter DestroyPropertyFilterRequestType

func init() {
	t["DestroyPropertyFilter"] = reflect.TypeOf((*DestroyPropertyFilter)(nil)).Elem()
}

type DestroyPropertyFilterRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyPropertyFilterRequestType"] = reflect.TypeOf((*DestroyPropertyFilterRequestType)(nil)).Elem()
}

type DestroyPropertyFilterResponse struct {
}

type DestroyRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyRequestType"] = reflect.TypeOf((*DestroyRequestType)(nil)).Elem()
}

type DestroyVffs DestroyVffsRequestType

func init() {
	t["DestroyVffs"] = reflect.TypeOf((*DestroyVffs)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DestroyVffs`.
type DestroyVffsRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The path of the VFFS to destroy. See `FileSystemMountInfo`.
	VffsPath string `xml:"vffsPath" json:"vffsPath"`
}

func init() {
	t["DestroyVffsRequestType"] = reflect.TypeOf((*DestroyVffsRequestType)(nil)).Elem()
}

type DestroyVffsResponse struct {
}

type DestroyView DestroyViewRequestType

func init() {
	t["DestroyView"] = reflect.TypeOf((*DestroyView)(nil)).Elem()
}

type DestroyViewRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DestroyViewRequestType"] = reflect.TypeOf((*DestroyViewRequestType)(nil)).Elem()
}

type DestroyViewResponse struct {
}

type Destroy_Task DestroyRequestType

func init() {
	t["Destroy_Task"] = reflect.TypeOf((*Destroy_Task)(nil)).Elem()
}

type Destroy_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `VirtualMachine.DetachDisk_Task`.
type DetachDiskRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The ID of the virtual disk to be operated. See
	// `ID`
	DiskId ID `xml:"diskId" json:"diskId"`
}

func init() {
	t["DetachDiskRequestType"] = reflect.TypeOf((*DetachDiskRequestType)(nil)).Elem()
}

type DetachDisk_Task DetachDiskRequestType

func init() {
	t["DetachDisk_Task"] = reflect.TypeOf((*DetachDisk_Task)(nil)).Elem()
}

type DetachDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DetachScsiLun DetachScsiLunRequestType

func init() {
	t["DetachScsiLun"] = reflect.TypeOf((*DetachScsiLun)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DetachScsiLunEx_Task`.
type DetachScsiLunExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// each element specifies UUID of LUN to be detached.
	LunUuid []string `xml:"lunUuid" json:"lunUuid"`
}

func init() {
	t["DetachScsiLunExRequestType"] = reflect.TypeOf((*DetachScsiLunExRequestType)(nil)).Elem()
}

type DetachScsiLunEx_Task DetachScsiLunExRequestType

func init() {
	t["DetachScsiLunEx_Task"] = reflect.TypeOf((*DetachScsiLunEx_Task)(nil)).Elem()
}

type DetachScsiLunEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostStorageSystem.DetachScsiLun`.
type DetachScsiLunRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The uuid of the ScsiLun device to detach.
	LunUuid string `xml:"lunUuid" json:"lunUuid"`
}

func init() {
	t["DetachScsiLunRequestType"] = reflect.TypeOf((*DetachScsiLunRequestType)(nil)).Elem()
}

type DetachScsiLunResponse struct {
}

type DetachTagFromVStorageObject DetachTagFromVStorageObjectRequestType

func init() {
	t["DetachTagFromVStorageObject"] = reflect.TypeOf((*DetachTagFromVStorageObject)(nil)).Elem()
}

// The parameters of `VcenterVStorageObjectManager.DetachTagFromVStorageObject`.
type DetachTagFromVStorageObjectRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The identifier(ID) of the virtual storage object.
	Id ID `xml:"id" json:"id"`
	// The category to which the tag belongs.
	Category string `xml:"category" json:"category"`
	// The tag which has to be disassociated with the virtual storage
	// object.
	Tag string `xml:"tag" json:"tag"`
}

func init() {
	t["DetachTagFromVStorageObjectRequestType"] = reflect.TypeOf((*DetachTagFromVStorageObjectRequestType)(nil)).Elem()
}

type DetachTagFromVStorageObjectResponse struct {
}

// Specification used to create a host device backed virtual disk
type DeviceBackedVirtualDiskSpec struct {
	VirtualDiskSpec

	// The deviceName of the backing device
	//
	// See also `ScsiLun`.
	Device string `xml:"device" json:"device"`
}

func init() {
	t["DeviceBackedVirtualDiskSpec"] = reflect.TypeOf((*DeviceBackedVirtualDiskSpec)(nil)).Elem()
}

// The device is backed by a backing type which is not supported
// for this particular device.
//
// If this fault is returned as a subfault of
// DisallowedMigrationDeviceAttached, this indicates that although
// this backing for the device may be supported on the destination
// host, the hosts do not support the requested migration of the
// virtual machine while using this device with this backing.
type DeviceBackingNotSupported struct {
	DeviceNotSupported

	// The type of the backing.
	Backing string `xml:"backing" json:"backing"`
}

func init() {
	t["DeviceBackingNotSupported"] = reflect.TypeOf((*DeviceBackingNotSupported)(nil)).Elem()
}

type DeviceBackingNotSupportedFault BaseDeviceBackingNotSupported

func init() {
	t["DeviceBackingNotSupportedFault"] = reflect.TypeOf((*DeviceBackingNotSupportedFault)(nil)).Elem()
}

// The device in question is supported, but the device-controller
// combination is not supported.
//
// If this fault is returned as a subfault of
// DisallowedMigrationDeviceAttached, this indicates that although
// this device-controller combination may be supported on the
// destination host, the hosts do not support the requested migration
// of the virtual machine while using this device and controller.
type DeviceControllerNotSupported struct {
	DeviceNotSupported

	// The type of the controller.
	Controller string `xml:"controller" json:"controller"`
}

func init() {
	t["DeviceControllerNotSupported"] = reflect.TypeOf((*DeviceControllerNotSupported)(nil)).Elem()
}

type DeviceControllerNotSupportedFault DeviceControllerNotSupported

func init() {
	t["DeviceControllerNotSupportedFault"] = reflect.TypeOf((*DeviceControllerNotSupportedFault)(nil)).Elem()
}

// Identifier of a replication device group.
type DeviceGroupId struct {
	DynamicData

	// ID of the device group.
	Id string `xml:"id" json:"id"`
}

func init() {
	t["DeviceGroupId"] = reflect.TypeOf((*DeviceGroupId)(nil)).Elem()
}

// A DeviceHotPlugNotSupported exception is thrown if the specified device
// cannot be hot-added or hot-removed from the virtual machine
// at this time.
type DeviceHotPlugNotSupported struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceHotPlugNotSupported"] = reflect.TypeOf((*DeviceHotPlugNotSupported)(nil)).Elem()
}

type DeviceHotPlugNotSupportedFault DeviceHotPlugNotSupported

func init() {
	t["DeviceHotPlugNotSupportedFault"] = reflect.TypeOf((*DeviceHotPlugNotSupportedFault)(nil)).Elem()
}

// A DeviceNotFound exception is thrown if
// a device to be edited or removed
// cannot be found.
//
// Most likely, the client incorrectly passed
// the device key.
type DeviceNotFound struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceNotFound"] = reflect.TypeOf((*DeviceNotFound)(nil)).Elem()
}

type DeviceNotFoundFault DeviceNotFound

func init() {
	t["DeviceNotFoundFault"] = reflect.TypeOf((*DeviceNotFoundFault)(nil)).Elem()
}

// The virtual machine uses a device type that is not supported on the
// host.
//
// If this fault is returned as a subfault of
// `DisallowedMigrationDeviceAttached`, this indicates that although
// this device may be supported on the destination host, the hosts do
// not support the requested migration of the virtual machine while
// using this device.
type DeviceNotSupported struct {
	VirtualHardwareCompatibilityIssue

	// The label of the device.
	Device string `xml:"device" json:"device"`
	// The specific reason why the device is not supported.
	//
	// Values should come from `DeviceNotSupportedReason_enum`.
	// This might not be set if we're not sure of the reason, or
	// if this doesn't make sense in the context. For example,
	// in the `DisallowedMigrationDeviceAttached` context
	// we already know the problem.
	Reason string `xml:"reason,omitempty" json:"reason,omitempty"`
}

func init() {
	t["DeviceNotSupported"] = reflect.TypeOf((*DeviceNotSupported)(nil)).Elem()
}

type DeviceNotSupportedFault BaseDeviceNotSupported

func init() {
	t["DeviceNotSupportedFault"] = reflect.TypeOf((*DeviceNotSupportedFault)(nil)).Elem()
}

// A DeviceUnsupportedForVmPlatform exception is thrown if the specified device
// is not supported on the platform on which the virtual machine is being
// created/configured.
//
// For example, this exception might be thrown if a client
// incorrectly attempts to add a device supported only on ESX Server to a
// virtual machine on a hosted product.
type DeviceUnsupportedForVmPlatform struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceUnsupportedForVmPlatform"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatform)(nil)).Elem()
}

type DeviceUnsupportedForVmPlatformFault DeviceUnsupportedForVmPlatform

func init() {
	t["DeviceUnsupportedForVmPlatformFault"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatformFault)(nil)).Elem()
}

// A DeviceUnsupportedForVmVersion exception is thrown if a specific device
// is not supported for a given version of the virtual machine.
type DeviceUnsupportedForVmVersion struct {
	InvalidDeviceSpec

	// The current version of the virtual machine.
	CurrentVersion string `xml:"currentVersion" json:"currentVersion"`
	// The minimum expected virtual mahcine version needed to
	// support this device.
	ExpectedVersion string `xml:"expectedVersion" json:"expectedVersion"`
}

func init() {
	t["DeviceUnsupportedForVmVersion"] = reflect.TypeOf((*DeviceUnsupportedForVmVersion)(nil)).Elem()
}

type DeviceUnsupportedForVmVersionFault DeviceUnsupportedForVmVersion

func init() {
	t["DeviceUnsupportedForVmVersionFault"] = reflect.TypeOf((*DeviceUnsupportedForVmVersionFault)(nil)).Elem()
}

type DiagnosticManagerAuditRecordResult struct {
	DynamicData

	// Zero or more audit records returned.
	//
	// Each audit record is a UTF-8 string in RFC 5424 format. See RFC 5424,
	// page 8, for the ABNF grammar.
	//
	// The HOSTNAME and MSGID fields are set to "-", the structured data
	// contains the audit record parameters, no unstructured data will be
	// present, and each record is terminated with an ASCII LF (newline).
	Records []string `xml:"records,omitempty" json:"records,omitempty"`
	// The token to be used for subsequent read operations.
	//
	// The string is "opaque"; the format of this data changes over time.
	NextToken string `xml:"nextToken" json:"nextToken"`
}

func init() {
	t["DiagnosticManagerAuditRecordResult"] = reflect.TypeOf((*DiagnosticManagerAuditRecordResult)(nil)).Elem()
	minAPIVersionForType["DiagnosticManagerAuditRecordResult"] = "7.0.3.0"
}

// Describes a location of a diagnostic bundle and the server to which
// it belongs.
//
// This is a return type for the generateLogBundles operation.
type DiagnosticManagerBundleInfo struct {
	DynamicData

	// The host to which this diagnostic bundle belongs.
	//
	// If this is for the default server, then it is not set.
	//
	// Refers instance of `HostSystem`.
	System *ManagedObjectReference `xml:"system,omitempty" json:"system,omitempty"`
	// The location from which the diagnostic bundle can be downloaded.
	//
	// The host part of the URL is returned as '\*' if the hostname to be used
	// is the name of the server to which the call was made. For example, if
	// the call is made to vcsrv1.domain1.com, and the bundle is available
	// for download from http://vcsrv1.domain1.com/diagnostics/bundle.zip,
	// the URL returned may be http:// \* /diagnostics/bundle.zip. The client
	// replaces the asterisk with the server name on which it invoked the
	// call.
	Url string `xml:"url" json:"url"`
}

func init() {
	t["DiagnosticManagerBundleInfo"] = reflect.TypeOf((*DiagnosticManagerBundleInfo)(nil)).Elem()
}

// Describes a log file that is available on a server.
type DiagnosticManagerLogDescriptor struct {
	DynamicData

	// A key to identify the log file for browsing and download operations.
	Key string `xml:"key" json:"key"`
	// The filename of the log.
	FileName string `xml:"fileName" json:"fileName"`
	// The application that generated the log file.
	//
	// For more information on currently supported creators, see
	// `DiagnosticManagerLogCreator_enum`.
	Creator string `xml:"creator" json:"creator"`
	// Describes the format of the log file.
	//
	// For more information on currently supported formats, see
	// `DiagnosticManagerLogFormat_enum`.
	Format string `xml:"format" json:"format"`
	// Describes the mime-type of the returned file.
	//
	// Typical
	// mime-types include:
	//   - text/plain - for a plain log file
	MimeType string `xml:"mimeType" json:"mimeType"`
	// Localized description of log file.
	Info BaseDescription `xml:"info,typeattr" json:"info"`
}

func init() {
	t["DiagnosticManagerLogDescriptor"] = reflect.TypeOf((*DiagnosticManagerLogDescriptor)(nil)).Elem()
}

// A header that is returned with a set of log entries.
//
// This header describes where entries are located in the log file. Log
// files typically grow dynamically, so indexes based on line numbers may
// become inaccurate.
type DiagnosticManagerLogHeader struct {
	DynamicData

	// The first line of this log segment.
	LineStart int32 `xml:"lineStart" json:"lineStart"`
	// The last line of this log segment.
	LineEnd int32 `xml:"lineEnd" json:"lineEnd"`
	// Log entries, listed by line, for this log segment.
	LineText []string `xml:"lineText,omitempty" json:"lineText,omitempty"`
}

func init() {
	t["DiagnosticManagerLogHeader"] = reflect.TypeOf((*DiagnosticManagerLogHeader)(nil)).Elem()
}

// The digest file of the specified virtual disk is not supported.
//
// Typically, this fault is returned as part of a parent fault like
// `VmConfigIncompatibleForFaultTolerance`, indicating that the
// virtual disk's digest file needs to be changed before fault tolerance can be
// enabled on the associated virtual machine.
type DigestNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["DigestNotSupported"] = reflect.TypeOf((*DigestNotSupported)(nil)).Elem()
}

type DigestNotSupportedFault DigestNotSupported

func init() {
	t["DigestNotSupportedFault"] = reflect.TypeOf((*DigestNotSupportedFault)(nil)).Elem()
}

// This fault is thrown when an operation fails because the specified
// directory is not empty.
type DirectoryNotEmpty struct {
	FileFault
}

func init() {
	t["DirectoryNotEmpty"] = reflect.TypeOf((*DirectoryNotEmpty)(nil)).Elem()
}

type DirectoryNotEmptyFault DirectoryNotEmpty

func init() {
	t["DirectoryNotEmptyFault"] = reflect.TypeOf((*DirectoryNotEmptyFault)(nil)).Elem()
}

// Fault thrown when an attempt is made to move a disk with associated snapshots to a destination host.
//
// If such a move were to occur, snapshots associated with the disk would be irrevocably
// lost. This is always an error.
type DisableAdminNotSupported struct {
	HostConfigFault
}

func init() {
	t["DisableAdminNotSupported"] = reflect.TypeOf((*DisableAdminNotSupported)(nil)).Elem()
}

type DisableAdminNotSupportedFault DisableAdminNotSupported

func init() {
	t["DisableAdminNotSupportedFault"] = reflect.TypeOf((*DisableAdminNotSupportedFault)(nil)).Elem()
}

type DisableAlarm DisableAlarmRequestType

func init() {
	t["DisableAlarm"] = reflect.TypeOf((*DisableAlarm)(nil)).Elem()
}

// The parameters of `AlarmManager.DisableAlarm`.
type DisableAlarmRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The Alarm being disabled.
	//
	// Required privileges: Alarm.ToggleEnableOnEntity
	//
	// Refers instance of `Alarm`.
	Alarm ManagedObjectReference `xml:"alarm" json:"alarm"`
	// The ManagedEntity on which to disable the alarm.
	//
	// Required privileges: System.Read
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["DisableAlarmRequestType"] = reflect.TypeOf((*DisableAlarmRequestType)(nil)).Elem()
}

type DisableAlarmResponse struct {
}

type DisableClusteredVmdkSupport DisableClusteredVmdkSupportRequestType

func init() {
	t["DisableClusteredVmdkSupport"] = reflect.TypeOf((*DisableClusteredVmdkSupport)(nil)).Elem()
}

// The parameters of `HostDatastoreSystem.DisableClusteredVmdkSupport`.
type DisableClusteredVmdkSupportRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Datastore on which clustered vmdk should be
	// disabled.
	//
	// Refers instance of `Datastore`.
	Datastore ManagedObjectReference `xml:"datastore" json:"datastore"`
}

func init() {
	t["DisableClusteredVmdkSupportRequestType"] = reflect.TypeOf((*DisableClusteredVmdkSupportRequestType)(nil)).Elem()
}

type DisableClusteredVmdkSupportResponse struct {
}

type DisableEvcModeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DisableEvcModeRequestType"] = reflect.TypeOf((*DisableEvcModeRequestType)(nil)).Elem()
}

type DisableEvcMode_Task DisableEvcModeRequestType

func init() {
	t["DisableEvcMode_Task"] = reflect.TypeOf((*DisableEvcMode_Task)(nil)).Elem()
}

type DisableEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DisableFeature DisableFeatureRequestType

func init() {
	t["DisableFeature"] = reflect.TypeOf((*DisableFeature)(nil)).Elem()
}

// The parameters of `LicenseManager.DisableFeature`.
type DisableFeatureRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// Host to act on if LicenseManager is not on a host.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// key of the feature to disable.
	FeatureKey string `xml:"featureKey" json:"featureKey"`
}

func init() {
	t["DisableFeatureRequestType"] = reflect.TypeOf((*DisableFeatureRequestType)(nil)).Elem()
}

type DisableFeatureResponse struct {
	Returnval bool `xml:"returnval" json:"returnval"`
}

type DisableHyperThreading DisableHyperThreadingRequestType

func init() {
	t["DisableHyperThreading"] = reflect.TypeOf((*DisableHyperThreading)(nil)).Elem()
}

type DisableHyperThreadingRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DisableHyperThreadingRequestType"] = reflect.TypeOf((*DisableHyperThreadingRequestType)(nil)).Elem()
}

type DisableHyperThreadingResponse struct {
}

type DisableMultipathPath DisableMultipathPathRequestType

func init() {
	t["DisableMultipathPath"] = reflect.TypeOf((*DisableMultipathPath)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DisableMultipathPath`.
type DisableMultipathPathRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The name of the path to disable.
	PathName string `xml:"pathName" json:"pathName"`
}

func init() {
	t["DisableMultipathPathRequestType"] = reflect.TypeOf((*DisableMultipathPathRequestType)(nil)).Elem()
}

type DisableMultipathPathResponse struct {
}

type DisableRuleset DisableRulesetRequestType

func init() {
	t["DisableRuleset"] = reflect.TypeOf((*DisableRuleset)(nil)).Elem()
}

// The parameters of `HostFirewallSystem.DisableRuleset`.
type DisableRulesetRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Id   string                 `xml:"id" json:"id"`
}

func init() {
	t["DisableRulesetRequestType"] = reflect.TypeOf((*DisableRulesetRequestType)(nil)).Elem()
}

type DisableRulesetResponse struct {
}

// The parameters of `VirtualMachine.DisableSecondaryVM_Task`.
type DisableSecondaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The secondary virtual machine specified will be disabed.
	// This field must specify a secondary virtual machine that is part of the fault
	// tolerant group that this virtual machine is currently associated with. It can
	// only be invoked from the primary virtual machine in the group.
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
}

func init() {
	t["DisableSecondaryVMRequestType"] = reflect.TypeOf((*DisableSecondaryVMRequestType)(nil)).Elem()
}

type DisableSecondaryVM_Task DisableSecondaryVMRequestType

func init() {
	t["DisableSecondaryVM_Task"] = reflect.TypeOf((*DisableSecondaryVM_Task)(nil)).Elem()
}

type DisableSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DisableSmartCardAuthentication DisableSmartCardAuthenticationRequestType

func init() {
	t["DisableSmartCardAuthentication"] = reflect.TypeOf((*DisableSmartCardAuthentication)(nil)).Elem()
}

type DisableSmartCardAuthenticationRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DisableSmartCardAuthenticationRequestType"] = reflect.TypeOf((*DisableSmartCardAuthenticationRequestType)(nil)).Elem()
}

type DisableSmartCardAuthenticationResponse struct {
}

// Fault thrown if the disallowed operation is invoked by the client.
//
// The
// change is disallowed because it conflicts with target state maintained
// by a service. The corresponding method is usually not disabled because
// only a subset of changes carried out by the method is disallowed. For
// example, an online extend executed via virtual machine reconfigure
// method is not allowed if replication is enabled on a virtual machine.
type DisallowedChangeByService struct {
	RuntimeFault

	// The service that has disallowed the change.
	ServiceName string `xml:"serviceName" json:"serviceName"`
	// The change this is not allowed, the set of possible values is
	// described in `DisallowedChangeByServiceDisallowedChange_enum`.
	DisallowedChange string `xml:"disallowedChange,omitempty" json:"disallowedChange,omitempty"`
}

func init() {
	t["DisallowedChangeByService"] = reflect.TypeOf((*DisallowedChangeByService)(nil)).Elem()
}

type DisallowedChangeByServiceFault DisallowedChangeByService

func init() {
	t["DisallowedChangeByServiceFault"] = reflect.TypeOf((*DisallowedChangeByServiceFault)(nil)).Elem()
}

// Thrown when the `VirtualMachine.ReconfigVM_Task` operation
// includes a change to the `VirtualDiskMode_enum`
// property.
//
// This property cannot be changed as long as a virtual machine
// has an existing snapshot.
type DisallowedDiskModeChange struct {
	InvalidDeviceSpec
}

func init() {
	t["DisallowedDiskModeChange"] = reflect.TypeOf((*DisallowedDiskModeChange)(nil)).Elem()
}

type DisallowedDiskModeChangeFault DisallowedDiskModeChange

func init() {
	t["DisallowedDiskModeChangeFault"] = reflect.TypeOf((*DisallowedDiskModeChangeFault)(nil)).Elem()
}

// The virtual machine is using a type of device that prevents migration.
type DisallowedMigrationDeviceAttached struct {
	MigrationFault

	// A fault specifies the particular device issue.
	//
	// This is typically
	// a subclass of VirtualHardwareCompatibilityIssue, such as
	// RawDiskNotSupported, RemoteDeviceNotSupported, or SharedBusControllerNotSupported
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["DisallowedMigrationDeviceAttached"] = reflect.TypeOf((*DisallowedMigrationDeviceAttached)(nil)).Elem()
}

type DisallowedMigrationDeviceAttachedFault DisallowedMigrationDeviceAttached

func init() {
	t["DisallowedMigrationDeviceAttachedFault"] = reflect.TypeOf((*DisallowedMigrationDeviceAttachedFault)(nil)).Elem()
}

// Fault thrown when an attempt is made to perform a disallowed operation on a
// host that has been configured as a failover host in an cluster that has High
// Availability enabled.
//
// See `ClusterFailoverHostAdmissionControlPolicy`.
// Examples of such operations are destroying a host, moving a host out of a cluster,
// or powering on a virtual machine on a specific host.
type DisallowedOperationOnFailoverHost struct {
	RuntimeFault

	// The failover host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Name of the failover host.
	Hostname string `xml:"hostname" json:"hostname"`
}

func init() {
	t["DisallowedOperationOnFailoverHost"] = reflect.TypeOf((*DisallowedOperationOnFailoverHost)(nil)).Elem()
}

type DisallowedOperationOnFailoverHostFault DisallowedOperationOnFailoverHost

func init() {
	t["DisallowedOperationOnFailoverHostFault"] = reflect.TypeOf((*DisallowedOperationOnFailoverHostFault)(nil)).Elem()
}

type DisconnectHostRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DisconnectHostRequestType"] = reflect.TypeOf((*DisconnectHostRequestType)(nil)).Elem()
}

type DisconnectHost_Task DisconnectHostRequestType

func init() {
	t["DisconnectHost_Task"] = reflect.TypeOf((*DisconnectHost_Task)(nil)).Elem()
}

type DisconnectHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

type DisconnectNvmeController DisconnectNvmeControllerRequestType

func init() {
	t["DisconnectNvmeController"] = reflect.TypeOf((*DisconnectNvmeController)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DisconnectNvmeControllerEx_Task`.
type DisconnectNvmeControllerExRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A list of data objects, each specifying the parameters
	// necessary to disconnect an NVMe controller.
	DisconnectSpec []HostNvmeDisconnectSpec `xml:"disconnectSpec,omitempty" json:"disconnectSpec,omitempty"`
}

func init() {
	t["DisconnectNvmeControllerExRequestType"] = reflect.TypeOf((*DisconnectNvmeControllerExRequestType)(nil)).Elem()
	minAPIVersionForType["DisconnectNvmeControllerExRequestType"] = "7.0.3.0"
}

type DisconnectNvmeControllerEx_Task DisconnectNvmeControllerExRequestType

func init() {
	t["DisconnectNvmeControllerEx_Task"] = reflect.TypeOf((*DisconnectNvmeControllerEx_Task)(nil)).Elem()
}

type DisconnectNvmeControllerEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// The parameters of `HostStorageSystem.DisconnectNvmeController`.
type DisconnectNvmeControllerRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A data object that specifies the parameters
	// necessary to perform the disconnection.
	DisconnectSpec HostNvmeDisconnectSpec `xml:"disconnectSpec" json:"disconnectSpec"`
}

func init() {
	t["DisconnectNvmeControllerRequestType"] = reflect.TypeOf((*DisconnectNvmeControllerRequestType)(nil)).Elem()
}

type DisconnectNvmeControllerResponse struct {
}

// An attempt to enable Enhanced VMotion Compatibility on a cluster, or to
// select a less-featureful EVC mode for a cluster where EVC is already enabled,
// has failed because the cluster contains one or more disconnected hosts.
type DisconnectedHostsBlockingEVC struct {
	EVCConfigFault
}

func init() {
	t["DisconnectedHostsBlockingEVC"] = reflect.TypeOf((*DisconnectedHostsBlockingEVC)(nil)).Elem()
}

type DisconnectedHostsBlockingEVCFault DisconnectedHostsBlockingEVC

func init() {
	t["DisconnectedHostsBlockingEVCFault"] = reflect.TypeOf((*DisconnectedHostsBlockingEVCFault)(nil)).Elem()
}

type DiscoverFcoeHbas DiscoverFcoeHbasRequestType

func init() {
	t["DiscoverFcoeHbas"] = reflect.TypeOf((*DiscoverFcoeHbas)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DiscoverFcoeHbas`.
type DiscoverFcoeHbasRequestType struct {
	This     ManagedObjectReference      `xml:"_this" json:"-"`
	FcoeSpec FcoeConfigFcoeSpecification `xml:"fcoeSpec" json:"fcoeSpec"`
}

func init() {
	t["DiscoverFcoeHbasRequestType"] = reflect.TypeOf((*DiscoverFcoeHbasRequestType)(nil)).Elem()
}

type DiscoverFcoeHbasResponse struct {
}

type DiscoverNvmeControllers DiscoverNvmeControllersRequestType

func init() {
	t["DiscoverNvmeControllers"] = reflect.TypeOf((*DiscoverNvmeControllers)(nil)).Elem()
}

// The parameters of `HostStorageSystem.DiscoverNvmeControllers`.
type DiscoverNvmeControllersRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// A data object that specifies the parameters
	// necessary to retrieve the Discovery Log.
	DiscoverSpec HostNvmeDiscoverSpec `xml:"discoverSpec" json:"discoverSpec"`
}

func init() {
	t["DiscoverNvmeControllersRequestType"] = reflect.TypeOf((*DiscoverNvmeControllersRequestType)(nil)).Elem()
}

type DiscoverNvmeControllersResponse struct {
	Returnval HostNvmeDiscoveryLog `xml:"returnval" json:"returnval"`
}

// An area of the disk flagged as modified
type DiskChangeExtent struct {
	DynamicData

	// Start offset (in bytes) of modified area
	Start int64 `xml:"start" json:"start"`
	// Length (in bytes) of modified area
	Length int64 `xml:"length" json:"length"`
}

func init() {
	t["DiskChangeExtent"] = reflect.TypeOf((*DiskChangeExtent)(nil)).Elem()
}

// Data structure to describe areas in a disk associated with this VM that have
// been modified since a well-defined point in the past.
//
// Returned by
// `VirtualMachine.QueryChangedDiskAreas`. This data structure describes
// a subset of the disk identified by startOffset and length. All areas that
// have been modified within this interval are listed under changedArea.
type DiskChangeInfo struct {
	DynamicData

	// Start offset (in bytes) of disk area described by this data structure.
	StartOffset int64 `xml:"startOffset" json:"startOffset"`
	// Length (in bytes) of disk area described by this data structure.
	Length int64 `xml:"length" json:"length"`
	// Modified disk areas.
	//
	// Might be empty if no parts of the disk between
	// startOffset and startOffset + length were modified.
	ChangedArea []DiskChangeExtent `xml:"changedArea,omitempty" json:"changedArea,omitempty"`
}

func init() {
	t["DiskChangeInfo"] = reflect.TypeOf((*DiskChangeInfo)(nil)).Elem()
}

// This data object type contains the crypto information of all disks along
// the chain
type DiskCryptoSpec struct {
	DynamicData

	// The parent in the chain.
	Parent *DiskCryptoSpec `xml:"parent,omitempty" json:"parent,omitempty"`
	// Crypto information of the current disk.
	Crypto BaseCryptoSpec `xml:"crypto,typeattr" json:"crypto"`
}

func init() {
	t["DiskCryptoSpec"] = reflect.TypeOf((*DiskCryptoSpec)(nil)).Elem()
}

// Fault used for disks which have existing, non-VSAN partitions.
//
// See also `HostStorageSystem.UpdateDiskPartitions`, `HostVsanSystem.QueryDisksForVsan`.
type DiskHasPartitions struct {
	VsanDiskFault
}

func init() {
	t["DiskHasPartitions"] = reflect.TypeOf((*DiskHasPartitions)(nil)).Elem()
}

type DiskHasPartitionsFault DiskHasPartitions

func init() {
	t["DiskHasPartitionsFault"] = reflect.TypeOf((*DiskHasPartitionsFault)(nil)).Elem()
}

// Fault thrown for the case that an attempt is made to delete the last
// `VsanHostDiskMapping.nonSsd` from a `VsanHostDiskMapping`.
//
// See also `HostVsanSystem.RemoveDisk_Task`, `HostVsanSystem.RemoveDiskMapping_Task`.
type DiskIsLastRemainingNonSSD struct {
	VsanDiskFault
}

func init() {
	t["DiskIsLastRemainingNonSSD"] = reflect.TypeOf((*DiskIsLastRemainingNonSSD)(nil)).Elem()
}

type DiskIsLastRemainingNonSSDFault DiskIsLastRemainingNonSSD

func init() {
	t["DiskIsLastRemainingNonSSDFault"] = reflect.TypeOf((*DiskIsLastRemainingNonSSDFault)(nil)).Elem()
}

// Fault used for disks which are ineligible for VSAN because they are
// considered non-local.
//
// See also `HostVsanSystem.QueryDisksForVsan`.
type DiskIsNonLocal struct {
	VsanDiskFault
}

func init() {
	t["DiskIsNonLocal"] = reflect.TypeOf((*DiskIsNonLocal)(nil)).Elem()
}

type DiskIsNonLocalFault DiskIsNonLocal

func init() {
	t["DiskIsNonLocalFault"] = reflect.TypeOf((*DiskIsNonLocalFault)(nil)).Elem()
}

// Fault used for disks which are ineligible for VSAN because they are USB
// disks.
//
// See also `HostVsanSystem.QueryDisksForVsan`.
type DiskIsUSB struct {
	VsanDiskFault
}

func init() {
	t["DiskIsUSB"] = reflect.TypeOf((*DiskIsUSB)(nil)).Elem()
}

type DiskIsUSBFault DiskIsUSB

func init() {
	t["DiskIsUSBFault"] = reflect.TypeOf((*DiskIsUSBFault)(nil)).Elem()
}

// Specifying non-standard disk movement types is not supported.
//
// See also `VirtualMachineRelocateSpec.diskMoveType`, `VirtualMachineRelocateSpecDiskLocator.diskMoveType`.
type DiskMoveTypeNotSupported struct {
	MigrationFault
}

func init() {
	t["DiskMoveTypeNotSupported"] = reflect.TypeOf((*DiskMoveTypeNotSupported)(nil)).Elem()
}

type DiskMoveTypeNotSupportedFault DiskMoveTypeNotSupported

func init() {
	t["DiskMoveTypeNotSupportedFault"] = reflect.TypeOf((*DiskMoveTypeNotSupportedFault)(nil)).Elem()
}

// The host does not support the backings for the disks specified by the virtual
// machine.
//
// For example, this fault is thrown if a virtual machine is created from
// a template that specifies backings that the host does not have. Similarly, this fault
// is thrown if a virtual machine is registered on a host that does not support the
// specified backings.
type DiskNotSupported struct {
	VirtualHardwareCompatibilityIssue

	// The ID of disk that is not supported.
	Disk int32 `xml:"disk" json:"disk"`
}

func init() {
	t["DiskNotSupported"] = reflect.TypeOf((*DiskNotSupported)(nil)).Elem()
}

type DiskNotSupportedFault BaseDiskNotSupported

func init() {
	t["DiskNotSupportedFault"] = reflect.TypeOf((*DiskNotSupportedFault)(nil)).Elem()
}

// Fault used for disks which are too small for usage by VSAN.
type DiskTooSmall struct {
	VsanDiskFault
}

func init() {
	t["DiskTooSmall"] = reflect.TypeOf((*DiskTooSmall)(nil)).Elem()
}

type DiskTooSmallFault DiskTooSmall

func init() {
	t["DiskTooSmallFault"] = reflect.TypeOf((*DiskTooSmallFault)(nil)).Elem()
}

type DissociateProfile DissociateProfileRequestType

func init() {
	t["DissociateProfile"] = reflect.TypeOf((*DissociateProfile)(nil)).Elem()
}

// The parameters of `Profile.DissociateProfile`.
type DissociateProfileRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// List of entities. The vCenter Server will remove the associations
	// that the profile has with the entities in the list. If unset,
	// the Server removes all the associations that the profile has with any
	// managed entities in the inventory.
	// If the specified entity is not associated with the profile,
	// the Server does not perform any action.
	//
	// Refers instances of `ManagedEntity`.
	Entity []ManagedObjectReference `xml:"entity,omitempty" json:"entity,omitempty"`
}

func init() {
	t["DissociateProfileRequestType"] = reflect.TypeOf((*DissociateProfileRequestType)(nil)).Elem()
}

type DissociateProfileResponse struct {
}

// The `DistributedVirtualPort` data object represents a port in a
// `DistributedVirtualSwitch`.
//
// Virtual ports are part of a distributed
// virtual portgroup. Servers create virtual ports according to the portgroup type
// (`DistributedVirtualPortgroup*.*DistributedVirtualPortgroup.config*.*DVPortgroupConfigInfo.type`).
// See `DistributedVirtualPortgroupPortgroupType_enum`.
//   - To configure host network access by port, set the distributed virtual port
//     in the host virtual NIC specification
//     (`HostVirtualNicSpec*.*HostVirtualNicSpec.distributedVirtualPort*.*DistributedVirtualSwitchPortConnection.portKey`).
//   - To configure virtual machine network access by port, set the port
//     in the virtual Ethernet card backing
//     (`VirtualEthernetCard*.*VirtualDevice.backing*.*VirtualEthernetCardDistributedVirtualPortBackingInfo.port*.*DistributedVirtualSwitchPortConnection.portKey`).
type DistributedVirtualPort struct {
	DynamicData

	// Port key.
	Key string `xml:"key" json:"key"`
	// Port configuration, including identifying information, network
	// settings, and the set of entities that can connect to the port.
	Config DVPortConfigInfo `xml:"config" json:"config"`
	// UUID of the `DistributedVirtualSwitch` to which the port belongs.
	DvsUuid string `xml:"dvsUuid" json:"dvsUuid"`
	// Key of the portgroup `DistributedVirtualPortgroup` to which
	// the port belongs, if any.
	PortgroupKey string `xml:"portgroupKey,omitempty" json:"portgroupKey,omitempty"`
	// `HostSystem` that services this port.
	//
	// Refers instance of `HostSystem`.
	ProxyHost *ManagedObjectReference `xml:"proxyHost,omitempty" json:"proxyHost,omitempty"`
	// Entity that connects to the port.
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty" json:"connectee,omitempty"`
	// Specifies whether the port is a conflict port.
	//
	// A port could be marked
	// as conflict if an entity is discovered connecting to a port that is
	// already occupied, or if the host creates a port without conferring
	// with vCenter Server.
	//
	// The distributed virtual switch does not persist the runtime state
	// of a conflict port. Also, the port cannot move away from the host.
	// vCenter Server will not move a virtual machine (VMotion) that is
	// using a conflict port.
	Conflict bool `xml:"conflict" json:"conflict"`
	// If the port is marked conflict in the case of two entities connecting to
	// the same port (see
	// `DistributedVirtualPort.conflict`), this is the
	// key of the port which the connected entity is contending for.
	ConflictPortKey string `xml:"conflictPortKey,omitempty" json:"conflictPortKey,omitempty"`
	// Runtime state of the port.
	State *DVPortState `xml:"state,omitempty" json:"state,omitempty"`
	// Cookie representing the current instance of association between a
	// port and a virtual or physical NIC.
	//
	// See `DistributedVirtualSwitchPortConnection`.
	// The same cookie is present in the physical or virtual NIC configuration
	// (`DistributedVirtualSwitchPortConnection*.*DistributedVirtualSwitchPortConnection.connectionCookie`)
	// so that the Server can verify that the entity is the rightful
	// connectee of the port.
	ConnectionCookie int32 `xml:"connectionCookie,omitempty" json:"connectionCookie,omitempty"`
	// The last time the
	// `DistributedVirtualPort.state*.*DVPortState.runtimeInfo`
	// value was changed.
	LastStatusChange time.Time `xml:"lastStatusChange" json:"lastStatusChange"`
	// Specifies whether the port is a host local port.
	//
	// A host local port is created
	// to resurrect the management network connection on a VMkernel virtual NIC.
	// You cannot use vCenter Server to reconfigure this port and you cannot
	// reassign the port.
	HostLocalPort *bool `xml:"hostLocalPort" json:"hostLocalPort,omitempty"`
	// Populate the Id assigned to vmknic or vnic by external management plane
	// to port, if the port is connected to the nics.
	ExternalId string `xml:"externalId,omitempty" json:"externalId,omitempty"`
	// Populate the segmentPortId assigned to LSP.
	SegmentPortId string `xml:"segmentPortId,omitempty" json:"segmentPortId,omitempty"`
}

func init() {
	t["DistributedVirtualPort"] = reflect.TypeOf((*DistributedVirtualPort)(nil)).Elem()
}

// This class describes a DistributedVirtualPortgroup that a device backing
// can be attached to.
type DistributedVirtualPortgroupInfo struct {
	DynamicData

	// The name of the switch.
	SwitchName string `xml:"switchName" json:"switchName"`
	// The UUID of the switch.
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// The name of the portgroup.
	PortgroupName string `xml:"portgroupName" json:"portgroupName"`
	// The key of the portgroup.
	PortgroupKey string `xml:"portgroupKey" json:"portgroupKey"`
	// The type of portgroup.
	//
	// See `DistributedVirtualPortgroupPortgroupType_enum`
	PortgroupType string `xml:"portgroupType" json:"portgroupType"`
	// Whether this portgroup is an uplink portgroup.
	UplinkPortgroup bool `xml:"uplinkPortgroup" json:"uplinkPortgroup"`
	// The portgroup.
	//
	// Refers instance of `DistributedVirtualPortgroup`.
	Portgroup ManagedObjectReference `xml:"portgroup" json:"portgroup"`
	// Indicates whether network bandwidth reservation is supported on
	// the portgroup
	NetworkReservationSupported *bool `xml:"networkReservationSupported" json:"networkReservationSupported,omitempty"`
	// Backing type of portgroup.
	//
	// See
	// `DistributedVirtualPortgroup*.*DistributedVirtualPortgroupBackingType_enum`
	// for possible values.
	// The default value is "standard".
	BackingType string `xml:"backingType,omitempty" json:"backingType,omitempty"`
	// The logical switch UUID, which is used by NSX portgroup
	LogicalSwitchUuid string `xml:"logicalSwitchUuid,omitempty" json:"logicalSwitchUuid,omitempty"`
	// The segment ID of logical switch, which is used by NSX portroup
	SegmentId string `xml:"segmentId,omitempty" json:"segmentId,omitempty"`
}

func init() {
	t["DistributedVirtualPortgroupInfo"] = reflect.TypeOf((*DistributedVirtualPortgroupInfo)(nil)).Elem()
}

// The `DistributedVirtualPortgroupNsxPortgroupOperationResult`
// data object defines the result of NSX port group operations, including
// create, reconfigure and delete.
type DistributedVirtualPortgroupNsxPortgroupOperationResult struct {
	DynamicData

	// The management object of NSX port group.
	//
	// For add operation, it indicates the port groups created successfully.
	// For reconfigure operation, it indicates the port groups updated
	// successfully.
	// For delete operation, it indicates the port groups failed deleted.
	//
	// Refers instances of `DistributedVirtualPortgroup`.
	Portgroups []ManagedObjectReference `xml:"portgroups,omitempty" json:"portgroups,omitempty"`
	// The failed port group operation details.
	Problems []DistributedVirtualPortgroupProblem `xml:"problems,omitempty" json:"problems,omitempty"`
}

func init() {
	t["DistributedVirtualPortgroupNsxPortgroupOperationResult"] = reflect.TypeOf((*DistributedVirtualPortgroupNsxPortgroupOperationResult)(nil)).Elem()
}

// The `DistributedVirtualPortgroupProblem`
// data object defines the error while excuting NSX port group operations.
type DistributedVirtualPortgroupProblem struct {
	DynamicData

	// The problematic logical switch UUID
	LogicalSwitchUuid string `xml:"logicalSwitchUuid" json:"logicalSwitchUuid"`
	// The failure reason for each problematic logical switch UUID
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["DistributedVirtualPortgroupProblem"] = reflect.TypeOf((*DistributedVirtualPortgroupProblem)(nil)).Elem()
}

// The `DistributedVirtualSwitchHostMember` data object represents an ESXi host that
// is a member of a distributed virtual switch.
//
// When you add a host to a switch
// (`DistributedVirtualSwitchHostMemberConfigSpec*.*DistributedVirtualSwitchHostMemberConfigSpec.host`),
// the Server creates a proxy switch (`HostProxySwitch`).
// The host member object contains information about the configuration
// and state of the proxy.
type DistributedVirtualSwitchHostMember struct {
	DynamicData

	// Host member runtime state.
	RuntimeState *DistributedVirtualSwitchHostMemberRuntimeState `xml:"runtimeState,omitempty" json:"runtimeState,omitempty"`
	// Host member configuration.
	Config DistributedVirtualSwitchHostMemberConfigInfo `xml:"config" json:"config"`
	// Vendor, product and version information for the proxy switch
	// module.
	ProductInfo *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty" json:"productInfo,omitempty"`
	// Port keys of the uplink ports created for the host member.
	//
	// These ports
	// will be deleted after the host leaves the switch.
	UplinkPortKey []string `xml:"uplinkPortKey,omitempty" json:"uplinkPortKey,omitempty"`
	// Deprecated as of vSphere API 5.1, use
	// `HostMemberRuntimeInfo*.*HostMemberRuntimeInfo.status` instead.
	//
	// The host DistributedVirtualSwitch component status.
	//
	// See
	// `HostComponentState` for valid values.
	Status string `xml:"status" json:"status"`
	// Deprecated as of vSphere API 5.1, use
	// `HostMemberRuntimeInfo*.*HostMemberRuntimeInfo.statusDetail` instead.
	//
	// Additional information regarding the host's current status.
	StatusDetail string `xml:"statusDetail,omitempty" json:"statusDetail,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMember"] = reflect.TypeOf((*DistributedVirtualSwitchHostMember)(nil)).Elem()
}

// Base class.
type DistributedVirtualSwitchHostMemberBacking struct {
	DynamicData
}

func init() {
	t["DistributedVirtualSwitchHostMemberBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberBacking)(nil)).Elem()
}

// The `DistributedVirtualSwitchHostMemberConfigInfo` data object
// contains membership configuration information for the ESXi host.
type DistributedVirtualSwitchHostMemberConfigInfo struct {
	DynamicData

	// ESXi host.
	//
	// This property should always be set unless the user's setting
	// does not have System.Read privilege on the object referred to
	// by this property.
	//
	// Refers instance of `HostSystem`.
	Host *ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
	// Maximum number of ports than can be created in the proxy switch.
	//
	// _ESXi 5.0 and earlier hosts_:
	// If you change the maximum number of ports, you must reboot
	// the host for the new value to take effect.
	MaxProxySwitchPorts int32 `xml:"maxProxySwitchPorts" json:"maxProxySwitchPorts"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
	// Host membership backing, specifying physical NIC, portgroup, and port
	// bindings for the proxy switch.
	Backing BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,typeattr" json:"backing"`
	// Indicate whether the proxy switch is used by NSX on this particular
	// host member of the VDS.
	NsxSwitch *bool `xml:"nsxSwitch" json:"nsxSwitch,omitempty"`
	// Indicate if ENS is enabled for this particular host member of
	// the VDS.
	//
	// It is read only.
	EnsEnabled *bool `xml:"ensEnabled" json:"ensEnabled,omitempty"`
	// Indicate if ENS interrupt mode is enabled for this particular host
	// member of the VDS.
	//
	// It is read only.
	EnsInterruptEnabled *bool `xml:"ensInterruptEnabled" json:"ensInterruptEnabled,omitempty"`
	// Indicate which transport zones this host joins by this VDS.
	TransportZones []DistributedVirtualSwitchHostMemberTransportZoneInfo `xml:"transportZones,omitempty" json:"transportZones,omitempty"`
	// Indicate which uplink ports are used by NSX-T.
	NsxtUsedUplinkNames []string `xml:"nsxtUsedUplinkNames,omitempty" json:"nsxtUsedUplinkNames,omitempty"`
	// Indicate if network offloading is enabled for this particular host
	// member of the VDS.
	//
	// Unset implies that network offloading is disabled.
	NetworkOffloadingEnabled *bool `xml:"networkOffloadingEnabled" json:"networkOffloadingEnabled,omitempty" vim:"8.0.0.1"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigInfo"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigInfo)(nil)).Elem()
}

// Specification to create or reconfigure ESXi host membership
// in a `DistributedVirtualSwitch`.
type DistributedVirtualSwitchHostMemberConfigSpec struct {
	DynamicData

	// Host member operation type.
	//
	// See
	// `ConfigSpecOperation_enum` for valid values.
	Operation string `xml:"operation" json:"operation"`
	// Identifies a host member of a `DistributedVirtualSwitch`
	// for a `Folder.CreateDVS_Task` or
	// `DistributedVirtualSwitch*.*DistributedVirtualSwitch.ReconfigureDvs_Task` operation.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// Specifies the physical NICs to use as backing for the proxy switch
	// on the host.
	Backing BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,omitempty,typeattr" json:"backing,omitempty"`
	// Maximum number of ports allowed in the `HostProxySwitch`.
	//
	// _ESXi 5.0 and earlier hosts_: If you are reconfiguring an existing
	// host membership, that is, the proxy switch already exists, you must reboot
	// the host for the new setting to take effect.
	MaxProxySwitchPorts int32 `xml:"maxProxySwitchPorts,omitempty" json:"maxProxySwitchPorts,omitempty"`
	// Opaque binary blob that stores vendor specific configuration.
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty" json:"vendorSpecificConfig,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

// The runtime state of uplink on the host.
type DistributedVirtualSwitchHostMemberHostUplinkState struct {
	DynamicData

	// Name of the uplink.
	UplinkName string `xml:"uplinkName" json:"uplinkName"`
	// The runtime state of the uplink.
	//
	// See `DistributedVirtualSwitchHostMemberHostUplinkStateState_enum` for supported values.
	State string `xml:"state" json:"state"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberHostUplinkState"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberHostUplinkState)(nil)).Elem()
	minAPIVersionForType["DistributedVirtualSwitchHostMemberHostUplinkState"] = "8.0.3.0"
}

// The `DistributedVirtualSwitchHostMemberPnicBacking` data object
// specifies a set of physical NICs to use for a proxy switch.
//
// When you add a host to a distributed virtual switch
// (`DistributedVirtualSwitchHostMemberConfigSpec*.*DistributedVirtualSwitchHostMemberConfigSpec.host`),
// the host creates a proxy switch that will use the pNICs as uplinks.
type DistributedVirtualSwitchHostMemberPnicBacking struct {
	DistributedVirtualSwitchHostMemberBacking

	// List of physical NIC specifications.
	//
	// Each entry identifies
	// a pNIC to the proxy switch and optionally specifies uplink
	// portgroup and port connections for the pNIC.
	PnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"pnicSpec,omitempty" json:"pnicSpec,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicBacking)(nil)).Elem()
}

// Specification for an individual physical NIC.
type DistributedVirtualSwitchHostMemberPnicSpec struct {
	DynamicData

	// Name of the physical NIC to be added to the proxy switch.
	//
	// See `PhysicalNic*.*PhysicalNic.device`.
	PnicDevice string `xml:"pnicDevice" json:"pnicDevice"`
	// Key of the port to be connected to the physical NIC.
	UplinkPortKey string `xml:"uplinkPortKey,omitempty" json:"uplinkPortKey,omitempty"`
	// Key of the portgroup to be connected to the physical NIC.
	UplinkPortgroupKey string `xml:"uplinkPortgroupKey,omitempty" json:"uplinkPortgroupKey,omitempty"`
	// Cookie that represents this `DistributedVirtualSwitchPortConnection`
	// instance for the port.
	//
	// The cookie value is generated by the
	// Server. The Server ignores any value set by an SDK client.
	//
	// The same cookie is present in the distributed virtual port configuration
	// (`DistributedVirtualPort*.*DistributedVirtualPort.connectionCookie`)
	// so that the Server can verify that the entity is the rightful
	// connectee of the port.
	ConnectionCookie int32 `xml:"connectionCookie,omitempty" json:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

// Runtime state of a host member.
type DistributedVirtualSwitchHostMemberRuntimeState struct {
	DynamicData

	// Current maximum number of ports allowed to be created in the
	// proxy switch.
	CurrentMaxProxySwitchPorts int32 `xml:"currentMaxProxySwitchPorts" json:"currentMaxProxySwitchPorts"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberRuntimeState"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberRuntimeState)(nil)).Elem()
}

// Transport zone information.
type DistributedVirtualSwitchHostMemberTransportZoneInfo struct {
	DynamicData

	// The UUID of transport zone.
	Uuid string `xml:"uuid" json:"uuid"`
	// The type of transport zone.
	//
	// See `DistributedVirtualSwitchHostMemberTransportZoneType_enum` for valid values.
	Type string `xml:"type" json:"type"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberTransportZoneInfo"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberTransportZoneInfo)(nil)).Elem()
}

// This data object type is a subset of `AboutInfo`.
//
// An object of
// this type can be used to describe the specification for a host.
type DistributedVirtualSwitchHostProductSpec struct {
	DynamicData

	// The product-line name.
	ProductLineId string `xml:"productLineId,omitempty" json:"productLineId,omitempty"`
	// Dot-separated version string.
	//
	// For example, "1.2".
	Version string `xml:"version,omitempty" json:"version,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

// This class describes a DistributedVirtualSwitch that a device backing
// can attached to its ports.
type DistributedVirtualSwitchInfo struct {
	DynamicData

	// The name of the switch.
	SwitchName string `xml:"switchName" json:"switchName"`
	// The UUID of the switch.
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// The switch.
	//
	// Refers instance of `DistributedVirtualSwitch`.
	DistributedVirtualSwitch ManagedObjectReference `xml:"distributedVirtualSwitch" json:"distributedVirtualSwitch"`
	// Indicates whether network bandwidth reservation is supported on
	// the switch
	NetworkReservationSupported *bool `xml:"networkReservationSupported" json:"networkReservationSupported,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchInfo"] = reflect.TypeOf((*DistributedVirtualSwitchInfo)(nil)).Elem()
}

// This class defines a data structure to hold opaque binary data
// identified by a key.
type DistributedVirtualSwitchKeyedOpaqueBlob struct {
	DynamicData

	// A key that identifies the opaque binary blob.
	Key string `xml:"key" json:"key"`
	// The opaque data.
	//
	// It is recommended that base64 encoding be used for binary
	// data.
	OpaqueData string `xml:"opaqueData" json:"opaqueData"`
}

func init() {
	t["DistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*DistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

// This is the return type for the checkCompatibility method.
//
// This object
// has a host property and optionally a fault which would
// be populated only if that host is not compatible with a given dvsProductSpec.
// If the host is compatible then the error property would be unset.
type DistributedVirtualSwitchManagerCompatibilityResult struct {
	DynamicData

	// The host for which results are annotated.
	//
	// The whole object will be
	// filtered out if the caller did not have view permissions on the
	// host entity.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// This property contains the faults that makes the host not compatible
	// with a given DvsProductSpec.
	//
	// For example, a host might not be compatible
	// because it's an older version of ESX that doesn't support DVS.
	Error []LocalizedMethodFault `xml:"error,omitempty" json:"error,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

// This class is used to specify ProductSpec for the DVS.
//
// The two properties are
// strictly mutually exclusive. If both properties are set, then
// an InvalidArgument fault would be thrown.
type DistributedVirtualSwitchManagerDvsProductSpec struct {
	DynamicData

	// The ProductSpec for new DVS
	NewSwitchProductSpec *DistributedVirtualSwitchProductSpec `xml:"newSwitchProductSpec,omitempty" json:"newSwitchProductSpec,omitempty"`
	// Get ProductSpec from the existing DVS
	//
	// Refers instance of `DistributedVirtualSwitch`.
	DistributedVirtualSwitch *ManagedObjectReference `xml:"distributedVirtualSwitch,omitempty" json:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerDvsProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerDvsProductSpec)(nil)).Elem()
}

// Check host compatibility against all hosts specified in the array.
type DistributedVirtualSwitchManagerHostArrayFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	// List of hosts to consider.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostArrayFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostArrayFilter)(nil)).Elem()
}

// Check host compatibility for all hosts in the container.
//
// If the recursive
// flag is true, then check hosts at all levels within this container, otherwise
// check only at the container level. In case of container being a `Datacenter`,
// the recursive flag is applied to its HostFolder.
type DistributedVirtualSwitchManagerHostContainer struct {
	DynamicData

	// Check compatibility of hosts in this container.
	//
	// The supported container
	// types are Datacenter, Folder, and ComputeResource.
	//
	// Refers instance of `ManagedEntity`.
	Container ManagedObjectReference `xml:"container" json:"container"`
	// If true, include hosts of all levels in the hierarchy with
	// container as root of the tree.
	//
	// In case of container being a `Datacenter`,
	// the recursive flag is applied to its HostFolder.
	Recursive bool `xml:"recursive" json:"recursive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainer"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainer)(nil)).Elem()
}

// Check host compatibility against all hosts in this
// `DistributedVirtualSwitchManagerHostContainer`
type DistributedVirtualSwitchManagerHostContainerFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	// Container of hosts that are part of the filter.
	HostContainer DistributedVirtualSwitchManagerHostContainer `xml:"hostContainer" json:"hostContainer"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainerFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainerFilter)(nil)).Elem()
}

// Base class for filters to check host compatibility.
type DistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DynamicData

	// If this flag is true, then the filter returns the hosts in the
	// `DistributedVirtualSwitchManagerHostContainer`
	// that satisfy the criteria specified by this filter, otherwise
	// it returns hosts that don't meet the criteria.
	Inclusive bool `xml:"inclusive" json:"inclusive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

// Check host compatibility against all hosts in the DVS (or not in the DVS if
// inclusive flag in base class is false)
type DistributedVirtualSwitchManagerHostDvsMembershipFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	// Refers instance of `DistributedVirtualSwitch`.
	DistributedVirtualSwitch ManagedObjectReference `xml:"distributedVirtualSwitch" json:"distributedVirtualSwitch"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsMembershipFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsMembershipFilter)(nil)).Elem()
}

// The `DistributedVirtualSwitchManagerImportResult`
// data object represents the results of a
// `DistributedVirtualSwitchManager.DVSManagerImportEntity_Task`
// operation.
//
// It contains lists of the switches and portgroups
// that were created. It also contains a list of faults
// that occurred during the operation.
type DistributedVirtualSwitchManagerImportResult struct {
	DynamicData

	// List of distributed virtual switches.
	//
	// Refers instances of `DistributedVirtualSwitch`.
	DistributedVirtualSwitch []ManagedObjectReference `xml:"distributedVirtualSwitch,omitempty" json:"distributedVirtualSwitch,omitempty"`
	// List of distributed virtual portgroups.
	//
	// Refers instances of `DistributedVirtualPortgroup`.
	DistributedVirtualPortgroup []ManagedObjectReference `xml:"distributedVirtualPortgroup,omitempty" json:"distributedVirtualPortgroup,omitempty"`
	// Faults that occurred on the entities during the import operation.
	ImportFault []ImportOperationBulkFaultFaultOnImport `xml:"importFault,omitempty" json:"importFault,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerImportResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerImportResult)(nil)).Elem()
}

// Describe the network offload specification of a
// `VmwareDistributedVirtualSwitch`.
type DistributedVirtualSwitchNetworkOffloadSpec struct {
	DynamicData

	// Identifier of the specification.
	Id string `xml:"id" json:"id"`
	// Name of the specification.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// DPU types supported in the specification.
	Types []string `xml:"types,omitempty" json:"types,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchNetworkOffloadSpec"] = reflect.TypeOf((*DistributedVirtualSwitchNetworkOffloadSpec)(nil)).Elem()
	minAPIVersionForType["DistributedVirtualSwitchNetworkOffloadSpec"] = "8.0.0.1"
}

// Information about the entity that connects to a DistributedVirtualPort.
type DistributedVirtualSwitchPortConnectee struct {
	DynamicData

	// The connected entity.
	//
	// This property should always be set unless the user's setting
	// does not have System.Read privilege on the object referred to
	// by this property.
	//
	// Refers instance of `ManagedEntity`.
	ConnectedEntity *ManagedObjectReference `xml:"connectedEntity,omitempty" json:"connectedEntity,omitempty"`
	// The key of the virtual NIC that connects to this port.
	NicKey string `xml:"nicKey,omitempty" json:"nicKey,omitempty"`
	// The type of the connectee.
	//
	// See `ConnecteeType` for valid values.
	Type string `xml:"type,omitempty" json:"type,omitempty"`
	// A hint on address information of the NIC that connects to this port.
	AddressHint string `xml:"addressHint,omitempty" json:"addressHint,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnectee"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnectee)(nil)).Elem()
}

// The `DistributedVirtualSwitchPortConnection` data object represents a connection
// or association between a `DistributedVirtualPortgroup` or a
// `DistributedVirtualPort` and one of the following entities:
//   - Virtual machine virtual NIC
//     (`VirtualEthernetCardDistributedVirtualPortBackingInfo`)
//   - Host virtual NIC (`HostVirtualNic`)
//   - Physical NIC (`HostNetworkInfo*.*HostNetworkInfo.pnic`)
type DistributedVirtualSwitchPortConnection struct {
	DynamicData

	// UUID of the switch (`DistributedVirtualSwitch*.*DistributedVirtualSwitch.uuid`).
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// Key of the portgroup.
	//
	// If specified, the connection object represents a connection
	// or an association between a `DistributedVirtualPortgroup`
	// and a Virtual NIC or physical NIC.
	// In this case, setting the `DistributedVirtualSwitchPortConnection.portKey` is not necessary for a
	// early-binding portgroup and is not allowed for a late-binding portgroup.
	// The `DistributedVirtualSwitchPortConnection.portKey` property will be populated by the implementation
	// at the time of port binding.
	PortgroupKey string `xml:"portgroupKey,omitempty" json:"portgroupKey,omitempty"`
	// Key of the port.
	//
	// If specified, this object represents a connection
	// or an association between an individual `DistributedVirtualPort`
	// and a Virtual NIC or physical NIC. See `DistributedVirtualSwitchPortConnection.portgroupKey` for more information on populating
	// this property.
	PortKey string `xml:"portKey,omitempty" json:"portKey,omitempty"`
	// Cookie that represents this `DistributedVirtualSwitchPortConnection`
	// instance for the port.
	//
	// The cookie value is generated by the
	// Server. The Server ignores any value set by an SDK client.
	//
	// The same cookie is present in the distributed virtual port configuration
	// (`DistributedVirtualPort*.*DistributedVirtualPort.connectionCookie`)
	// so that the Server can verify that the entity is the rightful
	// connectee of the port.
	ConnectionCookie int32 `xml:"connectionCookie,omitempty" json:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnection"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnection)(nil)).Elem()
}

// The criteria specification for selecting ports.
type DistributedVirtualSwitchPortCriteria struct {
	DynamicData

	// If set, only the connected ports are qualified.
	Connected *bool `xml:"connected" json:"connected,omitempty"`
	// If set, only the active ports are qualified.
	Active *bool `xml:"active" json:"active,omitempty"`
	// If set to true, only the uplink ports are qualified.
	//
	// If set to false, only
	// non-uplink ports are qualified.
	UplinkPort *bool `xml:"uplinkPort" json:"uplinkPort,omitempty"`
	// If set to true, only the NSX ports are qualified.
	//
	// If set to false, only
	// non-NSX ports are qualified.
	// NSX ports are ports of NSX port group.
	NsxPort *bool `xml:"nsxPort" json:"nsxPort,omitempty"`
	// Deprecated as of vSphere API 5.5.
	//
	// If set, only the ports of which the scope covers the entity are
	// qualified.
	//
	// Refers instance of `ManagedEntity`.
	Scope *ManagedObjectReference `xml:"scope,omitempty" json:"scope,omitempty"`
	// The keys of the portgroup that is used for the scope of `DistributedVirtualSwitchPortCriteria.inside`.
	//
	// If this property is unset, it means any portgroup. If `DistributedVirtualSwitchPortCriteria.inside`
	// is unset, this property is ignored.
	PortgroupKey []string `xml:"portgroupKey,omitempty" json:"portgroupKey,omitempty"`
	// If unset, all ports in the switch are qualified.
	//
	// If set to true, only ports inside `DistributedVirtualSwitchPortCriteria.portgroupKey` or any
	// portgroup, if not set, are qualified.
	// If set to false, only ports outside `DistributedVirtualSwitchPortCriteria.portgroupKey` or any
	// portgroup, if not set, are qualified.
	Inside *bool `xml:"inside" json:"inside,omitempty"`
	// If set, only the ports of which the key is in the array are
	// qualified.
	PortKey []string `xml:"portKey,omitempty" json:"portKey,omitempty"`
	// If set, only the ports that are present in one of the host are qualified.
	//
	// Refers instances of `HostSystem`.
	Host []ManagedObjectReference `xml:"host,omitempty" json:"host,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortCriteria"] = reflect.TypeOf((*DistributedVirtualSwitchPortCriteria)(nil)).Elem()
}

// Statistic data of a DistributedVirtualPort.
type DistributedVirtualSwitchPortStatistics struct {
	DynamicData

	// The number of multicast packets received.
	PacketsInMulticast int64 `xml:"packetsInMulticast" json:"packetsInMulticast"`
	// The number of multicast packets forwarded.
	PacketsOutMulticast int64 `xml:"packetsOutMulticast" json:"packetsOutMulticast"`
	// The number of bytes received from multicast packets.
	BytesInMulticast int64 `xml:"bytesInMulticast" json:"bytesInMulticast"`
	// The number of bytes forwarded from multicast packets.
	BytesOutMulticast int64 `xml:"bytesOutMulticast" json:"bytesOutMulticast"`
	// The number of unicast packets received.
	PacketsInUnicast int64 `xml:"packetsInUnicast" json:"packetsInUnicast"`
	// The number of unicast packets forwarded.
	PacketsOutUnicast int64 `xml:"packetsOutUnicast" json:"packetsOutUnicast"`
	// The number of bytes received from unicast packets.
	BytesInUnicast int64 `xml:"bytesInUnicast" json:"bytesInUnicast"`
	// The number of bytes forwarded from unicast packets.
	BytesOutUnicast int64 `xml:"bytesOutUnicast" json:"bytesOutUnicast"`
	// The number of broadcast packets received.
	PacketsInBroadcast int64 `xml:"packetsInBroadcast" json:"packetsInBroadcast"`
	// The number of broadcast packets forwarded.
	PacketsOutBroadcast int64 `xml:"packetsOutBroadcast" json:"packetsOutBroadcast"`
	// The number of bytes received from broadcast packets.
	BytesInBroadcast int64 `xml:"bytesInBroadcast" json:"bytesInBroadcast"`
	// The number of bytes forwarded from broadcast packets.
	BytesOutBroadcast int64 `xml:"bytesOutBroadcast" json:"bytesOutBroadcast"`
	// The number of received packets dropped.
	PacketsInDropped int64 `xml:"packetsInDropped" json:"packetsInDropped"`
	// The number of packets to be forwarded dropped.
	PacketsOutDropped int64 `xml:"packetsOutDropped" json:"packetsOutDropped"`
	// The number of packets received that cause an exception.
	PacketsInException int64 `xml:"packetsInException" json:"packetsInException"`
	// The number of packets to be forwarded that cause an exception.
	PacketsOutException int64 `xml:"packetsOutException" json:"packetsOutException"`
	// The number of bytes received at a pnic on the behalf of a port's
	// connectee (inter-host rx).
	BytesInFromPnic int64 `xml:"bytesInFromPnic,omitempty" json:"bytesInFromPnic,omitempty"`
	// The number of bytes transmitted at a pnic on the behalf of a port's
	// connectee (inter-host tx).
	BytesOutToPnic int64 `xml:"bytesOutToPnic,omitempty" json:"bytesOutToPnic,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortStatistics"] = reflect.TypeOf((*DistributedVirtualSwitchPortStatistics)(nil)).Elem()
}

// This data object type is a subset of `AboutInfo`.
//
// An object of
// this type can be used to describe the specification for a proxy switch module
// of a `DistributedVirtualSwitch`.
type DistributedVirtualSwitchProductSpec struct {
	DynamicData

	// Short form of the product name.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Name of the vendor of this product.
	Vendor string `xml:"vendor,omitempty" json:"vendor,omitempty"`
	// Dot-separated version string.
	//
	// For example, "1.2".
	Version string `xml:"version,omitempty" json:"version,omitempty"`
	// Build string for the server on which this call is made.
	//
	// For example, x.y.z-num.
	// This string does not apply to the API.
	Build string `xml:"build,omitempty" json:"build,omitempty"`
	// Forwarding class of the distributed virtual switch.
	ForwardingClass string `xml:"forwardingClass,omitempty" json:"forwardingClass,omitempty"`
	// The ID of the bundle if a host component bundle needs to be installed on
	// the host members to support the functionality of the switch.
	BundleId string `xml:"bundleId,omitempty" json:"bundleId,omitempty"`
	// The URL of the bundle that VMware Update Manager will use to install
	// the bundle on the host members, if `DistributedVirtualSwitchProductSpec.bundleId` is set.
	BundleUrl string `xml:"bundleUrl,omitempty" json:"bundleUrl,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchProductSpec)(nil)).Elem()
}

type DoesCustomizationSpecExist DoesCustomizationSpecExistRequestType

func init() {
	t["DoesCustomizationSpecExist"] = reflect.TypeOf((*DoesCustomizationSpecExist)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.DoesCustomizationSpecExist`.
type DoesCustomizationSpecExistRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	Name string                 `xml:"name" json:"name"`
}

func init() {
	t["DoesCustomizationSpecExistRequestType"] = reflect.TypeOf((*DoesCustomizationSpecExistRequestType)(nil)).Elem()
}

type DoesCustomizationSpecExistResponse struct {
	Returnval bool `xml:"returnval" json:"returnval"`
}

// Fault indicating that the domain controller
// for domainName cannot be reached.
type DomainNotFound struct {
	ActiveDirectoryFault

	// The domain that cannot be accessed.
	DomainName string `xml:"domainName" json:"domainName"`
}

func init() {
	t["DomainNotFound"] = reflect.TypeOf((*DomainNotFound)(nil)).Elem()
}

type DomainNotFoundFault DomainNotFound

func init() {
	t["DomainNotFoundFault"] = reflect.TypeOf((*DomainNotFoundFault)(nil)).Elem()
}

type DownloadDescriptionTree DownloadDescriptionTreeRequestType

func init() {
	t["DownloadDescriptionTree"] = reflect.TypeOf((*DownloadDescriptionTree)(nil)).Elem()
}

type DownloadDescriptionTreeRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
}

func init() {
	t["DownloadDescriptionTreeRequestType"] = reflect.TypeOf((*DownloadDescriptionTreeRequestType)(nil)).Elem()
}

type DownloadDescriptionTreeResponse struct {
	Returnval []byte `xml:"returnval" json:"returnval"`
}

// Data object describing the operational status of various DPU
// elements.
type DpuStatusInfo struct {
	HostHardwareElementInfo

	// Uniquely identify this DPU.
	//
	// Should be the VMware identifier
	// which can be composed from pci and other identifying elements.
	DpuId string `xml:"dpuId" json:"dpuId"`
	// The FRU this sensor monitors, if any.
	Fru     *HostFru                       `xml:"fru,omitempty" json:"fru,omitempty"`
	Sensors []DpuStatusInfoOperationalInfo `xml:"sensors,omitempty" json:"sensors,omitempty"`
}

func init() {
	t["DpuStatusInfo"] = reflect.TypeOf((*DpuStatusInfo)(nil)).Elem()
	minAPIVersionForType["DpuStatusInfo"] = "8.0.0.1"
}

// Sensor information provided by DPU that provides health status.
type DpuStatusInfoOperationalInfo struct {
	DynamicData

	// This string uniquely identifies a sensor in the DPU.
	SensorId string `xml:"sensorId" json:"sensorId"`
	// The health state of the element indicated by the sensor.
	//
	// See also `HostNumericSensorHealthState_enum`.
	HealthState BaseElementDescription `xml:"healthState,omitempty,typeattr" json:"healthState,omitempty"`
	// A description of the state of the sensor
	// such as: N watts, Y RPM, or other measurement.
	Reading string `xml:"reading" json:"reading"`
	// If provided by underying API, the base units in which the sensor
	// reading is specified, "RPM", "WATTS" and so forth.
	Units string `xml:"units,omitempty" json:"units,omitempty"`
	// Reports the ISO 8601 Timestamp when this sensor was last updated by
	// management controller if the this sensor is capable of tracking
	// when it was last updated.
	//
	// Property timeStampRaw, which comes from
	// vendor firmware is convertible to DateTime, it will be provided.
	TimeStamp *time.Time `xml:"timeStamp" json:"timeStamp,omitempty"`
}

func init() {
	t["DpuStatusInfoOperationalInfo"] = reflect.TypeOf((*DpuStatusInfoOperationalInfo)(nil)).Elem()
	minAPIVersionForType["DpuStatusInfoOperationalInfo"] = "8.0.0.1"
}

type DropConnections DropConnectionsRequestType

func init() {
	t["DropConnections"] = reflect.TypeOf((*DropConnections)(nil)).Elem()
}

// The parameters of `VirtualMachine.DropConnections`.
type DropConnectionsRequestType struct {
	This              ManagedObjectReference         `xml:"_this" json:"-"`
	ListOfConnections []BaseVirtualMachineConnection `xml:"listOfConnections,omitempty,typeattr" json:"listOfConnections,omitempty"`
}

func init() {
	t["DropConnectionsRequestType"] = reflect.TypeOf((*DropConnectionsRequestType)(nil)).Elem()
	minAPIVersionForType["DropConnectionsRequestType"] = "7.0.1.0"
}

type DropConnectionsResponse struct {
	Returnval bool `xml:"returnval" json:"returnval"`
}

// This event records when DRS is disabled on a cluster.
type DrsDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DrsDisabledEvent"] = reflect.TypeOf((*DrsDisabledEvent)(nil)).Elem()
}

// This fault is thrown when DRS cannot move a virtual machine because
// DRS is disabled on it (i.e., it is pinned on its registered host).
type DrsDisabledOnVm struct {
	VimFault
}

func init() {
	t["DrsDisabledOnVm"] = reflect.TypeOf((*DrsDisabledOnVm)(nil)).Elem()
}

type DrsDisabledOnVmFault DrsDisabledOnVm

func init() {
	t["DrsDisabledOnVmFault"] = reflect.TypeOf((*DrsDisabledOnVmFault)(nil)).Elem()
}

// This event records when DRS is enabled on a cluster.
type DrsEnabledEvent struct {
	ClusterEvent

	// The DRS automation level in (`DrsBehavior`)
	Behavior string `xml:"behavior" json:"behavior"`
}

func init() {
	t["DrsEnabledEvent"] = reflect.TypeOf((*DrsEnabledEvent)(nil)).Elem()
}

// This event records that the host has successfully entered standby mode initiated by
// Distributed Power Management.
//
// A host in this mode has no running virtual
// machines and no provisioning operations are occurring.
type DrsEnteredStandbyModeEvent struct {
	EnteredStandbyModeEvent
}

func init() {
	t["DrsEnteredStandbyModeEvent"] = reflect.TypeOf((*DrsEnteredStandbyModeEvent)(nil)).Elem()
}

// This event records that a host has begun the process of
// entering standby mode initiated by Distributed Power Management.
type DrsEnteringStandbyModeEvent struct {
	EnteringStandbyModeEvent
}

func init() {
	t["DrsEnteringStandbyModeEvent"] = reflect.TypeOf((*DrsEnteringStandbyModeEvent)(nil)).Elem()
}

// This event records that Distributed Power Management tried to bring a host out
// from standby mode, but the host failed to exit standby mode.
type DrsExitStandbyModeFailedEvent struct {
	ExitStandbyModeFailedEvent
}

func init() {
	t["DrsExitStandbyModeFailedEvent"] = reflect.TypeOf((*DrsExitStandbyModeFailedEvent)(nil)).Elem()
}

// This event records that Distributed Power Management brings this host
// out from standby mode.
type DrsExitedStandbyModeEvent struct {
	ExitedStandbyModeEvent
}

func init() {
	t["DrsExitedStandbyModeEvent"] = reflect.TypeOf((*DrsExitedStandbyModeEvent)(nil)).Elem()
}

// This event records that a host has begun the process of
// exiting standby mode initiated by Distributed Power Management.
type DrsExitingStandbyModeEvent struct {
	ExitingStandbyModeEvent
}

func init() {
	t["DrsExitingStandbyModeEvent"] = reflect.TypeOf((*DrsExitingStandbyModeEvent)(nil)).Elem()
}

// This event records DRS invocation failure.
type DrsInvocationFailedEvent struct {
	ClusterEvent
}

func init() {
	t["DrsInvocationFailedEvent"] = reflect.TypeOf((*DrsInvocationFailedEvent)(nil)).Elem()
}

// This event records that DRS has recovered from failure.
//
// It is triggered by a successful DRS invocation after repeated failure.
type DrsRecoveredFromFailureEvent struct {
	ClusterEvent
}

func init() {
	t["DrsRecoveredFromFailureEvent"] = reflect.TypeOf((*DrsRecoveredFromFailureEvent)(nil)).Elem()
}

// This event records when resource configuration
// specification synchronization fails on a host.
type DrsResourceConfigureFailedEvent struct {
	HostEvent

	// The reason for the failure.
	Reason LocalizedMethodFault `xml:"reason" json:"reason"`
}

func init() {
	t["DrsResourceConfigureFailedEvent"] = reflect.TypeOf((*DrsResourceConfigureFailedEvent)(nil)).Elem()
}

// This event records when resource configuration
// specification returns to synchronized from previous failure.
type DrsResourceConfigureSyncedEvent struct {
	HostEvent
}

func init() {
	t["DrsResourceConfigureSyncedEvent"] = reflect.TypeOf((*DrsResourceConfigureSyncedEvent)(nil)).Elem()
}

// This event records when a virtual machine comes into compliance with DRS rules.
type DrsRuleComplianceEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleComplianceEvent"] = reflect.TypeOf((*DrsRuleComplianceEvent)(nil)).Elem()
}

// This event records when a virtual machine violates a DRS VM-Host rule.
type DrsRuleViolationEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleViolationEvent"] = reflect.TypeOf((*DrsRuleViolationEvent)(nil)).Elem()
}

// This event records when a virtual machine violates a soft VM-Host rule.
type DrsSoftRuleViolationEvent struct {
	VmEvent
}

func init() {
	t["DrsSoftRuleViolationEvent"] = reflect.TypeOf((*DrsSoftRuleViolationEvent)(nil)).Elem()
}

// This event records a virtual machine migration that was recommended by DRS.
type DrsVmMigratedEvent struct {
	VmMigratedEvent
}

func init() {
	t["DrsVmMigratedEvent"] = reflect.TypeOf((*DrsVmMigratedEvent)(nil)).Elem()
}

// This event records when a virtual machine is powered on by DRS.
type DrsVmPoweredOnEvent struct {
	VmPoweredOnEvent
}

func init() {
	t["DrsVmPoweredOnEvent"] = reflect.TypeOf((*DrsVmPoweredOnEvent)(nil)).Elem()
}

// This fault is thrown when DRS tries to migrate a virtual machine to a host,
// but finds that the host is incompatible with the given virtual machine.
type DrsVmotionIncompatibleFault struct {
	VirtualHardwareCompatibilityIssue

	// The host that is incompatible with a given virtual machine.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
}

func init() {
	t["DrsVmotionIncompatibleFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFault)(nil)).Elem()
}

type DrsVmotionIncompatibleFaultFault DrsVmotionIncompatibleFault

func init() {
	t["DrsVmotionIncompatibleFaultFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFaultFault)(nil)).Elem()
}

type DuplicateCustomizationSpec DuplicateCustomizationSpecRequestType

func init() {
	t["DuplicateCustomizationSpec"] = reflect.TypeOf((*DuplicateCustomizationSpec)(nil)).Elem()
}

// The parameters of `CustomizationSpecManager.DuplicateCustomizationSpec`.
type DuplicateCustomizationSpecRequestType struct {
	This    ManagedObjectReference `xml:"_this" json:"-"`
	Name    string                 `xml:"name" json:"name"`
	NewName string                 `xml:"newName" json:"newName"`
}

func init() {
	t["DuplicateCustomizationSpecRequestType"] = reflect.TypeOf((*DuplicateCustomizationSpecRequestType)(nil)).Elem()
}

type DuplicateCustomizationSpecResponse struct {
}

// Fault used to denote a duplicate set of disks were incorrectly specified
// for a given operation.
//
// See also `HostVsanSystem.AddDisks_Task`, `HostVsanSystem.InitializeDisks_Task`.
type DuplicateDisks struct {
	VsanDiskFault
}

func init() {
	t["DuplicateDisks"] = reflect.TypeOf((*DuplicateDisks)(nil)).Elem()
}

type DuplicateDisksFault DuplicateDisks

func init() {
	t["DuplicateDisksFault"] = reflect.TypeOf((*DuplicateDisksFault)(nil)).Elem()
}

// This event records that a duplicate IP address has been observed in
// conflict with the vmotion or IP storage interface configured on the
// host.
type DuplicateIpDetectedEvent struct {
	HostEvent

	// The Duplicate IP address detected.
	DuplicateIP string `xml:"duplicateIP" json:"duplicateIP"`
	// The MAC associated with duplicate IP.
	MacAddress string `xml:"macAddress" json:"macAddress"`
}

func init() {
	t["DuplicateIpDetectedEvent"] = reflect.TypeOf((*DuplicateIpDetectedEvent)(nil)).Elem()
}

// A DuplicateName exception is thrown because a name already exists
// in the same name space.
type DuplicateName struct {
	VimFault

	// The name that is already bound in the name space.
	Name string `xml:"name" json:"name"`
	// Managed object that already holds the name.
	Object ManagedObjectReference `xml:"object" json:"object"`
}

func init() {
	t["DuplicateName"] = reflect.TypeOf((*DuplicateName)(nil)).Elem()
}

type DuplicateNameFault DuplicateName

func init() {
	t["DuplicateNameFault"] = reflect.TypeOf((*DuplicateNameFault)(nil)).Elem()
}

// Fault thrown for cases that duplicate network interface names are
// incorrectly specified for a VSAN operation.
//
// See also `HostVsanSystem.UpdateVsan_Task`, `ComputeResource.ReconfigureComputeResource_Task`.
type DuplicateVsanNetworkInterface struct {
	VsanFault

	// The network interface name found to be duplicated.
	Device string `xml:"device" json:"device"`
}

func init() {
	t["DuplicateVsanNetworkInterface"] = reflect.TypeOf((*DuplicateVsanNetworkInterface)(nil)).Elem()
}

type DuplicateVsanNetworkInterfaceFault DuplicateVsanNetworkInterface

func init() {
	t["DuplicateVsanNetworkInterfaceFault"] = reflect.TypeOf((*DuplicateVsanNetworkInterfaceFault)(nil)).Elem()
}

// This event is generated when an import operation is
// performed on a distributed virtual portgroup
type DvpgImportEvent struct {
	DVPortgroupEvent

	// The type of restore operation.
	//
	// See `EntityImportType_enum` for valid values
	ImportType string `xml:"importType" json:"importType"`
}

func init() {
	t["DvpgImportEvent"] = reflect.TypeOf((*DvpgImportEvent)(nil)).Elem()
}

// This event is generated when a restore operation is
// performed on a distributed virtual portgroup
type DvpgRestoreEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DvpgRestoreEvent"] = reflect.TypeOf((*DvpgRestoreEvent)(nil)).Elem()
}

// This class defines network rule action to accept packets.
type DvsAcceptNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsAcceptNetworkRuleAction"] = reflect.TypeOf((*DvsAcceptNetworkRuleAction)(nil)).Elem()
}

// Thrown if a vSphere Distributed Switch apply operation failed to set or remove
// some of the specified objects.
type DvsApplyOperationFault struct {
	DvsFault

	// Faults occurred on the host during a DistributedVirtualSwitch operation.
	ObjectFault []DvsApplyOperationFaultFaultOnObject `xml:"objectFault" json:"objectFault"`
}

func init() {
	t["DvsApplyOperationFault"] = reflect.TypeOf((*DvsApplyOperationFault)(nil)).Elem()
}

type DvsApplyOperationFaultFault DvsApplyOperationFault

func init() {
	t["DvsApplyOperationFaultFault"] = reflect.TypeOf((*DvsApplyOperationFaultFault)(nil)).Elem()
}

// The fault occurred during an apply operation.
type DvsApplyOperationFaultFaultOnObject struct {
	DynamicData

	// The object identifier.
	//
	// It should be UUID for vSphere Distributed Switches,
	// keys for vNetwork distributed portgroups and ports.
	ObjectId string `xml:"objectId" json:"objectId"`
	// The Type of the objects.
	Type string `xml:"type" json:"type"`
	// The fault that occurred.
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["DvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*DvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

// This class defines network rule action to copy the packet to an
// associated slow-path service Virtual Machine and let the original
// frame continue.
type DvsCopyNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsCopyNetworkRuleAction"] = reflect.TypeOf((*DvsCopyNetworkRuleAction)(nil)).Elem()
}

// A distributed virtual switch was created.
type DvsCreatedEvent struct {
	DvsEvent

	// The folder where the DistributedVirtualSwitch is created.
	Parent FolderEventArgument `xml:"parent" json:"parent"`
}

func init() {
	t["DvsCreatedEvent"] = reflect.TypeOf((*DvsCreatedEvent)(nil)).Elem()
}

// A distributed virtual switch was destroyed.
type DvsDestroyedEvent struct {
	DvsEvent
}

func init() {
	t["DvsDestroyedEvent"] = reflect.TypeOf((*DvsDestroyedEvent)(nil)).Elem()
}

// This class defines network rule action to drop packets.
type DvsDropNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsDropNetworkRuleAction"] = reflect.TypeOf((*DvsDropNetworkRuleAction)(nil)).Elem()
}

// These are dvs-related events.
type DvsEvent struct {
	Event
}

func init() {
	t["DvsEvent"] = reflect.TypeOf((*DvsEvent)(nil)).Elem()
}

// The event argument is a Host object.
type DvsEventArgument struct {
	EntityEventArgument

	// The distributed virtual switch object.
	//
	// Refers instance of `DistributedVirtualSwitch`.
	Dvs ManagedObjectReference `xml:"dvs" json:"dvs"`
}

func init() {
	t["DvsEventArgument"] = reflect.TypeOf((*DvsEventArgument)(nil)).Elem()
}

// Base class for faults that can be thrown while invoking a distributed virtual switch
// operation.
type DvsFault struct {
	VimFault
}

func init() {
	t["DvsFault"] = reflect.TypeOf((*DvsFault)(nil)).Elem()
}

type DvsFaultFault BaseDvsFault

func init() {
	t["DvsFaultFault"] = reflect.TypeOf((*DvsFaultFault)(nil)).Elem()
}

// This class defines Network Filter configuration.
//
// ** Supported Qualifier and Actions **
// <table border="1"width="100%">
// <tr>
// <th>Network Filter Config</th>
// <th>Supported classes</th>
// </tr>
// <tr>
// <td>Qualifiers supported</td>
// <td>`SingleIp`, `IpRange`,
// `SingleMac`, `MacRange`,
// `DvsSingleIpPort`,
// `DvsSystemTrafficNetworkRuleQualifier`
// </td>
// </tr>
// <tr>
// <td>Actions Supported</td>
// <td>`DvsDropNetworkRuleAction`,
// `DvsAcceptNetworkRuleAction`,
// `DvsPuntNetworkRuleAction`,
// `DvsCopyNetworkRuleAction`,
// `DvsMacRewriteNetworkRuleAction`,
// `DvsGreEncapNetworkRuleAction`,
// `DvsLogNetworkRuleAction`,
// `DvsUpdateTagNetworkRuleAction`,
// `DvsRateLimitNetworkRuleAction`
// </td>
// </tr>
type DvsFilterConfig struct {
	InheritablePolicy

	// The key of Network Filter Config.
	Key string `xml:"key,omitempty" json:"key,omitempty"`
	// The name of the network traffic filter agent.
	AgentName string `xml:"agentName,omitempty" json:"agentName,omitempty"`
	// The slot number of the network filter agent.
	SlotNumber string `xml:"slotNumber,omitempty" json:"slotNumber,omitempty"`
	// Network Filter Parameter
	Parameters *DvsFilterParameter `xml:"parameters,omitempty" json:"parameters,omitempty"`
	// This property specifies whether to allow all traffic or to deny all
	// traffic when a Network Filter fails to configure.
	//
	// Please see `DvsFilterOnFailure_enum`
	// for more details.
	OnFailure string `xml:"onFailure,omitempty" json:"onFailure,omitempty"`
}

func init() {
	t["DvsFilterConfig"] = reflect.TypeOf((*DvsFilterConfig)(nil)).Elem()
}

// The specification to reconfigure Network Filter.
//
// This specification allows the user to do fine-grained updates for the
// Filter in the port settings.
// If the operation is `remove`, only the
// `DistributedVirtualPort.key` needs to be specified.
// If other fields are specified, they will be ignored. We cannot remove
// an inherited element. Only when the inherited flag is set to false and
// parent does not have an element with same key this operation succeeds.
// If the operation is `add`, then
// `DistributedVirtualPort.key` should not be specified and
// other fields need to be specified. The inherited flag should be set to
// false.
// If the operation is `edit`, then
// `DistributedVirtualPort.key` needs be specified and
// specify the other properties that need modification. If the inherited
// flag is set to true, a `DvsFilterConfig` object of same
// key must exist at the parent's level. The property values in the spec
// object will be ignored and use the values from the parent's
// `DvsFilterConfig` object instead. If inherited
// flag is set to false, then the new modifications will be applied.
type DvsFilterConfigSpec struct {
	DvsFilterConfig

	// Operation type.
	//
	// See `ConfigSpecOperation_enum` for valid values.
	Operation string `xml:"operation" json:"operation"`
}

func init() {
	t["DvsFilterConfigSpec"] = reflect.TypeOf((*DvsFilterConfigSpec)(nil)).Elem()
}

// This class defines Network Filter parameter.
type DvsFilterParameter struct {
	DynamicData

	// List of parameters for a Network Filter.
	Parameters []string `xml:"parameters,omitempty" json:"parameters,omitempty"`
}

func init() {
	t["DvsFilterParameter"] = reflect.TypeOf((*DvsFilterParameter)(nil)).Elem()
}

// This class defines Network Filter Policy.
type DvsFilterPolicy struct {
	InheritablePolicy

	// List of Network Filter Configurations.
	//
	// In an update operation, the array can contain all
	// `DvsTrafficFilterConfigSpec` objects
	// or all `DvsFilterConfig` and
	// `DvsTrafficFilterConfig`
	// object, but not mixed of Config and Spec objects. If array of
	// `DvsFilterConfigSpec` and `DvsTrafficFilterConfigSpec` is used
	// for updating Network Filter then only the Network Filters
	// matching `DistributedVirtualPort.key` /
	// `DistributedVirtualPort.key`
	// is updated.
	// If array of `DvsFilterConfig` and
	// `DvsTrafficFilterConfig`
	// is used for updating port settings, the Network Filter
	// settings will be overridden with the new array specified. The
	// specified array should only contain `DvsFilterConfig` and
	// `DvsTrafficFilterConfig` objects with `InheritablePolicy.inherited` /
	// `InheritablePolicy.inherited` set to false.
	// `DvsFilterConfig*/*DvsTrafficFilterConfig` objects with
	// `InheritablePolicy.inherited*/*InheritablePolicy.inherited` as
	// true in the specified array will be ignored. The updated result will
	// include `DvsFilterConfig*/*DvsTrafficFilterConfig` objects
	// inherited from parent, if any.
	FilterConfig []BaseDvsFilterConfig `xml:"filterConfig,omitempty,typeattr" json:"filterConfig,omitempty"`
}

func init() {
	t["DvsFilterPolicy"] = reflect.TypeOf((*DvsFilterPolicy)(nil)).Elem()
}

// This class defines network rule action to GRE Encapsulate a packet.
type DvsGreEncapNetworkRuleAction struct {
	DvsNetworkRuleAction

	// Single IP address.
	//
	// Only IPv4 is supported for vSphere API 5.5.
	EncapsulationIp SingleIp `xml:"encapsulationIp" json:"encapsulationIp"`
}

func init() {
	t["DvsGreEncapNetworkRuleAction"] = reflect.TypeOf((*DvsGreEncapNetworkRuleAction)(nil)).Elem()
}

// Health check status of an switch is changed.
type DvsHealthStatusChangeEvent struct {
	HostEvent

	// UUID of the DVS the host is connected to.
	SwitchUuid string `xml:"switchUuid" json:"switchUuid"`
	// Health check status.
	HealthResult BaseHostMemberHealthCheckResult `xml:"healthResult,omitempty,typeattr" json:"healthResult,omitempty"`
}

func init() {
	t["DvsHealthStatusChangeEvent"] = reflect.TypeOf((*DvsHealthStatusChangeEvent)(nil)).Elem()
}

// The DVS configuration on the host was synchronized with that of
// the Virtual Center Server and the configuration is the same on
// the host and Virtual Center Server.
type DvsHostBackInSyncEvent struct {
	DvsEvent

	// The host that was synchronized.
	HostBackInSync HostEventArgument `xml:"hostBackInSync" json:"hostBackInSync"`
}

func init() {
	t["DvsHostBackInSyncEvent"] = reflect.TypeOf((*DvsHostBackInSyncEvent)(nil)).Elem()
}

// This class defines the resource allocation for a host infrastructure
// traffic class on a physical NIC
type DvsHostInfrastructureTrafficResource struct {
	DynamicData

	// The key of the host infrastructure resource.
	//
	// Possible value can be of
	// `DistributedVirtualSwitchHostInfrastructureTrafficClass_enum`.
	Key string `xml:"key" json:"key"`
	// The description of the host infrastructure resource.
	//
	// This property is ignored for update operation.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// The allocation settings of the host infrastructure resource.
	AllocationInfo DvsHostInfrastructureTrafficResourceAllocation `xml:"allocationInfo" json:"allocationInfo"`
}

func init() {
	t["DvsHostInfrastructureTrafficResource"] = reflect.TypeOf((*DvsHostInfrastructureTrafficResource)(nil)).Elem()
}

// Resource allocation information for a
// host infrastructure traffic class.
type DvsHostInfrastructureTrafficResourceAllocation struct {
	DynamicData

	// The maximum allowed usage for a traffic class belonging to
	// this resource pool per host physical NIC.
	//
	// The utilization of a traffic class will not exceed the specified limit
	// even if there are available network resources. If this value is unset
	// or set to -1 in an update operation, then there is no limit on the network
	// resource usage (only bounded by available resource and shares).
	// Units are in Mbits/sec.
	Limit *int64 `xml:"limit" json:"limit,omitempty"`
	// Network share.
	//
	// The value is used as a relative weight in competing for
	// shared bandwidth, in case of resource contention.
	Shares *SharesInfo `xml:"shares,omitempty" json:"shares,omitempty"`
	// Amount of bandwidth resource that is guaranteed available
	// to the host infrastructure traffic class.
	//
	// If the utilization is less than the reservation, the extra bandwidth
	// is used for other host infrastructure traffic class types. Reservation is not
	// allowed to exceed the value of
	// `DvsHostInfrastructureTrafficResourceAllocation.limit`, if
	// `DvsHostInfrastructureTrafficResourceAllocation.limit` is set.
	// Unit is Mbits/sec.
	Reservation *int64 `xml:"reservation" json:"reservation,omitempty"`
}

func init() {
	t["DvsHostInfrastructureTrafficResourceAllocation"] = reflect.TypeOf((*DvsHostInfrastructureTrafficResourceAllocation)(nil)).Elem()
}

// A host joined the distributed virtual switch.
type DvsHostJoinedEvent struct {
	DvsEvent

	// The host that joined DVS.
	HostJoined HostEventArgument `xml:"hostJoined" json:"hostJoined"`
}

func init() {
	t["DvsHostJoinedEvent"] = reflect.TypeOf((*DvsHostJoinedEvent)(nil)).Elem()
}

// A host left the distributed virtual switch.
type DvsHostLeftEvent struct {
	DvsEvent

	// The host that left DVS.
	HostLeft HostEventArgument `xml:"hostLeft" json:"hostLeft"`
}

func init() {
	t["DvsHostLeftEvent"] = reflect.TypeOf((*DvsHostLeftEvent)(nil)).Elem()
}

// A host has it's status or statusDetail updated.
type DvsHostStatusUpdated struct {
	DvsEvent

	// The host.
	HostMember HostEventArgument `xml:"hostMember" json:"hostMember"`
	// Host's old status.
	OldStatus string `xml:"oldStatus,omitempty" json:"oldStatus,omitempty"`
	// Host's new status.
	NewStatus string `xml:"newStatus,omitempty" json:"newStatus,omitempty"`
	// Comments regarding host's old status.
	OldStatusDetail string `xml:"oldStatusDetail,omitempty" json:"oldStatusDetail,omitempty"`
	// Comments regarding host's new status.
	NewStatusDetail string `xml:"newStatusDetail,omitempty" json:"newStatusDetail,omitempty"`
}

func init() {
	t["DvsHostStatusUpdated"] = reflect.TypeOf((*DvsHostStatusUpdated)(nil)).Elem()
}

// The `DvsHostVNicProfile` data object describes the IP configuration
// for a host Virtual NIC connected to a distributed virtual switch.
//
// The `DvsVNicProfile.ipConfig` property contains the Virtual NIC IP address.
// If a profile plug-in defines policies or subprofiles, use the
// `ApplyProfile.policy` or `ApplyProfile.property`
// list to access the additional configuration data.
type DvsHostVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsHostVNicProfile"] = reflect.TypeOf((*DvsHostVNicProfile)(nil)).Elem()
}

// The DVS configuration on the host diverged from that of
// the Virtual Center Server.
type DvsHostWentOutOfSyncEvent struct {
	DvsEvent

	// The host that went out of sync.
	HostOutOfSync DvsOutOfSyncHostArgument `xml:"hostOutOfSync" json:"hostOutOfSync"`
}

func init() {
	t["DvsHostWentOutOfSyncEvent"] = reflect.TypeOf((*DvsHostWentOutOfSyncEvent)(nil)).Elem()
}

// This event is generated when a import operation is
// performed on a distributed virtual switch
type DvsImportEvent struct {
	DvsEvent

	// The type of restore operation.
	//
	// See `EntityImportType_enum` for valid values
	ImportType string `xml:"importType" json:"importType"`
}

func init() {
	t["DvsImportEvent"] = reflect.TypeOf((*DvsImportEvent)(nil)).Elem()
}

// This class defines the IP Rule Qualifier.
//
// Here IP addresses of source
// and destination will be used for classifying packets.
type DvsIpNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	// IP qualifier for source.
	//
	// If this property is NULL, it will match "any IPv4 or any IPv6 address".
	SourceAddress BaseIpAddress `xml:"sourceAddress,omitempty,typeattr" json:"sourceAddress,omitempty"`
	// IP qualifier for destination.
	//
	// If this property is NULL, it will match "any IPv4 or any IPv6 address".
	DestinationAddress BaseIpAddress `xml:"destinationAddress,omitempty,typeattr" json:"destinationAddress,omitempty"`
	// Protocols like TCP, UDP, ICMP etc.
	//
	// The valid value for a protocol
	// is got from IANA assigned value for the protocol. This can be got
	// from RFC 5237 and IANA website section related to protocol numbers.
	Protocol *IntExpression `xml:"protocol,omitempty" json:"protocol,omitempty"`
	// Source IP Port.
	SourceIpPort BaseDvsIpPort `xml:"sourceIpPort,omitempty,typeattr" json:"sourceIpPort,omitempty"`
	// Destination IP Port.
	DestinationIpPort BaseDvsIpPort `xml:"destinationIpPort,omitempty,typeattr" json:"destinationIpPort,omitempty"`
	// TCP flags.
	//
	// The valid values can be found at RFC 3168.
	// TCP flags are not supported by Traffic Filtering
	TcpFlags *IntExpression `xml:"tcpFlags,omitempty" json:"tcpFlags,omitempty"`
}

func init() {
	t["DvsIpNetworkRuleQualifier"] = reflect.TypeOf((*DvsIpNetworkRuleQualifier)(nil)).Elem()
}

// Base class for specifying Ports.
//
// Objects of the base class represent any port (single/range/list).
type DvsIpPort struct {
	NegatableExpression
}

func init() {
	t["DvsIpPort"] = reflect.TypeOf((*DvsIpPort)(nil)).Elem()
}

// This class defines a range of Ports.
type DvsIpPortRange struct {
	DvsIpPort

	// Starting port number of the ports range.
	StartPortNumber int32 `xml:"startPortNumber" json:"startPortNumber"`
	// Ending port number of the ports range.
	EndPortNumber int32 `xml:"endPortNumber" json:"endPortNumber"`
}

func init() {
	t["DvsIpPortRange"] = reflect.TypeOf((*DvsIpPortRange)(nil)).Elem()
}

// This class defines network rule action to just log the rule.
type DvsLogNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsLogNetworkRuleAction"] = reflect.TypeOf((*DvsLogNetworkRuleAction)(nil)).Elem()
}

// This class defines the MAC Rule Qualifier.
//
// Here MAC addresses of source
// and destination will be used for classifying packets.
type DvsMacNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	// MAC address for source.
	//
	// If this property is NULL, it will match "any MAC address".
	SourceAddress BaseMacAddress `xml:"sourceAddress,omitempty,typeattr" json:"sourceAddress,omitempty"`
	// MAC address for destination.
	//
	// If this property is NULL, it will match "any MAC address".
	DestinationAddress BaseMacAddress `xml:"destinationAddress,omitempty,typeattr" json:"destinationAddress,omitempty"`
	// Protocol used.
	//
	// This corresponds to the EtherType field in Ethernet
	// frame. The valid values can be found from IEEE list at:
	// http://standards.ieee.org/regauth/ as mentioned in RFC 5342.
	Protocol *IntExpression `xml:"protocol,omitempty" json:"protocol,omitempty"`
	// vlan id.
	VlanId *IntExpression `xml:"vlanId,omitempty" json:"vlanId,omitempty"`
}

func init() {
	t["DvsMacNetworkRuleQualifier"] = reflect.TypeOf((*DvsMacNetworkRuleQualifier)(nil)).Elem()
}

// This class defines network rule action to MAC Rewrite.
type DvsMacRewriteNetworkRuleAction struct {
	DvsNetworkRuleAction

	// Rewrite Destination MAC with this MAC address.
	RewriteMac string `xml:"rewriteMac" json:"rewriteMac"`
}

func init() {
	t["DvsMacRewriteNetworkRuleAction"] = reflect.TypeOf((*DvsMacRewriteNetworkRuleAction)(nil)).Elem()
}

// Two distributed virtual switches was merged.
type DvsMergedEvent struct {
	DvsEvent

	// The source DVS.
	SourceDvs DvsEventArgument `xml:"sourceDvs" json:"sourceDvs"`
	// The destination DVS.
	DestinationDvs DvsEventArgument `xml:"destinationDvs" json:"destinationDvs"`
}

func init() {
	t["DvsMergedEvent"] = reflect.TypeOf((*DvsMergedEvent)(nil)).Elem()
}

// This class is the base class for network rule action.
type DvsNetworkRuleAction struct {
	DynamicData
}

func init() {
	t["DvsNetworkRuleAction"] = reflect.TypeOf((*DvsNetworkRuleAction)(nil)).Elem()
}

// This class is the base class for identifying network traffic.
type DvsNetworkRuleQualifier struct {
	DynamicData

	// The key of the Qualifier
	Key string `xml:"key,omitempty" json:"key,omitempty"`
}

func init() {
	t["DvsNetworkRuleQualifier"] = reflect.TypeOf((*DvsNetworkRuleQualifier)(nil)).Elem()
}

// Thrown if
// `DVSCapability.dvsOperationSupported`
// is false and `DVSConfigInfo.extensionKey` is not same
// as the extension key of the login-session.
type DvsNotAuthorized struct {
	DvsFault

	// The extension key associated with the user-session.
	SessionExtensionKey string `xml:"sessionExtensionKey,omitempty" json:"sessionExtensionKey,omitempty"`
	// The value of `DVSConfigInfo.extensionKey`.
	DvsExtensionKey string `xml:"dvsExtensionKey,omitempty" json:"dvsExtensionKey,omitempty"`
}

func init() {
	t["DvsNotAuthorized"] = reflect.TypeOf((*DvsNotAuthorized)(nil)).Elem()
}

type DvsNotAuthorizedFault DvsNotAuthorized

func init() {
	t["DvsNotAuthorizedFault"] = reflect.TypeOf((*DvsNotAuthorizedFault)(nil)).Elem()
}

// Thrown if a DistributedVirtualSwitch operation failed on some of the host members.
type DvsOperationBulkFault struct {
	DvsFault

	// Faults occurred on the host during a DistributedVirtualSwitch operation.
	HostFault []DvsOperationBulkFaultFaultOnHost `xml:"hostFault" json:"hostFault"`
}

func init() {
	t["DvsOperationBulkFault"] = reflect.TypeOf((*DvsOperationBulkFault)(nil)).Elem()
}

type DvsOperationBulkFaultFault DvsOperationBulkFault

func init() {
	t["DvsOperationBulkFaultFault"] = reflect.TypeOf((*DvsOperationBulkFaultFault)(nil)).Elem()
}

// The fault occurred on the host during an operation.
type DvsOperationBulkFaultFaultOnHost struct {
	DynamicData

	// The host.
	//
	// Refers instance of `HostSystem`.
	Host ManagedObjectReference `xml:"host" json:"host"`
	// The fault that occurred.
	Fault LocalizedMethodFault `xml:"fault" json:"fault"`
}

func init() {
	t["DvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*DvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

// The host on which the DVS configuration is different from that
// of Virtual Center server.
type DvsOutOfSyncHostArgument struct {
	DynamicData

	// The host.
	OutOfSyncHost HostEventArgument `xml:"outOfSyncHost" json:"outOfSyncHost"`
	// The DVS configuration parameters that are different between
	// Virtual Center server and the host.
	ConfigParamters []string `xml:"configParamters" json:"configParamters"`
}

func init() {
	t["DvsOutOfSyncHostArgument"] = reflect.TypeOf((*DvsOutOfSyncHostArgument)(nil)).Elem()
}

// A port is blocked in the distributed virtual switch.
type DvsPortBlockedEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// Reason for port's current status
	StatusDetail string `xml:"statusDetail,omitempty" json:"statusDetail,omitempty"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
	// Previous state of the DvsPort.
	//
	// See `DvsEventPortBlockState_enum`
	PrevBlockState string `xml:"prevBlockState,omitempty" json:"prevBlockState,omitempty"`
}

func init() {
	t["DvsPortBlockedEvent"] = reflect.TypeOf((*DvsPortBlockedEvent)(nil)).Elem()
}

// A port is connected in the distributed virtual switch.
type DvsPortConnectedEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port's connectee.
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty" json:"connectee,omitempty"`
}

func init() {
	t["DvsPortConnectedEvent"] = reflect.TypeOf((*DvsPortConnectedEvent)(nil)).Elem()
}

// New ports are created in the distributed virtual switch.
type DvsPortCreatedEvent struct {
	DvsEvent

	// The key of the ports that are created.
	PortKey []string `xml:"portKey" json:"portKey"`
}

func init() {
	t["DvsPortCreatedEvent"] = reflect.TypeOf((*DvsPortCreatedEvent)(nil)).Elem()
}

// Existing ports are deleted in the distributed virtual switch.
type DvsPortDeletedEvent struct {
	DvsEvent

	// The key of the ports that are deleted.
	PortKey []string `xml:"portKey" json:"portKey"`
}

func init() {
	t["DvsPortDeletedEvent"] = reflect.TypeOf((*DvsPortDeletedEvent)(nil)).Elem()
}

// A port is disconnected in the distributed virtual switch.
type DvsPortDisconnectedEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port's formal connectee.
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty" json:"connectee,omitempty"`
}

func init() {
	t["DvsPortDisconnectedEvent"] = reflect.TypeOf((*DvsPortDisconnectedEvent)(nil)).Elem()
}

// A port has entered passthrough mode on the distributed virtual switch.
type DvsPortEnteredPassthruEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortEnteredPassthruEvent"] = reflect.TypeOf((*DvsPortEnteredPassthruEvent)(nil)).Elem()
}

// A port has exited passthrough mode on the distributed virtual switch.
type DvsPortExitedPassthruEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortExitedPassthruEvent"] = reflect.TypeOf((*DvsPortExitedPassthruEvent)(nil)).Elem()
}

// A port was moved into the distributed virtual portgroup.
type DvsPortJoinPortgroupEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The portgroup key.
	PortgroupKey string `xml:"portgroupKey" json:"portgroupKey"`
	// The portgroup name.
	PortgroupName string `xml:"portgroupName" json:"portgroupName"`
}

func init() {
	t["DvsPortJoinPortgroupEvent"] = reflect.TypeOf((*DvsPortJoinPortgroupEvent)(nil)).Elem()
}

// A port was moved out of the distributed virtual portgroup.
type DvsPortLeavePortgroupEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The portgroup key.
	PortgroupKey string `xml:"portgroupKey" json:"portgroupKey"`
	// The portgroup name.
	PortgroupName string `xml:"portgroupName" json:"portgroupName"`
}

func init() {
	t["DvsPortLeavePortgroupEvent"] = reflect.TypeOf((*DvsPortLeavePortgroupEvent)(nil)).Elem()
}

// A port of which link status is changed to down in the distributed
// virtual switch.
type DvsPortLinkDownEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkDownEvent"] = reflect.TypeOf((*DvsPortLinkDownEvent)(nil)).Elem()
}

// A port of which link status is changed to up in the distributed
// virtual switch.
type DvsPortLinkUpEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkUpEvent"] = reflect.TypeOf((*DvsPortLinkUpEvent)(nil)).Elem()
}

// Existing ports are reconfigured in the distributed virtual switch.
type DvsPortReconfiguredEvent struct {
	DvsEvent

	// The key of the ports that are reconfigured.
	PortKey []string `xml:"portKey" json:"portKey"`
	// The configuration values changed during the reconfiguration.
	ConfigChanges []ChangesInfoEventArgument `xml:"configChanges,omitempty" json:"configChanges,omitempty"`
}

func init() {
	t["DvsPortReconfiguredEvent"] = reflect.TypeOf((*DvsPortReconfiguredEvent)(nil)).Elem()
}

// A port of which runtime information is changed in the vNetwork Distributed
// Switch.
type DvsPortRuntimeChangeEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The new port runtime information.
	RuntimeInfo DVPortStatus `xml:"runtimeInfo" json:"runtimeInfo"`
}

func init() {
	t["DvsPortRuntimeChangeEvent"] = reflect.TypeOf((*DvsPortRuntimeChangeEvent)(nil)).Elem()
}

// A port is unblocked in the distributed virtual switch.
type DvsPortUnblockedEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
	// The port runtime information.
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty" json:"runtimeInfo,omitempty"`
	// Previous state of the DvsPort.
	//
	// See `DvsEventPortBlockState_enum`
	PrevBlockState string `xml:"prevBlockState,omitempty" json:"prevBlockState,omitempty"`
}

func init() {
	t["DvsPortUnblockedEvent"] = reflect.TypeOf((*DvsPortUnblockedEvent)(nil)).Elem()
}

// A port of which vendor specific state is changed in the vNetwork Distributed
// Switch.
type DvsPortVendorSpecificStateChangeEvent struct {
	DvsEvent

	// The port key.
	PortKey string `xml:"portKey" json:"portKey"`
}

func init() {
	t["DvsPortVendorSpecificStateChangeEvent"] = reflect.TypeOf((*DvsPortVendorSpecificStateChangeEvent)(nil)).Elem()
}

// The `DvsProfile` data object represents the distributed virtual switch
// to which this host is connected.
//
// If a profile plug-in defines policies or subprofiles,
// use the `ApplyProfile.policy` or `ApplyProfile.property`
// list to access the additional configuration data.
type DvsProfile struct {
	ApplyProfile

	// Linkable identifier.
	Key string `xml:"key" json:"key"`
	// Unique identifier for the distributed virtual switch.
	Name string `xml:"name" json:"name"`
	// List of subprofiles that map physical NICs to uplink ports.
	//
	// Use the `PnicUplinkProfile.key` property to access
	// subprofiles in the list.
	Uplink []PnicUplinkProfile `xml:"uplink,omitempty" json:"uplink,omitempty"`
}

func init() {
	t["DvsProfile"] = reflect.TypeOf((*DvsProfile)(nil)).Elem()
}

// This class defines network rule action to punt.
//
// i.e, forward packets
// to an associated slow-path service Virtual Machine.
type DvsPuntNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsPuntNetworkRuleAction"] = reflect.TypeOf((*DvsPuntNetworkRuleAction)(nil)).Elem()
}

// This class defines network rule action to ratelimit packets.
type DvsRateLimitNetworkRuleAction struct {
	DvsNetworkRuleAction

	// Rate limit value specified in packets per second.
	PacketsPerSecond int32 `xml:"packetsPerSecond" json:"packetsPerSecond"`
}

func init() {
	t["DvsRateLimitNetworkRuleAction"] = reflect.TypeOf((*DvsRateLimitNetworkRuleAction)(nil)).Elem()
}

// The parameters of `DistributedVirtualSwitch.DvsReconfigureVmVnicNetworkResourcePool_Task`.
type DvsReconfigureVmVnicNetworkResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this" json:"-"`
	// The Virtual NIC network resource pool configuration specification and operation type.
	ConfigSpec []DvsVmVnicResourcePoolConfigSpec `xml:"configSpec" json:"configSpec"`
}

func init() {
	t["DvsReconfigureVmVnicNetworkResourcePoolRequestType"] = reflect.TypeOf((*DvsReconfigureVmVnicNetworkResourcePoolRequestType)(nil)).Elem()
}

type DvsReconfigureVmVnicNetworkResourcePool_Task DvsReconfigureVmVnicNetworkResourcePoolRequestType

func init() {
	t["DvsReconfigureVmVnicNetworkResourcePool_Task"] = reflect.TypeOf((*DvsReconfigureVmVnicNetworkResourcePool_Task)(nil)).Elem()
}

type DvsReconfigureVmVnicNetworkResourcePool_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval" json:"returnval"`
}

// A distributed virtual switch was reconfigured.
type DvsReconfiguredEvent struct {
	DvsEvent

	// The reconfiguration spec.
	ConfigSpec BaseDVSConfigSpec `xml:"configSpec,typeattr" json:"configSpec"`
	// The configuration values changed during the reconfiguration.
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty" json:"configChanges,omitempty"`
}

func init() {
	t["DvsReconfiguredEvent"] = reflect.TypeOf((*DvsReconfiguredEvent)(nil)).Elem()
}

// A distributed virtual switch was renamed.
type DvsRenamedEvent struct {
	DvsEvent

	// The old DistributedVirtualSwitch name.
	OldName string `xml:"oldName" json:"oldName"`
	// The new DistributedVirtualSwitch name.
	NewName string `xml:"newName" json:"newName"`
}

func init() {
	t["DvsRenamedEvent"] = reflect.TypeOf((*DvsRenamedEvent)(nil)).Elem()
}

// This class defines the bandwidth reservation information for the
// vSphere Distributed Switch.
type DvsResourceRuntimeInfo struct {
	DynamicData

	// Capacity: Total Reservation allocated for Virtual Machine
	// Traffic for this switch.
	//
	// Units in Mbits/s.
	Capacity int32 `xml:"capacity,omitempty" json:"capacity,omitempty"`
	// usage: Current total usage.
	//
	// This is the sum of all reservations
	// allocated to `DVSVmVnicNetworkResourcePool` on this switch and the
	// sum of reservation taken by `VirtualEthernetCard` whose
	// backing is not associdated with any `DVSVmVnicNetworkResourcePool`.
	// Units in Mbits/s.
	Usage int32 `xml:"usage,omitempty" json:"usage,omitempty"`
	// Available: Current available resource for reservation (capacity - usage).
	//
	// Units in Mbits/s.
	Available int32 `xml:"available,omitempty" json:"available,omitempty"`
	// The reservation taken by `VirtualEthernetCard` of which the
	// backing is not associdated with any `DVSVmVnicNetworkResourcePool`
	AllocatedResource []DvsVnicAllocatedResource `xml:"allocatedResource,omitempty" json:"allocatedResource,omitempty"`
	// The runtime information of `DVSVmVnicNetworkResourcePool`.
	VmVnicNetworkResourcePoolRuntime []DvsVmVnicNetworkResourcePoolRuntimeInfo `xml:"vmVnicNetworkResourcePoolRuntime,omitempty" json:"vmVnicNetworkResourcePoolRuntime,omitempty"`
}

func init() {
	t["DvsResourceRuntimeInfo"] = reflect.TypeOf((*DvsResourceRuntimeInfo)(nil)).Elem()
}

// This event is generated when a restore operation is
// performed on a distributed virtual switch
type DvsRestoreEvent struct {
	DvsEvent
}

func init() {
	t["DvsRestoreEvent"] = reflect.TypeOf((*DvsRestoreEvent)(nil)).Elem()
}

// Deprecated as of vSphere API 5.5.
//
// Thrown if a entity trying to connect to a port or portgroup but it is not in the
// port or portgroup's scope.
type DvsScopeViolated struct {
	DvsFault

	// The configured scope.
	//
	// Refers instances of `ManagedEntity`.
	Scope []ManagedObjectReference `xml:"scope" json:"scope"`
	// The entity that violates the scope.
	//
	// Refers instance of `ManagedEntity`.
	Entity ManagedObjectReference `xml:"entity" json:"entity"`
}

func init() {
	t["DvsScopeViolated"] = reflect.TypeOf((*DvsScopeViolated)(nil)).Elem()
}

type DvsScopeViolatedFault DvsScopeViolated

func init() {
	t["DvsScopeViolatedFault"] = reflect.TypeOf((*DvsScopeViolatedFault)(nil)).Elem()
}

// The `DvsServiceConsoleVNicProfile` data object describes the IP configuration
// for a service console Virtual NIC connected to a distributed virtual switch.
//
// The `DvsVNicProfile.ipConfig` property contains the Virtual NIC IP address.
// If a profile plug-in defines policies or subprofiles, use the
// `ApplyProfile.policy` or `ApplyProfile.property`
// list to access the additional configuration data.
type DvsServiceConsoleVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsServiceConsoleVNicProfile"] = reflect.TypeOf((*DvsServiceConsoleVNicProfile)(nil)).Elem()
}

// This class defines a Single Port
type DvsSingleIpPort struct {
	DvsIpPort

	// The IP port number.
	PortNumber int32 `xml:"portNumber" json:"portNumber"`
}

func init() {
	t["DvsSingleIpPort"] = reflect.TypeOf((*DvsSingleIpPort)(nil)).Elem()
}

// This class defines the System Traffic Qualifier.
//
// Here the type of
// traffic will be used for classifying packets.
type DvsSystemTrafficNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	// Type of system traffic.
	//
	// See `DistributedVirtualSwitchHostInfrastructureTrafficClass_enum`
	// for valid values.
	TypeOfSystemTraffic *StringExpression `xml:"typeOfSystemTraffic,omitempty" json:"typeOfSystemTraffic,omitempty"`
}

func init() {
	t["DvsSystemTrafficNetworkRuleQualifier"] = reflect.TypeOf((*DvsSystemTrafficNetworkRuleQualifier)(nil)).Elem()
}

// This class defines Traffic Filter configuration.
//
// ** Supported Qualifier and Actions **
// <table border="1"width="100%">
// <tr>
// <th>Traffic Filter Config</th>
// <th>Supported classes</th>
// </tr>
// <tr>
// <td>Qualifiers supported</td>
// <td>`SingleIp`, `IpRange`,
// `SingleMac`, `MacRange`,
// `DvsSingleIpPort`,
// `DvsSystemTrafficNetworkRuleQualifier`
// </td>
// </tr>
// <tr>
// <td>Actions Supported</td>
// <td>`DvsDropNetworkRuleAction`,
// `DvsAcceptNetworkRuleAction`,
// `DvsPuntNetworkRuleAction`,
// `DvsCopyNetworkRuleAction`,
// `DvsMacRewriteNetworkRuleAction`,
// `DvsGreEncapNetworkRuleAction`,
// `DvsLogNetworkRuleAction`,
// `DvsUpdateTagNetworkRuleAction`,
// `DvsRateLimitNetworkRuleAction`
// </td>
// </tr>
type DvsTrafficFilterConfig struct {
	DvsFilterConfig

	// Network Traffic Ruleset
	TrafficRuleset *DvsTrafficRuleset `xml:"trafficRuleset,omitempty" json:"trafficRuleset,omitempty"`
}

func init() {
	t["DvsTrafficFilterConfig"] = reflect.TypeOf((*DvsTrafficFilterConfig)(nil)).Elem()
}

// The specification to reconfigure Traffic Filter.
//
// This specification allows the user to do fine-grained updates for the
// Traffic Filter in the port settings.
// If the operation is `remove`, only the
// `DistributedVirtualPort.key` needs to be specified.
// If other fields are specified, they will be ignored. We cannot remove
// an inherited element. Only when the inherited flag is set to false and
// parent does not have an element with same key this operation succeeds.
// If the operation is `add`, then
// `DistributedVirtualPort.key` should not be specified and
// other fields need to be specified. The inherited flag should be set to
// false.
// If the operation is `edit`, then
// `DistributedVirtualPort.key` needs be specified and
// specify the other properties that need modification. If the inherited
// flag is set to true, a `DvsTrafficFilterConfig` object of same
// key must exist at the parent's level. The property values in the spec
// object will be ignored and use the values from the parent's
// `DvsTrafficFilterConfig` object instead. If inherited
// flag is set to false, then the new modifications will be applied.
type DvsTrafficFilterConfigSpec struct {
	DvsTrafficFilterConfig

	// Operation type.
	//
	// See `ConfigSpecOperation_enum` for valid values.
	Operation string `xml:"operation" json:"operation"`
}

func init() {
	t["DvsTrafficFilterConfigSpec"] = reflect.TypeOf((*DvsTrafficFilterConfigSpec)(nil)).Elem()
}

// This class defines a single rule that will be applied to network traffic.
type DvsTrafficRule struct {
	DynamicData

	// The key of the rule
	Key string `xml:"key,omitempty" json:"key,omitempty"`
	// Description of the rule
	Description string `xml:"description,omitempty" json:"description,omitempty"`
	// Sequence of this rule.
	//
	// i.e, the order in which this rule appears
	// in the ruleset.
	Sequence int32 `xml:"sequence,omitempty" json:"sequence,omitempty"`
	// List of Network rule qualifiers.
	//
	// 'AND' of this array of
	// network rule qualifiers is applied as one network traffic rule.
	// If the TrafficRule belongs to
	// `DvsFilterPolicy` :
	// There can be a maximum of 1 `DvsIpNetworkRuleQualifier`,
	// 1 `DvsMacNetworkRuleQualifier` and
	// 1 `DvsSystemTrafficNetworkRuleQualifier` for a total of
	// 3 `DvsTrafficRule.qualifier`
	Qualifier []BaseDvsNetworkRuleQualifier `xml:"qualifier,omitempty,typeattr" json:"qualifier,omitempty"`
	// Action to be applied for this rule.
	Action BaseDvsNetworkRuleAction `xml:"action,omitempty,typeattr" json:"action,omitempty"`
	// Whether this rule needs to be applied to incoming packets,
	// to outgoing packets or both.
	//
	// See `DvsNetworkRuleDirectionType_enum` for valid values.
	Direction string `xml:"direction,omitempty" json:"direction,omitempty"`
}

func init() {
	t["DvsTrafficRule"] = reflect.TypeOf((*DvsTrafficRule)(nil)).Elem()
}

// This class defines a ruleset(set of rules) that will be
// applied to network traffic.
type DvsTrafficRuleset struct {
	DynamicData

	// The key of the ruleset.
	Key string `xml:"key,omitempty" json:"key,omitempty"`
	// Whether ruleset is enabled or not.
	Enabled *bool `xml:"enabled" json:"enabled,omitempty"`
	// Precedence of the ruleset.
	//
	// Rulesets for a port will be executed
	// in the order of their precedence.
	Precedence int32 `xml:"precedence,omitempty" json:"precedence,omitempty"`
	// List of rules belonging to this ruleset.
	Rules []DvsTrafficRule `xml:"rules,omitempty" json:"rules,omitempty"`
}

func init() {
	t["DvsTrafficRuleset"] = reflect.TypeOf((*DvsTrafficRuleset)(nil)).Elem()
}

// This class defines network rule action to tag packets(qos,dscp) or
// clear tags(clear qos, dscp tags) on packets.
//
// One or both of qos and dscp may be specified.
type DvsUpdateTagNetworkRuleAction struct {
	DvsNetworkRuleAction

	// QOS tag.
	//
	// IEEE 802.1p supports 3 bit Priority Code Point (PCP).
	// The valid values are between 0-7. Please refer the IEEE 802.1p
	// documentation for more details about what each value represents.
	// If qosTag is set to 0 then the tag on the packets will be cleared.
	QosTag int32 `xml:"qosTag,omitempty" json:"qosTag,omitempty"`
	// DSCP tag.
	//
	// The valid values for DSCP tag can be found in
	// 'Differentiated Services Field Codepoints' section of IANA website.
	// The information can also be got from reading all of the below RFC:
	// RFC 2474, RFC 2597, RFC 3246, RFC 5865.
	// If the dscpTag is set to 0 then the dscp tag on packets will be cleared.
	DscpTag int32 `xml:"dscpTag,omitempty" json:"dscpTag,omitempty"`
}

func init() {
	t["DvsUpdateTagNetworkRuleAction"] = reflect.TypeOf((*DvsUpdateTagNetworkRuleAction)(nil)).Elem()
}

// An upgrade for the distributed virtual switch is available.
type DvsUpgradeAvailableEvent struct {
	DvsEvent

	// The product info of the upgrade.
	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo" json:"productInfo"`
}

func init() {
	t["DvsUpgradeAvailableEvent"] = reflect.TypeOf((*DvsUpgradeAvailableEvent)(nil)).Elem()
}

// An upgrade for the distributed virtual switch is in progress.
type DvsUpgradeInProgressEvent struct {
	DvsEvent

	// The product info of the upgrade.
	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo" json:"productInfo"`
}

func init() {
	t["DvsUpgradeInProgressEvent"] = reflect.TypeOf((*DvsUpgradeInProgressEvent)(nil)).Elem()
}

// An upgrade for the distributed virtual switch is rejected.
type DvsUpgradeRejectedEvent struct {
	DvsEvent

	// The product info of the upgrade.
	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo" json:"productInfo"`
}

func init() {
	t["DvsUpgradeRejectedEvent"] = reflect.TypeOf((*DvsUpgradeRejectedEvent)(nil)).Elem()
}

// The distributed virtual switch was upgraded.
type DvsUpgradedEvent struct {
	DvsEvent

	// The product info of the upgrade.
	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo" json:"productInfo"`
}

func init() {
	t["DvsUpgradedEvent"] = reflect.TypeOf((*DvsUpgradedEvent)(nil)).Elem()
}

// The `DvsVNicProfile` data object is the base object
// for host and service console Virtual NIC subprofiles.
//
// If a profile plug-in defines additional policies or subprofiles, use the
// `ApplyProfile.policy` or `ApplyProfile.property`
// list to access the configuration data.
type DvsVNicProfile struct {
	ApplyProfile

	// Linkable identifier.
	Key string `xml:"key" json:"key"`
	// IP address for the Virtual NIC belonging to a distributed virtual switch.
	IpConfig IpAddressProfile `xml:"ipConfig" json:"ipConfig"`
}

func init() {
	t["DvsVNicProfile"] = reflect.TypeOf((*DvsVNicProfile)(nil)).Elem()
}

// This class defines the runtime information for the
// virtual NIC network resource pool
type DvsVmVnicNetworkResourcePoolRuntimeInfo struct {
	DynamicData

	// The key of the virtual NIC network resource pool
	Key string `xml:"key" json:"key"`
	// The name of the virtual NIC network resource pool
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// Capacity: Reservation allocated for this Network Resource Pool.
	//
	// Units in Mbits/s.
	Capacity int32 `xml:"capacity,omitempty" json:"capacity,omitempty"`
	// usage: Reservation taken by all `VirtualEthernetCard` for which the
	// backing is associdated with this `DVSVmVnicNetworkResourcePool`.
	//
	// Units in Mbits/s.
	Usage int32 `xml:"usage,omitempty" json:"usage,omitempty"`
	// Available: Current available resource for reservation (capacity - usage).
	//
	// Units in Mbits/s.
	Available int32 `xml:"available,omitempty" json:"available,omitempty"`
	// The status of the virtual NIC network resource pool
	// See `ManagedEntityStatus_enum` for possible values
	//
	// `red` indicates that the
	// reservations used by all the virtual network adapters belonging
	// to this resource pool exceeds the total reservation quota allocated to the
	// resource pool. This can happen due to failure of one or more uplink
	// or if the user bypasses VirtualCenter and powers on VMs directly on host.
	// The reservation of one or more virtual network adapters cannot be guaranteed
	// and corrective action needs to be taken by the user.
	//
	// `green` indicates that the resource pool
	// is in good state. The reservations for all virtual network adapters can
	// be fulfilled.
	Status string `xml:"status" json:"status"`
	// The virtual network adapaters that
	// are currently associated with the resource pool
	AllocatedResource []DvsVnicAllocatedResource `xml:"allocatedResource,omitempty" json:"allocatedResource,omitempty"`
}

func init() {
	t["DvsVmVnicNetworkResourcePoolRuntimeInfo"] = reflect.TypeOf((*DvsVmVnicNetworkResourcePoolRuntimeInfo)(nil)).Elem()
}

// Resource allocation information for a virtual NIC network resource pool.
type DvsVmVnicResourceAllocation struct {
	DynamicData

	// Quota for the total amount of virtual machine nic reservation in this pool.
	//
	// Unit in Mbits/sec.
	ReservationQuota int64 `xml:"reservationQuota,omitempty" json:"reservationQuota,omitempty"`
}

func init() {
	t["DvsVmVnicResourceAllocation"] = reflect.TypeOf((*DvsVmVnicResourceAllocation)(nil)).Elem()
}

// The configuration specification data object to update the resource configuration
// for a virtual NIC network resource pool.
type DvsVmVnicResourcePoolConfigSpec struct {
	DynamicData

	// The type of operation on the virtual NIC network resource pool
	// Possible value can be of
	// `ConfigSpecOperation_enum`
	Operation string `xml:"operation" json:"operation"`
	// The key of the network resource pool.
	//
	// The property is ignored for add
	// operations.
	Key string `xml:"key,omitempty" json:"key,omitempty"`
	// The configVersion is a unique identifier for a given version
	// of the configuration.
	//
	// Each change to the configuration will
	// update this value. This is typically implemented as a
	// non-decreasing count or a time-stamp. However, a client should
	// always treat this as an opaque string.
	//
	// If specified when updating the resource configuration, the
	// changes will only be applied if the current configVersion matches the
	// specified configVersion. This field can be used to guard against
	// updates that that may have occurred between the time when configVersion
	// was read and when it is applied.
	ConfigVersion string `xml:"configVersion,omitempty" json:"configVersion,omitempty"`
	// The resource allocation for the virtual NIC network resource pool.
	AllocationInfo *DvsVmVnicResourceAllocation `xml:"allocationInfo,omitempty" json:"allocationInfo,omitempty"`
	// The name for the virtual NIC network resource pool.
	//
	// The property is required for Add operations.
	Name string `xml:"name,omitempty" json:"name,omitempty"`
	// The description for the virtual NIC network resource pool.
	Description string `xml:"description,omitempty" json:"description,omitempty"`
}

func init() {
	t["DvsVmVnicResourcePoolConfigSpec"] = reflect.TypeOf((*DvsVmVnicResourcePoolConfigSpec)(nil)).Elem()
}

// This class defines the allocated resource information on a virtual NIC
type DvsVnicAllocatedResource struct {
	DynamicData

	// The virtual machine
	//
	// Refers instance of `VirtualMachine`.
	Vm ManagedObjectReference `xml:"vm" json:"vm"`
	// The virtual NIC key
	VnicKey string `xml:"vnicKey" json:"vnicKey"`
	// The reservation specification on the virtual NIC.
	//
	// Units in Mbits/s
	Reservation *int64 `xml:"reservation" json:"reservation,omitempty"`
}

func init() {
	t["DvsVnicAllocatedResource"] = reflect.TypeOf((*DvsVnicAllocatedResource)(nil)).Elem()
}

// DynamicArray is a data object type that represents an array of dynamically-typed
// objects.
//
// A client should only see a DynamicArray object when the element type
// is unknown (meaning the type is newer than the client). Otherwise, a client would
// see the type as T\[\] where T is known.
type DynamicArray struct {
	// Array of dynamic values.
	Val []AnyType `xml:"val,typeattr" json:"val"`
}

func init() {
	t["DynamicArray"] = reflect.TypeOf((*DynamicArray)(nil)).Elem()
}

type DynamicData struct {
}

func init() {
	t["DynamicData"] = reflect.TypeOf((*DynamicData)(nil)).Elem()
}

// The DynamicProperty data object type represents a name-value pair.
type DynamicProperty struct {
	// Path to the property.
	Name string `xml:"name" json:"name"`
	// Value of the property.
	Val AnyType `xml:"val,typeattr" json:"val"`
}

func init() {
	t["DynamicProperty"] = reflect.TypeOf((*DynamicProperty)(nil)).Elem()
}

// The host does not satisfy the admission requirements for the Enhanced
// VMotion Compatibility mode of the cluster.
type EVCAdmissionFailed struct {
	NotSupportedHostInCluster

	// The faults that caused this EVC test to fail
	// (e.g.
	//
	// FeatureRequirementsNotMet faults).
	Faults []LocalizedMethodFault `xml:"faults,omitempty" json:"faults,omitempty"`
}

func init() {
	t["EVCAdmissionFailed"] = reflect.TypeOf((*EVCAdmissionFailed)(nil)).Elem()
}

// The host's CPU hardware is a family/model that should support the
// Enhanced VMotion Compatibility mode of the cluster, but some necessary
// CPU features are not present.
type EVCAdmissionFailedCPUFeaturesForMode struct {
	EVCAdmissionFailed

	// The Enhanced VMotion Compatibility mode that is currently in effect for
	// the cluster.
	CurrentEVCModeKey string `xml:"currentEVCModeKey" json:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUFeaturesForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUFeaturesForModeFault EVCAdmissionFailedCPUFeaturesForMode

func init() {
	t["EVCAdmissionFailedCPUFeaturesForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForModeFault)(nil)).Elem()
}

// The host's CPU hardware is a family/model that does not support any
// Enhanced VMotion Compatibility mode.
type EVCAdmissionFailedCPUModel struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUModel"] = reflect.TypeOf((*EVCAdmissionFailedCPUModel)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelFault EVCAdmissionFailedCPUModel

func init() {
	t["EVCAdmissionFailedCPUModelFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelFault)(nil)).Elem()
}

// The host's CPU hardware is a family/model that does not support the Enhanced
// VMotion Compatibility mode of the cluster.
type EVCAdmissionFailedCPUModelForMode struct {
	EVCAdmissionFailed

	// The Enhanced VMotion Compatibility mode that is currently in effect for
	// the cluster.
	CurrentEVCModeKey string `xml:"currentEVCModeKey" json:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUModelForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelForModeFault EVCAdmissionFailedCPUModelForMode

func init() {
	t["EVCAdmissionFailedCPUModelForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForModeFault)(nil)).Elem()
}

// The host's CPU vendor does not match the required CPU vendor for the
// Enhanced VMotion Compatibility mode of the cluster.
type EVCAdmissionFailedCPUVendor struct {
	EVCAdmissionFailed

	// The CPU vendor required for entering the cluster.
	ClusterCPUVendor string `xml:"clusterCPUVendor" json:"clusterCPUVendor"`
	// The CPU vendor of the host.
	HostCPUVendor string `xml:"hostCPUVendor" json:"hostCPUVendor"`
}

func init() {
	t["EVCAdmissionFailedCPUVendor"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendor)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorFault EVCAdmissionFailedCPUVendor

func init() {
	t["EVCAdmissionFailedCPUVendorFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorFault)(nil)).Elem()
}

// The host's CPU vendor is unknown, which prevents admission into an Enhanced
// VMotion Compatibility cluster.
type EVCAdmissionFailedCPUVendorUnknown struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUVendorUnknown"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknown)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorUnknownFault EVCAdmissionFailedCPUVendorUnknown

func init() {
	t["EVCAdmissionFailedCPUVendorUnknownFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknownFault)(nil)).Elem()
}

type EVCAdmissionFailedFault BaseEVCAdmissionFailed

func init() {
	t["EVCAdmissionFailedFault"] = reflect.TypeOf((*EVCAdmissionFailedFault)(nil)).Elem()
}

// The host is not connected, which prevents admission into an Enhanced
// VMotion Compatibility cluster.
type EVCAdmissionFailedHostDisconnected struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostDisconnected"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnected)(nil)).Elem()
}

type EVCAdmissionFailedHostDisconnectedFault EVCAdmissionFailedHostDisconnected

func init() {
	t["EVCAdmissionFailedHostDisconnectedFault"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnectedFault)(nil)).Elem()
}

// The host's software does not support any Enhanced VMotion Compatibility mode.
type EVCAdmissionFailedHostSoftware struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftware"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftware)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareFault EVCAdmissionFailedHostSoftware

func init() {
	t["EVCAdmissionFailedHostSoftwareFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareFault)(nil)).Elem()
}

// The host's software does not support the Enhanced VMotion Compatibility
// mode of the cluster.
type EVCAdmissionFailedHostSoftwareForMode struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftwareForMode"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForMode)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareForModeFault EVCAdmissionFailedHostSoftwareForMode

func init() {
	t["EVCAdmissionFailedHostSoftwareForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForModeFault)(nil)).Elem()
}

// An attempt to move or add a host into an Enhanced VMotion Compatibility
// cluster has failed for the following reason:
//   - The host exposes additional compatibility-relevant CPU features beyond
//     those present in the baseline mandated by the cluster's EVC mode.
//   - The host has powered-on or suspended virtual machines.
//
// Therefore the host may not be admitted into the cluster, since its virtual
// machines may be using CPU features suppressed in the cluster.
//
// Note that in rare cases, this may occur even if the host's
// `maxEVCModeKey` corresponds to the EVC
// mode of the cluster. This means that even though that EVC mode is the best
// match for the host's hardware, the host still has some features beyond
// those present in the baseline for that EVC mode.
type EVCAdmissionFailedVmActive struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedVmActive"] = reflect.TypeOf((*EVCAdmissionFailedVmActive)(nil)).Elem()
}

type EVCAdmissionFailedVmActiveFault EVCAdmissionFailedVmActive

func init() {
	t["EVCAdmissionFailedVmActiveFault"] = reflect.TypeOf((*EVCAdmissionFailedVmActiveFault)(nil)).Elem()
}

// An attempt to enable Enhanced VMotion Compatibility on a cluster has failed.
type EVCConfigFault struct {
	VimFault

	// The faults that caused this EVC test to fail,
	// such as `FeatureRequirementsNotMet` faults.
	Faults []LocalizedMethodFault `xml:"faults,omitempty" json:"faults,omitempty"`
}

func init() {
	t["EVCConfigFault"] = reflect.TypeOf((*EVCConfigFault)(nil)).Elem()
}

type EVCConfigFaultFault BaseEVCConfigFault

func init() {
	t["EVCConfigFaultFault"] = reflect.TypeOf((*EVCConfigFaultFault)(nil)).Elem()
}

// The `EVCMode` data object describes an Enhanced vMotion Compatibility mode.
//
// An EVC mode is associated with a set of CPU features. A vCenter Server defines
// the available EVC modes. You use them to establish a common set of features
// for compatibility between hosts in a cluster. An EVC-enabled cluster supports
// safe vMotion of virtual machines across a range of CPU generations.
// You must use the vSphere Client to configure EVC.
//
// When you add a host to an EVC-enabled cluster, the vCenter Server determines
// the CPU compatibility to preserve vMotion compatibility within the cluster.
// If the host CPU is compatible with those already in the cluster, the Server
// adds the host to the cluster and configures it for compatible operation.
// Hosts that are not compatible are not allowed to join the cluster.
//
// The inherited `ElementDescription.key` property is a string value
// that uniquely identifies an EVC mode. The vCenter Server assigns
// the key value; the vSphere API uses the key to identify modes
// in summary and information objects:
//   - `ClusterComputeResourceSummary*.*ClusterComputeResourceSummary.currentEVCModeKey`
//   - `HostListSummary*.*HostListSummary.currentEVCModeKey`
//   - `HostListSummary*.*HostListSummary.maxEVCModeKey`
//   - `VirtualMachineRuntimeInfo*.*VirtualMachineRuntimeInfo.minRequiredEVCModeKey`
//
// The inherited `Description.label` and `Description.summary`
// properties are human-readable strings.
//
// You can use the `EVCMode.track` and `EVCMode.vendorTier` properties to determine
// feature-superset relationships between modes without examining the
// individual feature bits in `EVCMode.guaranteedCPUFeatures`.
// The CPU feature baseline of mode A is a superset of mode B's baseline
// if and only if:
//   - modeA.track is the same as or a superset of modeB.track
//   - modeA.vendorTier is equal to or greater than modeB.vendorTie