/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0014J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionRequest;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "info", "Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "getInfo", "()Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "isBatchingAllowed", "", "()Z", "redo", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "assertClientId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n45#2,2:111\n48#2,3:114\n51#2,2:122\n53#2,8:125\n25#3:113\n59#3:117\n37#3,2:118\n84#3,2:120\n86#3:124\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n74#1:111,2\n74#1:114,3\n74#1:122,2\n74#1:125,8\n74#1:113\n74#1:117\n74#1:118,2\n74#1:120,2\n74#1:124\n*E\n"})
public class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult
implements FrontendEditorActionRequest {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;
    @Nullable
    private final EditorActionCommandInfo info;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken, @Nullable EditorActionCommandInfo info2) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, patch, resetUndoHistoryToken);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
        this.info = info2;
    }

    @Override
    @NotNull
    public TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    @Nullable
    public EditorActionCommandInfo getInfo() {
        return this.info;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean redo(@NotNull FrontendRebaseSession rebaseSession) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(this.getEditorId());
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return false;
        }
        EditorImpl editor2 = editorImpl;
        ResetUndoHistoryToken resetUndoHistoryToken = this.getResetUndoHistoryToken();
        if (resetUndoHistoryToken != null) {
            resetUndoHistoryToken.refresh();
        }
        editor = FrontendPatchEngineKt.getEngine(this.getSession());
        String description$iv = "Redoing call editor action " + this.frontendActionId;
        boolean $i$f$recordChanges = false;
        if ($this$recordChanges$iv.getHasActivePatch()) {
            void $this$thisLogger$iv$iv = $this$recordChanges$iv;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PatchEngine.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        }
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl5 = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var13_19 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var13_19;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ChangeScope $this$redo_u24lambda_u240 = it$iv.getSession().getChangeScope();
                    boolean bl4 = false;
                    ActionManager actionManager = ActionManager.getInstance();
                    AnAction anAction = actionManager.getAction(this.frontendActionId);
                    if (anAction == null) {
                        throw new IllegalStateException(("Not found action id: " + this.frontendActionId).toString());
                    }
                    AnAction action = anAction;
                    DataContext dataContext = editor2.getDataContext();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext dataContext2 = dataContext;
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"keyboard shortcut", (DataContext)dataContext2);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)actionEvent);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv.getSession().getPatch();
            }
            catch (Throwable bl5) {
                try {
                    throwable = bl5;
                    throw bl5;
                }
                catch (Throwable bl5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw bl5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if ($this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        RdPatch patchAfterRedo = rdPatch;
        return this.updatePatchAfterRedo(patchAfterRedo) != null || this.getStatus().isExecuting();
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        String backendActionId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return (RdRequest)new RdCallEditorActionRequest(backendActionId, this.getEditorId(), this.getPatch());
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + " Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    @Override
    public void assertClientId() {
        ClientIdKt.assertClientIdConsistency$default((ClientId)new ClientId(this.getEditorId().getClientId()), (String)(this.debugDescription() + "::" + this.getEditorId().getDocumentId()), (boolean)false, (int)2, null);
    }
}

