/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.intellij.terminal.backend.BackendTerminalSession;
import com.intellij.terminal.backend.JediTermServices;
import com.intellij.terminal.backend.ObservableJediTerminal;
import com.intellij.terminal.backend.StopAwareTerminalStarter;
import com.intellij.terminal.backend.TerminalDisplayImpl;
import com.intellij.terminal.backend.TerminalOutputKt;
import com.intellij.terminal.backend.TerminalSessionStartKt;
import com.intellij.terminal.session.TerminalClearBufferEvent;
import com.intellij.terminal.session.TerminalCloseEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalResizeEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.terminal.session.TerminalWriteBytesEvent;
import com.intellij.terminal.session.dto.TerminalSizeDto;
import com.intellij.terminal.session.dto.TerminalSizeDtoKt;
import com.intellij.util.CoroutinesKt;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalBlockTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "startTerminalSession", "Lkotlin/Pair;", "Lcom/intellij/terminal/session/TerminalSession;", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "project", "Lcom/intellij/openapi/project/Project;", "options", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "createJediTermServices", "Lcom/intellij/terminal/backend/JediTermServices;", "connector", "Lcom/jediterm/terminal/TtyConnector;", "termSize", "Lcom/jediterm/core/util/TermSize;", "maxHistoryLinesCount", "", "createTerminalInputChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/intellij/terminal/session/TerminalInputEvent;", "services", "startTerminalEmulation", "", "terminalStarter", "Lcom/jediterm/terminal/TerminalStarter;", "ensureEmulationActive", "starter", "Lcom/intellij/terminal/backend/StopAwareTerminalStarter;", "intellij.terminal.backend"})
public final class TerminalSessionStartKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Pair<TerminalSession, ShellStartupOptions> startTerminalSession(@NotNull Project project, @NotNull ShellStartupOptions options, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        TermSize termSize = options.getInitialTermSize();
        if (termSize == null) {
            boolean bl = false;
            LOG.warn("No initial terminal size provided, using default 80x24. " + options);
            termSize = new TermSize(80, 24);
        }
        TermSize termSize2 = termSize;
        ShellStartupOptions optionsWithSize = options.builder().initialTermSize(termSize2).build();
        LocalBlockTerminalRunner runner = new LocalBlockTerminalRunner(project);
        ShellStartupOptions shellStartupOptions = runner.configureStartupOptions(optionsWithSize);
        Intrinsics.checkNotNullExpressionValue((Object)shellStartupOptions, (String)"configureStartupOptions(...)");
        ShellStartupOptions configuredOptions = shellStartupOptions;
        PtyProcess ptyProcess = runner.createProcess(configuredOptions);
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"createProcess(...)");
        PtyProcess process = ptyProcess;
        TtyConnector ttyConnector = runner.createTtyConnector(process);
        Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"createTtyConnector(...)");
        TtyConnector connector = ttyConnector;
        int maxHistoryLinesCount = AdvancedSettings.Companion.getInt("terminal.buffer.max.lines.count");
        JediTermServices services = TerminalSessionStartKt.createJediTermServices(connector, termSize2, maxHistoryLinesCount, settings);
        CoroutineScope outputScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"Terminal output forwarding", null, (boolean)false, (int)6, null);
        MutableSharedFlow<List<TerminalOutputEvent>> outputFlow = TerminalOutputKt.createTerminalOutputFlow(services.getTextBuffer(), services.getTerminalDisplay(), services.getController(), outputScope, (Function0<Unit>)((Function0)() -> TerminalSessionStartKt.startTerminalSession$lambda$1(services)));
        CoroutineScope inputScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"Terminal input handling", null, (boolean)false, (int)6, null);
        SendChannel<TerminalInputEvent> inputChannel = TerminalSessionStartKt.createTerminalInputChannel(services, inputScope);
        services.getExecutorService().getUnboundedExecutorService().submit(() -> TerminalSessionStartKt.startTerminalSession$lambda$2(services, coroutineScope, outputFlow));
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)coroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(services, null){
            int label;
            final /* synthetic */ JediTermServices $services;
            {
                this.$services = $services;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StopAwareTerminalStarter starter = this.$services.getTerminalStarter();
                        starter.close();
                        TtyConnector ttyConnector = starter.getTtyConnector();
                        Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"getTtyConnector(...)");
                        TerminalUtilKt.waitFor(ttyConnector, TerminalUtilKt.STOP_EMULATOR_TIMEOUT, (Function0<Unit>)((Function0)() -> startTerminalSession.2.invokeSuspend$lambda$0(starter)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(StopAwareTerminalStarter $starter) {
                $starter.requestEmulatorStop();
                return Unit.INSTANCE;
            }
        }), (int)1, null);
        BackendTerminalSession session2 = new BackendTerminalSession(inputChannel, (Flow<? extends List<? extends TerminalOutputEvent>>)((Flow)FlowKt.asSharedFlow(outputFlow)));
        return TuplesKt.to((Object)session2, (Object)configuredOptions);
    }

    private static final JediTermServices createJediTermServices(TtyConnector connector, TermSize termSize, int maxHistoryLinesCount, JBTerminalSystemSettingsProviderBase settings) {
        StyleState styleState = new StyleState();
        TerminalTextBuffer textBuffer = new TerminalTextBuffer(termSize.getColumns(), termSize.getRows(), styleState, maxHistoryLinesCount);
        TerminalDisplayImpl terminalDisplay = new TerminalDisplayImpl((DefaultSettingsProvider)settings);
        ObservableJediTerminal controller = new ObservableJediTerminal(terminalDisplay, textBuffer, styleState);
        TerminalTypeAheadManager typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)new JediTermTypeAheadModel((Terminal)controller, textBuffer, (SettingsProvider)settings));
        TerminalExecutorServiceManagerImpl executorService = new TerminalExecutorServiceManagerImpl();
        StopAwareTerminalStarter terminalStarter = new StopAwareTerminalStarter(controller, connector, (TerminalDataStream)new TtyBasedArrayDataStream(connector), typeAheadManager, (TerminalExecutorServiceManager)executorService);
        return new JediTermServices(textBuffer, terminalDisplay, controller, (TerminalExecutorServiceManager)executorService, terminalStarter);
    }

    private static final SendChannel<TerminalInputEvent> createTerminalInputChannel(JediTermServices services, CoroutineScope coroutineScope) {
        StopAwareTerminalStarter terminalStarter = services.getTerminalStarter();
        TerminalTextBuffer textBuffer = services.getTextBuffer();
        ObservableJediTerminal controller = services.getController();
        Channel inputChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<TerminalInputEvent>)inputChannel, terminalStarter, textBuffer, controller, null){
            Object L$0;
            int label;
            final /* synthetic */ Channel<TerminalInputEvent> $inputChannel;
            final /* synthetic */ StopAwareTerminalStarter $terminalStarter;
            final /* synthetic */ TerminalTextBuffer $textBuffer;
            final /* synthetic */ ObservableJediTerminal $controller;
            {
                this.$inputChannel = $inputChannel;
                this.$terminalStarter = $terminalStarter;
                this.$textBuffer = $textBuffer;
                this.$controller = $controller;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$inputChannel.iterator();
lbl6:
                        // 6 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) ** GOTO lbl54
                        event = (TerminalInputEvent)var2_3.next();
                        var4_5 = event;
                        if (!(var4_5 instanceof TerminalWriteBytesEvent)) ** GOTO lbl23
                        this.$terminalStarter.sendBytes(((TerminalWriteBytesEvent)event).getBytes(), false);
                        ** GOTO lbl6
lbl23:
                        // 1 sources

                        if (!(var4_5 instanceof TerminalResizeEvent)) ** GOTO lbl26
                        this.$terminalStarter.postResize(TerminalSizeDtoKt.toTermSize((TerminalSizeDto)((TerminalResizeEvent)event).getNewSize()), RequestOrigin.User);
                        ** GOTO lbl6
lbl26:
                        // 1 sources

                        if (!Intrinsics.areEqual((Object)var4_5, (Object)TerminalCloseEvent.INSTANCE)) ** GOTO lbl32
                        this.$terminalStarter.close();
                        v1 = this.$terminalStarter.getTtyConnector();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getTtyConnector(...)");
                        TerminalUtilKt.waitFor(v1, TerminalUtilKt.STOP_EMULATOR_TIMEOUT, (Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.terminal.backend.StopAwareTerminalStarter ), ()Lkotlin/Unit;)((StopAwareTerminalStarter)this.$terminalStarter));
                        ** GOTO lbl6
lbl32:
                        // 1 sources

                        if (!(var4_5 instanceof TerminalClearBufferEvent)) ** GOTO lbl53
                        var5_6 = this.$textBuffer;
                        var6_7 = this.$textBuffer;
                        var7_8 = this.$controller;
                        $i$f$withLock = false;
                        $this$withLock$iv.lock();
                        try {
                            $i$a$-withLock-TerminalSessionStartKt$createTerminalInputChannel$1$2 = false;
                            var6_7.clearHistory();
                            if (var7_8.getY() > 0) {
                                lastLine = var6_7.getLine(var7_8.getY() - 1);
                                var6_7.clearScreenBuffer();
                                var6_7.addLine(lastLine);
                                var7_8.setY(1);
                            }
                            var11_12 = Unit.INSTANCE;
                            ** GOTO lbl6
                        }
                        finally {
                            $this$withLock$iv.unlock();
                            ** continue;
                        }
lbl53:
                        // 1 sources

                        throw new NoWhenBranchMatchedException();
lbl54:
                        // 1 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(StopAwareTerminalStarter $terminalStarter) {
                $terminalStarter.requestEmulatorStop();
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        return (SendChannel)inputChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startTerminalEmulation(TerminalStarter terminalStarter) {
        try {
            terminalStarter.start();
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        finally {
            try {
                terminalStarter.getTtyConnector().close();
            }
            catch (Throwable t) {
                LOG.error("Error closing TtyConnector", t);
            }
        }
    }

    private static final void ensureEmulationActive(StopAwareTerminalStarter starter) {
        if (Thread.interrupted() || starter.isStopped()) {
            throw new CancellationException("Terminal emulation was stopped");
        }
    }

    private static final Unit startTerminalSession$lambda$1(JediTermServices $services) {
        TerminalSessionStartKt.ensureEmulationActive($services.getTerminalStarter());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startTerminalSession$lambda$2(JediTermServices $services, CoroutineScope $coroutineScope, MutableSharedFlow $outputFlow) {
        try {
            TerminalSessionStartKt.startTerminalEmulation($services.getTerminalStarter());
        }
        catch (Throwable throwable) {
            BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<List<TerminalOutputEvent>>)$outputFlow, $coroutineScope, null){
                int label;
                final /* synthetic */ MutableSharedFlow<List<TerminalOutputEvent>> $outputFlow;
                final /* synthetic */ CoroutineScope $coroutineScope;
                {
                    this.$outputFlow = $outputFlow;
                    this.$coroutineScope = $coroutineScope;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = this.$outputFlow.emit((Object)CollectionsKt.listOf((Object)TerminalSessionTerminatedEvent.INSTANCE), (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.$coroutineScope, null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            throw throwable;
        }
        BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
    }

    static {
        Logger logger = Logger.getInstance(BackendTerminalSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

