/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.CommitSelectionImpl;
import com.intellij.vcs.log.ui.table.VcsLogCommitListModel;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0001BB!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0016J'\u0010\"\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010$\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H&0'\u00a2\u0006\u0002\u0010(J\u0017\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010*\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010-2\u0006\u0010*\u001a\u00020\u001dH\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010*\u001a\u00020\u001dJ\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u0010*\u001a\u00020\u001dJ\u0014\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010*\u001a\u00020\u001dJ\u0014\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010*\u001a\u00020\u001dJ\u001c\u00108\u001a\u0004\u0018\u0001092\u0006\u0010*\u001a\u00020\u001d2\b\b\u0002\u0010:\u001a\u00020;H\u0007J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006C"}, d2={"Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/vcs/log/ui/table/VcsLogCommitListModel;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "requestMore", "Ljava/lang/Runnable;", "properties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Ljava/lang/Runnable;Lcom/intellij/vcs/log/impl/VcsLogUiProperties;)V", "getLogData", "()Lcom/intellij/vcs/log/data/VcsLogData;", "getProperties$intellij_platform_vcs_log_impl", "()Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "<set-?>", "Lcom/intellij/vcs/log/visible/VisiblePack;", "visiblePack", "getVisiblePack", "()Lcom/intellij/vcs/log/visible/VisiblePack;", "setVisiblePack", "(Lcom/intellij/vcs/log/visible/VisiblePack;)V", "visiblePack$delegate", "Lkotlin/properties/ReadWriteProperty;", "dataProvider", "Lcom/intellij/vcs/log/VcsLogDataProvider;", "getDataProvider", "()Lcom/intellij/vcs/log/VcsLogDataProvider;", "getRowCount", "", "getColumnCount", "getColumnName", "", "column", "getValueAt", "", "rowIndex", "columnIndex", "T", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "(ILcom/intellij/vcs/log/ui/table/column/VcsLogColumn;)Ljava/lang/Object;", "getId", "row", "(I)Ljava/lang/Integer;", "getGraphRowInfo", "Lcom/intellij/vcs/log/graph/RowInfo;", "getRowType", "Lcom/intellij/vcs/log/graph/RowType;", "getRootAtRow", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPrintElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "getRefsAtRow", "", "Lcom/intellij/vcs/log/VcsRef;", "getCommitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "load", "", "createSelection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "rows", "", "fromGraphToTableRow", "graphRow", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nGraphTableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphTableModel.kt\ncom/intellij/vcs/log/ui/table/GraphTableModel\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,127:1\n33#2,3:128\n*S KotlinDebug\n*F\n+ 1 GraphTableModel.kt\ncom/intellij/vcs/log/ui/table/GraphTableModel\n*L\n32#1:128,3\n*E\n"})
public final class GraphTableModel
extends AbstractTableModel
implements VcsLogCommitListModel {
    @NotNull
    private static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final Runnable requestMore;
    @NotNull
    private final VcsLogUiProperties properties;
    @NotNull
    private final ReadWriteProperty visiblePack$delegate;
    @NotNull
    private final VcsLogDataProvider dataProvider;
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public GraphTableModel(@NotNull VcsLogData logData, @NotNull Runnable requestMore, @NotNull VcsLogUiProperties properties) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)requestMore, (String)"requestMore");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.logData = logData;
        this.requestMore = requestMore;
        this.properties = properties;
        Delegates delegates = Delegates.INSTANCE;
        VisiblePack initialValue$iv = VisiblePack.EMPTY;
        boolean $i$f$observable = false;
        this.visiblePack$delegate = (ReadWriteProperty)new ObservableProperty<VisiblePack>((Object)initialValue$iv, this){
            final /* synthetic */ GraphTableModel this$0;
            {
                this.this$0 = graphTableModel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                VisiblePack cfr_ignored_0 = (VisiblePack)newValue;
                VisiblePack cfr_ignored_1 = (VisiblePack)oldValue;
                boolean bl = false;
                this.this$0.fireTableDataChanged();
            }
        };
        this.dataProvider = this.logData;
    }

    @NotNull
    public final VcsLogData getLogData() {
        return this.logData;
    }

    @NotNull
    public final VcsLogUiProperties getProperties$intellij_platform_vcs_log_impl() {
        return this.properties;
    }

    @NotNull
    public final VisiblePack getVisiblePack() {
        return (VisiblePack)this.visiblePack$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setVisiblePack(@NotNull VisiblePack visiblePack) {
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"<set-?>");
        this.visiblePack$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)visiblePack);
    }

    @Override
    @NotNull
    public VcsLogDataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public int getRowCount() {
        return this.getVisiblePack().getVisibleGraph().getVisibleCommitCount();
    }

    @Override
    public int getColumnCount() {
        return VcsLogColumnManager.Companion.getInstance().getModelColumnsCount();
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return GraphTableModel.Companion.getColumn(column).getLocalizedName();
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object t = this.getValueAt(rowIndex, GraphTableModel.Companion.getColumn(columnIndex));
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
        return t;
    }

    public final <T> T getValueAt(int rowIndex, @NotNull VcsLogColumn<T> column) {
        T t;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (rowIndex >= this.getRowCount() - 1 && VcsLogUtil.canRequestMore(this.getVisiblePack())) {
            this.requestMore.run();
        }
        try {
            T t2 = column.getValue(this, rowIndex);
            if (t2 == null) {
                t2 = column.getStubValue(this);
            }
            t = t2;
        }
        catch (ProcessCanceledException ignore) {
            t = column.getStubValue(this);
        }
        catch (Throwable t3) {
            LOG.error("Failed to get information for the log table", t3);
            t = column.getStubValue(this);
        }
        return t;
    }

    @Override
    @Nullable
    public Integer getId(int row) {
        RowInfo<Integer> rowInfo = this.getGraphRowInfo(row);
        return rowInfo != null ? (Integer)rowInfo.getCommit() : null;
    }

    private final RowInfo<Integer> getGraphRowInfo(int row) {
        return this.getVisiblePack().getVisibleGraph().getRowInfo(row);
    }

    @Nullable
    public final RowType getRowType(int row) {
        RowInfo<Integer> rowInfo = this.getGraphRowInfo(row);
        return rowInfo != null ? rowInfo.getRowType() : null;
    }

    @Nullable
    public final VirtualFile getRootAtRow(int row) {
        Object object = this.getGraphRowInfo(row);
        if (object == null || (object = (Integer)object.getOneOfHeads()) == null) {
            return null;
        }
        int head = (Integer)object;
        return this.getVisiblePack().getRootAtHead(head);
    }

    @NotNull
    public final Collection<PrintElement> getPrintElements(int row) {
        Collection collection;
        if (((Boolean)VisiblePack.NO_GRAPH_INFORMATION.get((UserDataHolder)this.getVisiblePack(), (Object)false)).booleanValue()) {
            collection = CollectionsKt.emptyList();
        } else {
            RowInfo<Integer> rowInfo = this.getGraphRowInfo(row);
            collection = rowInfo != null ? rowInfo.getPrintElements() : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
        }
        return collection;
    }

    @NotNull
    public final List<VcsRef> getRefsAtRow(int row) {
        VirtualFile root = this.getRootAtRow(row);
        Integer n = this.getId(row);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int id = n;
        RefsModel refsModel = this.getVisiblePack().getDataPack().getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        RefsModel refsModel2 = refsModel;
        VirtualFile virtualFile = root;
        return virtualFile != null ? refsModel2.refsToCommit(virtualFile, id) : refsModel2.refsToCommit(id);
    }

    @JvmOverloads
    @Nullable
    public final VcsCommitMetadata getCommitMetadata(int row, boolean load) {
        Iterable iterable;
        Integer n = this.getId(row);
        if (n == null) {
            return null;
        }
        int commit = n;
        if (load) {
            int startRowIndex = Math.max(0, row - 20);
            int endRowIndex = Math.min(row + 40, this.getRowCount());
            iterable = SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)startRowIndex, (int)endRowIndex))), arg_0 -> GraphTableModel.getCommitMetadata$lambda$1(this, arg_0)));
        } else {
            List list = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"emptyList(...)");
            iterable = list;
        }
        Iterable commitsToLoad = iterable;
        return this.logData.getMiniDetailsGetter().getCommitData(commit, commitsToLoad);
    }

    public static /* synthetic */ VcsCommitMetadata getCommitMetadata$default(GraphTableModel graphTableModel, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return graphTableModel.getCommitMetadata(n, bl);
    }

    @NotNull
    public final VcsLogCommitSelection createSelection(@NotNull int[] rows) {
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        VisibleGraph<Integer> visibleGraph = this.getVisiblePack().getVisibleGraph();
        Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"getVisibleGraph(...)");
        return new CommitSelectionImpl(this.logData, visibleGraph, rows);
    }

    public final int fromGraphToTableRow(int graphRow) {
        return graphRow;
    }

    @JvmOverloads
    @Nullable
    public final VcsCommitMetadata getCommitMetadata(int row) {
        return GraphTableModel.getCommitMetadata$default(this, row, false, 2, null);
    }

    private static final Integer getCommitMetadata$lambda$1(GraphTableModel this$0, int it) {
        RowInfo<Integer> rowInfo = this$0.getGraphRowInfo(it);
        return rowInfo != null ? (Integer)rowInfo.getCommit() : null;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GraphTableModel.class, "visiblePack", "getVisiblePack()Lcom/intellij/vcs/log/visible/VisiblePack;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GraphTableModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/ui/table/GraphTableModel$Companion;", "", "<init>", "()V", "UP_PRELOAD_COUNT", "", "DOWN_PRELOAD_COUNT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getColumn", "Lcom/intellij/vcs/log/ui/table/column/VcsLogColumn;", "modelIndex", "intellij.platform.vcs.log.impl"})
    private static final class Companion {
        private Companion() {
        }

        private final VcsLogColumn<?> getColumn(int modelIndex) {
            return VcsLogColumnManager.Companion.getInstance().getColumn(modelIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

