/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.CSVReader;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessListUtil {
    private static final Logger LOG = Logger.getInstance(ProcessListUtil.class);
    private static final String WIN_PROCESS_LIST_HELPER_FILENAME = "WinProcessListHelper.exe";
    public static final List<@NlsSafe String> COMM_LIST_COMMAND = List.of("/bin/ps", "-a", "-x", "-o", "pid,ppid,state,user,comm");
    public static final List<@NlsSafe String> COMMAND_LIST_COMMAND = List.of("/bin/ps", "-a", "-x", "-o", "pid,ppid,state,user,command");
    private static final String PARENT_PID_PREFIX = "PPid:";

    private ProcessListUtil() {
    }

    public static ProcessInfo @NotNull [] getProcessList() {
        List<ProcessInfo> result = ProcessListUtil.doGetProcessList();
        ProcessInfo[] processInfoArray = result.toArray(ProcessInfo.EMPTY_ARRAY);
        if (processInfoArray == null) {
            ProcessListUtil.$$$reportNull$$$0(0);
        }
        return processInfoArray;
    }

    @NotNull
    private static List<ProcessInfo> doGetProcessList() {
        if (SystemInfo.isWindows) {
            List<ProcessInfo> result = ProcessListUtil.getProcessListUsingWinProcessListHelper();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
            LOG.info("Cannot get process list via WinProcessListHelper.exe, fallback to wmic");
            result = ProcessListUtil.getProcessListUsingWindowsWMIC();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
            LOG.info("Cannot get process list via wmic, fallback to tasklist");
            result = ProcessListUtil.getProcessListUsingWindowsTaskList();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(3);
                }
                return list;
            }
            LOG.error("Cannot get process list via wmic and tasklist");
        } else if (SystemInfo.isUnix) {
            List<ProcessInfo> result = SystemInfo.isMac ? ProcessListUtil.getProcessListOnMac() : ProcessListUtil.getProcessListOnUnix();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(4);
                }
                return list;
            }
            LOG.error("Cannot get process list");
        } else {
            LOG.error("Cannot get process list, unexpected platform: " + SystemInfo.OS_NAME);
        }
        List<ProcessInfo> list = Collections.emptyList();
        if (list == null) {
            ProcessListUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<@NlsSafe String> command, @NotNull NullableFunction<? super String, ? extends List<ProcessInfo>> parser) {
        if (command == null) {
            ProcessListUtil.$$$reportNull$$$0(6);
        }
        if (parser == null) {
            ProcessListUtil.$$$reportNull$$$0(7);
        }
        return ProcessListUtil.parseCommandOutput(command, parser, null);
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<@NlsSafe String> command, @NotNull NullableFunction<? super String, ? extends List<ProcessInfo>> parser, @Nullable Charset charset) {
        String output;
        if (command == null) {
            ProcessListUtil.$$$reportNull$$$0(8);
        }
        if (parser == null) {
            ProcessListUtil.$$$reportNull$$$0(9);
        }
        try {
            ProcessOutput processOutput;
            int exitCode;
            GeneralCommandLine commandLine = new GeneralCommandLine(command);
            if (charset != null) {
                commandLine.withCharset(charset);
            }
            if ((exitCode = (processOutput = ExecUtil.execAndGetOutput(commandLine)).getExitCode()) != 0) {
                LOG.error("Cannot get process list, command '" + StringUtil.join(command, (String)" ") + "' exited with code " + exitCode + ", stdout:\n" + processOutput.getStdout() + "\nstderr:\n" + processOutput.getStderr());
            }
            output = processOutput.getStdout();
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get process list", (Throwable)e);
            return null;
        }
        return (List)parser.fun((Object)output);
    }

    @Nullable
    private static List<ProcessInfo> getProcessListOnUnix() {
        File proc = new File("/proc");
        File[] processes = proc.listFiles();
        if (processes == null) {
            LOG.error("Cannot read /proc, not mounted?");
            return null;
        }
        String currentUser = ProcessListUtil.getCurrentUser();
        Map<Long, String> owners = ProcessListUtil.getProcessOwners();
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (File each : processes) {
            List cmdline;
            int pid = StringUtil.parseInt((String)each.getName(), (int)-1);
            if (pid == -1) continue;
            try (FileInputStream stream = new FileInputStream(new File(each, "cmdline"));){
                String cmdlineString = new String(FileUtil.loadBytes((InputStream)stream), StandardCharsets.UTF_8);
                cmdline = StringUtil.split((String)cmdlineString, (String)"\u0000");
            }
            catch (IOException e) {
                continue;
            }
            if (cmdline.isEmpty()) continue;
            String executablePath = null;
            try {
                File exe = new File(each, "exe");
                if (!exe.getAbsolutePath().equals(exe.getCanonicalPath())) {
                    executablePath = exe.getCanonicalPath();
                }
            }
            catch (IOException exe) {
                // empty catch block
            }
            int parentPid = -1;
            try (FileInputStream stream2 = new FileInputStream(new File(each, "status"));){
                String statusString = new String(FileUtil.loadBytes((InputStream)stream2), StandardCharsets.UTF_8);
                for (String line : StringUtil.splitByLines((String)statusString)) {
                    if (!line.startsWith(PARENT_PID_PREFIX)) continue;
                    try {
                        parentPid = Integer.parseInt(line.substring(PARENT_PID_PREFIX.length()).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.error("Failed to parse parent pid from line " + line);
                    }
                    break;
                }
            }
            catch (IOException stream2) {
                // empty catch block
            }
            String processUser = owners.get(pid);
            result.add(new ProcessInfo(pid, StringUtil.join((Collection)cmdline, (String)" "), PathUtil.getFileName((String)((String)cmdline.get(0))), StringUtil.join(cmdline.subList(1, cmdline.size()), (String)" "), executablePath, parentPid, processUser, currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(processUser)) : ThreeState.UNSURE));
        }
        return result;
    }

    @Nullable
    private static List<ProcessInfo> getProcessListOnMac() {
        return ProcessListUtil.parseCommandOutput(COMM_LIST_COMMAND, (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)commandOnly -> ProcessListUtil.parseCommandOutput(COMMAND_LIST_COMMAND, (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)full -> ProcessListUtil.parseMacOutput(commandOnly, full, ProcessListUtil.getCurrentUser())))));
    }

    @ApiStatus.Internal
    @Nullable
    public static List<ProcessInfo> parseMacOutput(@NotNull String commandOnly, @NotNull String full) {
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(10);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(11);
        }
        return ProcessListUtil.parseMacOutput(commandOnly, full, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static List<ProcessInfo> parseMacOutput(@NotNull String commandOnly, @NotNull String full, @Nullable String currentUser) {
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(12);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(13);
        }
        List<MacProcessInfo> commands = ProcessListUtil.doParseMacOutput(commandOnly);
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (commands == null || fulls == null) {
            return null;
        }
        Int2ObjectOpenHashMap idToCommand = new Int2ObjectOpenHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            String command;
            if (!idToCommand.containsKey(each.pid) || !each.commandLine.equals(command = (String)idToCommand.get(each.pid)) && !each.commandLine.startsWith(command + " ")) continue;
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.substring(command.length()).trim();
            ThreeState isOwnedByCurrentUser = currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(each.user)) : ThreeState.UNSURE;
            result.add(new ProcessInfo(each.pid, each.commandLine, name, args, command, each.parentPid, each.user, isOwnedByCurrentUser));
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @Nullable
    public static List<ProcessInfo> parseLinuxOutputMacStyle(@NotNull String commandOnly, @NotNull String full) {
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(14);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(15);
        }
        return ProcessListUtil.parseLinuxOutputMacStyle(commandOnly, full, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static List<ProcessInfo> parseLinuxOutputMacStyle(@NotNull String commandOnly, @NotNull String full, @Nullable String currentUser) {
        List<MacProcessInfo> commands;
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(16);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(17);
        }
        if ((commands = ProcessListUtil.doParseMacOutput(commandOnly)) == null) {
            LOG.debug("Failed to parse commands output: ", new Object[]{commandOnly});
            return null;
        }
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (fulls == null) {
            LOG.debug("Failed to parse comm output: ", new Object[]{full});
            return null;
        }
        Int2ObjectOpenHashMap idToCommand = new Int2ObjectOpenHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            if (!idToCommand.containsKey(each.pid)) continue;
            String command = (String)idToCommand.get(each.pid);
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.startsWith(command) ? each.commandLine.substring(command.length()).trim() : each.commandLine;
            ThreeState isOwnedByCurrentUser = currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(each.user)) : ThreeState.UNSURE;
            result.add(new ProcessInfo(each.pid, each.commandLine, name, args, command, each.parentPid, each.user, isOwnedByCurrentUser));
        }
        return result;
    }

    @Nullable
    private static List<MacProcessInfo> doParseMacOutput(@NlsSafe String output) {
        ArrayList<MacProcessInfo> result = new ArrayList<MacProcessInfo>();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        @NlsSafe String header = lines[0];
        String pidString = "PID";
        int pidStart = header.indexOf(pidString);
        if (pidStart == -1) {
            return null;
        }
        String parentPidString = "PPID";
        int parentPidStart = header.indexOf(parentPidString, pidStart);
        if (parentPidStart == -1) {
            return null;
        }
        int parentPidSectionStart = pidStart + pidString.length();
        int statStart = header.indexOf("S", parentPidStart);
        if (statStart == -1) {
            return null;
        }
        int userStart = header.indexOf("USER", statStart);
        if (userStart == -1) {
            return null;
        }
        int commandStart = header.indexOf("COMM", userStart);
        if (commandStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            try {
                int pid = StringUtil.parseInt((String)line.substring(0, parentPidSectionStart).trim(), (int)-1);
                if (pid == -1) continue;
                int parentPid = StringUtil.parseInt((String)line.substring(parentPidSectionStart, statStart).trim(), (int)-1);
                @NlsSafe String state = line.substring(statStart, userStart).trim();
                if (state.contains("Z")) continue;
                String user = line.substring(userStart, commandStart).trim();
                String commandLine = line.substring(commandStart).trim();
                result.add(new MacProcessInfo(pid, commandLine, user, state, parentPid));
                continue;
            }
            catch (Exception e) {
                LOG.error("Can't parse line '" + line + "'", (Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    private static List<ProcessInfo> getProcessListUsingWinProcessListHelper() {
        Path exeFile = ProcessListUtil.findWinProcessListHelperFile();
        if (exeFile == null) {
            return null;
        }
        return ProcessListUtil.parseCommandOutput(Collections.singletonList(exeFile.toAbsolutePath().toString()), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)output -> ProcessListUtil.parseWinProcessListHelperOutput(output, ProcessListUtil.getProcessOwners(), ProcessListUtil.getCurrentUser())), StandardCharsets.UTF_8);
    }

    private static void logErrorTestSafe(@NonNls String message) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            LOG.warn(message);
        } else {
            LOG.error(message);
        }
    }

    @Nullable
    private static String unescapeString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < str.length(); ++index) {
            if (str.charAt(index) == '\\') {
                if (index == str.length() - 1) {
                    ProcessListUtil.logErrorTestSafe("Invalid escaped string: backslash at the last position");
                    LOG.debug(str);
                    return null;
                }
                switch (str.charAt(index + 1)) {
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    default: {
                        ProcessListUtil.logErrorTestSafe("Invalid character after an escape symbol: " + str.charAt(index + 1));
                        LOG.debug(str);
                        return null;
                    }
                }
                ++index;
                continue;
            }
            builder.append(str.charAt(index));
        }
        return builder.toString();
    }

    @Nullable
    private static String removePrefix(String str, @NonNls String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        ProcessListUtil.logErrorTestSafe("Can't remove prefix \"" + prefix + "\"");
        LOG.debug(str);
        return null;
    }

    @Nullable
    static List<ProcessInfo> parseWinProcessListHelperOutput(@NotNull String output, @NotNull Map<Long, String> processOwners, @Nullable String currentUser) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(18);
        }
        if (processOwners == null) {
            ProcessListUtil.$$$reportNull$$$0(19);
        }
        String[] lines = StringUtil.splitByLines((String)output, (boolean)false);
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        if (lines.length % 4 != 0) {
            ProcessListUtil.logErrorTestSafe("Broken output of WinProcessListHelper.exe: output line count is not a multiple of 4");
            LOG.debug(output);
            return null;
        }
        int processCount = lines.length / 4;
        for (int i = 0; i < processCount; ++i) {
            String args;
            int offset = i * 4;
            String idString = ProcessListUtil.removePrefix(lines[offset], "pid:");
            int id = StringUtil.parseInt((String)idString, (int)-1);
            if (id == -1) {
                ProcessListUtil.logErrorTestSafe("Broken output of WinProcessListHelper.exe: process ID is not a number: " + lines[offset]);
                LOG.debug(output);
                return null;
            }
            if (id == 0) continue;
            String parentIdString = ProcessListUtil.removePrefix(lines[offset + 1], "parentPid:");
            int parentId = StringUtil.parseInt((String)parentIdString, (int)-1);
            if (parentId == -1) {
                ProcessListUtil.logErrorTestSafe("Broken output of WinProcessListHelper.exe: parent process ID is not a number: " + lines[offset + 1]);
                LOG.debug(output);
                return null;
            }
            String name = ProcessListUtil.unescapeString(ProcessListUtil.removePrefix(lines[offset + 2], "name:"));
            if (name == null) {
                ProcessListUtil.logErrorTestSafe("Failed to read a process name: " + lines[offset + 2]);
                LOG.debug(output);
                return null;
            }
            if (name.isEmpty()) continue;
            String commandLine = ProcessListUtil.unescapeString(ProcessListUtil.removePrefix(lines[offset + 3], "cmd:"));
            if (commandLine == null) {
                ProcessListUtil.logErrorTestSafe("Failed to read a process command line: " + lines[offset + 3]);
                LOG.debug(output);
                return null;
            }
            if (commandLine.isEmpty()) {
                commandLine = name;
                args = "";
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            String processUser = processOwners.get(id);
            ThreeState isOwnedByCurrentUser = currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(processUser)) : ThreeState.UNSURE;
            result.add(new ProcessInfo(id, commandLine, name, args, null, parentId, processUser, isOwnedByCurrentUser));
        }
        return result;
    }

    @NotNull
    private static String extractCommandLineArgs(@NotNull String fullCommandLine, @NotNull String executableName) {
        List commandLineList;
        if (fullCommandLine == null) {
            ProcessListUtil.$$$reportNull$$$0(20);
        }
        if (executableName == null) {
            ProcessListUtil.$$$reportNull$$$0(21);
        }
        if ((commandLineList = StringUtil.splitHonorQuotes((String)fullCommandLine, (char)' ')).isEmpty()) {
            return "";
        }
        String first = StringUtil.unquoteString((String)((String)commandLineList.get(0)));
        if (StringUtil.endsWithIgnoreCase((String)first, (String)executableName)) {
            List argsList = commandLineList.subList(1, commandLineList.size());
            String string = StringUtil.join(argsList, (String)" ");
            if (string == null) {
                ProcessListUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static Path findWinProcessListHelperFile() {
        try {
            return PathManager.findBinFileWithException((String)WIN_PROCESS_LIST_HELPER_FILENAME);
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsWMIC() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("wmic.exe", "path", "win32_process", "get", "Caption,Processid,ParentProcessId,Commandline,ExecutablePath"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)output -> ProcessListUtil.parseWMICOutput(output, ProcessListUtil.getProcessOwners(), ProcessListUtil.getCurrentUser())));
    }

    @Nullable
    static List<ProcessInfo> parseWMICOutput(@NotNull String output, @NotNull Map<Long, String> processOwners, @Nullable String currentUser) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(23);
        }
        if (processOwners == null) {
            ProcessListUtil.$$$reportNull$$$0(24);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int commandLineStart = header.indexOf("CommandLine");
        if (commandLineStart == -1) {
            return null;
        }
        int pidStart = header.indexOf("ProcessId");
        if (pidStart == -1) {
            return null;
        }
        int parentPidStart = header.indexOf("ParentProcessId");
        if (parentPidStart == -1) {
            return null;
        }
        int executablePathStart = header.indexOf("ExecutablePath");
        if (executablePathStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            int pid = StringUtil.parseInt((String)line.substring(pidStart).trim(), (int)-1);
            if (pid == -1 || pid == 0) continue;
            int parentPid = StringUtil.parseInt((String)line.substring(parentPidStart, pidStart).trim(), (int)-1);
            String executablePath = line.substring(executablePathStart, parentPidStart).trim();
            String name = line.substring(0, commandLineStart).trim();
            if (name.isEmpty()) continue;
            String commandLine = line.substring(commandLineStart, executablePathStart).trim();
            String args = "";
            if (commandLine.isEmpty()) {
                commandLine = name;
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            String processUser = processOwners.get(pid);
            ThreeState isOwnedByCurrentUser = currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(processUser)) : ThreeState.UNSURE;
            result.add(new ProcessInfo(pid, commandLine, name, args, executablePath, parentPid, processUser, isOwnedByCurrentUser));
        }
        return result;
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsTaskList() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("tasklist.exe", "/fo", "csv", "/nh", "/v"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)output -> ProcessListUtil.parseListTasksOutput(output, ProcessListUtil.getCurrentUser())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<ProcessInfo> parseListTasksOutput(@NotNull String output, @Nullable String currentUser) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(25);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        CSVReader reader = new CSVReader(new StringReader(output));
        try {
            while (true) {
                String[] next;
                if ((next = reader.readNext()) != null) {
                    String userName;
                    String name;
                    if (next.length < 2) {
                        List<ProcessInfo> list = null;
                        return list;
                    }
                    int pid = StringUtil.parseInt((String)next[1], (int)-1);
                    if (pid == -1 || (name = next[0]).isEmpty()) continue;
                    String string = userName = next.length > 6 ? next[6] : null;
                    if ("N/A".equals(userName)) {
                        userName = null;
                    }
                    ThreeState isOwnedByCurrentUser = currentUser != null ? ThreeState.fromBoolean((boolean)currentUser.equals(userName)) : ThreeState.UNSURE;
                    result.add(new ProcessInfo(pid, name, name, "", null, -1, userName, isOwnedByCurrentUser));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Cannot parse listtasks output", (Throwable)e);
            List<ProcessInfo> list = null;
            return list;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    @NotNull
    private static Map<Long, String> getProcessOwners() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        ProcessHandle.allProcesses().forEach(it -> {
            long pid = it.pid();
            ProcessHandle.Info info = it.info();
            String user = info.user().orElse(null);
            result.put(pid, user);
        });
        HashMap<Long, String> hashMap = result;
        if (hashMap == null) {
            ProcessListUtil.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    @Nullable
    private static String getCurrentUser() {
        return ProcessHandle.current().info().user().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/impl/ProcessListUtil";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandOnly";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "full";
                break;
            }
            case 18: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOwners";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommandLine";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetProcessList";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/impl/ProcessListUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCommandLineArgs";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOwners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandOutput";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseMacOutput";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseLinuxOutputMacStyle";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseWinProcessListHelperOutput";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractCommandLineArgs";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseWMICOutput";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseListTasksOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }

    private record MacProcessInfo(int pid, String commandLine, String user, String state, int parentPid) {
    }
}

