/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.data.GraphQLRequestPaginationKt;
import com.intellij.collaboration.api.dto.GraphQLConnectionDTO;
import com.intellij.collaboration.api.dto.GraphQLCursorPageInfoDTO;
import com.intellij.collaboration.api.dto.GraphQLNodesDTO;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.diff.util.Side;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequestsKt;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestOperation;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.data.GHComment;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.GHReaction;
import org.jetbrains.plugins.github.api.data.GHReactionContent;
import org.jetbrains.plugins.github.api.data.GHRepository;
import org.jetbrains.plugins.github.api.data.GHRepositoryPullRequestTemplate;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.commit.GHCommitStatusRollupContextDTO;
import org.jetbrains.plugins.github.api.data.commit.GHCommitStatusRollupShortDTO;
import org.jetbrains.plugins.github.api.data.graphql.query.GHGQLSearchQueryResponse;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestChangedFile;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommit;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestMergeabilityData;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReviewDTO;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewThread;
import org.jetbrains.plugins.github.api.util.GHSchemaPreview;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests;", "", "<init>", "()V", "User", "Organization", "Repo", "Comment", "PullRequest", "intellij.vcs.github"})
public final class GHGQLRequests {
    @NotNull
    public static final GHGQLRequests INSTANCE = new GHGQLRequests();

    private GHGQLRequests() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Comment;", "", "<init>", "()V", "updateComment", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/GHComment;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "commentId", "", "newText", "deleteComment", "addReaction", "Lorg/jetbrains/plugins/github/api/data/GHReaction;", "reaction", "Lorg/jetbrains/plugins/github/api/data/GHReactionContent;", "removeReaction", "intellij.vcs.github"})
    public static final class Comment {
        @NotNull
        public static final Comment INSTANCE = new Comment();

        private Comment() {
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHComment> updateComment(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"body", (Object)newText)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"updateIssueComment", "issueComment"};
            Object $this$updateComment_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHComment>(string, "graphql/query/updateIssueComment.graphql", map2, GHComment.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$updateComment_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLUpdateIssueComment);
            ((GithubApiRequest)$this$updateComment_u24lambda_u240).withOperationName("update issue comment");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Object> deleteComment(@NotNull GithubServerPath server, @NotNull String commentId) {
            GithubApiRequest.Post.GQLQuery.TraversedParsed<Object> traversedParsed;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            GithubApiRequest.Post.GQLQuery.TraversedParsed<Object> $this$deleteComment_u24lambda_u241 = traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "graphql/query/deleteIssueComment.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)commentId)), Object.class, new String[0]);
            boolean bl = false;
            $this$deleteComment_u24lambda_u241.withOperation(GithubApiRequestOperation.GraphQLDeleteIssueComment);
            $this$deleteComment_u24lambda_u241.withOperationName("delete issue comment");
            return traversedParsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHReaction> addReaction(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull GHReactionContent reaction) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            Intrinsics.checkNotNullParameter((Object)((Object)reaction), (String)"reaction");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"reaction", (Object)((Object)reaction))};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"addReaction", "reaction"};
            Object $this$addReaction_u24lambda_u242 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHReaction>(string, "graphql/query/addReaction.graphql", map2, GHReaction.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$addReaction_u24lambda_u242).withOperation(GithubApiRequestOperation.GraphQLAddReactionToComment);
            ((GithubApiRequest)$this$addReaction_u24lambda_u242).withOperationName("add reaction");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHReaction> removeReaction(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull GHReactionContent reaction) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            Intrinsics.checkNotNullParameter((Object)((Object)reaction), (String)"reaction");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"reaction", (Object)((Object)reaction))};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"removeReaction", "reaction"};
            Object $this$removeReaction_u24lambda_u243 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHReaction>(string, "graphql/query/removeReaction.graphql", map2, GHReaction.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$removeReaction_u24lambda_u243).withOperation(GithubApiRequestOperation.GraphQLRemoveReactionFromComment);
            ((GithubApiRequest)$this$removeReaction_u24lambda_u243).withOperationName("remove reaction");
            return (GithubApiRequest.Post.GQLQuery)object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization;", "", "<init>", "()V", "Team", "intellij.vcs.github"})
    public static final class Organization {
        @NotNull
        public static final Organization INSTANCE = new Organization();

        private Organization() {
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization$Team;", "", "<init>", "()V", "findAll", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lcom/intellij/collaboration/api/dto/GraphQLPagedResponseDataDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "organization", "", "pagination", "Lcom/intellij/collaboration/api/data/GraphQLRequestPagination;", "TeamsConnection", "intellij.vcs.github"})
        public static final class Team {
            @NotNull
            public static final Team INSTANCE = new Team();

            private Team() {
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHTeam>> findAll(@NotNull GithubServerPath server, @NotNull String organization, @Nullable GraphQLRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organization, (String)"organization");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[3];
                object[0] = TuplesKt.to((Object)"organization", (Object)organization);
                GraphQLRequestPagination graphQLRequestPagination = pagination;
                object[1] = TuplesKt.to((Object)"pageSize", (Object)(graphQLRequestPagination != null ? Integer.valueOf(graphQLRequestPagination.getPageSize()) : null));
                GraphQLRequestPagination graphQLRequestPagination2 = pagination;
                object[2] = TuplesKt.to((Object)"cursor", (Object)(graphQLRequestPagination2 != null ? graphQLRequestPagination2.getAfterCursor() : null));
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"organization", "teams"};
                Object $this$findAll_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<TeamsConnection>(string, "graphql/query/findOrganizationTeams.graphql", map2, TeamsConnection.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$findAll_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLGetTeamsForOrganization);
                ((GithubApiRequest)$this$findAll_u24lambda_u240).withOperationName("get teams in organization");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            public static /* synthetic */ GithubApiRequest.Post.GQLQuery findAll$default(Team team, GithubServerPath githubServerPath, String string, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    graphQLRequestPagination = null;
                }
                return team.findAll(githubServerPath, string, graphQLRequestPagination);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization$Team$TeamsConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class TeamsConnection
            extends GraphQLConnectionDTO<GHTeam> {
                public TeamsConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<GHTeam> nodes) {
                    Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(pageInfo, nodes);
                }

                public /* synthetic */ TeamsConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        list = CollectionsKt.emptyList();
                    }
                    this(graphQLCursorPageInfoDTO, list);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006012345B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJQ\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000eJ\u001e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ.\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f0\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J.\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J.\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0&0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J*\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0&0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J$\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000eJ$\u0010/\u001a\b\u0012\u0004\u0012\u00020-0\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000e\u00a8\u00066"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest;", "", "<init>", "()V", "findOneId", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "number", "", "create", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "repositoryId", "", "baseRefName", "headRefName", "title", "body", "draft", "", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "findOne", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "update", "pullRequestId", "description", "markReadyForReview", "mergeabilityData", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestMergeabilityData;", "search", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "query", "pagination", "Lcom/intellij/collaboration/api/data/GraphQLRequestPagination;", "reviewThreads", "Lcom/intellij/collaboration/api/dto/GraphQLPagedResponseDataDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "commits", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommit;", "files", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestChangedFile;", "markFileAsViewed", "", "path", "unmarkFileAsViewed", "PRSearch", "ThreadsConnection", "CommitsConnection", "FilesConnection", "Timeline", "Review", "intellij.vcs.github"})
    public static final class PullRequest {
        @NotNull
        public static final PullRequest INSTANCE = new PullRequest();

        private PullRequest() {
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPRIdentifier> findOneId(@NotNull GHRepositoryCoordinates repository, long number) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"number", (Object)number)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "pullRequest"};
            Object $this$findOneId_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPRIdentifier>(string, "graphql/query/findPullRequestId.graphql", map2, GHPRIdentifier.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$findOneId_u24lambda_u240).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$findOneId_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLGetPullRequestId);
            ((GithubApiRequest)$this$findOneId_u24lambda_u240).withOperationName("get pull request id");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequestShort> create(@NotNull GHRepositoryCoordinates repository, @NotNull String repositoryId, @NotNull String baseRefName, @NotNull String headRefName, @NotNull String title, @Nullable String body, @Nullable Boolean draft) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            Intrinsics.checkNotNullParameter((Object)baseRefName, (String)"baseRefName");
            Intrinsics.checkNotNullParameter((Object)headRefName, (String)"headRefName");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repositoryId", (Object)repositoryId), TuplesKt.to((Object)"baseRefName", (Object)baseRefName), TuplesKt.to((Object)"headRefName", (Object)headRefName), TuplesKt.to((Object)"title", (Object)title), TuplesKt.to((Object)"body", (Object)body), TuplesKt.to((Object)"draft", (Object)draft)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"createPullRequest", "pullRequest"};
            Object $this$create_u24lambda_u241 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestShort>(string, "graphql/query/createPullRequest.graphql", map2, GHPullRequestShort.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$create_u24lambda_u241).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$create_u24lambda_u241).withOperation(GithubApiRequestOperation.GraphQLCreatePullRequest);
            ((GithubApiRequest)$this$create_u24lambda_u241).withOperationName("create pull request");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery create$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, String string, String string2, String string3, String string4, String string5, Boolean bl, int n, Object object) {
            if ((n & 0x20) != 0) {
                string5 = null;
            }
            if ((n & 0x40) != 0) {
                bl = false;
            }
            return pullRequest.create(gHRepositoryCoordinates, string, string2, string3, string4, string5, bl);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequest> findOne(@NotNull GHRepositoryCoordinates repository, long number) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"number", (Object)number)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "pullRequest"};
            Object $this$findOne_u24lambda_u242 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequest>(string, "graphql/query/findPullRequest.graphql", map2, GHPullRequest.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$findOne_u24lambda_u242).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$findOne_u24lambda_u242).withOperation(GithubApiRequestOperation.GraphQLGetPullRequest);
            ((GithubApiRequest)$this$findOne_u24lambda_u242).withOperationName("get pull request");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequest> update(@NotNull GHRepositoryCoordinates repository, @NotNull String pullRequestId, @Nullable String title, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            Object object = new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)};
            Map parameters = MapsKt.mutableMapOf((Pair[])object);
            if (title != null) {
                parameters.put("title", title);
            }
            if (description != null) {
                parameters.put("body", description);
            }
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            object = new String[]{"updatePullRequest", "pullRequest"};
            Object $this$update_u24lambda_u243 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequest>(string, "graphql/query/updatePullRequest.graphql", parameters, GHPullRequest.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$update_u24lambda_u243).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$update_u24lambda_u243).withOperation(GithubApiRequestOperation.GraphQLUpdatePullRequest);
            ((GithubApiRequest)$this$update_u24lambda_u243).withOperationName("update pull request");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Object> markReadyForReview(@NotNull GHRepositoryCoordinates repository, @NotNull String pullRequestId) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)};
            Object $this$markReadyForReview_u24lambda_u244 = object = new GithubApiRequest.Post.GQLQuery.Parsed<Object>(string, "graphql/query/markPullRequestReadyForReview.graphql", MapsKt.mutableMapOf((Pair[])object), Object.class);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$markReadyForReview_u24lambda_u244).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$markReadyForReview_u24lambda_u244).withOperation(GithubApiRequestOperation.GraphQLMarkPullRequestReadyForReview);
            ((GithubApiRequest)$this$markReadyForReview_u24lambda_u244).withOperationName("mark pull request ready for review");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequestMergeabilityData> mergeabilityData(@NotNull GHRepositoryCoordinates repository, long number) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"number", (Object)number)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "pullRequest"};
            Object $this$mergeabilityData_u24lambda_u245 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequestMergeabilityData>(string, "graphql/query/findPullRequestMergeability.graphql", map2, GHPullRequestMergeabilityData.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$mergeabilityData_u24lambda_u245).setAcceptMimeType(GHSchemaPreview.CHECKS.getMimeType() + "," + GHSchemaPreview.PR_MERGE_INFO.getMimeType());
            ((GithubApiRequest)$this$mergeabilityData_u24lambda_u245).withOperation(GithubApiRequestOperation.GraphQLGetMergeabilityData);
            ((GithubApiRequest)$this$mergeabilityData_u24lambda_u245).withOperationName("get mergeability data");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLSearchQueryResponse<GHPullRequestShort>> search(@NotNull GithubServerPath server, @NotNull String query, @Nullable GraphQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[3];
            object[0] = TuplesKt.to((Object)"query", (Object)query);
            GraphQLRequestPagination graphQLRequestPagination = pagination;
            object[1] = TuplesKt.to((Object)"pageSize", (Object)(graphQLRequestPagination != null ? Integer.valueOf(graphQLRequestPagination.getPageSize()) : null));
            GraphQLRequestPagination graphQLRequestPagination2 = pagination;
            object[2] = TuplesKt.to((Object)"cursor", (Object)(graphQLRequestPagination2 != null ? graphQLRequestPagination2.getAfterCursor() : null));
            Object $this$search_u24lambda_u246 = object = new GithubApiRequest.Post.GQLQuery.Parsed<PRSearch>(string, "graphql/query/issueSearch.graphql", MapsKt.mapOf((Pair[])object), PRSearch.class);
            boolean bl = false;
            ((GithubApiRequest.Post)$this$search_u24lambda_u246).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            ((GithubApiRequest)$this$search_u24lambda_u246).withOperation(GithubApiRequestOperation.GraphQLSearchPullRequests);
            ((GithubApiRequest)$this$search_u24lambda_u246).withOperationName("search issues");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery search$default(PullRequest pullRequest, GithubServerPath githubServerPath, String string, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                graphQLRequestPagination = null;
            }
            return pullRequest.search(githubServerPath, string, graphQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHPullRequestReviewThread>> reviewThreads(@NotNull GHRepositoryCoordinates repository, long number, @Nullable GraphQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new String[]{"repository", "pullRequest", "reviewThreads"};
            Object $this$reviewThreads_u24lambda_u247 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<ThreadsConnection>(string, "graphql/query/pullRequestReviewThreads.graphql", GHGQLRequestsKt.access$parameters(repository, number, pagination), ThreadsConnection.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$reviewThreads_u24lambda_u247).withOperation(GithubApiRequestOperation.GraphQLGetReviewThreads);
            ((GithubApiRequest)$this$reviewThreads_u24lambda_u247).withOperationName("get review threads");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery reviewThreads$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, long l, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                graphQLRequestPagination = null;
            }
            return pullRequest.reviewThreads(gHRepositoryCoordinates, l, graphQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHPullRequestCommit>> commits(@NotNull GHRepositoryCoordinates repository, long number, @Nullable GraphQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new String[]{"repository", "pullRequest", "commits"};
            Object $this$commits_u24lambda_u248 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<CommitsConnection>(string, "graphql/query/pullRequestCommits.graphql", GHGQLRequestsKt.access$parameters(repository, number, pagination), CommitsConnection.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$commits_u24lambda_u248).withOperation(GithubApiRequestOperation.GraphQLGetPullRequestCommits);
            ((GithubApiRequest)$this$commits_u24lambda_u248).withOperationName("get pull request commits");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery commits$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, long l, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                graphQLRequestPagination = null;
            }
            return pullRequest.commits(gHRepositoryCoordinates, l, graphQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHPullRequestChangedFile>> files(@NotNull GHRepositoryCoordinates repository, long number, @NotNull GraphQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new String[]{"repository", "pullRequest", "files"};
            Object $this$files_u24lambda_u249 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<FilesConnection>(string, "graphql/query/pullRequestFiles.graphql", GHGQLRequestsKt.access$parameters(repository, number, pagination), FilesConnection.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$files_u24lambda_u249).withOperation(GithubApiRequestOperation.GraphQLGetPullRequestFiles);
            ((GithubApiRequest)$this$files_u24lambda_u249).withOperationName("get pull request files");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Unit> markFileAsViewed(@NotNull GithubServerPath server, @NotNull String pullRequestId, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId), TuplesKt.to((Object)"path", (Object)path)};
            Object $this$markFileAsViewed_u24lambda_u2410 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<Unit>(string, "graphql/query/markFileAsViewed.graphql", MapsKt.mapOf((Pair[])object), Unit.class, new String[0]);
            boolean bl = false;
            ((GithubApiRequest)$this$markFileAsViewed_u24lambda_u2410).withOperation(GithubApiRequestOperation.GraphQLMarkFileAsViewed);
            ((GithubApiRequest)$this$markFileAsViewed_u24lambda_u2410).withOperationName("mark file as viewed");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Unit> unmarkFileAsViewed(@NotNull GithubServerPath server, @NotNull String pullRequestId, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId), TuplesKt.to((Object)"path", (Object)path)};
            Object $this$unmarkFileAsViewed_u24lambda_u2411 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<Unit>(string, "graphql/query/unmarkFileAsViewed.graphql", MapsKt.mapOf((Pair[])object), Unit.class, new String[0]);
            boolean bl = false;
            ((GithubApiRequest)$this$unmarkFileAsViewed_u24lambda_u2411).withOperation(GithubApiRequestOperation.GraphQLUnmarkFileAsViewed);
            ((GithubApiRequest)$this$unmarkFileAsViewed_u24lambda_u2411).withOperationName("unmark file as viewed");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$CommitsConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommit;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class CommitsConnection
        extends GraphQLConnectionDTO<GHPullRequestCommit> {
            public CommitsConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<GHPullRequestCommit> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }

            public /* synthetic */ CommitsConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(graphQLCursorPageInfoDTO, list);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$FilesConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestChangedFile;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class FilesConnection
        extends GraphQLConnectionDTO<GHPullRequestChangedFile> {
            public FilesConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<GHPullRequestChangedFile> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }

            public /* synthetic */ FilesConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(graphQLCursorPageInfoDTO, list);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$PRSearch;", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "search", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse$SearchConnection;", "<init>", "(Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse$SearchConnection;)V", "intellij.vcs.github"})
        private static final class PRSearch
        extends GHGQLSearchQueryResponse<GHPullRequestShort> {
            public PRSearch(@NotNull GHGQLSearchQueryResponse.SearchConnection<GHPullRequestShort> search) {
                Intrinsics.checkNotNullParameter(search, (String)"search");
                super(search);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nJ\"\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00190\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ<\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\nJ$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJD\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\nJ\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020$0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010*\u001a\u00020\nJ\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020$0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010*\u001a\u00020\n\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Review;", "", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReviewDTO;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "pullRequestId", "", "event", "Lorg/jetbrains/plugins/github/api/data/GHPullRequestReviewEvent;", "body", "commitSha", "threads", "", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewThread;", "submit", "reviewId", "updateBody", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "newText", "delete", "pendingReviews", "Lcom/intellij/collaboration/api/dto/GraphQLNodesDTO;", "addComment", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewComment;", "fileName", "diffLine", "", "inReplyTo", "deleteComment", "commentId", "updateComment", "addThread", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "line", "side", "Lcom/intellij/diff/util/Side;", "startLine", "resolveThread", "threadId", "unresolveThread", "PendingReviewNodes", "intellij.vcs.github"})
        public static final class Review {
            @NotNull
            public static final Review INSTANCE = new Review();

            private Review() {
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestPendingReviewDTO> create(@NotNull GithubServerPath server, @NotNull String pullRequestId, @Nullable GHPullRequestReviewEvent event, @Nullable String body, @Nullable String commitSha, @Nullable List<GHPullRequestDraftReviewThread> threads) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId), TuplesKt.to((Object)"event", (Object)((Object)event)), TuplesKt.to((Object)"commitOid", (Object)commitSha), TuplesKt.to((Object)"threads", threads), TuplesKt.to((Object)"body", (Object)body)};
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"addPullRequestReview", "pullRequestReview"};
                Object $this$create_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestPendingReviewDTO>(string, "graphql/query/createReview.graphql", map2, GHPullRequestPendingReviewDTO.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$create_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLCreateReview);
                ((GithubApiRequest)$this$create_u24lambda_u240).withOperationName("create review");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<Object> submit(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull GHPullRequestReviewEvent event, @Nullable String body) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"event", (Object)((Object)event)), TuplesKt.to((Object)"body", (Object)body)};
                Object $this$submit_u24lambda_u241 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "graphql/query/submitReview.graphql", MapsKt.mapOf((Pair[])object), Object.class, new String[0]);
                boolean bl = false;
                ((GithubApiRequest)$this$submit_u24lambda_u241).withOperation(GithubApiRequestOperation.GraphQLSubmitReview);
                ((GithubApiRequest)$this$submit_u24lambda_u241).withOperationName("submit review");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReview> updateBody(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"body", (Object)newText)};
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"updatePullRequestReview", "pullRequestReview"};
                Object $this$updateBody_u24lambda_u242 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReview>(string, "graphql/query/updateReview.graphql", map2, GHPullRequestReview.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$updateBody_u24lambda_u242).withOperation(GithubApiRequestOperation.GraphQLUpdateReview);
                ((GithubApiRequest)$this$updateBody_u24lambda_u242).withOperationName("update review");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<Object> delete(@NotNull GithubServerPath server, @NotNull String reviewId) {
                GithubApiRequest.Post.GQLQuery.TraversedParsed<Object> traversedParsed;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                GithubApiRequest.Post.GQLQuery.TraversedParsed<Object> $this$delete_u24lambda_u243 = traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "graphql/query/deleteReview.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"reviewId", (Object)reviewId)), Object.class, new String[0]);
                boolean bl = false;
                $this$delete_u24lambda_u243.withOperation(GithubApiRequestOperation.GraphQLDeleteReview);
                $this$delete_u24lambda_u243.withOperationName("delete review");
                return traversedParsed;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GraphQLNodesDTO<GHPullRequestPendingReviewDTO>> pendingReviews(@NotNull GithubServerPath server, @NotNull String pullRequestId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new String[]{"node", "reviews"};
                Object $this$pendingReviews_u24lambda_u244 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<PendingReviewNodes>(string, "graphql/query/findPendingReview.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)), PendingReviewNodes.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$pendingReviews_u24lambda_u244).withOperation(GithubApiRequestOperation.GraphQLGetPendingReviews);
                ((GithubApiRequest)$this$pendingReviews_u24lambda_u244).withOperationName("get pending reviews");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewComment> addComment(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String body, @NotNull String commitSha, @NotNull String fileName, int diffLine) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"body", (Object)body), TuplesKt.to((Object)"commit", (Object)commitSha), TuplesKt.to((Object)"file", (Object)fileName), TuplesKt.to((Object)"position", (Object)diffLine)};
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"addPullRequestReviewComment", "comment"};
                Object $this$addComment_u24lambda_u245 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewComment>(string, "graphql/query/addReviewComment.graphql", map2, GHPullRequestReviewComment.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$addComment_u24lambda_u245).withOperation(GithubApiRequestOperation.GraphQLCreateReviewCommentOnLine);
                ((GithubApiRequest)$this$addComment_u24lambda_u245).withOperationName("create review comment on line");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewComment> addComment(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String inReplyTo, @NotNull String body) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)inReplyTo, (String)"inReplyTo");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"inReplyTo", (Object)inReplyTo), TuplesKt.to((Object)"body", (Object)body)};
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"addPullRequestReviewComment", "comment"};
                Object $this$addComment_u24lambda_u246 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewComment>(string, "graphql/query/addReviewComment.graphql", map2, GHPullRequestReviewComment.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$addComment_u24lambda_u246).withOperation(GithubApiRequestOperation.GraphQLCreateReviewComment);
                ((GithubApiRequest)$this$addComment_u24lambda_u246).withOperationName("create review comment");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestPendingReviewDTO> deleteComment(@NotNull GithubServerPath server, @NotNull String commentId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new String[]{"deletePullRequestReviewComment", "pullRequestReview"};
                Object $this$deleteComment_u24lambda_u247 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestPendingReviewDTO>(string, "graphql/query/deleteReviewComment.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)commentId)), GHPullRequestPendingReviewDTO.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$deleteComment_u24lambda_u247).withOperation(GithubApiRequestOperation.GraphQLDeleteReviewComment);
                ((GithubApiRequest)$this$deleteComment_u24lambda_u247).withOperationName("delete review comment");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewComment> updateComment(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"body", (Object)newText)};
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"updatePullRequestReviewComment", "pullRequestReviewComment"};
                Object $this$updateComment_u24lambda_u248 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewComment>(string, "graphql/query/updateReviewComment.graphql", map2, GHPullRequestReviewComment.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$updateComment_u24lambda_u248).withOperation(GithubApiRequestOperation.GraphQLUpdateReviewComment);
                ((GithubApiRequest)$this$updateComment_u24lambda_u248).withOperationName("update review comment");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> addThread(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String body, int line, @NotNull Side side, int startLine, @NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)side, (String)"side");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Object object = new Pair[]{TuplesKt.to((Object)"pullRequestReviewId", (Object)reviewId), TuplesKt.to((Object)"path", (Object)fileName), TuplesKt.to((Object)"side", (Object)side.name()), TuplesKt.to((Object)"line", (Object)line), TuplesKt.to((Object)"body", (Object)body)};
                Map params = MapsKt.mutableMapOf((Pair[])object);
                if (startLine != line) {
                    params.put("startSide", side.name());
                    Integer n = startLine;
                    params.put("startLine", n);
                }
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                object = new String[]{"addPullRequestReviewThread", "thread"};
                Object $this$addThread_u24lambda_u249 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "graphql/query/addPullRequestReviewThread.graphql", params, GHPullRequestReviewThread.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$addThread_u24lambda_u249).withOperation(GithubApiRequestOperation.GraphQLCreateReviewThread);
                ((GithubApiRequest)$this$addThread_u24lambda_u249).withOperationName("create review thread on line");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> resolveThread(@NotNull GithubServerPath server, @NotNull String threadId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new String[]{"resolveReviewThread", "thread"};
                Object $this$resolveThread_u24lambda_u2410 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "graphql/query/resolveReviewThread.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"threadId", (Object)threadId)), GHPullRequestReviewThread.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$resolveThread_u24lambda_u2410).withOperation(GithubApiRequestOperation.GraphQLResolveReviewThread);
                ((GithubApiRequest)$this$resolveThread_u24lambda_u2410).withOperationName("resolve review thread");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> unresolveThread(@NotNull GithubServerPath server, @NotNull String threadId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new String[]{"unresolveReviewThread", "thread"};
                Object $this$unresolveThread_u24lambda_u2411 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "graphql/query/unresolveReviewThread.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"threadId", (Object)threadId)), GHPullRequestReviewThread.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest)$this$unresolveThread_u24lambda_u2411).withOperation(GithubApiRequestOperation.GraphQLUnresolveReviewThread);
                ((GithubApiRequest)$this$unresolveThread_u24lambda_u2411).withOperationName("unresolve review thread");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Review$PendingReviewNodes;", "Lcom/intellij/collaboration/api/dto/GraphQLNodesDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReviewDTO;", "nodes", "", "<init>", "(Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class PendingReviewNodes
            extends GraphQLNodesDTO<GHPullRequestPendingReviewDTO> {
                public PendingReviewNodes(@NotNull List<GHPullRequestPendingReviewDTO> nodes) {
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(nodes);
                }

                public /* synthetic */ PendingReviewNodes(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        list = CollectionsKt.emptyList();
                    }
                    this(list);
                }

                public PendingReviewNodes() {
                    this(null, 1, null);
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$ThreadsConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class ThreadsConnection
        extends GraphQLConnectionDTO<GHPullRequestReviewThread> {
            public ThreadsConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<GHPullRequestReviewThread> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }

            public /* synthetic */ ThreadsConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(graphQLCursorPageInfoDTO, list);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Timeline;", "", "<init>", "()V", "items", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lcom/intellij/collaboration/api/dto/GraphQLPagedResponseDataDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoOwner", "", "repoName", "number", "", "pagination", "Lcom/intellij/collaboration/api/data/GraphQLRequestPagination;", "TimelineConnection", "intellij.vcs.github"})
        public static final class Timeline {
            @NotNull
            public static final Timeline INSTANCE = new Timeline();

            private Timeline() {
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHPRTimelineItem>> items(@NotNull GithubServerPath server, @NotNull String repoOwner, @NotNull String repoName, long number, @Nullable GraphQLRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoOwner, (String)"repoOwner");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
                Object object = new Pair[6];
                object[0] = TuplesKt.to((Object)"repoOwner", (Object)repoOwner);
                object[1] = TuplesKt.to((Object)"repoName", (Object)repoName);
                object[2] = TuplesKt.to((Object)"number", (Object)number);
                GraphQLRequestPagination graphQLRequestPagination = pagination;
                object[3] = TuplesKt.to((Object)"pageSize", (Object)(graphQLRequestPagination != null ? Integer.valueOf(graphQLRequestPagination.getPageSize()) : null));
                GraphQLRequestPagination graphQLRequestPagination2 = pagination;
                object[4] = TuplesKt.to((Object)"cursor", (Object)(graphQLRequestPagination2 != null ? graphQLRequestPagination2.getAfterCursor() : null));
                GraphQLRequestPagination graphQLRequestPagination3 = pagination;
                object[5] = TuplesKt.to((Object)"since", (Object)(graphQLRequestPagination3 != null ? graphQLRequestPagination3.getSince() : null));
                Map map2 = MapsKt.mapOf((Pair[])object);
                object = new String[]{"repository", "pullRequest", "timelineItems"};
                Object $this$items_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<TimelineConnection>(string, "graphql/query/pullRequestTimeline.graphql", map2, TimelineConnection.class, (String[])object);
                boolean bl = false;
                ((GithubApiRequest.Post)$this$items_u24lambda_u240).setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
                ((GithubApiRequest)$this$items_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLGetPullRequestTimelineItems);
                ((GithubApiRequest)$this$items_u24lambda_u240).withOperationName("get pull request timeline items");
                return (GithubApiRequest.Post.GQLQuery)object;
            }

            public static /* synthetic */ GithubApiRequest.Post.GQLQuery items$default(Timeline timeline, GithubServerPath githubServerPath, String string, String string2, long l, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
                if ((n & 0x10) != 0) {
                    graphQLRequestPagination = null;
                }
                return timeline.items(githubServerPath, string, string2, l, graphQLRequestPagination);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Timeline$TimelineConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class TimelineConnection
            extends GraphQLConnectionDTO<GHPRTimelineItem> {
                public TimelineConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<? extends GHPRTimelineItem> nodes) {
                    Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(pageInfo, nodes);
                }

                public /* synthetic */ TimelineConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        list = CollectionsKt.emptyList();
                    }
                    this(graphQLCursorPageInfoDTO, list);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\u00052\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00052\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00170\u00052\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Repo;", "", "<init>", "()V", "find", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/GHRepository;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "loadPullRequestTemplates", "", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPullRequestTemplate;", "getProtectionRules", "Lcom/intellij/collaboration/api/dto/GraphQLPagedResponseDataDTO;", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRule;", "pagination", "Lcom/intellij/collaboration/api/data/GraphQLRequestPagination;", "getCommitStatus", "Lorg/jetbrains/plugins/github/api/data/commit/GHCommitStatusRollupShortDTO;", "repo", "commitHash", "", "getCommitStatusContext", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/commit/GHCommitStatusRollupContextDTO;", "pageData", "ProtectedRulesConnection", "ContextsConnection", "intellij.vcs.github"})
    public static final class Repo {
        @NotNull
        public static final Repo INSTANCE = new Repo();

        private Repo() {
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHRepository> find(@NotNull GHRepositoryCoordinates repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository())};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository"};
            Object $this$find_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHRepository>(string, "graphql/query/findRepository.graphql", map2, GHRepository.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$find_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLGetRepository);
            ((GithubApiRequest)$this$find_u24lambda_u240).withOperationName("get repository");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<List<GHRepositoryPullRequestTemplate>> loadPullRequestTemplates(@NotNull GHRepositoryCoordinates repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository())};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "pullRequestTemplates"};
            Object $this$loadPullRequestTemplates_u24lambda_u241 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsedList<GHRepositoryPullRequestTemplate>(string, "graphql/query/getPullRequestTemplates.graphql", map2, GHRepositoryPullRequestTemplate.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$loadPullRequestTemplates_u24lambda_u241).withOperation(GithubApiRequestOperation.GraphQLGetPullRequestTemplates);
            ((GithubApiRequest)$this$loadPullRequestTemplates_u24lambda_u241).withOperationName("get pull request templates");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GraphQLPagedResponseDataDTO<GHBranchProtectionRule>> getProtectionRules(@NotNull GHRepositoryCoordinates repository, @Nullable GraphQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[4];
            object[0] = TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner());
            object[1] = TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository());
            GraphQLRequestPagination graphQLRequestPagination = pagination;
            object[2] = TuplesKt.to((Object)"pageSize", (Object)(graphQLRequestPagination != null ? Integer.valueOf(graphQLRequestPagination.getPageSize()) : null));
            GraphQLRequestPagination graphQLRequestPagination2 = pagination;
            object[3] = TuplesKt.to((Object)"cursor", (Object)(graphQLRequestPagination2 != null ? graphQLRequestPagination2.getAfterCursor() : null));
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "branchProtectionRules"};
            Object $this$getProtectionRules_u24lambda_u242 = object = new GithubApiRequest.Post.GQLQuery.TraversedParsed<ProtectedRulesConnection>(string, "graphql/query/getProtectionRules.graphql", map2, ProtectedRulesConnection.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$getProtectionRules_u24lambda_u242).withOperation(GithubApiRequestOperation.GraphQLGetBranchProtectionRules);
            ((GithubApiRequest)$this$getProtectionRules_u24lambda_u242).withOperationName("get branch protection rules");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery getProtectionRules$default(Repo repo, GHRepositoryCoordinates gHRepositoryCoordinates, GraphQLRequestPagination graphQLRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                graphQLRequestPagination = null;
            }
            return repo.getProtectionRules(gHRepositoryCoordinates, graphQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHCommitStatusRollupShortDTO> getCommitStatus(@NotNull GHRepositoryCoordinates repo, @NotNull String commitHash) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            String string = repo.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repo.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repo.getRepositoryPath().getRepository()), TuplesKt.to((Object)"oid", (Object)commitHash)};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = new String[]{"repository", "object", "statusCheckRollup"};
            Object $this$getCommitStatus_u24lambda_u243 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHCommitStatusRollupShortDTO>(string, "graphql/query/getRepositoryCommitStatusShort.graphql", map2, GHCommitStatusRollupShortDTO.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$getCommitStatus_u24lambda_u243).withOperation(GithubApiRequestOperation.GraphQLGetCommitStatuses);
            ((GithubApiRequest)$this$getCommitStatus_u24lambda_u243).withOperationName("get commit statuses");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GraphQLConnectionDTO<GHCommitStatusRollupContextDTO>> getCommitStatusContext(@NotNull GHRepositoryCoordinates repo, @NotNull String commitHash, @NotNull GraphQLRequestPagination pageData) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)pageData, (String)"pageData");
            String string = repo.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repo.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repo.getRepositoryPath().getRepository()), TuplesKt.to((Object)"oid", (Object)commitHash)};
            Map map2 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])object), (Map)GraphQLRequestPaginationKt.asParameters((GraphQLRequestPagination)pageData));
            object = new String[]{"repository", "object", "statusCheckRollup", "contexts"};
            Object $this$getCommitStatusContext_u24lambda_u244 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<ContextsConnection>(string, "graphql/query/getRepositoryCommitStatusContexts.graphql", map2, ContextsConnection.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$getCommitStatusContext_u24lambda_u244).withOperation(GithubApiRequestOperation.GraphQLGetCommitStatusContexts);
            ((GithubApiRequest)$this$getCommitStatusContext_u24lambda_u244).withOperationName("get commit status contexts");
            return (GithubApiRequest.Post.GQLQuery)object;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Repo$ContextsConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/commit/GHCommitStatusRollupContextDTO;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class ContextsConnection
        extends GraphQLConnectionDTO<GHCommitStatusRollupContextDTO> {
            public ContextsConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<? extends GHCommitStatusRollupContextDTO> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }

            public /* synthetic */ ContextsConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(graphQLCursorPageInfoDTO, list);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Repo$ProtectedRulesConnection;", "Lcom/intellij/collaboration/api/dto/GraphQLConnectionDTO;", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRule;", "pageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "nodes", "", "<init>", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class ProtectedRulesConnection
        extends GraphQLConnectionDTO<GHBranchProtectionRule> {
            public ProtectedRulesConnection(@NotNull GraphQLCursorPageInfoDTO pageInfo, @NotNull List<GHBranchProtectionRule> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }

            public /* synthetic */ ProtectedRulesConnection(GraphQLCursorPageInfoDTO graphQLCursorPageInfoDTO, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(graphQLCursorPageInfoDTO, list);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$User;", "", "<init>", "()V", "find", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "login", "", "intellij.vcs.github"})
    public static final class User {
        @NotNull
        public static final User INSTANCE = new User();

        private User() {
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHUser> find(@NotNull GithubServerPath server, @NotNull String login2) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toGraphQLUrl(...)");
            Object object = new String[]{"user"};
            Object $this$find_u24lambda_u240 = object = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHUser>(string, "graphql/query/findUser.graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"login", (Object)login2)), GHUser.class, (String[])object);
            boolean bl = false;
            ((GithubApiRequest)$this$find_u24lambda_u240).withOperation(GithubApiRequestOperation.GraphQLGetUser);
            ((GithubApiRequest)$this$find_u24lambda_u240).withOperationName("get user");
            return (GithubApiRequest.Post.GQLQuery)object;
        }
    }
}

