/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringUiService;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQuotesUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInlineLocalHandler
extends InlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)PyInlineLocalHandler.class.getName());
    private static final Pair<PyStatement, Boolean> EMPTY_DEF_RESULT = Pair.create(null, (Object)false);
    private static final String HELP_ID = "refactoring.inlineVariable";

    public static PyInlineLocalHandler getInstance() {
        return (PyInlineLocalHandler)((Object)InlineActionHandler.EP_NAME.findExtensionOrFail(PyInlineLocalHandler.class));
    }

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof PythonLanguage;
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PyTargetExpression;
    }

    public void inlineElement(Project project, Editor editor2, PsiElement element) {
        PsiElement refElement;
        if (editor2 == null) {
            return;
        }
        PsiReference psiReference = TargetElementUtilBase.findReferenceWithoutExpectedCaret((Editor)editor2);
        PyReferenceExpression refExpr = null;
        if (psiReference != null && (refElement = psiReference.getElement()) instanceof PyReferenceExpression) {
            refExpr = (PyReferenceExpression)refElement;
        }
        PyInlineLocalHandler.invoke(project, editor2, (PyTargetExpression)element, refExpr, false);
    }

    private static boolean stringContentCanBeInlinedIntoFString(@NotNull PyStringElement inlinedStringElement, @NotNull PyFormattedStringElement targetFString) {
        if (inlinedStringElement == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(0);
        }
        if (targetFString == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(1);
        }
        if (LanguageLevel.forElement((PsiElement)targetFString).isAtLeast(LanguageLevel.PYTHON312)) {
            return true;
        }
        String content2 = inlinedStringElement.getContent();
        if (targetFString.isTripleQuoted()) {
            return !content2.contains("\\");
        }
        return !content2.contains("'") && !content2.contains("\"") && !content2.contains("\\");
    }

    @NotNull
    private static List<PyStringElement> getStringElements(@NotNull PyExpression expression) {
        if (expression == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(2);
        }
        ArrayList<PyStringElement> result2 = new ArrayList<PyStringElement>();
        for (PyStringLiteralExpression stringLiteralExpr : PsiTreeUtil.findChildrenOfAnyType((PsiElement)expression, (boolean)false, (Class[])new Class[]{PyStringLiteralExpression.class})) {
            result2.addAll(stringLiteralExpr.getStringElements());
        }
        ArrayList<PyStringElement> arrayList = result2;
        if (arrayList == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static PyExpression replaceQuotesInExpression(@NotNull PyExpression expression, char desiredQuote) {
        if (expression == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(4);
        }
        PyExpression expressionCopy = (PyExpression)expression.copy();
        List<PyStringElement> valueStringElements = PyInlineLocalHandler.getStringElements(expressionCopy);
        for (PyStringElement valueStringElement : valueStringElements) {
            char actualQuote = valueStringElement.getQuote().charAt(0);
            PyStringElement elementToReplace = valueStringElement;
            if (actualQuote != desiredQuote) {
                elementToReplace = PyQuotesUtil.createCopyWithConvertedQuotes(valueStringElement);
            }
            valueStringElement.replace(elementToReplace);
        }
        PyExpression pyExpression = expressionCopy;
        if (pyExpression == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(5);
        }
        return pyExpression;
    }

    private static boolean checkPossibleInlineElement(@NotNull PsiElement element, @NotNull PyExpression value, @NotNull Project project, @NotNull Editor editor2, @NotNull Map<PsiElement, PsiElement> simpleReplacements, @NotNull Map<PyFStringFragment, PyStringElement> fStringFragmentsReplacements) {
        Object fStringFragment;
        PsiElement psiElement;
        boolean entireValueIsSingleNonInterpolatedString;
        PyFormattedStringElement targetFString;
        if (element == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(6);
        }
        if (value == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(9);
        }
        if (simpleReplacements == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(10);
        }
        if (fStringFragmentsReplacements == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(11);
        }
        if ((targetFString = (PyFormattedStringElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFormattedStringElement.class, (boolean)true, (Class[])new Class[]{PyStatement.class})) == null) {
            simpleReplacements.put(element, (PsiElement)value);
            return true;
        }
        boolean fStringCanContainArbitraryStrings = LanguageLevel.forElement((PsiElement)element).isAtLeast(LanguageLevel.PYTHON312);
        if (!fStringCanContainArbitraryStrings && !targetFString.isTripleQuoted() && value.textContains('\n')) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyPsiBundle.message("refactoring.inline.can.not.multiline.string.to.f.string", new Object[0]), (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        boolean intoNestedFString = PsiTreeUtil.getParentOfType((PsiElement)targetFString, PyFormattedStringElement.class, (boolean)true, (Class[])new Class[]{PyStatement.class}) != null;
        List<PyStringElement> valueStringElements = PyInlineLocalHandler.getStringElements(value);
        boolean bl = entireValueIsSingleNonInterpolatedString = value instanceof PyStringLiteralExpression && valueStringElements.size() == 1;
        if (entireValueIsSingleNonInterpolatedString && (psiElement = element.getParent()) instanceof PyFStringFragment && (fStringFragment = (PyFStringFragment)psiElement).getTypeConversion() == null && fStringFragment.getFormatPart() == null && (!value.textContains('\n') || targetFString.isTripleQuoted())) {
            if (intoNestedFString && !PyInlineLocalHandler.stringContentCanBeInlinedIntoFString(valueStringElements.get(0), targetFString)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyPsiBundle.message("refactoring.inline.can.not.string.with.backslashes.or.quotes.to.f.string", new Object[0]), (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
                return false;
            }
            PyExpression valueReplacedQuotes = PyInlineLocalHandler.replaceQuotesInExpression(value, targetFString.getQuote().charAt(0));
            List<PyStringElement> stringElements = PyInlineLocalHandler.getStringElements(valueReplacedQuotes);
            if (stringElements.size() == 1) {
                fStringFragmentsReplacements.put((PyFStringFragment)fStringFragment, stringElements.get(0));
                return true;
            }
        }
        if (!fStringCanContainArbitraryStrings && intoNestedFString) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyPsiBundle.message("refactoring.inline.can.not.string.to.nested.f.string", new Object[0]), (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        for (PyStringElement valueStringElement : valueStringElements) {
            if (PyInlineLocalHandler.stringContentCanBeInlinedIntoFString(valueStringElement, targetFString)) continue;
            String message = PyPsiBundle.message("refactoring.inline.can.not.string.with.backslashes.or.quotes.to.f.string", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return false;
        }
        char newQuote = PyStringLiteralUtil.flipQuote((char)targetFString.getQuote().charAt(0));
        Object quoteSafeValue = fStringCanContainArbitraryStrings ? value.copy() : PyInlineLocalHandler.replaceQuotesInExpression(value, newQuote);
        simpleReplacements.put(element, (PsiElement)quoteSafeValue);
        return true;
    }

    private static void makeFStringFragmentsReplacements(@NotNull Map<PyFStringFragment, PyStringElement> fStringFragmentsReplacements) {
        if (fStringFragmentsReplacements == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(12);
        }
        MultiMap fString2Replacements = new MultiMap();
        for (Map.Entry<PyFStringFragment, PyStringElement> entry : fStringFragmentsReplacements.entrySet()) {
            PyFStringFragment fStringFragment = entry.getKey();
            PyFormattedStringElement fString = (PyFormattedStringElement)fStringFragment.getParent();
            String valueProperQuotes = entry.getValue().getContent();
            fString2Replacements.putValue((Object)fString, (Object)Pair.create((Object)fStringFragment, (Object)valueProperQuotes));
        }
        ArrayList<PyFormattedStringElement> fStrings = new ArrayList<PyFormattedStringElement>(fString2Replacements.keySet());
        fStrings.sort(Comparator.comparingInt(it -> -it.getTextOffset()));
        for (PyFormattedStringElement fString : fStrings) {
            Collection replacements = fString2Replacements.get((Object)fString);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(fString.getProject());
            List replacementsSegments = ContainerUtil.sorted((Collection)ContainerUtil.map((Collection)replacements, it -> Pair.create((Object)((PyFStringFragment)it.first).getTextRangeInParent(), (Object)((String)it.second))), Comparator.comparingInt(it -> -((TextRange)it.first).getStartOffset()));
            StringBuilder elementStringBuilder = new StringBuilder(fString.getText());
            for (Pair segment : replacementsSegments) {
                elementStringBuilder.replace(((TextRange)segment.first).getStartOffset(), ((TextRange)segment.first).getEndOffset(), (String)segment.second);
            }
            String resultString = elementStringBuilder.toString();
            PyStringElement elementToReplace = (PyStringElement)elementGenerator.createStringLiteralAlreadyEscaped(resultString).getFirstChild();
            fString.replace(elementToReplace);
        }
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PyTargetExpression local, @Nullable PyReferenceExpression refExpr, boolean replaceJustOneOccurrence) {
        if (project == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(14);
        }
        if (local == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(15);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        ScopeOwner containerBlock = PyInlineLocalHandler.getContext(local);
        LOG.assertTrue(containerBlock != null);
        Pair<PyStatement, Boolean> defPair = PyInlineLocalHandler.getAssignmentToInline(containerBlock, refExpr, local, project);
        PyStatement def = (PyStatement)defPair.first;
        if (def == null || PyInlineLocalHandler.getValue(def) == null) {
            String key = (Boolean)defPair.second != false ? "variable.has.no.dominating.definition" : "variable.has.no.initializer";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (def instanceof PyAssignmentStatement && ((PyAssignmentStatement)def).getTargets().length > 1) {
            highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{def}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)PyPsiBundle.message("refactoring.inline.local.multiassignment", localName));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        PsiElement[] refsToInline = replaceJustOneOccurrence && refExpr != null ? new PsiElement[]{refExpr} : PyDefUseUtil.getPostRefs(containerBlock, local, PyInlineLocalHandler.getObject(def));
        if (refsToInline.length == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor2, refsToInline, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            int occurrencesCount = refsToInline.length;
            String occurrencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrencesCount});
            String question = RefactoringBundle.message((String)"inline.local.variable.prompt", (Object[])new Object[]{localName}) + " " + occurrencesString;
            boolean result2 = RefactoringUiService.getInstance().showRefactoringMessageDialog(PyInlineLocalHandler.getRefactoringName(), question, HELP_ID, "OptionPane.questionIcon", true, project);
            if (!result2) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                return;
            }
        }
        PsiFile workingFile = local.getContainingFile();
        for (PsiElement ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (otherFile.equals(workingFile)) continue;
            String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        for (PsiElement ref : refsToInline) {
            ArrayList<PsiElement> elems = new ArrayList<PsiElement>();
            List<Instruction> latestDefs = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), ref, false, false, TypeEvalContext.codeInsightFallback(project));
            for (Instruction i : latestDefs) {
                elems.add(i.getElement());
            }
            PsiElement[] defs = elems.toArray(PsiElement.EMPTY_ARRAY);
            boolean isSameDefinition = true;
            for (PsiElement otherDef : defs) {
                isSameDefinition &= PyInlineLocalHandler.isSameDefinition(def, otherDef);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor2, defs, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{ref}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)PyInlineLocalHandler.getRefactoringName(), (String)HELP_ID);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PsiElement parent;
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)local);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyInlineLocalHandler.getRefactoringId(), afterData);
                ArrayList<PsiElement> exprs = new ArrayList<PsiElement>();
                PyExpression value = PyInlineLocalHandler.prepareValue(def, localName, project);
                PsiElement lastChild = def.getLastChild();
                if (lastChild != null && lastChild.getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT && (parent = def.getParent()) != null) {
                    parent.addBefore(lastChild, (PsiElement)def);
                }
                HashMap<PsiElement, PsiElement> simpleReplacements = new HashMap<PsiElement, PsiElement>();
                HashMap<PyFStringFragment, PyStringElement> fStringFragmentsReplacements = new HashMap<PyFStringFragment, PyStringElement>();
                for (PsiElement refToInline : refsToInline) {
                    if (PyInlineLocalHandler.checkPossibleInlineElement(refToInline, value, project, editor2, simpleReplacements, fStringFragmentsReplacements)) continue;
                    return;
                }
                LanguageLevel level = LanguageLevel.forElement((PsiElement)value);
                for (Map.Entry entry : simpleReplacements.entrySet()) {
                    Object replValue;
                    PsiElement replElement = (PsiElement)entry.getKey();
                    if (PyReplaceExpressionUtil.isNeedParenthesis((PyExpression)replElement, (PyExpression)(replValue = (PsiElement)entry.getValue()))) {
                        replValue = PyElementGenerator.getInstance(project).createExpressionFromText(level, "(" + replValue.getText() + ")");
                    }
                    exprs.add(replElement.replace(replValue));
                }
                PyInlineLocalHandler.makeFStringFragmentsReplacements(fStringFragmentsReplacements);
                if (!replaceJustOneOccurrence) {
                    PsiElement next = def.getNextSibling();
                    if (next instanceof PsiWhiteSpace) {
                        PyPsiUtils.removeElements(next);
                    }
                    PyPsiUtils.removeElements(new PsiElement[]{def});
                }
                List ranges = ContainerUtil.mapNotNull(exprs, element -> {
                    PyStatement parentalStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatement.class, (boolean)false);
                    return parentalStatement != null ? parentalStatement.getTextRange() : null;
                });
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
                CodeStyleManager.getInstance((Project)project).reformatText(workingFile, (Collection)ranges);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    highlightManager.addOccurrenceHighlights(editor2, exprs.toArray(PsiElement.EMPTY_ARRAY), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                    WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                }
            }
            finally {
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)local);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyInlineLocalHandler.getRefactoringId(), afterData);
            }
        }), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    private static boolean isSameDefinition(PyStatement def, PsiElement otherDef) {
        if (otherDef instanceof PyTargetExpression) {
            otherDef = otherDef.getParent();
        }
        return otherDef == def;
    }

    private static ScopeOwner getContext(PyTargetExpression local) {
        ScopeOwner context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyFunction.class);
        if (context == null) {
            context = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)local, PyClass.class);
        }
        if (context == null) {
            context = (PyFile)local.getContainingFile();
        }
        return context;
    }

    private static Pair<PyStatement, Boolean> getAssignmentToInline(ScopeOwner containerBlock, PyReferenceExpression expr, PyTargetExpression local, Project project) {
        Query query;
        PsiReference first;
        if (expr != null) {
            try {
                List<Instruction> candidates = PyDefUseUtil.getLatestDefs(containerBlock, local.getName(), (PsiElement)expr, true, true, TypeEvalContext.codeInsightFallback(project));
                if (candidates.size() == 1) {
                    PyStatement expression = PyInlineLocalHandler.getAssignmentByLeftPart((PyElement)candidates.get(0).getElement());
                    return Pair.create((Object)expression, (Object)false);
                }
                return Pair.create(null, (Object)(!candidates.isEmpty() ? 1 : 0));
            }
            catch (PyDefUseUtil.InstructionNotFoundException candidates) {
                // empty catch block
            }
        }
        PyElement lValue = (first = (PsiReference)(query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false)).findFirst()) != null ? (PyElement)first.resolve() : null;
        return lValue != null ? Pair.create((Object)PyInlineLocalHandler.getAssignmentByLeftPart(lValue), (Object)false) : EMPTY_DEF_RESULT;
    }

    @Nullable
    private static PyStatement getAssignmentByLeftPart(PyElement candidate) {
        PsiElement parent = candidate.getParent();
        return parent instanceof PyAssignmentStatement || parent instanceof PyAugAssignmentStatement ? (PyStatement)parent : null;
    }

    @Nullable
    private static PyExpression getValue(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getAssignedValue();
        }
        return ((PyAugAssignmentStatement)def).getValue();
    }

    @Nullable
    private static PyExpression getObject(@Nullable PyStatement def) {
        if (def == null) {
            return null;
        }
        if (def instanceof PyAssignmentStatement) {
            return ((PyAssignmentStatement)def).getTargets()[0];
        }
        return ((PyAugAssignmentStatement)def).getTarget();
    }

    @NotNull
    private static PyExpression prepareValue(@NotNull PyStatement def, @NotNull String localName, @NotNull Project project) {
        if (def == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(16);
        }
        if (localName == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(18);
        }
        PyExpression value = PyInlineLocalHandler.getValue(def);
        assert (value != null);
        if (def instanceof PyAugAssignmentStatement) {
            PyAugAssignmentStatement expression = (PyAugAssignmentStatement)def;
            PsiElement operation = expression.getOperation();
            assert (operation != null);
            String op = operation.getText().replace('=', ' ');
            LanguageLevel level = LanguageLevel.forElement((PsiElement)value);
            PyExpression pyExpression = PyElementGenerator.getInstance(project).createExpressionFromText(level, localName + " " + op + value.getText() + ")");
            if (pyExpression == null) {
                PyInlineLocalHandler.$$$reportNull$$$0(19);
            }
            return pyExpression;
        }
        PyExpression pyExpression = value;
        if (pyExpression == null) {
            PyInlineLocalHandler.$$$reportNull$$$0(20);
        }
        return pyExpression;
    }

    public static String getRefactoringId() {
        return "refactoring.python.inline.local";
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlinedStringElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFString";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleReplacements";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fStringFragmentsReplacements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/inline/PyInlineLocalHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceQuotesInExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringContentCanBeInlinedIntoFString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringElements";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceQuotesInExpression";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkPossibleInlineElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "makeFStringFragmentsReplacements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 19, 20 -> new IllegalStateException(string);
        };
    }
}

