/* File:      builtin.P
** Author(s): Debray, Sagonas, Swift, Warren, Xu
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1999
** Copyright (C) ECRC, Germany, 1990
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: builtin.P,v 1.72 2011-08-12 15:14:16 tswift Exp $
** 
*/


:- compiler_options([xpp_on]).
#include "../emu/builtin.h"

/*======================================================================*/
/* inline predicates							*/
/*======================================================================*/

:- mode inline_predicate(?,?).
inline_predicate(<, 2).
inline_predicate(>, 2).
inline_predicate(=<, 2).
inline_predicate(>=, 2).
inline_predicate(=:=, 2).
inline_predicate(=\=, 2).
inline_predicate(is, 2).

inline_predicate(=, 2).
inline_predicate(==, 2).
inline_predicate(@=, 2).
inline_predicate(\==, 2).
inline_predicate(@<, 2).
inline_predicate(@=<, 2).
inline_predicate(@>, 2).
inline_predicate(@>=, 2).

%%inline_predicate(var, 1).
%%inline_predicate(nonvar, 1).
inline_predicate('_$cutto', 1).
inline_predicate('_$savecp', 1).
inline_predicate('_$builtin', 1).

inline_predicate(fail, 0).
inline_predicate(true, 0).
inline_predicate(halt, 0).
inline_predicate(!, 0).

inline_predicate(Pred,A) :- inline_jumpcof_cond(Pred,A,_).

:- mode is_builtin_instr(?,?,?).
is_builtin_instr(Pred,Arity,Sym) :-
    builtin_instr(Pred,Arity,Mod),
    (standard_symbol(Pred,Arity,_)
     ->	true
     ;	sym_prop(im(Mod),Sym)
    ).

%% Declaring a builtin an inline_predicate makes compiler use bi_instr
%% instruction.  A builtin can use a builtin_instr only if its only
%% access to registers is through the ptoc_* and ctop-*
%% macros/functions and only its argument registers are accessed.  So
%% builtins like code_call cannot be so declared.  Also, only builtins
%% with 0 to 4 arguments can be instructions.
%% Also builtins that may call expand_heap cannot be instructions.

:- mode builtin_instr(?,?,?).
builtin_instr(abolish_table_info,0,machine).
builtin_instr(assert_code_to_buff,1,machine).
%%builtin_instr(code_load,4,machine).
builtin_instr(conget,2,gensym).
builtin_instr(conset,2,gensym).
builtin_instr(conget,2,machine).
builtin_instr(conset,2,machine).
builtin_instr(file_function,3,machine).
%%builtin_instr(get_delay_lists,2,tables).
builtin_instr(getenv,2,machine).
%%builtin_instr(incr_eval_builtin,3,increval).  NO, uses many registers
%%builtin_instr(load_obj,4,machine).
%%builtin_instr(parsort,4,machine).
builtin_instr(psc_name,2,machine).
builtin_instr(psc_arity,2,machine).
builtin_instr(psc_type,2,machine).
builtin_instr(psc_prop,2,machine).
builtin_instr(psc_mod,2,machine).
builtin_instr(psc_set_type,2,machine).
builtin_instr(psc_set_prop,2,machine).
builtin_instr(psc_ep,2,machine).
builtin_instr(psc_set_ep,2,machine).
builtin_instr(psc_data,2,machine).
builtin_instr(psc_insert,4,machine).
builtin_instr(psc_insertmod_inline,3,machine).
builtin_instr(psc_import,3,machine).
builtin_instr(psc_import_as,2,machine).
builtin_instr(putenv,1,machine).
builtin_instr(stat_flag,2,machine).
builtin_instr(stat_set_flag,2,machine).
builtin_instr(stat_sta,1,machine).
builtin_instr(stat_cputime,1,machine). 
builtin_instr(stat_walltime,1,machine).
builtin_instr(str_len,2,machine).
builtin_instr(str_cmp,3,machine).
builtin_instr(term_new_mod_inline,3,machine).
builtin_instr(term_psc,2,machine).
builtin_instr(term_type,2,machine).
builtin_instr(term_compare,3,machine).
builtin_instr(term_new,2,machine).
builtin_instr(term_arg,3,machine).
builtin_instr(term_set_arg,4,machine).
builtin_instr(term_hash,3,machine).
%%builtin_instr(trie_assert_hdr_info,3,machine).  % if add to inline_builtin
builtin_instr(unload_seg,1,machine).

%% builtins for which to generate a bi_instr instruction: these are
%% standard predicates (so mod doesnt matter, or is gotten from the
%% standard_symbol). 

builtin_instr(functor,3,_).
builtin_instr(=..,2,_).
builtin_instr(acyclic_term,1,_).
builtin_instr(arg,3,_).
%builtin_instr(atom_codes,2,_).
%builtin_instr(atom_chars,2,_).
builtin_instr(copy_term,2,_).
builtin_instr(expand_filename,2,_).
builtin_instr(get_producer_call,3,_).
builtin_instr(hilog_arg,3,_).
%%builtin_instr(is_absolute_filename,1,_).  %% causes inf loop in system??
%%builtin_instr(is_acyclic,1,_). breaks prolog_tests/large_arity_prolog
builtin_instr(is_charlist,2,_).
%%builtin_instr(is_cyclic,1,_). breaks prolog_tests/test_cycle.P
%builtin_instr(keysort,2,_).
builtin_instr(number_chars,2,_).
builtin_instr(number_codes,2,_).
builtin_instr(number_digits,2,standard).
builtin_instr(parse_filename,4,_).
builtin_instr(psc_init_info,1,machine).
builtin_instr(put,1,_).
builtin_instr(segfault_handler,1,_).
builtin_instr(slash,1,machine).
%builtin_instr(sort,2,_).
builtin_instr(str_cat,3,_).
builtin_instr(str_length,2,_).
builtin_instr(string_substitute,4,_).
builtin_instr(substring,4,_).
builtin_instr(tab,1,standard).
builtin_instr(term_depth,2,_).
builtin_instr(term_size,2,_).
builtin_instr(term_size_limit,2,_).
builtin_instr(tilde_expand_filename,2,_).
builtin_instr(unify_with_occurs_check,2,_).

/*======================================================================*/
/* primitive predicates	("hard-wired" builtins)				*/
/*======================================================================*/

:- mode inline_builtin(?,?,?).
inline_builtin(=.., 2, UNIV).
inline_builtin('$$clean_up_block', 0, CLEAN_UP_BLOCK).
inline_builtin('$$findall_init', 2, FINDALL_INIT).
inline_builtin('$$findall_add', 3, FINDALL_ADD).
inline_builtin('$$findall_get_solutions', 4, FINDALL_GET_SOLS).
inline_builtin('$$set_scope_marker', 0, SET_SCOPE_MARKER).
inline_builtin('$$unwind_stack', 0, UNWIND_STACK).
inline_builtin(abolish_table_info, 0, ABOLISH_ALL_TABLES).
inline_builtin(abolish_table_predicate, 1, ABOLISH_TABLE_PREDICATE).
inline_builtin(almost_search_module, 5, ALMOST_SEARCH_MODULE).
inline_builtin(arg, 3, ARG).
inline_builtin(assert_buff_to_clref, 6, ASSERT_BUFF_TO_CLREF).
inline_builtin(assert_code_to_buff, 1, ASSERT_CODE_TO_BUFF).
%inline_builtin(atom_chars, 2, ATOM_CHARS).
%inline_builtin(atom_codes, 2, ATOM_CODES).
% inline_builtin(breg_retskel, 4, BREG_RETSKEL). % do not inline!
inline_builtin(buff_alloc, 2, BUFF_ALLOC).
inline_builtin(buff_byte, 3, BUFF_BYTE).
inline_builtin(buff_cell, 3, BUFF_CELL).
inline_builtin(buff_dealloc, 3, BUFF_DEALLOC).
inline_builtin(buff_set_byte, 3, BUFF_SET_BYTE).
inline_builtin(buff_set_cell, 4, BUFF_SET_CELL).
inline_builtin(buff_set_var, 4, BUFF_SET_VAR).
inline_builtin(buff_set_word, 3, BUFF_SET_WORD).
inline_builtin(buff_word, 3, BUFF_WORD).
inline_builtin(call0, 1, CALL0).
inline_builtin(close_open_tables, 1, CLOSE_OPEN_TABLES).
inline_builtin(code_call, 3, CODE_CALL).
inline_builtin(code_load, 4, CODE_LOAD).
inline_builtin(conget, 2, CONGET_TERM).
inline_builtin(conset, 2, CONSET_TERM).
inline_builtin(copy_term, 2, COPY_TERM).
inline_builtin(dereference_the_bucket, 2, DEREFERENCE_THE_BUCKET).
inline_builtin(dirname_canonic, 2, DIRNAME_CANONIC).
inline_builtin(dynamic_code_function,5, DYNAMIC_CODE_FUNCTION).
inline_builtin(existing_file_extension, 2, EXISTING_FILE_EXTENSION).
inline_builtin(expand_filename, 2, EXPAND_FILENAME).
inline_builtin(expand_heap, 0, EXP_HEAP).
inline_builtin(file_function, 3, FILE_FUNCTION).
inline_builtin(file_function, 7, FILE_FUNCTION).
inline_builtin(file_gettoken, 5, FILE_GETTOKEN).
inline_builtin(file_puttoken, 3, FILE_PUTTOKEN).
inline_builtin(file_writequoted, 2, FILE_WRITEQUOTED).
inline_builtin(force_truth_value, 2, FORCE_TRUTH_VALUE).
inline_builtin(formatted_io, 5, FORMATTED_IO).
inline_builtin(functor, 3, FUNCTOR).
inline_builtin(get_call, 4, TRIE_GET_CALL).
inline_builtin(get_delay_lists, 2, GET_DELAY_LISTS).
inline_builtin(get_lastnode_cs_retskel, 4, GET_LASTNODE_CS_RETSKEL).
inline_builtin(get_producer_call, 3, GET_PRODUCER_CALL).
inline_builtin(get_ptcp, 1, GET_PTCP).
inline_builtin(getenv, 2, GETENV).
inline_builtin(putenv, 1, PUTENV).
inline_builtin(hilog_arg, 3, HiLog_ARG).
%% inline_builtin(hilog_univ, 2, HiLog_UNIV).
inline_builtin(intern_string, 2, INTERN_STRING).
inline_builtin(is_absolute_filename, 1, IS_ABSOLUTE_FILENAME).
inline_builtin(is_charlist, 2, IS_CHARLIST).
inline_builtin(acyclic_term, 1, IS_ACYCLIC).
inline_builtin(is_acyclic, 1, IS_ACYCLIC).
inline_builtin(is_cyclic, 1, IS_CYCLIC).
%% inline_builtin(is_incomplete, 2, IS_INCOMPLETE). % Should not be inlined -- Kostis !!
inline_builtin(is_xwammode, 1, IS_XWAMMODE).
%inline_builtin(keysort, 2, KEYSORT).
inline_builtin(load_obj, 4, LOAD_OBJ).
inline_builtin(lrd_success, 2, LRD_SUCCESS).
inline_builtin(mark_heap, 1, MARK_HEAP).
inline_builtin(next_bucket, 2, NEXT_BUCKET).
inline_builtin(number_chars, 2, NUMBER_CHARS).
inline_builtin(number_codes, 2, NUMBER_CODES).
inline_builtin(number_digits, 2, NUMBER_DIGITS).
inline_builtin(pair_next, 2, PAIR_NEXT).
inline_builtin(pair_psc, 2, PAIR_PSC).
inline_builtin(parse_filename, 4, PARSE_FILENAME).
%inline_builtin(print_all_stacks, 0, PRINT_ALL_STACKS).
%inline_builtin(print_cp, 0, PRINT_CP).
%inline_builtin(print_heap, 2, PRINT_HEAP).
%inline_builtin(print_ls, 0, PRINT_LS).
%inline_builtin(print_regs, 0, PRINT_REGS).
%inline_builtin(print_tr, 0, PRINT_TR).
inline_builtin(psc_arity, 2, PSC_ARITY).
inline_builtin(psc_data, 2, PSC_DATA).
inline_builtin(psc_env, 2, PSC_ENV).
inline_builtin(psc_ep, 2, PSC_EP).
inline_builtin(psc_import, 3, PSC_IMPORT).
inline_builtin(psc_import_as, 2, PSC_IMPORT_AS).
inline_builtin(psc_insert, 4, PSC_INSERT).
inline_builtin(psc_insertmod_inline, 3, PSC_INSERTMOD).
inline_builtin(psc_init_info, 1, PSC_INIT_INFO).
inline_builtin(psc_mod, 2, PSC_MOD).
inline_builtin(psc_name, 2, PSC_NAME).
inline_builtin(psc_prop, 2, PSC_PROP).
inline_builtin(psc_set_ep, 2, PSC_SET_EP).
inline_builtin(psc_set_prop, 2, PSC_SET_PROP).
inline_builtin(psc_set_spy, 2, PSC_SET_SPY).
inline_builtin(psc_set_type, 2, PSC_SET_TYPE).
inline_builtin(psc_spy, 2, PSC_SPY).
inline_builtin(psc_type, 2, PSC_TYPE).
inline_builtin(put, 1, PUT).
inline_builtin(segfault_handler, 1, SEGFAULT_HANDLER).
inline_builtin(set_tabled_eval, 2, SET_TABLED_EVAL).
inline_builtin(slash, 1, SLASH_BUILTIN).
inline_builtin(slg_not, 1, SLG_NOT).
%inline_builtin(sort, 2, SORT).
%inline_builtin(parsort, 4, PARSORT).
inline_builtin(stat_cputime, 1, STAT_CPUTIME).
inline_builtin(stat_flag, 2,  STAT_FLAG).
inline_builtin(stat_set_flag, 2, STAT_SET_FLAG).
inline_builtin(stat_sta, 1, STAT_STA).
inline_builtin(stat_walltime, 1, STAT_WALLTIME).
inline_builtin(storage_builtin, 5, STORAGE_BUILTIN).
inline_builtin(str_len, 2, STR_LEN).
inline_builtin(str_length, 2, STR_LEN).
inline_builtin(str_cat, 3, STR_CAT).
inline_builtin(str_cmp, 3, STR_CMP).
inline_builtin(str_match, 5, STR_MATCH).
inline_builtin(string_substitute, 4, STRING_SUBSTITUTE).
inline_builtin(substring, 4, SUBSTRING).
inline_builtin(sys_errno, 1, SYS_ERRNO).
inline_builtin(sys_gethost, 2, SYS_GETHOST).
/* inline_builtin(sys_syscall, 4, SYS_SYSCALL). */
inline_builtin(sys_system, 7, SYS_SYSTEM).
inline_builtin(tab, 1, TAB).
inline_builtin(table_status, 4, TABLE_STATUS).
inline_builtin(term_arg, 3, TERM_ARG).
inline_builtin(term_compare, 3, TERM_COMPARE).
inline_builtin(term_depth, 2, TERM_DEPTH).
inline_builtin(term_hash, 3, TERM_HASH).
inline_builtin(term_new, 2, TERM_NEW).
inline_builtin(term_new_mod_inline, 3, TERM_NEW_MOD).
inline_builtin(term_psc, 2, TERM_PSC).
inline_builtin(term_set_arg, 4, TERM_SET_ARG).
inline_builtin(term_size, 2, TERM_SIZE).
inline_builtin(term_size_limit, 2, TERM_SIZE_LIMIT).
inline_builtin(term_type, 2, TERM_TYPE).
inline_builtin(tilde_expand_filename, 2, TILDE_EXPAND_FILENAME).
inline_builtin(trie_delete_return, 3, TRIE_DELETE_RETURN).
inline_builtin(unload_seg, 1, UNLOAD_SEG).
inline_builtin(unify_with_occurs_check, 2, UNIFY_WITH_OCCURS_CHECK).

% The following two are not declared as inlined, because they are inlined
% in a special way (through WAM instructions) by the XSB compiler anyway.
% inline_builtin(var, 1, VAR).
% inline_builtin(nonvar, 1, NONVAR).
% inline_builtin(atom, 1, ATOM).
% inline_builtin(integer, 1, INTEGER).
% inline_builtin(real, 1, REAL).
% inline_builtin(number, 1, NUMBER).
% inline_builtin(atomic, 1, ATOMIC).
% inline_builtin(compound, 1, COMPOUND).
% inline_builtin(callable, 1, CALLABLE).
% inline_builtin(is_list, 1, IS_LIST).
% inline_builtin(is_attv, 1, IS_ATTV). % similar to is_list
% inline_builtin(is_most_general_term, 1, IS_MOST_GENERAL_TERM).
% inline_builtin(is_number_atom, 1, IS_NUMBER_ATOM).


:- mode inline_jumpcof_cond(?,?,?).
%%inline_jumpcof_cond(_,_,_) :- fail.
inline_jumpcof_cond(atom, 1, ATOM_TEST).
inline_jumpcof_cond(integer, 1, INTEGER_TEST).
inline_jumpcof_cond(real, 1, REAL_TEST).
inline_jumpcof_cond(number, 1, NUMBER_TEST).
inline_jumpcof_cond(atomic, 1, ATOMIC_TEST).
inline_jumpcof_cond(compound, 1, COMPOUND_TEST).
inline_jumpcof_cond(callable, 1, CALLABLE_TEST).
inline_jumpcof_cond(directly_callable, 1, DIRECTLY_CALLABLE_TEST).
inline_jumpcof_cond(is_list, 1, IS_LIST_TEST).
inline_jumpcof_cond(is_most_general_term, 1, IS_MOST_GENERAL_TERM_TEST).
inline_jumpcof_cond(is_attv, 1, IS_ATTV_TEST).
inline_jumpcof_cond(var, 1, VAR_TEST).
inline_jumpcof_cond(nonvar, 1, NONVAR_TEST).
inline_jumpcof_cond(is_number_atom, 1, IS_NUMBER_ATOM_TEST).
inline_jumpcof_cond(ground, 1, GROUND_TEST).

/*======================================================================*/
/* builtin functions							*/
/*======================================================================*/

:- mode builtin_function(?,?,?).
builtin_function(+, 2, 1).
builtin_function(-, 2, 2).
builtin_function(*, 2, 3).
builtin_function(/, 2, 4).
builtin_function(/\, 2, 5).
builtin_function(\/, 2, 6).
builtin_function(//, 2, 7).
builtin_function(sin, 1, 9).
builtin_function(cos, 1, 10).
builtin_function(tan, 1, 11).
builtin_function(float, 1, 13).
builtin_function(floor, 1, 14).
builtin_function(exp, 1, 15).
builtin_function(log, 1, 16).
builtin_function(log10, 1, 17).
builtin_function(sqrt, 1, 18).
builtin_function(asin, 1, 19).
builtin_function(acos, 1, 20).
builtin_function(atan, 1, 21).
builtin_function(abs, 1, 22).
builtin_function(truncate, 1, 23).
builtin_function(round, 1, 24).
builtin_function(ceiling, 1, 25).
builtin_function(sign, 1, 26).
builtin_function(lgamma, 1, 28).
builtin_function(erf, 1, 29).
