/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;

public interface NextGenBuildCacheAccess
extends Closeable {
    public <T> void load(Map<BuildCacheKey, T> var1, LoadHandler<T> var2);

    public <T> void store(Map<BuildCacheKey, T> var1, StoreHandler<T> var2);

    public static abstract class DelegatingStoreHandler<T>
    implements StoreHandler<T> {
        private final StoreHandler<T> delegate;

        public DelegatingStoreHandler(StoreHandler<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void ensureStoreOperationStarted(BuildCacheKey key) {
            this.delegate.ensureStoreOperationStarted(key);
        }

        @Override
        public void recordStoreFinished(BuildCacheKey key, boolean stored) {
            this.delegate.recordStoreFinished(key, stored);
        }

        @Override
        public void recordStoreFailure(BuildCacheKey key, Throwable failure) {
            this.delegate.recordStoreFailure(key, failure);
        }

        @Override
        public void recordPackFailure(BuildCacheKey key, Throwable failure) {
            this.delegate.recordPackFailure(key, failure);
        }
    }

    public static abstract class DelegatingLoadHandler<T>
    implements LoadHandler<T> {
        private final LoadHandler<T> delegate;

        public DelegatingLoadHandler(LoadHandler<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void ensureLoadOperationStarted(BuildCacheKey key) {
            this.delegate.ensureLoadOperationStarted(key);
        }

        @Override
        public void recordLoadHit(BuildCacheKey key, long size) {
            this.delegate.recordLoadHit(key, size);
        }

        @Override
        public void recordLoadMiss(BuildCacheKey key) {
            this.delegate.recordLoadMiss(key);
        }

        @Override
        public void recordLoadFailure(BuildCacheKey key, Throwable t) {
            this.delegate.recordLoadFailure(key, t);
        }

        @Override
        public void recordUnpackFailure(BuildCacheKey key, Throwable failure) {
            this.delegate.recordUnpackFailure(key, failure);
        }
    }

    public static interface StoreHandler<T> {
        public NextGenBuildCacheService.NextGenWriter createWriter(T var1);

        public void ensureStoreOperationStarted(BuildCacheKey var1);

        public void recordStoreFinished(BuildCacheKey var1, boolean var2);

        public void recordStoreFailure(BuildCacheKey var1, Throwable var2);

        public void recordPackFailure(BuildCacheKey var1, Throwable var2);
    }

    public static interface LoadHandler<T> {
        public void handle(InputStream var1, T var2);

        public void ensureLoadOperationStarted(BuildCacheKey var1);

        public void recordLoadHit(BuildCacheKey var1, long var2);

        public void recordLoadMiss(BuildCacheKey var1);

        public void recordLoadFailure(BuildCacheKey var1, Throwable var2);

        public void recordUnpackFailure(BuildCacheKey var1, Throwable var2);
    }
}

