/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winspool;
import com.sun.jna.platform.win32.WinspoolUtil;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;

public class Win32SpoolMonitor {
    private static final int TWO_DIMENSIONAL_PRINTERS = 0;
    private static final Charset UTF_16LE = Charset.forName("UTF-16LE");

    public void monitorPrinter(String pPrinterName) {
        WinNT.HANDLEByReference phPrinter = new WinNT.HANDLEByReference();
        Winspool.INSTANCE.OpenPrinter(pPrinterName, phPrinter, null);
        WinNT.HANDLE chgObject = Winspool.INSTANCE.FindFirstPrinterChangeNotification(phPrinter.getValue(), 65280, 0, (Winspool.PRINTER_NOTIFY_OPTIONS)null);
        if (chgObject != null) {
            WinDef.DWORDByReference pdwChange;
            boolean fcnreturn;
            do {
                Kernel32.INSTANCE.WaitForSingleObject(chgObject, -1);
            } while (!(fcnreturn = Winspool.INSTANCE.FindNextPrinterChangeNotification(chgObject, pdwChange = new WinDef.DWORDByReference(), (Winspool.PRINTER_NOTIFY_OPTIONS)null, (PointerByReference)null)));
            Winspool.JOB_INFO_1[] jobInfo1 = WinspoolUtil.getJobInfo1(phPrinter);
            for (int i = 0; i < jobInfo1.length; ++i) {
                this.printJobInfo(jobInfo1[i]);
            }
            Winspool.INSTANCE.FindClosePrinterChangeNotification(chgObject);
        } else {
            this.getLastError();
        }
    }

    public int getLastError() {
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 0) {
            System.out.println("error: " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorAllPrinters() {
        System.out.println("Monitoring all printers, press Ctrl + C to stop");
        WinNT.HANDLEByReference printServerHandle = new WinNT.HANDLEByReference();
        boolean success = Winspool.INSTANCE.OpenPrinter(null, printServerHandle, null);
        if (!success) {
            int errorCode = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("Failed to access the print server - " + errorCode);
        }
        try {
            Winspool.PRINTER_NOTIFY_OPTIONS options = new Winspool.PRINTER_NOTIFY_OPTIONS();
            options.Count = 1;
            Winspool.PRINTER_NOTIFY_OPTIONS_TYPE.ByReference optionsType = new Winspool.PRINTER_NOTIFY_OPTIONS_TYPE.ByReference();
            optionsType.Type = 1;
            optionsType.setFields(new short[]{0, 10, 13});
            optionsType.toArray(1);
            options.pTypes = optionsType;
            WinNT.HANDLE changeNotificationsHandle = Winspool.INSTANCE.FindFirstPrinterChangeNotification(printServerHandle.getValue(), 1792, 0, options);
            if (!this.isValidHandle(changeNotificationsHandle)) {
                int errorCode = Kernel32.INSTANCE.GetLastError();
                throw new RuntimeException("Failed to get a change handle - " + errorCode);
            }
            try {
                while (true) {
                    Kernel32.INSTANCE.WaitForSingleObject(changeNotificationsHandle, -1);
                    WinDef.DWORDByReference change = new WinDef.DWORDByReference();
                    PointerByReference infoPointer = new PointerByReference();
                    success = Winspool.INSTANCE.FindNextPrinterChangeNotification(changeNotificationsHandle, change, options, infoPointer);
                    if (!success) {
                        int errorCode = Kernel32.INSTANCE.GetLastError();
                        throw new RuntimeException("Failed to get printer change notification - " + errorCode);
                    }
                    System.out.println("Change - " + String.format("0x%08X", change.getValue().longValue()));
                    if (infoPointer.getValue() != null) {
                        Winspool.PRINTER_NOTIFY_INFO info = Structure.newInstance(Winspool.PRINTER_NOTIFY_INFO.class, infoPointer.getValue());
                        info.read();
                        try {
                            if ((info.Flags & 1) > 0) {
                                System.out.println("Some information was discarded");
                            }
                            for (Winspool.PRINTER_NOTIFY_INFO_DATA data : info.aData) {
                                System.out.println("Job ID - " + data.Id);
                                if (data.Field == 0) {
                                    String printerName = new String(data.NotifyData.Data.pBuf.getByteArray(0L, data.NotifyData.Data.cbBuf), UTF_16LE);
                                    System.out.println("Printer - " + printerName);
                                    continue;
                                }
                                if (data.Field == 10) {
                                    System.out.println("Status - " + String.format("0x%08X", data.NotifyData.adwData[0]));
                                    continue;
                                }
                                String jobName = new String(data.NotifyData.Data.pBuf.getByteArray(0L, data.NotifyData.Data.cbBuf), UTF_16LE);
                                System.out.println("Job Name - " + jobName);
                            }
                        }
                        finally {
                            Winspool.INSTANCE.FreePrinterNotifyInfo(info.getPointer());
                        }
                    }
                    System.out.println("==================================================");
                }
            }
            catch (Throwable throwable) {
                Winspool.INSTANCE.FindClosePrinterChangeNotification(changeNotificationsHandle);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Winspool.INSTANCE.ClosePrinter(printServerHandle.getValue());
            throw throwable;
        }
    }

    private boolean isValidHandle(WinNT.HANDLE handle) {
        return handle != null && !handle.equals(Kernel32.INVALID_HANDLE_VALUE);
    }

    private void printJobInfo(Winspool.JOB_INFO_1 jobInfo1) {
        WinBase.FILETIME lpFileTime = new WinBase.FILETIME();
        Kernel32.INSTANCE.SystemTimeToFileTime(jobInfo1.Submitted, lpFileTime);
        String info = "JobId: " + jobInfo1.JobId + "\npDatatype: " + jobInfo1.pDatatype + "\nPagesPrinted: " + jobInfo1.PagesPrinted + "\npDocument: " + jobInfo1.pDocument + "\npMachineName: " + jobInfo1.pMachineName + "\nPosition: " + jobInfo1.Position + "\npPrinterName: " + jobInfo1.pPrinterName + "\nPriority: " + jobInfo1.Priority + "\npStatus: " + jobInfo1.pStatus + "\npUserName: " + jobInfo1.pUserName + "\nStatus: " + jobInfo1.Status + "\nTotalPages: " + jobInfo1.TotalPages + "\nSubmitted: " + DateFormat.getDateTimeInstance().format(lpFileTime.toDate());
        System.out.println(info);
    }

    public static void main(String[] args) throws Exception {
        System.out.print("Please enter the name of a printer to monitor, or press enter to monitor all printers: ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String printer = reader.readLine();
        Win32SpoolMonitor monitor = new Win32SpoolMonitor();
        if (printer.isEmpty()) {
            monitor.monitorAllPrinters();
        } else {
            monitor.monitorPrinter(printer);
        }
    }
}

