/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocTypeCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    public static final String MSG_UNKNOWN_TAG = "javadoc.unknownTag";
    public static final String MSG_TAG_FORMAT = "type.tagFormat";
    public static final String MSG_MISSING_TAG = "type.missingTag";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG = Pattern.compile("\\s*<([^>]+)>.*");
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG_SPLITTER = Pattern.compile("\\s+");
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern authorFormat;
    private Pattern versionFormat;
    private boolean allowMissingParamTags;
    private boolean allowUnknownTags;
    private List<String> allowedAnnotations = Collections.singletonList("Generated");

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setAuthorFormat(Pattern pattern) {
        this.authorFormat = pattern;
    }

    public void setVersionFormat(Pattern pattern) {
        this.versionFormat = pattern;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowUnknownTags(boolean flag) {
        this.allowUnknownTags = flag;
    }

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Arrays.asList(userAnnotations);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
            if (textBlock == null) {
                this.log(lineNo, MSG_JAVADOC_MISSING, new Object[0]);
            } else {
                List<JavadocTag> tags = this.getJavadocTags(textBlock);
                if (ScopeUtil.isOuterMostType(ast)) {
                    this.checkTag(lineNo, tags, JavadocTagInfo.AUTHOR.getName(), this.authorFormat);
                    this.checkTag(lineNo, tags, JavadocTagInfo.VERSION.getName(), this.versionFormat);
                }
                List<String> typeParamNames = CheckUtil.getTypeParameterNames(ast);
                if (!this.allowMissingParamTags) {
                    for (String typeParamName : typeParamNames) {
                        this.checkTypeParamTag(lineNo, tags, typeParamName);
                    }
                }
                this.checkUnusedTypeParamTags(tags, typeParamNames);
            }
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        Scope customScope;
        if (ScopeUtil.isInInterfaceOrAnnotationBlock(ast)) {
            customScope = Scope.PUBLIC;
        } else {
            DetailAST mods = ast.findFirstToken(5);
            customScope = ScopeUtil.getScopeFromMods(mods);
        }
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope)) && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations);
    }

    private List<JavadocTag> getJavadocTags(TextBlock textBlock) {
        JavadocTags tags = JavadocUtil.getJavadocTags(textBlock, JavadocUtil.JavadocTagType.BLOCK);
        if (!this.allowUnknownTags) {
            for (InvalidJavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), MSG_UNKNOWN_TAG, tag.getName());
            }
        }
        return tags.getValidTags();
    }

    private void checkTag(int lineNo, List<JavadocTag> tags, String tagName, Pattern formatPattern) {
        if (formatPattern != null) {
            boolean hasTag = false;
            String tagPrefix = "@";
            for (int i = tags.size() - 1; i >= 0; --i) {
                JavadocTag tag = tags.get(i);
                if (!tag.getTagName().equals(tagName)) continue;
                hasTag = true;
                if (formatPattern.matcher(tag.getFirstArg()).find()) continue;
                this.log(lineNo, MSG_TAG_FORMAT, "@" + tagName, formatPattern.pattern());
            }
            if (!hasTag) {
                this.log(lineNo, MSG_MISSING_TAG, "@" + tagName);
            }
        }
    }

    private void checkTypeParamTag(int lineNo, List<JavadocTag> tags, String typeParamName) {
        boolean found = false;
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag() || tag.getFirstArg().indexOf(OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log(lineNo, MSG_MISSING_TAG, JavadocTagInfo.PARAM.getText() + " " + OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET);
        }
    }

    private void checkUnusedTypeParamTags(List<JavadocTag> tags, List<String> typeParamNames) {
        for (int i = tags.size() - 1; i >= 0; --i) {
            String typeParamName;
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag() || typeParamNames.contains(typeParamName = JavadocTypeCheck.extractTypeParamNameFromTag(tag))) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.PARAM.getText(), OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET);
        }
    }

    private static String extractTypeParamNameFromTag(JavadocTag tag) {
        Matcher matchInAngleBrackets = TYPE_NAME_IN_JAVADOC_TAG.matcher(tag.getFirstArg());
        String typeParamName = matchInAngleBrackets.find() ? matchInAngleBrackets.group(1).trim() : TYPE_NAME_IN_JAVADOC_TAG_SPLITTER.split(tag.getFirstArg())[0];
        return typeParamName;
    }
}

