// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGauge_MoveTo(t *testing.T) {
	ms := generateTestGauge()
	dest := NewGauge()
	ms.MoveTo(dest)
	assert.Equal(t, NewGauge(), ms)
	assert.Equal(t, generateTestGauge(), dest)
}

func TestGauge_CopyTo(t *testing.T) {
	ms := NewGauge()
	orig := NewGauge()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestGauge()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestGauge_DataPoints(t *testing.T) {
	ms := NewGauge()
	assert.Equal(t, NewNumberDataPointSlice(), ms.DataPoints())
	fillTestNumberDataPointSlice(ms.DataPoints())
	assert.Equal(t, generateTestNumberDataPointSlice(), ms.DataPoints())
}

func generateTestGauge() Gauge {
	tv := NewGauge()
	fillTestGauge(tv)
	return tv
}

func fillTestGauge(tv Gauge) {
	fillTestNumberDataPointSlice(newNumberDataPointSlice(&tv.orig.DataPoints))
}
