// This file defines a gNOI API used for OS installation.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.14.0
// source: os.proto

package pb

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type InstallError_Type int32

const (
	// An unspecified error. Must use the detail value to describe the issue.
	InstallError_UNSPECIFIED InstallError_Type = 0
	// The newly transferred package is not compatible with the Target platform.
	// The detail field MUST contain the detailed error message.
	InstallError_INCOMPATIBLE InstallError_Type = 1
	// The OS package being transferred is larger than the available size the
	// Target provisioned. This is unexpected since the Target MUST clear disk
	// space for the new OS packages. The available space and the OS package
	// size MUST be guaranteed by the platform maker, therefore the most likely
	// cause of this error is that a wrong package is being transferred.
	InstallError_TOO_LARGE InstallError_Type = 2
	// Used whenever the system is unable to parse the newly transferred
	// package, like reading the OS version or the integrity checksums.
	InstallError_PARSE_FAIL InstallError_Type = 3
	// The transferred OS package fails integrity check.
	InstallError_INTEGRITY_FAIL InstallError_Type = 4
	// Attempting to force transfer an OS package with the same version as the
	// currently running.
	InstallError_INSTALL_RUN_PACKAGE InstallError_Type = 5
	// Another Install RPC to this Target is already in progress.
	InstallError_INSTALL_IN_PROGRESS InstallError_Type = 6
	// A switchover happened during the Install RPC.
	InstallError_UNEXPECTED_SWITCHOVER InstallError_Type = 7
	// Failed to sync the transferred OS package to the standby Supervisor. The
	// detail value MUST have more information.
	InstallError_SYNC_FAIL InstallError_Type = 8
)

// Enum value maps for InstallError_Type.
var (
	InstallError_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "INCOMPATIBLE",
		2: "TOO_LARGE",
		3: "PARSE_FAIL",
		4: "INTEGRITY_FAIL",
		5: "INSTALL_RUN_PACKAGE",
		6: "INSTALL_IN_PROGRESS",
		7: "UNEXPECTED_SWITCHOVER",
		8: "SYNC_FAIL",
	}
	InstallError_Type_value = map[string]int32{
		"UNSPECIFIED":           0,
		"INCOMPATIBLE":          1,
		"TOO_LARGE":             2,
		"PARSE_FAIL":            3,
		"INTEGRITY_FAIL":        4,
		"INSTALL_RUN_PACKAGE":   5,
		"INSTALL_IN_PROGRESS":   6,
		"UNEXPECTED_SWITCHOVER": 7,
		"SYNC_FAIL":             8,
	}
)

func (x InstallError_Type) Enum() *InstallError_Type {
	p := new(InstallError_Type)
	*p = x
	return p
}

func (x InstallError_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstallError_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_os_proto_enumTypes[0].Descriptor()
}

func (InstallError_Type) Type() protoreflect.EnumType {
	return &file_os_proto_enumTypes[0]
}

func (x InstallError_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstallError_Type.Descriptor instead.
func (InstallError_Type) EnumDescriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{8, 0}
}

type ActivateError_Type int32

const (
	// An unspecified error. Must use the detail value to describe the issue.
	ActivateError_UNSPECIFIED ActivateError_Type = 0
	// There is no OS package with the version requested for activation. This is
	// also used for an empty version string.
	ActivateError_NON_EXISTENT_VERSION ActivateError_Type = 1
)

// Enum value maps for ActivateError_Type.
var (
	ActivateError_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "NON_EXISTENT_VERSION",
	}
	ActivateError_Type_value = map[string]int32{
		"UNSPECIFIED":          0,
		"NON_EXISTENT_VERSION": 1,
	}
)

func (x ActivateError_Type) Enum() *ActivateError_Type {
	p := new(ActivateError_Type)
	*p = x
	return p
}

func (x ActivateError_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActivateError_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_os_proto_enumTypes[1].Descriptor()
}

func (ActivateError_Type) Type() protoreflect.EnumType {
	return &file_os_proto_enumTypes[1]
}

func (x ActivateError_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActivateError_Type.Descriptor instead.
func (ActivateError_Type) EnumDescriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{12, 0}
}

type StandbyState_State int32

const (
	StandbyState_UNSPECIFIED StandbyState_State = 0
	// The Target does not support dual Supervisors.
	StandbyState_UNSUPORTED StandbyState_State = 1
	// Standby Supervisor is supported but does not exist.
	StandbyState_NON_EXISTENT StandbyState_State = 2
	// Standby Supervisor is supported but is not available, eg.: rebooting.
	StandbyState_UNAVAILABLE StandbyState_State = 3
)

// Enum value maps for StandbyState_State.
var (
	StandbyState_State_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "UNSUPORTED",
		2: "NON_EXISTENT",
		3: "UNAVAILABLE",
	}
	StandbyState_State_value = map[string]int32{
		"UNSPECIFIED":  0,
		"UNSUPORTED":   1,
		"NON_EXISTENT": 2,
		"UNAVAILABLE":  3,
	}
)

func (x StandbyState_State) Enum() *StandbyState_State {
	p := new(StandbyState_State)
	*p = x
	return p
}

func (x StandbyState_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandbyState_State) Descriptor() protoreflect.EnumDescriptor {
	return file_os_proto_enumTypes[2].Descriptor()
}

func (StandbyState_State) Type() protoreflect.EnumType {
	return &file_os_proto_enumTypes[2]
}

func (x StandbyState_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandbyState_State.Descriptor instead.
func (StandbyState_State) EnumDescriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{16, 0}
}

type InstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*InstallRequest_TransferRequest
	//	*InstallRequest_TransferContent
	//	*InstallRequest_TransferEnd
	Request isInstallRequest_Request `protobuf_oneof:"request"`
}

func (x *InstallRequest) Reset() {
	*x = InstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallRequest) ProtoMessage() {}

func (x *InstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallRequest.ProtoReflect.Descriptor instead.
func (*InstallRequest) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{0}
}

func (m *InstallRequest) GetRequest() isInstallRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *InstallRequest) GetTransferRequest() *TransferRequest {
	if x, ok := x.GetRequest().(*InstallRequest_TransferRequest); ok {
		return x.TransferRequest
	}
	return nil
}

func (x *InstallRequest) GetTransferContent() []byte {
	if x, ok := x.GetRequest().(*InstallRequest_TransferContent); ok {
		return x.TransferContent
	}
	return nil
}

func (x *InstallRequest) GetTransferEnd() *TransferEnd {
	if x, ok := x.GetRequest().(*InstallRequest_TransferEnd); ok {
		return x.TransferEnd
	}
	return nil
}

type isInstallRequest_Request interface {
	isInstallRequest_Request()
}

type InstallRequest_TransferRequest struct {
	TransferRequest *TransferRequest `protobuf:"bytes,1,opt,name=transfer_request,json=transferRequest,proto3,oneof"`
}

type InstallRequest_TransferContent struct {
	TransferContent []byte `protobuf:"bytes,2,opt,name=transfer_content,json=transferContent,proto3,oneof"`
}

type InstallRequest_TransferEnd struct {
	TransferEnd *TransferEnd `protobuf:"bytes,3,opt,name=transfer_end,json=transferEnd,proto3,oneof"`
}

func (*InstallRequest_TransferRequest) isInstallRequest_Request() {}

func (*InstallRequest_TransferContent) isInstallRequest_Request() {}

func (*InstallRequest_TransferEnd) isInstallRequest_Request() {}

type TransferRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version string is a vendor defined string that identifies the OS
	// version. It is provided by the vendor and embedded in the OS package. This
	// value states the desired OS package version to transfer to the Target. If
	// the Target already has the OS package version it will reply with
	// InstallResponse->Validated. In the case that the target is a
	// single Supervisor device, or the partner Supervisor does not have the OS
	// image specified, it will respond with InstallResponse->TransferReady. In
	// this case, the client MUST subsequently transfer the image. In the case
	// that the image is available on the peer Supervisor of a dual Supervisor
	// system, it will respond with InstallResponse->SyncProgress. In this,
	// latter, case - the client does not need to transfer the OS image. This
	// value can also be set empty, in which case the OS package is forced
	// transferred to the Target. The Target MUST never validate that this value
	// matches the one in the InstallResponse->Validated message, that is the
	// Client's responsibility.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// For a Target with dual Supervisors setting this flag instructs the Target
	// to perform the action on the Standby Supervisor.
	StandbySupervisor bool `protobuf:"varint,2,opt,name=standby_supervisor,json=standbySupervisor,proto3" json:"standby_supervisor,omitempty"`
}

func (x *TransferRequest) Reset() {
	*x = TransferRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferRequest) ProtoMessage() {}

func (x *TransferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferRequest.ProtoReflect.Descriptor instead.
func (*TransferRequest) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{1}
}

func (x *TransferRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *TransferRequest) GetStandbySupervisor() bool {
	if x != nil {
		return x.StandbySupervisor
	}
	return false
}

// The TransferEnd message is sent whenever the Client finishes transferring
// the OS package to the Target. At this point the Target MUST perform a general
// health check to the OS package. If the Target fails to parse the OS package
// it MUST immediately reply with an InstallError->type->PARSE_FAIL. If the
// integrity check of the OS package fails it MUST immediately reply with an
// InstallError->type->INTEGRITY_FAIL. If the identified OS version contained in
// the package is not compatible with the Target either because of the platform
// type or the running OS, it MUST immediately reply with an
// InstallError->type->INCOMPATIBLE. If the image is force transferred by
// omitting the InstallRequest->TransferRequest->version value, and the OS
// package is the same as the one running in the Target, the RPC MUST
// immediately abort and reply with an InstallError->type->INSTALL_RUN_PACKAGE.
type TransferEnd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransferEnd) Reset() {
	*x = TransferEnd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEnd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEnd) ProtoMessage() {}

func (x *TransferEnd) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEnd.ProtoReflect.Descriptor instead.
func (*TransferEnd) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{2}
}

// The InstallResponse is used by the Target to inform the Client about the
// state of the Install RPC. At any stage of the process the Target can reply
// with an Error message which MUST terminate the stream.
type InstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*InstallResponse_TransferReady
	//	*InstallResponse_TransferProgress
	//	*InstallResponse_SyncProgress
	//	*InstallResponse_Validated
	//	*InstallResponse_InstallError
	Response isInstallResponse_Response `protobuf_oneof:"response"`
}

func (x *InstallResponse) Reset() {
	*x = InstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallResponse) ProtoMessage() {}

func (x *InstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallResponse.ProtoReflect.Descriptor instead.
func (*InstallResponse) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{3}
}

func (m *InstallResponse) GetResponse() isInstallResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *InstallResponse) GetTransferReady() *TransferReady {
	if x, ok := x.GetResponse().(*InstallResponse_TransferReady); ok {
		return x.TransferReady
	}
	return nil
}

func (x *InstallResponse) GetTransferProgress() *TransferProgress {
	if x, ok := x.GetResponse().(*InstallResponse_TransferProgress); ok {
		return x.TransferProgress
	}
	return nil
}

func (x *InstallResponse) GetSyncProgress() *SyncProgress {
	if x, ok := x.GetResponse().(*InstallResponse_SyncProgress); ok {
		return x.SyncProgress
	}
	return nil
}

func (x *InstallResponse) GetValidated() *Validated {
	if x, ok := x.GetResponse().(*InstallResponse_Validated); ok {
		return x.Validated
	}
	return nil
}

func (x *InstallResponse) GetInstallError() *InstallError {
	if x, ok := x.GetResponse().(*InstallResponse_InstallError); ok {
		return x.InstallError
	}
	return nil
}

type isInstallResponse_Response interface {
	isInstallResponse_Response()
}

type InstallResponse_TransferReady struct {
	TransferReady *TransferReady `protobuf:"bytes,1,opt,name=transfer_ready,json=transferReady,proto3,oneof"`
}

type InstallResponse_TransferProgress struct {
	TransferProgress *TransferProgress `protobuf:"bytes,2,opt,name=transfer_progress,json=transferProgress,proto3,oneof"`
}

type InstallResponse_SyncProgress struct {
	SyncProgress *SyncProgress `protobuf:"bytes,3,opt,name=sync_progress,json=syncProgress,proto3,oneof"`
}

type InstallResponse_Validated struct {
	Validated *Validated `protobuf:"bytes,4,opt,name=validated,proto3,oneof"`
}

type InstallResponse_InstallError struct {
	InstallError *InstallError `protobuf:"bytes,5,opt,name=install_error,json=installError,proto3,oneof"`
}

func (*InstallResponse_TransferReady) isInstallResponse_Response() {}

func (*InstallResponse_TransferProgress) isInstallResponse_Response() {}

func (*InstallResponse_SyncProgress) isInstallResponse_Response() {}

func (*InstallResponse_Validated) isInstallResponse_Response() {}

func (*InstallResponse_InstallError) isInstallResponse_Response() {}

// The TransferReady message tells the Client that the Target is ready to accept
// the transfer of the OS package. At this stage the Target MUST have cleared
// enough space to accept the incoming OS package.
type TransferReady struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransferReady) Reset() {
	*x = TransferReady{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferReady) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferReady) ProtoMessage() {}

func (x *TransferReady) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferReady.ProtoReflect.Descriptor instead.
func (*TransferReady) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{4}
}

// The TransferProgress message is sent by the target asynchronously during a
// file transfer. The device SHOULD not respond to each input block received
// from the client, but rather determine reasonable intervals at which to send
// the message (e.g., 5MB).
type TransferProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of bytes transferred.
	BytesReceived uint64 `protobuf:"varint,1,opt,name=bytes_received,json=bytesReceived,proto3" json:"bytes_received,omitempty"`
}

func (x *TransferProgress) Reset() {
	*x = TransferProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferProgress) ProtoMessage() {}

func (x *TransferProgress) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferProgress.ProtoReflect.Descriptor instead.
func (*TransferProgress) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{5}
}

func (x *TransferProgress) GetBytesReceived() uint64 {
	if x != nil {
		return x.BytesReceived
	}
	return 0
}

// The SyncProgress message signals the Client about the progress of
// transferring the OS package between Supervisors.
type SyncProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage that has transferred between Supervisors.
	PercentageTransferred uint32 `protobuf:"varint,1,opt,name=percentage_transferred,json=percentageTransferred,proto3" json:"percentage_transferred,omitempty"`
}

func (x *SyncProgress) Reset() {
	*x = SyncProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncProgress) ProtoMessage() {}

func (x *SyncProgress) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncProgress.ProtoReflect.Descriptor instead.
func (*SyncProgress) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{6}
}

func (x *SyncProgress) GetPercentageTransferred() uint32 {
	if x != nil {
		return x.PercentageTransferred
	}
	return 0
}

// The Validated message asserts that the Target was able to parse the package
// and perform integrity checks to its contents.
type Validated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OS version string that identifies the OS version in the OS package.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Informational field that SHOULD be used for providing more details about
	// the OS package and its version. This MUST be strictly informational if
	// used, and can contain information such as build date, target platform,
	// developer, etc.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Validated) Reset() {
	*x = Validated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Validated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Validated) ProtoMessage() {}

func (x *Validated) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Validated.ProtoReflect.Descriptor instead.
func (*Validated) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{7}
}

func (x *Validated) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Validated) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The InstallError message MUST be sent by the Target to the Client whenever an
// issue occurs. The Target MUST immediately close the RPC without a gRPC error.
type InstallError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type   InstallError_Type `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.os.InstallError_Type" json:"type,omitempty"`
	Detail string            `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *InstallError) Reset() {
	*x = InstallError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallError) ProtoMessage() {}

func (x *InstallError) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallError.ProtoReflect.Descriptor instead.
func (*InstallError) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{8}
}

func (x *InstallError) GetType() InstallError_Type {
	if x != nil {
		return x.Type
	}
	return InstallError_UNSPECIFIED
}

func (x *InstallError) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// The ActivateRequest is sent by the Client to the Target to initiate a change
// in the next bootable OS version that is to be used on the Target.
type ActivateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version that is required to be activated and booted.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// For dual Supervisors setting this flag instructs the Target to perform the
	// action on the Standby Supervisor.
	StandbySupervisor bool `protobuf:"varint,2,opt,name=standby_supervisor,json=standbySupervisor,proto3" json:"standby_supervisor,omitempty"`
}

func (x *ActivateRequest) Reset() {
	*x = ActivateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateRequest) ProtoMessage() {}

func (x *ActivateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateRequest.ProtoReflect.Descriptor instead.
func (*ActivateRequest) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{9}
}

func (x *ActivateRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ActivateRequest) GetStandbySupervisor() bool {
	if x != nil {
		return x.StandbySupervisor
	}
	return false
}

// The ActivateResponse is sent from the Target to the Client in response to the
// Activate RPC. It indicates the success of making the OS package version
// active.
type ActivateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*ActivateResponse_ActivateOk
	//	*ActivateResponse_ActivateError
	Response isActivateResponse_Response `protobuf_oneof:"response"`
}

func (x *ActivateResponse) Reset() {
	*x = ActivateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateResponse) ProtoMessage() {}

func (x *ActivateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateResponse.ProtoReflect.Descriptor instead.
func (*ActivateResponse) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{10}
}

func (m *ActivateResponse) GetResponse() isActivateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ActivateResponse) GetActivateOk() *ActivateOK {
	if x, ok := x.GetResponse().(*ActivateResponse_ActivateOk); ok {
		return x.ActivateOk
	}
	return nil
}

func (x *ActivateResponse) GetActivateError() *ActivateError {
	if x, ok := x.GetResponse().(*ActivateResponse_ActivateError); ok {
		return x.ActivateError
	}
	return nil
}

type isActivateResponse_Response interface {
	isActivateResponse_Response()
}

type ActivateResponse_ActivateOk struct {
	ActivateOk *ActivateOK `protobuf:"bytes,1,opt,name=activate_ok,json=activateOk,proto3,oneof"`
}

type ActivateResponse_ActivateError struct {
	ActivateError *ActivateError `protobuf:"bytes,2,opt,name=activate_error,json=activateError,proto3,oneof"`
}

func (*ActivateResponse_ActivateOk) isActivateResponse_Response() {}

func (*ActivateResponse_ActivateError) isActivateResponse_Response() {}

// If the Target is already running the requested version in ActivateRequest,
// then it replies with ActivateOK. If the Target has the OS package version
// requested in ActivateRequest then it replies with ActivateOK and proceeds to
// boot. In a Target with dual Supervisor, performing this RPC on the Active
// Supervisor triggers a switchover before booting the (old)Active Supervisor.
// The Target should always perform a switchover with the least impact possible
// to forwarding.
type ActivateOK struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ActivateOK) Reset() {
	*x = ActivateOK{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateOK) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateOK) ProtoMessage() {}

func (x *ActivateOK) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateOK.ProtoReflect.Descriptor instead.
func (*ActivateOK) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{11}
}

type ActivateError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type   ActivateError_Type `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.os.ActivateError_Type" json:"type,omitempty"`
	Detail string             `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ActivateError) Reset() {
	*x = ActivateError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateError) ProtoMessage() {}

func (x *ActivateError) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateError.ProtoReflect.Descriptor instead.
func (*ActivateError) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{12}
}

func (x *ActivateError) GetType() ActivateError_Type {
	if x != nil {
		return x.Type
	}
	return ActivateError_UNSPECIFIED
}

func (x *ActivateError) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

type VerifyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VerifyRequest) Reset() {
	*x = VerifyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyRequest) ProtoMessage() {}

func (x *VerifyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyRequest.ProtoReflect.Descriptor instead.
func (*VerifyRequest) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{13}
}

type VerifyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OS version currently running.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Informational message describing fail details of the last boot. This MUST
	// be set when a newly transferred OS fails to boot and the system falls back
	// to the previously running OS version. It MUST be cleared whenever the
	// systems successfully boots the activated OS version.
	ActivationFailMessage string         `protobuf:"bytes,2,opt,name=activation_fail_message,json=activationFailMessage,proto3" json:"activation_fail_message,omitempty"`
	VerifyStandby         *VerifyStandby `protobuf:"bytes,3,opt,name=verify_standby,json=verifyStandby,proto3" json:"verify_standby,omitempty"`
}

func (x *VerifyResponse) Reset() {
	*x = VerifyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyResponse) ProtoMessage() {}

func (x *VerifyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyResponse.ProtoReflect.Descriptor instead.
func (*VerifyResponse) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{14}
}

func (x *VerifyResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VerifyResponse) GetActivationFailMessage() string {
	if x != nil {
		return x.ActivationFailMessage
	}
	return ""
}

func (x *VerifyResponse) GetVerifyStandby() *VerifyStandby {
	if x != nil {
		return x.VerifyStandby
	}
	return nil
}

type VerifyStandby struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to State:
	//	*VerifyStandby_StandbyState
	//	*VerifyStandby_VerifyResponse
	State isVerifyStandby_State `protobuf_oneof:"state"`
}

func (x *VerifyStandby) Reset() {
	*x = VerifyStandby{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyStandby) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyStandby) ProtoMessage() {}

func (x *VerifyStandby) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyStandby.ProtoReflect.Descriptor instead.
func (*VerifyStandby) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{15}
}

func (m *VerifyStandby) GetState() isVerifyStandby_State {
	if m != nil {
		return m.State
	}
	return nil
}

func (x *VerifyStandby) GetStandbyState() *StandbyState {
	if x, ok := x.GetState().(*VerifyStandby_StandbyState); ok {
		return x.StandbyState
	}
	return nil
}

func (x *VerifyStandby) GetVerifyResponse() *StandbyResponse {
	if x, ok := x.GetState().(*VerifyStandby_VerifyResponse); ok {
		return x.VerifyResponse
	}
	return nil
}

type isVerifyStandby_State interface {
	isVerifyStandby_State()
}

type VerifyStandby_StandbyState struct {
	StandbyState *StandbyState `protobuf:"bytes,1,opt,name=standby_state,json=standbyState,proto3,oneof"`
}

type VerifyStandby_VerifyResponse struct {
	VerifyResponse *StandbyResponse `protobuf:"bytes,2,opt,name=verify_response,json=verifyResponse,proto3,oneof"`
}

func (*VerifyStandby_StandbyState) isVerifyStandby_State() {}

func (*VerifyStandby_VerifyResponse) isVerifyStandby_State() {}

type StandbyState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State StandbyState_State `protobuf:"varint,1,opt,name=state,proto3,enum=gnoi.os.StandbyState_State" json:"state,omitempty"`
}

func (x *StandbyState) Reset() {
	*x = StandbyState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandbyState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandbyState) ProtoMessage() {}

func (x *StandbyState) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandbyState.ProtoReflect.Descriptor instead.
func (*StandbyState) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{16}
}

func (x *StandbyState) GetState() StandbyState_State {
	if x != nil {
		return x.State
	}
	return StandbyState_UNSPECIFIED
}

type StandbyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Standby Supervisor ID, usually the slot number.
	Id                    string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Version               string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	ActivationFailMessage string `protobuf:"bytes,3,opt,name=activation_fail_message,json=activationFailMessage,proto3" json:"activation_fail_message,omitempty"`
}

func (x *StandbyResponse) Reset() {
	*x = StandbyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_os_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandbyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandbyResponse) ProtoMessage() {}

func (x *StandbyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_os_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandbyResponse.ProtoReflect.Descriptor instead.
func (*StandbyResponse) Descriptor() ([]byte, []int) {
	return file_os_proto_rawDescGZIP(), []int{17}
}

func (x *StandbyResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *StandbyResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *StandbyResponse) GetActivationFailMessage() string {
	if x != nil {
		return x.ActivationFailMessage
	}
	return ""
}

var File_os_proto protoreflect.FileDescriptor

var file_os_proto_rawDesc = []byte{
	0x0a, 0x08, 0x6f, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x67, 0x6e, 0x6f, 0x69,
	0x2e, 0x6f, 0x73, 0x22, 0xca, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0c, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x45, 0x6e, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0x5a, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a,
	0x12, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x5f, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64,
	0x62, 0x79, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x22, 0x0d, 0x0a, 0x0b,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x22, 0xd8, 0x02, 0x0a, 0x0f,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3f, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f,
	0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x65, 0x61, 0x64, 0x79, 0x48,
	0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x65, 0x61, 0x64, 0x79,
	0x12, 0x48, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6e,
	0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x73, 0x79,
	0x6e, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x53, 0x79, 0x6e, 0x63,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x79, 0x6e, 0x63,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x32, 0x0a, 0x09, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6e,
	0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x3c, 0x0a, 0x0d,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x0f, 0x0a, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x52, 0x65, 0x61, 0x64, 0x79, 0x22, 0x39, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x64, 0x22, 0x45, 0x0a, 0x0c, 0x53, 0x79, 0x6e, 0x63, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x35, 0x0a, 0x16, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x15, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x22, 0x47, 0x0a, 0x09, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x91, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1a, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xb8, 0x01, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41,
	0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x4f, 0x4f, 0x5f, 0x4c,
	0x41, 0x52, 0x47, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x41, 0x52, 0x53, 0x45, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52,
	0x49, 0x54, 0x59, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47,
	0x45, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15,
	0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x57, 0x49, 0x54, 0x43,
	0x48, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x59, 0x4e, 0x43, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x10, 0x08, 0x22, 0x5a, 0x0a, 0x0f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x5f, 0x73,
	0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73,
	0x6f, 0x72, 0x22, 0x97, 0x01, 0x0a, 0x10, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4f,
	0x4b, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4f, 0x6b, 0x12,
	0x3f, 0x0a, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f,
	0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48,
	0x00, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x0c, 0x0a, 0x0a,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4f, 0x4b, 0x22, 0x8b, 0x01, 0x0a, 0x0d, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2f, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x67, 0x6e, 0x6f,
	0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x31, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18,
	0x0a, 0x14, 0x4e, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x22, 0x0f, 0x0a, 0x0d, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x0e, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3d,
	0x0a, 0x0e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73,
	0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x52, 0x0d,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x22, 0x9b, 0x01,
	0x0a, 0x0d, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x12,
	0x3c, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x0c, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x43, 0x0a,
	0x0f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x0c,
	0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x67, 0x6e,
	0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x4b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x53,
	0x55, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x4e,
	0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x55,
	0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0x73, 0x0a, 0x0f,
	0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x32, 0xc2, 0x01, 0x0a, 0x02, 0x4f, 0x53, 0x12, 0x40, 0x0a, 0x07, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x12, 0x17, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x12, 0x3f, 0x0a, 0x08, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x18, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x19, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x16, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e,
	0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x6f, 0x73, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x23, 0x5a, 0x21, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x6e, 0x78, 0x69,
	0x2f, 0x67, 0x6e, 0x6f, 0x69, 0x2f, 0x6f, 0x73, 0x2f, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_os_proto_rawDescOnce sync.Once
	file_os_proto_rawDescData = file_os_proto_rawDesc
)

func file_os_proto_rawDescGZIP() []byte {
	file_os_proto_rawDescOnce.Do(func() {
		file_os_proto_rawDescData = protoimpl.X.CompressGZIP(file_os_proto_rawDescData)
	})
	return file_os_proto_rawDescData
}

var file_os_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_os_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_os_proto_goTypes = []interface{}{
	(InstallError_Type)(0),   // 0: gnoi.os.InstallError.Type
	(ActivateError_Type)(0),  // 1: gnoi.os.ActivateError.Type
	(StandbyState_State)(0),  // 2: gnoi.os.StandbyState.State
	(*InstallRequest)(nil),   // 3: gnoi.os.InstallRequest
	(*TransferRequest)(nil),  // 4: gnoi.os.TransferRequest
	(*TransferEnd)(nil),      // 5: gnoi.os.TransferEnd
	(*InstallResponse)(nil),  // 6: gnoi.os.InstallResponse
	(*TransferReady)(nil),    // 7: gnoi.os.TransferReady
	(*TransferProgress)(nil), // 8: gnoi.os.TransferProgress
	(*SyncProgress)(nil),     // 9: gnoi.os.SyncProgress
	(*Validated)(nil),        // 10: gnoi.os.Validated
	(*InstallError)(nil),     // 11: gnoi.os.InstallError
	(*ActivateRequest)(nil),  // 12: gnoi.os.ActivateRequest
	(*ActivateResponse)(nil), // 13: gnoi.os.ActivateResponse
	(*ActivateOK)(nil),       // 14: gnoi.os.ActivateOK
	(*ActivateError)(nil),    // 15: gnoi.os.ActivateError
	(*VerifyRequest)(nil),    // 16: gnoi.os.VerifyRequest
	(*VerifyResponse)(nil),   // 17: gnoi.os.VerifyResponse
	(*VerifyStandby)(nil),    // 18: gnoi.os.VerifyStandby
	(*StandbyState)(nil),     // 19: gnoi.os.StandbyState
	(*StandbyResponse)(nil),  // 20: gnoi.os.StandbyResponse
}
var file_os_proto_depIdxs = []int32{
	4,  // 0: gnoi.os.InstallRequest.transfer_request:type_name -> gnoi.os.TransferRequest
	5,  // 1: gnoi.os.InstallRequest.transfer_end:type_name -> gnoi.os.TransferEnd
	7,  // 2: gnoi.os.InstallResponse.transfer_ready:type_name -> gnoi.os.TransferReady
	8,  // 3: gnoi.os.InstallResponse.transfer_progress:type_name -> gnoi.os.TransferProgress
	9,  // 4: gnoi.os.InstallResponse.sync_progress:type_name -> gnoi.os.SyncProgress
	10, // 5: gnoi.os.InstallResponse.validated:type_name -> gnoi.os.Validated
	11, // 6: gnoi.os.InstallResponse.install_error:type_name -> gnoi.os.InstallError
	0,  // 7: gnoi.os.InstallError.type:type_name -> gnoi.os.InstallError.Type
	14, // 8: gnoi.os.ActivateResponse.activate_ok:type_name -> gnoi.os.ActivateOK
	15, // 9: gnoi.os.ActivateResponse.activate_error:type_name -> gnoi.os.ActivateError
	1,  // 10: gnoi.os.ActivateError.type:type_name -> gnoi.os.ActivateError.Type
	18, // 11: gnoi.os.VerifyResponse.verify_standby:type_name -> gnoi.os.VerifyStandby
	19, // 12: gnoi.os.VerifyStandby.standby_state:type_name -> gnoi.os.StandbyState
	20, // 13: gnoi.os.VerifyStandby.verify_response:type_name -> gnoi.os.StandbyResponse
	2,  // 14: gnoi.os.StandbyState.state:type_name -> gnoi.os.StandbyState.State
	3,  // 15: gnoi.os.OS.Install:input_type -> gnoi.os.InstallRequest
	12, // 16: gnoi.os.OS.Activate:input_type -> gnoi.os.ActivateRequest
	16, // 17: gnoi.os.OS.Verify:input_type -> gnoi.os.VerifyRequest
	6,  // 18: gnoi.os.OS.Install:output_type -> gnoi.os.InstallResponse
	13, // 19: gnoi.os.OS.Activate:output_type -> gnoi.os.ActivateResponse
	17, // 20: gnoi.os.OS.Verify:output_type -> gnoi.os.VerifyResponse
	18, // [18:21] is the sub-list for method output_type
	15, // [15:18] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_os_proto_init() }
func file_os_proto_init() {
	if File_os_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_os_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEnd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferReady); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Validated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateOK); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyStandby); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandbyState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_os_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandbyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_os_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*InstallRequest_TransferRequest)(nil),
		(*InstallRequest_TransferContent)(nil),
		(*InstallRequest_TransferEnd)(nil),
	}
	file_os_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*InstallResponse_TransferReady)(nil),
		(*InstallResponse_TransferProgress)(nil),
		(*InstallResponse_SyncProgress)(nil),
		(*InstallResponse_Validated)(nil),
		(*InstallResponse_InstallError)(nil),
	}
	file_os_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ActivateResponse_ActivateOk)(nil),
		(*ActivateResponse_ActivateError)(nil),
	}
	file_os_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*VerifyStandby_StandbyState)(nil),
		(*VerifyStandby_VerifyResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_os_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_os_proto_goTypes,
		DependencyIndexes: file_os_proto_depIdxs,
		EnumInfos:         file_os_proto_enumTypes,
		MessageInfos:      file_os_proto_msgTypes,
	}.Build()
	File_os_proto = out.File
	file_os_proto_rawDesc = nil
	file_os_proto_goTypes = nil
	file_os_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OSClient is the client API for OS service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OSClient interface {
	// Install transfers an OS package into the Target. No concurrent Install RPCs
	// MUST be allowed to the same Target.
	//
	// The OS package file format is platform dependent. The platform MUST
	// validate that the OS package that is supplied is valid and bootable. This
	// SHOULD include a hash check against a known good hash. It is recommended
	// that the hash is embedded in the OS package.
	//
	// The Target manages its own persistent storage, and OS installation process.
	// It stores a set of distinct OS packages, and always proactively frees up
	// space for incoming new OS packages. It is guaranteed that the Target always
	// has enough space for a valid incoming OS package. The currently running OS
	// packages MUST never be removed. The Client MUST expect that the last
	// successfully installed package is available.
	//
	// The Install RPC allows the Client to specify the OS package version. If
	// the Target already has an OS package with the same version then there is no
	// need to transfer the OS package to the Target. If the Target does not have
	// an OS package with the same version, then the OS package is copied.
	//
	// Scenario 1 - When the Target already has the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 2 - When the Target does not have the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [TransferReady|InstallError]
	//            transfer_content  -->
	//                              ...
	//                              <-- [TransferProgress|InstallError]
	//                              ...
	//                  TransferEnd -->
	//                              <-- [Validated|InstallError]
	//
	// On a dual Supervisor Target, only the Active Supervisor runs this gNOI
	// Service. The Install RPC applies to the Active Supervisor unless
	// InstallRequest->TransferRequest->standby_supervisor is set, in which case
	// it applies to the Standby Supervisor. One Install RPC is required for each
	// Supervisor. The Supervisor order of package installation MUST not be fixed.
	//
	// The Target MUST always attempt to copy the OS package between Supervisors
	// first before accepting the transfer from the Client. The syncing progress
	// is reported to the client with InstallResponse->SyncProgress messages.
	//
	// If a switchover is triggered during the Install RPC, the RPC MUST
	// immediately abort with Error->type->UNEXPECTED_SWITCHOVER.
	//
	// Scenario 3 - When both Supervisors already have the OS package, regardless
	//              of the value in Start.standby_supervisor:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 4 - When one of the Supervisors already has the OS package but the
	//              other Supervisor is the target of the Install:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [SyncProgress|InstallError]
	//                              ...
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 5 - When neither of the two Supervisors has the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [TransferReady|InstallError]
	//            transfer_content  -->
	//                              ...
	//                              <-- [TransferProgress|InstallError]
	//                              ...
	//                  TransferEnd -->
	//                              <-- [Validated|InstallError]
	//
	Install(ctx context.Context, opts ...grpc.CallOption) (OS_InstallClient, error)
	// Activate sets the requested OS version as the version which is used at the
	// next reboot, and reboots the Target. When booting the requested OS version
	// fails, the Target recovers by booting the previously running OS package.
	Activate(ctx context.Context, in *ActivateRequest, opts ...grpc.CallOption) (*ActivateResponse, error)
	// Verify checks the running OS version. This RPC may be called multiple times
	// while the Target boots, until successful.
	Verify(ctx context.Context, in *VerifyRequest, opts ...grpc.CallOption) (*VerifyResponse, error)
}

type oSClient struct {
	cc grpc.ClientConnInterface
}

func NewOSClient(cc grpc.ClientConnInterface) OSClient {
	return &oSClient{cc}
}

func (c *oSClient) Install(ctx context.Context, opts ...grpc.CallOption) (OS_InstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_OS_serviceDesc.Streams[0], "/gnoi.os.OS/Install", opts...)
	if err != nil {
		return nil, err
	}
	x := &oSInstallClient{stream}
	return x, nil
}

type OS_InstallClient interface {
	Send(*InstallRequest) error
	Recv() (*InstallResponse, error)
	grpc.ClientStream
}

type oSInstallClient struct {
	grpc.ClientStream
}

func (x *oSInstallClient) Send(m *InstallRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *oSInstallClient) Recv() (*InstallResponse, error) {
	m := new(InstallResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *oSClient) Activate(ctx context.Context, in *ActivateRequest, opts ...grpc.CallOption) (*ActivateResponse, error) {
	out := new(ActivateResponse)
	err := c.cc.Invoke(ctx, "/gnoi.os.OS/Activate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oSClient) Verify(ctx context.Context, in *VerifyRequest, opts ...grpc.CallOption) (*VerifyResponse, error) {
	out := new(VerifyResponse)
	err := c.cc.Invoke(ctx, "/gnoi.os.OS/Verify", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OSServer is the server API for OS service.
type OSServer interface {
	// Install transfers an OS package into the Target. No concurrent Install RPCs
	// MUST be allowed to the same Target.
	//
	// The OS package file format is platform dependent. The platform MUST
	// validate that the OS package that is supplied is valid and bootable. This
	// SHOULD include a hash check against a known good hash. It is recommended
	// that the hash is embedded in the OS package.
	//
	// The Target manages its own persistent storage, and OS installation process.
	// It stores a set of distinct OS packages, and always proactively frees up
	// space for incoming new OS packages. It is guaranteed that the Target always
	// has enough space for a valid incoming OS package. The currently running OS
	// packages MUST never be removed. The Client MUST expect that the last
	// successfully installed package is available.
	//
	// The Install RPC allows the Client to specify the OS package version. If
	// the Target already has an OS package with the same version then there is no
	// need to transfer the OS package to the Target. If the Target does not have
	// an OS package with the same version, then the OS package is copied.
	//
	// Scenario 1 - When the Target already has the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 2 - When the Target does not have the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [TransferReady|InstallError]
	//            transfer_content  -->
	//                              ...
	//                              <-- [TransferProgress|InstallError]
	//                              ...
	//                  TransferEnd -->
	//                              <-- [Validated|InstallError]
	//
	// On a dual Supervisor Target, only the Active Supervisor runs this gNOI
	// Service. The Install RPC applies to the Active Supervisor unless
	// InstallRequest->TransferRequest->standby_supervisor is set, in which case
	// it applies to the Standby Supervisor. One Install RPC is required for each
	// Supervisor. The Supervisor order of package installation MUST not be fixed.
	//
	// The Target MUST always attempt to copy the OS package between Supervisors
	// first before accepting the transfer from the Client. The syncing progress
	// is reported to the client with InstallResponse->SyncProgress messages.
	//
	// If a switchover is triggered during the Install RPC, the RPC MUST
	// immediately abort with Error->type->UNEXPECTED_SWITCHOVER.
	//
	// Scenario 3 - When both Supervisors already have the OS package, regardless
	//              of the value in Start.standby_supervisor:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 4 - When one of the Supervisors already has the OS package but the
	//              other Supervisor is the target of the Install:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [SyncProgress|InstallError]
	//                              ...
	//                              <-- [Validated|InstallError]
	//
	//
	// Scenario 5 - When neither of the two Supervisors has the OS package:
	//
	//         Client :--------------|--------------> Target
	//              TransferRequest -->
	//                              <-- [TransferReady|InstallError]
	//            transfer_content  -->
	//                              ...
	//                              <-- [TransferProgress|InstallError]
	//                              ...
	//                  TransferEnd -->
	//                              <-- [Validated|InstallError]
	//
	Install(OS_InstallServer) error
	// Activate sets the requested OS version as the version which is used at the
	// next reboot, and reboots the Target. When booting the requested OS version
	// fails, the Target recovers by booting the previously running OS package.
	Activate(context.Context, *ActivateRequest) (*ActivateResponse, error)
	// Verify checks the running OS version. This RPC may be called multiple times
	// while the Target boots, until successful.
	Verify(context.Context, *VerifyRequest) (*VerifyResponse, error)
}

// UnimplementedOSServer can be embedded to have forward compatible implementations.
type UnimplementedOSServer struct {
}

func (*UnimplementedOSServer) Install(OS_InstallServer) error {
	return status.Errorf(codes.Unimplemented, "method Install not implemented")
}
func (*UnimplementedOSServer) Activate(context.Context, *ActivateRequest) (*ActivateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Activate not implemented")
}
func (*UnimplementedOSServer) Verify(context.Context, *VerifyRequest) (*VerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Verify not implemented")
}

func RegisterOSServer(s *grpc.Server, srv OSServer) {
	s.RegisterService(&_OS_serviceDesc, srv)
}

func _OS_Install_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OSServer).Install(&oSInstallServer{stream})
}

type OS_InstallServer interface {
	Send(*InstallResponse) error
	Recv() (*InstallRequest, error)
	grpc.ServerStream
}

type oSInstallServer struct {
	grpc.ServerStream
}

func (x *oSInstallServer) Send(m *InstallResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *oSInstallServer) Recv() (*InstallRequest, error) {
	m := new(InstallRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _OS_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OSServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnoi.os.OS/Activate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OSServer).Activate(ctx, req.(*ActivateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OS_Verify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OSServer).Verify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnoi.os.OS/Verify",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OSServer).Verify(ctx, req.(*VerifyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OS_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gnoi.os.OS",
	HandlerType: (*OSServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Activate",
			Handler:    _OS_Activate_Handler,
		},
		{
			MethodName: "Verify",
			Handler:    _OS_Verify_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Install",
			Handler:       _OS_Install_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "os.proto",
}
