# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_classification_openconfig_module_catalog__organizations_organization_modules_module_classification(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/classification. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for data describing the module's classification
  """
  __slots__ = ('_path_helper', '_extmethods', '__category','__subcategory','__deployment_status',)

  _yang_name = 'classification'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__category = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="category", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    self.__subcategory = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="subcategory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    self.__deployment_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="deployment-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'classification']

  def _get_category(self):
    """
    Getter method for category, mapped from YANG variable /organizations/organization/modules/module/classification/category (identityref)

    YANG Description: Categorization of the module based on identities defined
or used by the publishing organizations.
    """
    return self.__category
      
  def _set_category(self, v, load=False):
    """
    Setter method for category, mapped from YANG variable /organizations/organization/modules/module/classification/category (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_category is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_category() directly.

    YANG Description: Categorization of the module based on identities defined
or used by the publishing organizations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="category", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """category must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="category", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__category = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_category(self):
    self.__category = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_LAYER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_SERVICE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_NETWORK_ELEMENT': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="category", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)


  def _get_subcategory(self):
    """
    Getter method for subcategory, mapped from YANG variable /organizations/organization/modules/module/classification/subcategory (identityref)

    YANG Description: Sub-categorization of the module based on identities
defined or used by the publishing organizations.
    """
    return self.__subcategory
      
  def _set_subcategory(self, v, load=False):
    """
    Setter method for subcategory, mapped from YANG variable /organizations/organization/modules/module/classification/subcategory (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subcategory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subcategory() directly.

    YANG Description: Sub-categorization of the module based on identities
defined or used by the publishing organizations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="subcategory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subcategory must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="subcategory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__subcategory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subcategory(self):
    self.__subcategory = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_MODEL_TYPE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_STANDARD': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_VENDOR': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IETF_TYPE_USER': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="subcategory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)


  def _get_deployment_status(self):
    """
    Getter method for deployment_status, mapped from YANG variable /organizations/organization/modules/module/classification/deployment_status (identityref)

    YANG Description: Deployment status of the module -- experimental,
standards-track, production, etc.
    """
    return self.__deployment_status
      
  def _set_deployment_status(self, v, load=False):
    """
    Setter method for deployment_status, mapped from YANG variable /organizations/organization/modules/module/classification/deployment_status (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_deployment_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_deployment_status() directly.

    YANG Description: Deployment status of the module -- experimental,
standards-track, production, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="deployment-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """deployment_status must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="deployment-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__deployment_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_deployment_status(self):
    self.__deployment_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:EXPERIMENTAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PRODUCTION': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="deployment-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)

  category = __builtin__.property(_get_category, _set_category)
  subcategory = __builtin__.property(_get_subcategory, _set_subcategory)
  deployment_status = __builtin__.property(_get_deployment_status, _set_deployment_status)


  _pyangbind_elements = OrderedDict([('category', category), ('subcategory', subcategory), ('deployment_status', deployment_status), ])


class yc_dependencies_openconfig_module_catalog__organizations_organization_modules_module_dependencies(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/dependencies. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data about dependencies of the module
  """
  __slots__ = ('_path_helper', '_extmethods', '__required_module',)

  _yang_name = 'dependencies'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__required_module = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="required-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'dependencies']

  def _get_required_module(self):
    """
    Getter method for required_module, mapped from YANG variable /organizations/organization/modules/module/dependencies/required_module (string)

    YANG Description: List of names of modules that are imported by the
current module.  This list should reflect all of the 'import'
statements in the module.  Release bundles should be used to
indicate which versions of the imported module are used
(or are compatible) with the current module
    """
    return self.__required_module
      
  def _set_required_module(self, v, load=False):
    """
    Setter method for required_module, mapped from YANG variable /organizations/organization/modules/module/dependencies/required_module (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_required_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_required_module() directly.

    YANG Description: List of names of modules that are imported by the
current module.  This list should reflect all of the 'import'
statements in the module.  Release bundles should be used to
indicate which versions of the imported module are used
(or are compatible) with the current module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="required-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """required_module must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="required-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__required_module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_required_module(self):
    self.__required_module = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="required-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

  required_module = __builtin__.property(_get_required_module, _set_required_module)


  _pyangbind_elements = OrderedDict([('required_module', required_module), ])


class yc_access_openconfig_module_catalog__organizations_organization_modules_module_access(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/access. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for data pertaining to retrieval and usage of the
module
  """
  __slots__ = ('_path_helper', '_extmethods', '__uri','__md5_hash',)

  _yang_name = 'access'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__uri = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)
    self.__md5_hash = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'access']

  def _get_uri(self):
    """
    Getter method for uri, mapped from YANG variable /organizations/organization/modules/module/access/uri (oc-inet:uri)

    YANG Description: URI where module can be downloaded.  Modules may be
made available from the catalog maintainer, or directly
from the publisher
    """
    return self.__uri
      
  def _set_uri(self, v, load=False):
    """
    Setter method for uri, mapped from YANG variable /organizations/organization/modules/module/access/uri (oc-inet:uri)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_uri is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_uri() directly.

    YANG Description: URI where module can be downloaded.  Modules may be
made available from the catalog maintainer, or directly
from the publisher
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """uri must be of a type compatible with oc-inet:uri""",
          'defined-type': "oc-inet:uri",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)""",
        })

    self.__uri = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_uri(self):
    self.__uri = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)


  def _get_md5_hash(self):
    """
    Getter method for md5_hash, mapped from YANG variable /organizations/organization/modules/module/access/md5_hash (string)

    YANG Description: Optional MD5 hash of the module file.  If specified, the
hash may be used by users to validate data integrity
    """
    return self.__md5_hash
      
  def _set_md5_hash(self, v, load=False):
    """
    Setter method for md5_hash, mapped from YANG variable /organizations/organization/modules/module/access/md5_hash (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_md5_hash is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_md5_hash() directly.

    YANG Description: Optional MD5 hash of the module file.  If specified, the
hash may be used by users to validate data integrity
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """md5_hash must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__md5_hash = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_md5_hash(self):
    self.__md5_hash = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

  uri = __builtin__.property(_get_uri, _set_uri)
  md5_hash = __builtin__.property(_get_md5_hash, _set_md5_hash)


  _pyangbind_elements = OrderedDict([('uri', uri), ('md5_hash', md5_hash), ])


class yc_access_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule_access(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/submodules/submodule/access. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for data pertaining to retrieval and usage of the
module
  """
  __slots__ = ('_path_helper', '_extmethods', '__uri','__md5_hash',)

  _yang_name = 'access'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__uri = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)
    self.__md5_hash = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'submodules', 'submodule', 'access']

  def _get_uri(self):
    """
    Getter method for uri, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access/uri (oc-inet:uri)

    YANG Description: URI where module can be downloaded.  Modules may be
made available from the catalog maintainer, or directly
from the publisher
    """
    return self.__uri
      
  def _set_uri(self, v, load=False):
    """
    Setter method for uri, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access/uri (oc-inet:uri)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_uri is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_uri() directly.

    YANG Description: URI where module can be downloaded.  Modules may be
made available from the catalog maintainer, or directly
from the publisher
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """uri must be of a type compatible with oc-inet:uri""",
          'defined-type': "oc-inet:uri",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)""",
        })

    self.__uri = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_uri(self):
    self.__uri = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="uri", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-inet:uri', is_config=True)


  def _get_md5_hash(self):
    """
    Getter method for md5_hash, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access/md5_hash (string)

    YANG Description: Optional MD5 hash of the module file.  If specified, the
hash may be used by users to validate data integrity
    """
    return self.__md5_hash
      
  def _set_md5_hash(self, v, load=False):
    """
    Setter method for md5_hash, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access/md5_hash (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_md5_hash is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_md5_hash() directly.

    YANG Description: Optional MD5 hash of the module file.  If specified, the
hash may be used by users to validate data integrity
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """md5_hash must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__md5_hash = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_md5_hash(self):
    self.__md5_hash = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="md5-hash", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)

  uri = __builtin__.property(_get_uri, _set_uri)
  md5_hash = __builtin__.property(_get_md5_hash, _set_md5_hash)


  _pyangbind_elements = OrderedDict([('uri', uri), ('md5_hash', md5_hash), ])


class yc_submodule_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/submodules/submodule. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of submodules included by a module.  All submodules
specified by 'include' statements in the module should be
included in this list.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__access',)

  _yang_name = 'submodule'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__access = YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'submodules', 'submodule']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/name (string)

    YANG Description: Name of the submodule as indicated by its top-level
'submodule' statement
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the submodule as indicated by its top-level
'submodule' statement
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_access(self):
    """
    Getter method for access, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access (container)

    YANG Description: Container for data pertaining to retrieval and usage of the
module
    """
    return self.__access
      
  def _set_access(self, v, load=False):
    """
    Setter method for access, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule/access (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_access is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_access() directly.

    YANG Description: Container for data pertaining to retrieval and usage of the
module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """access must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__access = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_access(self):
    self.__access = YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  access = __builtin__.property(_get_access, _set_access)


  _pyangbind_elements = OrderedDict([('name', name), ('access', access), ])


class yc_submodules_openconfig_module_catalog__organizations_organization_modules_module_submodules(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module/submodules. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for the submodules belonging to a submodule. If the
module does not have any submodules, this container
should be empty.
  """
  __slots__ = ('_path_helper', '_extmethods', '__submodule',)

  _yang_name = 'submodules'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__submodule = YANGDynClass(base=YANGListType("name",yc_submodule_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule, yang_name="submodule", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="submodule", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module', 'submodules']

  def _get_submodule(self):
    """
    Getter method for submodule, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule (list)

    YANG Description: List of submodules included by a module.  All submodules
specified by 'include' statements in the module should be
included in this list.
    """
    return self.__submodule
      
  def _set_submodule(self, v, load=False):
    """
    Setter method for submodule, mapped from YANG variable /organizations/organization/modules/module/submodules/submodule (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_submodule is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_submodule() directly.

    YANG Description: List of submodules included by a module.  All submodules
specified by 'include' statements in the module should be
included in this list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_submodule_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule, yang_name="submodule", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="submodule", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """submodule must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_submodule_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule, yang_name="submodule", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="submodule", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__submodule = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_submodule(self):
    self.__submodule = YANGDynClass(base=YANGListType("name",yc_submodule_openconfig_module_catalog__organizations_organization_modules_module_submodules_submodule, yang_name="submodule", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="submodule", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  submodule = __builtin__.property(_get_submodule, _set_submodule)


  _pyangbind_elements = OrderedDict([('submodule', submodule), ])


class yc_module_openconfig_module_catalog__organizations_organization_modules_module(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules/module. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of published modules from the organization
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__version','__namespace','__prefix','__revision','__summary','__classification','__dependencies','__access','__submodules',)

  _yang_name = 'module'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    self.__namespace = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="namespace", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__prefix = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__revision = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__summary = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="summary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__classification = YANGDynClass(base=yc_classification_openconfig_module_catalog__organizations_organization_modules_module_classification, is_container='container', yang_name="classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__dependencies = YANGDynClass(base=yc_dependencies_openconfig_module_catalog__organizations_organization_modules_module_dependencies, is_container='container', yang_name="dependencies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__access = YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__submodules = YANGDynClass(base=yc_submodules_openconfig_module_catalog__organizations_organization_modules_module_submodules, is_container='container', yang_name="submodules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules', 'module']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/modules/module/name (string)

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/modules/module/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/modules/module/version (oc-cat-types:module-version-type)

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/modules/module/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)


  def _get_namespace(self):
    """
    Getter method for namespace, mapped from YANG variable /organizations/organization/modules/module/namespace (string)

    YANG Description: Published namespace of module, i.e., defined by the
'namespace' 
    """
    return self.__namespace
      
  def _set_namespace(self, v, load=False):
    """
    Setter method for namespace, mapped from YANG variable /organizations/organization/modules/module/namespace (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_namespace is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_namespace() directly.

    YANG Description: Published namespace of module, i.e., defined by the
'namespace' 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="namespace", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """namespace must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="namespace", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__namespace = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_namespace(self):
    self.__namespace = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="namespace", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_prefix(self):
    """
    Getter method for prefix, mapped from YANG variable /organizations/organization/modules/module/prefix (string)

    YANG Description: Published prefix of the module
    """
    return self.__prefix
      
  def _set_prefix(self, v, load=False):
    """
    Setter method for prefix, mapped from YANG variable /organizations/organization/modules/module/prefix (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_prefix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_prefix() directly.

    YANG Description: Published prefix of the module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """prefix must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__prefix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_prefix(self):
    self.__prefix = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_revision(self):
    """
    Getter method for revision, mapped from YANG variable /organizations/organization/modules/module/revision (string)

    YANG Description: Date in the revision statement of the module
    """
    return self.__revision
      
  def _set_revision(self, v, load=False):
    """
    Setter method for revision, mapped from YANG variable /organizations/organization/modules/module/revision (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revision() directly.

    YANG Description: Date in the revision statement of the module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revision must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__revision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revision(self):
    self.__revision = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_summary(self):
    """
    Getter method for summary, mapped from YANG variable /organizations/organization/modules/module/summary (string)

    YANG Description: Summary description of the module
    """
    return self.__summary
      
  def _set_summary(self, v, load=False):
    """
    Setter method for summary, mapped from YANG variable /organizations/organization/modules/module/summary (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_summary is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_summary() directly.

    YANG Description: Summary description of the module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="summary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """summary must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="summary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__summary = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_summary(self):
    self.__summary = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="summary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_classification(self):
    """
    Getter method for classification, mapped from YANG variable /organizations/organization/modules/module/classification (container)

    YANG Description: Container for data describing the module's classification
    """
    return self.__classification
      
  def _set_classification(self, v, load=False):
    """
    Setter method for classification, mapped from YANG variable /organizations/organization/modules/module/classification (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classification is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classification() directly.

    YANG Description: Container for data describing the module's classification
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_classification_openconfig_module_catalog__organizations_organization_modules_module_classification, is_container='container', yang_name="classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classification must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_classification_openconfig_module_catalog__organizations_organization_modules_module_classification, is_container='container', yang_name="classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__classification = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classification(self):
    self.__classification = YANGDynClass(base=yc_classification_openconfig_module_catalog__organizations_organization_modules_module_classification, is_container='container', yang_name="classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_dependencies(self):
    """
    Getter method for dependencies, mapped from YANG variable /organizations/organization/modules/module/dependencies (container)

    YANG Description: Data about dependencies of the module
    """
    return self.__dependencies
      
  def _set_dependencies(self, v, load=False):
    """
    Setter method for dependencies, mapped from YANG variable /organizations/organization/modules/module/dependencies (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dependencies is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dependencies() directly.

    YANG Description: Data about dependencies of the module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_dependencies_openconfig_module_catalog__organizations_organization_modules_module_dependencies, is_container='container', yang_name="dependencies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dependencies must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_dependencies_openconfig_module_catalog__organizations_organization_modules_module_dependencies, is_container='container', yang_name="dependencies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__dependencies = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dependencies(self):
    self.__dependencies = YANGDynClass(base=yc_dependencies_openconfig_module_catalog__organizations_organization_modules_module_dependencies, is_container='container', yang_name="dependencies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_access(self):
    """
    Getter method for access, mapped from YANG variable /organizations/organization/modules/module/access (container)

    YANG Description: Container for data pertaining to retrieval and usage of the
module
    """
    return self.__access
      
  def _set_access(self, v, load=False):
    """
    Setter method for access, mapped from YANG variable /organizations/organization/modules/module/access (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_access is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_access() directly.

    YANG Description: Container for data pertaining to retrieval and usage of the
module
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """access must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__access = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_access(self):
    self.__access = YANGDynClass(base=yc_access_openconfig_module_catalog__organizations_organization_modules_module_access, is_container='container', yang_name="access", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_submodules(self):
    """
    Getter method for submodules, mapped from YANG variable /organizations/organization/modules/module/submodules (container)

    YANG Description: Data for the submodules belonging to a submodule. If the
module does not have any submodules, this container
should be empty.
    """
    return self.__submodules
      
  def _set_submodules(self, v, load=False):
    """
    Setter method for submodules, mapped from YANG variable /organizations/organization/modules/module/submodules (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_submodules is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_submodules() directly.

    YANG Description: Data for the submodules belonging to a submodule. If the
module does not have any submodules, this container
should be empty.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_submodules_openconfig_module_catalog__organizations_organization_modules_module_submodules, is_container='container', yang_name="submodules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """submodules must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_submodules_openconfig_module_catalog__organizations_organization_modules_module_submodules, is_container='container', yang_name="submodules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__submodules = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_submodules(self):
    self.__submodules = YANGDynClass(base=yc_submodules_openconfig_module_catalog__organizations_organization_modules_module_submodules, is_container='container', yang_name="submodules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  version = __builtin__.property(_get_version, _set_version)
  namespace = __builtin__.property(_get_namespace, _set_namespace)
  prefix = __builtin__.property(_get_prefix, _set_prefix)
  revision = __builtin__.property(_get_revision, _set_revision)
  summary = __builtin__.property(_get_summary, _set_summary)
  classification = __builtin__.property(_get_classification, _set_classification)
  dependencies = __builtin__.property(_get_dependencies, _set_dependencies)
  access = __builtin__.property(_get_access, _set_access)
  submodules = __builtin__.property(_get_submodules, _set_submodules)


  _pyangbind_elements = OrderedDict([('name', name), ('version', version), ('namespace', namespace), ('prefix', prefix), ('revision', revision), ('summary', summary), ('classification', classification), ('dependencies', dependencies), ('access', access), ('submodules', submodules), ])


class yc_modules_openconfig_module_catalog__organizations_organization_modules(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/modules. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Modules published by this organization
  """
  __slots__ = ('_path_helper', '_extmethods', '__module',)

  _yang_name = 'modules'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__module = YANGDynClass(base=YANGListType("name version",yc_module_openconfig_module_catalog__organizations_organization_modules_module, yang_name="module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'modules']

  def _get_module(self):
    """
    Getter method for module, mapped from YANG variable /organizations/organization/modules/module (list)

    YANG Description: List of published modules from the organization
    """
    return self.__module
      
  def _set_module(self, v, load=False):
    """
    Setter method for module, mapped from YANG variable /organizations/organization/modules/module (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_module() directly.

    YANG Description: List of published modules from the organization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name version",yc_module_openconfig_module_catalog__organizations_organization_modules_module, yang_name="module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """module must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name version",yc_module_openconfig_module_catalog__organizations_organization_modules_module, yang_name="module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_module(self):
    self.__module = YANGDynClass(base=YANGListType("name version",yc_module_openconfig_module_catalog__organizations_organization_modules_module, yang_name="module", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  module = __builtin__.property(_get_module, _set_module)


  _pyangbind_elements = OrderedDict([('module', module), ])


class yc_member_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members_member(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/release-bundles/release-bundle/members/member. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A set of modules or bundles which are part of the bundle
of models. For example, if 'ietf-yang-types' were to be
specified within the bundle, then this would refer to the
individual entry within the module catalogue. If the type
of the entry is set to bundle, then for example,
openconfig-bgp could be referenced - which itself consists
of separate modules.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__type','__module','__release_bundle','__publisher','__compatible_versions',)

  _yang_name = 'member'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    self.__module = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__release_bundle = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__compatible_versions = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="compatible-versions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'release-bundles', 'release-bundle', 'members', 'member']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/id (string)

    YANG Description: Identifier for the bundle member
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifier for the bundle member
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/type (identityref)

    YANG Description: The type of member that is to be included within the
release bundle. Release bundles may include modules and
other release bundles.  Both member modules and member
bundles should specify the list of compatible versions.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of member that is to be included within the
release bundle. Release bundles may include modules and
other release bundles.  Both member modules and member
bundles should specify the list of compatible versions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:MODULE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:RELEASE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:FEATURE_BUNDLE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)


  def _get_module(self):
    """
    Getter method for module, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/module (leafref)

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    return self.__module
      
  def _set_module(self, v, load=False):
    """
    Setter method for module, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/module (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_module() directly.

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """module must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_module(self):
    self.__module = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_release_bundle(self):
    """
    Getter method for release_bundle, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/release_bundle (leafref)

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    return self.__release_bundle
      
  def _set_release_bundle(self, v, load=False):
    """
    Setter method for release_bundle, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/release_bundle (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_release_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_release_bundle() directly.

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """release_bundle must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__release_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_release_bundle(self):
    self.__release_bundle = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_publisher(self):
    """
    Getter method for publisher, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/publisher (leafref)

    YANG Description: Reference to the name of the publishing organization
    """
    return self.__publisher
      
  def _set_publisher(self, v, load=False):
    """
    Setter method for publisher, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/publisher (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_publisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_publisher() directly.

    YANG Description: Reference to the name of the publishing organization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """publisher must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__publisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_publisher(self):
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_compatible_versions(self):
    """
    Getter method for compatible_versions, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/compatible_versions (oc-cat-types:module-version-type)

    YANG Description: A list of semantic version specification of the versions
of the specified module or release bundle which are
compatible when building this version of the bundle.

Version specifications may be added when changes are made
to a module within a bundle, and this does not affect the
interaction between it and other modules. It is expected
that backwards compatible changes to an individual module or
member bundle do not affect the compatibility of that
with other members, and hence wildcard matches are allowed
within this list.
    """
    return self.__compatible_versions
      
  def _set_compatible_versions(self, v, load=False):
    """
    Setter method for compatible_versions, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member/compatible_versions (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_compatible_versions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_compatible_versions() directly.

    YANG Description: A list of semantic version specification of the versions
of the specified module or release bundle which are
compatible when building this version of the bundle.

Version specifications may be added when changes are made
to a module within a bundle, and this does not affect the
interaction between it and other modules. It is expected
that backwards compatible changes to an individual module or
member bundle do not affect the compatibility of that
with other members, and hence wildcard matches are allowed
within this list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="compatible-versions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """compatible_versions must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="compatible-versions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__compatible_versions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_compatible_versions(self):
    self.__compatible_versions = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="compatible-versions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  type = __builtin__.property(_get_type, _set_type)
  module = __builtin__.property(_get_module, _set_module)
  release_bundle = __builtin__.property(_get_release_bundle, _set_release_bundle)
  publisher = __builtin__.property(_get_publisher, _set_publisher)
  compatible_versions = __builtin__.property(_get_compatible_versions, _set_compatible_versions)


  _pyangbind_elements = OrderedDict([('id', id), ('type', type), ('module', module), ('release_bundle', release_bundle), ('publisher', publisher), ('compatible_versions', compatible_versions), ])


class yc_members_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/release-bundles/release-bundle/members. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of bundle members which make up this release bundle. A
member is defined as an individual YANG module specified
in the YANG catalogue, or another release
bundle which can be used to group multiple YANG
models together.
  """
  __slots__ = ('_path_helper', '_extmethods', '__member',)

  _yang_name = 'members'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__member = YANGDynClass(base=YANGListType("id",yc_member_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'release-bundles', 'release-bundle', 'members']

  def _get_member(self):
    """
    Getter method for member, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member (list)

    YANG Description: A set of modules or bundles which are part of the bundle
of models. For example, if 'ietf-yang-types' were to be
specified within the bundle, then this would refer to the
individual entry within the module catalogue. If the type
of the entry is set to bundle, then for example,
openconfig-bgp could be referenced - which itself consists
of separate modules.
    """
    return self.__member
      
  def _set_member(self, v, load=False):
    """
    Setter method for member, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members/member (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_member is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_member() directly.

    YANG Description: A set of modules or bundles which are part of the bundle
of models. For example, if 'ietf-yang-types' were to be
specified within the bundle, then this would refer to the
individual entry within the module catalogue. If the type
of the entry is set to bundle, then for example,
openconfig-bgp could be referenced - which itself consists
of separate modules.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_member_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """member must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_member_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__member = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_member(self):
    self.__member = YANGDynClass(base=YANGListType("id",yc_member_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  member = __builtin__.property(_get_member, _set_member)


  _pyangbind_elements = OrderedDict([('member', member), ])


class yc_release_bundle_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/release-bundles/release-bundle. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of release bundles - sets of modules and/or
bundles which are interoperable
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__version','__members',)

  _yang_name = 'release-bundle'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    self.__members = YANGDynClass(base=yc_members_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'release-bundles', 'release-bundle']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/name (string)

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/version (oc-cat-types:module-version-type)

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)


  def _get_members(self):
    """
    Getter method for members, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members (container)

    YANG Description: List of bundle members which make up this release bundle. A
member is defined as an individual YANG module specified
in the YANG catalogue, or another release
bundle which can be used to group multiple YANG
models together.
    """
    return self.__members
      
  def _set_members(self, v, load=False):
    """
    Setter method for members, mapped from YANG variable /organizations/organization/release_bundles/release_bundle/members (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_members is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_members() directly.

    YANG Description: List of bundle members which make up this release bundle. A
member is defined as an individual YANG module specified
in the YANG catalogue, or another release
bundle which can be used to group multiple YANG
models together.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_members_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """members must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_members_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__members = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_members(self):
    self.__members = YANGDynClass(base=yc_members_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  version = __builtin__.property(_get_version, _set_version)
  members = __builtin__.property(_get_members, _set_members)


  _pyangbind_elements = OrderedDict([('name', name), ('version', version), ('members', members), ])


class yc_release_bundles_openconfig_module_catalog__organizations_organization_release_bundles(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/release-bundles. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of release bundles
  """
  __slots__ = ('_path_helper', '_extmethods', '__release_bundle',)

  _yang_name = 'release-bundles'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__release_bundle = YANGDynClass(base=YANGListType("name version",yc_release_bundle_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle, yang_name="release-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'release-bundles']

  def _get_release_bundle(self):
    """
    Getter method for release_bundle, mapped from YANG variable /organizations/organization/release_bundles/release_bundle (list)

    YANG Description: List of release bundles - sets of modules and/or
bundles which are interoperable
    """
    return self.__release_bundle
      
  def _set_release_bundle(self, v, load=False):
    """
    Setter method for release_bundle, mapped from YANG variable /organizations/organization/release_bundles/release_bundle (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_release_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_release_bundle() directly.

    YANG Description: List of release bundles - sets of modules and/or
bundles which are interoperable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name version",yc_release_bundle_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle, yang_name="release-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """release_bundle must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name version",yc_release_bundle_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle, yang_name="release-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__release_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_release_bundle(self):
    self.__release_bundle = YANGDynClass(base=YANGListType("name version",yc_release_bundle_openconfig_module_catalog__organizations_organization_release_bundles_release_bundle, yang_name="release-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  release_bundle = __builtin__.property(_get_release_bundle, _set_release_bundle)


  _pyangbind_elements = OrderedDict([('release_bundle', release_bundle), ])


class yc_release_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_release_bundle(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/feature-bundles/feature-bundle/release-bundle. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data to identify the release bundle from which the feature
paths should be specified.  If the feature crosses
release bundles, a new release bundle should be
created to support the feature bundle.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__publisher','__version',)

  _yang_name = 'release-bundle'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'feature-bundles', 'feature-bundle', 'release-bundle']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/name (leafref)

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the module set which is included in this bundle -
for example, 'openconfig-bgp'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_publisher(self):
    """
    Getter method for publisher, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/publisher (leafref)

    YANG Description: Reference to the name of the publishing organization
    """
    return self.__publisher
      
  def _set_publisher(self, v, load=False):
    """
    Setter method for publisher, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/publisher (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_publisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_publisher() directly.

    YANG Description: Reference to the name of the publishing organization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """publisher must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__publisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_publisher(self):
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/version (oc-cat-types:module-version-type)

    YANG Description: Version of the referenced release bundle
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: Version of the referenced release bundle
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  publisher = __builtin__.property(_get_publisher, _set_publisher)
  version = __builtin__.property(_get_version, _set_version)


  _pyangbind_elements = OrderedDict([('name', name), ('publisher', publisher), ('version', version), ])


class yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles_feature_bundle(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/feature-bundles/feature-bundle/feature-bundles/feature-bundle. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of feature bundles included in the current
feature bundle.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__publisher','__version',)

  _yang_name = 'feature-bundle'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'feature-bundles', 'feature-bundle', 'feature-bundles', 'feature-bundle']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/name (leafref)

    YANG Description: Name of the referenced feature bundle
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the referenced feature bundle
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_publisher(self):
    """
    Getter method for publisher, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/publisher (leafref)

    YANG Description: Publisher of the referenced feature bundle
    """
    return self.__publisher
      
  def _set_publisher(self, v, load=False):
    """
    Setter method for publisher, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/publisher (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_publisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_publisher() directly.

    YANG Description: Publisher of the referenced feature bundle
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """publisher must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__publisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_publisher(self):
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)

    YANG Description: Version of the referenced feature bundle
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: Version of the referenced feature bundle
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  publisher = __builtin__.property(_get_publisher, _set_publisher)
  version = __builtin__.property(_get_version, _set_version)


  _pyangbind_elements = OrderedDict([('name', name), ('publisher', publisher), ('version', version), ])


class yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/feature-bundles/feature-bundle/feature-bundles. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of included feature
bundles.  Feature bundles may be composed from other
smaller feature units
  """
  __slots__ = ('_path_helper', '_extmethods', '__feature_bundle',)

  _yang_name = 'feature-bundles'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__feature_bundle = YANGDynClass(base=YANGListType("name",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'feature-bundles', 'feature-bundle', 'feature-bundles']

  def _get_feature_bundle(self):
    """
    Getter method for feature_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle (list)

    YANG Description: The list of feature bundles included in the current
feature bundle.
    """
    return self.__feature_bundle
      
  def _set_feature_bundle(self, v, load=False):
    """
    Setter method for feature_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles/feature_bundle (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundle() directly.

    YANG Description: The list of feature bundles included in the current
feature bundle.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundle must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__feature_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundle(self):
    self.__feature_bundle = YANGDynClass(base=YANGListType("name",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  feature_bundle = __builtin__.property(_get_feature_bundle, _set_feature_bundle)


  _pyangbind_elements = OrderedDict([('feature_bundle', feature_bundle), ])


class yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/feature-bundles/feature-bundle. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of feature bundles
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__version','__path','__release_bundle','__feature_bundles',)

  _yang_name = 'feature-bundle'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    self.__path = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__release_bundle = YANGDynClass(base=yc_release_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_release_bundle, is_container='container', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'feature-bundles', 'feature-bundle']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/name (string)

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the module or bundle.  For modules, this
should reflect the 'module' or 'submodule'
statement in the YANG module file.

For bundles, this is the canonical name for the overall
bundle of modules which is to be released together.
This name should be consistent over multiple
releases
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: For individual modules, this is the version number, e.g.,
a semantic version.  The version may be the same as the date
indicated in the module revision statement.

For bundles, this is a semantic version number for the
overall bundle. This version is to be defined as per the
approach specified in the OpenConfig semantic version
guidance - and is of the form x.y.z, where x is the major
version, y is the minor version, and z is the patch level
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)


  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/path (string)

    YANG Description: The list of schema paths included in the feature.  The
paths specify subtrees, i.e., all data underneath the
specified path are included in the feature.
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/path (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: The list of schema paths included in the feature.  The
paths specify subtrees, i.e., all data underneath the
specified path are included in the feature.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_release_bundle(self):
    """
    Getter method for release_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle (container)

    YANG Description: Data to identify the release bundle from which the feature
paths should be specified.  If the feature crosses
release bundles, a new release bundle should be
created to support the feature bundle.
    """
    return self.__release_bundle
      
  def _set_release_bundle(self, v, load=False):
    """
    Setter method for release_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/release_bundle (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_release_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_release_bundle() directly.

    YANG Description: Data to identify the release bundle from which the feature
paths should be specified.  If the feature crosses
release bundles, a new release bundle should be
created to support the feature bundle.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_release_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_release_bundle, is_container='container', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """release_bundle must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_release_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_release_bundle, is_container='container', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__release_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_release_bundle(self):
    self.__release_bundle = YANGDynClass(base=yc_release_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_release_bundle, is_container='container', yang_name="release-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_feature_bundles(self):
    """
    Getter method for feature_bundles, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles (container)

    YANG Description: Enclosing container for the list of included feature
bundles.  Feature bundles may be composed from other
smaller feature units
    """
    return self.__feature_bundles
      
  def _set_feature_bundles(self, v, load=False):
    """
    Setter method for feature_bundles, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle/feature_bundles (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundles is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundles() directly.

    YANG Description: Enclosing container for the list of included feature
bundles.  Feature bundles may be composed from other
smaller feature units
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundles must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__feature_bundles = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundles(self):
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  version = __builtin__.property(_get_version, _set_version)
  path = __builtin__.property(_get_path, _set_path)
  release_bundle = __builtin__.property(_get_release_bundle, _set_release_bundle)
  feature_bundles = __builtin__.property(_get_feature_bundles, _set_feature_bundles)


  _pyangbind_elements = OrderedDict([('name', name), ('version', version), ('path', path), ('release_bundle', release_bundle), ('feature_bundles', feature_bundles), ])


class yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/feature-bundles. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of feature bundles
  """
  __slots__ = ('_path_helper', '_extmethods', '__feature_bundle',)

  _yang_name = 'feature-bundles'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__feature_bundle = YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'feature-bundles']

  def _get_feature_bundle(self):
    """
    Getter method for feature_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle (list)

    YANG Description: List of feature bundles
    """
    return self.__feature_bundle
      
  def _set_feature_bundle(self, v, load=False):
    """
    Setter method for feature_bundle, mapped from YANG variable /organizations/organization/feature_bundles/feature_bundle (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundle() directly.

    YANG Description: List of feature bundles
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundle must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__feature_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundle(self):
    self.__feature_bundle = YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  feature_bundle = __builtin__.property(_get_feature_bundle, _set_feature_bundle)


  _pyangbind_elements = OrderedDict([('feature_bundle', feature_bundle), ])


class yc_feature_bundle_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles_feature_bundle(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/implementations/implementation/feature-bundles/feature-bundle. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of feature bundles supported by the implementation
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__publisher','__version',)

  _yang_name = 'feature-bundle'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'implementations', 'implementation', 'feature-bundles', 'feature-bundle']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/name (leafref)

    YANG Description: Name of the referenced feature bundle
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the referenced feature bundle
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_publisher(self):
    """
    Getter method for publisher, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/publisher (leafref)

    YANG Description: Publisher of the referenced feature bundle
    """
    return self.__publisher
      
  def _set_publisher(self, v, load=False):
    """
    Setter method for publisher, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/publisher (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_publisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_publisher() directly.

    YANG Description: Publisher of the referenced feature bundle
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """publisher must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)""",
        })

    self.__publisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_publisher(self):
    self.__publisher = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="publisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='leafref', is_config=True)


  def _get_version(self):
    """
    Getter method for version, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)

    YANG Description: Version of the referenced feature bundle
    """
    return self.__version
      
  def _set_version(self, v, load=False):
    """
    Setter method for version, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle/version (oc-cat-types:module-version-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_version() directly.

    YANG Description: Version of the referenced feature bundle
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """version must be of a type compatible with oc-cat-types:module-version-type""",
          'defined-type': "oc-cat-types:module-version-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)""",
        })

    self.__version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_version(self):
    self.__version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='oc-cat-types:module-version-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  publisher = __builtin__.property(_get_publisher, _set_publisher)
  version = __builtin__.property(_get_version, _set_version)


  _pyangbind_elements = OrderedDict([('name', name), ('publisher', publisher), ('version', version), ])


class yc_feature_bundles_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/implementations/implementation/feature-bundles. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of feature bundles
  """
  __slots__ = ('_path_helper', '_extmethods', '__feature_bundle',)

  _yang_name = 'feature-bundles'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__feature_bundle = YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'implementations', 'implementation', 'feature-bundles']

  def _get_feature_bundle(self):
    """
    Getter method for feature_bundle, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle (list)

    YANG Description: List of feature bundles supported by the implementation
    """
    return self.__feature_bundle
      
  def _set_feature_bundle(self, v, load=False):
    """
    Setter method for feature_bundle, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles/feature_bundle (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundle is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundle() directly.

    YANG Description: List of feature bundles supported by the implementation
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundle must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__feature_bundle = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundle(self):
    self.__feature_bundle = YANGDynClass(base=YANGListType("name version",yc_feature_bundle_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles_feature_bundle, yang_name="feature-bundle", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name version', extensions=None), is_container='list', yang_name="feature-bundle", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  feature_bundle = __builtin__.property(_get_feature_bundle, _set_feature_bundle)


  _pyangbind_elements = OrderedDict([('feature_bundle', feature_bundle), ])


class yc_implementation_openconfig_module_catalog__organizations_organization_implementations_implementation(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/implementations/implementation. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of available implementations, keyed by an identifier
provided by either the implementor or the module
maintainer.  Such a key avoids needing a complex composite
key to uniquely identify an implementation.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__description','__reference','__platform','__platform_version','__status','__feature_bundles',)

  _yang_name = 'implementation'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__reference = YANGDynClass(base=[six.text_type,six.text_type,], is_leaf=True, yang_name="reference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='union', is_config=True)
    self.__platform = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__platform_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'implementations', 'implementation']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /organizations/organization/implementations/implementation/id (string)

    YANG Description: An identifier for the implementation, provided by the
implementor.  This id should uniquely identify a specific
implementation of the module, e.g., based on the vendor,
platform, and platform version.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /organizations/organization/implementations/implementation/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: An identifier for the implementation, provided by the
implementor.  This id should uniquely identify a specific
implementation of the module, e.g., based on the vendor,
platform, and platform version.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /organizations/organization/implementations/implementation/description (string)

    YANG Description: A text summary of important information about the
implementation
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /organizations/organization/implementations/implementation/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A text summary of important information about the
implementation
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_reference(self):
    """
    Getter method for reference, mapped from YANG variable /organizations/organization/implementations/implementation/reference (union)

    YANG Description: A URI (preferred) or text reference to more detailed
information about the implementation.
    """
    return self.__reference
      
  def _set_reference(self, v, load=False):
    """
    Setter method for reference, mapped from YANG variable /organizations/organization/implementations/implementation/reference (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_reference is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_reference() directly.

    YANG Description: A URI (preferred) or text reference to more detailed
information about the implementation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,six.text_type,], is_leaf=True, yang_name="reference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """reference must be of a type compatible with union""",
          'defined-type': "openconfig-module-catalog:union",
          'generated-type': """YANGDynClass(base=[six.text_type,six.text_type,], is_leaf=True, yang_name="reference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='union', is_config=True)""",
        })

    self.__reference = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_reference(self):
    self.__reference = YANGDynClass(base=[six.text_type,six.text_type,], is_leaf=True, yang_name="reference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='union', is_config=True)


  def _get_platform(self):
    """
    Getter method for platform, mapped from YANG variable /organizations/organization/implementations/implementation/platform (string)

    YANG Description: Name of the platform on which the implementation
is available -- this could be the model name of a network
device, a server OS, etc.
    """
    return self.__platform
      
  def _set_platform(self, v, load=False):
    """
    Setter method for platform, mapped from YANG variable /organizations/organization/implementations/implementation/platform (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_platform is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_platform() directly.

    YANG Description: Name of the platform on which the implementation
is available -- this could be the model name of a network
device, a server OS, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="platform", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """platform must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__platform = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_platform(self):
    self.__platform = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_platform_version(self):
    """
    Getter method for platform_version, mapped from YANG variable /organizations/organization/implementations/implementation/platform_version (string)

    YANG Description: Implementor-defined version name or number of the
module implementation, corresponding to the platform.
This could be the firmware version of a network device
such as a router, OS version, or other server platform
version.
    """
    return self.__platform_version
      
  def _set_platform_version(self, v, load=False):
    """
    Setter method for platform_version, mapped from YANG variable /organizations/organization/implementations/implementation/platform_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_platform_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_platform_version() directly.

    YANG Description: Implementor-defined version name or number of the
module implementation, corresponding to the platform.
This could be the firmware version of a network device
such as a router, OS version, or other server platform
version.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="platform-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """platform_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__platform_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_platform_version(self):
    self.__platform_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="platform-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_status(self):
    """
    Getter method for status, mapped from YANG variable /organizations/organization/implementations/implementation/status (identityref)

    YANG Description: Indicates the status of the implementation, e.g.,
complete, partial, in-progress, etc.  Implementors
may define additional values for the base identity
    """
    return self.__status
      
  def _set_status(self, v, load=False):
    """
    Setter method for status, mapped from YANG variable /organizations/organization/implementations/implementation/status (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_status() directly.

    YANG Description: Indicates the status of the implementation, e.g.,
complete, partial, in-progress, etc.  Implementors
may define additional values for the base identity
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """status must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_status(self):
    self.__status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:IN_PROGRESS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PLANNED': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMPLETE': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:PARTIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)


  def _get_feature_bundles(self):
    """
    Getter method for feature_bundles, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles (container)

    YANG Description: Enclosing container for the list of feature bundles
    """
    return self.__feature_bundles
      
  def _set_feature_bundles(self, v, load=False):
    """
    Setter method for feature_bundles, mapped from YANG variable /organizations/organization/implementations/implementation/feature_bundles (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundles is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundles() directly.

    YANG Description: Enclosing container for the list of feature bundles
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundles must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__feature_bundles = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundles(self):
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_implementations_implementation_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  description = __builtin__.property(_get_description, _set_description)
  reference = __builtin__.property(_get_reference, _set_reference)
  platform = __builtin__.property(_get_platform, _set_platform)
  platform_version = __builtin__.property(_get_platform_version, _set_platform_version)
  status = __builtin__.property(_get_status, _set_status)
  feature_bundles = __builtin__.property(_get_feature_bundles, _set_feature_bundles)


  _pyangbind_elements = OrderedDict([('id', id), ('description', description), ('reference', reference), ('platform', platform), ('platform_version', platform_version), ('status', status), ('feature_bundles', feature_bundles), ])


class yc_implementations_openconfig_module_catalog__organizations_organization_implementations(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization/implementations. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for module implementation information
  """
  __slots__ = ('_path_helper', '_extmethods', '__implementation',)

  _yang_name = 'implementations'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__implementation = YANGDynClass(base=YANGListType("id",yc_implementation_openconfig_module_catalog__organizations_organization_implementations_implementation, yang_name="implementation", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="implementation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization', 'implementations']

  def _get_implementation(self):
    """
    Getter method for implementation, mapped from YANG variable /organizations/organization/implementations/implementation (list)

    YANG Description: List of available implementations, keyed by an identifier
provided by either the implementor or the module
maintainer.  Such a key avoids needing a complex composite
key to uniquely identify an implementation.
    """
    return self.__implementation
      
  def _set_implementation(self, v, load=False):
    """
    Setter method for implementation, mapped from YANG variable /organizations/organization/implementations/implementation (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_implementation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_implementation() directly.

    YANG Description: List of available implementations, keyed by an identifier
provided by either the implementor or the module
maintainer.  Such a key avoids needing a complex composite
key to uniquely identify an implementation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_implementation_openconfig_module_catalog__organizations_organization_implementations_implementation, yang_name="implementation", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="implementation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """implementation must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_implementation_openconfig_module_catalog__organizations_organization_implementations_implementation, yang_name="implementation", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="implementation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__implementation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_implementation(self):
    self.__implementation = YANGDynClass(base=YANGListType("id",yc_implementation_openconfig_module_catalog__organizations_organization_implementations_implementation, yang_name="implementation", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="implementation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  implementation = __builtin__.property(_get_implementation, _set_implementation)


  _pyangbind_elements = OrderedDict([('implementation', implementation), ])


class yc_organization_openconfig_module_catalog__organizations_organization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations/organization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of organizations publishing YANG modules or
module bundles
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__contact','__modules','__release_bundles','__feature_bundles','__implementations',)

  _yang_name = 'organization'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    self.__contact = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="contact", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    self.__modules = YANGDynClass(base=yc_modules_openconfig_module_catalog__organizations_organization_modules, is_container='container', yang_name="modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__release_bundles = YANGDynClass(base=yc_release_bundles_openconfig_module_catalog__organizations_organization_release_bundles, is_container='container', yang_name="release-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    self.__implementations = YANGDynClass(base=yc_implementations_openconfig_module_catalog__organizations_organization_implementations, is_container='container', yang_name="implementations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations', 'organization']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /organizations/organization/name (string)

    YANG Description: Name of the maintaining organization -- the name should be
supplied in the official format used by the organization.
Standards Body examples:
 IETF, IEEE, MEF, ONF, etc.
Commercial entity examples:
 AT&T, Facebook, <Vendor>
Name of industry forum examples:
 OpenConfig, OpenDaylight, ON.Lab
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /organizations/organization/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the maintaining organization -- the name should be
supplied in the official format used by the organization.
Standards Body examples:
 IETF, IEEE, MEF, ONF, etc.
Commercial entity examples:
 AT&T, Facebook, <Vendor>
Name of industry forum examples:
 OpenConfig, OpenDaylight, ON.Lab
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /organizations/organization/type (identityref)

    YANG Description: Type of the publishing organization
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /organizations/organization/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of the publishing organization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-module-catalog:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:STANDARDS': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDUSTRY': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:COMMERCIAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}, 'oc-cat-types:INDIVIDUAL': {'@module': 'openconfig-catalog-types', '@namespace': 'http://openconfig.net/yang/catalog-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='identityref', is_config=True)


  def _get_contact(self):
    """
    Getter method for contact, mapped from YANG variable /organizations/organization/contact (string)

    YANG Description: Contact information for the publishing organization (web
site, email address, etc.)
    """
    return self.__contact
      
  def _set_contact(self, v, load=False):
    """
    Setter method for contact, mapped from YANG variable /organizations/organization/contact (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_contact is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_contact() directly.

    YANG Description: Contact information for the publishing organization (web
site, email address, etc.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="contact", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """contact must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="contact", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)""",
        })

    self.__contact = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_contact(self):
    self.__contact = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="contact", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='string', is_config=True)


  def _get_modules(self):
    """
    Getter method for modules, mapped from YANG variable /organizations/organization/modules (container)

    YANG Description: Modules published by this organization
    """
    return self.__modules
      
  def _set_modules(self, v, load=False):
    """
    Setter method for modules, mapped from YANG variable /organizations/organization/modules (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_modules is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_modules() directly.

    YANG Description: Modules published by this organization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_modules_openconfig_module_catalog__organizations_organization_modules, is_container='container', yang_name="modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """modules must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_modules_openconfig_module_catalog__organizations_organization_modules, is_container='container', yang_name="modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__modules = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_modules(self):
    self.__modules = YANGDynClass(base=yc_modules_openconfig_module_catalog__organizations_organization_modules, is_container='container', yang_name="modules", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_release_bundles(self):
    """
    Getter method for release_bundles, mapped from YANG variable /organizations/organization/release_bundles (container)

    YANG Description: List of release bundles
    """
    return self.__release_bundles
      
  def _set_release_bundles(self, v, load=False):
    """
    Setter method for release_bundles, mapped from YANG variable /organizations/organization/release_bundles (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_release_bundles is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_release_bundles() directly.

    YANG Description: List of release bundles
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_release_bundles_openconfig_module_catalog__organizations_organization_release_bundles, is_container='container', yang_name="release-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """release_bundles must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_release_bundles_openconfig_module_catalog__organizations_organization_release_bundles, is_container='container', yang_name="release-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__release_bundles = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_release_bundles(self):
    self.__release_bundles = YANGDynClass(base=yc_release_bundles_openconfig_module_catalog__organizations_organization_release_bundles, is_container='container', yang_name="release-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_feature_bundles(self):
    """
    Getter method for feature_bundles, mapped from YANG variable /organizations/organization/feature_bundles (container)

    YANG Description: Enclosing container for the list of feature bundles
    """
    return self.__feature_bundles
      
  def _set_feature_bundles(self, v, load=False):
    """
    Setter method for feature_bundles, mapped from YANG variable /organizations/organization/feature_bundles (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_feature_bundles is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_feature_bundles() directly.

    YANG Description: Enclosing container for the list of feature bundles
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """feature_bundles must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__feature_bundles = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_feature_bundles(self):
    self.__feature_bundles = YANGDynClass(base=yc_feature_bundles_openconfig_module_catalog__organizations_organization_feature_bundles, is_container='container', yang_name="feature-bundles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)


  def _get_implementations(self):
    """
    Getter method for implementations, mapped from YANG variable /organizations/organization/implementations (container)

    YANG Description: Container for module implementation information
    """
    return self.__implementations
      
  def _set_implementations(self, v, load=False):
    """
    Setter method for implementations, mapped from YANG variable /organizations/organization/implementations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_implementations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_implementations() directly.

    YANG Description: Container for module implementation information
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_implementations_openconfig_module_catalog__organizations_organization_implementations, is_container='container', yang_name="implementations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """implementations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_implementations_openconfig_module_catalog__organizations_organization_implementations, is_container='container', yang_name="implementations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__implementations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_implementations(self):
    self.__implementations = YANGDynClass(base=yc_implementations_openconfig_module_catalog__organizations_organization_implementations, is_container='container', yang_name="implementations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  contact = __builtin__.property(_get_contact, _set_contact)
  modules = __builtin__.property(_get_modules, _set_modules)
  release_bundles = __builtin__.property(_get_release_bundles, _set_release_bundles)
  feature_bundles = __builtin__.property(_get_feature_bundles, _set_feature_bundles)
  implementations = __builtin__.property(_get_implementations, _set_implementations)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('contact', contact), ('modules', modules), ('release_bundles', release_bundles), ('feature_bundles', feature_bundles), ('implementations', implementations), ])


class yc_organizations_openconfig_module_catalog__organizations(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /organizations. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of organizations owning modules
  """
  __slots__ = ('_path_helper', '_extmethods', '__organization',)

  _yang_name = 'organizations'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__organization = YANGDynClass(base=YANGListType("name",yc_organization_openconfig_module_catalog__organizations_organization, yang_name="organization", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="organization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['organizations']

  def _get_organization(self):
    """
    Getter method for organization, mapped from YANG variable /organizations/organization (list)

    YANG Description: List of organizations publishing YANG modules or
module bundles
    """
    return self.__organization
      
  def _set_organization(self, v, load=False):
    """
    Setter method for organization, mapped from YANG variable /organizations/organization (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_organization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_organization() directly.

    YANG Description: List of organizations publishing YANG modules or
module bundles
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_organization_openconfig_module_catalog__organizations_organization, yang_name="organization", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="organization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """organization must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_organization_openconfig_module_catalog__organizations_organization, yang_name="organization", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="organization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)""",
        })

    self.__organization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_organization(self):
    self.__organization = YANGDynClass(base=YANGListType("name",yc_organization_openconfig_module_catalog__organizations_organization, yang_name="organization", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="organization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='list', is_config=True)

  organization = __builtin__.property(_get_organization, _set_organization)


  _pyangbind_elements = OrderedDict([('organization', organization), ])


class openconfig_module_catalog(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-module-catalog - based on the path /openconfig-module-catalog. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module provides a schema for cataloging and descrbing
YANG models published across various organizations.  The catalog
contains several categories of data:

* organizations -- entities that publish and/or maintain
 individual YANG modules or groups of modules

* modules -- information regarding individual YANG modules,
 including their versions, dependencies, submodules, and how
 to access them

* release bundles -- groups of modules that are compatible and
 consistent with each other (as determined by the publisher of
 of the bundle).  The release bundle does not necessarily
 correspond to a functional area, e.g., it could the entire
 set of modules published by an organization

* feature bundles -- sets of schema paths across a
 release bundle that provide a specific set of functionality

* implementations -- information about available module and/or
 bundle implementations and their status
  """
  __slots__ = ('_path_helper', '_extmethods', '__organizations',)

  _yang_name = 'openconfig-module-catalog'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__organizations = YANGDynClass(base=yc_organizations_openconfig_module_catalog__organizations, is_container='container', yang_name="organizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_organizations(self):
    """
    Getter method for organizations, mapped from YANG variable /organizations (container)

    YANG Description: List of organizations owning modules
    """
    return self.__organizations
      
  def _set_organizations(self, v, load=False):
    """
    Setter method for organizations, mapped from YANG variable /organizations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_organizations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_organizations() directly.

    YANG Description: List of organizations owning modules
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_organizations_openconfig_module_catalog__organizations, is_container='container', yang_name="organizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """organizations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_organizations_openconfig_module_catalog__organizations, is_container='container', yang_name="organizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)""",
        })

    self.__organizations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_organizations(self):
    self.__organizations = YANGDynClass(base=yc_organizations_openconfig_module_catalog__organizations, is_container='container', yang_name="organizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/module-catalog', defining_module='openconfig-module-catalog', yang_type='container', is_config=True)

  organizations = __builtin__.property(_get_organizations, _set_organizations)


  _pyangbind_elements = OrderedDict([('organizations', organizations), ])


class openconfig_catalog_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-catalog-types - based on the path /openconfig-catalog-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types and identities used by the OpenConfig
YANG module catalog model.
  """
  _pyangbind_elements = {}

  

