# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_qos_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-types - based on the path /openconfig-qos-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types and identities used in OpenConfig
models related to quality-of-service (QoS)
  """
  _pyangbind_elements = {}

  

class openconfig_qos_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-interfaces - based on the path /openconfig-qos-interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines data related to quality-of-service
configuration and operational state associated with
interfaces.
  """
  _pyangbind_elements = {}

  

class openconfig_qos_elements(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-elements - based on the path /openconfig-qos-elements. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated with QoS elements.  The primary elements of
the model include:

 classifiers: match packets with a specific characteristic

 forwarding groups: logical class of packets that receive
 common forwarding treatment

 queues:  collection of packets to be scheduled, including
 a queue management scheme

 schedulers: sequence of one more elements that schedule
 packets for transmission, including policer and shaper
 functions
  """
  _pyangbind_elements = {}

  

class openconfig_qos_mem_mgmt(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos-mem-mgmt - based on the path /openconfig-qos-mem-mgmt. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This submodule defines configuration and operational state
data associated related to queue management features of QoS
particularly:

- buffer-allocation-profiles: these profiles are applied on
 a per-interface basis, and determine how memory is to be managed
 across the queues that are instantiated on the system.

- queue-management-profiles: these profiles are applied on a per-interface
 per-queue basis, and determine how packets are marked/dropped within
 the queue instantiation.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_qos__qos_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'config']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/config/interface_id (string)

    YANG Description: Identifier for the interface.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/config/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  interface_id = __builtin__.property(_get_interface_id, _set_interface_id)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ])


class yc_state_openconfig_qos__qos_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'state']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/state/interface_id (string)

    YANG Description: Identifier for the interface.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/state/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  interface_id = __builtin__.property(_get_interface_id)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ])


class yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for QoS on ingress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'config']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/config/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile, _set_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile, _set_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile, _set_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for QoS on ingress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'state']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the input (rx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/input/state/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for match terms in the classifier
associated with an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__matched_packets','__matched_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/id (leafref)

    YANG Description: Reference to match terms in the classifier
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match terms in the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  id = __builtin__.property(_get_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('id', id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms/term. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of match terms in the classifier associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'term'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms', 'term']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/id (leafref)

    YANG Description: Reference to match term id list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match term id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state (container)

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier/terms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of match terms in the
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__term',)

  _yang_name = 'terms'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier', 'terms']

  def _get_term(self):
    """
    Getter method for term, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term (list)

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    return self.__term
      
  def _set_term(self, v, load=False):
    """
    Setter method for term, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms/term (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_term is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_term() directly.

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """term must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__term = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_term(self):
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  term = __builtin__.property(_get_term, _set_term)


  _pyangbind_elements = OrderedDict([('term', term), ])


class yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers/classifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of classifiers that should be applied to the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__config','__state','__terms',)

  _yang_name = 'classifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers', 'classifier']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/type (leafref)

    YANG Description: Reference to the classifier name.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the classifier name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config (container)

    YANG Description: Configuration parameters for the list of classifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state (container)

    YANG Description: Operational state parameters for the list of classifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_terms(self):
    """
    Getter method for terms, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms (container)

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    return self.__terms
      
  def _set_terms(self, v, load=False):
    """
    Setter method for terms, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier/terms (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terms is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terms() directly.

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terms must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__terms = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terms(self):
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  terms = __builtin__.property(_get_terms, _set_terms)


  _pyangbind_elements = OrderedDict([('type', type), ('config', config), ('state', state), ('terms', terms), ])


class yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/classifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Classifiers to be applied to the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__classifier',)

  _yang_name = 'classifiers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'classifiers']

  def _get_classifier(self):
    """
    Getter method for classifier, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier (list)

    YANG Description: A list of classifiers that should be applied to the interface
    """
    return self.__classifier
      
  def _set_classifier(self, v, load=False):
    """
    Setter method for classifier, mapped from YANG variable /qos/interfaces/interface/input/classifiers/classifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifier() directly.

    YANG Description: A list of classifiers that should be applied to the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__classifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifier(self):
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_input_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  classifier = __builtin__.property(_get_classifier, _set_classifier)


  _pyangbind_elements = OrderedDict([('classifier', classifier), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile, _set_queue_management_profile)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_input_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/input/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/input/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers/scheduler/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the scheduler
policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__conforming_pkts','__conforming_octets','__exceeding_pkts','__exceeding_octets','__violating_pkts','__violating_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers', 'scheduler', 'state']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/sequence (leafref)

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_conforming_pkts(self):
    """
    Getter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    return self.__conforming_pkts
      
  def _set_conforming_pkts(self, v, load=False):
    """
    Setter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_pkts() directly.

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_pkts(self):
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_conforming_octets(self):
    """
    Getter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    return self.__conforming_octets
      
  def _set_conforming_octets(self, v, load=False):
    """
    Setter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_octets() directly.

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_octets(self):
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_pkts(self):
    """
    Getter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    return self.__exceeding_pkts
      
  def _set_exceeding_pkts(self, v, load=False):
    """
    Setter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_pkts() directly.

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_pkts(self):
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_octets(self):
    """
    Getter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    return self.__exceeding_octets
      
  def _set_exceeding_octets(self, v, load=False):
    """
    Setter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_octets() directly.

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_octets(self):
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_pkts(self):
    """
    Getter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    return self.__violating_pkts
      
  def _set_violating_pkts(self, v, load=False):
    """
    Setter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_pkts() directly.

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_pkts(self):
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_octets(self):
    """
    Getter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    return self.__violating_octets
      
  def _set_violating_octets(self, v, load=False):
    """
    Setter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_octets() directly.

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_octets(self):
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  conforming_pkts = __builtin__.property(_get_conforming_pkts)
  conforming_octets = __builtin__.property(_get_conforming_octets)
  exceeding_pkts = __builtin__.property(_get_exceeding_pkts)
  exceeding_octets = __builtin__.property(_get_exceeding_octets)
  violating_pkts = __builtin__.property(_get_violating_pkts)
  violating_octets = __builtin__.property(_get_violating_octets)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('conforming_pkts', conforming_pkts), ('conforming_octets', conforming_octets), ('exceeding_pkts', exceeding_pkts), ('exceeding_octets', exceeding_octets), ('violating_pkts', violating_pkts), ('violating_octets', violating_octets), ])


class yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers/scheduler. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__state',)

  _yang_name = 'scheduler'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers', 'scheduler']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/sequence (leafref)

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state (container)

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('state', state), ])


class yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy/schedulers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Schedulers within the applied scheduler-policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__scheduler',)

  _yang_name = 'schedulers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy', 'schedulers']

  def _get_scheduler(self):
    """
    Getter method for scheduler, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler (list)

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    return self.__scheduler
      
  def _set_scheduler(self, v, load=False):
    """
    Setter method for scheduler, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers/scheduler (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler() directly.

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)""",
        })

    self.__scheduler = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler(self):
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

  scheduler = __builtin__.property(_get_scheduler)


  _pyangbind_elements = OrderedDict([('scheduler', scheduler), ])


class yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/scheduler-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Scheduler policy associated with the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__schedulers',)

  _yang_name = 'scheduler-policy'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'scheduler-policy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config (container)

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state (container)

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_schedulers(self):
    """
    Getter method for schedulers, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers (container)

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    return self.__schedulers
      
  def _set_schedulers(self, v, load=False):
    """
    Setter method for schedulers, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy/schedulers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_schedulers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_schedulers() directly.

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """schedulers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__schedulers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_schedulers(self):
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_input_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  schedulers = __builtin__.property(_get_schedulers, _set_schedulers)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('schedulers', schedulers), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config/name (string)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state/name (string)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)


  _pyangbind_elements = OrderedDict([('name', name), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues/voq-interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__queues',)

  _yang_name = 'voq-interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues', 'voq-interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/name (leafref)

    YANG Description: Name used to refer to the egress interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name used to refer to the egress interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config (container)

    YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to the interface
for which the VOQs are instantiated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state (container)

    YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the interface
for which the VOQs are instantiated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  queues = __builtin__.property(_get_queues, _set_queues)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('queues', queues), ])


class yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input/virtual-output-queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__voq_interface',)

  _yang_name = 'virtual-output-queues'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__voq_interface = YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input', 'virtual-output-queues']

  def _get_voq_interface(self):
    """
    Getter method for voq_interface, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface (list)

    YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
    """
    return self.__voq_interface
      
  def _set_voq_interface(self, v, load=False):
    """
    Setter method for voq_interface, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues/voq_interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_voq_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_voq_interface() directly.

    YANG Description: List of egress interfaces for which a virtual output
queue is instantiated at this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """voq_interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__voq_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_voq_interface(self):
    self.__voq_interface = YANGDynClass(base=YANGListType("name",yc_voq_interface_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues_voq_interface, yang_name="voq-interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="voq-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  voq_interface = __builtin__.property(_get_voq_interface, _set_voq_interface)


  _pyangbind_elements = OrderedDict([('voq_interface', voq_interface), ])


class yc_input_openconfig_qos__qos_interfaces_interface_input(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/input. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for QoS data for the ingress
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__classifiers','__queues','__scheduler_policy','__virtual_output_queues',)

  _yang_name = 'input'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__virtual_output_queues = YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'input']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/input/config (container)

    YANG Description: Configuration data for QoS on ingress interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/input/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for QoS on ingress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_input_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/input/state (container)

    YANG Description: Operational state data for QoS on ingress interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/input/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for QoS on ingress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_input_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_classifiers(self):
    """
    Getter method for classifiers, mapped from YANG variable /qos/interfaces/interface/input/classifiers (container)

    YANG Description: Classifiers to be applied to the interface.
    """
    return self.__classifiers
      
  def _set_classifiers(self, v, load=False):
    """
    Setter method for classifiers, mapped from YANG variable /qos/interfaces/interface/input/classifiers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifiers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifiers() directly.

    YANG Description: Classifiers to be applied to the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifiers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__classifiers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifiers(self):
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_input_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/input/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/input/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_input_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_scheduler_policy(self):
    """
    Getter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy (container)

    YANG Description: Scheduler policy associated with the interface.
    """
    return self.__scheduler_policy
      
  def _set_scheduler_policy(self, v, load=False):
    """
    Setter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/input/scheduler_policy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler_policy() directly.

    YANG Description: Scheduler policy associated with the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler_policy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__scheduler_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler_policy(self):
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_input_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_virtual_output_queues(self):
    """
    Getter method for virtual_output_queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues (container)

    YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
    """
    return self.__virtual_output_queues
      
  def _set_virtual_output_queues(self, v, load=False):
    """
    Setter method for virtual_output_queues, mapped from YANG variable /qos/interfaces/interface/input/virtual_output_queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_virtual_output_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_virtual_output_queues() directly.

    YANG Description: Surrounding container for the list of egress interfaces
for which virtual output queues are instantiated on this
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """virtual_output_queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__virtual_output_queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_virtual_output_queues(self):
    self.__virtual_output_queues = YANGDynClass(base=yc_virtual_output_queues_openconfig_qos__qos_interfaces_interface_input_virtual_output_queues, is_container='container', yang_name="virtual-output-queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  classifiers = __builtin__.property(_get_classifiers, _set_classifiers)
  queues = __builtin__.property(_get_queues, _set_queues)
  scheduler_policy = __builtin__.property(_get_scheduler_policy, _set_scheduler_policy)
  virtual_output_queues = __builtin__.property(_get_virtual_output_queues, _set_virtual_output_queues)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('classifiers', classifiers), ('queues', queues), ('scheduler_policy', scheduler_policy), ('virtual_output_queues', virtual_output_queues), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for QoS on the egress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'config']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/config/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile, _set_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile, _set_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile, _set_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for QoS on the egress interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__buffer_allocation_profile','__multicast_buffer_allocation_profile','__unicast_buffer_allocation_profile',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'state']

  def _get_buffer_allocation_profile(self):
    """
    Getter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    return self.__buffer_allocation_profile
      
  def _set_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This leaf is used in deployment cases where the operator or system
requires common allocation profiles covering unicast and multicast
packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_buffer_allocation_profile(self):
    self.__buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_multicast_buffer_allocation_profile(self):
    """
    Getter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/multicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__multicast_buffer_allocation_profile
      
  def _set_multicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for multicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/multicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only multicast packets on
the interface - if specified, the unicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to unicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__multicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_buffer_allocation_profile(self):
    self.__multicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_unicast_buffer_allocation_profile(self):
    """
    Getter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/unicast_buffer_allocation_profile (leafref)

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    return self.__unicast_buffer_allocation_profile
      
  def _set_unicast_buffer_allocation_profile(self, v, load=False):
    """
    Setter method for unicast_buffer_allocation_profile, mapped from YANG variable /qos/interfaces/interface/output/state/unicast_buffer_allocation_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_buffer_allocation_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_buffer_allocation_profile() directly.

    YANG Description: The buffer allocation profile that is to be used for the interface.
This profile specifies how memory that is available to the interface
should be allocated amongst the queues that are instantiated on the
interface.

This reference specifies the policy that should be used for memory
allocated to the output (tx) queueing.

This buffer allocation profile applies to only unicast packets on
the interface - if specified, the multicast-buffer-allocation-profile
governs the allocation profile used for memory dedicated to multicast.
If a system does not support, or an operator does not require separate
buffer-allocation-profiles, this is specified by use of the
buffer-allocation-profile leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_buffer_allocation_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__unicast_buffer_allocation_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_buffer_allocation_profile(self):
    self.__unicast_buffer_allocation_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-buffer-allocation-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  buffer_allocation_profile = __builtin__.property(_get_buffer_allocation_profile)
  multicast_buffer_allocation_profile = __builtin__.property(_get_multicast_buffer_allocation_profile)
  unicast_buffer_allocation_profile = __builtin__.property(_get_unicast_buffer_allocation_profile)


  _pyangbind_elements = OrderedDict([('buffer_allocation_profile', buffer_allocation_profile), ('multicast_buffer_allocation_profile', multicast_buffer_allocation_profile), ('unicast_buffer_allocation_profile', unicast_buffer_allocation_profile), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_qos__qos_interfaces_interface_output_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the list of classifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/name (leafref)

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the classifier to be applied to ingress traffic on
the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of packets matched by the classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of packets matched by the classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {'value': 4}, 'IPV6': {'value': 6}, 'MPLS': {}, 'IPV4_MULTICAST': {}, 'IPV6_MULTICAST': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for match terms in the classifier
associated with an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__matched_packets','__matched_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/id (leafref)

    YANG Description: Reference to match terms in the classifier
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match terms in the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching this classifier
match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching this
classifier match term on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  id = __builtin__.property(_get_id)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('id', id), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms/term. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of match terms in the classifier associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'term'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms', 'term']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/id (leafref)

    YANG Description: Reference to match term id list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to match term id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state (container)

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for match terms in the classifier
associated with an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier/terms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of match terms in the
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__term',)

  _yang_name = 'terms'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier', 'terms']

  def _get_term(self):
    """
    Getter method for term, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term (list)

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    return self.__term
      
  def _set_term(self, v, load=False):
    """
    Setter method for term, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms/term (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_term is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_term() directly.

    YANG Description: List of match terms in the classifier associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """term must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__term = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_term(self):
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  term = __builtin__.property(_get_term, _set_term)


  _pyangbind_elements = OrderedDict([('term', term), ])


class yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers/classifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of classifiers that should be applied to the interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__config','__state','__terms',)

  _yang_name = 'classifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers', 'classifier']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/type (leafref)

    YANG Description: Reference to the classifier name.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to the classifier name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config (container)

    YANG Description: Configuration parameters for the list of classifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state (container)

    YANG Description: Operational state parameters for the list of classifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the list of classifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_terms(self):
    """
    Getter method for terms, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms (container)

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    return self.__terms
      
  def _set_terms(self, v, load=False):
    """
    Setter method for terms, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier/terms (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terms is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terms() directly.

    YANG Description: Enclosing container for the list of match terms in the
classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terms must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__terms = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terms(self):
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  terms = __builtin__.property(_get_terms, _set_terms)


  _pyangbind_elements = OrderedDict([('type', type), ('config', config), ('state', state), ('terms', terms), ])


class yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/classifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Classifiers to be applied to the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__classifier',)

  _yang_name = 'classifiers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'classifiers']

  def _get_classifier(self):
    """
    Getter method for classifier, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier (list)

    YANG Description: A list of classifiers that should be applied to the interface
    """
    return self.__classifier
      
  def _set_classifier(self, v, load=False):
    """
    Setter method for classifier, mapped from YANG variable /qos/interfaces/interface/output/classifiers/classifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifier() directly.

    YANG Description: A list of classifiers that should be applied to the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__classifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifier(self):
    self.__classifier = YANGDynClass(base=YANGListType("type",yc_classifier_openconfig_qos__qos_interfaces_interface_output_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  classifier = __builtin__.property(_get_classifier, _set_classifier)


  _pyangbind_elements = OrderedDict([('classifier', classifier), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile, _set_queue_management_profile)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the queue associated with the
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__queue_management_profile','__max_queue_len','__avg_queue_len','__transmit_pkts','__transmit_octets','__dropped_pkts',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/name (string)

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the queue associated with this interface.
A queue may be explicitly configured, or implicitly created
by the system based on default queues that are instantiated
by a hardware component, or are assumed to be default on
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_queue_management_profile(self):
    """
    Getter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/queue_management_profile (leafref)

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    return self.__queue_management_profile
      
  def _set_queue_management_profile(self, v, load=False):
    """
    Setter method for queue_management_profile, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/queue_management_profile (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_management_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_management_profile() directly.

    YANG Description: The queue management profile that is to be used for the queue
on the interface.

For example, the system may use a profile which specifies that
WRED curves are used for setting an ECN mark in the IP header
instead of dropping a packet in order to signal impending
congestion and for determining when there is sufficient
congestion to tail drop packets.

A single profile is available per queue - which applies to all packets
that are enqueued to the specified queue, whether they are unicast or
multicast.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_management_profile must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__queue_management_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_management_profile(self):
    self.__queue_management_profile = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="queue-management-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_max_queue_len(self):
    """
    Getter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/max_queue_len (oc-yang:counter64)

    YANG Description: Maximum observed queue length
    """
    return self.__max_queue_len
      
  def _set_max_queue_len(self, v, load=False):
    """
    Setter method for max_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/max_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_queue_len() directly.

    YANG Description: Maximum observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__max_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_queue_len(self):
    self.__max_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_avg_queue_len(self):
    """
    Getter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/avg_queue_len (oc-yang:counter64)

    YANG Description: Average observed queue length
    """
    return self.__avg_queue_len
      
  def _set_avg_queue_len(self, v, load=False):
    """
    Setter method for avg_queue_len, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/avg_queue_len (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_queue_len is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_queue_len() directly.

    YANG Description: Average observed queue length
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_queue_len must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__avg_queue_len = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_queue_len(self):
    self.__avg_queue_len = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-queue-len", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_pkts(self):
    """
    Getter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_pkts (oc-yang:counter64)

    YANG Description: Number of packets transmitted by this queue
    """
    return self.__transmit_pkts
      
  def _set_transmit_pkts(self, v, load=False):
    """
    Setter method for transmit_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_pkts() directly.

    YANG Description: Number of packets transmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_pkts(self):
    self.__transmit_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_transmit_octets(self):
    """
    Getter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_octets (oc-yang:counter64)

    YANG Description: Number of octets trasmitted by this queue
    """
    return self.__transmit_octets
      
  def _set_transmit_octets(self, v, load=False):
    """
    Setter method for transmit_octets, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/transmit_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmit_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmit_octets() directly.

    YANG Description: Number of octets trasmitted by this queue
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmit_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__transmit_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmit_octets(self):
    self.__transmit_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmit-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_dropped_pkts(self):
    """
    Getter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_pkts (oc-yang:counter64)

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    return self.__dropped_pkts
      
  def _set_dropped_pkts(self, v, load=False):
    """
    Setter method for dropped_pkts, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state/dropped_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dropped_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dropped_pkts() directly.

    YANG Description: Number of packets dropped by the queue due to overrun
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dropped_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__dropped_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dropped_pkts(self):
    self.__dropped_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dropped-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  queue_management_profile = __builtin__.property(_get_queue_management_profile)
  max_queue_len = __builtin__.property(_get_max_queue_len)
  avg_queue_len = __builtin__.property(_get_avg_queue_len)
  transmit_pkts = __builtin__.property(_get_transmit_pkts)
  transmit_octets = __builtin__.property(_get_transmit_octets)
  dropped_pkts = __builtin__.property(_get_dropped_pkts)


  _pyangbind_elements = OrderedDict([('name', name), ('queue_management_profile', queue_management_profile), ('max_queue_len', max_queue_len), ('avg_queue_len', avg_queue_len), ('transmit_pkts', transmit_pkts), ('transmit_octets', transmit_octets), ('dropped_pkts', dropped_pkts), ])


class yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues/queue. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the queue associated with this
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'queue'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues', 'queue']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/name (leafref)

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the queue
instantiated on the interface.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config (container)

    YANG Description: Configuration data for the queue associated with the
interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_queues_queue_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state (container)

    YANG Description: Operational state data for the queue associated with the
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/queues/queue/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the queue associated with the
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_queues_queue_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_queues_openconfig_qos__qos_interfaces_interface_output_queues(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/queues. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__queue',)

  _yang_name = 'queues'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'queues']

  def _get_queue(self):
    """
    Getter method for queue, mapped from YANG variable /qos/interfaces/interface/output/queues/queue (list)

    YANG Description: Top-level container for the queue associated with this
interface
    """
    return self.__queue
      
  def _set_queue(self, v, load=False):
    """
    Setter method for queue, mapped from YANG variable /qos/interfaces/interface/output/queues/queue (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue() directly.

    YANG Description: Top-level container for the queue associated with this
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue(self):
    self.__queue = YANGDynClass(base=YANGListType("name",yc_queue_openconfig_qos__qos_interfaces_interface_output_queues_queue, yang_name="queue", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  queue = __builtin__.property(_get_queue, _set_queue)


  _pyangbind_elements = OrderedDict([('queue', queue), ])


class yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state/name (leafref)

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The scheduler policy to be applied to traffic on this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers/scheduler/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the scheduler
policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__conforming_pkts','__conforming_octets','__exceeding_pkts','__exceeding_octets','__violating_pkts','__violating_octets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers', 'scheduler', 'state']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/sequence (leafref)

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID of the scheduler within
the current scheduler policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_conforming_pkts(self):
    """
    Getter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    return self.__conforming_pkts
      
  def _set_conforming_pkts(self, v, load=False):
    """
    Setter method for conforming_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_pkts() directly.

    YANG Description: The number of packets that were considered conforming by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_pkts(self):
    self.__conforming_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_conforming_octets(self):
    """
    Getter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    return self.__conforming_octets
      
  def _set_conforming_octets(self, v, load=False):
    """
    Setter method for conforming_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/conforming_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conforming_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conforming_octets() directly.

    YANG Description: The number of octets in packets that were considered
conforming by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conforming_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__conforming_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conforming_octets(self):
    self.__conforming_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="conforming-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_pkts(self):
    """
    Getter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    return self.__exceeding_pkts
      
  def _set_exceeding_pkts(self, v, load=False):
    """
    Setter method for exceeding_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_pkts() directly.

    YANG Description: The number of packets that were considered exceeding by
the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_pkts(self):
    self.__exceeding_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_exceeding_octets(self):
    """
    Getter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    return self.__exceeding_octets
      
  def _set_exceeding_octets(self, v, load=False):
    """
    Setter method for exceeding_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/exceeding_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exceeding_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exceeding_octets() directly.

    YANG Description: The number of octets in packets that were considered
exceeding by the scheduler.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exceeding_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__exceeding_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exceeding_octets(self):
    self.__exceeding_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="exceeding-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_pkts(self):
    """
    Getter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    return self.__violating_pkts
      
  def _set_violating_pkts(self, v, load=False):
    """
    Setter method for violating_pkts, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_pkts() directly.

    YANG Description: The number of packets that were considered violating by
the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_pkts(self):
    self.__violating_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)


  def _get_violating_octets(self):
    """
    Getter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    return self.__violating_octets
      
  def _set_violating_octets(self, v, load=False):
    """
    Setter method for violating_octets, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state/violating_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_violating_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_violating_octets() directly.

    YANG Description: The number of octets in packets that were considered
violating by the policer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """violating_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__violating_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_violating_octets(self):
    self.__violating_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="violating-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:counter64', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  conforming_pkts = __builtin__.property(_get_conforming_pkts)
  conforming_octets = __builtin__.property(_get_conforming_octets)
  exceeding_pkts = __builtin__.property(_get_exceeding_pkts)
  exceeding_octets = __builtin__.property(_get_exceeding_octets)
  violating_pkts = __builtin__.property(_get_violating_pkts)
  violating_octets = __builtin__.property(_get_violating_octets)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('conforming_pkts', conforming_pkts), ('conforming_octets', conforming_octets), ('exceeding_pkts', exceeding_pkts), ('exceeding_octets', exceeding_octets), ('violating_pkts', violating_pkts), ('violating_octets', violating_octets), ])


class yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers/scheduler. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence','__state',)

  _yang_name = 'scheduler'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers', 'scheduler']

  def _get_sequence(self):
    """
    Getter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/sequence (leafref)

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    return self.__sequence
      
  def _set_sequence(self, v, load=False):
    """
    Setter method for sequence, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/sequence (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence() directly.

    YANG Description: Reference to the sequence ID for the scheduler.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__sequence = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence(self):
    self.__sequence = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sequence", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state (container)

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the scheduler
policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=False)

  sequence = __builtin__.property(_get_sequence)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sequence', sequence), ('state', state), ])


class yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy/schedulers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Schedulers within the applied scheduler-policy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__scheduler',)

  _yang_name = 'schedulers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy', 'schedulers']

  def _get_scheduler(self):
    """
    Getter method for scheduler, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler (list)

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    return self.__scheduler
      
  def _set_scheduler(self, v, load=False):
    """
    Setter method for scheduler, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers/scheduler (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler() directly.

    YANG Description: List of the schedulers that are part of the scheduler-policy
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)""",
        })

    self.__scheduler = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler(self):
    self.__scheduler = YANGDynClass(base=YANGListType("sequence",yc_scheduler_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers_scheduler, yang_name="scheduler", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None), is_container='list', yang_name="scheduler", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=False)

  scheduler = __builtin__.property(_get_scheduler)


  _pyangbind_elements = OrderedDict([('scheduler', scheduler), ])


class yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output/scheduler-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Scheduler policy associated with the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__schedulers',)

  _yang_name = 'scheduler-policy'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output', 'scheduler-policy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config (container)

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to a scheduler policy on
an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state (container)

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to a scheduler policy
on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_schedulers(self):
    """
    Getter method for schedulers, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers (container)

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    return self.__schedulers
      
  def _set_schedulers(self, v, load=False):
    """
    Setter method for schedulers, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy/schedulers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_schedulers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_schedulers() directly.

    YANG Description: Schedulers within the applied scheduler-policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """schedulers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__schedulers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_schedulers(self):
    self.__schedulers = YANGDynClass(base=yc_schedulers_openconfig_qos__qos_interfaces_interface_output_scheduler_policy_schedulers, is_container='container', yang_name="schedulers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  schedulers = __builtin__.property(_get_schedulers, _set_schedulers)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('schedulers', schedulers), ])


class yc_output_openconfig_qos__qos_interfaces_interface_output(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface/output. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for QoS data related to the egress
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__interface_ref','__classifiers','__queues','__scheduler_policy',)

  _yang_name = 'output'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_output_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface', 'output']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/output/config (container)

    YANG Description: Configuration data for QoS on the egress interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/output/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for QoS on the egress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_output_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/output/state (container)

    YANG Description: Operational state data for QoS on the egress interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/output/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for QoS on the egress interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_output_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/output/interface_ref (container)

    YANG Description: Reference to an interface or subinterface
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/output/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_output_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_output_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_output_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_classifiers(self):
    """
    Getter method for classifiers, mapped from YANG variable /qos/interfaces/interface/output/classifiers (container)

    YANG Description: Classifiers to be applied to the interface.
    """
    return self.__classifiers
      
  def _set_classifiers(self, v, load=False):
    """
    Setter method for classifiers, mapped from YANG variable /qos/interfaces/interface/output/classifiers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifiers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifiers() directly.

    YANG Description: Classifiers to be applied to the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifiers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__classifiers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifiers(self):
    self.__classifiers = YANGDynClass(base=yc_classifiers_openconfig_qos__qos_interfaces_interface_output_classifiers, is_container='container', yang_name="classifiers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_queues(self):
    """
    Getter method for queues, mapped from YANG variable /qos/interfaces/interface/output/queues (container)

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    return self.__queues
      
  def _set_queues(self, v, load=False):
    """
    Setter method for queues, mapped from YANG variable /qos/interfaces/interface/output/queues (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queues is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queues() directly.

    YANG Description: Surrounding container for a list of queues that are
instantiated on an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queues must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__queues = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queues(self):
    self.__queues = YANGDynClass(base=yc_queues_openconfig_qos__qos_interfaces_interface_output_queues, is_container='container', yang_name="queues", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_scheduler_policy(self):
    """
    Getter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy (container)

    YANG Description: Scheduler policy associated with the interface.
    """
    return self.__scheduler_policy
      
  def _set_scheduler_policy(self, v, load=False):
    """
    Setter method for scheduler_policy, mapped from YANG variable /qos/interfaces/interface/output/scheduler_policy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scheduler_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scheduler_policy() directly.

    YANG Description: Scheduler policy associated with the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scheduler_policy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__scheduler_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scheduler_policy(self):
    self.__scheduler_policy = YANGDynClass(base=yc_scheduler_policy_openconfig_qos__qos_interfaces_interface_output_scheduler_policy, is_container='container', yang_name="scheduler-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  classifiers = __builtin__.property(_get_classifiers, _set_classifiers)
  queues = __builtin__.property(_get_queues, _set_queues)
  scheduler_policy = __builtin__.property(_get_scheduler_policy, _set_scheduler_policy)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('interface_ref', interface_ref), ('classifiers', classifiers), ('queues', queues), ('scheduler_policy', scheduler_policy), ])


class yc_interface_openconfig_qos__qos_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces referenced by QoS entities.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_id','__config','__state','__interface_ref','__input','__output',)

  _yang_name = 'interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__input = YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__output = YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces', 'interface']

  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /qos/interfaces/interface/interface_id (leafref)

    YANG Description: Reference to the interface-id list key
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /qos/interfaces/interface/interface_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Reference to the interface-id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/interfaces/interface/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/interfaces/interface/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /qos/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_qos__qos_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_input(self):
    """
    Getter method for input, mapped from YANG variable /qos/interfaces/interface/input (container)

    YANG Description: Top-level container for QoS data for the ingress
interface
    """
    return self.__input
      
  def _set_input(self, v, load=False):
    """
    Setter method for input, mapped from YANG variable /qos/interfaces/interface/input (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input() directly.

    YANG Description: Top-level container for QoS data for the ingress
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__input = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input(self):
    self.__input = YANGDynClass(base=yc_input_openconfig_qos__qos_interfaces_interface_input, is_container='container', yang_name="input", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_output(self):
    """
    Getter method for output, mapped from YANG variable /qos/interfaces/interface/output (container)

    YANG Description: Top-level container for QoS data related to the egress
interface
    """
    return self.__output
      
  def _set_output(self, v, load=False):
    """
    Setter method for output, mapped from YANG variable /qos/interfaces/interface/output (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output() directly.

    YANG Description: Top-level container for QoS data related to the egress
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__output = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output(self):
    self.__output = YANGDynClass(base=yc_output_openconfig_qos__qos_interfaces_interface_output, is_container='container', yang_name="output", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  interface_id = __builtin__.property(_get_interface_id, _set_interface_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  input = __builtin__.property(_get_input, _set_input)
  output = __builtin__.property(_get_output, _set_output)


  _pyangbind_elements = OrderedDict([('interface_id', interface_id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('input', input), ('output', output), ])


class yc_interfaces_openconfig_qos__qos_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /qos/interfaces/interface (list)

    YANG Description: List of interfaces referenced by QoS entities.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /qos/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces referenced by QoS entities.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("interface_id",yc_interface_openconfig_qos__qos_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface-id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for classifers
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/classifiers/classifier/config/name (string)

    YANG Description: User-assigned name of the classifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/classifiers/classifier/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-assigned name of the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/config/type (enumeration)

    YANG Description: Type of classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/config/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for classifiers
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/classifiers/classifier/state/name (string)

    YANG Description: User-assigned name of the classifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/classifiers/classifier/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User-assigned name of the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /qos/classifiers/classifier/state/type (enumeration)

    YANG Description: Type of classifier.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /qos/classifiers/classifier/state/type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of classifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-qos:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4': {}, 'IPV6': {}, 'MPLS': {}, 'ETHERNET': {}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='enumeration', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for list of match criteria in a QoS
classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/config/id (string)

    YANG Description: Identifier for the match term
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/config/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifier for the match term
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)

  id = __builtin__.property(_get_id, _set_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for list of match criteria in a
QoS classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/state/id (string)

    YANG Description: Identifier for the match term
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifier for the match term
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=False)

  id = __builtin__.property(_get_id)


  _pyangbind_elements = OrderedDict([('id', id), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2', 'config']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=True)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

  source_mac = __builtin__.property(_get_source_mac, _set_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask, _set_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac, _set_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask, _set_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype, _set_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State Information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2', 'state']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-yang:mac-address', is_config=False)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

  source_mac = __builtin__.property(_get_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/l2. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'l2'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'l2']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state (container)

    YANG Description: State Information.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State Information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__destination_address','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('destination_address', destination_address), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__destination_address','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  destination_address = __builtin__.property(_get_destination_address)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('destination_address', destination_address), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for IPv4 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ipv4'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config (container)

    YANG Description: Configuration data for IPv4 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state (container)

    YANG Description: State information for IPv4 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_flow_label','__destination_address','__destination_flow_label','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv6', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_flow_label = __builtin__.property(_get_source_flow_label, _set_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_flow_label = __builtin__.property(_get_destination_flow_label, _set_destination_flow_label)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_flow_label','__destination_address','__destination_flow_label','__dscp','__dscp_set','__protocol','__hop_limit',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv6', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_flow_label = __builtin__.property(_get_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address)
  destination_flow_label = __builtin__.property(_get_destination_flow_label)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_ipv6_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/ipv6. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for IPv6 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ipv6'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'ipv6']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config (container)

    YANG Description: Configuration data for IPv6 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state (container)

    YANG Description: Operational state data for IPv6 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/transport/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__destination_port','__tcp_flags',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'transport', 'config']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_tcp_flags(self):
    """
    Getter method for tcp_flags, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/tcp_flags (identityref)

    YANG Description: List of TCP flags to match
    """
    return self.__tcp_flags
      
  def _set_tcp_flags(self, v, load=False):
    """
    Setter method for tcp_flags, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config/tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tcp_flags() directly.

    YANG Description: List of TCP flags to match
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)""",
        })

    self.__tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tcp_flags(self):
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=True)

  source_port = __builtin__.property(_get_source_port, _set_source_port)
  destination_port = __builtin__.property(_get_destination_port, _set_destination_port)
  tcp_flags = __builtin__.property(_get_tcp_flags, _set_tcp_flags)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('destination_port', destination_port), ('tcp_flags', tcp_flags), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/transport/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__destination_port','__tcp_flags',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'transport', 'state']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_tcp_flags(self):
    """
    Getter method for tcp_flags, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/tcp_flags (identityref)

    YANG Description: List of TCP flags to match
    """
    return self.__tcp_flags
      
  def _set_tcp_flags(self, v, load=False):
    """
    Setter method for tcp_flags, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state/tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tcp_flags() directly.

    YANG Description: List of TCP flags to match
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-qos:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)""",
        })

    self.__tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tcp_flags(self):
    self.__tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='identityref', is_config=False)

  source_port = __builtin__.property(_get_source_port)
  destination_port = __builtin__.property(_get_destination_port)
  tcp_flags = __builtin__.property(_get_tcp_flags)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('destination_port', destination_port), ('tcp_flags', tcp_flags), ])


class yc_transport_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/transport. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Transport fields container
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'transport'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'transport']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state (container)

    YANG Description: State data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/mpls/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to fields within
the MPLS header.
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=True)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'mpls', 'config']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=True)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=True)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  traffic_class = __builtin__.property(_get_traffic_class, _set_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value, _set_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value, _set_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value, _set_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/mpls/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to fields
within the MPLS header
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=False)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'mpls', 'state']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=False)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-tc', is_config=False)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  traffic_class = __builtin__.property(_get_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_mpls_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions/mpls. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MPLS header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'mpls'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions', 'mpls']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config (container)

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state (container)

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_conditions_openconfig_qos__qos_classifiers_classifier_terms_term_conditions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/conditions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Conditions for the classifier term. Packets must match all of
the criteria specified within the match condition to be considered
matching the term.
  """
  __slots__ = ('_path_helper', '_extmethods', '__l2','__ipv4','__ipv6','__transport','__mpls',)

  _yang_name = 'conditions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__l2 = YANGDynClass(base=yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__ipv4 = YANGDynClass(base=yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__ipv6 = YANGDynClass(base=yc_ipv6_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__transport = YANGDynClass(base=yc_transport_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__mpls = YANGDynClass(base=yc_mpls_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'conditions']

  def _get_l2(self):
    """
    Getter method for l2, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2 (container)

    YANG Description: Ethernet header fields
    """
    return self.__l2
      
  def _set_l2(self, v, load=False):
    """
    Setter method for l2, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/l2 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l2 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l2() directly.

    YANG Description: Ethernet header fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l2 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__l2 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l2(self):
    self.__l2 = YANGDynClass(base=yc_l2_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_l2, is_container='container', yang_name="l2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_ipv4(self):
    """
    Getter method for ipv4, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4 (container)

    YANG Description: Top level container for IPv4 match field data
    """
    return self.__ipv4
      
  def _set_ipv4(self, v, load=False):
    """
    Setter method for ipv4, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv4 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv4() directly.

    YANG Description: Top level container for IPv4 match field data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv4 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv4(self):
    self.__ipv4 = YANGDynClass(base=yc_ipv4_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv4, is_container='container', yang_name="ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_ipv6(self):
    """
    Getter method for ipv6, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6 (container)

    YANG Description: Top-level container for IPv6 match field data
    """
    return self.__ipv6
      
  def _set_ipv6(self, v, load=False):
    """
    Setter method for ipv6, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/ipv6 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6() directly.

    YANG Description: Top-level container for IPv6 match field data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv6_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv6_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6(self):
    self.__ipv6 = YANGDynClass(base=yc_ipv6_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_ipv6, is_container='container', yang_name="ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_transport(self):
    """
    Getter method for transport, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport (container)

    YANG Description: Transport fields container
    """
    return self.__transport
      
  def _set_transport(self, v, load=False):
    """
    Setter method for transport, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/transport (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transport is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transport() directly.

    YANG Description: Transport fields container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_transport_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transport must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_transport_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__transport = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transport(self):
    self.__transport = YANGDynClass(base=yc_transport_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_transport, is_container='container', yang_name="transport", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_mpls(self):
    """
    Getter method for mpls, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls (container)

    YANG Description: MPLS header fields
    """
    return self.__mpls
      
  def _set_mpls(self, v, load=False):
    """
    Setter method for mpls, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions/mpls (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mpls is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mpls() directly.

    YANG Description: MPLS header fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mpls_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mpls must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mpls_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__mpls = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mpls(self):
    self.__mpls = YANGDynClass(base=yc_mpls_openconfig_qos__qos_classifiers_classifier_terms_term_conditions_mpls, is_container='container', yang_name="mpls", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  l2 = __builtin__.property(_get_l2, _set_l2)
  ipv4 = __builtin__.property(_get_ipv4, _set_ipv4)
  ipv6 = __builtin__.property(_get_ipv6, _set_ipv6)
  transport = __builtin__.property(_get_transport, _set_transport)
  mpls = __builtin__.property(_get_mpls, _set_mpls)


  _pyangbind_elements = OrderedDict([('l2', l2), ('ipv4', ipv4), ('ipv6', ipv6), ('transport', transport), ('mpls', mpls), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Actions to be applied to packets that match the classifier
term.
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_group',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions', 'config']

  def _get_target_group(self):
    """
    Getter method for target_group, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/config/target_group (leafref)

    YANG Description: References the forwarding group or class to which the
matched packets should be assigned
    """
    return self.__target_group
      
  def _set_target_group(self, v, load=False):
    """
    Setter method for target_group, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/config/target_group (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_group() directly.

    YANG Description: References the forwarding group or class to which the
matched packets should be assigned
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_group must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__target_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_group(self):
    self.__target_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

  target_group = __builtin__.property(_get_target_group, _set_target_group)


  _pyangbind_elements = OrderedDict([('target_group', target_group), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters associated with classifier term
actions
  """
  __slots__ = ('_path_helper', '_extmethods', '__target_group',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions', 'state']

  def _get_target_group(self):
    """
    Getter method for target_group, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/state/target_group (leafref)

    YANG Description: References the forwarding group or class to which the
matched packets should be assigned
    """
    return self.__target_group
      
  def _set_target_group(self, v, load=False):
    """
    Setter method for target_group, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/state/target_group (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_group() directly.

    YANG Description: References the forwarding group or class to which the
matched packets should be assigned
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_group must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)""",
        })

    self.__target_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_group(self):
    self.__target_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=False)

  target_group = __builtin__.property(_get_target_group)


  _pyangbind_elements = OrderedDict([('target_group', target_group), ])


class yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions/remark/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to remarking packets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_dscp','__set_dot1p','__set_mpls_tc',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_dscp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    self.__set_dot1p = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    self.__set_mpls_tc = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions', 'remark', 'config']

  def _get_set_dscp(self):
    """
    Getter method for set_dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_dscp (uint8)

    YANG Description: Sets the 6-bit DSCP (differentiated services code point)
value in the IP packet header.
    """
    return self.__set_dscp
      
  def _set_set_dscp(self, v, load=False):
    """
    Setter method for set_dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_dscp (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_dscp() directly.

    YANG Description: Sets the 6-bit DSCP (differentiated services code point)
value in the IP packet header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_dscp must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__set_dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_dscp(self):
    self.__set_dscp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)


  def _get_set_dot1p(self):
    """
    Getter method for set_dot1p, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_dot1p (uint8)

    YANG Description: Sets the 3-bit class-of-service value in the
Ethernet packet header for 802.1Q VLAN-tagged packets,
also known as PCP (priority code point).
    """
    return self.__set_dot1p
      
  def _set_set_dot1p(self, v, load=False):
    """
    Setter method for set_dot1p, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_dot1p (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_dot1p is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_dot1p() directly.

    YANG Description: Sets the 3-bit class-of-service value in the
Ethernet packet header for 802.1Q VLAN-tagged packets,
also known as PCP (priority code point).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_dot1p must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__set_dot1p = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_dot1p(self):
    self.__set_dot1p = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)


  def _get_set_mpls_tc(self):
    """
    Getter method for set_mpls_tc, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_mpls_tc (uint8)

    YANG Description: Sets the 3-bit traffic class value (also referred to as EXP
or CoS) in MPLS packets.
    """
    return self.__set_mpls_tc
      
  def _set_set_mpls_tc(self, v, load=False):
    """
    Setter method for set_mpls_tc, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config/set_mpls_tc (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_mpls_tc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_mpls_tc() directly.

    YANG Description: Sets the 3-bit traffic class value (also referred to as EXP
or CoS) in MPLS packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_mpls_tc must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__set_mpls_tc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_mpls_tc(self):
    self.__set_mpls_tc = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)

  set_dscp = __builtin__.property(_get_set_dscp, _set_set_dscp)
  set_dot1p = __builtin__.property(_get_set_dot1p, _set_set_dot1p)
  set_mpls_tc = __builtin__.property(_get_set_mpls_tc, _set_set_mpls_tc)


  _pyangbind_elements = OrderedDict([('set_dscp', set_dscp), ('set_dot1p', set_dot1p), ('set_mpls_tc', set_mpls_tc), ])


class yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions/remark/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to remarking packets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__set_dscp','__set_dot1p','__set_mpls_tc',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__set_dscp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    self.__set_dot1p = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    self.__set_mpls_tc = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions', 'remark', 'state']

  def _get_set_dscp(self):
    """
    Getter method for set_dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_dscp (uint8)

    YANG Description: Sets the 6-bit DSCP (differentiated services code point)
value in the IP packet header.
    """
    return self.__set_dscp
      
  def _set_set_dscp(self, v, load=False):
    """
    Setter method for set_dscp, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_dscp (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_dscp() directly.

    YANG Description: Sets the 6-bit DSCP (differentiated services code point)
value in the IP packet header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_dscp must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__set_dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_dscp(self):
    self.__set_dscp = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)


  def _get_set_dot1p(self):
    """
    Getter method for set_dot1p, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_dot1p (uint8)

    YANG Description: Sets the 3-bit class-of-service value in the
Ethernet packet header for 802.1Q VLAN-tagged packets,
also known as PCP (priority code point).
    """
    return self.__set_dot1p
      
  def _set_set_dot1p(self, v, load=False):
    """
    Setter method for set_dot1p, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_dot1p (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_dot1p is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_dot1p() directly.

    YANG Description: Sets the 3-bit class-of-service value in the
Ethernet packet header for 802.1Q VLAN-tagged packets,
also known as PCP (priority code point).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_dot1p must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__set_dot1p = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_dot1p(self):
    self.__set_dot1p = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-dot1p", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)


  def _get_set_mpls_tc(self):
    """
    Getter method for set_mpls_tc, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_mpls_tc (uint8)

    YANG Description: Sets the 3-bit traffic class value (also referred to as EXP
or CoS) in MPLS packets.
    """
    return self.__set_mpls_tc
      
  def _set_set_mpls_tc(self, v, load=False):
    """
    Setter method for set_mpls_tc, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state/set_mpls_tc (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_set_mpls_tc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_set_mpls_tc() directly.

    YANG Description: Sets the 3-bit traffic class value (also referred to as EXP
or CoS) in MPLS packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """set_mpls_tc must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)""",
        })

    self.__set_mpls_tc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_set_mpls_tc(self):
    self.__set_mpls_tc = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="set-mpls-tc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=False)

  set_dscp = __builtin__.property(_get_set_dscp)
  set_dot1p = __builtin__.property(_get_set_dot1p)
  set_mpls_tc = __builtin__.property(_get_set_mpls_tc)


  _pyangbind_elements = OrderedDict([('set_dscp', set_dscp), ('set_dot1p', set_dot1p), ('set_mpls_tc', set_mpls_tc), ])


class yc_remark_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions/remark. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Remark actions to be associated with packets that match the
classifier term. Where a packet matches these criteria, the
specified rewrite actions should be performed.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'remark'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions', 'remark']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config (container)

    YANG Description: Configuration parameters relating to remarking packets.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to remarking packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state (container)

    YANG Description: Operational state parameters relating to remarking packets.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to remarking packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_actions_openconfig_qos__qos_classifiers_classifier_terms_term_actions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term/actions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Actions to be applied for packets matching the specified
classification rules.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__remark',)

  _yang_name = 'actions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__remark = YANGDynClass(base=yc_remark_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark, is_container='container', yang_name="remark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term', 'actions']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/config (container)

    YANG Description: Actions to be applied to packets that match the classifier
term.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Actions to be applied to packets that match the classifier
term.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_actions_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/state (container)

    YANG Description: Operational state parameters associated with classifier term
actions
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters associated with classifier term
actions
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_actions_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_remark(self):
    """
    Getter method for remark, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark (container)

    YANG Description: Remark actions to be associated with packets that match the
classifier term. Where a packet matches these criteria, the
specified rewrite actions should be performed.
    """
    return self.__remark
      
  def _set_remark(self, v, load=False):
    """
    Setter method for remark, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions/remark (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remark() directly.

    YANG Description: Remark actions to be associated with packets that match the
classifier term. Where a packet matches these criteria, the
specified rewrite actions should be performed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_remark_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark, is_container='container', yang_name="remark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remark must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_remark_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark, is_container='container', yang_name="remark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__remark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remark(self):
    self.__remark = YANGDynClass(base=yc_remark_openconfig_qos__qos_classifiers_classifier_terms_term_actions_remark, is_container='container', yang_name="remark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  remark = __builtin__.property(_get_remark, _set_remark)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('remark', remark), ])


class yc_term_openconfig_qos__qos_classifiers_classifier_terms_term(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms/term. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of match terms used in the classifier
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__conditions','__actions',)

  _yang_name = 'term'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__conditions = YANGDynClass(base=yc_conditions_openconfig_qos__qos_classifiers_classifier_terms_term_conditions, is_container='container', yang_name="conditions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__actions = YANGDynClass(base=yc_actions_openconfig_qos__qos_classifiers_classifier_terms_term_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms', 'term']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/id (leafref)

    YANG Description: Reference to id list key.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /qos/classifiers/classifier/terms/term/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to id list key.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/config (container)

    YANG Description: Configuration data for list of match criteria in a QoS
classifier
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/terms/term/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for list of match criteria in a QoS
classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_terms_term_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/state (container)

    YANG Description: Operational state data for list of match criteria in a
QoS classifier
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/terms/term/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for list of match criteria in a
QoS classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_terms_term_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_conditions(self):
    """
    Getter method for conditions, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions (container)

    YANG Description: Conditions for the classifier term. Packets must match all of
the criteria specified within the match condition to be considered
matching the term.
    """
    return self.__conditions
      
  def _set_conditions(self, v, load=False):
    """
    Setter method for conditions, mapped from YANG variable /qos/classifiers/classifier/terms/term/conditions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_conditions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_conditions() directly.

    YANG Description: Conditions for the classifier term. Packets must match all of
the criteria specified within the match condition to be considered
matching the term.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_conditions_openconfig_qos__qos_classifiers_classifier_terms_term_conditions, is_container='container', yang_name="conditions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """conditions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_conditions_openconfig_qos__qos_classifiers_classifier_terms_term_conditions, is_container='container', yang_name="conditions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__conditions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_conditions(self):
    self.__conditions = YANGDynClass(base=yc_conditions_openconfig_qos__qos_classifiers_classifier_terms_term_conditions, is_container='container', yang_name="conditions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_actions(self):
    """
    Getter method for actions, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions (container)

    YANG Description: Actions to be applied for packets matching the specified
classification rules.
    """
    return self.__actions
      
  def _set_actions(self, v, load=False):
    """
    Setter method for actions, mapped from YANG variable /qos/classifiers/classifier/terms/term/actions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_actions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_actions() directly.

    YANG Description: Actions to be applied for packets matching the specified
classification rules.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_actions_openconfig_qos__qos_classifiers_classifier_terms_term_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """actions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_actions_openconfig_qos__qos_classifiers_classifier_terms_term_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__actions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_actions(self):
    self.__actions = YANGDynClass(base=yc_actions_openconfig_qos__qos_classifiers_classifier_terms_term_actions, is_container='container', yang_name="actions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  conditions = __builtin__.property(_get_conditions, _set_conditions)
  actions = __builtin__.property(_get_actions, _set_actions)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('conditions', conditions), ('actions', actions), ])


class yc_terms_openconfig_qos__qos_classifiers_classifier_terms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier/terms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for ths list of terms
  """
  __slots__ = ('_path_helper', '_extmethods', '__term',)

  _yang_name = 'terms'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier', 'terms']

  def _get_term(self):
    """
    Getter method for term, mapped from YANG variable /qos/classifiers/classifier/terms/term (list)

    YANG Description: List of match terms used in the classifier
    """
    return self.__term
      
  def _set_term(self, v, load=False):
    """
    Setter method for term, mapped from YANG variable /qos/classifiers/classifier/terms/term (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_term is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_term() directly.

    YANG Description: List of match terms used in the classifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_term_openconfig_qos__qos_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """term must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__term = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_term(self):
    self.__term = YANGDynClass(base=YANGListType("id",yc_term_openconfig_qos__qos_classifiers_classifier_terms_term, yang_name="term", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="term", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  term = __builtin__.property(_get_term, _set_term)


  _pyangbind_elements = OrderedDict([('term', term), ])


class yc_classifier_openconfig_qos__qos_classifiers_classifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers/classifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of classifier elements
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__terms',)

  _yang_name = 'classifier'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers', 'classifier']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/classifiers/classifier/name (leafref)

    YANG Description: Reference to list key name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/classifiers/classifier/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to list key name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /qos/classifiers/classifier/config (container)

    YANG Description: Configuration data for classifers
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /qos/classifiers/classifier/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for classifers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_qos__qos_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_qos__qos_classifiers_classifier_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /qos/classifiers/classifier/state (container)

    YANG Description: Operational state data for classifiers
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /qos/classifiers/classifier/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for classifiers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_qos__qos_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_qos__qos_classifiers_classifier_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)


  def _get_terms(self):
    """
    Getter method for terms, mapped from YANG variable /qos/classifiers/classifier/terms (container)

    YANG Description: Enclosing container for ths list of terms
    """
    return self.__terms
      
  def _set_terms(self, v, load=False):
    """
    Setter method for terms, mapped from YANG variable /qos/classifiers/classifier/terms (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terms is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terms() directly.

    YANG Description: Enclosing container for ths list of terms
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terms_openconfig_qos__qos_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terms must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terms_openconfig_qos__qos_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)""",
        })

    self.__terms = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terms(self):
    self.__terms = YANGDynClass(base=yc_terms_openconfig_qos__qos_classifiers_classifier_terms, is_container='container', yang_name="terms", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  terms = __builtin__.property(_get_terms, _set_terms)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('terms', terms), ])


class yc_classifiers_openconfig_qos__qos_classifiers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/classifiers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for QoS classifiers
  """
  __slots__ = ('_path_helper', '_extmethods', '__classifier',)

  _yang_name = 'classifiers'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__classifier = YANGDynClass(base=YANGListType("name",yc_classifier_openconfig_qos__qos_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'classifiers']

  def _get_classifier(self):
    """
    Getter method for classifier, mapped from YANG variable /qos/classifiers/classifier (list)

    YANG Description: List of classifier elements
    """
    return self.__classifier
      
  def _set_classifier(self, v, load=False):
    """
    Setter method for classifier, mapped from YANG variable /qos/classifiers/classifier (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_classifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_classifier() directly.

    YANG Description: List of classifier elements
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_classifier_openconfig_qos__qos_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """classifier must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_classifier_openconfig_qos__qos_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)""",
        })

    self.__classifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_classifier(self):
    self.__classifier = YANGDynClass(base=YANGListType("name",yc_classifier_openconfig_qos__qos_classifiers_classifier, yang_name="classifier", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="classifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='list', is_config=True)

  classifier = __builtin__.property(_get_classifier, _set_classifier)


  _pyangbind_elements = OrderedDict([('classifier', classifier), ])


class yc_config_openconfig_qos__qos_forwarding_groups_forwarding_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-qos - based on the path /qos/forwarding-groups/forwarding-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for forwarding groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__fabric_priority','__output_queue','__unicast_output_queue','__multicast_output_queue',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    self.__fabric_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="fabric-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    self.__output_queue = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__unicast_output_queue = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    self.__multicast_output_queue = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="multicast-output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['qos', 'forwarding-groups', 'forwarding-group', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/name (string)

    YANG Description: Name of the forwarding group
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the forwarding group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='string', is_config=True)


  def _get_fabric_priority(self):
    """
    Getter method for fabric_priority, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/fabric_priority (uint8)

    YANG Description: Set the priority for the forwarding group for
local transmission through the device, e.g.,
across a switching fabric. Higher priorities
are considered to be better, such that traffic
with fabric priority 128 is considered to be
higher priority than that with fabric priority
0.
    """
    return self.__fabric_priority
      
  def _set_fabric_priority(self, v, load=False):
    """
    Setter method for fabric_priority, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/fabric_priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fabric_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fabric_priority() directly.

    YANG Description: Set the priority for the forwarding group for
local transmission through the device, e.g.,
across a switching fabric. Higher priorities
are considered to be better, such that traffic
with fabric priority 128 is considered to be
higher priority than that with fabric priority
0.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="fabric-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fabric_priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="fabric-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)""",
        })

    self.__fabric_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fabric_priority(self):
    self.__fabric_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="fabric-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='uint8', is_config=True)


  def _get_output_queue(self):
    """
    Getter method for output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/output_queue (leafref)

    YANG Description: Output queue for packets in this forwarding group.
This leaf applies to both multicast and unicast
packets. Where a user or system requires separate
queueing for multicast and unicast the unicast-output-queue
and multicast-output-queue leaves should be specified.
    """
    return self.__output_queue
      
  def _set_output_queue(self, v, load=False):
    """
    Setter method for output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/output_queue (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_queue() directly.

    YANG Description: Output queue for packets in this forwarding group.
This leaf applies to both multicast and unicast
packets. Where a user or system requires separate
queueing for multicast and unicast the unicast-output-queue
and multicast-output-queue leaves should be specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_queue must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__output_queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_queue(self):
    self.__output_queue = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_unicast_output_queue(self):
    """
    Getter method for unicast_output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/unicast_output_queue (leafref)

    YANG Description: Output queue for unicast packets within this
forwarding group. Where an operator or system does
not require separate queueing for multicast and
unicast this leaf is not specified.
    """
    return self.__unicast_output_queue
      
  def _set_unicast_output_queue(self, v, load=False):
    """
    Setter method for unicast_output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/unicast_output_queue (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unicast_output_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unicast_output_queue() directly.

    YANG Description: Output queue for unicast packets within this
forwarding group. Where an operator or system does
not require separate queueing for multicast and
unicast this leaf is not specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="unicast-output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unicast_output_queue must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)""",
        })

    self.__unicast_output_queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unicast_output_queue(self):
    self.__unicast_output_queue = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="unicast-output-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/qos', defining_module='openconfig-qos', yang_type='leafref', is_config=True)


  def _get_multicast_output_queue(self):
    """
    Getter method for multicast_output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/multicast_output_queue (leafref)

    YANG Description: Output queue for multicast packets within this
forwarding group. Where an operator or system does
not require separate queueing for multicast and
unicast this leaf is not specified.
    """
    return self.__multicast_output_queue
      
  def _set_multicast_output_queue(self, v, load=False):
    """
    Setter method for multicast_output_queue, mapped from YANG variable /qos/forwarding_groups/forwarding_group/config/multicast_output_queue (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_output_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_output_queue() directly.

    YANG Description: Output queue for multicast packets within this
forwarding group. Where an op