//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2019-03-01/examples/metricBaselines.json
func ExampleBaselinesClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewBaselinesClient(cred, nil)
	res, err := client.List(ctx,
		"<resource-uri>",
		&armmonitor.BaselinesClientListOptions{Metricnames: nil,
			Metricnamespace: nil,
			Timespan:        to.StringPtr("<timespan>"),
			Interval:        to.StringPtr("<interval>"),
			Aggregation:     to.StringPtr("<aggregation>"),
			Sensitivities:   to.StringPtr("<sensitivities>"),
			Filter:          nil,
			ResultType:      nil,
		})
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.BaselinesClientListResult)
}
