// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateKmsKey struct {
}

func (*validateOpAssociateKmsKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateKmsKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateKmsKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateKmsKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelExportTask struct {
}

func (*validateOpCancelExportTask) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelExportTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelExportTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelExportTaskInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateExportTask struct {
}

func (*validateOpCreateExportTask) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateExportTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateExportTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateExportTaskInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLogGroup struct {
}

func (*validateOpCreateLogGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLogGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLogGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLogGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLogStream struct {
}

func (*validateOpCreateLogStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLogStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLogStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLogStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataProtectionPolicy struct {
}

func (*validateOpDeleteDataProtectionPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataProtectionPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataProtectionPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataProtectionPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDestination struct {
}

func (*validateOpDeleteDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLogGroup struct {
}

func (*validateOpDeleteLogGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLogGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLogGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLogGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLogStream struct {
}

func (*validateOpDeleteLogStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLogStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLogStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLogStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteMetricFilter struct {
}

func (*validateOpDeleteMetricFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteMetricFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteMetricFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteMetricFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteQueryDefinition struct {
}

func (*validateOpDeleteQueryDefinition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteQueryDefinition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteQueryDefinitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteQueryDefinitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRetentionPolicy struct {
}

func (*validateOpDeleteRetentionPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRetentionPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRetentionPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRetentionPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSubscriptionFilter struct {
}

func (*validateOpDeleteSubscriptionFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSubscriptionFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSubscriptionFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSubscriptionFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeSubscriptionFilters struct {
}

func (*validateOpDescribeSubscriptionFilters) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeSubscriptionFilters) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeSubscriptionFiltersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeSubscriptionFiltersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateKmsKey struct {
}

func (*validateOpDisassociateKmsKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateKmsKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateKmsKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateKmsKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataProtectionPolicy struct {
}

func (*validateOpGetDataProtectionPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataProtectionPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataProtectionPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataProtectionPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLogEvents struct {
}

func (*validateOpGetLogEvents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLogEvents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLogEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLogEventsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLogRecord struct {
}

func (*validateOpGetLogRecord) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLogRecord) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLogRecordInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLogRecordInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetQueryResults struct {
}

func (*validateOpGetQueryResults) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetQueryResults) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetQueryResultsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetQueryResultsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsLogGroup struct {
}

func (*validateOpListTagsLogGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsLogGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsLogGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsLogGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutDataProtectionPolicy struct {
}

func (*validateOpPutDataProtectionPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutDataProtectionPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutDataProtectionPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutDataProtectionPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutDestination struct {
}

func (*validateOpPutDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutDestinationPolicy struct {
}

func (*validateOpPutDestinationPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutDestinationPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutDestinationPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutDestinationPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutLogEvents struct {
}

func (*validateOpPutLogEvents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutLogEvents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutLogEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutLogEventsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutMetricFilter struct {
}

func (*validateOpPutMetricFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutMetricFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutMetricFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutMetricFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutQueryDefinition struct {
}

func (*validateOpPutQueryDefinition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutQueryDefinition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutQueryDefinitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutQueryDefinitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutRetentionPolicy struct {
}

func (*validateOpPutRetentionPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutRetentionPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutRetentionPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutRetentionPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutSubscriptionFilter struct {
}

func (*validateOpPutSubscriptionFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutSubscriptionFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutSubscriptionFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutSubscriptionFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartQuery struct {
}

func (*validateOpStartQuery) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartQuery) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartQueryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartQueryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopQuery struct {
}

func (*validateOpStopQuery) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopQuery) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopQueryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopQueryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagLogGroup struct {
}

func (*validateOpTagLogGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagLogGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagLogGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagLogGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTestMetricFilter struct {
}

func (*validateOpTestMetricFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTestMetricFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TestMetricFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTestMetricFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagLogGroup struct {
}

func (*validateOpUntagLogGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagLogGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagLogGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagLogGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateKmsKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateKmsKey{}, middleware.After)
}

func addOpCancelExportTaskValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelExportTask{}, middleware.After)
}

func addOpCreateExportTaskValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateExportTask{}, middleware.After)
}

func addOpCreateLogGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLogGroup{}, middleware.After)
}

func addOpCreateLogStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLogStream{}, middleware.After)
}

func addOpDeleteDataProtectionPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataProtectionPolicy{}, middleware.After)
}

func addOpDeleteDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDestination{}, middleware.After)
}

func addOpDeleteLogGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLogGroup{}, middleware.After)
}

func addOpDeleteLogStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLogStream{}, middleware.After)
}

func addOpDeleteMetricFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteMetricFilter{}, middleware.After)
}

func addOpDeleteQueryDefinitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteQueryDefinition{}, middleware.After)
}

func addOpDeleteRetentionPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRetentionPolicy{}, middleware.After)
}

func addOpDeleteSubscriptionFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSubscriptionFilter{}, middleware.After)
}

func addOpDescribeSubscriptionFiltersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeSubscriptionFilters{}, middleware.After)
}

func addOpDisassociateKmsKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateKmsKey{}, middleware.After)
}

func addOpGetDataProtectionPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataProtectionPolicy{}, middleware.After)
}

func addOpGetLogEventsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLogEvents{}, middleware.After)
}

func addOpGetLogRecordValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLogRecord{}, middleware.After)
}

func addOpGetQueryResultsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetQueryResults{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListTagsLogGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsLogGroup{}, middleware.After)
}

func addOpPutDataProtectionPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutDataProtectionPolicy{}, middleware.After)
}

func addOpPutDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutDestination{}, middleware.After)
}

func addOpPutDestinationPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutDestinationPolicy{}, middleware.After)
}

func addOpPutLogEventsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutLogEvents{}, middleware.After)
}

func addOpPutMetricFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutMetricFilter{}, middleware.After)
}

func addOpPutQueryDefinitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutQueryDefinition{}, middleware.After)
}

func addOpPutRetentionPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutRetentionPolicy{}, middleware.After)
}

func addOpPutSubscriptionFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutSubscriptionFilter{}, middleware.After)
}

func addOpStartQueryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartQuery{}, middleware.After)
}

func addOpStopQueryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopQuery{}, middleware.After)
}

func addOpTagLogGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagLogGroup{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpTestMetricFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTestMetricFilter{}, middleware.After)
}

func addOpUntagLogGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagLogGroup{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateInputLogEvent(v *types.InputLogEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputLogEvent"}
	if v.Timestamp == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Timestamp"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputLogEvents(v []types.InputLogEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputLogEvents"}
	for i := range v {
		if err := validateInputLogEvent(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricTransformation(v *types.MetricTransformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricTransformation"}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.MetricNamespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricNamespace"))
	}
	if v.MetricValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricTransformations(v []types.MetricTransformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricTransformations"}
	for i := range v {
		if err := validateMetricTransformation(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateKmsKeyInput(v *AssociateKmsKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateKmsKeyInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.KmsKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelExportTaskInput(v *CancelExportTaskInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelExportTaskInput"}
	if v.TaskId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaskId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateExportTaskInput(v *CreateExportTaskInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateExportTaskInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.From == nil {
		invalidParams.Add(smithy.NewErrParamRequired("From"))
	}
	if v.To == nil {
		invalidParams.Add(smithy.NewErrParamRequired("To"))
	}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLogGroupInput(v *CreateLogGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLogGroupInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLogStreamInput(v *CreateLogStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLogStreamInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.LogStreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogStreamName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataProtectionPolicyInput(v *DeleteDataProtectionPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataProtectionPolicyInput"}
	if v.LogGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDestinationInput(v *DeleteDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDestinationInput"}
	if v.DestinationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLogGroupInput(v *DeleteLogGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLogGroupInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLogStreamInput(v *DeleteLogStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLogStreamInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.LogStreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogStreamName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteMetricFilterInput(v *DeleteMetricFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteMetricFilterInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.FilterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteQueryDefinitionInput(v *DeleteQueryDefinitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteQueryDefinitionInput"}
	if v.QueryDefinitionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryDefinitionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRetentionPolicyInput(v *DeleteRetentionPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRetentionPolicyInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSubscriptionFilterInput(v *DeleteSubscriptionFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSubscriptionFilterInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.FilterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeSubscriptionFiltersInput(v *DescribeSubscriptionFiltersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeSubscriptionFiltersInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateKmsKeyInput(v *DisassociateKmsKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateKmsKeyInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataProtectionPolicyInput(v *GetDataProtectionPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataProtectionPolicyInput"}
	if v.LogGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLogEventsInput(v *GetLogEventsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLogEventsInput"}
	if v.LogStreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogStreamName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLogRecordInput(v *GetLogRecordInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLogRecordInput"}
	if v.LogRecordPointer == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogRecordPointer"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetQueryResultsInput(v *GetQueryResultsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetQueryResultsInput"}
	if v.QueryId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsLogGroupInput(v *ListTagsLogGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsLogGroupInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutDataProtectionPolicyInput(v *PutDataProtectionPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutDataProtectionPolicyInput"}
	if v.LogGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupIdentifier"))
	}
	if v.PolicyDocument == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyDocument"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutDestinationInput(v *PutDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutDestinationInput"}
	if v.DestinationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationName"))
	}
	if v.TargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetArn"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutDestinationPolicyInput(v *PutDestinationPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutDestinationPolicyInput"}
	if v.DestinationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationName"))
	}
	if v.AccessPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessPolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutLogEventsInput(v *PutLogEventsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutLogEventsInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.LogStreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogStreamName"))
	}
	if v.LogEvents == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogEvents"))
	} else if v.LogEvents != nil {
		if err := validateInputLogEvents(v.LogEvents); err != nil {
			invalidParams.AddNested("LogEvents", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutMetricFilterInput(v *PutMetricFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutMetricFilterInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.FilterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterName"))
	}
	if v.FilterPattern == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterPattern"))
	}
	if v.MetricTransformations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricTransformations"))
	} else if v.MetricTransformations != nil {
		if err := validateMetricTransformations(v.MetricTransformations); err != nil {
			invalidParams.AddNested("MetricTransformations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutQueryDefinitionInput(v *PutQueryDefinitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutQueryDefinitionInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.QueryString == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryString"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutRetentionPolicyInput(v *PutRetentionPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutRetentionPolicyInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.RetentionInDays == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetentionInDays"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutSubscriptionFilterInput(v *PutSubscriptionFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutSubscriptionFilterInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.FilterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterName"))
	}
	if v.FilterPattern == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterPattern"))
	}
	if v.DestinationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartQueryInput(v *StartQueryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartQueryInput"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.QueryString == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryString"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopQueryInput(v *StopQueryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopQueryInput"}
	if v.QueryId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagLogGroupInput(v *TagLogGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagLogGroupInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTestMetricFilterInput(v *TestMetricFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TestMetricFilterInput"}
	if v.FilterPattern == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterPattern"))
	}
	if v.LogEventMessages == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogEventMessages"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagLogGroupInput(v *UntagLogGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagLogGroupInput"}
	if v.LogGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogGroupName"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
