package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLPatternAttribute invokes the adb.DescribeSQLPatternAttribute API synchronously
func (client *Client) DescribeSQLPatternAttribute(request *DescribeSQLPatternAttributeRequest) (response *DescribeSQLPatternAttributeResponse, err error) {
	response = CreateDescribeSQLPatternAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLPatternAttributeWithChan invokes the adb.DescribeSQLPatternAttribute API asynchronously
func (client *Client) DescribeSQLPatternAttributeWithChan(request *DescribeSQLPatternAttributeRequest) (<-chan *DescribeSQLPatternAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLPatternAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLPatternAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLPatternAttributeWithCallback invokes the adb.DescribeSQLPatternAttribute API asynchronously
func (client *Client) DescribeSQLPatternAttributeWithCallback(request *DescribeSQLPatternAttributeRequest, callback func(response *DescribeSQLPatternAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLPatternAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLPatternAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLPatternAttributeRequest is the request struct for api DescribeSQLPatternAttribute
type DescribeSQLPatternAttributeRequest struct {
	*requests.RpcRequest
	DBClusterId string           `position:"Query" name:"DBClusterId"`
	PatternId   requests.Integer `position:"Query" name:"PatternId"`
	EndTime     string           `position:"Query" name:"EndTime"`
	StartTime   string           `position:"Query" name:"StartTime"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeSQLPatternAttributeResponse is the response struct for api DescribeSQLPatternAttribute
type DescribeSQLPatternAttributeResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	PatternDetail PatternDetail `json:"PatternDetail" xml:"PatternDetail"`
}

// CreateDescribeSQLPatternAttributeRequest creates a request to invoke DescribeSQLPatternAttribute API
func CreateDescribeSQLPatternAttributeRequest() (request *DescribeSQLPatternAttributeRequest) {
	request = &DescribeSQLPatternAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeSQLPatternAttribute", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLPatternAttributeResponse creates a response to parse from DescribeSQLPatternAttribute response
func CreateDescribeSQLPatternAttributeResponse() (response *DescribeSQLPatternAttributeResponse) {
	response = &DescribeSQLPatternAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
