package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImage invokes the aiworkspace.GetImage API synchronously
func (client *Client) GetImage(request *GetImageRequest) (response *GetImageResponse, err error) {
	response = CreateGetImageResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageWithChan invokes the aiworkspace.GetImage API asynchronously
func (client *Client) GetImageWithChan(request *GetImageRequest) (<-chan *GetImageResponse, <-chan error) {
	responseChan := make(chan *GetImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageWithCallback invokes the aiworkspace.GetImage API asynchronously
func (client *Client) GetImageWithCallback(request *GetImageRequest, callback func(response *GetImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageResponse
		var err error
		defer close(result)
		response, err = client.GetImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageRequest is the request struct for api GetImage
type GetImageRequest struct {
	*requests.RoaRequest
	ImageId string `position:"Path" name:"ImageId"`
	Verbose string `position:"Query" name:"Verbose"`
}

// GetImageResponse is the response struct for api GetImage
type GetImageResponse struct {
	*responses.BaseResponse
	RequestId       string       `json:"RequestId" xml:"RequestId"`
	GmtCreateTime   string       `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string       `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	Name            string       `json:"Name" xml:"Name"`
	Description     string       `json:"Description" xml:"Description"`
	ImageUri        string       `json:"ImageUri" xml:"ImageUri"`
	UserId          string       `json:"UserId" xml:"UserId"`
	ParentUserId    string       `json:"ParentUserId" xml:"ParentUserId"`
	WorkspaceId     string       `json:"WorkspaceId" xml:"WorkspaceId"`
	Accessibility   string       `json:"Accessibility" xml:"Accessibility"`
	Labels          []LabelsItem `json:"Labels" xml:"Labels"`
}

// CreateGetImageRequest creates a request to invoke GetImage API
func CreateGetImageRequest() (request *GetImageRequest) {
	request = &GetImageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "GetImage", "/api/v1/images/[ImageId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetImageResponse creates a response to parse from GetImage response
func CreateGetImageResponse() (response *GetImageResponse) {
	response = &GetImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
