package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDpChGeneralStanford invokes the alinlp.GetDpChGeneralStanford API synchronously
func (client *Client) GetDpChGeneralStanford(request *GetDpChGeneralStanfordRequest) (response *GetDpChGeneralStanfordResponse, err error) {
	response = CreateGetDpChGeneralStanfordResponse()
	err = client.DoAction(request, response)
	return
}

// GetDpChGeneralStanfordWithChan invokes the alinlp.GetDpChGeneralStanford API asynchronously
func (client *Client) GetDpChGeneralStanfordWithChan(request *GetDpChGeneralStanfordRequest) (<-chan *GetDpChGeneralStanfordResponse, <-chan error) {
	responseChan := make(chan *GetDpChGeneralStanfordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDpChGeneralStanford(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDpChGeneralStanfordWithCallback invokes the alinlp.GetDpChGeneralStanford API asynchronously
func (client *Client) GetDpChGeneralStanfordWithCallback(request *GetDpChGeneralStanfordRequest, callback func(response *GetDpChGeneralStanfordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDpChGeneralStanfordResponse
		var err error
		defer close(result)
		response, err = client.GetDpChGeneralStanford(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDpChGeneralStanfordRequest is the request struct for api GetDpChGeneralStanford
type GetDpChGeneralStanfordRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetDpChGeneralStanfordResponse is the response struct for api GetDpChGeneralStanford
type GetDpChGeneralStanfordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetDpChGeneralStanfordRequest creates a request to invoke GetDpChGeneralStanford API
func CreateGetDpChGeneralStanfordRequest() (request *GetDpChGeneralStanfordRequest) {
	request = &GetDpChGeneralStanfordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetDpChGeneralStanford", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDpChGeneralStanfordResponse creates a response to parse from GetDpChGeneralStanford response
func CreateGetDpChGeneralStanfordResponse() (response *GetDpChGeneralStanfordResponse) {
	response = &GetDpChGeneralStanfordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
