package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPriceChEcom invokes the alinlp.GetPriceChEcom API synchronously
func (client *Client) GetPriceChEcom(request *GetPriceChEcomRequest) (response *GetPriceChEcomResponse, err error) {
	response = CreateGetPriceChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetPriceChEcomWithChan invokes the alinlp.GetPriceChEcom API asynchronously
func (client *Client) GetPriceChEcomWithChan(request *GetPriceChEcomRequest) (<-chan *GetPriceChEcomResponse, <-chan error) {
	responseChan := make(chan *GetPriceChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPriceChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPriceChEcomWithCallback invokes the alinlp.GetPriceChEcom API asynchronously
func (client *Client) GetPriceChEcomWithCallback(request *GetPriceChEcomRequest, callback func(response *GetPriceChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPriceChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetPriceChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPriceChEcomRequest is the request struct for api GetPriceChEcom
type GetPriceChEcomRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetPriceChEcomResponse is the response struct for api GetPriceChEcom
type GetPriceChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetPriceChEcomRequest creates a request to invoke GetPriceChEcom API
func CreateGetPriceChEcomRequest() (request *GetPriceChEcomRequest) {
	request = &GetPriceChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetPriceChEcom", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPriceChEcomResponse creates a response to parse from GetPriceChEcom response
func CreateGetPriceChEcomResponse() (response *GetPriceChEcomResponse) {
	response = &GetPriceChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
