package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWeChComment invokes the alinlp.GetWeChComment API synchronously
func (client *Client) GetWeChComment(request *GetWeChCommentRequest) (response *GetWeChCommentResponse, err error) {
	response = CreateGetWeChCommentResponse()
	err = client.DoAction(request, response)
	return
}

// GetWeChCommentWithChan invokes the alinlp.GetWeChComment API asynchronously
func (client *Client) GetWeChCommentWithChan(request *GetWeChCommentRequest) (<-chan *GetWeChCommentResponse, <-chan error) {
	responseChan := make(chan *GetWeChCommentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWeChComment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWeChCommentWithCallback invokes the alinlp.GetWeChComment API asynchronously
func (client *Client) GetWeChCommentWithCallback(request *GetWeChCommentRequest, callback func(response *GetWeChCommentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWeChCommentResponse
		var err error
		defer close(result)
		response, err = client.GetWeChComment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWeChCommentRequest is the request struct for api GetWeChComment
type GetWeChCommentRequest struct {
	*requests.RpcRequest
	Type        string `position:"Body" name:"Type"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Size        string `position:"Body" name:"Size"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	Operation   string `position:"Body" name:"Operation"`
}

// GetWeChCommentResponse is the response struct for api GetWeChComment
type GetWeChCommentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWeChCommentRequest creates a request to invoke GetWeChComment API
func CreateGetWeChCommentRequest() (request *GetWeChCommentRequest) {
	request = &GetWeChCommentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWeChComment", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWeChCommentResponse creates a response to parse from GetWeChComment response
func CreateGetWeChCommentResponse() (response *GetWeChCommentResponse) {
	response = &GetWeChCommentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
