package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWeChEcom invokes the alinlp.GetWeChEcom API synchronously
func (client *Client) GetWeChEcom(request *GetWeChEcomRequest) (response *GetWeChEcomResponse, err error) {
	response = CreateGetWeChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetWeChEcomWithChan invokes the alinlp.GetWeChEcom API asynchronously
func (client *Client) GetWeChEcomWithChan(request *GetWeChEcomRequest) (<-chan *GetWeChEcomResponse, <-chan error) {
	responseChan := make(chan *GetWeChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWeChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWeChEcomWithCallback invokes the alinlp.GetWeChEcom API asynchronously
func (client *Client) GetWeChEcomWithCallback(request *GetWeChEcomRequest, callback func(response *GetWeChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWeChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetWeChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWeChEcomRequest is the request struct for api GetWeChEcom
type GetWeChEcomRequest struct {
	*requests.RpcRequest
	Type        string `position:"Body" name:"Type"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Size        string `position:"Body" name:"Size"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	Operation   string `position:"Body" name:"Operation"`
}

// GetWeChEcomResponse is the response struct for api GetWeChEcom
type GetWeChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWeChEcomRequest creates a request to invoke GetWeChEcom API
func CreateGetWeChEcomRequest() (request *GetWeChEcomRequest) {
	request = &GetWeChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWeChEcom", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWeChEcomResponse creates a response to parse from GetWeChEcom response
func CreateGetWeChEcomResponse() (response *GetWeChEcomResponse) {
	response = &GetWeChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
