package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPrometheusGlobalView invokes the arms.AddPrometheusGlobalView API synchronously
func (client *Client) AddPrometheusGlobalView(request *AddPrometheusGlobalViewRequest) (response *AddPrometheusGlobalViewResponse, err error) {
	response = CreateAddPrometheusGlobalViewResponse()
	err = client.DoAction(request, response)
	return
}

// AddPrometheusGlobalViewWithChan invokes the arms.AddPrometheusGlobalView API asynchronously
func (client *Client) AddPrometheusGlobalViewWithChan(request *AddPrometheusGlobalViewRequest) (<-chan *AddPrometheusGlobalViewResponse, <-chan error) {
	responseChan := make(chan *AddPrometheusGlobalViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPrometheusGlobalView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPrometheusGlobalViewWithCallback invokes the arms.AddPrometheusGlobalView API asynchronously
func (client *Client) AddPrometheusGlobalViewWithCallback(request *AddPrometheusGlobalViewRequest, callback func(response *AddPrometheusGlobalViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPrometheusGlobalViewResponse
		var err error
		defer close(result)
		response, err = client.AddPrometheusGlobalView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPrometheusGlobalViewRequest is the request struct for api AddPrometheusGlobalView
type AddPrometheusGlobalViewRequest struct {
	*requests.RpcRequest
	GroupName string `position:"Query" name:"GroupName"`
	Clusters  string `position:"Query" name:"Clusters"`
}

// AddPrometheusGlobalViewResponse is the response struct for api AddPrometheusGlobalView
type AddPrometheusGlobalViewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddPrometheusGlobalViewRequest creates a request to invoke AddPrometheusGlobalView API
func CreateAddPrometheusGlobalViewRequest() (request *AddPrometheusGlobalViewRequest) {
	request = &AddPrometheusGlobalViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddPrometheusGlobalView", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPrometheusGlobalViewResponse creates a response to parse from AddPrometheusGlobalView response
func CreateAddPrometheusGlobalViewResponse() (response *AddPrometheusGlobalViewResponse) {
	response = &AddPrometheusGlobalViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
