package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCertificateState invokes the cas.DescribeCertificateState API synchronously
func (client *Client) DescribeCertificateState(request *DescribeCertificateStateRequest) (response *DescribeCertificateStateResponse, err error) {
	response = CreateDescribeCertificateStateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCertificateStateWithChan invokes the cas.DescribeCertificateState API asynchronously
func (client *Client) DescribeCertificateStateWithChan(request *DescribeCertificateStateRequest) (<-chan *DescribeCertificateStateResponse, <-chan error) {
	responseChan := make(chan *DescribeCertificateStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCertificateState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCertificateStateWithCallback invokes the cas.DescribeCertificateState API asynchronously
func (client *Client) DescribeCertificateStateWithCallback(request *DescribeCertificateStateRequest, callback func(response *DescribeCertificateStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCertificateStateResponse
		var err error
		defer close(result)
		response, err = client.DescribeCertificateState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCertificateStateRequest is the request struct for api DescribeCertificateState
type DescribeCertificateStateRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	OrderId  requests.Integer `position:"Query" name:"OrderId"`
}

// DescribeCertificateStateResponse is the response struct for api DescribeCertificateState
type DescribeCertificateStateResponse struct {
	*responses.BaseResponse
	Type         string `json:"Type" xml:"Type"`
	Domain       string `json:"Domain" xml:"Domain"`
	RecordType   string `json:"RecordType" xml:"RecordType"`
	Certificate  string `json:"Certificate" xml:"Certificate"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	RecordDomain string `json:"RecordDomain" xml:"RecordDomain"`
	PrivateKey   string `json:"PrivateKey" xml:"PrivateKey"`
	ValidateType string `json:"ValidateType" xml:"ValidateType"`
	RecordValue  string `json:"RecordValue" xml:"RecordValue"`
	Content      string `json:"Content" xml:"Content"`
	Uri          string `json:"Uri" xml:"Uri"`
}

// CreateDescribeCertificateStateRequest creates a request to invoke DescribeCertificateState API
func CreateDescribeCertificateStateRequest() (request *DescribeCertificateStateRequest) {
	request = &DescribeCertificateStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "DescribeCertificateState", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCertificateStateResponse creates a response to parse from DescribeCertificateState response
func CreateDescribeCertificateStateResponse() (response *DescribeCertificateStateResponse) {
	response = &DescribeCertificateStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
