package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableTransitRouterRouteTablePropagation invokes the cbn.EnableTransitRouterRouteTablePropagation API synchronously
func (client *Client) EnableTransitRouterRouteTablePropagation(request *EnableTransitRouterRouteTablePropagationRequest) (response *EnableTransitRouterRouteTablePropagationResponse, err error) {
	response = CreateEnableTransitRouterRouteTablePropagationResponse()
	err = client.DoAction(request, response)
	return
}

// EnableTransitRouterRouteTablePropagationWithChan invokes the cbn.EnableTransitRouterRouteTablePropagation API asynchronously
func (client *Client) EnableTransitRouterRouteTablePropagationWithChan(request *EnableTransitRouterRouteTablePropagationRequest) (<-chan *EnableTransitRouterRouteTablePropagationResponse, <-chan error) {
	responseChan := make(chan *EnableTransitRouterRouteTablePropagationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableTransitRouterRouteTablePropagation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableTransitRouterRouteTablePropagationWithCallback invokes the cbn.EnableTransitRouterRouteTablePropagation API asynchronously
func (client *Client) EnableTransitRouterRouteTablePropagationWithCallback(request *EnableTransitRouterRouteTablePropagationRequest, callback func(response *EnableTransitRouterRouteTablePropagationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableTransitRouterRouteTablePropagationResponse
		var err error
		defer close(result)
		response, err = client.EnableTransitRouterRouteTablePropagation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableTransitRouterRouteTablePropagationRequest is the request struct for api EnableTransitRouterRouteTablePropagation
type EnableTransitRouterRouteTablePropagationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteTableId string           `position:"Query" name:"TransitRouterRouteTableId"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	Version                   string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId string           `position:"Query" name:"TransitRouterAttachmentId"`
}

// EnableTransitRouterRouteTablePropagationResponse is the response struct for api EnableTransitRouterRouteTablePropagation
type EnableTransitRouterRouteTablePropagationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableTransitRouterRouteTablePropagationRequest creates a request to invoke EnableTransitRouterRouteTablePropagation API
func CreateEnableTransitRouterRouteTablePropagationRequest() (request *EnableTransitRouterRouteTablePropagationRequest) {
	request = &EnableTransitRouterRouteTablePropagationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "EnableTransitRouterRouteTablePropagation", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableTransitRouterRouteTablePropagationResponse creates a response to parse from EnableTransitRouterRouteTablePropagation response
func CreateEnableTransitRouterRouteTablePropagationResponse() (response *EnableTransitRouterRouteTablePropagationResponse) {
	response = &EnableTransitRouterRouteTablePropagationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
