package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterRouteTableAssociations invokes the cbn.ListTransitRouterRouteTableAssociations API synchronously
func (client *Client) ListTransitRouterRouteTableAssociations(request *ListTransitRouterRouteTableAssociationsRequest) (response *ListTransitRouterRouteTableAssociationsResponse, err error) {
	response = CreateListTransitRouterRouteTableAssociationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterRouteTableAssociationsWithChan invokes the cbn.ListTransitRouterRouteTableAssociations API asynchronously
func (client *Client) ListTransitRouterRouteTableAssociationsWithChan(request *ListTransitRouterRouteTableAssociationsRequest) (<-chan *ListTransitRouterRouteTableAssociationsResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterRouteTableAssociationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterRouteTableAssociations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterRouteTableAssociationsWithCallback invokes the cbn.ListTransitRouterRouteTableAssociations API asynchronously
func (client *Client) ListTransitRouterRouteTableAssociationsWithCallback(request *ListTransitRouterRouteTableAssociationsRequest, callback func(response *ListTransitRouterRouteTableAssociationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterRouteTableAssociationsResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterRouteTableAssociations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterRouteTableAssociationsRequest is the request struct for api ListTransitRouterRouteTableAssociations
type ListTransitRouterRouteTableAssociationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                     requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TransitRouterRouteTableId           string           `position:"Query" name:"TransitRouterRouteTableId"`
	NextToken                           string           `position:"Query" name:"NextToken"`
	TransitRouterAttachmentResourceId   string           `position:"Query" name:"TransitRouterAttachmentResourceId"`
	TransitRouterAttachmentResourceType string           `position:"Query" name:"TransitRouterAttachmentResourceType"`
	ResourceOwnerAccount                string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                        string           `position:"Query" name:"OwnerAccount"`
	OwnerId                             requests.Integer `position:"Query" name:"OwnerId"`
	Version                             string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId           string           `position:"Query" name:"TransitRouterAttachmentId"`
	MaxResults                          requests.Integer `position:"Query" name:"MaxResults"`
	TransitRouterAttachmentIds          *[]string        `position:"Query" name:"TransitRouterAttachmentIds"  type:"Repeated"`
	Status                              string           `position:"Query" name:"Status"`
}

// ListTransitRouterRouteTableAssociationsResponse is the response struct for api ListTransitRouterRouteTableAssociations
type ListTransitRouterRouteTableAssociationsResponse struct {
	*responses.BaseResponse
	NextToken                 string                     `json:"NextToken" xml:"NextToken"`
	RequestId                 string                     `json:"RequestId" xml:"RequestId"`
	TotalCount                int                        `json:"TotalCount" xml:"TotalCount"`
	MaxResults                int                        `json:"MaxResults" xml:"MaxResults"`
	TransitRouterAssociations []TransitRouterAssociation `json:"TransitRouterAssociations" xml:"TransitRouterAssociations"`
}

// CreateListTransitRouterRouteTableAssociationsRequest creates a request to invoke ListTransitRouterRouteTableAssociations API
func CreateListTransitRouterRouteTableAssociationsRequest() (request *ListTransitRouterRouteTableAssociationsRequest) {
	request = &ListTransitRouterRouteTableAssociationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterRouteTableAssociations", "", "")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterRouteTableAssociationsResponse creates a response to parse from ListTransitRouterRouteTableAssociations response
func CreateListTransitRouterRouteTableAssociationsResponse() (response *ListTransitRouterRouteTableAssociationsResponse) {
	response = &ListTransitRouterRouteTableAssociationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
