package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenTransitRouterService invokes the cbn.OpenTransitRouterService API synchronously
func (client *Client) OpenTransitRouterService(request *OpenTransitRouterServiceRequest) (response *OpenTransitRouterServiceResponse, err error) {
	response = CreateOpenTransitRouterServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenTransitRouterServiceWithChan invokes the cbn.OpenTransitRouterService API asynchronously
func (client *Client) OpenTransitRouterServiceWithChan(request *OpenTransitRouterServiceRequest) (<-chan *OpenTransitRouterServiceResponse, <-chan error) {
	responseChan := make(chan *OpenTransitRouterServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenTransitRouterService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenTransitRouterServiceWithCallback invokes the cbn.OpenTransitRouterService API asynchronously
func (client *Client) OpenTransitRouterServiceWithCallback(request *OpenTransitRouterServiceRequest, callback func(response *OpenTransitRouterServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenTransitRouterServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenTransitRouterService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenTransitRouterServiceRequest is the request struct for api OpenTransitRouterService
type OpenTransitRouterServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
}

// OpenTransitRouterServiceResponse is the response struct for api OpenTransitRouterService
type OpenTransitRouterServiceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenTransitRouterServiceRequest creates a request to invoke OpenTransitRouterService API
func CreateOpenTransitRouterServiceRequest() (request *OpenTransitRouterServiceRequest) {
	request = &OpenTransitRouterServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "OpenTransitRouterService", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenTransitRouterServiceResponse creates a response to parse from OpenTransitRouterService response
func CreateOpenTransitRouterServiceResponse() (response *OpenTransitRouterServiceResponse) {
	response = &OpenTransitRouterServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
