package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCardUsages invokes the cc5g.ListCardUsages API synchronously
func (client *Client) ListCardUsages(request *ListCardUsagesRequest) (response *ListCardUsagesResponse, err error) {
	response = CreateListCardUsagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCardUsagesWithChan invokes the cc5g.ListCardUsages API asynchronously
func (client *Client) ListCardUsagesWithChan(request *ListCardUsagesRequest) (<-chan *ListCardUsagesResponse, <-chan error) {
	responseChan := make(chan *ListCardUsagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCardUsages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCardUsagesWithCallback invokes the cc5g.ListCardUsages API asynchronously
func (client *Client) ListCardUsagesWithCallback(request *ListCardUsagesRequest, callback func(response *ListCardUsagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCardUsagesResponse
		var err error
		defer close(result)
		response, err = client.ListCardUsages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCardUsagesRequest is the request struct for api ListCardUsages
type ListCardUsagesRequest struct {
	*requests.RpcRequest
	Iccids                   *[]string `position:"Query" name:"Iccids"  type:"Repeated"`
	WirelessCloudConnectorId string    `position:"Query" name:"WirelessCloudConnectorId"`
}

// ListCardUsagesResponse is the response struct for api ListCardUsages
type ListCardUsagesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount string `json:"TotalCount" xml:"TotalCount"`
	Cards      []Card `json:"Cards" xml:"Cards"`
}

// CreateListCardUsagesRequest creates a request to invoke ListCardUsages API
func CreateListCardUsagesRequest() (request *ListCardUsagesRequest) {
	request = &ListCardUsagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListCardUsages", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListCardUsagesResponse creates a response to parse from ListCardUsages response
func CreateListCardUsagesResponse() (response *ListCardUsagesResponse) {
	response = &ListCardUsagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
