package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCallTag invokes the ccc.DeleteCallTag API synchronously
func (client *Client) DeleteCallTag(request *DeleteCallTagRequest) (response *DeleteCallTagResponse, err error) {
	response = CreateDeleteCallTagResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCallTagWithChan invokes the ccc.DeleteCallTag API asynchronously
func (client *Client) DeleteCallTagWithChan(request *DeleteCallTagRequest) (<-chan *DeleteCallTagResponse, <-chan error) {
	responseChan := make(chan *DeleteCallTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCallTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCallTagWithCallback invokes the ccc.DeleteCallTag API asynchronously
func (client *Client) DeleteCallTagWithCallback(request *DeleteCallTagRequest, callback func(response *DeleteCallTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCallTagResponse
		var err error
		defer close(result)
		response, err = client.DeleteCallTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCallTagRequest is the request struct for api DeleteCallTag
type DeleteCallTagRequest struct {
	*requests.RpcRequest
	TagName    string `position:"Query" name:"TagName"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteCallTagResponse is the response struct for api DeleteCallTag
type DeleteCallTagResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateDeleteCallTagRequest creates a request to invoke DeleteCallTag API
func CreateDeleteCallTagRequest() (request *DeleteCallTagRequest) {
	request = &DeleteCallTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "DeleteCallTag", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCallTagResponse creates a response to parse from DeleteCallTag response
func CreateDeleteCallTagResponse() (response *DeleteCallTagResponse) {
	response = &DeleteCallTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
