package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMediaEx invokes the cloudcallcenter.CreateMediaEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmediaex.html
func (client *Client) CreateMediaEx(request *CreateMediaExRequest) (response *CreateMediaExResponse, err error) {
	response = CreateCreateMediaExResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMediaExWithChan invokes the cloudcallcenter.CreateMediaEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmediaex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMediaExWithChan(request *CreateMediaExRequest) (<-chan *CreateMediaExResponse, <-chan error) {
	responseChan := make(chan *CreateMediaExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMediaEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMediaExWithCallback invokes the cloudcallcenter.CreateMediaEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createmediaex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMediaExWithCallback(request *CreateMediaExRequest, callback func(response *CreateMediaExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMediaExResponse
		var err error
		defer close(result)
		response, err = client.CreateMediaEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMediaExRequest is the request struct for api CreateMediaEx
type CreateMediaExRequest struct {
	*requests.RpcRequest
	Description  string `position:"Query" name:"Description"`
	OssFilePath  string `position:"Query" name:"OssFilePath"`
	UploadResult string `position:"Query" name:"UploadResult"`
	Type         string `position:"Query" name:"Type"`
	Content      string `position:"Query" name:"Content"`
	OssFileName  string `position:"Query" name:"OssFileName"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	FileName     string `position:"Query" name:"FileName"`
	Name         string `position:"Query" name:"Name"`
}

// CreateMediaExResponse is the response struct for api CreateMediaEx
type CreateMediaExResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Success          bool             `json:"Success" xml:"Success"`
	Code             string           `json:"Code" xml:"Code"`
	Message          string           `json:"Message" xml:"Message"`
	HttpStatusCode   int              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	MediaUploadParam MediaUploadParam `json:"MediaUploadParam" xml:"MediaUploadParam"`
}

// CreateCreateMediaExRequest creates a request to invoke CreateMediaEx API
func CreateCreateMediaExRequest() (request *CreateMediaExRequest) {
	request = &CreateMediaExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateMediaEx", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMediaExResponse creates a response to parse from CreateMediaEx response
func CreateCreateMediaExResponse() (response *CreateMediaExResponse) {
	response = &CreateMediaExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
