package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveVnCategory invokes the cloudcallcenter.MoveVnCategory API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/movevncategory.html
func (client *Client) MoveVnCategory(request *MoveVnCategoryRequest) (response *MoveVnCategoryResponse, err error) {
	response = CreateMoveVnCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// MoveVnCategoryWithChan invokes the cloudcallcenter.MoveVnCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/movevncategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoveVnCategoryWithChan(request *MoveVnCategoryRequest) (<-chan *MoveVnCategoryResponse, <-chan error) {
	responseChan := make(chan *MoveVnCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveVnCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveVnCategoryWithCallback invokes the cloudcallcenter.MoveVnCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/movevncategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoveVnCategoryWithCallback(request *MoveVnCategoryRequest, callback func(response *MoveVnCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveVnCategoryResponse
		var err error
		defer close(result)
		response, err = client.MoveVnCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveVnCategoryRequest is the request struct for api MoveVnCategory
type MoveVnCategoryRequest struct {
	*requests.RpcRequest
	InstanceId              string `position:"Query" name:"InstanceId"`
	TargetPreviousSiblingId string `position:"Query" name:"TargetPreviousSiblingId"`
	TargetParentId          string `position:"Query" name:"TargetParentId"`
	CategoryId              string `position:"Query" name:"CategoryId"`
}

// MoveVnCategoryResponse is the response struct for api MoveVnCategory
type MoveVnCategoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMoveVnCategoryRequest creates a request to invoke MoveVnCategory API
func CreateMoveVnCategoryRequest() (request *MoveVnCategoryRequest) {
	request = &MoveVnCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "MoveVnCategory", "", "")
	request.Method = requests.GET
	return
}

// CreateMoveVnCategoryResponse creates a response to parse from MoveVnCategory response
func CreateMoveVnCategoryResponse() (response *MoveVnCategoryResponse) {
	response = &MoveVnCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
