package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRepoWebhook invokes the cr.UpdateRepoWebhook API synchronously
func (client *Client) UpdateRepoWebhook(request *UpdateRepoWebhookRequest) (response *UpdateRepoWebhookResponse, err error) {
	response = CreateUpdateRepoWebhookResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRepoWebhookWithChan invokes the cr.UpdateRepoWebhook API asynchronously
func (client *Client) UpdateRepoWebhookWithChan(request *UpdateRepoWebhookRequest) (<-chan *UpdateRepoWebhookResponse, <-chan error) {
	responseChan := make(chan *UpdateRepoWebhookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRepoWebhook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRepoWebhookWithCallback invokes the cr.UpdateRepoWebhook API asynchronously
func (client *Client) UpdateRepoWebhookWithCallback(request *UpdateRepoWebhookRequest, callback func(response *UpdateRepoWebhookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRepoWebhookResponse
		var err error
		defer close(result)
		response, err = client.UpdateRepoWebhook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRepoWebhookRequest is the request struct for api UpdateRepoWebhook
type UpdateRepoWebhookRequest struct {
	*requests.RoaRequest
	WebhookId     requests.Integer `position:"Path" name:"WebhookId"`
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
}

// UpdateRepoWebhookResponse is the response struct for api UpdateRepoWebhook
type UpdateRepoWebhookResponse struct {
	*responses.BaseResponse
}

// CreateUpdateRepoWebhookRequest creates a request to invoke UpdateRepoWebhook API
func CreateUpdateRepoWebhookRequest() (request *UpdateRepoWebhookRequest) {
	request = &UpdateRepoWebhookRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "UpdateRepoWebhook", "/repos/[RepoNamespace]/[RepoName]/webhooks/[WebhookId]", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRepoWebhookResponse creates a response to parse from UpdateRepoWebhook response
func CreateUpdateRepoWebhookResponse() (response *UpdateRepoWebhookResponse) {
	response = &UpdateRepoWebhookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
