package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UmountDirectory invokes the dataworks_public.UmountDirectory API synchronously
func (client *Client) UmountDirectory(request *UmountDirectoryRequest) (response *UmountDirectoryResponse, err error) {
	response = CreateUmountDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// UmountDirectoryWithChan invokes the dataworks_public.UmountDirectory API asynchronously
func (client *Client) UmountDirectoryWithChan(request *UmountDirectoryRequest) (<-chan *UmountDirectoryResponse, <-chan error) {
	responseChan := make(chan *UmountDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UmountDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UmountDirectoryWithCallback invokes the dataworks_public.UmountDirectory API asynchronously
func (client *Client) UmountDirectoryWithCallback(request *UmountDirectoryRequest, callback func(response *UmountDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UmountDirectoryResponse
		var err error
		defer close(result)
		response, err = client.UmountDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UmountDirectoryRequest is the request struct for api UmountDirectory
type UmountDirectoryRequest struct {
	*requests.RpcRequest
	TargetType string `position:"Body" name:"TargetType"`
	TargetId   string `position:"Body" name:"TargetId"`
}

// UmountDirectoryResponse is the response struct for api UmountDirectory
type UmountDirectoryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int    `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateUmountDirectoryRequest creates a request to invoke UmountDirectory API
func CreateUmountDirectoryRequest() (request *UmountDirectoryRequest) {
	request = &UmountDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UmountDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateUmountDirectoryResponse creates a response to parse from UmountDirectory response
func CreateUmountDirectoryResponse() (response *UmountDirectoryResponse) {
	response = &UmountDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
