package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceLinkedRole invokes the dbfs.GetServiceLinkedRole API synchronously
func (client *Client) GetServiceLinkedRole(request *GetServiceLinkedRoleRequest) (response *GetServiceLinkedRoleResponse, err error) {
	response = CreateGetServiceLinkedRoleResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceLinkedRoleWithChan invokes the dbfs.GetServiceLinkedRole API asynchronously
func (client *Client) GetServiceLinkedRoleWithChan(request *GetServiceLinkedRoleRequest) (<-chan *GetServiceLinkedRoleResponse, <-chan error) {
	responseChan := make(chan *GetServiceLinkedRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceLinkedRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceLinkedRoleWithCallback invokes the dbfs.GetServiceLinkedRole API asynchronously
func (client *Client) GetServiceLinkedRoleWithCallback(request *GetServiceLinkedRoleRequest, callback func(response *GetServiceLinkedRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceLinkedRoleResponse
		var err error
		defer close(result)
		response, err = client.GetServiceLinkedRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceLinkedRoleRequest is the request struct for api GetServiceLinkedRole
type GetServiceLinkedRoleRequest struct {
	*requests.RpcRequest
}

// GetServiceLinkedRoleResponse is the response struct for api GetServiceLinkedRole
type GetServiceLinkedRoleResponse struct {
	*responses.BaseResponse
	AccountId      string `json:"AccountId" xml:"AccountId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DbfsLinkedRole bool   `json:"DbfsLinkedRole" xml:"DbfsLinkedRole"`
	RegionId       string `json:"RegionId" xml:"RegionId"`
}

// CreateGetServiceLinkedRoleRequest creates a request to invoke GetServiceLinkedRole API
func CreateGetServiceLinkedRoleRequest() (request *GetServiceLinkedRoleRequest) {
	request = &GetServiceLinkedRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "GetServiceLinkedRole", "", "")
	request.Method = requests.POST
	return
}

// CreateGetServiceLinkedRoleResponse creates a response to parse from GetServiceLinkedRole response
func CreateGetServiceLinkedRoleResponse() (response *GetServiceLinkedRoleResponse) {
	response = &GetServiceLinkedRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
